# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.ucb
# Libre Office Version: 7.2
from ooo.oenv.env_const import UNO_NONE
from ..beans.property_value import PropertyValue as PropertyValue_c9610c73
from ..beans.property_state import PropertyState as PropertyState_c97b0c77
import typing
from .property_value_state import PropertyValueState as PropertyValueState_f1050da5


class PropertyValueInfo(PropertyValue_c9610c73):
    """
    Struct Class

    contains value and state of a com.sun.star.beans.Property.

    See Also:
        `API PropertyValueInfo <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1ucb_1_1PropertyValueInfo.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.ucb'
    __ooo_full_ns__: str = 'com.sun.star.ucb.PropertyValueInfo'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.ucb.PropertyValueInfo'
    """Literal Constant ``com.sun.star.ucb.PropertyValueInfo``"""

    def __init__(self, Name: typing.Optional[str] = '', Handle: typing.Optional[int] = 0, Value: typing.Optional[object] = None, State: typing.Optional[PropertyState_c97b0c77] = PropertyState_c97b0c77.DIRECT_VALUE, ValueState: typing.Optional[PropertyValueState_f1050da5] = PropertyValueState_f1050da5.UNPROCESSED) -> None:
        """
        Constructor

        Arguments:
            Name (str, optional): Name value.
            Handle (int, optional): Handle value.
            Value (object, optional): Value value.
            State (PropertyState, optional): State value.
            ValueState (PropertyValueState, optional): ValueState value.
        """

        if isinstance(Name, PropertyValueInfo):
            oth: PropertyValueInfo = Name
            self.Name = oth.Name
            self.Handle = oth.Handle
            self.Value = oth.Value
            self.State = oth.State
            self.ValueState = oth.ValueState
            return

        kargs = {
            "Name": Name,
            "Handle": Handle,
            "Value": Value,
            "State": State,
            "ValueState": ValueState,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._value_state = kwargs["ValueState"]
        inst_keys = ('ValueState',)
        kargs = kwargs.copy()
        for key in inst_keys:
            del kargs[key]
        super()._init(**kargs)


    @property
    def ValueState(self) -> PropertyValueState_f1050da5:
        """
        the state of the property value.
        """
        return self._value_state
    
    @ValueState.setter
    def ValueState(self, value: PropertyValueState_f1050da5) -> None:
        self._value_state = value


__all__ = ['PropertyValueInfo']
