# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.ui.dialogs


class TemplateDescription(object):
    """
    Const Class

    The implementation of a FilePicker service may support the usage of different templates.
    
    The following constants define the currently specified templates.
    
    **since**
    
        LibreOffice 5.3

    See Also:
        `API TemplateDescription <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1ui_1_1dialogs_1_1TemplateDescription.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.ui.dialogs'
    __ooo_full_ns__: str = 'com.sun.star.ui.dialogs.TemplateDescription'
    __ooo_type_name__: str = 'const'

    FILEOPEN_SIMPLE = 0
    """
    A FileOpen dialog without any additional controls.
    """
    FILESAVE_SIMPLE = 1
    """
    A FileSave dialog without any additional controls.
    """
    FILESAVE_AUTOEXTENSION_PASSWORD = 2
    """
    A FileSave dialog with additional controls.
    """
    FILESAVE_AUTOEXTENSION_PASSWORD_FILTEROPTIONS = 3
    """
    A FileSave dialog with additional controls.
    """
    FILESAVE_AUTOEXTENSION_SELECTION = 4
    """
    A FileSave dialog with additional controls.
    """
    FILESAVE_AUTOEXTENSION_TEMPLATE = 5
    """
    A FileSave dialog with additional controls.
    """
    FILEOPEN_LINK_PREVIEW_IMAGE_TEMPLATE = 6
    """
    A FileOpen dialog with additional controls.
    """
    FILEOPEN_PLAY = 7
    """
    A FileOpen dialog with additional controls.
    """
    FILEOPEN_READONLY_VERSION = 8
    """
    A FileOpen dialog with additional controls.
    """
    FILEOPEN_LINK_PREVIEW = 9
    """
    A FileOpen dialog with additional controls.
    """
    FILESAVE_AUTOEXTENSION = 10
    """
    A FileSave dialog with additional controls.
    """
    FILEOPEN_PREVIEW = 11
    """
    A FileOpen dialog with additional controls.
    
    **since**
    
        LibreOffice 5.3
    """
    FILEOPEN_LINK_PLAY = 12
    """
    A FileOpen dialog with additional controls.
    
    **since**
    
        LibreOffice 5.3
    """
    FILEOPEN_LINK_PREVIEW_IMAGE_ANCHOR = 13
    """
    A FileOpen dialog with additional controls.
    
    **since**
    
        LibreOffice 6.1
    """

__all__ = ['TemplateDescription']
