# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.util


class MeasureUnit(object):
    """
    Const Class

    These constants are used to specify a measure.
    
    A component using these constants may not support all units.

    See Also:
        `API MeasureUnit <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1util_1_1MeasureUnit.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.util'
    __ooo_full_ns__: str = 'com.sun.star.util.MeasureUnit'
    __ooo_type_name__: str = 'const'

    MM_100TH = 0
    """
    all measures for this component are in 100th millimeter
    """
    MM_10TH = 1
    """
    all measures for this component are in 10th millimeter
    """
    MM = 2
    """
    all measures for this component are in millimeter
    """
    CM = 3
    """
    all measures for this component are in centimeters
    """
    INCH_1000TH = 4
    """
    all measures for this component are in 1000th inch
    """
    INCH_100TH = 5
    """
    all measures for this component are in 100th inch
    """
    INCH_10TH = 6
    """
    all measures for this component are in 10th inch
    """
    INCH = 7
    """
    all measures for this component are in inch
    """
    POINT = 8
    """
    all measures for this component are in points
    """
    TWIP = 9
    """
    all measures for this component are in twips
    """
    M = 10
    """
    all measures for this component are in meters
    """
    KM = 11
    """
    all measures for this component are in kilometers
    """
    PICA = 12
    """
    all measures for this component are in pica
    """
    FOOT = 13
    """
    all measures for this component are in foot
    """
    MILE = 14
    """
    all measures for this component are in miles
    """
    PERCENT = 15
    """
    all measures for this component are in percentage
    """
    PIXEL = 16
    """
    all measures for this component are in pixel
    """
    APPFONT = 17
    """
    all measures for this component are in APPFONT
    """
    SYSFONT = 18
    """
    all measures for this component are in SYSFONT
    """

__all__ = ['MeasureUnit']
