# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.xml.xpath
# Libre Office Version: 7.2
from ooo.oenv.env_const import UNO_NONE
import typing


class Libxml2ExtensionHandle(object):
    """
    Struct Class


    See Also:
        `API Libxml2ExtensionHandle <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1xml_1_1xpath_1_1Libxml2ExtensionHandle.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.xml.xpath'
    __ooo_full_ns__: str = 'com.sun.star.xml.xpath.Libxml2ExtensionHandle'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.xml.xpath.Libxml2ExtensionHandle'
    """Literal Constant ``com.sun.star.xml.xpath.Libxml2ExtensionHandle``"""

    def __init__(self, functionLookupFunction: typing.Optional[int] = 0, functionData: typing.Optional[int] = 0, variableLookupFunction: typing.Optional[int] = 0, variableData: typing.Optional[int] = 0) -> None:
        """
        Constructor

        Arguments:
            functionLookupFunction (int, optional): functionLookupFunction value.
            functionData (int, optional): functionData value.
            variableLookupFunction (int, optional): variableLookupFunction value.
            variableData (int, optional): variableData value.
        """
        super().__init__()

        if isinstance(functionLookupFunction, Libxml2ExtensionHandle):
            oth: Libxml2ExtensionHandle = functionLookupFunction
            self.functionLookupFunction = oth.functionLookupFunction
            self.functionData = oth.functionData
            self.variableLookupFunction = oth.variableLookupFunction
            self.variableData = oth.variableData
            return

        kargs = {
            "functionLookupFunction": functionLookupFunction,
            "functionData": functionData,
            "variableLookupFunction": variableLookupFunction,
            "variableData": variableData,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._function_lookup_function = kwargs["functionLookupFunction"]
        self._function_data = kwargs["functionData"]
        self._variable_lookup_function = kwargs["variableLookupFunction"]
        self._variable_data = kwargs["variableData"]


    @property
    def functionLookupFunction(self) -> int:
        return self._function_lookup_function
    
    @functionLookupFunction.setter
    def functionLookupFunction(self, value: int) -> None:
        self._function_lookup_function = value

    @property
    def functionData(self) -> int:
        return self._function_data
    
    @functionData.setter
    def functionData(self, value: int) -> None:
        self._function_data = value

    @property
    def variableLookupFunction(self) -> int:
        return self._variable_lookup_function
    
    @variableLookupFunction.setter
    def variableLookupFunction(self, value: int) -> None:
        self._variable_lookup_function = value

    @property
    def variableData(self) -> int:
        return self._variable_data
    
    @variableData.setter
    def variableData(self, value: int) -> None:
        self._variable_data = value


__all__ = ['Libxml2ExtensionHandle']
