

class Flow(object):
    """Generated from OpenAPI schema object #/components/schemas/Flow

    A high level data plane traffic flow  
    Acts as a container for endpoints, frame size, frame rate, duration and packet headers  

    Args
    ----
    - name (str): Unique name of an object that is the primary key for objects found in arrays
    - tx_rx (TxRx): A container for different types of transmit and receive endpoint containers
    - packet (list[Header]): The packet is a list of traffic protocol headers
     The order of traffic protocol headers assigned to the list is the order they will appear on the wire
    - size (Size): The frame size which overrides the total length of the packet
    - rate (Rate): The rate of packet transmission
    - duration (Duration): A container for different transmit durations
    """
    def __init__(self, name=None, tx_rx=None, packet=[], size=None, rate=None, duration=None):
        from abstract_open_traffic_generator.flow import TxRx
        from abstract_open_traffic_generator.flow import Size
        from abstract_open_traffic_generator.flow import Rate
        from abstract_open_traffic_generator.flow import Duration
        if isinstance(name, (str)) is True:
            import re
            assert(bool(re.match(r'^[\sa-zA-Z0-9-_()><\[\]]+$', name)) is True)
            self.name = name
        else:
            raise TypeError('name must be an instance of (str)')
        if isinstance(tx_rx, (TxRx)) is True:
            self.tx_rx = tx_rx
        else:
            raise TypeError('tx_rx must be an instance of (TxRx)')
        if isinstance(packet, (list, type(None))) is True:
            self.packet = [] if packet is None else list(packet)
        else:
            raise TypeError('packet must be an instance of (list, type(None))')
        if isinstance(size, (Size, type(None))) is True:
            self.size = size
        else:
            raise TypeError('size must be an instance of (Size, type(None))')
        if isinstance(rate, (Rate, type(None))) is True:
            self.rate = rate
        else:
            raise TypeError('rate must be an instance of (Rate, type(None))')
        if isinstance(duration, (Duration, type(None))) is True:
            self.duration = duration
        else:
            raise TypeError('duration must be an instance of (Duration, type(None))')


class TxRx(object):
    """Generated from OpenAPI schema object #/components/schemas/Flow.TxRx

    A container for different types of transmit and receive endpoint containers  

    Args
    ----
    - choice (Union[PortTxRx, DeviceTxRx]): The type of transmit and receive container used by the flow
    """
    _CHOICE_MAP = {
        'PortTxRx': 'port',
        'DeviceTxRx': 'device',
    }
    def __init__(self, choice=None):
        from abstract_open_traffic_generator.flow import PortTxRx
        from abstract_open_traffic_generator.flow import DeviceTxRx
        if isinstance(choice, (PortTxRx, DeviceTxRx)) is False:
            raise TypeError('choice must be of type: PortTxRx, DeviceTxRx')
        self.__setattr__('choice', TxRx._CHOICE_MAP[type(choice).__name__])
        self.__setattr__(TxRx._CHOICE_MAP[type(choice).__name__], choice)


class PortTxRx(object):
    """Generated from OpenAPI schema object #/components/schemas/Flow.PortTxRx

    A container for a transmit port and 0..n intended receive ports  
    When assigning this container to a flow the flows's packet headers will not be populated with any address resolution information such as source and/or destination addresses  
    For example Flow.Ethernet dst mac address values will be defaulted to 0  
    For full control over the Flow.properties.packet header contents use this container  

    Args
    ----
    - tx_port_name (str): The unique name of a port that is the transmit port
    - rx_port_names (list[str]): The unique names of ports that are the intended receive ports
    """
    def __init__(self, tx_port_name=None, rx_port_names=[]):
        if isinstance(tx_port_name, (str)) is True:
            self.tx_port_name = tx_port_name
        else:
            raise TypeError('tx_port_name must be an instance of (str)')
        if isinstance(rx_port_names, (list, type(None))) is True:
            self.rx_port_names = [] if rx_port_names is None else list(rx_port_names)
        else:
            raise TypeError('rx_port_names must be an instance of (list, type(None))')


class DeviceTxRx(object):
    """Generated from OpenAPI schema object #/components/schemas/Flow.DeviceTxRx

    A container for 1..n transmit devices and 1..n receive devices  
    Implemementations may use learned information from the devices to pre-populate Flow.properties.packet[Flow.Header fields]  
    For example an implementation may automatically start devices, get arp table information and pre-populate the Flow.Ethernet dst mac address values  
    To discover what the implementation supports use the /results/capabilities API  

    Args
    ----
    - tx_device_names (list[str]): The unique names of devices that will be transmitting
    - rx_device_names (list[str]): The unique names of emulated devices that will be receiving
    """
    def __init__(self, tx_device_names=[], rx_device_names=[]):
        if isinstance(tx_device_names, (list)) is True:
            self.tx_device_names = tx_device_names
        else:
            raise TypeError('tx_device_names must be an instance of (list)')
        if isinstance(rx_device_names, (list)) is True:
            self.rx_device_names = rx_device_names
        else:
            raise TypeError('rx_device_names must be an instance of (list)')


class Header(object):
    """Generated from OpenAPI schema object #/components/schemas/Flow.Header

    Container for all traffic packet headers  

    Args
    ----
    - choice (Union[Custom, Ethernet, Vlan, Ipv4, PfcPause, EthernetPause, Tcp, Udp]): TBD
    """
    _CHOICE_MAP = {
        'Custom': 'custom',
        'Ethernet': 'ethernet',
        'Vlan': 'vlan',
        'Ipv4': 'ipv4',
        'PfcPause': 'pfcpause',
        'EthernetPause': 'ethernetpause',
        'Tcp': 'tcp',
        'Udp': 'udp',
    }
    def __init__(self, choice=None):
        from abstract_open_traffic_generator.flow import Custom
        from abstract_open_traffic_generator.flow import Ethernet
        from abstract_open_traffic_generator.flow import Vlan
        from abstract_open_traffic_generator.flow import Ipv4
        from abstract_open_traffic_generator.flow import PfcPause
        from abstract_open_traffic_generator.flow import EthernetPause
        from abstract_open_traffic_generator.flow import Tcp
        from abstract_open_traffic_generator.flow import Udp
        if isinstance(choice, (Custom, Ethernet, Vlan, Ipv4, PfcPause, EthernetPause, Tcp, Udp)) is False:
            raise TypeError('choice must be of type: Custom, Ethernet, Vlan, Ipv4, PfcPause, EthernetPause, Tcp, Udp')
        self.__setattr__('choice', Header._CHOICE_MAP[type(choice).__name__])
        self.__setattr__(Header._CHOICE_MAP[type(choice).__name__], choice)


class Custom(object):
    """Generated from OpenAPI schema object #/components/schemas/Flow.Custom

    Custom packet header  

    Args
    ----
    - bytes (str): A custom packet header defined as a string of hex bytes
     The string MUST contain valid hex characters
     Spaces or colons can be part of the bytes but will be discarded This can be used to create a custom protocol from other inputs such as scapy, wireshark, pcap etc
     An example of ethernet/ipv4: '00000000000200000000000108004500001400010000400066e70a0000010a000002'
    - patterns (list[BitPattern]): Modify the bytes with bit based patterns
    """
    def __init__(self, bytes=None, patterns=[]):
        if isinstance(bytes, (str)) is True:
            import re
            assert(bool(re.match(r'^[A-Fa-f0-9: ]+$', bytes)) is True)
            self.bytes = bytes
        else:
            raise TypeError('bytes must be an instance of (str)')
        if isinstance(patterns, (list, type(None))) is True:
            self.patterns = [] if patterns is None else list(patterns)
        else:
            raise TypeError('patterns must be an instance of (list, type(None))')


class BitPattern(object):
    """Generated from OpenAPI schema object #/components/schemas/Flow.BitPattern

    Container for a bit pattern  

    Args
    ----
    - choice (Union[BitList, BitCounter]): TBD
    """
    _CHOICE_MAP = {
        'BitList': 'bitlist',
        'BitCounter': 'bitcounter',
    }
    def __init__(self, choice=None):
        from abstract_open_traffic_generator.flow import BitList
        from abstract_open_traffic_generator.flow import BitCounter
        if isinstance(choice, (BitList, BitCounter)) is False:
            raise TypeError('choice must be of type: BitList, BitCounter')
        self.__setattr__('choice', BitPattern._CHOICE_MAP[type(choice).__name__])
        self.__setattr__(BitPattern._CHOICE_MAP[type(choice).__name__], choice)


class BitList(object):
    """Generated from OpenAPI schema object #/components/schemas/Flow.BitList

    A pattern which is a list of values  

    Args
    ----
    - offset (int): Bit offset in the packet at which the pattern will be applied
    - length (int): The number of bits in the packet that the pattern will span
    - count (int): The number of values to generate before repeating
    - values (list[str]): TBD
    """
    def __init__(self, offset=1, length=1, count=1, values=[]):
        if isinstance(offset, (float, int, type(None))) is True:
            self.offset = offset
        else:
            raise TypeError('offset must be an instance of (float, int, type(None))')
        if isinstance(length, (float, int, type(None))) is True:
            self.length = length
        else:
            raise TypeError('length must be an instance of (float, int, type(None))')
        if isinstance(count, (float, int, type(None))) is True:
            self.count = count
        else:
            raise TypeError('count must be an instance of (float, int, type(None))')
        if isinstance(values, (list, type(None))) is True:
            self.values = [] if values is None else list(values)
        else:
            raise TypeError('values must be an instance of (list, type(None))')


class BitCounter(object):
    """Generated from OpenAPI schema object #/components/schemas/Flow.BitCounter

    An incrementing pattern  

    Args
    ----
    - offset (int): Bit offset in the packet at which the pattern will be applied
    - length (int): The number of bits in the packet that the pattern will span
    - count (int): The number of values to generate before repeating A value of 0 means the pattern will count continuously
    - start (str): The starting value of the pattern
     If the value is greater than the length it will be truncated
    - step (str): The amount the start value will be incremented by If the value is greater than the length it will be truncated
    """
    def __init__(self, offset=0, length=32, count=1, start='0', step='0'):
        if isinstance(offset, (float, int, type(None))) is True:
            self.offset = offset
        else:
            raise TypeError('offset must be an instance of (float, int, type(None))')
        if isinstance(length, (float, int, type(None))) is True:
            self.length = length
        else:
            raise TypeError('length must be an instance of (float, int, type(None))')
        if isinstance(count, (float, int, type(None))) is True:
            self.count = count
        else:
            raise TypeError('count must be an instance of (float, int, type(None))')
        if isinstance(start, (str, type(None))) is True:
            import re
            assert(bool(re.match(r'^[A-Fa-f0-9: ]+$', start)) is True)
            self.start = start
        else:
            raise TypeError('start must be an instance of (str, type(None))')
        if isinstance(step, (str, type(None))) is True:
            import re
            assert(bool(re.match(r'^[A-Fa-f0-9: ]+$', step)) is True)
            self.step = step
        else:
            raise TypeError('step must be an instance of (str, type(None))')


class Ethernet(object):
    """Generated from OpenAPI schema object #/components/schemas/Flow.Ethernet

    Ethernet packet header  

    Args
    ----
    - dst (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
    - src (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
    - ether_type (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
    """
    def __init__(self, dst=None, src=None, ether_type=None):
        from abstract_open_traffic_generator.flow import Pattern
        if isinstance(dst, (Pattern, type(None))) is True:
            self.dst = dst
        else:
            raise TypeError('dst must be an instance of (Pattern, type(None))')
        if isinstance(src, (Pattern, type(None))) is True:
            self.src = src
        else:
            raise TypeError('src must be an instance of (Pattern, type(None))')
        if isinstance(ether_type, (Pattern, type(None))) is True:
            self.ether_type = ether_type
        else:
            raise TypeError('ether_type must be an instance of (Pattern, type(None))')


class Pattern(object):
    """Generated from OpenAPI schema object #/components/schemas/Flow.Pattern

    A container for packet header field patterns  
    Possible patterns are fixed, list, counter, random  

    Args
    ----
    - choice (Union[str, list, Counter, Random]): TBD
    - ingress_result_name (str): A unique name is used to indicate to the system that the field may extend the result row key and create an aggregate result row for every unique ingress value
     To have ingress columns appear in flow result rows the flow result request allows for the ingress_result_name value to be specified as part of the request
    """
    _CHOICE_MAP = {
        'str': 'fixed',
        'list': 'list',
        'Counter': 'counter',
        'Random': 'random',
    }
    def __init__(self, choice=None, ingress_result_name=None):
        from abstract_open_traffic_generator.flow import Counter
        from abstract_open_traffic_generator.flow import Random
        if isinstance(choice, (str, list, Counter, Random)) is False:
            raise TypeError('choice must be of type: str, list, Counter, Random')
        self.__setattr__('choice', Pattern._CHOICE_MAP[type(choice).__name__])
        self.__setattr__(Pattern._CHOICE_MAP[type(choice).__name__], choice)
        if isinstance(ingress_result_name, (str, type(None))) is True:
            self.ingress_result_name = ingress_result_name
        else:
            raise TypeError('ingress_result_name must be an instance of (str, type(None))')


class Counter(object):
    """Generated from OpenAPI schema object #/components/schemas/Flow.Counter

    A counter pattern that can increment or decrement  

    Args
    ----
    - start (str): The value at which the pattern will start
    - step (str): The value at which the pattern will increment or decrement by
    - count (Union[float, int]): The number of values in the pattern
    - up (Union[True, False]): Determines whether the pattern will increment (true) or decrement (false)
    """
    def __init__(self, start=None, step=None, count=None, up=True):
        if isinstance(start, (str, type(None))) is True:
            self.start = start
        else:
            raise TypeError('start must be an instance of (str, type(None))')
        if isinstance(step, (str, type(None))) is True:
            self.step = step
        else:
            raise TypeError('step must be an instance of (str, type(None))')
        if isinstance(count, (float, int, type(None))) is True:
            self.count = count
        else:
            raise TypeError('count must be an instance of (float, int, type(None))')
        if isinstance(up, (bool, type(None))) is True:
            self.up = up
        else:
            raise TypeError('up must be an instance of (bool, type(None))')


class Random(object):
    """Generated from OpenAPI schema object #/components/schemas/Flow.Random

    A repeatable random range pattern  

    Args
    ----
    - min (str): TBD
    - max (str): TBD
    - step (Union[float, int]): TBD
    - seed (str): TBD
    - count (Union[float, int]): TBD
    """
    def __init__(self, min=None, max=None, step=None, seed=None, count=None):
        if isinstance(min, (str, type(None))) is True:
            self.min = min
        else:
            raise TypeError('min must be an instance of (str, type(None))')
        if isinstance(max, (str, type(None))) is True:
            self.max = max
        else:
            raise TypeError('max must be an instance of (str, type(None))')
        if isinstance(step, (float, int, type(None))) is True:
            self.step = step
        else:
            raise TypeError('step must be an instance of (float, int, type(None))')
        if isinstance(seed, (str, type(None))) is True:
            self.seed = seed
        else:
            raise TypeError('seed must be an instance of (str, type(None))')
        if isinstance(count, (float, int, type(None))) is True:
            self.count = count
        else:
            raise TypeError('count must be an instance of (float, int, type(None))')


class Vlan(object):
    """Generated from OpenAPI schema object #/components/schemas/Flow.Vlan

    Vlan packet header  

    Args
    ----
    - priority (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
    - cfi (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
    - id (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
    - protocol (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
    """
    def __init__(self, priority=None, cfi=None, id=None, protocol=None):
        from abstract_open_traffic_generator.flow import Pattern
        if isinstance(priority, (Pattern, type(None))) is True:
            self.priority = priority
        else:
            raise TypeError('priority must be an instance of (Pattern, type(None))')
        if isinstance(cfi, (Pattern, type(None))) is True:
            self.cfi = cfi
        else:
            raise TypeError('cfi must be an instance of (Pattern, type(None))')
        if isinstance(id, (Pattern, type(None))) is True:
            self.id = id
        else:
            raise TypeError('id must be an instance of (Pattern, type(None))')
        if isinstance(protocol, (Pattern, type(None))) is True:
            self.protocol = protocol
        else:
            raise TypeError('protocol must be an instance of (Pattern, type(None))')


class Ipv4(object):
    """Generated from OpenAPI schema object #/components/schemas/Flow.Ipv4

    Ipv4 packet header  

    Args
    ----
    - priority (Priority): A container for ipv4 raw, tos, dscp ip priorities
    - src (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
    - dst (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
    """
    def __init__(self, priority=None, src=None, dst=None):
        from abstract_open_traffic_generator.flow_ipv4 import Priority
        from abstract_open_traffic_generator.flow import Pattern
        if isinstance(priority, (Priority, type(None))) is True:
            self.priority = priority
        else:
            raise TypeError('priority must be an instance of (Priority, type(None))')
        if isinstance(src, (Pattern, type(None))) is True:
            self.src = src
        else:
            raise TypeError('src must be an instance of (Pattern, type(None))')
        if isinstance(dst, (Pattern, type(None))) is True:
            self.dst = dst
        else:
            raise TypeError('dst must be an instance of (Pattern, type(None))')


class PfcPause(object):
    """Generated from OpenAPI schema object #/components/schemas/Flow.PfcPause

    IEEE 802.1Qbb PFC Pause packet header  
    - dst: 01:80:C2:00:00:01 48bits - src: 48bits - ether_type: 0x8808 16bits - control_op_code: 0x0101 16bits - class_enable_vector: 16bits - pause_class_0: 0x0000 16bits - pause_class_1: 0x0000 16bits - pause_class_2: 0x0000 16bits - pause_class_3: 0x0000 16bits - pause_class_4: 0x0000 16bits - pause_class_5: 0x0000 16bits - pause_class_6: 0x0000 16bits - pause_class_7: 0x0000 16bits  

    Args
    ----
    - dst (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
    - src (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
    - ether_type (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
    - control_op_code (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
    - class_enable_vector (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
    - pause_class_0 (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
    - pause_class_1 (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
    - pause_class_2 (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
    - pause_class_3 (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
    - pause_class_4 (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
    - pause_class_5 (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
    - pause_class_6 (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
    - pause_class_7 (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
    """
    def __init__(self, dst=None, src=None, ether_type=None, control_op_code=None, class_enable_vector=None, pause_class_0=None, pause_class_1=None, pause_class_2=None, pause_class_3=None, pause_class_4=None, pause_class_5=None, pause_class_6=None, pause_class_7=None):
        from abstract_open_traffic_generator.flow import Pattern
        if isinstance(dst, (Pattern, type(None))) is True:
            self.dst = dst
        else:
            raise TypeError('dst must be an instance of (Pattern, type(None))')
        if isinstance(src, (Pattern, type(None))) is True:
            self.src = src
        else:
            raise TypeError('src must be an instance of (Pattern, type(None))')
        if isinstance(ether_type, (Pattern, type(None))) is True:
            self.ether_type = ether_type
        else:
            raise TypeError('ether_type must be an instance of (Pattern, type(None))')
        if isinstance(control_op_code, (Pattern, type(None))) is True:
            self.control_op_code = control_op_code
        else:
            raise TypeError('control_op_code must be an instance of (Pattern, type(None))')
        if isinstance(class_enable_vector, (Pattern, type(None))) is True:
            self.class_enable_vector = class_enable_vector
        else:
            raise TypeError('class_enable_vector must be an instance of (Pattern, type(None))')
        if isinstance(pause_class_0, (Pattern, type(None))) is True:
            self.pause_class_0 = pause_class_0
        else:
            raise TypeError('pause_class_0 must be an instance of (Pattern, type(None))')
        if isinstance(pause_class_1, (Pattern, type(None))) is True:
            self.pause_class_1 = pause_class_1
        else:
            raise TypeError('pause_class_1 must be an instance of (Pattern, type(None))')
        if isinstance(pause_class_2, (Pattern, type(None))) is True:
            self.pause_class_2 = pause_class_2
        else:
            raise TypeError('pause_class_2 must be an instance of (Pattern, type(None))')
        if isinstance(pause_class_3, (Pattern, type(None))) is True:
            self.pause_class_3 = pause_class_3
        else:
            raise TypeError('pause_class_3 must be an instance of (Pattern, type(None))')
        if isinstance(pause_class_4, (Pattern, type(None))) is True:
            self.pause_class_4 = pause_class_4
        else:
            raise TypeError('pause_class_4 must be an instance of (Pattern, type(None))')
        if isinstance(pause_class_5, (Pattern, type(None))) is True:
            self.pause_class_5 = pause_class_5
        else:
            raise TypeError('pause_class_5 must be an instance of (Pattern, type(None))')
        if isinstance(pause_class_6, (Pattern, type(None))) is True:
            self.pause_class_6 = pause_class_6
        else:
            raise TypeError('pause_class_6 must be an instance of (Pattern, type(None))')
        if isinstance(pause_class_7, (Pattern, type(None))) is True:
            self.pause_class_7 = pause_class_7
        else:
            raise TypeError('pause_class_7 must be an instance of (Pattern, type(None))')


class EthernetPause(object):
    """Generated from OpenAPI schema object #/components/schemas/Flow.EthernetPause

    IEEE 802.3x Ethernet Pause packet header  
    - dst: 01:80:C2:00:00:01 48bits - src: 48bits - ether_type: 0x8808 16bits - control_op_code: 0x0001 16bits - time: 0x0000 16bits  

    Args
    ----
    - dst (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
    - src (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
    - ether_type (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
    - control_op_code (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
    - time (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
    """
    def __init__(self, dst=None, src=None, ether_type=None, control_op_code=None, time=None):
        from abstract_open_traffic_generator.flow import Pattern
        if isinstance(dst, (Pattern, type(None))) is True:
            self.dst = dst
        else:
            raise TypeError('dst must be an instance of (Pattern, type(None))')
        if isinstance(src, (Pattern, type(None))) is True:
            self.src = src
        else:
            raise TypeError('src must be an instance of (Pattern, type(None))')
        if isinstance(ether_type, (Pattern, type(None))) is True:
            self.ether_type = ether_type
        else:
            raise TypeError('ether_type must be an instance of (Pattern, type(None))')
        if isinstance(control_op_code, (Pattern, type(None))) is True:
            self.control_op_code = control_op_code
        else:
            raise TypeError('control_op_code must be an instance of (Pattern, type(None))')
        if isinstance(time, (Pattern, type(None))) is True:
            self.time = time
        else:
            raise TypeError('time must be an instance of (Pattern, type(None))')


class Tcp(object):
    """Generated from OpenAPI schema object #/components/schemas/Flow.Tcp

    Tcp packet header  

    Args
    ----
    - src_port (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
     Tcp source port
     Max length is 2 bytes
    - dst_port (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
     Tcp destination port
     Max length is 2 bytes
    - ecn_ns (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
     Explicit congestion notification, concealment protection
     Max length is 1 bit
    - ecn_cwr (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
     Explicit congestion notification, congestion window reduced
     Max length is 1 bit
    - ecn_echo (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
     Explicit congestion notification, echo
     1 indicates the peer is ecn capable
     0 indicates that a packet with ipv4
     ecn = 11 in the ip header was received during normal transmission
     Max length is 1 bit
    - ctl_urg (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
     The urgent pointer field is significant
     Max length is 1 bit
    - ctl_ack (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
     The ackknowledgment field is significant
     Max length is 1 bit
    - ctl_psh (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
     Asks to push the buffered data to the receiving application
     Max length is 1 bit
    - ctl_rst (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
     Reset the connection
     Max length is 1 bit
    - ctl_syn (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
     Synchronize sequenece numbers
     Max length is 1 bit
    - ctl_fin (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
     Last packet from the sender
     Max length is 1 bit
    """
    def __init__(self, src_port=None, dst_port=None, ecn_ns=None, ecn_cwr=None, ecn_echo=None, ctl_urg=None, ctl_ack=None, ctl_psh=None, ctl_rst=None, ctl_syn=None, ctl_fin=None):
        from abstract_open_traffic_generator.flow import Pattern
        if isinstance(src_port, (Pattern, type(None))) is True:
            self.src_port = src_port
        else:
            raise TypeError('src_port must be an instance of (Pattern, type(None))')
        if isinstance(dst_port, (Pattern, type(None))) is True:
            self.dst_port = dst_port
        else:
            raise TypeError('dst_port must be an instance of (Pattern, type(None))')
        if isinstance(ecn_ns, (Pattern, type(None))) is True:
            self.ecn_ns = ecn_ns
        else:
            raise TypeError('ecn_ns must be an instance of (Pattern, type(None))')
        if isinstance(ecn_cwr, (Pattern, type(None))) is True:
            self.ecn_cwr = ecn_cwr
        else:
            raise TypeError('ecn_cwr must be an instance of (Pattern, type(None))')
        if isinstance(ecn_echo, (Pattern, type(None))) is True:
            self.ecn_echo = ecn_echo
        else:
            raise TypeError('ecn_echo must be an instance of (Pattern, type(None))')
        if isinstance(ctl_urg, (Pattern, type(None))) is True:
            self.ctl_urg = ctl_urg
        else:
            raise TypeError('ctl_urg must be an instance of (Pattern, type(None))')
        if isinstance(ctl_ack, (Pattern, type(None))) is True:
            self.ctl_ack = ctl_ack
        else:
            raise TypeError('ctl_ack must be an instance of (Pattern, type(None))')
        if isinstance(ctl_psh, (Pattern, type(None))) is True:
            self.ctl_psh = ctl_psh
        else:
            raise TypeError('ctl_psh must be an instance of (Pattern, type(None))')
        if isinstance(ctl_rst, (Pattern, type(None))) is True:
            self.ctl_rst = ctl_rst
        else:
            raise TypeError('ctl_rst must be an instance of (Pattern, type(None))')
        if isinstance(ctl_syn, (Pattern, type(None))) is True:
            self.ctl_syn = ctl_syn
        else:
            raise TypeError('ctl_syn must be an instance of (Pattern, type(None))')
        if isinstance(ctl_fin, (Pattern, type(None))) is True:
            self.ctl_fin = ctl_fin
        else:
            raise TypeError('ctl_fin must be an instance of (Pattern, type(None))')


class Udp(object):
    """Generated from OpenAPI schema object #/components/schemas/Flow.Udp

    Udp packet header  

    Args
    ----
    - src_port (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
     Udp source port
     Max length is 2 bytes
    - dst_port (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
     Tcp destination port
     Max length is 2 bytes
    - length (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
     Length in bytes of the udp header and yudp data
     Max length is 2 bytes
    - checksum (Pattern): A container for packet header field patterns
     Possible patterns are fixed, list, counter, random
     Checksum field used for error checking of header and data
     Max length is 2 bytes
    """
    def __init__(self, src_port=None, dst_port=None, length=None, checksum=None):
        from abstract_open_traffic_generator.flow import Pattern
        if isinstance(src_port, (Pattern, type(None))) is True:
            self.src_port = src_port
        else:
            raise TypeError('src_port must be an instance of (Pattern, type(None))')
        if isinstance(dst_port, (Pattern, type(None))) is True:
            self.dst_port = dst_port
        else:
            raise TypeError('dst_port must be an instance of (Pattern, type(None))')
        if isinstance(length, (Pattern, type(None))) is True:
            self.length = length
        else:
            raise TypeError('length must be an instance of (Pattern, type(None))')
        if isinstance(checksum, (Pattern, type(None))) is True:
            self.checksum = checksum
        else:
            raise TypeError('checksum must be an instance of (Pattern, type(None))')


class Size(object):
    """Generated from OpenAPI schema object #/components/schemas/Flow.Size

    The frame size which overrides the total length of the packet  

    Args
    ----
    - choice (Union[float, int, SizeIncrement, SizeRandom]): TBD
    """
    _CHOICE_MAP = {
        'float': 'fixed',
        'int': 'fixed',
        'SizeIncrement': 'increment',
        'SizeRandom': 'random',
    }
    def __init__(self, choice=None):
        from abstract_open_traffic_generator.flow import SizeIncrement
        from abstract_open_traffic_generator.flow import SizeRandom
        if isinstance(choice, (float, int, SizeIncrement, SizeRandom)) is False:
            raise TypeError('choice must be of type: float, int, SizeIncrement, SizeRandom')
        self.__setattr__('choice', Size._CHOICE_MAP[type(choice).__name__])
        self.__setattr__(Size._CHOICE_MAP[type(choice).__name__], choice)


class SizeIncrement(object):
    """Generated from OpenAPI schema object #/components/schemas/Flow.SizeIncrement

    Frame size that increments from a starting size to an ending size incrementing by a step size  

    Args
    ----
    - start (int): Starting frame size in bytes
    - end (int): Ending frame size in bytes
    - step (int): Step frame size in bytes
    """
    def __init__(self, start=64, end=1518, step=1):
        if isinstance(start, (float, int)) is True:
            self.start = start
        else:
            raise TypeError('start must be an instance of (float, int)')
        if isinstance(end, (float, int)) is True:
            self.end = end
        else:
            raise TypeError('end must be an instance of (float, int)')
        if isinstance(step, (float, int)) is True:
            self.step = step
        else:
            raise TypeError('step must be an instance of (float, int)')


class SizeRandom(object):
    """Generated from OpenAPI schema object #/components/schemas/Flow.SizeRandom

    Random frame size from a min value to a max value  

    Args
    ----
    - min (int): TBD
    - max (int): TBD
    """
    def __init__(self, min=64, max=1518):
        if isinstance(min, (float, int)) is True:
            self.min = min
        else:
            raise TypeError('min must be an instance of (float, int)')
        if isinstance(max, (float, int)) is True:
            self.max = max
        else:
            raise TypeError('max must be an instance of (float, int)')


class Rate(object):
    """Generated from OpenAPI schema object #/components/schemas/Flow.Rate

    The rate of packet transmission  

    Args
    ----
    - unit (Union[pps, bps, kbps, mbps, gbps, line]): The value is a unit of this
    - value (int): The actual rate
    """
    def __init__(self, unit=None, value=None):
        if isinstance(unit, (str)) is True:
            self.unit = unit
        else:
            raise TypeError('unit must be an instance of (str)')
        if isinstance(value, (float, int)) is True:
            self.value = value
        else:
            raise TypeError('value must be an instance of (float, int)')


class Duration(object):
    """Generated from OpenAPI schema object #/components/schemas/Flow.Duration

    A container for different transmit durations  

    Args
    ----
    - choice (Union[Fixed, Burst]): TBD
    """
    _CHOICE_MAP = {
        'Fixed': 'fixed',
        'Burst': 'burst',
    }
    def __init__(self, choice=None):
        from abstract_open_traffic_generator.flow import Fixed
        from abstract_open_traffic_generator.flow import Burst
        if isinstance(choice, (Fixed, Burst)) is False:
            raise TypeError('choice must be of type: Fixed, Burst')
        self.__setattr__('choice', Duration._CHOICE_MAP[type(choice).__name__])
        self.__setattr__(Duration._CHOICE_MAP[type(choice).__name__], choice)


class Fixed(object):
    """Generated from OpenAPI schema object #/components/schemas/Flow.Fixed

    A fixed number of packets will be transmitted after which the flow will stop  
    If the number of packets is set to 0 the flow will not stop  

    Args
    ----
    - packets (int): Stop transmit of the flow after this number of packets
     A value of 0 means that the flow will not stop transmitting
    - gap (int): The minimum gap between packets expressed as bytes
    - delay (int): The delay before starting transmission of packets
    - delay_unit (Union[bytes, nanoseconds]): The delay expressed as a number of this value
    """
    def __init__(self, packets=0, gap=None, delay=None, delay_unit=None):
        if isinstance(packets, (float, int, type(None))) is True:
            self.packets = packets
        else:
            raise TypeError('packets must be an instance of (float, int, type(None))')
        if isinstance(gap, (float, int, type(None))) is True:
            self.gap = gap
        else:
            raise TypeError('gap must be an instance of (float, int, type(None))')
        if isinstance(delay, (float, int, type(None))) is True:
            self.delay = delay
        else:
            raise TypeError('delay must be an instance of (float, int, type(None))')
        if isinstance(delay_unit, (str, type(None))) is True:
            self.delay_unit = delay_unit
        else:
            raise TypeError('delay_unit must be an instance of (str, type(None))')


class Burst(object):
    """Generated from OpenAPI schema object #/components/schemas/Flow.Burst

    A continuous burst of packets that will not automatically stop  

    Args
    ----
    - packets (int): The number of packets transmitted per burst
    - gap (int): The minimum gap between packets expressed as bytes
    - inter_burst_gap (int): The gap between the transmission of each burst
     A value of 0 means there is no gap between bursts
    - inter_burst_gap_unit (Union[bytes, nanoseconds]): The inter burst gap expressed as a number of this value
    """
    def __init__(self, packets=None, gap=None, inter_burst_gap=None, inter_burst_gap_unit=None):
        if isinstance(packets, (float, int, type(None))) is True:
            self.packets = packets
        else:
            raise TypeError('packets must be an instance of (float, int, type(None))')
        if isinstance(gap, (float, int, type(None))) is True:
            self.gap = gap
        else:
            raise TypeError('gap must be an instance of (float, int, type(None))')
        if isinstance(inter_burst_gap, (float, int, type(None))) is True:
            self.inter_burst_gap = inter_burst_gap
        else:
            raise TypeError('inter_burst_gap must be an instance of (float, int, type(None))')
        if isinstance(inter_burst_gap_unit, (str, type(None))) is True:
            self.inter_burst_gap_unit = inter_burst_gap_unit
        else:
            raise TypeError('inter_burst_gap_unit must be an instance of (str, type(None))')
