import json
import setuptools

kwargs = json.loads(
    """
{
    "name": "aws-cdk.app-delivery",
    "version": "1.63.0",
    "description": "Continuous Integration / Continuous Delivery for CDK Applications",
    "license": "Apache-2.0",
    "url": "https://github.com/aws/aws-cdk",
    "long_description_content_type": "text/markdown",
    "author": "Amazon Web Services",
    "bdist_wheel": {
        "universal": true
    },
    "project_urls": {
        "Source": "https://github.com/aws/aws-cdk.git"
    },
    "package_dir": {
        "": "src"
    },
    "packages": [
        "aws_cdk.app_delivery",
        "aws_cdk.app_delivery._jsii"
    ],
    "package_data": {
        "aws_cdk.app_delivery._jsii": [
            "app-delivery@1.63.0.jsii.tgz"
        ],
        "aws_cdk.app_delivery": [
            "py.typed"
        ]
    },
    "python_requires": ">=3.6",
    "install_requires": [
        "aws-cdk.aws-cloudformation==1.63.0",
        "aws-cdk.aws-codebuild==1.63.0",
        "aws-cdk.aws-codepipeline-actions==1.63.0",
        "aws-cdk.aws-codepipeline==1.63.0",
        "aws-cdk.aws-events==1.63.0",
        "aws-cdk.aws-iam==1.63.0",
        "aws-cdk.cloud-assembly-schema==1.63.0",
        "aws-cdk.core==1.63.0",
        "aws-cdk.cx-api==1.63.0",
        "constructs>=3.0.4, <4.0.0",
        "jsii>=1.11.0, <2.0.0",
        "publication>=0.0.3"
    ],
    "classifiers": [
        "Intended Audience :: Developers",
        "Operating System :: OS Independent",
        "Programming Language :: JavaScript",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Typing :: Typed",
        "Development Status :: 7 - Inactive",
        "License :: OSI Approved"
    ]
}
"""
)

with open("README.md") as fp:
    kwargs["long_description"] = fp.read()


setuptools.setup(**kwargs)
