# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables
from . import outputs

__all__ = [
    'AuthorityAccessUrl',
    'AuthorityConfig',
    'AuthorityConfigReusableConfig',
    'AuthorityConfigSubjectConfig',
    'AuthorityConfigSubjectConfigSubject',
    'AuthorityConfigSubjectConfigSubjectAltName',
    'AuthorityIamBindingCondition',
    'AuthorityIamMemberCondition',
    'AuthorityIssuingOptions',
    'AuthorityKeySpec',
]

@pulumi.output_type
class AuthorityAccessUrl(dict):
    def __init__(__self__, *,
                 ca_certificate_access_url: Optional[str] = None,
                 crl_access_url: Optional[str] = None):
        if ca_certificate_access_url is not None:
            pulumi.set(__self__, "ca_certificate_access_url", ca_certificate_access_url)
        if crl_access_url is not None:
            pulumi.set(__self__, "crl_access_url", crl_access_url)

    @property
    @pulumi.getter(name="caCertificateAccessUrl")
    def ca_certificate_access_url(self) -> Optional[str]:
        return pulumi.get(self, "ca_certificate_access_url")

    @property
    @pulumi.getter(name="crlAccessUrl")
    def crl_access_url(self) -> Optional[str]:
        return pulumi.get(self, "crl_access_url")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AuthorityConfig(dict):
    def __init__(__self__, *,
                 reusable_config: 'outputs.AuthorityConfigReusableConfig',
                 subject_config: 'outputs.AuthorityConfigSubjectConfig'):
        """
        :param 'AuthorityConfigReusableConfigArgs' reusable_config: A resource path to a ReusableConfig in the format
               `projects/*/locations/*/reusableConfigs/*`.
               . Alternatively, one of the short names
               found by running `gcloud beta privateca reusable-configs list`.
        :param 'AuthorityConfigSubjectConfigArgs' subject_config: Specifies some of the values in a certificate that are related to the subject.
               Structure is documented below.
        """
        pulumi.set(__self__, "reusable_config", reusable_config)
        pulumi.set(__self__, "subject_config", subject_config)

    @property
    @pulumi.getter(name="reusableConfig")
    def reusable_config(self) -> 'outputs.AuthorityConfigReusableConfig':
        """
        A resource path to a ReusableConfig in the format
        `projects/*/locations/*/reusableConfigs/*`.
        . Alternatively, one of the short names
        found by running `gcloud beta privateca reusable-configs list`.
        """
        return pulumi.get(self, "reusable_config")

    @property
    @pulumi.getter(name="subjectConfig")
    def subject_config(self) -> 'outputs.AuthorityConfigSubjectConfig':
        """
        Specifies some of the values in a certificate that are related to the subject.
        Structure is documented below.
        """
        return pulumi.get(self, "subject_config")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AuthorityConfigReusableConfig(dict):
    def __init__(__self__, *,
                 reusable_config: str):
        """
        :param str reusable_config: A resource path to a ReusableConfig in the format
               `projects/*/locations/*/reusableConfigs/*`.
               . Alternatively, one of the short names
               found by running `gcloud beta privateca reusable-configs list`.
        """
        pulumi.set(__self__, "reusable_config", reusable_config)

    @property
    @pulumi.getter(name="reusableConfig")
    def reusable_config(self) -> str:
        """
        A resource path to a ReusableConfig in the format
        `projects/*/locations/*/reusableConfigs/*`.
        . Alternatively, one of the short names
        found by running `gcloud beta privateca reusable-configs list`.
        """
        return pulumi.get(self, "reusable_config")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AuthorityConfigSubjectConfig(dict):
    def __init__(__self__, *,
                 common_name: str,
                 subject: 'outputs.AuthorityConfigSubjectConfigSubject',
                 subject_alt_name: Optional['outputs.AuthorityConfigSubjectConfigSubjectAltName'] = None):
        """
        :param str common_name: The common name of the distinguished name.
        :param 'AuthorityConfigSubjectConfigSubjectArgs' subject: Contains distinguished name fields such as the location and organization.
               Structure is documented below.
        :param 'AuthorityConfigSubjectConfigSubjectAltNameArgs' subject_alt_name: The subject alternative name fields.
               Structure is documented below.
        """
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "subject", subject)
        if subject_alt_name is not None:
            pulumi.set(__self__, "subject_alt_name", subject_alt_name)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> str:
        """
        The common name of the distinguished name.
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter
    def subject(self) -> 'outputs.AuthorityConfigSubjectConfigSubject':
        """
        Contains distinguished name fields such as the location and organization.
        Structure is documented below.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter(name="subjectAltName")
    def subject_alt_name(self) -> Optional['outputs.AuthorityConfigSubjectConfigSubjectAltName']:
        """
        The subject alternative name fields.
        Structure is documented below.
        """
        return pulumi.get(self, "subject_alt_name")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AuthorityConfigSubjectConfigSubject(dict):
    def __init__(__self__, *,
                 organization: str,
                 country_code: Optional[str] = None,
                 locality: Optional[str] = None,
                 organizational_unit: Optional[str] = None,
                 postal_code: Optional[str] = None,
                 province: Optional[str] = None,
                 street_address: Optional[str] = None):
        """
        :param str organization: The organization of the subject.
        :param str country_code: The country code of the subject.
        :param str locality: The locality or city of the subject.
        :param str organizational_unit: The organizational unit of the subject.
        :param str postal_code: The postal code of the subject.
        :param str province: The province, territory, or regional state of the subject.
        :param str street_address: The street address of the subject.
        """
        pulumi.set(__self__, "organization", organization)
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if organizational_unit is not None:
            pulumi.set(__self__, "organizational_unit", organizational_unit)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if street_address is not None:
            pulumi.set(__self__, "street_address", street_address)

    @property
    @pulumi.getter
    def organization(self) -> str:
        """
        The organization of the subject.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[str]:
        """
        The country code of the subject.
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter
    def locality(self) -> Optional[str]:
        """
        The locality or city of the subject.
        """
        return pulumi.get(self, "locality")

    @property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> Optional[str]:
        """
        The organizational unit of the subject.
        """
        return pulumi.get(self, "organizational_unit")

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[str]:
        """
        The postal code of the subject.
        """
        return pulumi.get(self, "postal_code")

    @property
    @pulumi.getter
    def province(self) -> Optional[str]:
        """
        The province, territory, or regional state of the subject.
        """
        return pulumi.get(self, "province")

    @property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> Optional[str]:
        """
        The street address of the subject.
        """
        return pulumi.get(self, "street_address")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AuthorityConfigSubjectConfigSubjectAltName(dict):
    def __init__(__self__, *,
                 dns_names: Optional[Sequence[str]] = None,
                 email_addresses: Optional[Sequence[str]] = None,
                 ip_addresses: Optional[Sequence[str]] = None,
                 uris: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] dns_names: Contains only valid, fully-qualified host names.
        :param Sequence[str] email_addresses: Contains only valid RFC 2822 E-mail addresses.
        :param Sequence[str] ip_addresses: Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
        :param Sequence[str] uris: Contains only valid RFC 3986 URIs.
        """
        if dns_names is not None:
            pulumi.set(__self__, "dns_names", dns_names)
        if email_addresses is not None:
            pulumi.set(__self__, "email_addresses", email_addresses)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if uris is not None:
            pulumi.set(__self__, "uris", uris)

    @property
    @pulumi.getter(name="dnsNames")
    def dns_names(self) -> Optional[Sequence[str]]:
        """
        Contains only valid, fully-qualified host names.
        """
        return pulumi.get(self, "dns_names")

    @property
    @pulumi.getter(name="emailAddresses")
    def email_addresses(self) -> Optional[Sequence[str]]:
        """
        Contains only valid RFC 2822 E-mail addresses.
        """
        return pulumi.get(self, "email_addresses")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[str]]:
        """
        Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter
    def uris(self) -> Optional[Sequence[str]]:
        """
        Contains only valid RFC 3986 URIs.
        """
        return pulumi.get(self, "uris")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AuthorityIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AuthorityIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AuthorityIssuingOptions(dict):
    def __init__(__self__, *,
                 include_ca_cert_url: Optional[bool] = None,
                 include_crl_access_url: Optional[bool] = None):
        """
        :param bool include_ca_cert_url: When true, includes a URL to the issuing CA certificate in the "authority
               information access" X.509 extension.
        :param bool include_crl_access_url: When true, includes a URL to the CRL corresponding to certificates issued from a
               CertificateAuthority. CRLs will expire 7 days from their creation. However, we will
               rebuild daily. CRLs are also rebuilt shortly after a certificate is revoked.
        """
        if include_ca_cert_url is not None:
            pulumi.set(__self__, "include_ca_cert_url", include_ca_cert_url)
        if include_crl_access_url is not None:
            pulumi.set(__self__, "include_crl_access_url", include_crl_access_url)

    @property
    @pulumi.getter(name="includeCaCertUrl")
    def include_ca_cert_url(self) -> Optional[bool]:
        """
        When true, includes a URL to the issuing CA certificate in the "authority
        information access" X.509 extension.
        """
        return pulumi.get(self, "include_ca_cert_url")

    @property
    @pulumi.getter(name="includeCrlAccessUrl")
    def include_crl_access_url(self) -> Optional[bool]:
        """
        When true, includes a URL to the CRL corresponding to certificates issued from a
        CertificateAuthority. CRLs will expire 7 days from their creation. However, we will
        rebuild daily. CRLs are also rebuilt shortly after a certificate is revoked.
        """
        return pulumi.get(self, "include_crl_access_url")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AuthorityKeySpec(dict):
    def __init__(__self__, *,
                 algorithm: Optional[str] = None,
                 cloud_kms_key_version: Optional[str] = None):
        """
        :param str algorithm: The algorithm to use for creating a managed Cloud KMS key for a for a simplified
               experience. All managed keys will be have their ProtectionLevel as HSM.
               Possible values are `SIGN_HASH_ALGORITHM_UNSPECIFIED`, `RSA_PSS_2048_SHA256`, `RSA_PSS_3072_SHA256`, `RSA_PSS_4096_SHA256`, `RSA_PKCS1_2048_SHA256`, `RSA_PKCS1_3072_SHA256`, `RSA_PKCS1_4096_SHA256`, `EC_P256_SHA256`, and `EC_P384_SHA384`.
        :param str cloud_kms_key_version: The resource name for an existing Cloud KMS CryptoKeyVersion in the format
               `projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*`.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if cloud_kms_key_version is not None:
            pulumi.set(__self__, "cloud_kms_key_version", cloud_kms_key_version)

    @property
    @pulumi.getter
    def algorithm(self) -> Optional[str]:
        """
        The algorithm to use for creating a managed Cloud KMS key for a for a simplified
        experience. All managed keys will be have their ProtectionLevel as HSM.
        Possible values are `SIGN_HASH_ALGORITHM_UNSPECIFIED`, `RSA_PSS_2048_SHA256`, `RSA_PSS_3072_SHA256`, `RSA_PSS_4096_SHA256`, `RSA_PKCS1_2048_SHA256`, `RSA_PKCS1_3072_SHA256`, `RSA_PKCS1_4096_SHA256`, `EC_P256_SHA256`, and `EC_P384_SHA384`.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="cloudKmsKeyVersion")
    def cloud_kms_key_version(self) -> Optional[str]:
        """
        The resource name for an existing Cloud KMS CryptoKeyVersion in the format
        `projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*`.
        """
        return pulumi.get(self, "cloud_kms_key_version")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


