# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Service']


class Service(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autogenerate_revision_name: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[pulumi.InputType['ServiceMetadataArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input[pulumi.InputType['ServiceTemplateArgs']]] = None,
                 traffics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceTrafficArgs']]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Service acts as a top-level container that manages a set of Routes and
        Configurations which implement a network service. Service exists to provide a
        singular abstraction which can be access controlled, reasoned about, and
        which encapsulates software lifecycle decisions such as rollout policy and
        team resource ownership. Service acts only as an orchestrator of the
        underlying Routes and Configurations (much as a kubernetes Deployment
        orchestrates ReplicaSets).

        The Service's controller will track the statuses of its owned Configuration
        and Route, reflecting their statuses and conditions as its own.

        See also:
        https://github.com/knative/serving/blob/master/docs/spec/overview.md#service

        To get more information about Service, see:

        * [API documentation](https://cloud.google.com/run/docs/reference/rest/v1/projects.locations.services)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/run/docs/)

        ## Example Usage
        ### Cloud Run Service Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            location="us-central1",
            template=gcp.cloudrun.ServiceTemplateArgs(
                spec=gcp.cloudrun.ServiceTemplateSpecArgs(
                    containers=[gcp.cloudrun.ServiceTemplateSpecContainerArgs(
                        image="us-docker.pkg.dev/cloudrun/container/hello",
                    )],
                ),
            ),
            traffics=[gcp.cloudrun.ServiceTrafficArgs(
                latest_revision=True,
                percent=100,
            )])
        ```
        ### Cloud Run Service Sql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.sql.DatabaseInstance("instance",
            region="us-east1",
            settings=gcp.sql.DatabaseInstanceSettingsArgs(
                tier="db-f1-micro",
            ),
            deletion_protection=True)
        default = gcp.cloudrun.Service("default",
            location="us-central1",
            template=gcp.cloudrun.ServiceTemplateArgs(
                spec=gcp.cloudrun.ServiceTemplateSpecArgs(
                    containers=[gcp.cloudrun.ServiceTemplateSpecContainerArgs(
                        image="us-docker.pkg.dev/cloudrun/container/hello",
                    )],
                ),
                metadata=gcp.cloudrun.ServiceTemplateMetadataArgs(
                    annotations={
                        "autoscaling.knative.dev/maxScale": "1000",
                        "run.googleapis.com/cloudsql-instances": instance.connection_name,
                        "run.googleapis.com/client-name": "demo",
                    },
                ),
            ),
            autogenerate_revision_name=True)
        ```

        ###Cloud Run Service Noauth

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            location="us-central1",
            template=gcp.cloudrun.ServiceTemplateArgs(
                spec=gcp.cloudrun.ServiceTemplateSpecArgs(
                    containers=[gcp.cloudrun.ServiceTemplateSpecContainerArgs(
                        image="us-docker.pkg.dev/cloudrun/container/hello",
                    )],
                ),
            ))
        noauth_iam_policy = gcp.organizations.get_iam_policy(bindings=[gcp.organizations.GetIAMPolicyBindingArgs(
            role="roles/run.invoker",
            members=["allUsers"],
        )])
        noauth_iam_policy = gcp.cloudrun.IamPolicy("noauthIamPolicy",
            location=default.location,
            project=default.project,
            service=default.name,
            policy_data=noauth_iam_policy.policy_data)
        ```
        ### Cloud Run Service Multiple Environment Variables

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            autogenerate_revision_name=True,
            location="us-central1",
            metadata=gcp.cloudrun.ServiceMetadataArgs(
                annotations={
                    "generated-by": "magic-modules",
                },
            ),
            template=gcp.cloudrun.ServiceTemplateArgs(
                spec=gcp.cloudrun.ServiceTemplateSpecArgs(
                    containers=[gcp.cloudrun.ServiceTemplateSpecContainerArgs(
                        env=[
                            {
                                "name": "SOURCE",
                                "value": "remote",
                            },
                            {
                                "name": "TARGET",
                                "value": "home",
                            },
                        ],
                        image="us-docker.pkg.dev/cloudrun/container/hello",
                    )],
                ),
            ),
            traffics=[gcp.cloudrun.ServiceTrafficArgs(
                latest_revision=True,
                percent=100,
            )])
        ```
        ### Cloud Run Service Traffic Split

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            location="us-central1",
            template=gcp.cloudrun.ServiceTemplateArgs(
                metadata=gcp.cloudrun.ServiceTemplateMetadataArgs(
                    name="cloudrun-srv-green",
                ),
                spec=gcp.cloudrun.ServiceTemplateSpecArgs(
                    containers=[gcp.cloudrun.ServiceTemplateSpecContainerArgs(
                        image="us-docker.pkg.dev/cloudrun/container/hello",
                    )],
                ),
            ),
            traffics=[
                gcp.cloudrun.ServiceTrafficArgs(
                    percent=25,
                    revision_name="cloudrun-srv-green",
                ),
                gcp.cloudrun.ServiceTrafficArgs(
                    percent=75,
                    revision_name="cloudrun-srv-blue",
                ),
            ])
        ```

        ## Import

        Service can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:cloudrun/service:Service default locations/{{location}}/namespaces/{{project}}/services/{{name}}
        ```

        ```sh
         $ pulumi import gcp:cloudrun/service:Service default {{location}}/{{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:cloudrun/service:Service default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] autogenerate_revision_name: If set to `true`, the revision name (template.metadata.name) will be omitted and
               autogenerated by Cloud Run. This cannot be set to `true` while `template.metadata.name`
               is also set.
               (For legacy support, if `template.metadata.name` is unset in state while
               this field is set to false, the revision name will still autogenerate.)
        :param pulumi.Input[str] location: The location of the cloud run instance. eg us-central1
        :param pulumi.Input[pulumi.InputType['ServiceMetadataArgs']] metadata: Metadata associated with this Service, including name, namespace, labels,
               and annotations.
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the port.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['ServiceTemplateArgs']] template: template holds the latest specification for the Revision to
               be stamped out. The template references the container image, and may also
               include labels and annotations that should be attached to the Revision.
               To correlate a Revision, and/or to force a Revision to be created when the
               spec doesn't otherwise change, a nonce label may be provided in the
               template metadata. For more details, see:
               https://github.com/knative/serving/blob/master/docs/client-conventions.md#associate-modifications-with-revisions
               Cloud Run does not currently support referencing a build that is
               responsible for materializing the container image from source.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceTrafficArgs']]]] traffics: Traffic specifies how to distribute traffic over a collection of Knative Revisions
               and Configurations
               Structure is documented below.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['autogenerate_revision_name'] = autogenerate_revision_name
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__['location'] = location
            __props__['metadata'] = metadata
            __props__['name'] = name
            __props__['project'] = project
            __props__['template'] = template
            __props__['traffics'] = traffics
            __props__['statuses'] = None
        super(Service, __self__).__init__(
            'gcp:cloudrun/service:Service',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autogenerate_revision_name: Optional[pulumi.Input[bool]] = None,
            location: Optional[pulumi.Input[str]] = None,
            metadata: Optional[pulumi.Input[pulumi.InputType['ServiceMetadataArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            statuses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceStatusArgs']]]]] = None,
            template: Optional[pulumi.Input[pulumi.InputType['ServiceTemplateArgs']]] = None,
            traffics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceTrafficArgs']]]]] = None) -> 'Service':
        """
        Get an existing Service resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] autogenerate_revision_name: If set to `true`, the revision name (template.metadata.name) will be omitted and
               autogenerated by Cloud Run. This cannot be set to `true` while `template.metadata.name`
               is also set.
               (For legacy support, if `template.metadata.name` is unset in state while
               this field is set to false, the revision name will still autogenerate.)
        :param pulumi.Input[str] location: The location of the cloud run instance. eg us-central1
        :param pulumi.Input[pulumi.InputType['ServiceMetadataArgs']] metadata: Metadata associated with this Service, including name, namespace, labels,
               and annotations.
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the port.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceStatusArgs']]]] statuses: The current status of the Service.
        :param pulumi.Input[pulumi.InputType['ServiceTemplateArgs']] template: template holds the latest specification for the Revision to
               be stamped out. The template references the container image, and may also
               include labels and annotations that should be attached to the Revision.
               To correlate a Revision, and/or to force a Revision to be created when the
               spec doesn't otherwise change, a nonce label may be provided in the
               template metadata. For more details, see:
               https://github.com/knative/serving/blob/master/docs/client-conventions.md#associate-modifications-with-revisions
               Cloud Run does not currently support referencing a build that is
               responsible for materializing the container image from source.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceTrafficArgs']]]] traffics: Traffic specifies how to distribute traffic over a collection of Knative Revisions
               and Configurations
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["autogenerate_revision_name"] = autogenerate_revision_name
        __props__["location"] = location
        __props__["metadata"] = metadata
        __props__["name"] = name
        __props__["project"] = project
        __props__["statuses"] = statuses
        __props__["template"] = template
        __props__["traffics"] = traffics
        return Service(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autogenerateRevisionName")
    def autogenerate_revision_name(self) -> pulumi.Output[Optional[bool]]:
        """
        If set to `true`, the revision name (template.metadata.name) will be omitted and
        autogenerated by Cloud Run. This cannot be set to `true` while `template.metadata.name`
        is also set.
        (For legacy support, if `template.metadata.name` is unset in state while
        this field is set to false, the revision name will still autogenerate.)
        """
        return pulumi.get(self, "autogenerate_revision_name")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The location of the cloud run instance. eg us-central1
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output['outputs.ServiceMetadata']:
        """
        Metadata associated with this Service, including name, namespace, labels,
        and annotations.
        Structure is documented below.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the port.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def statuses(self) -> pulumi.Output[Sequence['outputs.ServiceStatus']]:
        """
        The current status of the Service.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter
    def template(self) -> pulumi.Output[Optional['outputs.ServiceTemplate']]:
        """
        template holds the latest specification for the Revision to
        be stamped out. The template references the container image, and may also
        include labels and annotations that should be attached to the Revision.
        To correlate a Revision, and/or to force a Revision to be created when the
        spec doesn't otherwise change, a nonce label may be provided in the
        template metadata. For more details, see:
        https://github.com/knative/serving/blob/master/docs/client-conventions.md#associate-modifications-with-revisions
        Cloud Run does not currently support referencing a build that is
        responsible for materializing the container image from source.
        Structure is documented below.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter
    def traffics(self) -> pulumi.Output[Sequence['outputs.ServiceTraffic']]:
        """
        Traffic specifies how to distribute traffic over a collection of Knative Revisions
        and Configurations
        Structure is documented below.
        """
        return pulumi.get(self, "traffics")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

