# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables
from . import outputs

__all__ = [
    'ClusterAddonsConfig',
    'ClusterAddonsConfigCloudrunConfig',
    'ClusterAddonsConfigConfigConnectorConfig',
    'ClusterAddonsConfigDnsCacheConfig',
    'ClusterAddonsConfigGcePersistentDiskCsiDriverConfig',
    'ClusterAddonsConfigHorizontalPodAutoscaling',
    'ClusterAddonsConfigHttpLoadBalancing',
    'ClusterAddonsConfigIstioConfig',
    'ClusterAddonsConfigKalmConfig',
    'ClusterAddonsConfigNetworkPolicyConfig',
    'ClusterAuthenticatorGroupsConfig',
    'ClusterClusterAutoscaling',
    'ClusterClusterAutoscalingAutoProvisioningDefaults',
    'ClusterClusterAutoscalingResourceLimit',
    'ClusterClusterTelemetry',
    'ClusterConfidentialNodes',
    'ClusterDatabaseEncryption',
    'ClusterDefaultSnatStatus',
    'ClusterIpAllocationPolicy',
    'ClusterMaintenancePolicy',
    'ClusterMaintenancePolicyDailyMaintenanceWindow',
    'ClusterMaintenancePolicyMaintenanceExclusion',
    'ClusterMaintenancePolicyRecurringWindow',
    'ClusterMasterAuth',
    'ClusterMasterAuthClientCertificateConfig',
    'ClusterMasterAuthorizedNetworksConfig',
    'ClusterMasterAuthorizedNetworksConfigCidrBlock',
    'ClusterNetworkPolicy',
    'ClusterNodeConfig',
    'ClusterNodeConfigGuestAccelerator',
    'ClusterNodeConfigKubeletConfig',
    'ClusterNodeConfigLinuxNodeConfig',
    'ClusterNodeConfigSandboxConfig',
    'ClusterNodeConfigShieldedInstanceConfig',
    'ClusterNodeConfigTaint',
    'ClusterNodeConfigWorkloadMetadataConfig',
    'ClusterNodePool',
    'ClusterNodePoolAutoscaling',
    'ClusterNodePoolManagement',
    'ClusterNodePoolNodeConfig',
    'ClusterNodePoolNodeConfigGuestAccelerator',
    'ClusterNodePoolNodeConfigKubeletConfig',
    'ClusterNodePoolNodeConfigLinuxNodeConfig',
    'ClusterNodePoolNodeConfigSandboxConfig',
    'ClusterNodePoolNodeConfigShieldedInstanceConfig',
    'ClusterNodePoolNodeConfigTaint',
    'ClusterNodePoolNodeConfigWorkloadMetadataConfig',
    'ClusterNodePoolUpgradeSettings',
    'ClusterNotificationConfig',
    'ClusterNotificationConfigPubsub',
    'ClusterPodSecurityPolicyConfig',
    'ClusterPrivateClusterConfig',
    'ClusterPrivateClusterConfigMasterGlobalAccessConfig',
    'ClusterReleaseChannel',
    'ClusterResourceUsageExportConfig',
    'ClusterResourceUsageExportConfigBigqueryDestination',
    'ClusterVerticalPodAutoscaling',
    'ClusterWorkloadIdentityConfig',
    'NodePoolAutoscaling',
    'NodePoolManagement',
    'NodePoolNodeConfig',
    'NodePoolNodeConfigGuestAccelerator',
    'NodePoolNodeConfigKubeletConfig',
    'NodePoolNodeConfigLinuxNodeConfig',
    'NodePoolNodeConfigSandboxConfig',
    'NodePoolNodeConfigShieldedInstanceConfig',
    'NodePoolNodeConfigTaint',
    'NodePoolNodeConfigWorkloadMetadataConfig',
    'NodePoolUpgradeSettings',
    'GetClusterAddonsConfigResult',
    'GetClusterAddonsConfigCloudrunConfigResult',
    'GetClusterAddonsConfigConfigConnectorConfigResult',
    'GetClusterAddonsConfigDnsCacheConfigResult',
    'GetClusterAddonsConfigGcePersistentDiskCsiDriverConfigResult',
    'GetClusterAddonsConfigHorizontalPodAutoscalingResult',
    'GetClusterAddonsConfigHttpLoadBalancingResult',
    'GetClusterAddonsConfigIstioConfigResult',
    'GetClusterAddonsConfigKalmConfigResult',
    'GetClusterAddonsConfigNetworkPolicyConfigResult',
    'GetClusterAuthenticatorGroupsConfigResult',
    'GetClusterClusterAutoscalingResult',
    'GetClusterClusterAutoscalingAutoProvisioningDefaultResult',
    'GetClusterClusterAutoscalingResourceLimitResult',
    'GetClusterClusterTelemetryResult',
    'GetClusterConfidentialNodeResult',
    'GetClusterDatabaseEncryptionResult',
    'GetClusterDefaultSnatStatusResult',
    'GetClusterIpAllocationPolicyResult',
    'GetClusterMaintenancePolicyResult',
    'GetClusterMaintenancePolicyDailyMaintenanceWindowResult',
    'GetClusterMaintenancePolicyMaintenanceExclusionResult',
    'GetClusterMaintenancePolicyRecurringWindowResult',
    'GetClusterMasterAuthResult',
    'GetClusterMasterAuthClientCertificateConfigResult',
    'GetClusterMasterAuthorizedNetworksConfigResult',
    'GetClusterMasterAuthorizedNetworksConfigCidrBlockResult',
    'GetClusterNetworkPolicyResult',
    'GetClusterNodeConfigResult',
    'GetClusterNodeConfigGuestAcceleratorResult',
    'GetClusterNodeConfigKubeletConfigResult',
    'GetClusterNodeConfigLinuxNodeConfigResult',
    'GetClusterNodeConfigSandboxConfigResult',
    'GetClusterNodeConfigShieldedInstanceConfigResult',
    'GetClusterNodeConfigTaintResult',
    'GetClusterNodeConfigWorkloadMetadataConfigResult',
    'GetClusterNodePoolResult',
    'GetClusterNodePoolAutoscalingResult',
    'GetClusterNodePoolManagementResult',
    'GetClusterNodePoolNodeConfigResult',
    'GetClusterNodePoolNodeConfigGuestAcceleratorResult',
    'GetClusterNodePoolNodeConfigKubeletConfigResult',
    'GetClusterNodePoolNodeConfigLinuxNodeConfigResult',
    'GetClusterNodePoolNodeConfigSandboxConfigResult',
    'GetClusterNodePoolNodeConfigShieldedInstanceConfigResult',
    'GetClusterNodePoolNodeConfigTaintResult',
    'GetClusterNodePoolNodeConfigWorkloadMetadataConfigResult',
    'GetClusterNodePoolUpgradeSettingResult',
    'GetClusterNotificationConfigResult',
    'GetClusterNotificationConfigPubsubResult',
    'GetClusterPodSecurityPolicyConfigResult',
    'GetClusterPrivateClusterConfigResult',
    'GetClusterPrivateClusterConfigMasterGlobalAccessConfigResult',
    'GetClusterReleaseChannelResult',
    'GetClusterResourceUsageExportConfigResult',
    'GetClusterResourceUsageExportConfigBigqueryDestinationResult',
    'GetClusterVerticalPodAutoscalingResult',
    'GetClusterWorkloadIdentityConfigResult',
]

@pulumi.output_type
class ClusterAddonsConfig(dict):
    def __init__(__self__, *,
                 cloudrun_config: Optional['outputs.ClusterAddonsConfigCloudrunConfig'] = None,
                 config_connector_config: Optional['outputs.ClusterAddonsConfigConfigConnectorConfig'] = None,
                 dns_cache_config: Optional['outputs.ClusterAddonsConfigDnsCacheConfig'] = None,
                 gce_persistent_disk_csi_driver_config: Optional['outputs.ClusterAddonsConfigGcePersistentDiskCsiDriverConfig'] = None,
                 horizontal_pod_autoscaling: Optional['outputs.ClusterAddonsConfigHorizontalPodAutoscaling'] = None,
                 http_load_balancing: Optional['outputs.ClusterAddonsConfigHttpLoadBalancing'] = None,
                 istio_config: Optional['outputs.ClusterAddonsConfigIstioConfig'] = None,
                 kalm_config: Optional['outputs.ClusterAddonsConfigKalmConfig'] = None,
                 network_policy_config: Optional['outputs.ClusterAddonsConfigNetworkPolicyConfig'] = None):
        """
        :param 'ClusterAddonsConfigCloudrunConfigArgs' cloudrun_config: . Structure is documented below.
        :param 'ClusterAddonsConfigConfigConnectorConfigArgs' config_connector_config: .
               The status of the ConfigConnector addon. It is disabled by default; Set `enabled = true` to enable.
        :param 'ClusterAddonsConfigDnsCacheConfigArgs' dns_cache_config: .
               The status of the NodeLocal DNSCache addon. It is disabled by default.
               Set `enabled = true` to enable.
        :param 'ClusterAddonsConfigGcePersistentDiskCsiDriverConfigArgs' gce_persistent_disk_csi_driver_config: .
               Whether this cluster should enable the Google Compute Engine Persistent Disk Container Storage Interface (CSI) Driver. Defaults to disabled; set `enabled = true` to enable.
        :param 'ClusterAddonsConfigHorizontalPodAutoscalingArgs' horizontal_pod_autoscaling: The status of the Horizontal Pod Autoscaling
               addon, which increases or decreases the number of replica pods a replication controller
               has based on the resource usage of the existing pods.
               It ensures that a Heapster pod is running in the cluster, which is also used by the Cloud Monitoring service.
               It is enabled by default;
               set `disabled = true` to disable.
        :param 'ClusterAddonsConfigHttpLoadBalancingArgs' http_load_balancing: The status of the HTTP (L7) load balancing
               controller addon, which makes it easy to set up HTTP load balancers for services in a
               cluster. It is enabled by default; set `disabled = true` to disable.
        :param 'ClusterAddonsConfigIstioConfigArgs' istio_config: .
               Structure is documented below.
        :param 'ClusterAddonsConfigKalmConfigArgs' kalm_config: .
               Configuration for the KALM addon, which manages the lifecycle of k8s. It is disabled by default; Set `enabled = true` to enable.
        :param 'ClusterAddonsConfigNetworkPolicyConfigArgs' network_policy_config: Whether we should enable the network policy addon
               for the master.  This must be enabled in order to enable network policy for the nodes.
               To enable this, you must also define a `network_policy` block,
               otherwise nothing will happen.
               It can only be disabled if the nodes already do not have network policies enabled.
               Defaults to disabled; set `disabled = false` to enable.
        """
        if cloudrun_config is not None:
            pulumi.set(__self__, "cloudrun_config", cloudrun_config)
        if config_connector_config is not None:
            pulumi.set(__self__, "config_connector_config", config_connector_config)
        if dns_cache_config is not None:
            pulumi.set(__self__, "dns_cache_config", dns_cache_config)
        if gce_persistent_disk_csi_driver_config is not None:
            pulumi.set(__self__, "gce_persistent_disk_csi_driver_config", gce_persistent_disk_csi_driver_config)
        if horizontal_pod_autoscaling is not None:
            pulumi.set(__self__, "horizontal_pod_autoscaling", horizontal_pod_autoscaling)
        if http_load_balancing is not None:
            pulumi.set(__self__, "http_load_balancing", http_load_balancing)
        if istio_config is not None:
            pulumi.set(__self__, "istio_config", istio_config)
        if kalm_config is not None:
            pulumi.set(__self__, "kalm_config", kalm_config)
        if network_policy_config is not None:
            pulumi.set(__self__, "network_policy_config", network_policy_config)

    @property
    @pulumi.getter(name="cloudrunConfig")
    def cloudrun_config(self) -> Optional['outputs.ClusterAddonsConfigCloudrunConfig']:
        """
        . Structure is documented below.
        """
        return pulumi.get(self, "cloudrun_config")

    @property
    @pulumi.getter(name="configConnectorConfig")
    def config_connector_config(self) -> Optional['outputs.ClusterAddonsConfigConfigConnectorConfig']:
        """
        .
        The status of the ConfigConnector addon. It is disabled by default; Set `enabled = true` to enable.
        """
        return pulumi.get(self, "config_connector_config")

    @property
    @pulumi.getter(name="dnsCacheConfig")
    def dns_cache_config(self) -> Optional['outputs.ClusterAddonsConfigDnsCacheConfig']:
        """
        .
        The status of the NodeLocal DNSCache addon. It is disabled by default.
        Set `enabled = true` to enable.
        """
        return pulumi.get(self, "dns_cache_config")

    @property
    @pulumi.getter(name="gcePersistentDiskCsiDriverConfig")
    def gce_persistent_disk_csi_driver_config(self) -> Optional['outputs.ClusterAddonsConfigGcePersistentDiskCsiDriverConfig']:
        """
        .
        Whether this cluster should enable the Google Compute Engine Persistent Disk Container Storage Interface (CSI) Driver. Defaults to disabled; set `enabled = true` to enable.
        """
        return pulumi.get(self, "gce_persistent_disk_csi_driver_config")

    @property
    @pulumi.getter(name="horizontalPodAutoscaling")
    def horizontal_pod_autoscaling(self) -> Optional['outputs.ClusterAddonsConfigHorizontalPodAutoscaling']:
        """
        The status of the Horizontal Pod Autoscaling
        addon, which increases or decreases the number of replica pods a replication controller
        has based on the resource usage of the existing pods.
        It ensures that a Heapster pod is running in the cluster, which is also used by the Cloud Monitoring service.
        It is enabled by default;
        set `disabled = true` to disable.
        """
        return pulumi.get(self, "horizontal_pod_autoscaling")

    @property
    @pulumi.getter(name="httpLoadBalancing")
    def http_load_balancing(self) -> Optional['outputs.ClusterAddonsConfigHttpLoadBalancing']:
        """
        The status of the HTTP (L7) load balancing
        controller addon, which makes it easy to set up HTTP load balancers for services in a
        cluster. It is enabled by default; set `disabled = true` to disable.
        """
        return pulumi.get(self, "http_load_balancing")

    @property
    @pulumi.getter(name="istioConfig")
    def istio_config(self) -> Optional['outputs.ClusterAddonsConfigIstioConfig']:
        """
        .
        Structure is documented below.
        """
        return pulumi.get(self, "istio_config")

    @property
    @pulumi.getter(name="kalmConfig")
    def kalm_config(self) -> Optional['outputs.ClusterAddonsConfigKalmConfig']:
        """
        .
        Configuration for the KALM addon, which manages the lifecycle of k8s. It is disabled by default; Set `enabled = true` to enable.
        """
        return pulumi.get(self, "kalm_config")

    @property
    @pulumi.getter(name="networkPolicyConfig")
    def network_policy_config(self) -> Optional['outputs.ClusterAddonsConfigNetworkPolicyConfig']:
        """
        Whether we should enable the network policy addon
        for the master.  This must be enabled in order to enable network policy for the nodes.
        To enable this, you must also define a `network_policy` block,
        otherwise nothing will happen.
        It can only be disabled if the nodes already do not have network policies enabled.
        Defaults to disabled; set `disabled = false` to enable.
        """
        return pulumi.get(self, "network_policy_config")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterAddonsConfigCloudrunConfig(dict):
    def __init__(__self__, *,
                 disabled: bool,
                 load_balancer_type: Optional[str] = None):
        """
        :param bool disabled: The status of the Istio addon, which makes it easy to set up Istio for services in a
               cluster. It is disabled by default. Set `disabled = false` to enable.
        :param str load_balancer_type: The load balancer type of CloudRun ingress service. It is external load balancer by default.
               Set `load_balancer_type=LOAD_BALANCER_TYPE_INTERNAL` to configure it as internal load balancer.
        """
        pulumi.set(__self__, "disabled", disabled)
        if load_balancer_type is not None:
            pulumi.set(__self__, "load_balancer_type", load_balancer_type)

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        The status of the Istio addon, which makes it easy to set up Istio for services in a
        cluster. It is disabled by default. Set `disabled = false` to enable.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> Optional[str]:
        """
        The load balancer type of CloudRun ingress service. It is external load balancer by default.
        Set `load_balancer_type=LOAD_BALANCER_TYPE_INTERNAL` to configure it as internal load balancer.
        """
        return pulumi.get(self, "load_balancer_type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterAddonsConfigConfigConnectorConfig(dict):
    def __init__(__self__, *,
                 enabled: bool):
        """
        :param bool enabled: Enable the PodSecurityPolicy controller for this cluster.
               If enabled, pods must be valid under a PodSecurityPolicy to be created.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Enable the PodSecurityPolicy controller for this cluster.
        If enabled, pods must be valid under a PodSecurityPolicy to be created.
        """
        return pulumi.get(self, "enabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterAddonsConfigDnsCacheConfig(dict):
    def __init__(__self__, *,
                 enabled: bool):
        """
        :param bool enabled: Enable the PodSecurityPolicy controller for this cluster.
               If enabled, pods must be valid under a PodSecurityPolicy to be created.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Enable the PodSecurityPolicy controller for this cluster.
        If enabled, pods must be valid under a PodSecurityPolicy to be created.
        """
        return pulumi.get(self, "enabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterAddonsConfigGcePersistentDiskCsiDriverConfig(dict):
    def __init__(__self__, *,
                 enabled: bool):
        """
        :param bool enabled: Enable the PodSecurityPolicy controller for this cluster.
               If enabled, pods must be valid under a PodSecurityPolicy to be created.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Enable the PodSecurityPolicy controller for this cluster.
        If enabled, pods must be valid under a PodSecurityPolicy to be created.
        """
        return pulumi.get(self, "enabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterAddonsConfigHorizontalPodAutoscaling(dict):
    def __init__(__self__, *,
                 disabled: bool):
        """
        :param bool disabled: The status of the Istio addon, which makes it easy to set up Istio for services in a
               cluster. It is disabled by default. Set `disabled = false` to enable.
        """
        pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        The status of the Istio addon, which makes it easy to set up Istio for services in a
        cluster. It is disabled by default. Set `disabled = false` to enable.
        """
        return pulumi.get(self, "disabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterAddonsConfigHttpLoadBalancing(dict):
    def __init__(__self__, *,
                 disabled: bool):
        """
        :param bool disabled: The status of the Istio addon, which makes it easy to set up Istio for services in a
               cluster. It is disabled by default. Set `disabled = false` to enable.
        """
        pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        The status of the Istio addon, which makes it easy to set up Istio for services in a
        cluster. It is disabled by default. Set `disabled = false` to enable.
        """
        return pulumi.get(self, "disabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterAddonsConfigIstioConfig(dict):
    def __init__(__self__, *,
                 disabled: bool,
                 auth: Optional[str] = None):
        """
        :param bool disabled: The status of the Istio addon, which makes it easy to set up Istio for services in a
               cluster. It is disabled by default. Set `disabled = false` to enable.
        :param str auth: The authentication type between services in Istio. Available options include `AUTH_MUTUAL_TLS`.
        """
        pulumi.set(__self__, "disabled", disabled)
        if auth is not None:
            pulumi.set(__self__, "auth", auth)

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        The status of the Istio addon, which makes it easy to set up Istio for services in a
        cluster. It is disabled by default. Set `disabled = false` to enable.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def auth(self) -> Optional[str]:
        """
        The authentication type between services in Istio. Available options include `AUTH_MUTUAL_TLS`.
        """
        return pulumi.get(self, "auth")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterAddonsConfigKalmConfig(dict):
    def __init__(__self__, *,
                 enabled: bool):
        """
        :param bool enabled: Enable the PodSecurityPolicy controller for this cluster.
               If enabled, pods must be valid under a PodSecurityPolicy to be created.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Enable the PodSecurityPolicy controller for this cluster.
        If enabled, pods must be valid under a PodSecurityPolicy to be created.
        """
        return pulumi.get(self, "enabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterAddonsConfigNetworkPolicyConfig(dict):
    def __init__(__self__, *,
                 disabled: bool):
        """
        :param bool disabled: The status of the Istio addon, which makes it easy to set up Istio for services in a
               cluster. It is disabled by default. Set `disabled = false` to enable.
        """
        pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        The status of the Istio addon, which makes it easy to set up Istio for services in a
        cluster. It is disabled by default. Set `disabled = false` to enable.
        """
        return pulumi.get(self, "disabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterAuthenticatorGroupsConfig(dict):
    def __init__(__self__, *,
                 security_group: str):
        """
        :param str security_group: The name of the RBAC security group for use with Google security groups in Kubernetes RBAC. Group name must be in format `gke-security-groups@yourdomain.com`.
        """
        pulumi.set(__self__, "security_group", security_group)

    @property
    @pulumi.getter(name="securityGroup")
    def security_group(self) -> str:
        """
        The name of the RBAC security group for use with Google security groups in Kubernetes RBAC. Group name must be in format `gke-security-groups@yourdomain.com`.
        """
        return pulumi.get(self, "security_group")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterClusterAutoscaling(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 auto_provisioning_defaults: Optional['outputs.ClusterClusterAutoscalingAutoProvisioningDefaults'] = None,
                 autoscaling_profile: Optional[str] = None,
                 resource_limits: Optional[Sequence['outputs.ClusterClusterAutoscalingResourceLimit']] = None):
        """
        :param bool enabled: Enable the PodSecurityPolicy controller for this cluster.
               If enabled, pods must be valid under a PodSecurityPolicy to be created.
        :param 'ClusterClusterAutoscalingAutoProvisioningDefaultsArgs' auto_provisioning_defaults: Contains defaults for a node pool created by NAP.
               Structure is documented below.
        :param str autoscaling_profile: ) Configuration
               options for the [Autoscaling profile](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-autoscaler#autoscaling_profiles)
               feature, which lets you choose whether the cluster autoscaler should optimize for resource utilization or resource availability
               when deciding to remove nodes from a cluster. Can be `BALANCED` or `OPTIMIZE_UTILIZATION`. Defaults to `BALANCED`.
        :param Sequence['ClusterClusterAutoscalingResourceLimitArgs'] resource_limits: Global constraints for machine resources in the
               cluster. Configuring the `cpu` and `memory` types is required if node
               auto-provisioning is enabled. These limits will apply to node pool autoscaling
               in addition to node auto-provisioning. Structure is documented below.
        """
        pulumi.set(__self__, "enabled", enabled)
        if auto_provisioning_defaults is not None:
            pulumi.set(__self__, "auto_provisioning_defaults", auto_provisioning_defaults)
        if autoscaling_profile is not None:
            pulumi.set(__self__, "autoscaling_profile", autoscaling_profile)
        if resource_limits is not None:
            pulumi.set(__self__, "resource_limits", resource_limits)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Enable the PodSecurityPolicy controller for this cluster.
        If enabled, pods must be valid under a PodSecurityPolicy to be created.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="autoProvisioningDefaults")
    def auto_provisioning_defaults(self) -> Optional['outputs.ClusterClusterAutoscalingAutoProvisioningDefaults']:
        """
        Contains defaults for a node pool created by NAP.
        Structure is documented below.
        """
        return pulumi.get(self, "auto_provisioning_defaults")

    @property
    @pulumi.getter(name="autoscalingProfile")
    def autoscaling_profile(self) -> Optional[str]:
        """
        ) Configuration
        options for the [Autoscaling profile](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-autoscaler#autoscaling_profiles)
        feature, which lets you choose whether the cluster autoscaler should optimize for resource utilization or resource availability
        when deciding to remove nodes from a cluster. Can be `BALANCED` or `OPTIMIZE_UTILIZATION`. Defaults to `BALANCED`.
        """
        return pulumi.get(self, "autoscaling_profile")

    @property
    @pulumi.getter(name="resourceLimits")
    def resource_limits(self) -> Optional[Sequence['outputs.ClusterClusterAutoscalingResourceLimit']]:
        """
        Global constraints for machine resources in the
        cluster. Configuring the `cpu` and `memory` types is required if node
        auto-provisioning is enabled. These limits will apply to node pool autoscaling
        in addition to node auto-provisioning. Structure is documented below.
        """
        return pulumi.get(self, "resource_limits")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterClusterAutoscalingAutoProvisioningDefaults(dict):
    def __init__(__self__, *,
                 min_cpu_platform: Optional[str] = None,
                 oauth_scopes: Optional[Sequence[str]] = None,
                 service_account: Optional[str] = None):
        """
        :param str min_cpu_platform: Minimum CPU platform to be used by this instance.
               The instance may be scheduled on the specified or newer CPU platform. Applicable
               values are the friendly names of CPU platforms, such as `Intel Haswell`. See the
               [official documentation](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
               for more information.
        :param Sequence[str] oauth_scopes: The set of Google API scopes to be made available
               on all of the node VMs under the "default" service account.
               Use the "https://www.googleapis.com/auth/cloud-platform" scope to grant access to all APIs. It is recommended that you set `service_account` to a non-default service account and grant IAM roles to that service account for only the resources that it needs.
        :param str service_account: The service account to be used by the Node VMs.
               If not specified, the "default" service account is used.
        """
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if oauth_scopes is not None:
            pulumi.set(__self__, "oauth_scopes", oauth_scopes)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[str]:
        """
        Minimum CPU platform to be used by this instance.
        The instance may be scheduled on the specified or newer CPU platform. Applicable
        values are the friendly names of CPU platforms, such as `Intel Haswell`. See the
        [official documentation](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
        for more information.
        """
        return pulumi.get(self, "min_cpu_platform")

    @property
    @pulumi.getter(name="oauthScopes")
    def oauth_scopes(self) -> Optional[Sequence[str]]:
        """
        The set of Google API scopes to be made available
        on all of the node VMs under the "default" service account.
        Use the "https://www.googleapis.com/auth/cloud-platform" scope to grant access to all APIs. It is recommended that you set `service_account` to a non-default service account and grant IAM roles to that service account for only the resources that it needs.
        """
        return pulumi.get(self, "oauth_scopes")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[str]:
        """
        The service account to be used by the Node VMs.
        If not specified, the "default" service account is used.
        """
        return pulumi.get(self, "service_account")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterClusterAutoscalingResourceLimit(dict):
    def __init__(__self__, *,
                 resource_type: str,
                 maximum: Optional[int] = None,
                 minimum: Optional[int] = None):
        """
        :param str resource_type: The type of the resource. For example, `cpu` and
               `memory`.  See the [guide to using Node Auto-Provisioning](https://cloud.google.com/kubernetes-engine/docs/how-to/node-auto-provisioning)
               for a list of types.
        :param int maximum: Maximum amount of the resource in the cluster.
        :param int minimum: Minimum amount of the resource in the cluster.
        """
        pulumi.set(__self__, "resource_type", resource_type)
        if maximum is not None:
            pulumi.set(__self__, "maximum", maximum)
        if minimum is not None:
            pulumi.set(__self__, "minimum", minimum)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        The type of the resource. For example, `cpu` and
        `memory`.  See the [guide to using Node Auto-Provisioning](https://cloud.google.com/kubernetes-engine/docs/how-to/node-auto-provisioning)
        for a list of types.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def maximum(self) -> Optional[int]:
        """
        Maximum amount of the resource in the cluster.
        """
        return pulumi.get(self, "maximum")

    @property
    @pulumi.getter
    def minimum(self) -> Optional[int]:
        """
        Minimum amount of the resource in the cluster.
        """
        return pulumi.get(self, "minimum")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterClusterTelemetry(dict):
    def __init__(__self__, *,
                 type: str):
        """
        :param str type: The accelerator type resource to expose to this instance. E.g. `nvidia-tesla-k80`.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The accelerator type resource to expose to this instance. E.g. `nvidia-tesla-k80`.
        """
        return pulumi.get(self, "type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterConfidentialNodes(dict):
    def __init__(__self__, *,
                 enabled: bool):
        """
        :param bool enabled: Enable the PodSecurityPolicy controller for this cluster.
               If enabled, pods must be valid under a PodSecurityPolicy to be created.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Enable the PodSecurityPolicy controller for this cluster.
        If enabled, pods must be valid under a PodSecurityPolicy to be created.
        """
        return pulumi.get(self, "enabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterDatabaseEncryption(dict):
    def __init__(__self__, *,
                 state: str,
                 key_name: Optional[str] = None):
        """
        :param str state: `ENCRYPTED` or `DECRYPTED`
        :param str key_name: the key to use to encrypt/decrypt secrets.  See the [DatabaseEncryption definition](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1beta1/projects.locations.clusters#Cluster.DatabaseEncryption) for more information.
        """
        pulumi.set(__self__, "state", state)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        `ENCRYPTED` or `DECRYPTED`
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[str]:
        """
        the key to use to encrypt/decrypt secrets.  See the [DatabaseEncryption definition](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1beta1/projects.locations.clusters#Cluster.DatabaseEncryption) for more information.
        """
        return pulumi.get(self, "key_name")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterDefaultSnatStatus(dict):
    def __init__(__self__, *,
                 disabled: bool):
        """
        :param bool disabled: The status of the Istio addon, which makes it easy to set up Istio for services in a
               cluster. It is disabled by default. Set `disabled = false` to enable.
        """
        pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        The status of the Istio addon, which makes it easy to set up Istio for services in a
        cluster. It is disabled by default. Set `disabled = false` to enable.
        """
        return pulumi.get(self, "disabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterIpAllocationPolicy(dict):
    def __init__(__self__, *,
                 cluster_ipv4_cidr_block: Optional[str] = None,
                 cluster_secondary_range_name: Optional[str] = None,
                 services_ipv4_cidr_block: Optional[str] = None,
                 services_secondary_range_name: Optional[str] = None):
        """
        :param str cluster_ipv4_cidr_block: The IP address range for the cluster pod IPs.
               Set to blank to have a range chosen with the default size. Set to /netmask (e.g. /14)
               to have a range chosen with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14)
               from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to
               pick a specific range to use.
        :param str cluster_secondary_range_name: The name of the existing secondary
               range in the cluster's subnetwork to use for pod IP addresses. Alternatively,
               `cluster_ipv4_cidr_block` can be used to automatically create a GKE-managed one.
        :param str services_ipv4_cidr_block: The IP address range of the services IPs in this cluster.
               Set to blank to have a range chosen with the default size. Set to /netmask (e.g. /14)
               to have a range chosen with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14)
               from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to
               pick a specific range to use.
        :param str services_secondary_range_name: The name of the existing
               secondary range in the cluster's subnetwork to use for service `ClusterIP`s.
               Alternatively, `services_ipv4_cidr_block` can be used to automatically create a
               GKE-managed one.
        """
        if cluster_ipv4_cidr_block is not None:
            pulumi.set(__self__, "cluster_ipv4_cidr_block", cluster_ipv4_cidr_block)
        if cluster_secondary_range_name is not None:
            pulumi.set(__self__, "cluster_secondary_range_name", cluster_secondary_range_name)
        if services_ipv4_cidr_block is not None:
            pulumi.set(__self__, "services_ipv4_cidr_block", services_ipv4_cidr_block)
        if services_secondary_range_name is not None:
            pulumi.set(__self__, "services_secondary_range_name", services_secondary_range_name)

    @property
    @pulumi.getter(name="clusterIpv4CidrBlock")
    def cluster_ipv4_cidr_block(self) -> Optional[str]:
        """
        The IP address range for the cluster pod IPs.
        Set to blank to have a range chosen with the default size. Set to /netmask (e.g. /14)
        to have a range chosen with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14)
        from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to
        pick a specific range to use.
        """
        return pulumi.get(self, "cluster_ipv4_cidr_block")

    @property
    @pulumi.getter(name="clusterSecondaryRangeName")
    def cluster_secondary_range_name(self) -> Optional[str]:
        """
        The name of the existing secondary
        range in the cluster's subnetwork to use for pod IP addresses. Alternatively,
        `cluster_ipv4_cidr_block` can be used to automatically create a GKE-managed one.
        """
        return pulumi.get(self, "cluster_secondary_range_name")

    @property
    @pulumi.getter(name="servicesIpv4CidrBlock")
    def services_ipv4_cidr_block(self) -> Optional[str]:
        """
        The IP address range of the services IPs in this cluster.
        Set to blank to have a range chosen with the default size. Set to /netmask (e.g. /14)
        to have a range chosen with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14)
        from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to
        pick a specific range to use.
        """
        return pulumi.get(self, "services_ipv4_cidr_block")

    @property
    @pulumi.getter(name="servicesSecondaryRangeName")
    def services_secondary_range_name(self) -> Optional[str]:
        """
        The name of the existing
        secondary range in the cluster's subnetwork to use for service `ClusterIP`s.
        Alternatively, `services_ipv4_cidr_block` can be used to automatically create a
        GKE-managed one.
        """
        return pulumi.get(self, "services_secondary_range_name")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterMaintenancePolicy(dict):
    def __init__(__self__, *,
                 daily_maintenance_window: Optional['outputs.ClusterMaintenancePolicyDailyMaintenanceWindow'] = None,
                 maintenance_exclusions: Optional[Sequence['outputs.ClusterMaintenancePolicyMaintenanceExclusion']] = None,
                 recurring_window: Optional['outputs.ClusterMaintenancePolicyRecurringWindow'] = None):
        """
        :param 'ClusterMaintenancePolicyDailyMaintenanceWindowArgs' daily_maintenance_window: Time window specified for daily maintenance operations.
               Specify `start_time` in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) format "HH:MM”,
               where HH : \[00-23\] and MM : \[00-59\] GMT. For example:
        :param Sequence['ClusterMaintenancePolicyMaintenanceExclusionArgs'] maintenance_exclusions: Exceptions to maintenance window. Non-emergency maintenance should not occur in these windows. A cluster can have up to three maintenance exclusions at a time [Maintenance Window and Exclusions](https://cloud.google.com/kubernetes-engine/docs/concepts/maintenance-windows-and-exclusions)
        :param 'ClusterMaintenancePolicyRecurringWindowArgs' recurring_window: Time window for recurring maintenance operations.
        """
        if daily_maintenance_window is not None:
            pulumi.set(__self__, "daily_maintenance_window", daily_maintenance_window)
        if maintenance_exclusions is not None:
            pulumi.set(__self__, "maintenance_exclusions", maintenance_exclusions)
        if recurring_window is not None:
            pulumi.set(__self__, "recurring_window", recurring_window)

    @property
    @pulumi.getter(name="dailyMaintenanceWindow")
    def daily_maintenance_window(self) -> Optional['outputs.ClusterMaintenancePolicyDailyMaintenanceWindow']:
        """
        Time window specified for daily maintenance operations.
        Specify `start_time` in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) format "HH:MM”,
        where HH : \[00-23\] and MM : \[00-59\] GMT. For example:
        """
        return pulumi.get(self, "daily_maintenance_window")

    @property
    @pulumi.getter(name="maintenanceExclusions")
    def maintenance_exclusions(self) -> Optional[Sequence['outputs.ClusterMaintenancePolicyMaintenanceExclusion']]:
        """
        Exceptions to maintenance window. Non-emergency maintenance should not occur in these windows. A cluster can have up to three maintenance exclusions at a time [Maintenance Window and Exclusions](https://cloud.google.com/kubernetes-engine/docs/concepts/maintenance-windows-and-exclusions)
        """
        return pulumi.get(self, "maintenance_exclusions")

    @property
    @pulumi.getter(name="recurringWindow")
    def recurring_window(self) -> Optional['outputs.ClusterMaintenancePolicyRecurringWindow']:
        """
        Time window for recurring maintenance operations.
        """
        return pulumi.get(self, "recurring_window")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterMaintenancePolicyDailyMaintenanceWindow(dict):
    def __init__(__self__, *,
                 start_time: str,
                 duration: Optional[str] = None):
        pulumi.set(__self__, "start_time", start_time)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def duration(self) -> Optional[str]:
        return pulumi.get(self, "duration")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterMaintenancePolicyMaintenanceExclusion(dict):
    def __init__(__self__, *,
                 end_time: str,
                 exclusion_name: str,
                 start_time: str):
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "exclusion_name", exclusion_name)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="exclusionName")
    def exclusion_name(self) -> str:
        return pulumi.get(self, "exclusion_name")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        return pulumi.get(self, "start_time")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterMaintenancePolicyRecurringWindow(dict):
    def __init__(__self__, *,
                 end_time: str,
                 recurrence: str,
                 start_time: str):
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "recurrence", recurrence)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def recurrence(self) -> str:
        return pulumi.get(self, "recurrence")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        return pulumi.get(self, "start_time")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterMasterAuth(dict):
    def __init__(__self__, *,
                 client_certificate: Optional[str] = None,
                 client_certificate_config: Optional['outputs.ClusterMasterAuthClientCertificateConfig'] = None,
                 client_key: Optional[str] = None,
                 cluster_ca_certificate: Optional[str] = None,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param 'ClusterMasterAuthClientCertificateConfigArgs' client_certificate_config: Whether client certificate authorization is enabled for this cluster.  For example:
        :param str password: The password to use for HTTP basic authentication when accessing
               the Kubernetes master endpoint. This has been deprecated as of GKE 1.19.
        :param str username: The username to use for HTTP basic authentication when accessing
               the Kubernetes master endpoint. If not present basic auth will be disabled. This has been deprecated as of GKE 1.19.
        """
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_certificate_config is not None:
            pulumi.set(__self__, "client_certificate_config", client_certificate_config)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if cluster_ca_certificate is not None:
            pulumi.set(__self__, "cluster_ca_certificate", cluster_ca_certificate)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[str]:
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientCertificateConfig")
    def client_certificate_config(self) -> Optional['outputs.ClusterMasterAuthClientCertificateConfig']:
        """
        Whether client certificate authorization is enabled for this cluster.  For example:
        """
        return pulumi.get(self, "client_certificate_config")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[str]:
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> Optional[str]:
        return pulumi.get(self, "cluster_ca_certificate")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The password to use for HTTP basic authentication when accessing
        the Kubernetes master endpoint. This has been deprecated as of GKE 1.19.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        The username to use for HTTP basic authentication when accessing
        the Kubernetes master endpoint. If not present basic auth will be disabled. This has been deprecated as of GKE 1.19.
        """
        return pulumi.get(self, "username")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterMasterAuthClientCertificateConfig(dict):
    def __init__(__self__, *,
                 issue_client_certificate: bool):
        pulumi.set(__self__, "issue_client_certificate", issue_client_certificate)

    @property
    @pulumi.getter(name="issueClientCertificate")
    def issue_client_certificate(self) -> bool:
        return pulumi.get(self, "issue_client_certificate")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterMasterAuthorizedNetworksConfig(dict):
    def __init__(__self__, *,
                 cidr_blocks: Optional[Sequence['outputs.ClusterMasterAuthorizedNetworksConfigCidrBlock']] = None):
        """
        :param Sequence['ClusterMasterAuthorizedNetworksConfigCidrBlockArgs'] cidr_blocks: External networks that can access the
               Kubernetes cluster master through HTTPS.
        """
        if cidr_blocks is not None:
            pulumi.set(__self__, "cidr_blocks", cidr_blocks)

    @property
    @pulumi.getter(name="cidrBlocks")
    def cidr_blocks(self) -> Optional[Sequence['outputs.ClusterMasterAuthorizedNetworksConfigCidrBlock']]:
        """
        External networks that can access the
        Kubernetes cluster master through HTTPS.
        """
        return pulumi.get(self, "cidr_blocks")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterMasterAuthorizedNetworksConfigCidrBlock(dict):
    def __init__(__self__, *,
                 cidr_block: str,
                 display_name: Optional[str] = None):
        """
        :param str cidr_block: External network that can access Kubernetes master through HTTPS.
               Must be specified in CIDR notation.
        :param str display_name: Field for users to identify CIDR blocks.
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> str:
        """
        External network that can access Kubernetes master through HTTPS.
        Must be specified in CIDR notation.
        """
        return pulumi.get(self, "cidr_block")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Field for users to identify CIDR blocks.
        """
        return pulumi.get(self, "display_name")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterNetworkPolicy(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 provider: Optional[str] = None):
        """
        :param bool enabled: Enable the PodSecurityPolicy controller for this cluster.
               If enabled, pods must be valid under a PodSecurityPolicy to be created.
        :param str provider: The selected network policy provider. Defaults to PROVIDER_UNSPECIFIED.
        """
        pulumi.set(__self__, "enabled", enabled)
        if provider is not None:
            pulumi.set(__self__, "provider", provider)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Enable the PodSecurityPolicy controller for this cluster.
        If enabled, pods must be valid under a PodSecurityPolicy to be created.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def provider(self) -> Optional[str]:
        """
        The selected network policy provider. Defaults to PROVIDER_UNSPECIFIED.
        """
        return pulumi.get(self, "provider")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterNodeConfig(dict):
    def __init__(__self__, *,
                 boot_disk_kms_key: Optional[str] = None,
                 disk_size_gb: Optional[int] = None,
                 disk_type: Optional[str] = None,
                 guest_accelerators: Optional[Sequence['outputs.ClusterNodeConfigGuestAccelerator']] = None,
                 image_type: Optional[str] = None,
                 kubelet_config: Optional['outputs.ClusterNodeConfigKubeletConfig'] = None,
                 labels: Optional[Mapping[str, str]] = None,
                 linux_node_config: Optional['outputs.ClusterNodeConfigLinuxNodeConfig'] = None,
                 local_ssd_count: Optional[int] = None,
                 machine_type: Optional[str] = None,
                 metadata: Optional[Mapping[str, str]] = None,
                 min_cpu_platform: Optional[str] = None,
                 oauth_scopes: Optional[Sequence[str]] = None,
                 preemptible: Optional[bool] = None,
                 sandbox_config: Optional['outputs.ClusterNodeConfigSandboxConfig'] = None,
                 service_account: Optional[str] = None,
                 shielded_instance_config: Optional['outputs.ClusterNodeConfigShieldedInstanceConfig'] = None,
                 tags: Optional[Sequence[str]] = None,
                 taints: Optional[Sequence['outputs.ClusterNodeConfigTaint']] = None,
                 workload_metadata_config: Optional['outputs.ClusterNodeConfigWorkloadMetadataConfig'] = None):
        """
        :param str boot_disk_kms_key: The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool. This should be of the form projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME]. For more information about protecting resources with Cloud KMS Keys please see: https://cloud.google.com/compute/docs/disks/customer-managed-encryption
        :param int disk_size_gb: Size of the disk attached to each node, specified
               in GB. The smallest allowed disk size is 10GB. Defaults to 100GB.
        :param str disk_type: Type of the disk attached to each node
               (e.g. 'pd-standard', 'pd-balanced' or 'pd-ssd'). If unspecified, the default disk type is 'pd-standard'
        :param Sequence['ClusterNodeConfigGuestAcceleratorArgs'] guest_accelerators: List of the type and count of accelerator cards attached to the instance.
               Structure documented below.
        :param str image_type: The image type to use for this node. Note that changing the image type
               will delete and recreate all nodes in the node pool.
        :param 'ClusterNodeConfigKubeletConfigArgs' kubelet_config: Kubelet configuration, currently supported attributes can be found [here](https://cloud.google.com/sdk/gcloud/reference/beta/container/node-pools/create#--system-config-from-file).
               Structure is documented below.
        :param Mapping[str, str] labels: The Kubernetes labels (key/value pairs) to be applied to each node. The kubernetes.io/ and k8s.io/ prefixes are
               reserved by Kubernetes Core components and cannot be specified.
        :param 'ClusterNodeConfigLinuxNodeConfigArgs' linux_node_config: Linux node configuration, currently supported attributes can be found [here](https://cloud.google.com/sdk/gcloud/reference/beta/container/node-pools/create#--system-config-from-file).
               Note that validations happen all server side. All attributes are optional.
               Structure is documented below.
        :param int local_ssd_count: The amount of local SSD disks that will be
               attached to each cluster node. Defaults to 0.
        :param str machine_type: The name of a Google Compute Engine machine type.
               Defaults to `e2-medium`. To create a custom machine type, value should be set as specified
               [here](https://cloud.google.com/compute/docs/reference/latest/instances#machineType).
        :param Mapping[str, str] metadata: The metadata key/value pairs assigned to instances in
               the cluster. From GKE `1.12` onwards, `disable-legacy-endpoints` is set to
               `true` by the API; if `metadata` is set but that default value is not
               included, the provider will attempt to unset the value. To avoid this, set the
               value in your config.
        :param str min_cpu_platform: Minimum CPU platform to be used by this instance.
               The instance may be scheduled on the specified or newer CPU platform. Applicable
               values are the friendly names of CPU platforms, such as `Intel Haswell`. See the
               [official documentation](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
               for more information.
        :param Sequence[str] oauth_scopes: The set of Google API scopes to be made available
               on all of the node VMs under the "default" service account.
               Use the "https://www.googleapis.com/auth/cloud-platform" scope to grant access to all APIs. It is recommended that you set `service_account` to a non-default service account and grant IAM roles to that service account for only the resources that it needs.
        :param bool preemptible: A boolean that represents whether or not the underlying node VMs
               are preemptible. See the [official documentation](https://cloud.google.com/container-engine/docs/preemptible-vm)
               for more information. Defaults to false.
        :param 'ClusterNodeConfigSandboxConfigArgs' sandbox_config: [GKE Sandbox](https://cloud.google.com/kubernetes-engine/docs/how-to/sandbox-pods) configuration. When enabling this feature you must specify `image_type = "COS_CONTAINERD"` and `node_version = "1.12.7-gke.17"` or later to use it.
               Structure is documented below.
        :param str service_account: The service account to be used by the Node VMs.
               If not specified, the "default" service account is used.
        :param 'ClusterNodeConfigShieldedInstanceConfigArgs' shielded_instance_config: Shielded Instance options. Structure is documented below.
        :param Sequence[str] tags: The list of instance tags applied to all nodes. Tags are used to identify
               valid sources or targets for network firewalls.
        :param Sequence['ClusterNodeConfigTaintArgs'] taints: A list of [Kubernetes taints](https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/)
               to apply to nodes. GKE's API can only set this field on cluster creation.
               However, GKE will add taints to your nodes if you enable certain features such
               as GPUs. If this field is set, any diffs on this field will cause the provider to
               recreate the underlying resource. Taint values can be updated safely in
               Kubernetes (eg. through `kubectl`), and it's recommended that you do not use
               this field to manage taints. If you do, `lifecycle.ignore_changes` is
               recommended. Structure is documented below.
        :param 'ClusterNodeConfigWorkloadMetadataConfigArgs' workload_metadata_config: Metadata configuration to expose to workloads on the node pool.
               Structure is documented below.
        """
        if boot_disk_kms_key is not None:
            pulumi.set(__self__, "boot_disk_kms_key", boot_disk_kms_key)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if guest_accelerators is not None:
            pulumi.set(__self__, "guest_accelerators", guest_accelerators)
        if image_type is not None:
            pulumi.set(__self__, "image_type", image_type)
        if kubelet_config is not None:
            pulumi.set(__self__, "kubelet_config", kubelet_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if linux_node_config is not None:
            pulumi.set(__self__, "linux_node_config", linux_node_config)
        if local_ssd_count is not None:
            pulumi.set(__self__, "local_ssd_count", local_ssd_count)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if oauth_scopes is not None:
            pulumi.set(__self__, "oauth_scopes", oauth_scopes)
        if preemptible is not None:
            pulumi.set(__self__, "preemptible", preemptible)
        if sandbox_config is not None:
            pulumi.set(__self__, "sandbox_config", sandbox_config)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if workload_metadata_config is not None:
            pulumi.set(__self__, "workload_metadata_config", workload_metadata_config)

    @property
    @pulumi.getter(name="bootDiskKmsKey")
    def boot_disk_kms_key(self) -> Optional[str]:
        """
        The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool. This should be of the form projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME]. For more information about protecting resources with Cloud KMS Keys please see: https://cloud.google.com/compute/docs/disks/customer-managed-encryption
        """
        return pulumi.get(self, "boot_disk_kms_key")

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[int]:
        """
        Size of the disk attached to each node, specified
        in GB. The smallest allowed disk size is 10GB. Defaults to 100GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[str]:
        """
        Type of the disk attached to each node
        (e.g. 'pd-standard', 'pd-balanced' or 'pd-ssd'). If unspecified, the default disk type is 'pd-standard'
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="guestAccelerators")
    def guest_accelerators(self) -> Optional[Sequence['outputs.ClusterNodeConfigGuestAccelerator']]:
        """
        List of the type and count of accelerator cards attached to the instance.
        Structure documented below.
        """
        return pulumi.get(self, "guest_accelerators")

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[str]:
        """
        The image type to use for this node. Note that changing the image type
        will delete and recreate all nodes in the node pool.
        """
        return pulumi.get(self, "image_type")

    @property
    @pulumi.getter(name="kubeletConfig")
    def kubelet_config(self) -> Optional['outputs.ClusterNodeConfigKubeletConfig']:
        """
        Kubelet configuration, currently supported attributes can be found [here](https://cloud.google.com/sdk/gcloud/reference/beta/container/node-pools/create#--system-config-from-file).
        Structure is documented below.
        """
        return pulumi.get(self, "kubelet_config")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        """
        The Kubernetes labels (key/value pairs) to be applied to each node. The kubernetes.io/ and k8s.io/ prefixes are
        reserved by Kubernetes Core components and cannot be specified.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="linuxNodeConfig")
    def linux_node_config(self) -> Optional['outputs.ClusterNodeConfigLinuxNodeConfig']:
        """
        Linux node configuration, currently supported attributes can be found [here](https://cloud.google.com/sdk/gcloud/reference/beta/container/node-pools/create#--system-config-from-file).
        Note that validations happen all server side. All attributes are optional.
        Structure is documented below.
        """
        return pulumi.get(self, "linux_node_config")

    @property
    @pulumi.getter(name="localSsdCount")
    def local_ssd_count(self) -> Optional[int]:
        """
        The amount of local SSD disks that will be
        attached to each cluster node. Defaults to 0.
        """
        return pulumi.get(self, "local_ssd_count")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[str]:
        """
        The name of a Google Compute Engine machine type.
        Defaults to `e2-medium`. To create a custom machine type, value should be set as specified
        [here](https://cloud.google.com/compute/docs/reference/latest/instances#machineType).
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Mapping[str, str]]:
        """
        The metadata key/value pairs assigned to instances in
        the cluster. From GKE `1.12` onwards, `disable-legacy-endpoints` is set to
        `true` by the API; if `metadata` is set but that default value is not
        included, the provider will attempt to unset the value. To avoid this, set the
        value in your config.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[str]:
        """
        Minimum CPU platform to be used by this instance.
        The instance may be scheduled on the specified or newer CPU platform. Applicable
        values are the friendly names of CPU platforms, such as `Intel Haswell`. See the
        [official documentation](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
        for more information.
        """
        return pulumi.get(self, "min_cpu_platform")

    @property
    @pulumi.getter(name="oauthScopes")
    def oauth_scopes(self) -> Optional[Sequence[str]]:
        """
        The set of Google API scopes to be made available
        on all of the node VMs under the "default" service account.
        Use the "https://www.googleapis.com/auth/cloud-platform" scope to grant access to all APIs. It is recommended that you set `service_account` to a non-default service account and grant IAM roles to that service account for only the resources that it needs.
        """
        return pulumi.get(self, "oauth_scopes")

    @property
    @pulumi.getter
    def preemptible(self) -> Optional[bool]:
        """
        A boolean that represents whether or not the underlying node VMs
        are preemptible. See the [official documentation](https://cloud.google.com/container-engine/docs/preemptible-vm)
        for more information. Defaults to false.
        """
        return pulumi.get(self, "preemptible")

    @property
    @pulumi.getter(name="sandboxConfig")
    def sandbox_config(self) -> Optional['outputs.ClusterNodeConfigSandboxConfig']:
        """
        [GKE Sandbox](https://cloud.google.com/kubernetes-engine/docs/how-to/sandbox-pods) configuration. When enabling this feature you must specify `image_type = "COS_CONTAINERD"` and `node_version = "1.12.7-gke.17"` or later to use it.
        Structure is documented below.
        """
        return pulumi.get(self, "sandbox_config")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[str]:
        """
        The service account to be used by the Node VMs.
        If not specified, the "default" service account is used.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional['outputs.ClusterNodeConfigShieldedInstanceConfig']:
        """
        Shielded Instance options. Structure is documented below.
        """
        return pulumi.get(self, "shielded_instance_config")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The list of instance tags applied to all nodes. Tags are used to identify
        valid sources or targets for network firewalls.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def taints(self) -> Optional[Sequence['outputs.ClusterNodeConfigTaint']]:
        """
        A list of [Kubernetes taints](https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/)
        to apply to nodes. GKE's API can only set this field on cluster creation.
        However, GKE will add taints to your nodes if you enable certain features such
        as GPUs. If this field is set, any diffs on this field will cause the provider to
        recreate the underlying resource. Taint values can be updated safely in
        Kubernetes (eg. through `kubectl`), and it's recommended that you do not use
        this field to manage taints. If you do, `lifecycle.ignore_changes` is
        recommended. Structure is documented below.
        """
        return pulumi.get(self, "taints")

    @property
    @pulumi.getter(name="workloadMetadataConfig")
    def workload_metadata_config(self) -> Optional['outputs.ClusterNodeConfigWorkloadMetadataConfig']:
        """
        Metadata configuration to expose to workloads on the node pool.
        Structure is documented below.
        """
        return pulumi.get(self, "workload_metadata_config")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterNodeConfigGuestAccelerator(dict):
    def __init__(__self__, *,
                 count: int,
                 type: str):
        """
        :param int count: The number of the guest accelerator cards exposed to this instance.
        :param str type: The accelerator type resource to expose to this instance. E.g. `nvidia-tesla-k80`.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def count(self) -> int:
        """
        The number of the guest accelerator cards exposed to this instance.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The accelerator type resource to expose to this instance. E.g. `nvidia-tesla-k80`.
        """
        return pulumi.get(self, "type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterNodeConfigKubeletConfig(dict):
    def __init__(__self__, *,
                 cpu_manager_policy: str,
                 cpu_cfs_quota: Optional[bool] = None,
                 cpu_cfs_quota_period: Optional[str] = None):
        """
        :param str cpu_manager_policy: The CPU management policy on the node. See
               [K8S CPU Management Policies](https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/).
               One of `"none"` or `"static"`. Defaults to `none` when `kubelet_config` is unset.
        :param bool cpu_cfs_quota: If true, enables CPU CFS quota enforcement for
               containers that specify CPU limits.
        :param str cpu_cfs_quota_period: The CPU CFS quota period value. Specified
               as a sequence of decimal numbers, each with optional fraction and a unit suffix,
               such as `"300ms"`. Valid time units are "ns", "us" (or "µs"), "ms", "s", "m",
               "h". The value must be a positive duration.
        """
        pulumi.set(__self__, "cpu_manager_policy", cpu_manager_policy)
        if cpu_cfs_quota is not None:
            pulumi.set(__self__, "cpu_cfs_quota", cpu_cfs_quota)
        if cpu_cfs_quota_period is not None:
            pulumi.set(__self__, "cpu_cfs_quota_period", cpu_cfs_quota_period)

    @property
    @pulumi.getter(name="cpuManagerPolicy")
    def cpu_manager_policy(self) -> str:
        """
        The CPU management policy on the node. See
        [K8S CPU Management Policies](https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/).
        One of `"none"` or `"static"`. Defaults to `none` when `kubelet_config` is unset.
        """
        return pulumi.get(self, "cpu_manager_policy")

    @property
    @pulumi.getter(name="cpuCfsQuota")
    def cpu_cfs_quota(self) -> Optional[bool]:
        """
        If true, enables CPU CFS quota enforcement for
        containers that specify CPU limits.
        """
        return pulumi.get(self, "cpu_cfs_quota")

    @property
    @pulumi.getter(name="cpuCfsQuotaPeriod")
    def cpu_cfs_quota_period(self) -> Optional[str]:
        """
        The CPU CFS quota period value. Specified
        as a sequence of decimal numbers, each with optional fraction and a unit suffix,
        such as `"300ms"`. Valid time units are "ns", "us" (or "µs"), "ms", "s", "m",
        "h". The value must be a positive duration.
        """
        return pulumi.get(self, "cpu_cfs_quota_period")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterNodeConfigLinuxNodeConfig(dict):
    def __init__(__self__, *,
                 sysctls: Mapping[str, str]):
        """
        :param Mapping[str, str] sysctls: The Linux kernel parameters to be applied to the nodes
               and all pods running on the nodes. Specified as a map from the key, such as
               `net.core.wmem_max`, to a string value.
        """
        pulumi.set(__self__, "sysctls", sysctls)

    @property
    @pulumi.getter
    def sysctls(self) -> Mapping[str, str]:
        """
        The Linux kernel parameters to be applied to the nodes
        and all pods running on the nodes. Specified as a map from the key, such as
        `net.core.wmem_max`, to a string value.
        """
        return pulumi.get(self, "sysctls")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterNodeConfigSandboxConfig(dict):
    def __init__(__self__, *,
                 sandbox_type: str):
        """
        :param str sandbox_type: Which sandbox to use for pods in the node pool.
               Accepted values are:
        """
        pulumi.set(__self__, "sandbox_type", sandbox_type)

    @property
    @pulumi.getter(name="sandboxType")
    def sandbox_type(self) -> str:
        """
        Which sandbox to use for pods in the node pool.
        Accepted values are:
        """
        return pulumi.get(self, "sandbox_type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterNodeConfigShieldedInstanceConfig(dict):
    def __init__(__self__, *,
                 enable_integrity_monitoring: Optional[bool] = None,
                 enable_secure_boot: Optional[bool] = None):
        """
        :param bool enable_integrity_monitoring: Defines if the instance has integrity monitoring enabled.
        :param bool enable_secure_boot: Defines if the instance has Secure Boot enabled.
        """
        if enable_integrity_monitoring is not None:
            pulumi.set(__self__, "enable_integrity_monitoring", enable_integrity_monitoring)
        if enable_secure_boot is not None:
            pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)

    @property
    @pulumi.getter(name="enableIntegrityMonitoring")
    def enable_integrity_monitoring(self) -> Optional[bool]:
        """
        Defines if the instance has integrity monitoring enabled.
        """
        return pulumi.get(self, "enable_integrity_monitoring")

    @property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> Optional[bool]:
        """
        Defines if the instance has Secure Boot enabled.
        """
        return pulumi.get(self, "enable_secure_boot")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterNodeConfigTaint(dict):
    def __init__(__self__, *,
                 effect: str,
                 key: str,
                 value: str):
        """
        :param str effect: Effect for taint. Accepted values are `NO_SCHEDULE`, `PREFER_NO_SCHEDULE`, and `NO_EXECUTE`.
        :param str key: Key for taint.
        :param str value: Value for taint.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> str:
        """
        Effect for taint. Accepted values are `NO_SCHEDULE`, `PREFER_NO_SCHEDULE`, and `NO_EXECUTE`.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Key for taint.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value for taint.
        """
        return pulumi.get(self, "value")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterNodeConfigWorkloadMetadataConfig(dict):
    def __init__(__self__, *,
                 node_metadata: str):
        """
        :param str node_metadata: How to expose the node metadata to the workload running on the node.
               Accepted values are:
               * UNSPECIFIED: Not Set
               * SECURE: Prevent workloads not in hostNetwork from accessing certain VM metadata, specifically kube-env, which contains Kubelet credentials, and the instance identity token. See [Metadata Concealment](https://cloud.google.com/kubernetes-engine/docs/how-to/metadata-proxy) documentation.
               * EXPOSE: Expose all VM metadata to pods.
               * GKE_METADATA_SERVER: Enables [workload identity](https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity) on the node.
        """
        pulumi.set(__self__, "node_metadata", node_metadata)

    @property
    @pulumi.getter(name="nodeMetadata")
    def node_metadata(self) -> str:
        """
        How to expose the node metadata to the workload running on the node.
        Accepted values are:
        * UNSPECIFIED: Not Set
        * SECURE: Prevent workloads not in hostNetwork from accessing certain VM metadata, specifically kube-env, which contains Kubelet credentials, and the instance identity token. See [Metadata Concealment](https://cloud.google.com/kubernetes-engine/docs/how-to/metadata-proxy) documentation.
        * EXPOSE: Expose all VM metadata to pods.
        * GKE_METADATA_SERVER: Enables [workload identity](https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity) on the node.
        """
        return pulumi.get(self, "node_metadata")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterNodePool(dict):
    def __init__(__self__, *,
                 autoscaling: Optional['outputs.ClusterNodePoolAutoscaling'] = None,
                 initial_node_count: Optional[int] = None,
                 instance_group_urls: Optional[Sequence[str]] = None,
                 management: Optional['outputs.ClusterNodePoolManagement'] = None,
                 max_pods_per_node: Optional[int] = None,
                 name: Optional[str] = None,
                 name_prefix: Optional[str] = None,
                 node_config: Optional['outputs.ClusterNodePoolNodeConfig'] = None,
                 node_count: Optional[int] = None,
                 node_locations: Optional[Sequence[str]] = None,
                 upgrade_settings: Optional['outputs.ClusterNodePoolUpgradeSettings'] = None,
                 version: Optional[str] = None):
        """
        :param int initial_node_count: The number of nodes to create in this
               cluster's default node pool. In regional or multi-zonal clusters, this is the
               number of nodes per zone. Must be set if `node_pool` is not set. If you're using
               `container.NodePool` objects with no default node pool, you'll need to
               set this to a value of at least `1`, alongside setting
               `remove_default_node_pool` to `true`.
        :param Sequence[str] instance_group_urls: List of instance group URLs which have been assigned
               to the cluster.
        :param str name: The name of the cluster, unique within the project and
               location.
        :param 'ClusterNodePoolNodeConfigArgs' node_config: Parameters used in creating the default node pool.
               Generally, this field should not be used at the same time as a
               `container.NodePool` or a `node_pool` block; this configuration
               manages the default node pool, which isn't recommended to be used.
               Structure is documented below.
        :param Sequence[str] node_locations: The list of zones in which the cluster's nodes
               are located. Nodes must be in the region of their regional cluster or in the
               same region as their cluster's zone for zonal clusters. If this is specified for
               a zonal cluster, omit the cluster's zone.
        """
        if autoscaling is not None:
            pulumi.set(__self__, "autoscaling", autoscaling)
        if initial_node_count is not None:
            pulumi.set(__self__, "initial_node_count", initial_node_count)
        if instance_group_urls is not None:
            pulumi.set(__self__, "instance_group_urls", instance_group_urls)
        if management is not None:
            pulumi.set(__self__, "management", management)
        if max_pods_per_node is not None:
            pulumi.set(__self__, "max_pods_per_node", max_pods_per_node)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if node_config is not None:
            pulumi.set(__self__, "node_config", node_config)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if node_locations is not None:
            pulumi.set(__self__, "node_locations", node_locations)
        if upgrade_settings is not None:
            pulumi.set(__self__, "upgrade_settings", upgrade_settings)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def autoscaling(self) -> Optional['outputs.ClusterNodePoolAutoscaling']:
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter(name="initialNodeCount")
    def initial_node_count(self) -> Optional[int]:
        """
        The number of nodes to create in this
        cluster's default node pool. In regional or multi-zonal clusters, this is the
        number of nodes per zone. Must be set if `node_pool` is not set. If you're using
        `container.NodePool` objects with no default node pool, you'll need to
        set this to a value of at least `1`, alongside setting
        `remove_default_node_pool` to `true`.
        """
        return pulumi.get(self, "initial_node_count")

    @property
    @pulumi.getter(name="instanceGroupUrls")
    def instance_group_urls(self) -> Optional[Sequence[str]]:
        """
        List of instance group URLs which have been assigned
        to the cluster.
        """
        return pulumi.get(self, "instance_group_urls")

    @property
    @pulumi.getter
    def management(self) -> Optional['outputs.ClusterNodePoolManagement']:
        return pulumi.get(self, "management")

    @property
    @pulumi.getter(name="maxPodsPerNode")
    def max_pods_per_node(self) -> Optional[int]:
        return pulumi.get(self, "max_pods_per_node")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the cluster, unique within the project and
        location.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[str]:
        return pulumi.get(self, "name_prefix")

    @property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> Optional['outputs.ClusterNodePoolNodeConfig']:
        """
        Parameters used in creating the default node pool.
        Generally, this field should not be used at the same time as a
        `container.NodePool` or a `node_pool` block; this configuration
        manages the default node pool, which isn't recommended to be used.
        Structure is documented below.
        """
        return pulumi.get(self, "node_config")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[int]:
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nodeLocations")
    def node_locations(self) -> Optional[Sequence[str]]:
        """
        The list of zones in which the cluster's nodes
        are located. Nodes must be in the region of their regional cluster or in the
        same region as their cluster's zone for zonal clusters. If this is specified for
        a zonal cluster, omit the cluster's zone.
        """
        return pulumi.get(self, "node_locations")

    @property
    @pulumi.getter(name="upgradeSettings")
    def upgrade_settings(self) -> Optional['outputs.ClusterNodePoolUpgradeSettings']:
        return pulumi.get(self, "upgrade_settings")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        return pulumi.get(self, "version")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterNodePoolAutoscaling(dict):
    def __init__(__self__, *,
                 max_node_count: int,
                 min_node_count: int):
        pulumi.set(__self__, "max_node_count", max_node_count)
        pulumi.set(__self__, "min_node_count", min_node_count)

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> int:
        return pulumi.get(self, "max_node_count")

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> int:
        return pulumi.get(self, "min_node_count")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterNodePoolManagement(dict):
    def __init__(__self__, *,
                 auto_repair: Optional[bool] = None,
                 auto_upgrade: Optional[bool] = None):
        if auto_repair is not None:
            pulumi.set(__self__, "auto_repair", auto_repair)
        if auto_upgrade is not None:
            pulumi.set(__self__, "auto_upgrade", auto_upgrade)

    @property
    @pulumi.getter(name="autoRepair")
    def auto_repair(self) -> Optional[bool]:
        return pulumi.get(self, "auto_repair")

    @property
    @pulumi.getter(name="autoUpgrade")
    def auto_upgrade(self) -> Optional[bool]:
        return pulumi.get(self, "auto_upgrade")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterNodePoolNodeConfig(dict):
    def __init__(__self__, *,
                 boot_disk_kms_key: Optional[str] = None,
                 disk_size_gb: Optional[int] = None,
                 disk_type: Optional[str] = None,
                 guest_accelerators: Optional[Sequence['outputs.ClusterNodePoolNodeConfigGuestAccelerator']] = None,
                 image_type: Optional[str] = None,
                 kubelet_config: Optional['outputs.ClusterNodePoolNodeConfigKubeletConfig'] = None,
                 labels: Optional[Mapping[str, str]] = None,
                 linux_node_config: Optional['outputs.ClusterNodePoolNodeConfigLinuxNodeConfig'] = None,
                 local_ssd_count: Optional[int] = None,
                 machine_type: Optional[str] = None,
                 metadata: Optional[Mapping[str, str]] = None,
                 min_cpu_platform: Optional[str] = None,
                 oauth_scopes: Optional[Sequence[str]] = None,
                 preemptible: Optional[bool] = None,
                 sandbox_config: Optional['outputs.ClusterNodePoolNodeConfigSandboxConfig'] = None,
                 service_account: Optional[str] = None,
                 shielded_instance_config: Optional['outputs.ClusterNodePoolNodeConfigShieldedInstanceConfig'] = None,
                 tags: Optional[Sequence[str]] = None,
                 taints: Optional[Sequence['outputs.ClusterNodePoolNodeConfigTaint']] = None,
                 workload_metadata_config: Optional['outputs.ClusterNodePoolNodeConfigWorkloadMetadataConfig'] = None):
        """
        :param str boot_disk_kms_key: The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool. This should be of the form projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME]. For more information about protecting resources with Cloud KMS Keys please see: https://cloud.google.com/compute/docs/disks/customer-managed-encryption
        :param int disk_size_gb: Size of the disk attached to each node, specified
               in GB. The smallest allowed disk size is 10GB. Defaults to 100GB.
        :param str disk_type: Type of the disk attached to each node
               (e.g. 'pd-standard', 'pd-balanced' or 'pd-ssd'). If unspecified, the default disk type is 'pd-standard'
        :param Sequence['ClusterNodePoolNodeConfigGuestAcceleratorArgs'] guest_accelerators: List of the type and count of accelerator cards attached to the instance.
               Structure documented below.
        :param str image_type: The image type to use for this node. Note that changing the image type
               will delete and recreate all nodes in the node pool.
        :param 'ClusterNodePoolNodeConfigKubeletConfigArgs' kubelet_config: Kubelet configuration, currently supported attributes can be found [here](https://cloud.google.com/sdk/gcloud/reference/beta/container/node-pools/create#--system-config-from-file).
               Structure is documented below.
        :param Mapping[str, str] labels: The Kubernetes labels (key/value pairs) to be applied to each node. The kubernetes.io/ and k8s.io/ prefixes are
               reserved by Kubernetes Core components and cannot be specified.
        :param 'ClusterNodePoolNodeConfigLinuxNodeConfigArgs' linux_node_config: Linux node configuration, currently supported attributes can be found [here](https://cloud.google.com/sdk/gcloud/reference/beta/container/node-pools/create#--system-config-from-file).
               Note that validations happen all server side. All attributes are optional.
               Structure is documented below.
        :param int local_ssd_count: The amount of local SSD disks that will be
               attached to each cluster node. Defaults to 0.
        :param str machine_type: The name of a Google Compute Engine machine type.
               Defaults to `e2-medium`. To create a custom machine type, value should be set as specified
               [here](https://cloud.google.com/compute/docs/reference/latest/instances#machineType).
        :param Mapping[str, str] metadata: The metadata key/value pairs assigned to instances in
               the cluster. From GKE `1.12` onwards, `disable-legacy-endpoints` is set to
               `true` by the API; if `metadata` is set but that default value is not
               included, the provider will attempt to unset the value. To avoid this, set the
               value in your config.
        :param str min_cpu_platform: Minimum CPU platform to be used by this instance.
               The instance may be scheduled on the specified or newer CPU platform. Applicable
               values are the friendly names of CPU platforms, such as `Intel Haswell`. See the
               [official documentation](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
               for more information.
        :param Sequence[str] oauth_scopes: The set of Google API scopes to be made available
               on all of the node VMs under the "default" service account.
               Use the "https://www.googleapis.com/auth/cloud-platform" scope to grant access to all APIs. It is recommended that you set `service_account` to a non-default service account and grant IAM roles to that service account for only the resources that it needs.
        :param bool preemptible: A boolean that represents whether or not the underlying node VMs
               are preemptible. See the [official documentation](https://cloud.google.com/container-engine/docs/preemptible-vm)
               for more information. Defaults to false.
        :param 'ClusterNodePoolNodeConfigSandboxConfigArgs' sandbox_config: [GKE Sandbox](https://cloud.google.com/kubernetes-engine/docs/how-to/sandbox-pods) configuration. When enabling this feature you must specify `image_type = "COS_CONTAINERD"` and `node_version = "1.12.7-gke.17"` or later to use it.
               Structure is documented below.
        :param str service_account: The service account to be used by the Node VMs.
               If not specified, the "default" service account is used.
        :param 'ClusterNodePoolNodeConfigShieldedInstanceConfigArgs' shielded_instance_config: Shielded Instance options. Structure is documented below.
        :param Sequence[str] tags: The list of instance tags applied to all nodes. Tags are used to identify
               valid sources or targets for network firewalls.
        :param Sequence['ClusterNodePoolNodeConfigTaintArgs'] taints: A list of [Kubernetes taints](https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/)
               to apply to nodes. GKE's API can only set this field on cluster creation.
               However, GKE will add taints to your nodes if you enable certain features such
               as GPUs. If this field is set, any diffs on this field will cause the provider to
               recreate the underlying resource. Taint values can be updated safely in
               Kubernetes (eg. through `kubectl`), and it's recommended that you do not use
               this field to manage taints. If you do, `lifecycle.ignore_changes` is
               recommended. Structure is documented below.
        :param 'ClusterNodePoolNodeConfigWorkloadMetadataConfigArgs' workload_metadata_config: Metadata configuration to expose to workloads on the node pool.
               Structure is documented below.
        """
        if boot_disk_kms_key is not None:
            pulumi.set(__self__, "boot_disk_kms_key", boot_disk_kms_key)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if guest_accelerators is not None:
            pulumi.set(__self__, "guest_accelerators", guest_accelerators)
        if image_type is not None:
            pulumi.set(__self__, "image_type", image_type)
        if kubelet_config is not None:
            pulumi.set(__self__, "kubelet_config", kubelet_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if linux_node_config is not None:
            pulumi.set(__self__, "linux_node_config", linux_node_config)
        if local_ssd_count is not None:
            pulumi.set(__self__, "local_ssd_count", local_ssd_count)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if oauth_scopes is not None:
            pulumi.set(__self__, "oauth_scopes", oauth_scopes)
        if preemptible is not None:
            pulumi.set(__self__, "preemptible", preemptible)
        if sandbox_config is not None:
            pulumi.set(__self__, "sandbox_config", sandbox_config)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if workload_metadata_config is not None:
            pulumi.set(__self__, "workload_metadata_config", workload_metadata_config)

    @property
    @pulumi.getter(name="bootDiskKmsKey")
    def boot_disk_kms_key(self) -> Optional[str]:
        """
        The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool. This should be of the form projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME]. For more information about protecting resources with Cloud KMS Keys please see: https://cloud.google.com/compute/docs/disks/customer-managed-encryption
        """
        return pulumi.get(self, "boot_disk_kms_key")

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[int]:
        """
        Size of the disk attached to each node, specified
        in GB. The smallest allowed disk size is 10GB. Defaults to 100GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[str]:
        """
        Type of the disk attached to each node
        (e.g. 'pd-standard', 'pd-balanced' or 'pd-ssd'). If unspecified, the default disk type is 'pd-standard'
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="guestAccelerators")
    def guest_accelerators(self) -> Optional[Sequence['outputs.ClusterNodePoolNodeConfigGuestAccelerator']]:
        """
        List of the type and count of accelerator cards attached to the instance.
        Structure documented below.
        """
        return pulumi.get(self, "guest_accelerators")

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[str]:
        """
        The image type to use for this node. Note that changing the image type
        will delete and recreate all nodes in the node pool.
        """
        return pulumi.get(self, "image_type")

    @property
    @pulumi.getter(name="kubeletConfig")
    def kubelet_config(self) -> Optional['outputs.ClusterNodePoolNodeConfigKubeletConfig']:
        """
        Kubelet configuration, currently supported attributes can be found [here](https://cloud.google.com/sdk/gcloud/reference/beta/container/node-pools/create#--system-config-from-file).
        Structure is documented below.
        """
        return pulumi.get(self, "kubelet_config")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        """
        The Kubernetes labels (key/value pairs) to be applied to each node. The kubernetes.io/ and k8s.io/ prefixes are
        reserved by Kubernetes Core components and cannot be specified.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="linuxNodeConfig")
    def linux_node_config(self) -> Optional['outputs.ClusterNodePoolNodeConfigLinuxNodeConfig']:
        """
        Linux node configuration, currently supported attributes can be found [here](https://cloud.google.com/sdk/gcloud/reference/beta/container/node-pools/create#--system-config-from-file).
        Note that validations happen all server side. All attributes are optional.
        Structure is documented below.
        """
        return pulumi.get(self, "linux_node_config")

    @property
    @pulumi.getter(name="localSsdCount")
    def local_ssd_count(self) -> Optional[int]:
        """
        The amount of local SSD disks that will be
        attached to each cluster node. Defaults to 0.
        """
        return pulumi.get(self, "local_ssd_count")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[str]:
        """
        The name of a Google Compute Engine machine type.
        Defaults to `e2-medium`. To create a custom machine type, value should be set as specified
        [here](https://cloud.google.com/compute/docs/reference/latest/instances#machineType).
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Mapping[str, str]]:
        """
        The metadata key/value pairs assigned to instances in
        the cluster. From GKE `1.12` onwards, `disable-legacy-endpoints` is set to
        `true` by the API; if `metadata` is set but that default value is not
        included, the provider will attempt to unset the value. To avoid this, set the
        value in your config.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[str]:
        """
        Minimum CPU platform to be used by this instance.
        The instance may be scheduled on the specified or newer CPU platform. Applicable
        values are the friendly names of CPU platforms, such as `Intel Haswell`. See the
        [official documentation](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
        for more information.
        """
        return pulumi.get(self, "min_cpu_platform")

    @property
    @pulumi.getter(name="oauthScopes")
    def oauth_scopes(self) -> Optional[Sequence[str]]:
        """
        The set of Google API scopes to be made available
        on all of the node VMs under the "default" service account.
        Use the "https://www.googleapis.com/auth/cloud-platform" scope to grant access to all APIs. It is recommended that you set `service_account` to a non-default service account and grant IAM roles to that service account for only the resources that it needs.
        """
        return pulumi.get(self, "oauth_scopes")

    @property
    @pulumi.getter
    def preemptible(self) -> Optional[bool]:
        """
        A boolean that represents whether or not the underlying node VMs
        are preemptible. See the [official documentation](https://cloud.google.com/container-engine/docs/preemptible-vm)
        for more information. Defaults to false.
        """
        return pulumi.get(self, "preemptible")

    @property
    @pulumi.getter(name="sandboxConfig")
    def sandbox_config(self) -> Optional['outputs.ClusterNodePoolNodeConfigSandboxConfig']:
        """
        [GKE Sandbox](https://cloud.google.com/kubernetes-engine/docs/how-to/sandbox-pods) configuration. When enabling this feature you must specify `image_type = "COS_CONTAINERD"` and `node_version = "1.12.7-gke.17"` or later to use it.
        Structure is documented below.
        """
        return pulumi.get(self, "sandbox_config")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[str]:
        """
        The service account to be used by the Node VMs.
        If not specified, the "default" service account is used.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional['outputs.ClusterNodePoolNodeConfigShieldedInstanceConfig']:
        """
        Shielded Instance options. Structure is documented below.
        """
        return pulumi.get(self, "shielded_instance_config")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The list of instance tags applied to all nodes. Tags are used to identify
        valid sources or targets for network firewalls.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def taints(self) -> Optional[Sequence['outputs.ClusterNodePoolNodeConfigTaint']]:
        """
        A list of [Kubernetes taints](https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/)
        to apply to nodes. GKE's API can only set this field on cluster creation.
        However, GKE will add taints to your nodes if you enable certain features such
        as GPUs. If this field is set, any diffs on this field will cause the provider to
        recreate the underlying resource. Taint values can be updated safely in
        Kubernetes (eg. through `kubectl`), and it's recommended that you do not use
        this field to manage taints. If you do, `lifecycle.ignore_changes` is
        recommended. Structure is documented below.
        """
        return pulumi.get(self, "taints")

    @property
    @pulumi.getter(name="workloadMetadataConfig")
    def workload_metadata_config(self) -> Optional['outputs.ClusterNodePoolNodeConfigWorkloadMetadataConfig']:
        """
        Metadata configuration to expose to workloads on the node pool.
        Structure is documented below.
        """
        return pulumi.get(self, "workload_metadata_config")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterNodePoolNodeConfigGuestAccelerator(dict):
    def __init__(__self__, *,
                 count: int,
                 type: str):
        """
        :param int count: The number of the guest accelerator cards exposed to this instance.
        :param str type: The accelerator type resource to expose to this instance. E.g. `nvidia-tesla-k80`.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def count(self) -> int:
        """
        The number of the guest accelerator cards exposed to this instance.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The accelerator type resource to expose to this instance. E.g. `nvidia-tesla-k80`.
        """
        return pulumi.get(self, "type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterNodePoolNodeConfigKubeletConfig(dict):
    def __init__(__self__, *,
                 cpu_manager_policy: str,
                 cpu_cfs_quota: Optional[bool] = None,
                 cpu_cfs_quota_period: Optional[str] = None):
        """
        :param str cpu_manager_policy: The CPU management policy on the node. See
               [K8S CPU Management Policies](https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/).
               One of `"none"` or `"static"`. Defaults to `none` when `kubelet_config` is unset.
        :param bool cpu_cfs_quota: If true, enables CPU CFS quota enforcement for
               containers that specify CPU limits.
        :param str cpu_cfs_quota_period: The CPU CFS quota period value. Specified
               as a sequence of decimal numbers, each with optional fraction and a unit suffix,
               such as `"300ms"`. Valid time units are "ns", "us" (or "µs"), "ms", "s", "m",
               "h". The value must be a positive duration.
        """
        pulumi.set(__self__, "cpu_manager_policy", cpu_manager_policy)
        if cpu_cfs_quota is not None:
            pulumi.set(__self__, "cpu_cfs_quota", cpu_cfs_quota)
        if cpu_cfs_quota_period is not None:
            pulumi.set(__self__, "cpu_cfs_quota_period", cpu_cfs_quota_period)

    @property
    @pulumi.getter(name="cpuManagerPolicy")
    def cpu_manager_policy(self) -> str:
        """
        The CPU management policy on the node. See
        [K8S CPU Management Policies](https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/).
        One of `"none"` or `"static"`. Defaults to `none` when `kubelet_config` is unset.
        """
        return pulumi.get(self, "cpu_manager_policy")

    @property
    @pulumi.getter(name="cpuCfsQuota")
    def cpu_cfs_quota(self) -> Optional[bool]:
        """
        If true, enables CPU CFS quota enforcement for
        containers that specify CPU limits.
        """
        return pulumi.get(self, "cpu_cfs_quota")

    @property
    @pulumi.getter(name="cpuCfsQuotaPeriod")
    def cpu_cfs_quota_period(self) -> Optional[str]:
        """
        The CPU CFS quota period value. Specified
        as a sequence of decimal numbers, each with optional fraction and a unit suffix,
        such as `"300ms"`. Valid time units are "ns", "us" (or "µs"), "ms", "s", "m",
        "h". The value must be a positive duration.
        """
        return pulumi.get(self, "cpu_cfs_quota_period")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterNodePoolNodeConfigLinuxNodeConfig(dict):
    def __init__(__self__, *,
                 sysctls: Mapping[str, str]):
        """
        :param Mapping[str, str] sysctls: The Linux kernel parameters to be applied to the nodes
               and all pods running on the nodes. Specified as a map from the key, such as
               `net.core.wmem_max`, to a string value.
        """
        pulumi.set(__self__, "sysctls", sysctls)

    @property
    @pulumi.getter
    def sysctls(self) -> Mapping[str, str]:
        """
        The Linux kernel parameters to be applied to the nodes
        and all pods running on the nodes. Specified as a map from the key, such as
        `net.core.wmem_max`, to a string value.
        """
        return pulumi.get(self, "sysctls")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterNodePoolNodeConfigSandboxConfig(dict):
    def __init__(__self__, *,
                 sandbox_type: str):
        """
        :param str sandbox_type: Which sandbox to use for pods in the node pool.
               Accepted values are:
        """
        pulumi.set(__self__, "sandbox_type", sandbox_type)

    @property
    @pulumi.getter(name="sandboxType")
    def sandbox_type(self) -> str:
        """
        Which sandbox to use for pods in the node pool.
        Accepted values are:
        """
        return pulumi.get(self, "sandbox_type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterNodePoolNodeConfigShieldedInstanceConfig(dict):
    def __init__(__self__, *,
                 enable_integrity_monitoring: Optional[bool] = None,
                 enable_secure_boot: Optional[bool] = None):
        """
        :param bool enable_integrity_monitoring: Defines if the instance has integrity monitoring enabled.
        :param bool enable_secure_boot: Defines if the instance has Secure Boot enabled.
        """
        if enable_integrity_monitoring is not None:
            pulumi.set(__self__, "enable_integrity_monitoring", enable_integrity_monitoring)
        if enable_secure_boot is not None:
            pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)

    @property
    @pulumi.getter(name="enableIntegrityMonitoring")
    def enable_integrity_monitoring(self) -> Optional[bool]:
        """
        Defines if the instance has integrity monitoring enabled.
        """
        return pulumi.get(self, "enable_integrity_monitoring")

    @property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> Optional[bool]:
        """
        Defines if the instance has Secure Boot enabled.
        """
        return pulumi.get(self, "enable_secure_boot")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterNodePoolNodeConfigTaint(dict):
    def __init__(__self__, *,
                 effect: str,
                 key: str,
                 value: str):
        """
        :param str effect: Effect for taint. Accepted values are `NO_SCHEDULE`, `PREFER_NO_SCHEDULE`, and `NO_EXECUTE`.
        :param str key: Key for taint.
        :param str value: Value for taint.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> str:
        """
        Effect for taint. Accepted values are `NO_SCHEDULE`, `PREFER_NO_SCHEDULE`, and `NO_EXECUTE`.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Key for taint.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value for taint.
        """
        return pulumi.get(self, "value")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterNodePoolNodeConfigWorkloadMetadataConfig(dict):
    def __init__(__self__, *,
                 node_metadata: str):
        """
        :param str node_metadata: How to expose the node metadata to the workload running on the node.
               Accepted values are:
               * UNSPECIFIED: Not Set
               * SECURE: Prevent workloads not in hostNetwork from accessing certain VM metadata, specifically kube-env, which contains Kubelet credentials, and the instance identity token. See [Metadata Concealment](https://cloud.google.com/kubernetes-engine/docs/how-to/metadata-proxy) documentation.
               * EXPOSE: Expose all VM metadata to pods.
               * GKE_METADATA_SERVER: Enables [workload identity](https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity) on the node.
        """
        pulumi.set(__self__, "node_metadata", node_metadata)

    @property
    @pulumi.getter(name="nodeMetadata")
    def node_metadata(self) -> str:
        """
        How to expose the node metadata to the workload running on the node.
        Accepted values are:
        * UNSPECIFIED: Not Set
        * SECURE: Prevent workloads not in hostNetwork from accessing certain VM metadata, specifically kube-env, which contains Kubelet credentials, and the instance identity token. See [Metadata Concealment](https://cloud.google.com/kubernetes-engine/docs/how-to/metadata-proxy) documentation.
        * EXPOSE: Expose all VM metadata to pods.
        * GKE_METADATA_SERVER: Enables [workload identity](https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity) on the node.
        """
        return pulumi.get(self, "node_metadata")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterNodePoolUpgradeSettings(dict):
    def __init__(__self__, *,
                 max_surge: int,
                 max_unavailable: int):
        pulumi.set(__self__, "max_surge", max_surge)
        pulumi.set(__self__, "max_unavailable", max_unavailable)

    @property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> int:
        return pulumi.get(self, "max_surge")

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> int:
        return pulumi.get(self, "max_unavailable")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterNotificationConfig(dict):
    def __init__(__self__, *,
                 pubsub: 'outputs.ClusterNotificationConfigPubsub'):
        pulumi.set(__self__, "pubsub", pubsub)

    @property
    @pulumi.getter
    def pubsub(self) -> 'outputs.ClusterNotificationConfigPubsub':
        return pulumi.get(self, "pubsub")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterNotificationConfigPubsub(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 topic: Optional[str] = None):
        """
        :param bool enabled: Enable the PodSecurityPolicy controller for this cluster.
               If enabled, pods must be valid under a PodSecurityPolicy to be created.
        """
        pulumi.set(__self__, "enabled", enabled)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Enable the PodSecurityPolicy controller for this cluster.
        If enabled, pods must be valid under a PodSecurityPolicy to be created.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def topic(self) -> Optional[str]:
        return pulumi.get(self, "topic")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterPodSecurityPolicyConfig(dict):
    def __init__(__self__, *,
                 enabled: bool):
        """
        :param bool enabled: Enable the PodSecurityPolicy controller for this cluster.
               If enabled, pods must be valid under a PodSecurityPolicy to be created.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Enable the PodSecurityPolicy controller for this cluster.
        If enabled, pods must be valid under a PodSecurityPolicy to be created.
        """
        return pulumi.get(self, "enabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterPrivateClusterConfig(dict):
    def __init__(__self__, *,
                 enable_private_endpoint: bool,
                 enable_private_nodes: Optional[bool] = None,
                 master_global_access_config: Optional['outputs.ClusterPrivateClusterConfigMasterGlobalAccessConfig'] = None,
                 master_ipv4_cidr_block: Optional[str] = None,
                 peering_name: Optional[str] = None,
                 private_endpoint: Optional[str] = None,
                 public_endpoint: Optional[str] = None):
        """
        :param bool enable_private_endpoint: When `true`, the cluster's private
               endpoint is used as the cluster endpoint and access through the public endpoint
               is disabled. When `false`, either endpoint can be used. This field only applies
               to private clusters, when `enable_private_nodes` is `true`.
        :param bool enable_private_nodes: Enables the private cluster feature,
               creating a private endpoint on the cluster. In a private cluster, nodes only
               have RFC 1918 private addresses and communicate with the master's private
               endpoint via private networking.
        :param 'ClusterPrivateClusterConfigMasterGlobalAccessConfigArgs' master_global_access_config: Controls cluster master global
               access settings. If unset, the provider will no longer manage this field and will
               not modify the previously-set value. Structure is documented below.
        :param str master_ipv4_cidr_block: The IP range in CIDR notation to use for
               the hosted master network. This range will be used for assigning private IP
               addresses to the cluster master(s) and the ILB VIP. This range must not overlap
               with any other ranges in use within the cluster's network, and it must be a /28
               subnet. See [Private Cluster Limitations](https://cloud.google.com/kubernetes-engine/docs/how-to/private-clusters#limitations)
               for more details. This field only applies to private clusters, when
               `enable_private_nodes` is `true`.
        :param str peering_name: The name of the peering between this cluster and the Google owned VPC.
        :param str private_endpoint: The internal IP address of this cluster's master endpoint.
        :param str public_endpoint: The external IP address of this cluster's master endpoint.
        """
        pulumi.set(__self__, "enable_private_endpoint", enable_private_endpoint)
        if enable_private_nodes is not None:
            pulumi.set(__self__, "enable_private_nodes", enable_private_nodes)
        if master_global_access_config is not None:
            pulumi.set(__self__, "master_global_access_config", master_global_access_config)
        if master_ipv4_cidr_block is not None:
            pulumi.set(__self__, "master_ipv4_cidr_block", master_ipv4_cidr_block)
        if peering_name is not None:
            pulumi.set(__self__, "peering_name", peering_name)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if public_endpoint is not None:
            pulumi.set(__self__, "public_endpoint", public_endpoint)

    @property
    @pulumi.getter(name="enablePrivateEndpoint")
    def enable_private_endpoint(self) -> bool:
        """
        When `true`, the cluster's private
        endpoint is used as the cluster endpoint and access through the public endpoint
        is disabled. When `false`, either endpoint can be used. This field only applies
        to private clusters, when `enable_private_nodes` is `true`.
        """
        return pulumi.get(self, "enable_private_endpoint")

    @property
    @pulumi.getter(name="enablePrivateNodes")
    def enable_private_nodes(self) -> Optional[bool]:
        """
        Enables the private cluster feature,
        creating a private endpoint on the cluster. In a private cluster, nodes only
        have RFC 1918 private addresses and communicate with the master's private
        endpoint via private networking.
        """
        return pulumi.get(self, "enable_private_nodes")

    @property
    @pulumi.getter(name="masterGlobalAccessConfig")
    def master_global_access_config(self) -> Optional['outputs.ClusterPrivateClusterConfigMasterGlobalAccessConfig']:
        """
        Controls cluster master global
        access settings. If unset, the provider will no longer manage this field and will
        not modify the previously-set value. Structure is documented below.
        """
        return pulumi.get(self, "master_global_access_config")

    @property
    @pulumi.getter(name="masterIpv4CidrBlock")
    def master_ipv4_cidr_block(self) -> Optional[str]:
        """
        The IP range in CIDR notation to use for
        the hosted master network. This range will be used for assigning private IP
        addresses to the cluster master(s) and the ILB VIP. This range must not overlap
        with any other ranges in use within the cluster's network, and it must be a /28
        subnet. See [Private Cluster Limitations](https://cloud.google.com/kubernetes-engine/docs/how-to/private-clusters#limitations)
        for more details. This field only applies to private clusters, when
        `enable_private_nodes` is `true`.
        """
        return pulumi.get(self, "master_ipv4_cidr_block")

    @property
    @pulumi.getter(name="peeringName")
    def peering_name(self) -> Optional[str]:
        """
        The name of the peering between this cluster and the Google owned VPC.
        """
        return pulumi.get(self, "peering_name")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional[str]:
        """
        The internal IP address of this cluster's master endpoint.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="publicEndpoint")
    def public_endpoint(self) -> Optional[str]:
        """
        The external IP address of this cluster's master endpoint.
        """
        return pulumi.get(self, "public_endpoint")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterPrivateClusterConfigMasterGlobalAccessConfig(dict):
    def __init__(__self__, *,
                 enabled: bool):
        """
        :param bool enabled: Enable the PodSecurityPolicy controller for this cluster.
               If enabled, pods must be valid under a PodSecurityPolicy to be created.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Enable the PodSecurityPolicy controller for this cluster.
        If enabled, pods must be valid under a PodSecurityPolicy to be created.
        """
        return pulumi.get(self, "enabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterReleaseChannel(dict):
    def __init__(__self__, *,
                 channel: str):
        """
        :param str channel: The selected release channel.
               Accepted values are:
               * UNSPECIFIED: Not set.
               * RAPID: Weekly upgrade cadence; Early testers and developers who requires new features.
               * REGULAR: Multiple per month upgrade cadence; Production users who need features not yet offered in the Stable channel.
               * STABLE: Every few months upgrade cadence; Production users who need stability above all else, and for whom frequent upgrades are too risky.
        """
        pulumi.set(__self__, "channel", channel)

    @property
    @pulumi.getter
    def channel(self) -> str:
        """
        The selected release channel.
        Accepted values are:
        * UNSPECIFIED: Not set.
        * RAPID: Weekly upgrade cadence; Early testers and developers who requires new features.
        * REGULAR: Multiple per month upgrade cadence; Production users who need features not yet offered in the Stable channel.
        * STABLE: Every few months upgrade cadence; Production users who need stability above all else, and for whom frequent upgrades are too risky.
        """
        return pulumi.get(self, "channel")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterResourceUsageExportConfig(dict):
    def __init__(__self__, *,
                 bigquery_destination: 'outputs.ClusterResourceUsageExportConfigBigqueryDestination',
                 enable_network_egress_metering: Optional[bool] = None,
                 enable_resource_consumption_metering: Optional[bool] = None):
        """
        :param 'ClusterResourceUsageExportConfigBigqueryDestinationArgs' bigquery_destination: Parameters for using BigQuery as the destination of resource usage export.
        :param bool enable_network_egress_metering: Whether to enable network egress metering for this cluster. If enabled, a daemonset will be created
               in the cluster to meter network egress traffic.
        :param bool enable_resource_consumption_metering: Whether to enable resource
               consumption metering on this cluster. When enabled, a table will be created in
               the resource export BigQuery dataset to store resource consumption data. The
               resulting table can be joined with the resource usage table or with BigQuery
               billing export. Defaults to `true`.
        """
        pulumi.set(__self__, "bigquery_destination", bigquery_destination)
        if enable_network_egress_metering is not None:
            pulumi.set(__self__, "enable_network_egress_metering", enable_network_egress_metering)
        if enable_resource_consumption_metering is not None:
            pulumi.set(__self__, "enable_resource_consumption_metering", enable_resource_consumption_metering)

    @property
    @pulumi.getter(name="bigqueryDestination")
    def bigquery_destination(self) -> 'outputs.ClusterResourceUsageExportConfigBigqueryDestination':
        """
        Parameters for using BigQuery as the destination of resource usage export.
        """
        return pulumi.get(self, "bigquery_destination")

    @property
    @pulumi.getter(name="enableNetworkEgressMetering")
    def enable_network_egress_metering(self) -> Optional[bool]:
        """
        Whether to enable network egress metering for this cluster. If enabled, a daemonset will be created
        in the cluster to meter network egress traffic.
        """
        return pulumi.get(self, "enable_network_egress_metering")

    @property
    @pulumi.getter(name="enableResourceConsumptionMetering")
    def enable_resource_consumption_metering(self) -> Optional[bool]:
        """
        Whether to enable resource
        consumption metering on this cluster. When enabled, a table will be created in
        the resource export BigQuery dataset to store resource consumption data. The
        resulting table can be joined with the resource usage table or with BigQuery
        billing export. Defaults to `true`.
        """
        return pulumi.get(self, "enable_resource_consumption_metering")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterResourceUsageExportConfigBigqueryDestination(dict):
    def __init__(__self__, *,
                 dataset_id: str):
        pulumi.set(__self__, "dataset_id", dataset_id)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        return pulumi.get(self, "dataset_id")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterVerticalPodAutoscaling(dict):
    def __init__(__self__, *,
                 enabled: bool):
        """
        :param bool enabled: Enable the PodSecurityPolicy controller for this cluster.
               If enabled, pods must be valid under a PodSecurityPolicy to be created.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Enable the PodSecurityPolicy controller for this cluster.
        If enabled, pods must be valid under a PodSecurityPolicy to be created.
        """
        return pulumi.get(self, "enabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterWorkloadIdentityConfig(dict):
    def __init__(__self__, *,
                 identity_namespace: str):
        """
        :param str identity_namespace: Currently, the only supported identity namespace is the project's default.
        """
        pulumi.set(__self__, "identity_namespace", identity_namespace)

    @property
    @pulumi.getter(name="identityNamespace")
    def identity_namespace(self) -> str:
        """
        Currently, the only supported identity namespace is the project's default.
        """
        return pulumi.get(self, "identity_namespace")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NodePoolAutoscaling(dict):
    def __init__(__self__, *,
                 max_node_count: int,
                 min_node_count: int):
        """
        :param int max_node_count: Maximum number of nodes in the NodePool. Must be >= min_node_count.
        :param int min_node_count: Minimum number of nodes in the NodePool. Must be >=0 and
               <= `max_node_count`.
        """
        pulumi.set(__self__, "max_node_count", max_node_count)
        pulumi.set(__self__, "min_node_count", min_node_count)

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> int:
        """
        Maximum number of nodes in the NodePool. Must be >= min_node_count.
        """
        return pulumi.get(self, "max_node_count")

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> int:
        """
        Minimum number of nodes in the NodePool. Must be >=0 and
        <= `max_node_count`.
        """
        return pulumi.get(self, "min_node_count")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NodePoolManagement(dict):
    def __init__(__self__, *,
                 auto_repair: Optional[bool] = None,
                 auto_upgrade: Optional[bool] = None):
        """
        :param bool auto_repair: Whether the nodes will be automatically repaired.
        :param bool auto_upgrade: Whether the nodes will be automatically upgraded.
        """
        if auto_repair is not None:
            pulumi.set(__self__, "auto_repair", auto_repair)
        if auto_upgrade is not None:
            pulumi.set(__self__, "auto_upgrade", auto_upgrade)

    @property
    @pulumi.getter(name="autoRepair")
    def auto_repair(self) -> Optional[bool]:
        """
        Whether the nodes will be automatically repaired.
        """
        return pulumi.get(self, "auto_repair")

    @property
    @pulumi.getter(name="autoUpgrade")
    def auto_upgrade(self) -> Optional[bool]:
        """
        Whether the nodes will be automatically upgraded.
        """
        return pulumi.get(self, "auto_upgrade")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NodePoolNodeConfig(dict):
    def __init__(__self__, *,
                 boot_disk_kms_key: Optional[str] = None,
                 disk_size_gb: Optional[int] = None,
                 disk_type: Optional[str] = None,
                 guest_accelerators: Optional[Sequence['outputs.NodePoolNodeConfigGuestAccelerator']] = None,
                 image_type: Optional[str] = None,
                 kubelet_config: Optional['outputs.NodePoolNodeConfigKubeletConfig'] = None,
                 labels: Optional[Mapping[str, str]] = None,
                 linux_node_config: Optional['outputs.NodePoolNodeConfigLinuxNodeConfig'] = None,
                 local_ssd_count: Optional[int] = None,
                 machine_type: Optional[str] = None,
                 metadata: Optional[Mapping[str, str]] = None,
                 min_cpu_platform: Optional[str] = None,
                 oauth_scopes: Optional[Sequence[str]] = None,
                 preemptible: Optional[bool] = None,
                 sandbox_config: Optional['outputs.NodePoolNodeConfigSandboxConfig'] = None,
                 service_account: Optional[str] = None,
                 shielded_instance_config: Optional['outputs.NodePoolNodeConfigShieldedInstanceConfig'] = None,
                 tags: Optional[Sequence[str]] = None,
                 taints: Optional[Sequence['outputs.NodePoolNodeConfigTaint']] = None,
                 workload_metadata_config: Optional['outputs.NodePoolNodeConfigWorkloadMetadataConfig'] = None):
        if boot_disk_kms_key is not None:
            pulumi.set(__self__, "boot_disk_kms_key", boot_disk_kms_key)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if guest_accelerators is not None:
            pulumi.set(__self__, "guest_accelerators", guest_accelerators)
        if image_type is not None:
            pulumi.set(__self__, "image_type", image_type)
        if kubelet_config is not None:
            pulumi.set(__self__, "kubelet_config", kubelet_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if linux_node_config is not None:
            pulumi.set(__self__, "linux_node_config", linux_node_config)
        if local_ssd_count is not None:
            pulumi.set(__self__, "local_ssd_count", local_ssd_count)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if oauth_scopes is not None:
            pulumi.set(__self__, "oauth_scopes", oauth_scopes)
        if preemptible is not None:
            pulumi.set(__self__, "preemptible", preemptible)
        if sandbox_config is not None:
            pulumi.set(__self__, "sandbox_config", sandbox_config)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if workload_metadata_config is not None:
            pulumi.set(__self__, "workload_metadata_config", workload_metadata_config)

    @property
    @pulumi.getter(name="bootDiskKmsKey")
    def boot_disk_kms_key(self) -> Optional[str]:
        return pulumi.get(self, "boot_disk_kms_key")

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[int]:
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[str]:
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="guestAccelerators")
    def guest_accelerators(self) -> Optional[Sequence['outputs.NodePoolNodeConfigGuestAccelerator']]:
        return pulumi.get(self, "guest_accelerators")

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[str]:
        return pulumi.get(self, "image_type")

    @property
    @pulumi.getter(name="kubeletConfig")
    def kubelet_config(self) -> Optional['outputs.NodePoolNodeConfigKubeletConfig']:
        return pulumi.get(self, "kubelet_config")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="linuxNodeConfig")
    def linux_node_config(self) -> Optional['outputs.NodePoolNodeConfigLinuxNodeConfig']:
        return pulumi.get(self, "linux_node_config")

    @property
    @pulumi.getter(name="localSsdCount")
    def local_ssd_count(self) -> Optional[int]:
        return pulumi.get(self, "local_ssd_count")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[str]:
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[str]:
        return pulumi.get(self, "min_cpu_platform")

    @property
    @pulumi.getter(name="oauthScopes")
    def oauth_scopes(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "oauth_scopes")

    @property
    @pulumi.getter
    def preemptible(self) -> Optional[bool]:
        return pulumi.get(self, "preemptible")

    @property
    @pulumi.getter(name="sandboxConfig")
    def sandbox_config(self) -> Optional['outputs.NodePoolNodeConfigSandboxConfig']:
        return pulumi.get(self, "sandbox_config")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[str]:
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional['outputs.NodePoolNodeConfigShieldedInstanceConfig']:
        return pulumi.get(self, "shielded_instance_config")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def taints(self) -> Optional[Sequence['outputs.NodePoolNodeConfigTaint']]:
        return pulumi.get(self, "taints")

    @property
    @pulumi.getter(name="workloadMetadataConfig")
    def workload_metadata_config(self) -> Optional['outputs.NodePoolNodeConfigWorkloadMetadataConfig']:
        return pulumi.get(self, "workload_metadata_config")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NodePoolNodeConfigGuestAccelerator(dict):
    def __init__(__self__, *,
                 count: int,
                 type: str):
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def count(self) -> int:
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NodePoolNodeConfigKubeletConfig(dict):
    def __init__(__self__, *,
                 cpu_manager_policy: str,
                 cpu_cfs_quota: Optional[bool] = None,
                 cpu_cfs_quota_period: Optional[str] = None):
        pulumi.set(__self__, "cpu_manager_policy", cpu_manager_policy)
        if cpu_cfs_quota is not None:
            pulumi.set(__self__, "cpu_cfs_quota", cpu_cfs_quota)
        if cpu_cfs_quota_period is not None:
            pulumi.set(__self__, "cpu_cfs_quota_period", cpu_cfs_quota_period)

    @property
    @pulumi.getter(name="cpuManagerPolicy")
    def cpu_manager_policy(self) -> str:
        return pulumi.get(self, "cpu_manager_policy")

    @property
    @pulumi.getter(name="cpuCfsQuota")
    def cpu_cfs_quota(self) -> Optional[bool]:
        return pulumi.get(self, "cpu_cfs_quota")

    @property
    @pulumi.getter(name="cpuCfsQuotaPeriod")
    def cpu_cfs_quota_period(self) -> Optional[str]:
        return pulumi.get(self, "cpu_cfs_quota_period")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NodePoolNodeConfigLinuxNodeConfig(dict):
    def __init__(__self__, *,
                 sysctls: Mapping[str, str]):
        pulumi.set(__self__, "sysctls", sysctls)

    @property
    @pulumi.getter
    def sysctls(self) -> Mapping[str, str]:
        return pulumi.get(self, "sysctls")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NodePoolNodeConfigSandboxConfig(dict):
    def __init__(__self__, *,
                 sandbox_type: str):
        pulumi.set(__self__, "sandbox_type", sandbox_type)

    @property
    @pulumi.getter(name="sandboxType")
    def sandbox_type(self) -> str:
        return pulumi.get(self, "sandbox_type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NodePoolNodeConfigShieldedInstanceConfig(dict):
    def __init__(__self__, *,
                 enable_integrity_monitoring: Optional[bool] = None,
                 enable_secure_boot: Optional[bool] = None):
        if enable_integrity_monitoring is not None:
            pulumi.set(__self__, "enable_integrity_monitoring", enable_integrity_monitoring)
        if enable_secure_boot is not None:
            pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)

    @property
    @pulumi.getter(name="enableIntegrityMonitoring")
    def enable_integrity_monitoring(self) -> Optional[bool]:
        return pulumi.get(self, "enable_integrity_monitoring")

    @property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> Optional[bool]:
        return pulumi.get(self, "enable_secure_boot")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NodePoolNodeConfigTaint(dict):
    def __init__(__self__, *,
                 effect: str,
                 key: str,
                 value: str):
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> str:
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NodePoolNodeConfigWorkloadMetadataConfig(dict):
    def __init__(__self__, *,
                 node_metadata: str):
        pulumi.set(__self__, "node_metadata", node_metadata)

    @property
    @pulumi.getter(name="nodeMetadata")
    def node_metadata(self) -> str:
        return pulumi.get(self, "node_metadata")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NodePoolUpgradeSettings(dict):
    def __init__(__self__, *,
                 max_surge: int,
                 max_unavailable: int):
        """
        :param int max_surge: The number of additional nodes that can be added to the node pool during
               an upgrade. Increasing `max_surge` raises the number of nodes that can be upgraded simultaneously.
               Can be set to 0 or greater.
        :param int max_unavailable: The number of nodes that can be simultaneously unavailable during
               an upgrade. Increasing `max_unavailable` raises the number of nodes that can be upgraded in
               parallel. Can be set to 0 or greater.
        """
        pulumi.set(__self__, "max_surge", max_surge)
        pulumi.set(__self__, "max_unavailable", max_unavailable)

    @property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> int:
        """
        The number of additional nodes that can be added to the node pool during
        an upgrade. Increasing `max_surge` raises the number of nodes that can be upgraded simultaneously.
        Can be set to 0 or greater.
        """
        return pulumi.get(self, "max_surge")

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> int:
        """
        The number of nodes that can be simultaneously unavailable during
        an upgrade. Increasing `max_unavailable` raises the number of nodes that can be upgraded in
        parallel. Can be set to 0 or greater.
        """
        return pulumi.get(self, "max_unavailable")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GetClusterAddonsConfigResult(dict):
    def __init__(__self__, *,
                 cloudrun_configs: Sequence['outputs.GetClusterAddonsConfigCloudrunConfigResult'],
                 config_connector_configs: Sequence['outputs.GetClusterAddonsConfigConfigConnectorConfigResult'],
                 dns_cache_configs: Sequence['outputs.GetClusterAddonsConfigDnsCacheConfigResult'],
                 gce_persistent_disk_csi_driver_configs: Sequence['outputs.GetClusterAddonsConfigGcePersistentDiskCsiDriverConfigResult'],
                 horizontal_pod_autoscalings: Sequence['outputs.GetClusterAddonsConfigHorizontalPodAutoscalingResult'],
                 http_load_balancings: Sequence['outputs.GetClusterAddonsConfigHttpLoadBalancingResult'],
                 istio_configs: Sequence['outputs.GetClusterAddonsConfigIstioConfigResult'],
                 kalm_configs: Sequence['outputs.GetClusterAddonsConfigKalmConfigResult'],
                 network_policy_configs: Sequence['outputs.GetClusterAddonsConfigNetworkPolicyConfigResult']):
        pulumi.set(__self__, "cloudrun_configs", cloudrun_configs)
        pulumi.set(__self__, "config_connector_configs", config_connector_configs)
        pulumi.set(__self__, "dns_cache_configs", dns_cache_configs)
        pulumi.set(__self__, "gce_persistent_disk_csi_driver_configs", gce_persistent_disk_csi_driver_configs)
        pulumi.set(__self__, "horizontal_pod_autoscalings", horizontal_pod_autoscalings)
        pulumi.set(__self__, "http_load_balancings", http_load_balancings)
        pulumi.set(__self__, "istio_configs", istio_configs)
        pulumi.set(__self__, "kalm_configs", kalm_configs)
        pulumi.set(__self__, "network_policy_configs", network_policy_configs)

    @property
    @pulumi.getter(name="cloudrunConfigs")
    def cloudrun_configs(self) -> Sequence['outputs.GetClusterAddonsConfigCloudrunConfigResult']:
        return pulumi.get(self, "cloudrun_configs")

    @property
    @pulumi.getter(name="configConnectorConfigs")
    def config_connector_configs(self) -> Sequence['outputs.GetClusterAddonsConfigConfigConnectorConfigResult']:
        return pulumi.get(self, "config_connector_configs")

    @property
    @pulumi.getter(name="dnsCacheConfigs")
    def dns_cache_configs(self) -> Sequence['outputs.GetClusterAddonsConfigDnsCacheConfigResult']:
        return pulumi.get(self, "dns_cache_configs")

    @property
    @pulumi.getter(name="gcePersistentDiskCsiDriverConfigs")
    def gce_persistent_disk_csi_driver_configs(self) -> Sequence['outputs.GetClusterAddonsConfigGcePersistentDiskCsiDriverConfigResult']:
        return pulumi.get(self, "gce_persistent_disk_csi_driver_configs")

    @property
    @pulumi.getter(name="horizontalPodAutoscalings")
    def horizontal_pod_autoscalings(self) -> Sequence['outputs.GetClusterAddonsConfigHorizontalPodAutoscalingResult']:
        return pulumi.get(self, "horizontal_pod_autoscalings")

    @property
    @pulumi.getter(name="httpLoadBalancings")
    def http_load_balancings(self) -> Sequence['outputs.GetClusterAddonsConfigHttpLoadBalancingResult']:
        return pulumi.get(self, "http_load_balancings")

    @property
    @pulumi.getter(name="istioConfigs")
    def istio_configs(self) -> Sequence['outputs.GetClusterAddonsConfigIstioConfigResult']:
        return pulumi.get(self, "istio_configs")

    @property
    @pulumi.getter(name="kalmConfigs")
    def kalm_configs(self) -> Sequence['outputs.GetClusterAddonsConfigKalmConfigResult']:
        return pulumi.get(self, "kalm_configs")

    @property
    @pulumi.getter(name="networkPolicyConfigs")
    def network_policy_configs(self) -> Sequence['outputs.GetClusterAddonsConfigNetworkPolicyConfigResult']:
        return pulumi.get(self, "network_policy_configs")


@pulumi.output_type
class GetClusterAddonsConfigCloudrunConfigResult(dict):
    def __init__(__self__, *,
                 disabled: bool,
                 load_balancer_type: str):
        pulumi.set(__self__, "disabled", disabled)
        pulumi.set(__self__, "load_balancer_type", load_balancer_type)

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> str:
        return pulumi.get(self, "load_balancer_type")


@pulumi.output_type
class GetClusterAddonsConfigConfigConnectorConfigResult(dict):
    def __init__(__self__, *,
                 enabled: bool):
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetClusterAddonsConfigDnsCacheConfigResult(dict):
    def __init__(__self__, *,
                 enabled: bool):
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetClusterAddonsConfigGcePersistentDiskCsiDriverConfigResult(dict):
    def __init__(__self__, *,
                 enabled: bool):
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetClusterAddonsConfigHorizontalPodAutoscalingResult(dict):
    def __init__(__self__, *,
                 disabled: bool):
        pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        return pulumi.get(self, "disabled")


@pulumi.output_type
class GetClusterAddonsConfigHttpLoadBalancingResult(dict):
    def __init__(__self__, *,
                 disabled: bool):
        pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        return pulumi.get(self, "disabled")


@pulumi.output_type
class GetClusterAddonsConfigIstioConfigResult(dict):
    def __init__(__self__, *,
                 auth: str,
                 disabled: bool):
        pulumi.set(__self__, "auth", auth)
        pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def auth(self) -> str:
        return pulumi.get(self, "auth")

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        return pulumi.get(self, "disabled")


@pulumi.output_type
class GetClusterAddonsConfigKalmConfigResult(dict):
    def __init__(__self__, *,
                 enabled: bool):
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetClusterAddonsConfigNetworkPolicyConfigResult(dict):
    def __init__(__self__, *,
                 disabled: bool):
        pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        return pulumi.get(self, "disabled")


@pulumi.output_type
class GetClusterAuthenticatorGroupsConfigResult(dict):
    def __init__(__self__, *,
                 security_group: str):
        pulumi.set(__self__, "security_group", security_group)

    @property
    @pulumi.getter(name="securityGroup")
    def security_group(self) -> str:
        return pulumi.get(self, "security_group")


@pulumi.output_type
class GetClusterClusterAutoscalingResult(dict):
    def __init__(__self__, *,
                 auto_provisioning_defaults: Sequence['outputs.GetClusterClusterAutoscalingAutoProvisioningDefaultResult'],
                 autoscaling_profile: str,
                 enabled: bool,
                 resource_limits: Sequence['outputs.GetClusterClusterAutoscalingResourceLimitResult']):
        pulumi.set(__self__, "auto_provisioning_defaults", auto_provisioning_defaults)
        pulumi.set(__self__, "autoscaling_profile", autoscaling_profile)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "resource_limits", resource_limits)

    @property
    @pulumi.getter(name="autoProvisioningDefaults")
    def auto_provisioning_defaults(self) -> Sequence['outputs.GetClusterClusterAutoscalingAutoProvisioningDefaultResult']:
        return pulumi.get(self, "auto_provisioning_defaults")

    @property
    @pulumi.getter(name="autoscalingProfile")
    def autoscaling_profile(self) -> str:
        return pulumi.get(self, "autoscaling_profile")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="resourceLimits")
    def resource_limits(self) -> Sequence['outputs.GetClusterClusterAutoscalingResourceLimitResult']:
        return pulumi.get(self, "resource_limits")


@pulumi.output_type
class GetClusterClusterAutoscalingAutoProvisioningDefaultResult(dict):
    def __init__(__self__, *,
                 min_cpu_platform: str,
                 oauth_scopes: Sequence[str],
                 service_account: str):
        pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        pulumi.set(__self__, "oauth_scopes", oauth_scopes)
        pulumi.set(__self__, "service_account", service_account)

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> str:
        return pulumi.get(self, "min_cpu_platform")

    @property
    @pulumi.getter(name="oauthScopes")
    def oauth_scopes(self) -> Sequence[str]:
        return pulumi.get(self, "oauth_scopes")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        return pulumi.get(self, "service_account")


@pulumi.output_type
class GetClusterClusterAutoscalingResourceLimitResult(dict):
    def __init__(__self__, *,
                 maximum: int,
                 minimum: int,
                 resource_type: str):
        pulumi.set(__self__, "maximum", maximum)
        pulumi.set(__self__, "minimum", minimum)
        pulumi.set(__self__, "resource_type", resource_type)

    @property
    @pulumi.getter
    def maximum(self) -> int:
        return pulumi.get(self, "maximum")

    @property
    @pulumi.getter
    def minimum(self) -> int:
        return pulumi.get(self, "minimum")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class GetClusterClusterTelemetryResult(dict):
    def __init__(__self__, *,
                 type: str):
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetClusterConfidentialNodeResult(dict):
    def __init__(__self__, *,
                 enabled: bool):
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetClusterDatabaseEncryptionResult(dict):
    def __init__(__self__, *,
                 key_name: str,
                 state: str):
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter
    def state(self) -> str:
        return pulumi.get(self, "state")


@pulumi.output_type
class GetClusterDefaultSnatStatusResult(dict):
    def __init__(__self__, *,
                 disabled: bool):
        pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        return pulumi.get(self, "disabled")


@pulumi.output_type
class GetClusterIpAllocationPolicyResult(dict):
    def __init__(__self__, *,
                 cluster_ipv4_cidr_block: str,
                 cluster_secondary_range_name: str,
                 services_ipv4_cidr_block: str,
                 services_secondary_range_name: str):
        pulumi.set(__self__, "cluster_ipv4_cidr_block", cluster_ipv4_cidr_block)
        pulumi.set(__self__, "cluster_secondary_range_name", cluster_secondary_range_name)
        pulumi.set(__self__, "services_ipv4_cidr_block", services_ipv4_cidr_block)
        pulumi.set(__self__, "services_secondary_range_name", services_secondary_range_name)

    @property
    @pulumi.getter(name="clusterIpv4CidrBlock")
    def cluster_ipv4_cidr_block(self) -> str:
        return pulumi.get(self, "cluster_ipv4_cidr_block")

    @property
    @pulumi.getter(name="clusterSecondaryRangeName")
    def cluster_secondary_range_name(self) -> str:
        return pulumi.get(self, "cluster_secondary_range_name")

    @property
    @pulumi.getter(name="servicesIpv4CidrBlock")
    def services_ipv4_cidr_block(self) -> str:
        return pulumi.get(self, "services_ipv4_cidr_block")

    @property
    @pulumi.getter(name="servicesSecondaryRangeName")
    def services_secondary_range_name(self) -> str:
        return pulumi.get(self, "services_secondary_range_name")


@pulumi.output_type
class GetClusterMaintenancePolicyResult(dict):
    def __init__(__self__, *,
                 daily_maintenance_windows: Sequence['outputs.GetClusterMaintenancePolicyDailyMaintenanceWindowResult'],
                 maintenance_exclusions: Sequence['outputs.GetClusterMaintenancePolicyMaintenanceExclusionResult'],
                 recurring_windows: Sequence['outputs.GetClusterMaintenancePolicyRecurringWindowResult']):
        pulumi.set(__self__, "daily_maintenance_windows", daily_maintenance_windows)
        pulumi.set(__self__, "maintenance_exclusions", maintenance_exclusions)
        pulumi.set(__self__, "recurring_windows", recurring_windows)

    @property
    @pulumi.getter(name="dailyMaintenanceWindows")
    def daily_maintenance_windows(self) -> Sequence['outputs.GetClusterMaintenancePolicyDailyMaintenanceWindowResult']:
        return pulumi.get(self, "daily_maintenance_windows")

    @property
    @pulumi.getter(name="maintenanceExclusions")
    def maintenance_exclusions(self) -> Sequence['outputs.GetClusterMaintenancePolicyMaintenanceExclusionResult']:
        return pulumi.get(self, "maintenance_exclusions")

    @property
    @pulumi.getter(name="recurringWindows")
    def recurring_windows(self) -> Sequence['outputs.GetClusterMaintenancePolicyRecurringWindowResult']:
        return pulumi.get(self, "recurring_windows")


@pulumi.output_type
class GetClusterMaintenancePolicyDailyMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 duration: str,
                 start_time: str):
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def duration(self) -> str:
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        return pulumi.get(self, "start_time")


@pulumi.output_type
class GetClusterMaintenancePolicyMaintenanceExclusionResult(dict):
    def __init__(__self__, *,
                 end_time: str,
                 exclusion_name: str,
                 start_time: str):
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "exclusion_name", exclusion_name)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="exclusionName")
    def exclusion_name(self) -> str:
        return pulumi.get(self, "exclusion_name")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        return pulumi.get(self, "start_time")


@pulumi.output_type
class GetClusterMaintenancePolicyRecurringWindowResult(dict):
    def __init__(__self__, *,
                 end_time: str,
                 recurrence: str,
                 start_time: str):
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "recurrence", recurrence)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def recurrence(self) -> str:
        return pulumi.get(self, "recurrence")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        return pulumi.get(self, "start_time")


@pulumi.output_type
class GetClusterMasterAuthResult(dict):
    def __init__(__self__, *,
                 client_certificate: str,
                 client_certificate_configs: Sequence['outputs.GetClusterMasterAuthClientCertificateConfigResult'],
                 client_key: str,
                 cluster_ca_certificate: str,
                 password: str,
                 username: str):
        pulumi.set(__self__, "client_certificate", client_certificate)
        pulumi.set(__self__, "client_certificate_configs", client_certificate_configs)
        pulumi.set(__self__, "client_key", client_key)
        pulumi.set(__self__, "cluster_ca_certificate", cluster_ca_certificate)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> str:
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientCertificateConfigs")
    def client_certificate_configs(self) -> Sequence['outputs.GetClusterMasterAuthClientCertificateConfigResult']:
        return pulumi.get(self, "client_certificate_configs")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> str:
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> str:
        return pulumi.get(self, "cluster_ca_certificate")

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")


@pulumi.output_type
class GetClusterMasterAuthClientCertificateConfigResult(dict):
    def __init__(__self__, *,
                 issue_client_certificate: bool):
        pulumi.set(__self__, "issue_client_certificate", issue_client_certificate)

    @property
    @pulumi.getter(name="issueClientCertificate")
    def issue_client_certificate(self) -> bool:
        return pulumi.get(self, "issue_client_certificate")


@pulumi.output_type
class GetClusterMasterAuthorizedNetworksConfigResult(dict):
    def __init__(__self__, *,
                 cidr_blocks: Sequence['outputs.GetClusterMasterAuthorizedNetworksConfigCidrBlockResult']):
        pulumi.set(__self__, "cidr_blocks", cidr_blocks)

    @property
    @pulumi.getter(name="cidrBlocks")
    def cidr_blocks(self) -> Sequence['outputs.GetClusterMasterAuthorizedNetworksConfigCidrBlockResult']:
        return pulumi.get(self, "cidr_blocks")


@pulumi.output_type
class GetClusterMasterAuthorizedNetworksConfigCidrBlockResult(dict):
    def __init__(__self__, *,
                 cidr_block: str,
                 display_name: str):
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> str:
        return pulumi.get(self, "cidr_block")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        return pulumi.get(self, "display_name")


@pulumi.output_type
class GetClusterNetworkPolicyResult(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 provider: str):
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "provider", provider)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def provider(self) -> str:
        return pulumi.get(self, "provider")


@pulumi.output_type
class GetClusterNodeConfigResult(dict):
    def __init__(__self__, *,
                 boot_disk_kms_key: str,
                 disk_size_gb: int,
                 disk_type: str,
                 guest_accelerators: Sequence['outputs.GetClusterNodeConfigGuestAcceleratorResult'],
                 image_type: str,
                 kubelet_configs: Sequence['outputs.GetClusterNodeConfigKubeletConfigResult'],
                 labels: Mapping[str, str],
                 linux_node_configs: Sequence['outputs.GetClusterNodeConfigLinuxNodeConfigResult'],
                 local_ssd_count: int,
                 machine_type: str,
                 metadata: Mapping[str, str],
                 min_cpu_platform: str,
                 oauth_scopes: Sequence[str],
                 preemptible: bool,
                 sandbox_configs: Sequence['outputs.GetClusterNodeConfigSandboxConfigResult'],
                 service_account: str,
                 shielded_instance_configs: Sequence['outputs.GetClusterNodeConfigShieldedInstanceConfigResult'],
                 tags: Sequence[str],
                 taints: Sequence['outputs.GetClusterNodeConfigTaintResult'],
                 workload_metadata_configs: Sequence['outputs.GetClusterNodeConfigWorkloadMetadataConfigResult']):
        pulumi.set(__self__, "boot_disk_kms_key", boot_disk_kms_key)
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "guest_accelerators", guest_accelerators)
        pulumi.set(__self__, "image_type", image_type)
        pulumi.set(__self__, "kubelet_configs", kubelet_configs)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "linux_node_configs", linux_node_configs)
        pulumi.set(__self__, "local_ssd_count", local_ssd_count)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        pulumi.set(__self__, "oauth_scopes", oauth_scopes)
        pulumi.set(__self__, "preemptible", preemptible)
        pulumi.set(__self__, "sandbox_configs", sandbox_configs)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "shielded_instance_configs", shielded_instance_configs)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "taints", taints)
        pulumi.set(__self__, "workload_metadata_configs", workload_metadata_configs)

    @property
    @pulumi.getter(name="bootDiskKmsKey")
    def boot_disk_kms_key(self) -> str:
        return pulumi.get(self, "boot_disk_kms_key")

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> int:
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> str:
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="guestAccelerators")
    def guest_accelerators(self) -> Sequence['outputs.GetClusterNodeConfigGuestAcceleratorResult']:
        return pulumi.get(self, "guest_accelerators")

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> str:
        return pulumi.get(self, "image_type")

    @property
    @pulumi.getter(name="kubeletConfigs")
    def kubelet_configs(self) -> Sequence['outputs.GetClusterNodeConfigKubeletConfigResult']:
        return pulumi.get(self, "kubelet_configs")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="linuxNodeConfigs")
    def linux_node_configs(self) -> Sequence['outputs.GetClusterNodeConfigLinuxNodeConfigResult']:
        return pulumi.get(self, "linux_node_configs")

    @property
    @pulumi.getter(name="localSsdCount")
    def local_ssd_count(self) -> int:
        return pulumi.get(self, "local_ssd_count")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> str:
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, str]:
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> str:
        return pulumi.get(self, "min_cpu_platform")

    @property
    @pulumi.getter(name="oauthScopes")
    def oauth_scopes(self) -> Sequence[str]:
        return pulumi.get(self, "oauth_scopes")

    @property
    @pulumi.getter
    def preemptible(self) -> bool:
        return pulumi.get(self, "preemptible")

    @property
    @pulumi.getter(name="sandboxConfigs")
    def sandbox_configs(self) -> Sequence['outputs.GetClusterNodeConfigSandboxConfigResult']:
        return pulumi.get(self, "sandbox_configs")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="shieldedInstanceConfigs")
    def shielded_instance_configs(self) -> Sequence['outputs.GetClusterNodeConfigShieldedInstanceConfigResult']:
        return pulumi.get(self, "shielded_instance_configs")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def taints(self) -> Sequence['outputs.GetClusterNodeConfigTaintResult']:
        return pulumi.get(self, "taints")

    @property
    @pulumi.getter(name="workloadMetadataConfigs")
    def workload_metadata_configs(self) -> Sequence['outputs.GetClusterNodeConfigWorkloadMetadataConfigResult']:
        return pulumi.get(self, "workload_metadata_configs")


@pulumi.output_type
class GetClusterNodeConfigGuestAcceleratorResult(dict):
    def __init__(__self__, *,
                 count: int,
                 type: str):
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def count(self) -> int:
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetClusterNodeConfigKubeletConfigResult(dict):
    def __init__(__self__, *,
                 cpu_cfs_quota: bool,
                 cpu_cfs_quota_period: str,
                 cpu_manager_policy: str):
        pulumi.set(__self__, "cpu_cfs_quota", cpu_cfs_quota)
        pulumi.set(__self__, "cpu_cfs_quota_period", cpu_cfs_quota_period)
        pulumi.set(__self__, "cpu_manager_policy", cpu_manager_policy)

    @property
    @pulumi.getter(name="cpuCfsQuota")
    def cpu_cfs_quota(self) -> bool:
        return pulumi.get(self, "cpu_cfs_quota")

    @property
    @pulumi.getter(name="cpuCfsQuotaPeriod")
    def cpu_cfs_quota_period(self) -> str:
        return pulumi.get(self, "cpu_cfs_quota_period")

    @property
    @pulumi.getter(name="cpuManagerPolicy")
    def cpu_manager_policy(self) -> str:
        return pulumi.get(self, "cpu_manager_policy")


@pulumi.output_type
class GetClusterNodeConfigLinuxNodeConfigResult(dict):
    def __init__(__self__, *,
                 sysctls: Mapping[str, str]):
        pulumi.set(__self__, "sysctls", sysctls)

    @property
    @pulumi.getter
    def sysctls(self) -> Mapping[str, str]:
        return pulumi.get(self, "sysctls")


@pulumi.output_type
class GetClusterNodeConfigSandboxConfigResult(dict):
    def __init__(__self__, *,
                 sandbox_type: str):
        pulumi.set(__self__, "sandbox_type", sandbox_type)

    @property
    @pulumi.getter(name="sandboxType")
    def sandbox_type(self) -> str:
        return pulumi.get(self, "sandbox_type")


@pulumi.output_type
class GetClusterNodeConfigShieldedInstanceConfigResult(dict):
    def __init__(__self__, *,
                 enable_integrity_monitoring: bool,
                 enable_secure_boot: bool):
        pulumi.set(__self__, "enable_integrity_monitoring", enable_integrity_monitoring)
        pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)

    @property
    @pulumi.getter(name="enableIntegrityMonitoring")
    def enable_integrity_monitoring(self) -> bool:
        return pulumi.get(self, "enable_integrity_monitoring")

    @property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> bool:
        return pulumi.get(self, "enable_secure_boot")


@pulumi.output_type
class GetClusterNodeConfigTaintResult(dict):
    def __init__(__self__, *,
                 effect: str,
                 key: str,
                 value: str):
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> str:
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetClusterNodeConfigWorkloadMetadataConfigResult(dict):
    def __init__(__self__, *,
                 node_metadata: str):
        pulumi.set(__self__, "node_metadata", node_metadata)

    @property
    @pulumi.getter(name="nodeMetadata")
    def node_metadata(self) -> str:
        return pulumi.get(self, "node_metadata")


@pulumi.output_type
class GetClusterNodePoolResult(dict):
    def __init__(__self__, *,
                 autoscalings: Sequence['outputs.GetClusterNodePoolAutoscalingResult'],
                 initial_node_count: int,
                 instance_group_urls: Sequence[str],
                 managements: Sequence['outputs.GetClusterNodePoolManagementResult'],
                 max_pods_per_node: int,
                 name: str,
                 name_prefix: str,
                 node_configs: Sequence['outputs.GetClusterNodePoolNodeConfigResult'],
                 node_count: int,
                 node_locations: Sequence[str],
                 upgrade_settings: Sequence['outputs.GetClusterNodePoolUpgradeSettingResult'],
                 version: str):
        """
        :param str name: The name of the cluster.
        """
        pulumi.set(__self__, "autoscalings", autoscalings)
        pulumi.set(__self__, "initial_node_count", initial_node_count)
        pulumi.set(__self__, "instance_group_urls", instance_group_urls)
        pulumi.set(__self__, "managements", managements)
        pulumi.set(__self__, "max_pods_per_node", max_pods_per_node)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "name_prefix", name_prefix)
        pulumi.set(__self__, "node_configs", node_configs)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "node_locations", node_locations)
        pulumi.set(__self__, "upgrade_settings", upgrade_settings)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def autoscalings(self) -> Sequence['outputs.GetClusterNodePoolAutoscalingResult']:
        return pulumi.get(self, "autoscalings")

    @property
    @pulumi.getter(name="initialNodeCount")
    def initial_node_count(self) -> int:
        return pulumi.get(self, "initial_node_count")

    @property
    @pulumi.getter(name="instanceGroupUrls")
    def instance_group_urls(self) -> Sequence[str]:
        return pulumi.get(self, "instance_group_urls")

    @property
    @pulumi.getter
    def managements(self) -> Sequence['outputs.GetClusterNodePoolManagementResult']:
        return pulumi.get(self, "managements")

    @property
    @pulumi.getter(name="maxPodsPerNode")
    def max_pods_per_node(self) -> int:
        return pulumi.get(self, "max_pods_per_node")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the cluster.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> str:
        return pulumi.get(self, "name_prefix")

    @property
    @pulumi.getter(name="nodeConfigs")
    def node_configs(self) -> Sequence['outputs.GetClusterNodePoolNodeConfigResult']:
        return pulumi.get(self, "node_configs")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> int:
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nodeLocations")
    def node_locations(self) -> Sequence[str]:
        return pulumi.get(self, "node_locations")

    @property
    @pulumi.getter(name="upgradeSettings")
    def upgrade_settings(self) -> Sequence['outputs.GetClusterNodePoolUpgradeSettingResult']:
        return pulumi.get(self, "upgrade_settings")

    @property
    @pulumi.getter
    def version(self) -> str:
        return pulumi.get(self, "version")


@pulumi.output_type
class GetClusterNodePoolAutoscalingResult(dict):
    def __init__(__self__, *,
                 max_node_count: int,
                 min_node_count: int):
        pulumi.set(__self__, "max_node_count", max_node_count)
        pulumi.set(__self__, "min_node_count", min_node_count)

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> int:
        return pulumi.get(self, "max_node_count")

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> int:
        return pulumi.get(self, "min_node_count")


@pulumi.output_type
class GetClusterNodePoolManagementResult(dict):
    def __init__(__self__, *,
                 auto_repair: bool,
                 auto_upgrade: bool):
        pulumi.set(__self__, "auto_repair", auto_repair)
        pulumi.set(__self__, "auto_upgrade", auto_upgrade)

    @property
    @pulumi.getter(name="autoRepair")
    def auto_repair(self) -> bool:
        return pulumi.get(self, "auto_repair")

    @property
    @pulumi.getter(name="autoUpgrade")
    def auto_upgrade(self) -> bool:
        return pulumi.get(self, "auto_upgrade")


@pulumi.output_type
class GetClusterNodePoolNodeConfigResult(dict):
    def __init__(__self__, *,
                 boot_disk_kms_key: str,
                 disk_size_gb: int,
                 disk_type: str,
                 guest_accelerators: Sequence['outputs.GetClusterNodePoolNodeConfigGuestAcceleratorResult'],
                 image_type: str,
                 kubelet_configs: Sequence['outputs.GetClusterNodePoolNodeConfigKubeletConfigResult'],
                 labels: Mapping[str, str],
                 linux_node_configs: Sequence['outputs.GetClusterNodePoolNodeConfigLinuxNodeConfigResult'],
                 local_ssd_count: int,
                 machine_type: str,
                 metadata: Mapping[str, str],
                 min_cpu_platform: str,
                 oauth_scopes: Sequence[str],
                 preemptible: bool,
                 sandbox_configs: Sequence['outputs.GetClusterNodePoolNodeConfigSandboxConfigResult'],
                 service_account: str,
                 shielded_instance_configs: Sequence['outputs.GetClusterNodePoolNodeConfigShieldedInstanceConfigResult'],
                 tags: Sequence[str],
                 taints: Sequence['outputs.GetClusterNodePoolNodeConfigTaintResult'],
                 workload_metadata_configs: Sequence['outputs.GetClusterNodePoolNodeConfigWorkloadMetadataConfigResult']):
        pulumi.set(__self__, "boot_disk_kms_key", boot_disk_kms_key)
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "guest_accelerators", guest_accelerators)
        pulumi.set(__self__, "image_type", image_type)
        pulumi.set(__self__, "kubelet_configs", kubelet_configs)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "linux_node_configs", linux_node_configs)
        pulumi.set(__self__, "local_ssd_count", local_ssd_count)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        pulumi.set(__self__, "oauth_scopes", oauth_scopes)
        pulumi.set(__self__, "preemptible", preemptible)
        pulumi.set(__self__, "sandbox_configs", sandbox_configs)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "shielded_instance_configs", shielded_instance_configs)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "taints", taints)
        pulumi.set(__self__, "workload_metadata_configs", workload_metadata_configs)

    @property
    @pulumi.getter(name="bootDiskKmsKey")
    def boot_disk_kms_key(self) -> str:
        return pulumi.get(self, "boot_disk_kms_key")

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> int:
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> str:
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="guestAccelerators")
    def guest_accelerators(self) -> Sequence['outputs.GetClusterNodePoolNodeConfigGuestAcceleratorResult']:
        return pulumi.get(self, "guest_accelerators")

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> str:
        return pulumi.get(self, "image_type")

    @property
    @pulumi.getter(name="kubeletConfigs")
    def kubelet_configs(self) -> Sequence['outputs.GetClusterNodePoolNodeConfigKubeletConfigResult']:
        return pulumi.get(self, "kubelet_configs")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="linuxNodeConfigs")
    def linux_node_configs(self) -> Sequence['outputs.GetClusterNodePoolNodeConfigLinuxNodeConfigResult']:
        return pulumi.get(self, "linux_node_configs")

    @property
    @pulumi.getter(name="localSsdCount")
    def local_ssd_count(self) -> int:
        return pulumi.get(self, "local_ssd_count")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> str:
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, str]:
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> str:
        return pulumi.get(self, "min_cpu_platform")

    @property
    @pulumi.getter(name="oauthScopes")
    def oauth_scopes(self) -> Sequence[str]:
        return pulumi.get(self, "oauth_scopes")

    @property
    @pulumi.getter
    def preemptible(self) -> bool:
        return pulumi.get(self, "preemptible")

    @property
    @pulumi.getter(name="sandboxConfigs")
    def sandbox_configs(self) -> Sequence['outputs.GetClusterNodePoolNodeConfigSandboxConfigResult']:
        return pulumi.get(self, "sandbox_configs")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="shieldedInstanceConfigs")
    def shielded_instance_configs(self) -> Sequence['outputs.GetClusterNodePoolNodeConfigShieldedInstanceConfigResult']:
        return pulumi.get(self, "shielded_instance_configs")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def taints(self) -> Sequence['outputs.GetClusterNodePoolNodeConfigTaintResult']:
        return pulumi.get(self, "taints")

    @property
    @pulumi.getter(name="workloadMetadataConfigs")
    def workload_metadata_configs(self) -> Sequence['outputs.GetClusterNodePoolNodeConfigWorkloadMetadataConfigResult']:
        return pulumi.get(self, "workload_metadata_configs")


@pulumi.output_type
class GetClusterNodePoolNodeConfigGuestAcceleratorResult(dict):
    def __init__(__self__, *,
                 count: int,
                 type: str):
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def count(self) -> int:
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetClusterNodePoolNodeConfigKubeletConfigResult(dict):
    def __init__(__self__, *,
                 cpu_cfs_quota: bool,
                 cpu_cfs_quota_period: str,
                 cpu_manager_policy: str):
        pulumi.set(__self__, "cpu_cfs_quota", cpu_cfs_quota)
        pulumi.set(__self__, "cpu_cfs_quota_period", cpu_cfs_quota_period)
        pulumi.set(__self__, "cpu_manager_policy", cpu_manager_policy)

    @property
    @pulumi.getter(name="cpuCfsQuota")
    def cpu_cfs_quota(self) -> bool:
        return pulumi.get(self, "cpu_cfs_quota")

    @property
    @pulumi.getter(name="cpuCfsQuotaPeriod")
    def cpu_cfs_quota_period(self) -> str:
        return pulumi.get(self, "cpu_cfs_quota_period")

    @property
    @pulumi.getter(name="cpuManagerPolicy")
    def cpu_manager_policy(self) -> str:
        return pulumi.get(self, "cpu_manager_policy")


@pulumi.output_type
class GetClusterNodePoolNodeConfigLinuxNodeConfigResult(dict):
    def __init__(__self__, *,
                 sysctls: Mapping[str, str]):
        pulumi.set(__self__, "sysctls", sysctls)

    @property
    @pulumi.getter
    def sysctls(self) -> Mapping[str, str]:
        return pulumi.get(self, "sysctls")


@pulumi.output_type
class GetClusterNodePoolNodeConfigSandboxConfigResult(dict):
    def __init__(__self__, *,
                 sandbox_type: str):
        pulumi.set(__self__, "sandbox_type", sandbox_type)

    @property
    @pulumi.getter(name="sandboxType")
    def sandbox_type(self) -> str:
        return pulumi.get(self, "sandbox_type")


@pulumi.output_type
class GetClusterNodePoolNodeConfigShieldedInstanceConfigResult(dict):
    def __init__(__self__, *,
                 enable_integrity_monitoring: bool,
                 enable_secure_boot: bool):
        pulumi.set(__self__, "enable_integrity_monitoring", enable_integrity_monitoring)
        pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)

    @property
    @pulumi.getter(name="enableIntegrityMonitoring")
    def enable_integrity_monitoring(self) -> bool:
        return pulumi.get(self, "enable_integrity_monitoring")

    @property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> bool:
        return pulumi.get(self, "enable_secure_boot")


@pulumi.output_type
class GetClusterNodePoolNodeConfigTaintResult(dict):
    def __init__(__self__, *,
                 effect: str,
                 key: str,
                 value: str):
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> str:
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetClusterNodePoolNodeConfigWorkloadMetadataConfigResult(dict):
    def __init__(__self__, *,
                 node_metadata: str):
        pulumi.set(__self__, "node_metadata", node_metadata)

    @property
    @pulumi.getter(name="nodeMetadata")
    def node_metadata(self) -> str:
        return pulumi.get(self, "node_metadata")


@pulumi.output_type
class GetClusterNodePoolUpgradeSettingResult(dict):
    def __init__(__self__, *,
                 max_surge: int,
                 max_unavailable: int):
        pulumi.set(__self__, "max_surge", max_surge)
        pulumi.set(__self__, "max_unavailable", max_unavailable)

    @property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> int:
        return pulumi.get(self, "max_surge")

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> int:
        return pulumi.get(self, "max_unavailable")


@pulumi.output_type
class GetClusterNotificationConfigResult(dict):
    def __init__(__self__, *,
                 pubsubs: Sequence['outputs.GetClusterNotificationConfigPubsubResult']):
        pulumi.set(__self__, "pubsubs", pubsubs)

    @property
    @pulumi.getter
    def pubsubs(self) -> Sequence['outputs.GetClusterNotificationConfigPubsubResult']:
        return pulumi.get(self, "pubsubs")


@pulumi.output_type
class GetClusterNotificationConfigPubsubResult(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 topic: str):
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def topic(self) -> str:
        return pulumi.get(self, "topic")


@pulumi.output_type
class GetClusterPodSecurityPolicyConfigResult(dict):
    def __init__(__self__, *,
                 enabled: bool):
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetClusterPrivateClusterConfigResult(dict):
    def __init__(__self__, *,
                 enable_private_endpoint: bool,
                 enable_private_nodes: bool,
                 master_global_access_configs: Sequence['outputs.GetClusterPrivateClusterConfigMasterGlobalAccessConfigResult'],
                 master_ipv4_cidr_block: str,
                 peering_name: str,
                 private_endpoint: str,
                 public_endpoint: str):
        pulumi.set(__self__, "enable_private_endpoint", enable_private_endpoint)
        pulumi.set(__self__, "enable_private_nodes", enable_private_nodes)
        pulumi.set(__self__, "master_global_access_configs", master_global_access_configs)
        pulumi.set(__self__, "master_ipv4_cidr_block", master_ipv4_cidr_block)
        pulumi.set(__self__, "peering_name", peering_name)
        pulumi.set(__self__, "private_endpoint", private_endpoint)
        pulumi.set(__self__, "public_endpoint", public_endpoint)

    @property
    @pulumi.getter(name="enablePrivateEndpoint")
    def enable_private_endpoint(self) -> bool:
        return pulumi.get(self, "enable_private_endpoint")

    @property
    @pulumi.getter(name="enablePrivateNodes")
    def enable_private_nodes(self) -> bool:
        return pulumi.get(self, "enable_private_nodes")

    @property
    @pulumi.getter(name="masterGlobalAccessConfigs")
    def master_global_access_configs(self) -> Sequence['outputs.GetClusterPrivateClusterConfigMasterGlobalAccessConfigResult']:
        return pulumi.get(self, "master_global_access_configs")

    @property
    @pulumi.getter(name="masterIpv4CidrBlock")
    def master_ipv4_cidr_block(self) -> str:
        return pulumi.get(self, "master_ipv4_cidr_block")

    @property
    @pulumi.getter(name="peeringName")
    def peering_name(self) -> str:
        return pulumi.get(self, "peering_name")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> str:
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="publicEndpoint")
    def public_endpoint(self) -> str:
        return pulumi.get(self, "public_endpoint")


@pulumi.output_type
class GetClusterPrivateClusterConfigMasterGlobalAccessConfigResult(dict):
    def __init__(__self__, *,
                 enabled: bool):
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetClusterReleaseChannelResult(dict):
    def __init__(__self__, *,
                 channel: str):
        pulumi.set(__self__, "channel", channel)

    @property
    @pulumi.getter
    def channel(self) -> str:
        return pulumi.get(self, "channel")


@pulumi.output_type
class GetClusterResourceUsageExportConfigResult(dict):
    def __init__(__self__, *,
                 bigquery_destinations: Sequence['outputs.GetClusterResourceUsageExportConfigBigqueryDestinationResult'],
                 enable_network_egress_metering: bool,
                 enable_resource_consumption_metering: bool):
        pulumi.set(__self__, "bigquery_destinations", bigquery_destinations)
        pulumi.set(__self__, "enable_network_egress_metering", enable_network_egress_metering)
        pulumi.set(__self__, "enable_resource_consumption_metering", enable_resource_consumption_metering)

    @property
    @pulumi.getter(name="bigqueryDestinations")
    def bigquery_destinations(self) -> Sequence['outputs.GetClusterResourceUsageExportConfigBigqueryDestinationResult']:
        return pulumi.get(self, "bigquery_destinations")

    @property
    @pulumi.getter(name="enableNetworkEgressMetering")
    def enable_network_egress_metering(self) -> bool:
        return pulumi.get(self, "enable_network_egress_metering")

    @property
    @pulumi.getter(name="enableResourceConsumptionMetering")
    def enable_resource_consumption_metering(self) -> bool:
        return pulumi.get(self, "enable_resource_consumption_metering")


@pulumi.output_type
class GetClusterResourceUsageExportConfigBigqueryDestinationResult(dict):
    def __init__(__self__, *,
                 dataset_id: str):
        pulumi.set(__self__, "dataset_id", dataset_id)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        return pulumi.get(self, "dataset_id")


@pulumi.output_type
class GetClusterVerticalPodAutoscalingResult(dict):
    def __init__(__self__, *,
                 enabled: bool):
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetClusterWorkloadIdentityConfigResult(dict):
    def __init__(__self__, *,
                 identity_namespace: str):
        pulumi.set(__self__, "identity_namespace", identity_namespace)

    @property
    @pulumi.getter(name="identityNamespace")
    def identity_namespace(self) -> str:
        return pulumi.get(self, "identity_namespace")


