# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Note']


class Note(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attestation_authority: Optional[pulumi.Input[pulumi.InputType['NoteAttestationAuthorityArgs']]] = None,
                 expiration_time: Optional[pulumi.Input[str]] = None,
                 long_description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 related_note_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 related_urls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NoteRelatedUrlArgs']]]]] = None,
                 short_description: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        A Container Analysis note is a high-level piece of metadata that
        describes a type of analysis that can be done for a resource.

        To get more information about Note, see:

        * [API documentation](https://cloud.google.com/container-analysis/api/reference/rest/)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/container-analysis/)
            * [Creating Attestations (Occurrences)](https://cloud.google.com/binary-authorization/docs/making-attestations)

        ## Example Usage
        ### Container Analysis Note Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        note = gcp.containeranalysis.Note("note", attestation_authority=gcp.containeranalysis.NoteAttestationAuthorityArgs(
            hint=gcp.containeranalysis.NoteAttestationAuthorityHintArgs(
                human_readable_name="Attestor Note",
            ),
        ))
        ```
        ### Container Analysis Note Attestation Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        note = gcp.containeranalysis.Note("note",
            attestation_authority=gcp.containeranalysis.NoteAttestationAuthorityArgs(
                hint=gcp.containeranalysis.NoteAttestationAuthorityHintArgs(
                    human_readable_name="Attestor Note",
                ),
            ),
            expiration_time="2120-10-02T15:01:23.045123456Z",
            long_description="a longer description of test note",
            related_urls=[
                gcp.containeranalysis.NoteRelatedUrlArgs(
                    label="foo",
                    url="some.url",
                ),
                gcp.containeranalysis.NoteRelatedUrlArgs(
                    url="google.com",
                ),
            ],
            short_description="test note")
        ```

        ## Import

        Note can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:containeranalysis/note:Note default projects/{{project}}/notes/{{name}}
        ```

        ```sh
         $ pulumi import gcp:containeranalysis/note:Note default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:containeranalysis/note:Note default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['NoteAttestationAuthorityArgs']] attestation_authority: Note kind that represents a logical attestation "role" or "authority".
               For example, an organization might have one AttestationAuthority for
               "QA" and one for "build". This Note is intended to act strictly as a
               grouping mechanism for the attached Occurrences (Attestations). This
               grouping mechanism also provides a security boundary, since IAM ACLs
               gate the ability for a principle to attach an Occurrence to a given
               Note. It also provides a single point of lookup to find all attached
               Attestation Occurrences, even if they don't all live in the same
               project.
               Structure is documented below.
        :param pulumi.Input[str] expiration_time: Time of expiration for this note. Leave empty if note does not expire.
        :param pulumi.Input[str] long_description: A detailed description of the note
        :param pulumi.Input[str] name: The name of the note.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] related_note_names: Names of other notes related to this note.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NoteRelatedUrlArgs']]]] related_urls: URLs associated with this note and related metadata.
               Structure is documented below.
        :param pulumi.Input[str] short_description: A one sentence description of the note.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if attestation_authority is None and not opts.urn:
                raise TypeError("Missing required property 'attestation_authority'")
            __props__['attestation_authority'] = attestation_authority
            __props__['expiration_time'] = expiration_time
            __props__['long_description'] = long_description
            __props__['name'] = name
            __props__['project'] = project
            __props__['related_note_names'] = related_note_names
            __props__['related_urls'] = related_urls
            __props__['short_description'] = short_description
            __props__['create_time'] = None
            __props__['kind'] = None
            __props__['update_time'] = None
        super(Note, __self__).__init__(
            'gcp:containeranalysis/note:Note',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attestation_authority: Optional[pulumi.Input[pulumi.InputType['NoteAttestationAuthorityArgs']]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            expiration_time: Optional[pulumi.Input[str]] = None,
            kind: Optional[pulumi.Input[str]] = None,
            long_description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            related_note_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            related_urls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NoteRelatedUrlArgs']]]]] = None,
            short_description: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'Note':
        """
        Get an existing Note resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['NoteAttestationAuthorityArgs']] attestation_authority: Note kind that represents a logical attestation "role" or "authority".
               For example, an organization might have one AttestationAuthority for
               "QA" and one for "build". This Note is intended to act strictly as a
               grouping mechanism for the attached Occurrences (Attestations). This
               grouping mechanism also provides a security boundary, since IAM ACLs
               gate the ability for a principle to attach an Occurrence to a given
               Note. It also provides a single point of lookup to find all attached
               Attestation Occurrences, even if they don't all live in the same
               project.
               Structure is documented below.
        :param pulumi.Input[str] create_time: The time this note was created.
        :param pulumi.Input[str] expiration_time: Time of expiration for this note. Leave empty if note does not expire.
        :param pulumi.Input[str] kind: The type of analysis this note describes
        :param pulumi.Input[str] long_description: A detailed description of the note
        :param pulumi.Input[str] name: The name of the note.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] related_note_names: Names of other notes related to this note.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NoteRelatedUrlArgs']]]] related_urls: URLs associated with this note and related metadata.
               Structure is documented below.
        :param pulumi.Input[str] short_description: A one sentence description of the note.
        :param pulumi.Input[str] update_time: The time this note was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["attestation_authority"] = attestation_authority
        __props__["create_time"] = create_time
        __props__["expiration_time"] = expiration_time
        __props__["kind"] = kind
        __props__["long_description"] = long_description
        __props__["name"] = name
        __props__["project"] = project
        __props__["related_note_names"] = related_note_names
        __props__["related_urls"] = related_urls
        __props__["short_description"] = short_description
        __props__["update_time"] = update_time
        return Note(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="attestationAuthority")
    def attestation_authority(self) -> pulumi.Output['outputs.NoteAttestationAuthority']:
        """
        Note kind that represents a logical attestation "role" or "authority".
        For example, an organization might have one AttestationAuthority for
        "QA" and one for "build". This Note is intended to act strictly as a
        grouping mechanism for the attached Occurrences (Attestations). This
        grouping mechanism also provides a security boundary, since IAM ACLs
        gate the ability for a principle to attach an Occurrence to a given
        Note. It also provides a single point of lookup to find all attached
        Attestation Occurrences, even if they don't all live in the same
        project.
        Structure is documented below.
        """
        return pulumi.get(self, "attestation_authority")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time this note was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> pulumi.Output[Optional[str]]:
        """
        Time of expiration for this note. Leave empty if note does not expire.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[str]:
        """
        The type of analysis this note describes
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="longDescription")
    def long_description(self) -> pulumi.Output[Optional[str]]:
        """
        A detailed description of the note
        """
        return pulumi.get(self, "long_description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the note.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="relatedNoteNames")
    def related_note_names(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Names of other notes related to this note.
        """
        return pulumi.get(self, "related_note_names")

    @property
    @pulumi.getter(name="relatedUrls")
    def related_urls(self) -> pulumi.Output[Optional[Sequence['outputs.NoteRelatedUrl']]]:
        """
        URLs associated with this note and related metadata.
        Structure is documented below.
        """
        return pulumi.get(self, "related_urls")

    @property
    @pulumi.getter(name="shortDescription")
    def short_description(self) -> pulumi.Output[Optional[str]]:
        """
        A one sentence description of the note.
        """
        return pulumi.get(self, "short_description")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The time this note was last updated.
        """
        return pulumi.get(self, "update_time")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

