# Spacy pipeline

If `gatenlp` has been installed with the spacy extra (`pip install gatenlp[spacy]` or `pip install gatenlp[all]`) you can run a Spacy pipeline on a document and get the result as `gatenlp` annotations. 




```python
from gatenlp import Document
from gatenlp.lib_spacy import AnnSpacy
import spacy


```


```python
# In order to use the English pipeline with Spacy, the model has to get downloaded first
from spacy.cli import download as spacy_download
spacy_download("en_core_web_sm")

```

    [38;5;2m✔ Download and installation successful[0m
    You can now load the model via spacy.load('en_core_web_sm')



```python
doc = Document.load("https://gatenlp.github.io/python-gatenlp/testdocument2.txt")
doc
```




<div><style>#UMEGYGHDQL-wrapper { color: black !important; }</style>
<div id="UMEGYGHDQL-wrapper">

<div>
<style>
#UMEGYGHDQL-content {
    width: 100%;
    height: 100%;
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
}

.UMEGYGHDQL-row {
    width: 100%;
    display: flex;
    flex-direction: row;
    flex-wrap: nowrap;
}

.UMEGYGHDQL-col {
    border: 1px solid grey;
    display: inline-block;
    min-width: 200px;
    padding: 5px;
    /* white-space: normal; */
    /* white-space: pre-wrap; */
    overflow-y: auto;
}

.UMEGYGHDQL-hdr {
    font-size: 1.2rem;
    font-weight: bold;
}

.UMEGYGHDQL-label {
    margin-bottom: -15px;
    display: block;
}

.UMEGYGHDQL-input {
    vertical-align: middle;
    position: relative;
    *overflow: hidden;
}

#UMEGYGHDQL-popup {
    display: none;
    color: black;
    position: absolute;
    margin-top: 10%;
    margin-left: 10%;
    background: #aaaaaa;
    width: 60%;
    height: 60%;
    z-index: 50;
    padding: 25px 25px 25px;
    border: 1px solid black;
    overflow: auto;
}

.UMEGYGHDQL-selection {
    margin-bottom: 5px;
}

.UMEGYGHDQL-featuretable {
    margin-top: 10px;
}

.UMEGYGHDQL-fname {
    text-align: left !important;
    font-weight: bold;
    margin-right: 10px;
}
.UMEGYGHDQL-fvalue {
    text-align: left !important;
}
</style>
  <div id="UMEGYGHDQL-content">
        <div id="UMEGYGHDQL-popup" style="display: none;">
        </div>
        <div class="UMEGYGHDQL-row" id="UMEGYGHDQL-row1" style="height:67vh; min-height:100px;">
            <div id="UMEGYGHDQL-text-wrapper" class="UMEGYGHDQL-col" style="width:70%;">
                <div class="UMEGYGHDQL-hdr" id="UMEGYGHDQL-dochdr"></div>
                <div id="UMEGYGHDQL-text">
                </div>
            </div>
            <div id="UMEGYGHDQL-chooser" class="UMEGYGHDQL-col" style="width:30%; border-left-width: 0px;"></div>
        </div>
        <div class="UMEGYGHDQL-row" id="UMEGYGHDQL-row2" style="height:30vh; min-height: 100px;">
            <div id="UMEGYGHDQL-details" class="UMEGYGHDQL-col" style="width:100%; border-top-width: 0px;">
            </div>
        </div>
    </div>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script><script src="https://unpkg.com/gatenlp-ann-viewer@1.0.9/gatenlp-ann-viewer.js"></script>
    <script type="application/json" id="UMEGYGHDQL-data">
    {"annotation_sets": {}, "text": "This is just a sample document for experimenting with gatenlp. \nIt mentions a few named entities like the persons Barack Obama, \nAlbert Einstein and Wolfgang Amadeus Mozart and the geographical \nlocations and countries America, United States of America, \nHungary, the Atlantic Ocean, and Helskinki. \n\nIt also contains mentions of various numbers and amounts like \n12 degrees, 12.83$, 25 km/h or fortytwo kilos and mentions\norganizations and companies like the UNO, Microsoft, Apple, which\nhas an apple as it's logo, or Google. \n\n\n", "features": {}, "offset_type": "j", "name": ""}
    </script>
    <script type="text/javascript">
        gatenlp_run("UMEGYGHDQL-");
    </script>
  </div>

</div></div>



## Annotating the document using Spacy

In order to annotate one or more documents using Spacy, first create a AnnSpacy annotator object
and the run the document(s) through this annotator:


```python
spacy_pipeline = spacy.load("en_core_web_sm")
spacy_annotator = AnnSpacy(pipeline=spacy_pipeline)
```


```python
doc = spacy_annotator(doc)
doc
```




<div><style>#PZQXZBUIJE-wrapper { color: black !important; }</style>
<div id="PZQXZBUIJE-wrapper">

<div>
<style>
#PZQXZBUIJE-content {
    width: 100%;
    height: 100%;
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
}

.PZQXZBUIJE-row {
    width: 100%;
    display: flex;
    flex-direction: row;
    flex-wrap: nowrap;
}

.PZQXZBUIJE-col {
    border: 1px solid grey;
    display: inline-block;
    min-width: 200px;
    padding: 5px;
    /* white-space: normal; */
    /* white-space: pre-wrap; */
    overflow-y: auto;
}

.PZQXZBUIJE-hdr {
    font-size: 1.2rem;
    font-weight: bold;
}

.PZQXZBUIJE-label {
    margin-bottom: -15px;
    display: block;
}

.PZQXZBUIJE-input {
    vertical-align: middle;
    position: relative;
    *overflow: hidden;
}

#PZQXZBUIJE-popup {
    display: none;
    color: black;
    position: absolute;
    margin-top: 10%;
    margin-left: 10%;
    background: #aaaaaa;
    width: 60%;
    height: 60%;
    z-index: 50;
    padding: 25px 25px 25px;
    border: 1px solid black;
    overflow: auto;
}

.PZQXZBUIJE-selection {
    margin-bottom: 5px;
}

.PZQXZBUIJE-featuretable {
    margin-top: 10px;
}

.PZQXZBUIJE-fname {
    text-align: left !important;
    font-weight: bold;
    margin-right: 10px;
}
.PZQXZBUIJE-fvalue {
    text-align: left !important;
}
</style>
  <div id="PZQXZBUIJE-content">
        <div id="PZQXZBUIJE-popup" style="display: none;">
        </div>
        <div class="PZQXZBUIJE-row" id="PZQXZBUIJE-row1" style="height:67vh; min-height:100px;">
            <div id="PZQXZBUIJE-text-wrapper" class="PZQXZBUIJE-col" style="width:70%;">
                <div class="PZQXZBUIJE-hdr" id="PZQXZBUIJE-dochdr"></div>
                <div id="PZQXZBUIJE-text">
                </div>
            </div>
            <div id="PZQXZBUIJE-chooser" class="PZQXZBUIJE-col" style="width:30%; border-left-width: 0px;"></div>
        </div>
        <div class="PZQXZBUIJE-row" id="PZQXZBUIJE-row2" style="height:30vh; min-height: 100px;">
            <div id="PZQXZBUIJE-details" class="PZQXZBUIJE-col" style="width:100%; border-top-width: 0px;">
            </div>
        </div>
    </div>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script><script src="https://unpkg.com/gatenlp-ann-viewer@1.0.9/gatenlp-ann-viewer.js"></script>
    <script type="application/json" id="PZQXZBUIJE-data">
    {"annotation_sets": {"": {"name": "detached-from:", "annotations": [{"type": "Token", "start": 0, "end": 4, "id": 0, "features": {"_i": 0, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": true, "is_space": false, "is_stop": true, "is_title": true, "is_upper": false, "lang": "en", "lemma": "this", "like_email": false, "like_num": false, "like_url": false, "orth": 12943039165150086467, "pos": "DET", "prefix": "T", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "DT", "shape": "Xxxx", "suffix": "his", "ent_type": "", "dep": "nsubj", "head": 2, "left_edge": 0, "right_edge": 0}}, {"type": "SpaceToken", "start": 4, "end": 5, "id": 1, "features": {"is_space": true}}, {"type": "Token", "start": 5, "end": 7, "id": 2, "features": {"_i": 1, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "be", "like_email": false, "like_num": false, "like_url": false, "orth": 3411606890003347522, "pos": "AUX", "prefix": "i", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "VBZ", "shape": "xx", "suffix": "is", "ent_type": "", "dep": "ROOT", "head": 2, "left_edge": 0, "right_edge": 21}}, {"type": "SpaceToken", "start": 7, "end": 8, "id": 3, "features": {"is_space": true}}, {"type": "Token", "start": 8, "end": 12, "id": 4, "features": {"_i": 2, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "just", "like_email": false, "like_num": false, "like_url": false, "orth": 7148522813498185515, "pos": "ADV", "prefix": "j", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "RB", "shape": "xxxx", "suffix": "ust", "ent_type": "", "dep": "advmod", "head": 10, "left_edge": 4, "right_edge": 4}}, {"type": "SpaceToken", "start": 12, "end": 13, "id": 5, "features": {"is_space": true}}, {"type": "Token", "start": 13, "end": 14, "id": 6, "features": {"_i": 3, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "a", "like_email": false, "like_num": false, "like_url": false, "orth": 11901859001352538922, "pos": "DET", "prefix": "a", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "DT", "shape": "x", "suffix": "a", "ent_type": "", "dep": "det", "head": 10, "left_edge": 6, "right_edge": 6}}, {"type": "SpaceToken", "start": 14, "end": 15, "id": 7, "features": {"is_space": true}}, {"type": "Token", "start": 15, "end": 21, "id": 8, "features": {"_i": 4, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "sample", "like_email": false, "like_num": false, "like_url": false, "orth": 10528961229637103608, "pos": "NOUN", "prefix": "s", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NN", "shape": "xxxx", "suffix": "ple", "ent_type": "", "dep": "compound", "head": 10, "left_edge": 8, "right_edge": 8}}, {"type": "SpaceToken", "start": 21, "end": 22, "id": 9, "features": {"is_space": true}}, {"type": "Token", "start": 22, "end": 30, "id": 10, "features": {"_i": 5, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "document", "like_email": false, "like_num": false, "like_url": false, "orth": 2376024544662810659, "pos": "NOUN", "prefix": "d", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NN", "shape": "xxxx", "suffix": "ent", "ent_type": "", "dep": "attr", "head": 2, "left_edge": 4, "right_edge": 18}}, {"type": "SpaceToken", "start": 30, "end": 31, "id": 11, "features": {"is_space": true}}, {"type": "Token", "start": 31, "end": 34, "id": 12, "features": {"_i": 6, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "for", "like_email": false, "like_num": false, "like_url": false, "orth": 16037325823156266367, "pos": "ADP", "prefix": "f", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "IN", "shape": "xxx", "suffix": "for", "ent_type": "", "dep": "prep", "head": 10, "left_edge": 12, "right_edge": 18}}, {"type": "SpaceToken", "start": 34, "end": 35, "id": 13, "features": {"is_space": true}}, {"type": "Token", "start": 35, "end": 48, "id": 14, "features": {"_i": 7, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "experiment", "like_email": false, "like_num": false, "like_url": false, "orth": 9768530470678116220, "pos": "VERB", "prefix": "e", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "VBG", "shape": "xxxx", "suffix": "ing", "ent_type": "", "dep": "pcomp", "head": 12, "left_edge": 14, "right_edge": 18}}, {"type": "SpaceToken", "start": 48, "end": 49, "id": 15, "features": {"is_space": true}}, {"type": "Token", "start": 49, "end": 53, "id": 16, "features": {"_i": 8, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "with", "like_email": false, "like_num": false, "like_url": false, "orth": 12510949447758279278, "pos": "ADP", "prefix": "w", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "IN", "shape": "xxxx", "suffix": "ith", "ent_type": "", "dep": "prep", "head": 14, "left_edge": 16, "right_edge": 18}}, {"type": "SpaceToken", "start": 53, "end": 54, "id": 17, "features": {"is_space": true}}, {"type": "Token", "start": 54, "end": 61, "id": 18, "features": {"_i": 9, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "gatenlp", "like_email": false, "like_num": false, "like_url": false, "orth": 12347949006703186647, "pos": "NOUN", "prefix": "g", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NN", "shape": "xxxx", "suffix": "nlp", "ent_type": "", "dep": "pobj", "head": 16, "left_edge": 18, "right_edge": 18}}, {"type": "Token", "start": 61, "end": 62, "id": 19, "features": {"_i": 10, "is_alpha": false, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": true, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": ".", "like_email": false, "like_num": false, "like_url": false, "orth": 12646065887601541794, "pos": "PUNCT", "prefix": ".", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": ".", "shape": ".", "suffix": ".", "ent_type": "", "dep": "punct", "head": 2, "left_edge": 19, "right_edge": 21}}, {"type": "SpaceToken", "start": 62, "end": 63, "id": 20, "features": {"is_space": true}}, {"type": "SpaceToken", "start": 63, "end": 64, "id": 21, "features": {"_i": 11, "is_alpha": false, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": true, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "\n", "like_email": false, "like_num": false, "like_url": false, "orth": 962983613142996970, "pos": "SPACE", "prefix": "\n", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "_SP", "shape": "\n", "suffix": "\n", "ent_type": "", "dep": "", "head": 19, "left_edge": 21, "right_edge": 21}}, {"type": "Token", "start": 64, "end": 66, "id": 22, "features": {"_i": 12, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": true, "is_space": false, "is_stop": true, "is_title": true, "is_upper": false, "lang": "en", "lemma": "-PRON-", "like_email": false, "like_num": false, "like_url": false, "orth": 7859011591137717335, "pos": "PRON", "prefix": "I", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "PRP", "shape": "Xx", "suffix": "It", "ent_type": "", "dep": "nsubj", "head": 24, "left_edge": 22, "right_edge": 22}}, {"type": "SpaceToken", "start": 66, "end": 67, "id": 23, "features": {"is_space": true}}, {"type": "Token", "start": 67, "end": 75, "id": 24, "features": {"_i": 13, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "mention", "like_email": false, "like_num": false, "like_url": false, "orth": 834570530775529781, "pos": "VERB", "prefix": "m", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "VBZ", "shape": "xxxx", "suffix": "ons", "ent_type": "", "dep": "ROOT", "head": 24, "left_edge": 22, "right_edge": 99}}, {"type": "SpaceToken", "start": 75, "end": 76, "id": 25, "features": {"is_space": true}}, {"type": "Token", "start": 76, "end": 77, "id": 26, "features": {"_i": 14, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "a", "like_email": false, "like_num": false, "like_url": false, "orth": 11901859001352538922, "pos": "DET", "prefix": "a", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "DT", "shape": "x", "suffix": "a", "ent_type": "", "dep": "quantmod", "head": 28, "left_edge": 26, "right_edge": 26}}, {"type": "SpaceToken", "start": 77, "end": 78, "id": 27, "features": {"is_space": true}}, {"type": "Token", "start": 78, "end": 81, "id": 28, "features": {"_i": 15, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "few", "like_email": false, "like_num": false, "like_url": false, "orth": 11866476999679706272, "pos": "ADJ", "prefix": "f", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "JJ", "shape": "xxx", "suffix": "few", "ent_type": "", "dep": "nummod", "head": 32, "left_edge": 26, "right_edge": 28}}, {"type": "SpaceToken", "start": 81, "end": 82, "id": 29, "features": {"is_space": true}}, {"type": "Token", "start": 82, "end": 87, "id": 30, "features": {"_i": 16, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "name", "like_email": false, "like_num": false, "like_url": false, "orth": 6719370519630147158, "pos": "VERB", "prefix": "n", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "VBN", "shape": "xxxx", "suffix": "med", "ent_type": "", "dep": "amod", "head": 32, "left_edge": 30, "right_edge": 30}}, {"type": "SpaceToken", "start": 87, "end": 88, "id": 31, "features": {"is_space": true}}, {"type": "Token", "start": 88, "end": 96, "id": 32, "features": {"_i": 17, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "entity", "like_email": false, "like_num": false, "like_url": false, "orth": 7701268449352692754, "pos": "NOUN", "prefix": "e", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNS", "shape": "xxxx", "suffix": "ies", "ent_type": "", "dep": "dobj", "head": 24, "left_edge": 26, "right_edge": 96}}, {"type": "SpaceToken", "start": 96, "end": 97, "id": 33, "features": {"is_space": true}}, {"type": "Token", "start": 97, "end": 101, "id": 34, "features": {"_i": 18, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "like", "like_email": false, "like_num": false, "like_url": false, "orth": 18194338103975822726, "pos": "SCONJ", "prefix": "l", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "IN", "shape": "xxxx", "suffix": "ike", "ent_type": "", "dep": "prep", "head": 32, "left_edge": 34, "right_edge": 80}}, {"type": "SpaceToken", "start": 101, "end": 102, "id": 35, "features": {"is_space": true}}, {"type": "Token", "start": 102, "end": 105, "id": 36, "features": {"_i": 19, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "the", "like_email": false, "like_num": false, "like_url": false, "orth": 7425985699627899538, "pos": "DET", "prefix": "t", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "DT", "shape": "xxx", "suffix": "the", "ent_type": "", "dep": "det", "head": 38, "left_edge": 36, "right_edge": 36}}, {"type": "SpaceToken", "start": 105, "end": 106, "id": 37, "features": {"is_space": true}}, {"type": "Token", "start": 106, "end": 113, "id": 38, "features": {"_i": 20, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "person", "like_email": false, "like_num": false, "like_url": false, "orth": 17520808660558581486, "pos": "NOUN", "prefix": "p", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNS", "shape": "xxxx", "suffix": "ons", "ent_type": "", "dep": "pobj", "head": 34, "left_edge": 36, "right_edge": 80}}, {"type": "SpaceToken", "start": 113, "end": 114, "id": 39, "features": {"is_space": true}}, {"type": "Token", "start": 114, "end": 120, "id": 40, "features": {"_i": 21, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": true, "is_upper": false, "lang": "en", "lemma": "Barack", "like_email": false, "like_num": false, "like_url": false, "orth": 15388493565120789335, "pos": "PROPN", "prefix": "B", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNP", "shape": "Xxxxx", "suffix": "ack", "ent_type": "PERSON", "dep": "compound", "head": 42, "left_edge": 40, "right_edge": 40}}, {"type": "SpaceToken", "start": 120, "end": 121, "id": 41, "features": {"is_space": true}}, {"type": "Token", "start": 121, "end": 126, "id": 42, "features": {"_i": 22, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": true, "is_upper": false, "lang": "en", "lemma": "Obama", "like_email": false, "like_num": false, "like_url": false, "orth": 4857242187112322394, "pos": "PROPN", "prefix": "O", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNP", "shape": "Xxxxx", "suffix": "ama", "ent_type": "PERSON", "dep": "appos", "head": 38, "left_edge": 40, "right_edge": 80}}, {"type": "Token", "start": 126, "end": 127, "id": 43, "features": {"_i": 23, "is_alpha": false, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": true, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": ",", "like_email": false, "like_num": false, "like_url": false, "orth": 2593208677638477497, "pos": "PUNCT", "prefix": ",", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": ",", "shape": ",", "suffix": ",", "ent_type": "", "dep": "punct", "head": 42, "left_edge": 43, "right_edge": 45}}, {"type": "SpaceToken", "start": 127, "end": 128, "id": 44, "features": {"is_space": true}}, {"type": "SpaceToken", "start": 128, "end": 129, "id": 45, "features": {"_i": 24, "is_alpha": false, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": true, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "\n", "like_email": false, "like_num": false, "like_url": false, "orth": 962983613142996970, "pos": "SPACE", "prefix": "\n", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "_SP", "shape": "\n", "suffix": "\n", "ent_type": "", "dep": "", "head": 43, "left_edge": 45, "right_edge": 45}}, {"type": "Token", "start": 129, "end": 135, "id": 46, "features": {"_i": 25, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": true, "is_upper": false, "lang": "en", "lemma": "Albert", "like_email": false, "like_num": false, "like_url": false, "orth": 4069928766380601912, "pos": "PROPN", "prefix": "A", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNP", "shape": "Xxxxx", "suffix": "ert", "ent_type": "PERSON", "dep": "compound", "head": 48, "left_edge": 46, "right_edge": 46}}, {"type": "SpaceToken", "start": 135, "end": 136, "id": 47, "features": {"is_space": true}}, {"type": "Token", "start": 136, "end": 144, "id": 48, "features": {"_i": 26, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": true, "is_upper": false, "lang": "en", "lemma": "Einstein", "like_email": false, "like_num": false, "like_url": false, "orth": 18171558317586024262, "pos": "PROPN", "prefix": "E", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNP", "shape": "Xxxxx", "suffix": "ein", "ent_type": "PERSON", "dep": "conj", "head": 42, "left_edge": 46, "right_edge": 80}}, {"type": "SpaceToken", "start": 144, "end": 145, "id": 49, "features": {"is_space": true}}, {"type": "Token", "start": 145, "end": 148, "id": 50, "features": {"_i": 27, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "and", "like_email": false, "like_num": false, "like_url": false, "orth": 2283656566040971221, "pos": "CCONJ", "prefix": "a", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "CC", "shape": "xxx", "suffix": "and", "ent_type": "", "dep": "cc", "head": 48, "left_edge": 50, "right_edge": 50}}, {"type": "SpaceToken", "start": 148, "end": 149, "id": 51, "features": {"is_space": true}}, {"type": "Token", "start": 149, "end": 157, "id": 52, "features": {"_i": 28, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": true, "is_upper": false, "lang": "en", "lemma": "Wolfgang", "like_email": false, "like_num": false, "like_url": false, "orth": 10098205593463260770, "pos": "PROPN", "prefix": "W", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNP", "shape": "Xxxxx", "suffix": "ang", "ent_type": "PERSON", "dep": "compound", "head": 54, "left_edge": 52, "right_edge": 52}}, {"type": "SpaceToken", "start": 157, "end": 158, "id": 53, "features": {"is_space": true}}, {"type": "Token", "start": 158, "end": 165, "id": 54, "features": {"_i": 29, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": true, "is_upper": false, "lang": "en", "lemma": "Amadeus", "like_email": false, "like_num": false, "like_url": false, "orth": 5124047285483746746, "pos": "PROPN", "prefix": "A", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNP", "shape": "Xxxxx", "suffix": "eus", "ent_type": "PERSON", "dep": "compound", "head": 56, "left_edge": 52, "right_edge": 54}}, {"type": "SpaceToken", "start": 165, "end": 166, "id": 55, "features": {"is_space": true}}, {"type": "Token", "start": 166, "end": 172, "id": 56, "features": {"_i": 30, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": true, "is_upper": false, "lang": "en", "lemma": "Mozart", "like_email": false, "like_num": false, "like_url": false, "orth": 2524172713799673737, "pos": "PROPN", "prefix": "M", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNP", "shape": "Xxxxx", "suffix": "art", "ent_type": "PERSON", "dep": "conj", "head": 48, "left_edge": 52, "right_edge": 71}}, {"type": "SpaceToken", "start": 172, "end": 173, "id": 57, "features": {"is_space": true}}, {"type": "Token", "start": 173, "end": 176, "id": 58, "features": {"_i": 31, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "and", "like_email": false, "like_num": false, "like_url": false, "orth": 2283656566040971221, "pos": "CCONJ", "prefix": "a", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "CC", "shape": "xxx", "suffix": "and", "ent_type": "", "dep": "cc", "head": 56, "left_edge": 58, "right_edge": 58}}, {"type": "SpaceToken", "start": 176, "end": 177, "id": 59, "features": {"is_space": true}}, {"type": "Token", "start": 177, "end": 180, "id": 60, "features": {"_i": 32, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "the", "like_email": false, "like_num": false, "like_url": false, "orth": 7425985699627899538, "pos": "DET", "prefix": "t", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "DT", "shape": "xxx", "suffix": "the", "ent_type": "", "dep": "det", "head": 65, "left_edge": 60, "right_edge": 60}}, {"type": "SpaceToken", "start": 180, "end": 181, "id": 61, "features": {"is_space": true}}, {"type": "Token", "start": 181, "end": 193, "id": 62, "features": {"_i": 33, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "geographical", "like_email": false, "like_num": false, "like_url": false, "orth": 9133095776070088972, "pos": "ADJ", "prefix": "g", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "JJ", "shape": "xxxx", "suffix": "cal", "ent_type": "", "dep": "amod", "head": 65, "left_edge": 62, "right_edge": 64}}, {"type": "SpaceToken", "start": 193, "end": 194, "id": 63, "features": {"is_space": true}}, {"type": "SpaceToken", "start": 194, "end": 195, "id": 64, "features": {"_i": 34, "is_alpha": false, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": true, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "\n", "like_email": false, "like_num": false, "like_url": false, "orth": 962983613142996970, "pos": "SPACE", "prefix": "\n", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "_SP", "shape": "\n", "suffix": "\n", "ent_type": "", "dep": "", "head": 62, "left_edge": 64, "right_edge": 64}}, {"type": "Token", "start": 195, "end": 204, "id": 65, "features": {"_i": 35, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "location", "like_email": false, "like_num": false, "like_url": false, "orth": 13063876858105367867, "pos": "NOUN", "prefix": "l", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNS", "shape": "xxxx", "suffix": "ons", "ent_type": "", "dep": "conj", "head": 56, "left_edge": 60, "right_edge": 71}}, {"type": "SpaceToken", "start": 204, "end": 205, "id": 66, "features": {"is_space": true}}, {"type": "Token", "start": 205, "end": 208, "id": 67, "features": {"_i": 36, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "and", "like_email": false, "like_num": false, "like_url": false, "orth": 2283656566040971221, "pos": "CCONJ", "prefix": "a", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "CC", "shape": "xxx", "suffix": "and", "ent_type": "", "dep": "cc", "head": 65, "left_edge": 67, "right_edge": 67}}, {"type": "SpaceToken", "start": 208, "end": 209, "id": 68, "features": {"is_space": true}}, {"type": "Token", "start": 209, "end": 218, "id": 69, "features": {"_i": 37, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "country", "like_email": false, "like_num": false, "like_url": false, "orth": 13957816561748780037, "pos": "NOUN", "prefix": "c", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNS", "shape": "xxxx", "suffix": "ies", "ent_type": "", "dep": "compound", "head": 71, "left_edge": 69, "right_edge": 69}}, {"type": "SpaceToken", "start": 218, "end": 219, "id": 70, "features": {"is_space": true}}, {"type": "Token", "start": 219, "end": 226, "id": 71, "features": {"_i": 38, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": true, "is_upper": false, "lang": "en", "lemma": "America", "like_email": false, "like_num": false, "like_url": false, "orth": 13134984502707718284, "pos": "PROPN", "prefix": "A", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNP", "shape": "Xxxxx", "suffix": "ica", "ent_type": "GPE", "dep": "conj", "head": 65, "left_edge": 69, "right_edge": 71}}, {"type": "Token", "start": 226, "end": 227, "id": 72, "features": {"_i": 39, "is_alpha": false, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": true, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": ",", "like_email": false, "like_num": false, "like_url": false, "orth": 2593208677638477497, "pos": "PUNCT", "prefix": ",", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": ",", "shape": ",", "suffix": ",", "ent_type": "", "dep": "punct", "head": 48, "left_edge": 72, "right_edge": 72}}, {"type": "SpaceToken", "start": 227, "end": 228, "id": 73, "features": {"is_space": true}}, {"type": "Token", "start": 228, "end": 234, "id": 74, "features": {"_i": 40, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": true, "is_upper": false, "lang": "en", "lemma": "United", "like_email": false, "like_num": false, "like_url": false, "orth": 13226800834791099135, "pos": "PROPN", "prefix": "U", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNP", "shape": "Xxxxx", "suffix": "ted", "ent_type": "GPE", "dep": "compound", "head": 76, "left_edge": 74, "right_edge": 74}}, {"type": "SpaceToken", "start": 234, "end": 235, "id": 75, "features": {"is_space": true}}, {"type": "Token", "start": 235, "end": 241, "id": 76, "features": {"_i": 41, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": true, "is_upper": false, "lang": "en", "lemma": "States", "like_email": false, "like_num": false, "like_url": false, "orth": 3278625293875499398, "pos": "PROPN", "prefix": "S", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNP", "shape": "Xxxxx", "suffix": "tes", "ent_type": "GPE", "dep": "conj", "head": 48, "left_edge": 74, "right_edge": 80}}, {"type": "SpaceToken", "start": 241, "end": 242, "id": 77, "features": {"is_space": true}}, {"type": "Token", "start": 242, "end": 244, "id": 78, "features": {"_i": 42, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "of", "like_email": false, "like_num": false, "like_url": false, "orth": 886050111519832510, "pos": "ADP", "prefix": "o", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "IN", "shape": "xx", "suffix": "of", "ent_type": "GPE", "dep": "prep", "head": 76, "left_edge": 78, "right_edge": 80}}, {"type": "SpaceToken", "start": 244, "end": 245, "id": 79, "features": {"is_space": true}}, {"type": "Token", "start": 245, "end": 252, "id": 80, "features": {"_i": 43, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": true, "is_upper": false, "lang": "en", "lemma": "America", "like_email": false, "like_num": false, "like_url": false, "orth": 13134984502707718284, "pos": "PROPN", "prefix": "A", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNP", "shape": "Xxxxx", "suffix": "ica", "ent_type": "GPE", "dep": "pobj", "head": 78, "left_edge": 80, "right_edge": 80}}, {"type": "Token", "start": 252, "end": 253, "id": 81, "features": {"_i": 44, "is_alpha": false, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": true, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": ",", "like_email": false, "like_num": false, "like_url": false, "orth": 2593208677638477497, "pos": "PUNCT", "prefix": ",", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": ",", "shape": ",", "suffix": ",", "ent_type": "", "dep": "punct", "head": 32, "left_edge": 81, "right_edge": 83}}, {"type": "SpaceToken", "start": 253, "end": 254, "id": 82, "features": {"is_space": true}}, {"type": "SpaceToken", "start": 254, "end": 255, "id": 83, "features": {"_i": 45, "is_alpha": false, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": true, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "\n", "like_email": false, "like_num": false, "like_url": false, "orth": 962983613142996970, "pos": "SPACE", "prefix": "\n", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "_SP", "shape": "\n", "suffix": "\n", "ent_type": "", "dep": "", "head": 81, "left_edge": 83, "right_edge": 83}}, {"type": "Token", "start": 255, "end": 262, "id": 84, "features": {"_i": 46, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": true, "is_upper": false, "lang": "en", "lemma": "Hungary", "like_email": false, "like_num": false, "like_url": false, "orth": 4329063320156559772, "pos": "PROPN", "prefix": "H", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNP", "shape": "Xxxxx", "suffix": "ary", "ent_type": "GPE", "dep": "appos", "head": 32, "left_edge": 84, "right_edge": 96}}, {"type": "Token", "start": 262, "end": 263, "id": 85, "features": {"_i": 47, "is_alpha": false, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": true, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": ",", "like_email": false, "like_num": false, "like_url": false, "orth": 2593208677638477497, "pos": "PUNCT", "prefix": ",", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": ",", "shape": ",", "suffix": ",", "ent_type": "", "dep": "punct", "head": 84, "left_edge": 85, "right_edge": 85}}, {"type": "SpaceToken", "start": 263, "end": 264, "id": 86, "features": {"is_space": true}}, {"type": "Token", "start": 264, "end": 267, "id": 87, "features": {"_i": 48, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "the", "like_email": false, "like_num": false, "like_url": false, "orth": 7425985699627899538, "pos": "DET", "prefix": "t", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "DT", "shape": "xxx", "suffix": "the", "ent_type": "LOC", "dep": "det", "head": 91, "left_edge": 87, "right_edge": 87}}, {"type": "SpaceToken", "start": 267, "end": 268, "id": 88, "features": {"is_space": true}}, {"type": "Token", "start": 268, "end": 276, "id": 89, "features": {"_i": 49, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": true, "is_upper": false, "lang": "en", "lemma": "Atlantic", "like_email": false, "like_num": false, "like_url": false, "orth": 11990389520378046275, "pos": "PROPN", "prefix": "A", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNP", "shape": "Xxxxx", "suffix": "tic", "ent_type": "LOC", "dep": "compound", "head": 91, "left_edge": 89, "right_edge": 89}}, {"type": "SpaceToken", "start": 276, "end": 277, "id": 90, "features": {"is_space": true}}, {"type": "Token", "start": 277, "end": 282, "id": 91, "features": {"_i": 50, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": true, "is_upper": false, "lang": "en", "lemma": "Ocean", "like_email": false, "like_num": false, "like_url": false, "orth": 3745291585819928485, "pos": "PROPN", "prefix": "O", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNP", "shape": "Xxxxx", "suffix": "ean", "ent_type": "LOC", "dep": "conj", "head": 84, "left_edge": 87, "right_edge": 96}}, {"type": "Token", "start": 282, "end": 283, "id": 92, "features": {"_i": 51, "is_alpha": false, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": true, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": ",", "like_email": false, "like_num": false, "like_url": false, "orth": 2593208677638477497, "pos": "PUNCT", "prefix": ",", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": ",", "shape": ",", "suffix": ",", "ent_type": "", "dep": "punct", "head": 91, "left_edge": 92, "right_edge": 92}}, {"type": "SpaceToken", "start": 283, "end": 284, "id": 93, "features": {"is_space": true}}, {"type": "Token", "start": 284, "end": 287, "id": 94, "features": {"_i": 52, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "and", "like_email": false, "like_num": false, "like_url": false, "orth": 2283656566040971221, "pos": "CCONJ", "prefix": "a", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "CC", "shape": "xxx", "suffix": "and", "ent_type": "", "dep": "cc", "head": 91, "left_edge": 94, "right_edge": 94}}, {"type": "SpaceToken", "start": 287, "end": 288, "id": 95, "features": {"is_space": true}}, {"type": "Token", "start": 288, "end": 297, "id": 96, "features": {"_i": 53, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": true, "is_upper": false, "lang": "en", "lemma": "Helskinki", "like_email": false, "like_num": false, "like_url": false, "orth": 9776635674892551098, "pos": "PROPN", "prefix": "H", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNPS", "shape": "Xxxxx", "suffix": "nki", "ent_type": "PERSON", "dep": "conj", "head": 91, "left_edge": 96, "right_edge": 96}}, {"type": "Token", "start": 297, "end": 298, "id": 97, "features": {"_i": 54, "is_alpha": false, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": true, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": ".", "like_email": false, "like_num": false, "like_url": false, "orth": 12646065887601541794, "pos": "PUNCT", "prefix": ".", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": ".", "shape": ".", "suffix": ".", "ent_type": "", "dep": "punct", "head": 24, "left_edge": 97, "right_edge": 99}}, {"type": "SpaceToken", "start": 298, "end": 299, "id": 98, "features": {"is_space": true}}, {"type": "SpaceToken", "start": 299, "end": 301, "id": 99, "features": {"_i": 55, "is_alpha": false, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": true, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "\n\n", "like_email": false, "like_num": false, "like_url": false, "orth": 908432558851201422, "pos": "SPACE", "prefix": "\n", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "_SP", "shape": "\n\n", "suffix": "\n\n", "ent_type": "", "dep": "", "head": 97, "left_edge": 99, "right_edge": 99}}, {"type": "Token", "start": 301, "end": 303, "id": 100, "features": {"_i": 56, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": true, "is_space": false, "is_stop": true, "is_title": true, "is_upper": false, "lang": "en", "lemma": "-PRON-", "like_email": false, "like_num": false, "like_url": false, "orth": 7859011591137717335, "pos": "PRON", "prefix": "I", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "PRP", "shape": "Xx", "suffix": "It", "ent_type": "", "dep": "nsubj", "head": 104, "left_edge": 100, "right_edge": 100}}, {"type": "SpaceToken", "start": 303, "end": 304, "id": 101, "features": {"is_space": true}}, {"type": "Token", "start": 304, "end": 308, "id": 102, "features": {"_i": 57, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "also", "like_email": false, "like_num": false, "like_url": false, "orth": 12084876542534825196, "pos": "ADV", "prefix": "a", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "RB", "shape": "xxxx", "suffix": "lso", "ent_type": "", "dep": "advmod", "head": 104, "left_edge": 102, "right_edge": 102}}, {"type": "SpaceToken", "start": 308, "end": 309, "id": 103, "features": {"is_space": true}}, {"type": "Token", "start": 309, "end": 317, "id": 104, "features": {"_i": 58, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "contain", "like_email": false, "like_num": false, "like_url": false, "orth": 4189568596636683296, "pos": "VERB", "prefix": "c", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "VBZ", "shape": "xxxx", "suffix": "ins", "ent_type": "", "dep": "ROOT", "head": 104, "left_edge": 100, "right_edge": 186}}, {"type": "SpaceToken", "start": 317, "end": 318, "id": 105, "features": {"is_space": true}}, {"type": "Token", "start": 318, "end": 326, "id": 106, "features": {"_i": 59, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "mention", "like_email": false, "like_num": false, "like_url": false, "orth": 834570530775529781, "pos": "NOUN", "prefix": "m", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNS", "shape": "xxxx", "suffix": "ons", "ent_type": "", "dep": "dobj", "head": 104, "left_edge": 106, "right_edge": 112}}, {"type": "SpaceToken", "start": 326, "end": 327, "id": 107, "features": {"is_space": true}}, {"type": "Token", "start": 327, "end": 329, "id": 108, "features": {"_i": 60, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "of", "like_email": false, "like_num": false, "like_url": false, "orth": 886050111519832510, "pos": "ADP", "prefix": "o", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "IN", "shape": "xx", "suffix": "of", "ent_type": "", "dep": "prep", "head": 106, "left_edge": 108, "right_edge": 112}}, {"type": "SpaceToken", "start": 329, "end": 330, "id": 109, "features": {"is_space": true}}, {"type": "Token", "start": 330, "end": 337, "id": 110, "features": {"_i": 61, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "various", "like_email": false, "like_num": false, "like_url": false, "orth": 15505458595570984623, "pos": "ADJ", "prefix": "v", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "JJ", "shape": "xxxx", "suffix": "ous", "ent_type": "", "dep": "amod", "head": 112, "left_edge": 110, "right_edge": 110}}, {"type": "SpaceToken", "start": 337, "end": 338, "id": 111, "features": {"is_space": true}}, {"type": "Token", "start": 338, "end": 345, "id": 112, "features": {"_i": 62, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "number", "like_email": false, "like_num": false, "like_url": false, "orth": 16181666555170135050, "pos": "NOUN", "prefix": "n", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNS", "shape": "xxxx", "suffix": "ers", "ent_type": "", "dep": "pobj", "head": 108, "left_edge": 110, "right_edge": 112}}, {"type": "SpaceToken", "start": 345, "end": 346, "id": 113, "features": {"is_space": true}}, {"type": "Token", "start": 346, "end": 349, "id": 114, "features": {"_i": 63, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "and", "like_email": false, "like_num": false, "like_url": false, "orth": 2283656566040971221, "pos": "CCONJ", "prefix": "a", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "CC", "shape": "xxx", "suffix": "and", "ent_type": "", "dep": "cc", "head": 104, "left_edge": 114, "right_edge": 114}}, {"type": "SpaceToken", "start": 349, "end": 350, "id": 115, "features": {"is_space": true}}, {"type": "Token", "start": 350, "end": 357, "id": 116, "features": {"_i": 64, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "amount", "like_email": false, "like_num": false, "like_url": false, "orth": 14587414804570654629, "pos": "NOUN", "prefix": "a", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNS", "shape": "xxxx", "suffix": "nts", "ent_type": "", "dep": "conj", "head": 104, "left_edge": 116, "right_edge": 183}}, {"type": "SpaceToken", "start": 357, "end": 358, "id": 117, "features": {"is_space": true}}, {"type": "Token", "start": 358, "end": 362, "id": 118, "features": {"_i": 65, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "like", "like_email": false, "like_num": false, "like_url": false, "orth": 18194338103975822726, "pos": "SCONJ", "prefix": "l", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "IN", "shape": "xxxx", "suffix": "ike", "ent_type": "", "dep": "prep", "head": 116, "left_edge": 118, "right_edge": 183}}, {"type": "SpaceToken", "start": 362, "end": 363, "id": 119, "features": {"is_space": true}}, {"type": "SpaceToken", "start": 363, "end": 364, "id": 120, "features": {"_i": 66, "is_alpha": false, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": true, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "\n", "like_email": false, "like_num": false, "like_url": false, "orth": 962983613142996970, "pos": "SPACE", "prefix": "\n", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "_SP", "shape": "\n", "suffix": "\n", "ent_type": "", "dep": "", "head": 118, "left_edge": 120, "right_edge": 120}}, {"type": "Token", "start": 364, "end": 366, "id": 121, "features": {"_i": 67, "is_alpha": false, "is_bracket": false, "is_currency": false, "is_digit": true, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "12", "like_email": false, "like_num": true, "like_url": false, "orth": 1124146173557384544, "pos": "NUM", "prefix": "1", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "CD", "shape": "dd", "suffix": "12", "ent_type": "QUANTITY", "dep": "nummod", "head": 123, "left_edge": 121, "right_edge": 121}}, {"type": "SpaceToken", "start": 366, "end": 367, "id": 122, "features": {"is_space": true}}, {"type": "Token", "start": 367, "end": 374, "id": 123, "features": {"_i": 68, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "degree", "like_email": false, "like_num": false, "like_url": false, "orth": 232786014127703095, "pos": "NOUN", "prefix": "d", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNS", "shape": "xxxx", "suffix": "ees", "ent_type": "QUANTITY", "dep": "pobj", "head": 118, "left_edge": 121, "right_edge": 183}}, {"type": "Token", "start": 374, "end": 375, "id": 124, "features": {"_i": 69, "is_alpha": false, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": true, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": ",", "like_email": false, "like_num": false, "like_url": false, "orth": 2593208677638477497, "pos": "PUNCT", "prefix": ",", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": ",", "shape": ",", "suffix": ",", "ent_type": "", "dep": "punct", "head": 123, "left_edge": 124, "right_edge": 124}}, {"type": "SpaceToken", "start": 375, "end": 376, "id": 125, "features": {"is_space": true}}, {"type": "Token", "start": 376, "end": 381, "id": 126, "features": {"_i": 70, "is_alpha": false, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "12.83", "like_email": false, "like_num": true, "like_url": false, "orth": 3717249910499811532, "pos": "NUM", "prefix": "1", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "CD", "shape": "dd.dd", "suffix": ".83", "ent_type": "MONEY", "dep": "nummod", "head": 140, "left_edge": 126, "right_edge": 126}}, {"type": "Token", "start": 381, "end": 382, "id": 127, "features": {"_i": 71, "is_alpha": false, "is_bracket": false, "is_currency": true, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "$", "like_email": false, "like_num": false, "like_url": false, "orth": 11283501755624150392, "pos": "SYM", "prefix": "$", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "$", "shape": "$", "suffix": "$", "ent_type": "MONEY", "dep": "nummod", "head": 140, "left_edge": 127, "right_edge": 128}}, {"type": "Token", "start": 382, "end": 383, "id": 128, "features": {"_i": 72, "is_alpha": false, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": true, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": ",", "like_email": false, "like_num": false, "like_url": false, "orth": 2593208677638477497, "pos": "PUNCT", "prefix": ",", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": ",", "shape": ",", "suffix": ",", "ent_type": "", "dep": "punct", "head": 127, "left_edge": 128, "right_edge": 128}}, {"type": "SpaceToken", "start": 383, "end": 384, "id": 129, "features": {"is_space": true}}, {"type": "Token", "start": 384, "end": 386, "id": 130, "features": {"_i": 73, "is_alpha": false, "is_bracket": false, "is_currency": false, "is_digit": true, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "25", "like_email": false, "like_num": true, "like_url": false, "orth": 4522981160172931067, "pos": "NUM", "prefix": "2", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "CD", "shape": "dd", "suffix": "25", "ent_type": "QUANTITY", "dep": "nummod", "head": 132, "left_edge": 130, "right_edge": 130}}, {"type": "SpaceToken", "start": 386, "end": 387, "id": 131, "features": {"is_space": true}}, {"type": "Token", "start": 387, "end": 389, "id": 132, "features": {"_i": 74, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "km", "like_email": false, "like_num": false, "like_url": false, "orth": 378805508655178951, "pos": "NOUN", "prefix": "k", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NN", "shape": "xx", "suffix": "km", "ent_type": "QUANTITY", "dep": "dep", "head": 134, "left_edge": 130, "right_edge": 132}}, {"type": "Token", "start": 389, "end": 390, "id": 133, "features": {"_i": 75, "is_alpha": false, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": true, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "/", "like_email": false, "like_num": false, "like_url": false, "orth": 2466615745961202537, "pos": "SYM", "prefix": "/", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "SYM", "shape": "/", "suffix": "/", "ent_type": "", "dep": "punct", "head": 134, "left_edge": 133, "right_edge": 133}}, {"type": "Token", "start": 390, "end": 391, "id": 134, "features": {"_i": 76, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "h", "like_email": false, "like_num": false, "like_url": false, "orth": 15817570140490810055, "pos": "NOUN", "prefix": "h", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NN", "shape": "x", "suffix": "h", "ent_type": "", "dep": "nmod", "head": 140, "left_edge": 130, "right_edge": 138}}, {"type": "SpaceToken", "start": 391, "end": 392, "id": 135, "features": {"is_space": true}}, {"type": "Token", "start": 392, "end": 394, "id": 136, "features": {"_i": 77, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "or", "like_email": false, "like_num": false, "like_url": false, "orth": 3740602843040177340, "pos": "CCONJ", "prefix": "o", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "CC", "shape": "xx", "suffix": "or", "ent_type": "", "dep": "cc", "head": 134, "left_edge": 136, "right_edge": 136}}, {"type": "SpaceToken", "start": 394, "end": 395, "id": 137, "features": {"is_space": true}}, {"type": "Token", "start": 395, "end": 403, "id": 138, "features": {"_i": 78, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "fortytwo", "like_email": false, "like_num": false, "like_url": false, "orth": 14726603731027692826, "pos": "NOUN", "prefix": "f", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NN", "shape": "xxxx", "suffix": "two", "ent_type": "", "dep": "conj", "head": 134, "left_edge": 138, "right_edge": 138}}, {"type": "SpaceToken", "start": 403, "end": 404, "id": 139, "features": {"is_space": true}}, {"type": "Token", "start": 404, "end": 409, "id": 140, "features": {"_i": 79, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "kilo", "like_email": false, "like_num": false, "like_url": false, "orth": 14925654219422422651, "pos": "NOUN", "prefix": "k", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNS", "shape": "xxxx", "suffix": "los", "ent_type": "", "dep": "conj", "head": 123, "left_edge": 126, "right_edge": 183}}, {"type": "SpaceToken", "start": 409, "end": 410, "id": 141, "features": {"is_space": true}}, {"type": "Token", "start": 410, "end": 413, "id": 142, "features": {"_i": 80, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "and", "like_email": false, "like_num": false, "like_url": false, "orth": 2283656566040971221, "pos": "CCONJ", "prefix": "a", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "CC", "shape": "xxx", "suffix": "and", "ent_type": "", "dep": "cc", "head": 140, "left_edge": 142, "right_edge": 142}}, {"type": "SpaceToken", "start": 413, "end": 414, "id": 143, "features": {"is_space": true}}, {"type": "Token", "start": 414, "end": 422, "id": 144, "features": {"_i": 81, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "mention", "like_email": false, "like_num": false, "like_url": false, "orth": 834570530775529781, "pos": "NOUN", "prefix": "m", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNS", "shape": "xxxx", "suffix": "ons", "ent_type": "", "dep": "conj", "head": 140, "left_edge": 144, "right_edge": 145}}, {"type": "SpaceToken", "start": 422, "end": 423, "id": 145, "features": {"_i": 82, "is_alpha": false, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": true, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "\n", "like_email": false, "like_num": false, "like_url": false, "orth": 962983613142996970, "pos": "SPACE", "prefix": "\n", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "_SP", "shape": "\n", "suffix": "\n", "ent_type": "", "dep": "", "head": 144, "left_edge": 145, "right_edge": 145}}, {"type": "Token", "start": 423, "end": 436, "id": 146, "features": {"_i": 83, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "organization", "like_email": false, "like_num": false, "like_url": false, "orth": 13475968074239666840, "pos": "NOUN", "prefix": "o", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNS", "shape": "xxxx", "suffix": "ons", "ent_type": "", "dep": "conj", "head": 140, "left_edge": 146, "right_edge": 183}}, {"type": "SpaceToken", "start": 436, "end": 437, "id": 147, "features": {"is_space": true}}, {"type": "Token", "start": 437, "end": 440, "id": 148, "features": {"_i": 84, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "and", "like_email": false, "like_num": false, "like_url": false, "orth": 2283656566040971221, "pos": "CCONJ", "prefix": "a", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "CC", "shape": "xxx", "suffix": "and", "ent_type": "", "dep": "cc", "head": 146, "left_edge": 148, "right_edge": 148}}, {"type": "SpaceToken", "start": 440, "end": 441, "id": 149, "features": {"is_space": true}}, {"type": "Token", "start": 441, "end": 450, "id": 150, "features": {"_i": 85, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "company", "like_email": false, "like_num": false, "like_url": false, "orth": 8026612326651866097, "pos": "NOUN", "prefix": "c", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNS", "shape": "xxxx", "suffix": "ies", "ent_type": "", "dep": "conj", "head": 146, "left_edge": 150, "right_edge": 150}}, {"type": "SpaceToken", "start": 450, "end": 451, "id": 151, "features": {"is_space": true}}, {"type": "Token", "start": 451, "end": 455, "id": 152, "features": {"_i": 86, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "like", "like_email": false, "like_num": false, "like_url": false, "orth": 18194338103975822726, "pos": "SCONJ", "prefix": "l", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "IN", "shape": "xxxx", "suffix": "ike", "ent_type": "", "dep": "prep", "head": 146, "left_edge": 152, "right_edge": 183}}, {"type": "SpaceToken", "start": 455, "end": 456, "id": 153, "features": {"is_space": true}}, {"type": "Token", "start": 456, "end": 459, "id": 154, "features": {"_i": 87, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "the", "like_email": false, "like_num": false, "like_url": false, "orth": 7425985699627899538, "pos": "DET", "prefix": "t", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "DT", "shape": "xxx", "suffix": "the", "ent_type": "", "dep": "det", "head": 156, "left_edge": 154, "right_edge": 154}}, {"type": "SpaceToken", "start": 459, "end": 460, "id": 155, "features": {"is_space": true}}, {"type": "Token", "start": 460, "end": 463, "id": 156, "features": {"_i": 88, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": true, "lang": "en", "lemma": "UNO", "like_email": false, "like_num": false, "like_url": false, "orth": 16483755664596981775, "pos": "PROPN", "prefix": "U", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNP", "shape": "XXX", "suffix": "UNO", "ent_type": "ORG", "dep": "pobj", "head": 152, "left_edge": 154, "right_edge": 183}}, {"type": "Token", "start": 463, "end": 464, "id": 157, "features": {"_i": 89, "is_alpha": false, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": true, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": ",", "like_email": false, "like_num": false, "like_url": false, "orth": 2593208677638477497, "pos": "PUNCT", "prefix": ",", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": ",", "shape": ",", "suffix": ",", "ent_type": "", "dep": "punct", "head": 156, "left_edge": 157, "right_edge": 157}}, {"type": "SpaceToken", "start": 464, "end": 465, "id": 158, "features": {"is_space": true}}, {"type": "Token", "start": 465, "end": 474, "id": 159, "features": {"_i": 90, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": true, "is_upper": false, "lang": "en", "lemma": "Microsoft", "like_email": false, "like_num": false, "like_url": false, "orth": 5291444330391917710, "pos": "PROPN", "prefix": "M", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNP", "shape": "Xxxxx", "suffix": "oft", "ent_type": "ORG", "dep": "conj", "head": 156, "left_edge": 159, "right_edge": 162}}, {"type": "Token", "start": 474, "end": 475, "id": 160, "features": {"_i": 91, "is_alpha": false, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": true, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": ",", "like_email": false, "like_num": false, "like_url": false, "orth": 2593208677638477497, "pos": "PUNCT", "prefix": ",", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": ",", "shape": ",", "suffix": ",", "ent_type": "", "dep": "punct", "head": 159, "left_edge": 160, "right_edge": 160}}, {"type": "SpaceToken", "start": 475, "end": 476, "id": 161, "features": {"is_space": true}}, {"type": "Token", "start": 476, "end": 481, "id": 162, "features": {"_i": 92, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": true, "is_upper": false, "lang": "en", "lemma": "Apple", "like_email": false, "like_num": false, "like_url": false, "orth": 6418411030699964375, "pos": "PROPN", "prefix": "A", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNP", "shape": "Xxxxx", "suffix": "ple", "ent_type": "ORG", "dep": "conj", "head": 159, "left_edge": 162, "right_edge": 162}}, {"type": "Token", "start": 481, "end": 482, "id": 163, "features": {"_i": 93, "is_alpha": false, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": true, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": ",", "like_email": false, "like_num": false, "like_url": false, "orth": 2593208677638477497, "pos": "PUNCT", "prefix": ",", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": ",", "shape": ",", "suffix": ",", "ent_type": "", "dep": "punct", "head": 156, "left_edge": 163, "right_edge": 163}}, {"type": "SpaceToken", "start": 482, "end": 483, "id": 164, "features": {"is_space": true}}, {"type": "Token", "start": 483, "end": 488, "id": 165, "features": {"_i": 94, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "which", "like_email": false, "like_num": false, "like_url": false, "orth": 7063653163634019529, "pos": "DET", "prefix": "w", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "WDT", "shape": "xxxx", "suffix": "ich", "ent_type": "", "dep": "nsubj", "head": 167, "left_edge": 165, "right_edge": 166}}, {"type": "SpaceToken", "start": 488, "end": 489, "id": 166, "features": {"_i": 95, "is_alpha": false, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": true, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "\n", "like_email": false, "like_num": false, "like_url": false, "orth": 962983613142996970, "pos": "SPACE", "prefix": "\n", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "_SP", "shape": "\n", "suffix": "\n", "ent_type": "", "dep": "", "head": 165, "left_edge": 166, "right_edge": 166}}, {"type": "Token", "start": 489, "end": 492, "id": 167, "features": {"_i": 96, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "have", "like_email": false, "like_num": false, "like_url": false, "orth": 1248239241591158246, "pos": "AUX", "prefix": "h", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "VBZ", "shape": "xxx", "suffix": "has", "ent_type": "", "dep": "relcl", "head": 156, "left_edge": 165, "right_edge": 183}}, {"type": "SpaceToken", "start": 492, "end": 493, "id": 168, "features": {"is_space": true}}, {"type": "Token", "start": 493, "end": 495, "id": 169, "features": {"_i": 97, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "an", "like_email": false, "like_num": false, "like_url": false, "orth": 15099054000809333061, "pos": "DET", "prefix": "a", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "DT", "shape": "xx", "suffix": "an", "ent_type": "", "dep": "det", "head": 171, "left_edge": 169, "right_edge": 169}}, {"type": "SpaceToken", "start": 495, "end": 496, "id": 170, "features": {"is_space": true}}, {"type": "Token", "start": 496, "end": 501, "id": 171, "features": {"_i": 98, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "apple", "like_email": false, "like_num": false, "like_url": false, "orth": 8566208034543834098, "pos": "NOUN", "prefix": "a", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NN", "shape": "xxxx", "suffix": "ple", "ent_type": "", "dep": "dobj", "head": 167, "left_edge": 169, "right_edge": 183}}, {"type": "SpaceToken", "start": 501, "end": 502, "id": 172, "features": {"is_space": true}}, {"type": "Token", "start": 502, "end": 504, "id": 173, "features": {"_i": 99, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "as", "like_email": false, "like_num": false, "like_url": false, "orth": 7437575085468336610, "pos": "SCONJ", "prefix": "a", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "IN", "shape": "xx", "suffix": "as", "ent_type": "", "dep": "mark", "head": 176, "left_edge": 173, "right_edge": 173}}, {"type": "SpaceToken", "start": 504, "end": 505, "id": 174, "features": {"is_space": true}}, {"type": "Token", "start": 505, "end": 507, "id": 175, "features": {"_i": 100, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "-PRON-", "like_email": false, "like_num": false, "like_url": false, "orth": 10239237003504588839, "pos": "PRON", "prefix": "i", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "PRP", "shape": "xx", "suffix": "it", "ent_type": "", "dep": "nsubj", "head": 176, "left_edge": 175, "right_edge": 175}}, {"type": "Token", "start": 507, "end": 509, "id": 176, "features": {"_i": 101, "is_alpha": false, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "be", "like_email": false, "like_num": false, "like_url": false, "orth": 16428057658620181782, "pos": "AUX", "prefix": "'", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "VBZ", "shape": "'x", "suffix": "'s", "ent_type": "", "dep": "advcl", "head": 171, "left_edge": 173, "right_edge": 178}}, {"type": "SpaceToken", "start": 509, "end": 510, "id": 177, "features": {"is_space": true}}, {"type": "Token", "start": 510, "end": 514, "id": 178, "features": {"_i": 102, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "logo", "like_email": false, "like_num": false, "like_url": false, "orth": 16913656293518811842, "pos": "NOUN", "prefix": "l", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NN", "shape": "xxxx", "suffix": "ogo", "ent_type": "", "dep": "attr", "head": 176, "left_edge": 178, "right_edge": 178}}, {"type": "Token", "start": 514, "end": 515, "id": 179, "features": {"_i": 103, "is_alpha": false, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": true, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": ",", "like_email": false, "like_num": false, "like_url": false, "orth": 2593208677638477497, "pos": "PUNCT", "prefix": ",", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": ",", "shape": ",", "suffix": ",", "ent_type": "", "dep": "punct", "head": 171, "left_edge": 179, "right_edge": 179}}, {"type": "SpaceToken", "start": 515, "end": 516, "id": 180, "features": {"is_space": true}}, {"type": "Token", "start": 516, "end": 518, "id": 181, "features": {"_i": 104, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": true, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": true, "is_title": false, "is_upper": false, "lang": "en", "lemma": "or", "like_email": false, "like_num": false, "like_url": false, "orth": 3740602843040177340, "pos": "CCONJ", "prefix": "o", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "CC", "shape": "xx", "suffix": "or", "ent_type": "", "dep": "cc", "head": 171, "left_edge": 181, "right_edge": 181}}, {"type": "SpaceToken", "start": 518, "end": 519, "id": 182, "features": {"is_space": true}}, {"type": "Token", "start": 519, "end": 525, "id": 183, "features": {"_i": 105, "is_alpha": true, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": true, "is_upper": false, "lang": "en", "lemma": "Google", "like_email": false, "like_num": false, "like_url": false, "orth": 11578853341595296054, "pos": "PROPN", "prefix": "G", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "NNP", "shape": "Xxxxx", "suffix": "gle", "ent_type": "ORG", "dep": "conj", "head": 171, "left_edge": 183, "right_edge": 183}}, {"type": "Token", "start": 525, "end": 526, "id": 184, "features": {"_i": 106, "is_alpha": false, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": true, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": false, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": ".", "like_email": false, "like_num": false, "like_url": false, "orth": 12646065887601541794, "pos": "PUNCT", "prefix": ".", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": ".", "shape": ".", "suffix": ".", "ent_type": "", "dep": "punct", "head": 104, "left_edge": 184, "right_edge": 186}}, {"type": "SpaceToken", "start": 526, "end": 527, "id": 185, "features": {"is_space": true}}, {"type": "SpaceToken", "start": 527, "end": 530, "id": 186, "features": {"_i": 107, "is_alpha": false, "is_bracket": false, "is_currency": false, "is_digit": false, "is_left_punct": false, "is_lower": false, "is_oov": true, "is_punct": false, "is_quote": false, "is_right_punct": false, "is_sent_start": null, "is_space": true, "is_stop": false, "is_title": false, "is_upper": false, "lang": "en", "lemma": "\n\n\n", "like_email": false, "like_num": false, "like_url": false, "orth": 7412267946231497360, "pos": "SPACE", "prefix": "\n", "prob": -20.0, "rank": 18446744073709551615, "sentiment": 0.0, "tag": "_SP", "shape": "\n\n\n", "suffix": "\n\n\n", "ent_type": "", "dep": "", "head": 184, "left_edge": 186, "right_edge": 186}}, {"type": "PERSON", "start": 114, "end": 126, "id": 187, "features": {"lemma": "Barack Obama"}}, {"type": "PERSON", "start": 129, "end": 144, "id": 188, "features": {"lemma": "Albert Einstein"}}, {"type": "PERSON", "start": 149, "end": 172, "id": 189, "features": {"lemma": "Wolfgang Amadeus Mozart"}}, {"type": "GPE", "start": 219, "end": 226, "id": 190, "features": {"lemma": "America"}}, {"type": "GPE", "start": 228, "end": 252, "id": 191, "features": {"lemma": "United States of America"}}, {"type": "GPE", "start": 255, "end": 262, "id": 192, "features": {"lemma": "Hungary"}}, {"type": "LOC", "start": 264, "end": 282, "id": 193, "features": {"lemma": "the Atlantic Ocean"}}, {"type": "PERSON", "start": 288, "end": 297, "id": 194, "features": {"lemma": "Helskinki"}}, {"type": "QUANTITY", "start": 364, "end": 374, "id": 195, "features": {"lemma": "12 degree"}}, {"type": "MONEY", "start": 376, "end": 382, "id": 196, "features": {"lemma": "12.83 $"}}, {"type": "QUANTITY", "start": 384, "end": 389, "id": 197, "features": {"lemma": "25 km"}}, {"type": "ORG", "start": 460, "end": 463, "id": 198, "features": {"lemma": "UNO"}}, {"type": "ORG", "start": 465, "end": 474, "id": 199, "features": {"lemma": "Microsoft"}}, {"type": "ORG", "start": 476, "end": 481, "id": 200, "features": {"lemma": "Apple"}}, {"type": "ORG", "start": 519, "end": 525, "id": 201, "features": {"lemma": "Google"}}, {"type": "Sentence", "start": 0, "end": 64, "id": 202, "features": {}}, {"type": "Sentence", "start": 64, "end": 301, "id": 203, "features": {}}, {"type": "Sentence", "start": 301, "end": 530, "id": 204, "features": {}}, {"type": "NounChunk", "start": 8, "end": 30, "id": 205, "features": {}}, {"type": "NounChunk", "start": 54, "end": 61, "id": 206, "features": {}}, {"type": "NounChunk", "start": 64, "end": 66, "id": 207, "features": {}}, {"type": "NounChunk", "start": 76, "end": 96, "id": 208, "features": {}}, {"type": "NounChunk", "start": 102, "end": 113, "id": 209, "features": {}}, {"type": "NounChunk", "start": 114, "end": 126, "id": 210, "features": {}}, {"type": "NounChunk", "start": 129, "end": 144, "id": 211, "features": {}}, {"type": "NounChunk", "start": 149, "end": 172, "id": 212, "features": {}}, {"type": "NounChunk", "start": 177, "end": 204, "id": 213, "features": {}}, {"type": "NounChunk", "start": 209, "end": 226, "id": 214, "features": {}}, {"type": "NounChunk", "start": 228, "end": 241, "id": 215, "features": {}}, {"type": "NounChunk", "start": 245, "end": 252, "id": 216, "features": {}}, {"type": "NounChunk", "start": 255, "end": 262, "id": 217, "features": {}}, {"type": "NounChunk", "start": 264, "end": 282, "id": 218, "features": {}}, {"type": "NounChunk", "start": 288, "end": 297, "id": 219, "features": {}}, {"type": "NounChunk", "start": 301, "end": 303, "id": 220, "features": {}}, {"type": "NounChunk", "start": 318, "end": 326, "id": 221, "features": {}}, {"type": "NounChunk", "start": 330, "end": 345, "id": 222, "features": {}}, {"type": "NounChunk", "start": 350, "end": 357, "id": 223, "features": {}}, {"type": "NounChunk", "start": 364, "end": 374, "id": 224, "features": {}}, {"type": "NounChunk", "start": 376, "end": 409, "id": 225, "features": {}}, {"type": "NounChunk", "start": 414, "end": 422, "id": 226, "features": {}}, {"type": "NounChunk", "start": 423, "end": 436, "id": 227, "features": {}}, {"type": "NounChunk", "start": 441, "end": 450, "id": 228, "features": {}}, {"type": "NounChunk", "start": 456, "end": 463, "id": 229, "features": {}}, {"type": "NounChunk", "start": 465, "end": 474, "id": 230, "features": {}}, {"type": "NounChunk", "start": 476, "end": 481, "id": 231, "features": {}}, {"type": "NounChunk", "start": 493, "end": 501, "id": 232, "features": {}}, {"type": "NounChunk", "start": 505, "end": 507, "id": 233, "features": {}}, {"type": "NounChunk", "start": 510, "end": 514, "id": 234, "features": {}}, {"type": "NounChunk", "start": 519, "end": 525, "id": 235, "features": {}}], "next_annid": 236}}, "text": "This is just a sample document for experimenting with gatenlp. \nIt mentions a few named entities like the persons Barack Obama, \nAlbert Einstein and Wolfgang Amadeus Mozart and the geographical \nlocations and countries America, United States of America, \nHungary, the Atlantic Ocean, and Helskinki. \n\nIt also contains mentions of various numbers and amounts like \n12 degrees, 12.83$, 25 km/h or fortytwo kilos and mentions\norganizations and companies like the UNO, Microsoft, Apple, which\nhas an apple as it's logo, or Google. \n\n\n", "features": {}, "offset_type": "j", "name": ""}
    </script>
    <script type="text/javascript">
        gatenlp_run("PZQXZBUIJE-");
    </script>
  </div>

</div></div>




```python

```
