import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataArchiveFileConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file#excludes DataArchiveFile#excludes}
    */
    readonly excludes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file#output_file_mode DataArchiveFile#output_file_mode}
    */
    readonly outputFileMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file#output_path DataArchiveFile#output_path}
    */
    readonly outputPath: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file#source_content DataArchiveFile#source_content}
    */
    readonly sourceContent?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file#source_content_filename DataArchiveFile#source_content_filename}
    */
    readonly sourceContentFilename?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file#source_dir DataArchiveFile#source_dir}
    */
    readonly sourceDir?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file#source_file DataArchiveFile#source_file}
    */
    readonly sourceFile?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file#type DataArchiveFile#type}
    */
    readonly type: string;
    /**
    * source block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file#source DataArchiveFile#source}
    */
    readonly source?: DataArchiveFileSource[] | cdktf.IResolvable;
}
export interface DataArchiveFileSource {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file#content DataArchiveFile#content}
    */
    readonly content: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file#filename DataArchiveFile#filename}
    */
    readonly filename: string;
}
export declare function dataArchiveFileSourceToTerraform(struct?: DataArchiveFileSource | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/archive/d/file archive_file}
*/
export declare class DataArchiveFile extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "archive_file";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/archive/d/file archive_file} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataArchiveFileConfig
    */
    constructor(scope: Construct, id: string, config: DataArchiveFileConfig);
    private _excludes?;
    get excludes(): string[];
    set excludes(value: string[]);
    resetExcludes(): void;
    get excludesInput(): string[] | undefined;
    get id(): string;
    get outputBase64Sha256(): string;
    private _outputFileMode?;
    get outputFileMode(): string;
    set outputFileMode(value: string);
    resetOutputFileMode(): void;
    get outputFileModeInput(): string | undefined;
    get outputMd5(): string;
    private _outputPath?;
    get outputPath(): string;
    set outputPath(value: string);
    get outputPathInput(): string | undefined;
    get outputSha(): string;
    get outputSize(): number;
    private _sourceContent?;
    get sourceContent(): string;
    set sourceContent(value: string);
    resetSourceContent(): void;
    get sourceContentInput(): string | undefined;
    private _sourceContentFilename?;
    get sourceContentFilename(): string;
    set sourceContentFilename(value: string);
    resetSourceContentFilename(): void;
    get sourceContentFilenameInput(): string | undefined;
    private _sourceDir?;
    get sourceDir(): string;
    set sourceDir(value: string);
    resetSourceDir(): void;
    get sourceDirInput(): string | undefined;
    private _sourceFile?;
    get sourceFile(): string;
    set sourceFile(value: string);
    resetSourceFile(): void;
    get sourceFileInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _source?;
    get source(): DataArchiveFileSource[] | cdktf.IResolvable;
    set source(value: DataArchiveFileSource[] | cdktf.IResolvable);
    resetSource(): void;
    get sourceInput(): cdktf.IResolvable | DataArchiveFileSource[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-archive-file.d.ts.map