"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Es = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [es](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonopensearchservicesuccessortoamazonelasticsearchservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Es extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [es](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonopensearchservicesuccessortoamazonelasticsearchservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'es';
        this.accessLevelList = {
            Write: [
                'AcceptInboundConnection',
                'AcceptInboundCrossClusterSearchConnection',
                'AssociatePackage',
                'CancelElasticsearchServiceSoftwareUpdate',
                'CancelServiceSoftwareUpdate',
                'CreateDomain',
                'CreateElasticsearchDomain',
                'CreateElasticsearchServiceRole',
                'CreateOutboundConnection',
                'CreateOutboundCrossClusterSearchConnection',
                'CreatePackage',
                'CreateServiceRole',
                'DeleteDomain',
                'DeleteElasticsearchDomain',
                'DeleteElasticsearchServiceRole',
                'DeleteInboundConnection',
                'DeleteInboundCrossClusterSearchConnection',
                'DeleteOutboundConnection',
                'DeleteOutboundCrossClusterSearchConnection',
                'DeletePackage',
                'DissociatePackage',
                'ESHttpDelete',
                'ESHttpPatch',
                'ESHttpPost',
                'ESHttpPut',
                'PurchaseReservedElasticsearchInstanceOffering',
                'PurchaseReservedInstanceOffering',
                'RejectInboundConnection',
                'RejectInboundCrossClusterSearchConnection',
                'StartElasticsearchServiceSoftwareUpdate',
                'StartServiceSoftwareUpdate',
                'UpdateDomainConfig',
                'UpdateElasticsearchDomainConfig',
                'UpdatePackage',
                'UpgradeDomain',
                'UpgradeElasticsearchDomain'
            ],
            Tagging: [
                'AddTags',
                'RemoveTags'
            ],
            Read: [
                'DescribeDomain',
                'DescribeDomainAutoTunes',
                'DescribeDomainChangeProgress',
                'DescribeDomainConfig',
                'DescribeElasticsearchDomain',
                'DescribeElasticsearchDomainConfig',
                'DescribePackages',
                'ESCrossClusterGet',
                'ESHttpGet',
                'ESHttpHead',
                'GetPackageVersionHistory',
                'GetUpgradeHistory',
                'GetUpgradeStatus',
                'ListTags'
            ],
            List: [
                'DescribeDomains',
                'DescribeElasticsearchDomains',
                'DescribeElasticsearchInstanceTypeLimits',
                'DescribeInboundConnections',
                'DescribeInboundCrossClusterSearchConnections',
                'DescribeInstanceTypeLimits',
                'DescribeOutboundConnections',
                'DescribeOutboundCrossClusterSearchConnections',
                'DescribeReservedElasticsearchInstanceOfferings',
                'DescribeReservedElasticsearchInstances',
                'DescribeReservedInstanceOfferings',
                'DescribeReservedInstances',
                'GetCompatibleElasticsearchVersions',
                'GetCompatibleVersions',
                'ListDomainNames',
                'ListDomainsForPackage',
                'ListElasticsearchInstanceTypeDetails',
                'ListElasticsearchInstanceTypes',
                'ListElasticsearchVersions',
                'ListInstanceTypeDetails',
                'ListPackagesForDomain',
                'ListVersions'
            ]
        };
    }
    /**
     * Grants permission to the destination domain owner to accept an inbound cross-cluster search connection request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-accept-inbound-cross-cluster-search-connection
     */
    toAcceptInboundConnection() {
        return this.to('AcceptInboundConnection');
    }
    /**
     * Grants permission to the destination domain owner to accept an inbound cross-cluster search connection request. This permission is deprecated. Use AcceptInboundConnection instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-accept-inbound-cross-cluster-search-connection
     */
    toAcceptInboundCrossClusterSearchConnection() {
        return this.to('AcceptInboundCrossClusterSearchConnection');
    }
    /**
     * Grants permission to attach resource tags to an OpenSearch Service domain
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-addtags
     */
    toAddTags() {
        return this.to('AddTags');
    }
    /**
     * Grants permission to associate a package with an OpenSearch Service domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-associatepackage
     */
    toAssociatePackage() {
        return this.to('AssociatePackage');
    }
    /**
     * Grants permission to cancel a service software update of a domain. This permission is deprecated. Use CancelServiceSoftwareUpdate instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-stopupdate
     */
    toCancelElasticsearchServiceSoftwareUpdate() {
        return this.to('CancelElasticsearchServiceSoftwareUpdate');
    }
    /**
     * Grants permission to cancel a service software update of a domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-stopupdate
     */
    toCancelServiceSoftwareUpdate() {
        return this.to('CancelServiceSoftwareUpdate');
    }
    /**
     * Grants permission to create an Amazon OpenSearch Service domain
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-createdomain
     */
    toCreateDomain() {
        return this.to('CreateDomain');
    }
    /**
     * Grants permission to create an OpenSearch Service domain. This permission is deprecated. Use CreateDomain instead
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-createdomain
     */
    toCreateElasticsearchDomain() {
        return this.to('CreateElasticsearchDomain');
    }
    /**
     * Grants permission to create the service-linked role required for OpenSearch Service domains that use VPC access. This permission is deprecated. OpenSearch Service creates the service-linked role for you
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-createservicerole
     */
    toCreateElasticsearchServiceRole() {
        return this.to('CreateElasticsearchServiceRole');
    }
    /**
     * Grants permission to create a new cross-cluster search connection from a source domain to a destination domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-create-outbound-cross-cluster-search-connection
     */
    toCreateOutboundConnection() {
        return this.to('CreateOutboundConnection');
    }
    /**
     * Grants permission to create a new cross-cluster search connection from a source domain to a destination domain. This permission is deprecated. Use CreateOutboundConnection instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-create-outbound-cross-cluster-search-connection
     */
    toCreateOutboundCrossClusterSearchConnection() {
        return this.to('CreateOutboundCrossClusterSearchConnection');
    }
    /**
     * Grants permission to add a package for use with OpenSearch Service domains
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-createpackage
     */
    toCreatePackage() {
        return this.to('CreatePackage');
    }
    /**
     * Grants permission to create the service-linked role required for Amazon OpenSearch Service domains that use VPC access
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-createservicerole
     */
    toCreateServiceRole() {
        return this.to('CreateServiceRole');
    }
    /**
     * Grants permission to delete an Amazon OpenSearch Service domain and all of its data
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-deletedomain
     */
    toDeleteDomain() {
        return this.to('DeleteDomain');
    }
    /**
     * Grants permission to delete an OpenSearch Service domain and all of its data. This permission is deprecated. Use DeleteDomain instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-deletedomain
     */
    toDeleteElasticsearchDomain() {
        return this.to('DeleteElasticsearchDomain');
    }
    /**
     * Grants permission to delete the service-linked role required for OpenSearch Service domains that use VPC access. This permission is deprecated. Use the IAM API to delete service-linked roles
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-deleteservicerole
     */
    toDeleteElasticsearchServiceRole() {
        return this.to('DeleteElasticsearchServiceRole');
    }
    /**
     * Grants permission to the destination domain owner to delete an existing inbound cross-cluster search connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-delete-inbound-cross-cluster-search-connection
     */
    toDeleteInboundConnection() {
        return this.to('DeleteInboundConnection');
    }
    /**
     * Grants permission to the destination domain owner to delete an existing inbound cross-cluster search connection. This permission is deprecated. Use DeleteInboundConnection instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-delete-inbound-cross-cluster-search-connection
     */
    toDeleteInboundCrossClusterSearchConnection() {
        return this.to('DeleteInboundCrossClusterSearchConnection');
    }
    /**
     * Grants permission to the source domain owner to delete an existing outbound cross-cluster search connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-delete-outbound-cross-cluster-search-connection
     */
    toDeleteOutboundConnection() {
        return this.to('DeleteOutboundConnection');
    }
    /**
     * Grants permission to the source domain owner to delete an existing outbound cross-cluster search connection. This permission is deprecated. Use DeleteOutboundConnection instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-delete-outbound-cross-cluster-search-connection
     */
    toDeleteOutboundCrossClusterSearchConnection() {
        return this.to('DeleteOutboundCrossClusterSearchConnection');
    }
    /**
     * Grants permission to delete a package from OpenSearch Service. The package cannot be associated with any domains
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-deletepackage
     */
    toDeletePackage() {
        return this.to('DeletePackage');
    }
    /**
     * Grants permission to view a description of the domain configuration for the specified OpenSearch Service domain, including the domain ID, service endpoint, and ARN
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describedomain
     */
    toDescribeDomain() {
        return this.to('DescribeDomain');
    }
    /**
     * Grants permission to view the Auto-Tune configuration of the domain for the specified OpenSearch Service domain, including the Auto-Tune state and maintenance schedules
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describeautotune
     */
    toDescribeDomainAutoTunes() {
        return this.to('DescribeDomainAutoTunes');
    }
    /**
     * Grants permission to view detail stage progress of an OpenSearch Service domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describedomainchangeprogress
     */
    toDescribeDomainChangeProgress() {
        return this.to('DescribeDomainChangeProgress');
    }
    /**
     * Grants permission to view a description of the configuration options and status of an OpenSearch Service domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describedomainconfig
     */
    toDescribeDomainConfig() {
        return this.to('DescribeDomainConfig');
    }
    /**
     * Grants permission to view a description of the domain configuration for up to five specified OpenSearch Service domains
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describedomains
     */
    toDescribeDomains() {
        return this.to('DescribeDomains');
    }
    /**
     * Grants permission to view a description of the domain configuration for the specified OpenSearch Service domain, including the domain ID, service endpoint, and ARN. This permission is deprecated. Use DescribeDomain instead
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describedomain
     */
    toDescribeElasticsearchDomain() {
        return this.to('DescribeElasticsearchDomain');
    }
    /**
     * Grants permission to view a description of the configuration and status of an OpenSearch Service domain. This permission is deprecated. Use DescribeDomainConfig instead
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describedomainconfig
     */
    toDescribeElasticsearchDomainConfig() {
        return this.to('DescribeElasticsearchDomainConfig');
    }
    /**
     * Grants permission to view a description of the domain configuration for up to five specified Amazon OpenSearch domains. This permission is deprecated. Use DescribeDomains instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describedomains
     */
    toDescribeElasticsearchDomains() {
        return this.to('DescribeElasticsearchDomains');
    }
    /**
     * Grants permission to view the instance count, storage, and master node limits for a given OpenSearch version and instance type. This permission is deprecated. Use DescribeInstanceTypeLimits instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describeinstancetypelimits
     */
    toDescribeElasticsearchInstanceTypeLimits() {
        return this.to('DescribeElasticsearchInstanceTypeLimits');
    }
    /**
     * Grants permission to list all the inbound cross-cluster search connections for a destination domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describe-inbound-cross-cluster-search-connections
     */
    toDescribeInboundConnections() {
        return this.to('DescribeInboundConnections');
    }
    /**
     * Grants permission to list all the inbound cross-cluster search connections for a destination domain. This permission is deprecated. Use DescribeInboundConnections instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describe-inbound-cross-cluster-search-connections
     */
    toDescribeInboundCrossClusterSearchConnections() {
        return this.to('DescribeInboundCrossClusterSearchConnections');
    }
    /**
     * Grants permission to view the instance count, storage, and master node limits for a given engine version and instance type
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describeinstancetypelimits
     */
    toDescribeInstanceTypeLimits() {
        return this.to('DescribeInstanceTypeLimits');
    }
    /**
     * Grants permission to list all the outbound cross-cluster search connections for a source domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describe-outbound-cross-cluster-search-connections
     */
    toDescribeOutboundConnections() {
        return this.to('DescribeOutboundConnections');
    }
    /**
     * Grants permission to list all the outbound cross-cluster search connections for a source domain. This permission is deprecated. Use DescribeOutboundConnections instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describe-outbound-cross-cluster-search-connections
     */
    toDescribeOutboundCrossClusterSearchConnections() {
        return this.to('DescribeOutboundCrossClusterSearchConnections');
    }
    /**
     * Grants permission to describe all packages available to OpenSearch Service domains
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describepackages
     */
    toDescribePackages() {
        return this.to('DescribePackages');
    }
    /**
     * Grants permission to fetch Reserved Instance offerings for Amazon OpenSearch Service. This permission is deprecated. Use DescribeReservedInstanceOfferings instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describereservedinstanceofferings
     */
    toDescribeReservedElasticsearchInstanceOfferings() {
        return this.to('DescribeReservedElasticsearchInstanceOfferings');
    }
    /**
     * Grants permission to fetch OpenSearch Service Reserved Instances that have already been purchased. This permission is deprecated. Use DescribeReservedInstances instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describereservedinstances
     */
    toDescribeReservedElasticsearchInstances() {
        return this.to('DescribeReservedElasticsearchInstances');
    }
    /**
     * Grants permission to fetch Reserved Instance offerings for OpenSearch Service
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describereservedinstanceofferings
     */
    toDescribeReservedInstanceOfferings() {
        return this.to('DescribeReservedInstanceOfferings');
    }
    /**
     * Grants permission to fetch OpenSearch Service Reserved Instances that have already been purchased
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describereservedinstances
     */
    toDescribeReservedInstances() {
        return this.to('DescribeReservedInstances');
    }
    /**
     * Grants permission to disassociate a package from the specified OpenSearch Service domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-dissociatepackage
     */
    toDissociatePackage() {
        return this.to('DissociatePackage');
    }
    /**
     * Grants permission to send cross-cluster requests to a destination domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ac.html#ac-reference
     */
    toESCrossClusterGet() {
        return this.to('ESCrossClusterGet');
    }
    /**
     * Grants permission to send HTTP DELETE requests to the OpenSearch APIs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ac.html#ac-reference
     */
    toESHttpDelete() {
        return this.to('ESHttpDelete');
    }
    /**
     * Grants permission to send HTTP GET requests to the OpenSearch APIs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ac.html#ac-reference
     */
    toESHttpGet() {
        return this.to('ESHttpGet');
    }
    /**
     * Grants permission to send HTTP HEAD requests to the OpenSearch APIs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ac.html#ac-reference
     */
    toESHttpHead() {
        return this.to('ESHttpHead');
    }
    /**
     * Grants permission to send HTTP PATCH requests to the OpenSearch APIs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ac.html#ac-reference
     */
    toESHttpPatch() {
        return this.to('ESHttpPatch');
    }
    /**
     * Grants permission to send HTTP POST requests to the OpenSearch APIs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ac.html#ac-reference
     */
    toESHttpPost() {
        return this.to('ESHttpPost');
    }
    /**
     * Grants permission to send HTTP PUT requests to the OpenSearch APIs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ac.html#ac-reference
     */
    toESHttpPut() {
        return this.to('ESHttpPut');
    }
    /**
     * Grants permission to fetch a list of compatible OpenSearch and Elasticsearch versions to which an OpenSearch Service domain can be upgraded. This permission is deprecated. Use GetCompatibleVersions instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-get-compat-vers
     */
    toGetCompatibleElasticsearchVersions() {
        return this.to('GetCompatibleElasticsearchVersions');
    }
    /**
     * Grants permission to fetch list of compatible engine versions to which an OpenSearch Service domain can be upgraded
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-get-compat-vers
     */
    toGetCompatibleVersions() {
        return this.to('GetCompatibleVersions');
    }
    /**
     * Grants permission to fetch the version history for a package
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-get-pac-ver-hist
     */
    toGetPackageVersionHistory() {
        return this.to('GetPackageVersionHistory');
    }
    /**
     * Grants permission to fetch the upgrade history of a given OpenSearch Service domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-get-upgrade-hist
     */
    toGetUpgradeHistory() {
        return this.to('GetUpgradeHistory');
    }
    /**
     * Grants permission to fetch the upgrade status of a given OpenSearch Service domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-get-upgrade-stat
     */
    toGetUpgradeStatus() {
        return this.to('GetUpgradeStatus');
    }
    /**
     * Grants permission to display the names of all OpenSearch Service domains that the current user owns
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-listdomainnames
     */
    toListDomainNames() {
        return this.to('ListDomainNames');
    }
    /**
     * Grants permission to list all OpenSearch Service domains that a package is associated with
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-listdomainsforpackage
     */
    toListDomainsForPackage() {
        return this.to('ListDomainsForPackage');
    }
    /**
     * Grants permission to list all instance types and available features for a given OpenSearch version. This permission is deprecated. Use ListInstanceTypeDetails instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-listinstancetypedetails
     */
    toListElasticsearchInstanceTypeDetails() {
        return this.to('ListElasticsearchInstanceTypeDetails');
    }
    /**
     * Grants permission to list all EC2 instance types that are supported for a given OpenSearch version
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html
     */
    toListElasticsearchInstanceTypes() {
        return this.to('ListElasticsearchInstanceTypes');
    }
    /**
     * Grants permission to list all supported OpenSearch versions on Amazon OpenSearch Service. This permission is deprecated. Use ListVersions instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-listversions
     */
    toListElasticsearchVersions() {
        return this.to('ListElasticsearchVersions');
    }
    /**
     * Grants permission to list all instance types and available features for a given OpenSearch or Elasticsearch version
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-listinstancetypedetails
     */
    toListInstanceTypeDetails() {
        return this.to('ListInstanceTypeDetails');
    }
    /**
     * Grants permission to list all packages associated with the OpenSearch Service domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-listpackagesfordomain
     */
    toListPackagesForDomain() {
        return this.to('ListPackagesForDomain');
    }
    /**
     * Grants permission to display all resource tags for an OpenSearch Service domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-listtags
     */
    toListTags() {
        return this.to('ListTags');
    }
    /**
     * Grants permission to list all supported OpenSearch and Elasticsearch versions in Amazon OpenSearch Service
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-listversions
     */
    toListVersions() {
        return this.to('ListVersions');
    }
    /**
     * Grants permission to purchase OpenSearch Service Reserved Instances. This permission is deprecated. Use PurchaseReservedInstanceOffering instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-purchasereservedinstance
     */
    toPurchaseReservedElasticsearchInstanceOffering() {
        return this.to('PurchaseReservedElasticsearchInstanceOffering');
    }
    /**
     * Grants permission to purchase OpenSearch reserved instances
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-purchasereservedinstance
     */
    toPurchaseReservedInstanceOffering() {
        return this.to('PurchaseReservedInstanceOffering');
    }
    /**
     * Grants permission to the destination domain owner to reject an inbound cross-cluster search connection request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-reject-inbound-cross-cluster-search-connection
     */
    toRejectInboundConnection() {
        return this.to('RejectInboundConnection');
    }
    /**
     * Grants permission to the destination domain owner to reject an inbound cross-cluster search connection request. This permission is deprecated. Use RejectInboundConnection instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-reject-inbound-cross-cluster-search-connection
     */
    toRejectInboundCrossClusterSearchConnection() {
        return this.to('RejectInboundCrossClusterSearchConnection');
    }
    /**
     * Grants permission to remove resource tags from an OpenSearch Service domain
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-removetags
     */
    toRemoveTags() {
        return this.to('RemoveTags');
    }
    /**
     * Grants permission to start a service software update of a domain. This permission is deprecated. Use StartServiceSoftwareUpdate instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-startupdate
     */
    toStartElasticsearchServiceSoftwareUpdate() {
        return this.to('StartElasticsearchServiceSoftwareUpdate');
    }
    /**
     * Grants permission to start a service software update of a domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-startupdate
     */
    toStartServiceSoftwareUpdate() {
        return this.to('StartServiceSoftwareUpdate');
    }
    /**
     * Grants permission to modify the configuration of an OpenSearch Service domain, such as the instance type or number of instances
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-updatedomainconfig
     */
    toUpdateDomainConfig() {
        return this.to('UpdateDomainConfig');
    }
    /**
     * Grants permission to modify the configuration of an OpenSearch Service domain, such as the instance type or number of instances. This permission is deprecated. Use UpdateDomainConfig instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-updatedomainconfig
     */
    toUpdateElasticsearchDomainConfig() {
        return this.to('UpdateElasticsearchDomainConfig');
    }
    /**
     * Grants permission to update a package for use with OpenSearch Service domains
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-updatepackage
     */
    toUpdatePackage() {
        return this.to('UpdatePackage');
    }
    /**
     * Grants permission to initiate upgrade of an OpenSearch Service domain to a given version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-upgrade-domain
     */
    toUpgradeDomain() {
        return this.to('UpgradeDomain');
    }
    /**
     * Grants permission to initiate upgrade of an OpenSearch Service domain to a specified version. This permission is deprecated. Use UpgradeDomain instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-upgrade-domain
     */
    toUpgradeElasticsearchDomain() {
        return this.to('UpgradeElasticsearchDomain');
    }
    /**
     * Adds a resource of type domain to the statement
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ac.html
     *
     * @param domainName - Identifier for the domainName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDomain(domainName, account, region, partition) {
        return this.on(`arn:${partition || Es.defaultPartition}:es:${region || '*'}:${account || '*'}:domain/${domainName}`);
    }
    /**
     * Adds a resource of type es_role to the statement
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/slr.html
     *
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEsRole(account, partition) {
        return this.on(`arn:${partition || Es.defaultPartition}:iam::${account || '*'}:role/aws-service-role/es.amazonaws.com/AWSServiceRoleForAmazonOpenSearchService`);
    }
    /**
     * Adds a resource of type opensearchservice_role to the statement
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/slr.html
     *
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onOpensearchserviceRole(account, partition) {
        return this.on(`arn:${partition || Es.defaultPartition}:iam::${account || '*'}:role/aws-service-role/opensearchservice.amazonaws.com/AWSServiceRoleForAmazonOpenSearchService`);
    }
}
exports.Es = Es;
_a = JSII_RTTI_SYMBOL_1;
Es[_a] = { fqn: "iam-floyd.Es", version: "0.359.0" };
//# sourceMappingURL=data:application/json;base64,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