# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models import util


class ModelIdentity(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, artifact_name_template: str=None, name: str=None, version: str=None):  # noqa: E501
        """ModelIdentity - a model defined in Swagger

        :param artifact_name_template: The artifact_name_template of this ModelIdentity.  # noqa: E501
        :type artifact_name_template: str
        :param name: The name of this ModelIdentity.  # noqa: E501
        :type name: str
        :param version: The version of this ModelIdentity.  # noqa: E501
        :type version: str
        """
        self.swagger_types = {
            'artifact_name_template': str,
            'name': str,
            'version': str
        }

        self.attribute_map = {
            'artifact_name_template': 'artifactNameTemplate',
            'name': 'name',
            'version': 'version'
        }

        self._artifact_name_template = artifact_name_template
        self._name = name
        self._version = version

    @classmethod
    def from_dict(cls, dikt) -> 'ModelIdentity':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ModelIdentity of this ModelIdentity.  # noqa: E501
        :rtype: ModelIdentity
        """
        return util.deserialize_model(dikt, cls)

    @property
    def artifact_name_template(self) -> str:
        """Gets the artifact_name_template of this ModelIdentity.

        Template of output artifact name  # noqa: E501

        :return: The artifact_name_template of this ModelIdentity.
        :rtype: str
        """
        return self._artifact_name_template

    @artifact_name_template.setter
    def artifact_name_template(self, artifact_name_template: str):
        """Sets the artifact_name_template of this ModelIdentity.

        Template of output artifact name  # noqa: E501

        :param artifact_name_template: The artifact_name_template of this ModelIdentity.
        :type artifact_name_template: str
        """

        self._artifact_name_template = artifact_name_template

    @property
    def name(self) -> str:
        """Gets the name of this ModelIdentity.

        Model name  # noqa: E501

        :return: The name of this ModelIdentity.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str):
        """Sets the name of this ModelIdentity.

        Model name  # noqa: E501

        :param name: The name of this ModelIdentity.
        :type name: str
        """

        self._name = name

    @property
    def version(self) -> str:
        """Gets the version of this ModelIdentity.

        Model version  # noqa: E501

        :return: The version of this ModelIdentity.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version: str):
        """Sets the version of this ModelIdentity.

        Model version  # noqa: E501

        :param version: The version of this ModelIdentity.
        :type version: str
        """

        self._version = version
