# -*- coding: utf-8 -*-
"""rename tables

Revision ID: 33b76c3cb892
Revises: 2e3f33b8ea46
Create Date: 2015-02-07 12:52:16.186363

"""

from __future__ import unicode_literals

# revision identifiers, used by Alembic.
revision = '33b76c3cb892'
down_revision = u'2e3f33b8ea46'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
import rattail.db.types



def upgrade():

    # Drop all constraints which will be changing.
    op.drop_constraint('roles_uq_name', 'roles', type_='unique')
    op.drop_constraint('permissions_fk_role', 'permissions', type_='foreignkey')
    op.drop_constraint('users_fk_person', 'users', type_='foreignkey')
    op.drop_constraint('users_uq_username', 'users', type_='unique')
    op.drop_constraint('users_roles_fk_role', 'users_roles', type_='foreignkey')
    op.drop_constraint('users_roles_fk_user', 'users_roles', type_='foreignkey')
    op.drop_constraint('employees_fk_person', 'employees', type_='foreignkey')
    op.drop_constraint('customers_groups_fk_group', 'customers_groups', type_='foreignkey')
    op.drop_constraint('customers_groups_fk_customer', 'customers_groups', type_='foreignkey')
    op.drop_constraint('customers_people_fk_customer', 'customers_people', type_='foreignkey')
    op.drop_constraint('customers_people_fk_person', 'customers_people', type_='foreignkey')
    op.drop_constraint('vendors_uq_id', 'vendors', type_='unique')
    op.drop_constraint('vendor_contacts_fk_vendor', 'vendor_contacts', type_='foreignkey')
    op.drop_constraint('vendor_contacts_fk_person', 'vendor_contacts', type_='foreignkey')
    op.drop_constraint('categories_fk_department', 'categories', type_='foreignkey')
    op.drop_constraint('report_codes_uq_code', 'report_codes', type_='unique')
    op.drop_constraint('products_fk_department', 'products', type_='foreignkey')
    op.drop_constraint('products_fk_subdepartment', 'products', type_='foreignkey')
    op.drop_constraint('products_fk_category', 'products', type_='foreignkey')
    op.drop_constraint('products_fk_family', 'products', type_='foreignkey')
    op.drop_constraint('products_fk_report_code', 'products', type_='foreignkey')
    op.drop_constraint('products_fk_brand', 'products', type_='foreignkey')
    op.drop_constraint('products_regular_price_uuid_fkey', 'products', type_='foreignkey')
    op.drop_constraint('products_current_price_uuid_fkey', 'products', type_='foreignkey')
    op.drop_index('products_ix_upc', 'products')
    op.drop_constraint('product_codes_fk_product', 'product_codes', type_='foreignkey')
    op.drop_constraint('product_costs_fk_vendor', 'product_costs', type_='foreignkey')
    op.drop_constraint('product_costs_fk_product', 'product_costs', type_='foreignkey')
    op.drop_constraint('product_prices_fk_product', 'product_prices', type_='foreignkey')
    op.drop_constraint('batch_columns_fk_batch', 'batch_columns', type_='foreignkey')

    # Rename all tables.
    op.rename_table('settings', 'setting')
    op.rename_table('changes', 'change')
    op.rename_table('phone_numbers', 'phone')
    op.rename_table('email_addresses', 'email')
    op.rename_table('people', 'person')
    op.rename_table('roles', 'role')
    op.rename_table('permissions', 'permission')
    op.rename_table('users', 'user')
    op.rename_table('users_roles', 'user_x_role')
    op.rename_table('stores', 'store')
    op.rename_table('employees', 'employee')
    op.rename_table('customer_groups', 'customer_group')
    op.rename_table('customers', 'customer')
    op.rename_table('customers_groups', 'customer_x_group')
    op.rename_table('customers_people', 'customer_x_person')
    op.rename_table('vendors', 'vendor')
    op.rename_table('vendor_contacts', 'vendor_contact')
    op.rename_table('departments', 'department')
    op.rename_table('subdepartments', 'subdepartment')
    op.rename_table('categories', 'category')
    op.rename_table('families', 'family')
    op.rename_table('report_codes', 'report_code')
    op.rename_table('brands', 'brand')
    op.rename_table('products', 'product')
    op.rename_table('product_codes', 'product_code')
    op.rename_table('product_costs', 'product_cost')
    op.rename_table('product_prices', 'product_price')
    op.rename_table('batches', 'batch')
    op.rename_table('batch_columns', 'batch_column')
    op.rename_table('label_profiles', 'label_profile')

    # Recreate all constraints.
    op.create_unique_constraint('role_uq_name', 'role', ['name'])
    op.create_foreign_key('permission_fk_role', 'permission', 'role', ['role_uuid'], ['uuid'])
    op.create_foreign_key('user_fk_person', 'user', 'person', ['person_uuid'], ['uuid'])
    op.create_unique_constraint('user_uq_username', 'user', ['username'])
    op.create_foreign_key('user_x_role_fk_role', 'user_x_role', 'role', ['role_uuid'], ['uuid'])
    op.create_foreign_key('user_x_role_fk_user', 'user_x_role', 'user', ['user_uuid'], ['uuid'])
    op.create_foreign_key('employee_fk_person', 'employee', 'person', ['person_uuid'], ['uuid'])
    op.create_foreign_key('customer_x_group_fk_group', 'customer_x_group', 'customer_group', ['group_uuid'], ['uuid'])
    op.create_foreign_key('customer_x_group_fk_customer', 'customer_x_group', 'customer', ['customer_uuid'], ['uuid'])
    op.create_foreign_key('customer_x_person_fk_customer', 'customer_x_person', 'customer', ['customer_uuid'], ['uuid'])
    op.create_foreign_key('customer_x_person_fk_person', 'customer_x_person', 'person', ['person_uuid'], ['uuid'])
    op.create_unique_constraint('vendor_uq_id', 'vendor', ['id'])
    op.create_foreign_key('vendor_contact_fk_vendor', 'vendor_contact', 'vendor', ['vendor_uuid'], ['uuid'])
    op.create_foreign_key('vendor_contact_fk_person', 'vendor_contact', 'person', ['person_uuid'], ['uuid'])
    op.create_foreign_key('category_fk_department', 'category', 'department', ['department_uuid'], ['uuid'])
    op.create_unique_constraint('report_code_uq_code', 'report_code', ['code'])
    op.create_foreign_key('product_fk_department', 'product', 'department', ['department_uuid'], ['uuid'])
    op.create_foreign_key('product_fk_subdepartment', 'product', 'subdepartment', ['subdepartment_uuid'], ['uuid'])
    op.create_foreign_key('product_fk_category', 'product', 'category', ['category_uuid'], ['uuid'])
    op.create_foreign_key('product_fk_family', 'product', 'family', ['family_uuid'], ['uuid'])
    op.create_foreign_key('product_fk_report_code', 'product', 'report_code', ['report_code_uuid'], ['uuid'])
    op.create_foreign_key('product_fk_brand', 'product', 'brand', ['brand_uuid'], ['uuid'])
    op.create_foreign_key('product_fk_regular_price', 'product', 'product_price', ['regular_price_uuid'], ['uuid'])
    op.create_foreign_key('product_fk_current_price', 'product', 'product_price', ['current_price_uuid'], ['uuid'])
    op.create_index('product_ix_upc', 'product', ['upc'])
    op.create_foreign_key('product_code_fk_product', 'product_code', 'product', ['product_uuid'], ['uuid'])
    op.create_foreign_key('product_cost_fk_vendor', 'product_cost', 'vendor', ['vendor_uuid'], ['uuid'])
    op.create_foreign_key('product_cost_fk_product', 'product_cost', 'product', ['product_uuid'], ['uuid'])
    op.create_foreign_key('product_price_fk_product', 'product_price', 'product', ['product_uuid'], ['uuid'])
    op.create_foreign_key('batch_column_fk_batch', 'batch_column', 'batch', ['batch_uuid'], ['uuid'])


def downgrade():

    # drop all constraints which will be changing.
    op.drop_constraint('role_uq_name', 'role', type_='unique')
    op.drop_constraint('permission_fk_role', 'permission', type_='foreignkey')
    op.drop_constraint('user_fk_person', 'user', type_='foreignkey')
    op.drop_constraint('user_uq_username', 'user', type_='unique')
    op.drop_constraint('user_x_role_fk_role', 'user_x_role', type_='foreignkey')
    op.drop_constraint('user_x_role_fk_user', 'user_x_role', type_='foreignkey')
    op.drop_constraint('employee_fk_person', 'employee', type_='foreignkey')
    op.drop_constraint('customer_x_group_fk_group', 'customer_x_group', type_='foreignkey')
    op.drop_constraint('customer_x_group_fk_customer', 'customer_x_group', type_='foreignkey')
    op.drop_constraint('customer_x_person_fk_customer', 'customer_x_person', type_='foreignkey')
    op.drop_constraint('customer_x_person_fk_person', 'customer_x_person', type_='foreignkey')
    op.drop_constraint('vendor_uq_id', 'vendor', type_='unique')
    op.drop_constraint('vendor_contact_fk_vendor', 'vendor_contact', type_='foreignkey')
    op.drop_constraint('vendor_contact_fk_person', 'vendor_contact', type_='foreignkey')
    op.drop_constraint('category_fk_department', 'category', type_='foreignkey')
    op.drop_constraint('report_code_uq_code', 'report_code', type_='unique')
    op.drop_constraint('product_fk_department', 'product', type_='foreignkey')
    op.drop_constraint('product_fk_subdepartment', 'product', type_='foreignkey')
    op.drop_constraint('product_fk_category', 'product', type_='foreignkey')
    op.drop_constraint('product_fk_family', 'product', type_='foreignkey')
    op.drop_constraint('product_fk_report_code', 'product', type_='foreignkey')
    op.drop_constraint('product_fk_brand', 'product', type_='foreignkey')
    op.drop_constraint('product_fk_regular_price', 'product', type_='foreignkey')
    op.drop_constraint('product_fk_current_price', 'product', type_='foreignkey')
    op.drop_index('product_ix_upc', 'product')
    op.drop_constraint('product_code_fk_product', 'product_code', type_='foreignkey')
    op.drop_constraint('product_cost_fk_vendor', 'product_cost', type_='foreignkey')
    op.drop_constraint('product_cost_fk_product', 'product_cost', type_='foreignkey')
    op.drop_constraint('product_price_fk_product', 'product_price', type_='foreignkey')
    op.drop_constraint('batch_column_fk_batch', 'batch_column', type_='foreignkey')

    # Rename all tables.
    op.rename_table('setting', 'settings')
    op.rename_table('change', 'changes')
    op.rename_table('phone', 'phone_numbers')
    op.rename_table('email', 'email_addresses')
    op.rename_table('person', 'people')
    op.rename_table('role', 'roles')
    op.rename_table('permission', 'permissions')
    op.rename_table('user', 'users')
    op.rename_table('user_x_role', 'users_roles')
    op.rename_table('store', 'stores')
    op.rename_table('employee', 'employees')
    op.rename_table('customer_group', 'customer_groups')
    op.rename_table('customer', 'customers')
    op.rename_table('customer_x_group', 'customers_groups')
    op.rename_table('customer_x_person', 'customers_people')
    op.rename_table('vendor', 'vendors')
    op.rename_table('vendor_contact', 'vendor_contacts')
    op.rename_table('department', 'departments')
    op.rename_table('subdepartment', 'subdepartments')
    op.rename_table('category', 'categories')
    op.rename_table('family', 'families')
    op.rename_table('report_code', 'report_codes')
    op.rename_table('brand', 'brands')
    op.rename_table('product', 'products')
    op.rename_table('product_code', 'product_codes')
    op.rename_table('product_cost', 'product_costs')
    op.rename_table('product_price', 'product_prices')
    op.rename_table('batch', 'batches')
    op.rename_table('batch_column', 'batch_columns')
    op.rename_table('label_profile', 'label_profiles')

    # Recreate all constraints.
    op.create_unique_constraint('roles_uq_name', 'roles', ['name'])
    op.create_foreign_key('permissions_fk_role', 'permissions', 'roles', ['role_uuid'], ['uuid'])
    op.create_foreign_key('users_fk_person', 'users', 'people', ['person_uuid'], ['uuid'])
    op.create_unique_constraint('users_uq_username', 'users', ['username'])
    op.create_foreign_key('users_roles_fk_role', 'users_roles', 'roles', ['role_uuid'], ['uuid'])
    op.create_foreign_key('users_roles_fk_user', 'users_roles', 'users', ['user_uuid'], ['uuid'])
    op.create_foreign_key('employees_fk_person', 'employees', 'people', ['person_uuid'], ['uuid'])
    op.create_foreign_key('customers_groups_fk_group', 'customers_groups', 'customer_groups', ['group_uuid'], ['uuid'])
    op.create_foreign_key('customers_groups_fk_customer', 'customers_groups', 'customers', ['customer_uuid'], ['uuid'])
    op.create_foreign_key('customers_people_fk_customer', 'customers_people', 'customers', ['customer_uuid'], ['uuid'])
    op.create_foreign_key('customers_people_fk_person', 'customers_people', 'people', ['person_uuid'], ['uuid'])
    op.create_unique_constraint('vendor_uq_id', 'vendors', ['id'])
    op.create_foreign_key('vendor_contacts_fk_vendor', 'vendor_contacts', 'vendors', ['vendor_uuid'], ['uuid'])
    op.create_foreign_key('vendor_contacts_fk_person', 'vendor_contacts', 'people', ['person_uuid'], ['uuid'])
    op.create_foreign_key('categories_fk_department', 'categories', 'departments', ['department_uuid'], ['uuid'])
    op.create_unique_constraint('report_codes_uq_code', 'report_codes', ['code'])
    op.create_foreign_key('products_fk_department', 'products', 'departments', ['department_uuid'], ['uuid'])
    op.create_foreign_key('products_fk_subdepartment', 'products', 'subdepartments', ['subdepartment_uuid'], ['uuid'])
    op.create_foreign_key('products_fk_category', 'products', 'categories', ['category_uuid'], ['uuid'])
    op.create_foreign_key('products_fk_family', 'products', 'families', ['family_uuid'], ['uuid'])
    op.create_foreign_key('products_fk_report_code', 'products', 'report_codes', ['report_code_uuid'], ['uuid'])
    op.create_foreign_key('products_fk_brand', 'products', 'brands', ['brand_uuid'], ['uuid'])
    op.create_foreign_key('products_regular_price_uuid_fkey', 'products', 'product_prices', ['regular_price_uuid'], ['uuid'])
    op.create_foreign_key('products_current_price_uuid_fkey', 'products', 'product_prices', ['current_price_uuid'], ['uuid'])
    op.create_index('products_ix_upc', 'products', ['upc'])
    op.create_foreign_key('product_codes_fk_product', 'product_codes', 'products', ['product_uuid'], ['uuid'])
    op.create_foreign_key('product_costs_fk_vendor', 'product_costs', 'vendors', ['vendor_uuid'], ['uuid'])
    op.create_foreign_key('product_costs_fk_product', 'product_costs', 'products', ['product_uuid'], ['uuid'])
    op.create_foreign_key('product_prices_fk_product', 'product_prices', 'products', ['product_uuid'], ['uuid'])
    op.create_foreign_key('batch_columns_fk_batch', 'batch_columns', 'batches', ['batch_uuid'], ['uuid'])
