#-------------------------------------------------------------------------
# Name:        pySaliencyMapDefs
# Purpose:     Definitions for class pySaliencyMap
#
# Author:      Akisato Kimura <akisato@ieee.org>
#
# Created:     April 24, 2014
# Copyright:   (c) Akisato Kimura 2014-
# Licence:     MIT
# URL:         https://github.com/akisato-/pySaliencyMap
#-------------------------------------------------------------------------

# parameters for computing optical flows using the Gunner Farneback's algorithm
farne_pyr_scale = 0.5
farne_levels = 3
farne_winsize = 15
farne_iterations = 3
farne_poly_n = 5
farne_poly_sigma = 1.2
farne_flags = 0

# parameters for detecting local maxima
default_step_local = 16

# feature weights
weight_intensity = 0.30
weight_color = 0.30
weight_orientation = 0.20
weight_motion = 0.20

# coefficients of Gabor filters
GaborKernel_0 = [
    [1.85212E-06, 1.28181E-05, -0.000350433, -0.000136537,
        0.002010422, -0.000136537, -0.000350433, 1.28181E-05, 1.85212E-06],
    [2.80209E-05, 0.000193926, -0.005301717, -0.002065674,
        0.030415784, -0.002065674, -0.005301717, 0.000193926, 2.80209E-05],
    [0.000195076, 0.001350077, -0.036909595, -0.014380852,
        0.211749204, -0.014380852, -0.036909595, 0.001350077, 0.000195076],
    [0.000624940, 0.004325061, -0.118242318, -0.046070008,
        0.678352526, -0.046070008, -0.118242318, 0.004325061, 0.000624940],
    [0.000921261, 0.006375831, -0.174308068, -0.067914552,
        1.000000000, -0.067914552, -0.174308068, 0.006375831, 0.000921261],
    [0.000624940, 0.004325061, -0.118242318, -0.046070008,
        0.678352526, -0.046070008, -0.118242318, 0.004325061, 0.000624940],
    [0.000195076, 0.001350077, -0.036909595, -0.014380852,
        0.211749204, -0.014380852, -0.036909595, 0.001350077, 0.000195076],
    [2.80209E-05, 0.000193926, -0.005301717, -0.002065674,
        0.030415784, -0.002065674, -0.005301717, 0.000193926, 2.80209E-05],
    [1.85212E-06, 1.28181E-05, -0.000350433, -0.000136537,
        0.002010422, -0.000136537, -0.000350433, 1.28181E-05, 1.85212E-06]
]
GaborKernel_45 = [
    [4.04180E-06,  2.25320E-05, -0.000279806, -0.001028923,  3.79931E-05,
        0.000744712,  0.000132863, -9.04408E-06, -1.01551E-06],
    [2.25320E-05,  0.000925120,  0.002373205, -0.013561362, -0.022947700,
        0.000389916,  0.003516954,  0.000288732, -9.04408E-06],
    [-0.000279806,  0.002373205,  0.044837725,  0.052928748, -
        0.139178011, -0.108372072,  0.000847346,  0.003516954,  0.000132863],
    [-0.001028923, -0.013561362,  0.052928748,  0.460162150,
        0.249959607, -0.302454279, -0.108372072,  0.000389916,  0.000744712],
    [3.79931E-05, -0.022947700, -0.139178011,  0.249959607,  1.000000000,
        0.249959607, -0.139178011, -0.022947700,  3.79931E-05],
    [0.000744712,  0.003899160, -0.108372072, -0.302454279,  0.249959607,
        0.460162150,  0.052928748, -0.013561362, -0.001028923],
    [0.000132863,  0.003516954,  0.000847346, -0.108372072, -0.139178011,
        0.052928748,  0.044837725,  0.002373205, -0.000279806],
    [-9.04408E-06,  0.000288732,  0.003516954,  0.000389916, -
        0.022947700, -0.013561362,  0.002373205,  0.000925120,  2.25320E-05],
    [-1.01551E-06, -9.04408E-06,  0.000132863,  0.000744712,
        3.79931E-05, -0.001028923, -0.000279806,  2.25320E-05,  4.04180E-06]
]
GaborKernel_90 = [
    [1.85212E-06,  2.80209E-05,  0.000195076,  0.000624940,  0.000921261,
        0.000624940,  0.000195076,  2.80209E-05,  1.85212E-06],
    [1.28181E-05,  0.000193926,  0.001350077,  0.004325061,  0.006375831,
        0.004325061,  0.001350077,  0.000193926,  1.28181E-05],
    [-0.000350433, -0.005301717, -0.036909595, -0.118242318, -
        0.174308068, -0.118242318, -0.036909595, -0.005301717, -0.000350433],
    [-0.000136537, -0.002065674, -0.014380852, -0.046070008, -
        0.067914552, -0.046070008, -0.014380852, -0.002065674, -0.000136537],
    [0.002010422,  0.030415784,  0.211749204,  0.678352526,  1.000000000,
        0.678352526,  0.211749204,  0.030415784,  0.002010422],
    [-0.000136537, -0.002065674, -0.014380852, -0.046070008, -
        0.067914552, -0.046070008, -0.014380852, -0.002065674, -0.000136537],
    [-0.000350433, -0.005301717, -0.036909595, -0.118242318, -
        0.174308068, -0.118242318, -0.036909595, -0.005301717, -0.000350433],
    [1.28181E-05,  0.000193926,  0.001350077,  0.004325061,  0.006375831,
        0.004325061,  0.001350077,  0.000193926,  1.28181E-05],
    [1.85212E-06,  2.80209E-05,  0.000195076,  0.000624940,  0.000921261,
        0.000624940,  0.000195076,  2.80209E-05,  1.85212E-06]
]
GaborKernel_135 = [
    [-1.01551E-06, -9.04408E-06,  0.000132863,  0.000744712,
        3.79931E-05, -0.001028923, -0.000279806, 2.2532E-05, 4.0418E-06],
    [-9.04408E-06,  0.000288732,  0.003516954,  0.000389916, -
        0.022947700, -0.013561362, 0.002373205, 0.00092512, 2.2532E-05],
    [0.000132863,  0.003516954,  0.000847346, -0.108372072, -0.139178011,
        0.052928748, 0.044837725, 0.002373205, -0.000279806],
    [0.000744712,  0.000389916, -0.108372072, -0.302454279,
        0.249959607, 0.46016215, 0.052928748, -0.013561362, -0.001028923],
    [3.79931E-05, -0.022947700, -0.139178011,  0.249959607,
        1.000000000, 0.249959607, -0.139178011, -0.0229477, 3.79931E-05],
    [-0.001028923, -0.013561362,  0.052928748,  0.460162150,
        0.249959607, -0.302454279, -0.108372072, 0.000389916, 0.000744712],
    [-0.000279806,  0.002373205,  0.044837725,  0.052928748, -
        0.139178011, -0.108372072, 0.000847346, 0.003516954, 0.000132863],
    [2.25320E-05,  0.000925120,  0.002373205, -0.013561362, -0.022947700,
        0.000389916, 0.003516954, 0.000288732, -9.04408E-06],
    [4.04180E-06,  2.25320E-05, -0.000279806, -0.001028923,
        3.79931E-05, 0.000744712, 0.000132863, -9.04408E-06, -1.01551E-06]
]
