"""List of Reddit API endpoints known to aPRAW."""
from typing import Dict, Any, Union

BASE_URL = "https://oauth.reddit.com{}?{}"

API_PATH: Dict[str, str] = {
    "comment"              : "/r/{sub}/comments/{submission}/_/{id}",
    "compose"              : "/api/compose",
    "info"                 : "/api/info",
    "me_karma"             : "/api/v1/me/karma",
    "me"                   : "/api/v1/me",
    "mod_approve"          : "/api/approve",
    "mod_distinguish"      : "/api/distinguish",
    "mod_ignore_reports"   : "/api/ignore_reports",
    "mod_lock"             : "/api/lock",
    "mod_remove"           : "/api/remove",
    "mod_show_comment"     : "/api/show_comment",
    "mod_unignore_reports" : "/api/unignore_reports",
    "mod_unlock"           : "/api/unlock",
    "mod_sticky"           : "/api/set_subreddit_sticky",
    "moderated"            : "/user/{user}/moderated_subreddits",
    "modmail_conversation" : "/api/mod/conversations/{id}",
    "modmail_conversations": "/api/mod/conversations",
    "morechildren"         : "/api/morechildren",
    "post_delete"             : "/api/del",
    "post_hide"            : "/api/hide",
    "post_marknsfw"        : "/api/marknsfw",
    "post_save"            : "/api/save",
    "post_spoiler"         : "/api/spoiler",
    "post_unhide"          : "/api/unhide",
    "post_unmarknsfw"      : "/api/unmarknsfw",
    "post_unsave"          : "/api/unsave",
    "post_unspoiler"       : "/api/unspoiler",
    "post_vote"            : "/api/vote",
    "submission"           : "/r/{sub}/comments/{id}",
    "subreddit_about"      : "/r/{sub}/about",
    "subreddit_comments"   : "/r/{sub}/comments",
    "subreddit_edited"     : "/r/{sub}/about/edited",
    "subreddit_hot"        : "/r/{sub}/hot",
    "subreddit_log"        : "/r/{sub}/about/log",
    "subreddit_moderators" : "/r/{sub}/about/moderators",
    "subreddit_modqueue"   : "/r/{sub}/about/modqueue",
    "subreddit_new"        : "/r/{sub}/new",
    "subreddit_reports"    : "/r/{sub}/about/reports",
    "subreddit_rising"     : "/r/{sub}/rising",
    "subreddit_spam"       : "/r/{sub}/about/spam",
    "subreddit_top"        : "/r/{sub}/top",
    "subreddit_unmoderated": "/r/{sub}/about/unmoderated",
    "subreddit"            : "/r/{sub}",
    "subreddits_new"       : "/subreddits/new",
    "user_about"           : "/user/{user}/about",
    "user_comments"        : "/user/{user}/comments",
    "user_submissions"     : "/user/{user}/submitted",
    "wiki_alloweditor"     : "/r/{sub}/api/wiki/alloweditor/{act}",
    "wiki_edit"            : "/r/{sub}/api/wiki/edit",
    "wiki_hide"            : "/r/{sub}/api/wiki/hide",
    "wiki_page_revisions"  : "/r/{sub}/wiki/revisions/{page}",
    "wiki_page"            : "/r/{sub}/wiki/{page}",
    "wiki_revert"          : "/r/{sub}/api/wiki/revert",
    "wiki_revisions"       : "/r/{sub}/wiki/revisions",
    "wiki"                 : "/r/{sub}/wiki/pages"
}
