# -*- coding: utf-8 -*-
"""
Autogenerated IBEISController functions

TemplateInfo:
    autogen_time = 11:34:25 2016/01/05
    autogen_key = annotmatch

ToRegenerate:
    python -m wbia.templates.template_generator --key annotmatch --Tcfg with_web_api=False with_api_cache=False with_deleters=True no_extern_deleters=True --diff
    python -m wbia.templates.template_generator --key annotmatch --Tcfg with_web_api=False with_api_cache=False with_deleters=True no_extern_deleters=True --write
"""
import logging
import functools  # NOQA
from wbia import constants as const
import utool as ut
from wbia.control import controller_inject
from wbia.control import accessor_decors  # NOQA

print, rrr, profile = ut.inject2(__name__)
logger = logging.getLogger('wbia')

# Create dectorator to inject functions in this module into the IBEISController
CLASS_INJECT_KEY, register_ibs_method = controller_inject.make_ibs_register_decorator(
    __name__
)


register_api = controller_inject.get_wbia_flask_api(__name__)


def testdata_annotmatch(defaultdb='testdb1'):
    import wbia

    ibs = wbia.opendb(defaultdb=defaultdb)
    config2_ = None  # qreq_.qparams
    return ibs, config2_


ANNOTMATCH_CONFIDENCE = 'annotmatch_confidence'
ANNOTMATCH_POSIXTIME_MODIFIED = 'annotmatch_posixtime_modified'
ANNOTMATCH_REVIEWER = 'annotmatch_reviewer'
ANNOTMATCH_ROWID = 'annotmatch_rowid'
ANNOTMATCH_TAG_TEXT = 'annotmatch_tag_text'
ANNOTMATCH_EVIDENCE_DECISION = 'annotmatch_evidence_decision'
ANNOTMATCH_META_DECISION = 'annotmatch_meta_decision'
ANNOTMATCH_COUNT = 'annotmatch_count'
ANNOT_ROWID1 = 'annot_rowid1'
ANNOT_ROWID2 = 'annot_rowid2'


# FIXME: finish rename
# ANNOTMATCH_TRUTH              = ANNOTMATCH_EVIDENCE_DECISION


@register_ibs_method
def _get_all_annotmatch_rowids(ibs):
    r"""all_annotmatch_rowids <- annotmatch.get_all_rowids()

    Returns:
        list_ (list): unfiltered annotmatch_rowids

    TemplateInfo:
        Tider_all_rowids
        tbl = annotmatch

    Example:
        >>> # ENABLE_DOCTEST
        >>> from wbia.control.manual_annotmatch_funcs import *  # NOQA
        >>> ibs, config2_ = testdata_annotmatch()
        >>> ibs._get_all_annotmatch_rowids()
    """
    all_annotmatch_rowids = ibs.db.get_all_rowids(const.ANNOTMATCH_TABLE)
    return all_annotmatch_rowids


@register_ibs_method
@register_api('/api/match/', methods=['POST'])
def add_annotmatch(
    ibs,
    aid1_list,
    aid2_list,
    annotmatch_evidence_decision_list=None,
    annotmatch_meta_decision_list=None,
    annotmatch_confidence_list=None,
    annotmatch_tag_text_list=None,
    annotmatch_reviewer_list=None,
    annotmatch_posixtime_modified_list=None,
    anotmatch_count_list=None,
):
    r"""
    Returns:
        returns annotmatch_rowid_list of added (or already existing annotmatchs)

    TemplateInfo:
        Tadder_native
        tbl = annotmatch
    """
    n_input = len(aid1_list)
    # Rectify inputs
    if annotmatch_evidence_decision_list is None:
        annotmatch_evidence_decision_list = [None] * n_input
    if annotmatch_meta_decision_list is None:
        annotmatch_meta_decision_list = [None] * n_input
    if annotmatch_confidence_list is None:
        annotmatch_confidence_list = [None] * n_input
    if annotmatch_tag_text_list is None:
        annotmatch_tag_text_list = [None] * n_input
    if annotmatch_reviewer_list is None:
        annotmatch_reviewer_list = [None] * n_input
    if annotmatch_posixtime_modified_list is None:
        annotmatch_posixtime_modified_list = [None] * n_input
    if anotmatch_count_list is None:
        anotmatch_count_list = [0] * n_input
    # Associate input lists with columns
    cols_to_lists = [
        (ANNOT_ROWID1, aid1_list),
        (ANNOT_ROWID2, aid2_list),
        (ANNOTMATCH_EVIDENCE_DECISION, annotmatch_evidence_decision_list),
        (ANNOTMATCH_META_DECISION, annotmatch_meta_decision_list),
        (ANNOTMATCH_CONFIDENCE, annotmatch_confidence_list),
        (ANNOTMATCH_TAG_TEXT, annotmatch_tag_text_list),
        (ANNOTMATCH_REVIEWER, annotmatch_reviewer_list),
        (ANNOTMATCH_POSIXTIME_MODIFIED, annotmatch_posixtime_modified_list),
        (ANNOTMATCH_COUNT, anotmatch_count_list),
    ]
    colnames = ut.take_column(cols_to_lists, 0)
    params_iter = zip(*ut.take_column(cols_to_lists, 1))

    get_rowid_from_superkey = ibs.get_annotmatch_rowid_from_superkey
    # FIXME: encode superkey paramx
    superkey_paramx = (0, 1)
    annotmatch_rowid_list = ibs.db.add_cleanly(
        const.ANNOTMATCH_TABLE,
        colnames,
        params_iter,
        get_rowid_from_superkey,
        superkey_paramx,
    )
    return annotmatch_rowid_list


@register_ibs_method
def delete_annotmatch(ibs, annotmatch_rowid_list):
    r"""annotmatch.delete(annotmatch_rowid_list)

    delete annotmatch rows

    Args:
        annotmatch_rowid_list

    Returns:
        int: num_deleted

    TemplateInfo:
        Tdeleter_native_tbl
        tbl = annotmatch

    Example:
        >>> # DISABLE_DOCTEST
        >>> from wbia.control.manual_annotmatch_funcs import *  # NOQA
        >>> ibs, config2_ = testdata_annotmatch()
        >>> annotmatch_rowid_list = ibs._get_all_annotmatch_rowids()[:2]
        >>> num_deleted = ibs.delete_annotmatch(annotmatch_rowid_list)
        >>> print('num_deleted = %r' % (num_deleted,))
    """
    # from wbia.algo.preproc import preproc_annotmatch
    # NO EXTERN IMPORT
    if ut.VERBOSE:
        logger.info('[ibs] deleting %d annotmatch rows' % len(annotmatch_rowid_list))
    # Prepare: Delete externally stored data (if any)
    # preproc_annotmatch.on_delete(ibs, annotmatch_rowid_list, config2_=config2_)
    # NO EXTERN DELETE
    # Finalize: Delete self
    ibs.db.delete_rowids(const.ANNOTMATCH_TABLE, annotmatch_rowid_list)
    num_deleted = len(ut.filter_Nones(annotmatch_rowid_list))
    return num_deleted


@register_ibs_method
@accessor_decors.getter_1to1
def get_annotmatch_aid1(ibs, annotmatch_rowid_list, eager=True, nInput=None):
    r"""aid1_list <- annotmatch.aid1[annotmatch_rowid_list]

    gets data from the "native" column "aid1" in the "annotmatch" table

    Args:
        annotmatch_rowid_list (list):

    Returns:
        list: aid1_list

    TemplateInfo:
        Tgetter_table_column
        col = aid1
        tbl = annotmatch

    Example:
        >>> # ENABLE_DOCTEST
        >>> from wbia.control.manual_annotmatch_funcs import *  # NOQA
        >>> ibs, config2_ = testdata_annotmatch()
        >>> annotmatch_rowid_list = ibs._get_all_annotmatch_rowids()
        >>> eager = True
        >>> aid1_list = ibs.get_annotmatch_aid1(annotmatch_rowid_list, eager=eager)
        >>> assert len(annotmatch_rowid_list) == len(aid1_list)
    """
    id_iter = annotmatch_rowid_list
    colnames = (ANNOT_ROWID1,)
    aid1_list = ibs.db.get(
        const.ANNOTMATCH_TABLE,
        colnames,
        id_iter,
        id_colname='rowid',
        eager=eager,
        nInput=nInput,
    )
    return aid1_list


@register_ibs_method
@accessor_decors.getter_1to1
def get_annotmatch_aid2(ibs, annotmatch_rowid_list, eager=True, nInput=None):
    r"""aid2_list <- annotmatch.aid2[annotmatch_rowid_list]

    gets data from the "native" column "aid2" in the "annotmatch" table

    Args:
        annotmatch_rowid_list (list):

    Returns:
        list: aid2_list

    TemplateInfo:
        Tgetter_table_column
        col = aid2
        tbl = annotmatch

    Example:
        >>> # ENABLE_DOCTEST
        >>> from wbia.control.manual_annotmatch_funcs import *  # NOQA
        >>> ibs, config2_ = testdata_annotmatch()
        >>> annotmatch_rowid_list = ibs._get_all_annotmatch_rowids()
        >>> eager = True
        >>> aid2_list = ibs.get_annotmatch_aid2(annotmatch_rowid_list, eager=eager)
        >>> assert len(annotmatch_rowid_list) == len(aid2_list)
    """
    id_iter = annotmatch_rowid_list
    colnames = (ANNOT_ROWID2,)
    aid2_list = ibs.db.get(
        const.ANNOTMATCH_TABLE,
        colnames,
        id_iter,
        id_colname='rowid',
        eager=eager,
        nInput=nInput,
    )
    return aid2_list


@register_ibs_method
@accessor_decors.getter_1to1
def get_annotmatch_confidence(ibs, annotmatch_rowid_list, eager=True, nInput=None):
    r"""annotmatch_confidence_list <- annotmatch.annotmatch_confidence[annotmatch_rowid_list]

    gets data from the "native" column "annotmatch_confidence" in the "annotmatch" table

    Args:
        annotmatch_rowid_list (list):

    Returns:
        list: annotmatch_confidence_list

    TemplateInfo:
        Tgetter_table_column
        col = annotmatch_confidence
        tbl = annotmatch

    Example:
        >>> # ENABLE_DOCTEST
        >>> from wbia.control.manual_annotmatch_funcs import *  # NOQA
        >>> ibs, config2_ = testdata_annotmatch()
        >>> annotmatch_rowid_list = ibs._get_all_annotmatch_rowids()
        >>> eager = True
        >>> annotmatch_confidence_list = ibs.get_annotmatch_confidence(annotmatch_rowid_list, eager=eager)
        >>> assert len(annotmatch_rowid_list) == len(annotmatch_confidence_list)
    """
    id_iter = annotmatch_rowid_list
    colnames = (ANNOTMATCH_CONFIDENCE,)
    annotmatch_confidence_list = ibs.db.get(
        const.ANNOTMATCH_TABLE,
        colnames,
        id_iter,
        id_colname='rowid',
        eager=eager,
        nInput=nInput,
    )
    return annotmatch_confidence_list


@register_ibs_method
@accessor_decors.getter_1to1
def get_annotmatch_posixtime_modified(
    ibs, annotmatch_rowid_list, eager=True, nInput=None
):
    r"""annotmatch_posixtime_modified_list <- annotmatch.annotmatch_posixtime_modified[annotmatch_rowid_list]

    gets data from the "native" column "annotmatch_posixtime_modified" in the "annotmatch" table

    Args:
        annotmatch_rowid_list (list):

    Returns:
        list: annotmatch_posixtime_modified_list

    TemplateInfo:
        Tgetter_table_column
        col = annotmatch_posixtime_modified
        tbl = annotmatch

    Example:
        >>> # ENABLE_DOCTEST
        >>> from wbia.control.manual_annotmatch_funcs import *  # NOQA
        >>> ibs, config2_ = testdata_annotmatch()
        >>> annotmatch_rowid_list = ibs._get_all_annotmatch_rowids()
        >>> eager = True
        >>> annotmatch_posixtime_modified_list = ibs.get_annotmatch_posixtime_modified(annotmatch_rowid_list, eager=eager)
        >>> assert len(annotmatch_rowid_list) == len(annotmatch_posixtime_modified_list)
    """
    id_iter = annotmatch_rowid_list
    colnames = (ANNOTMATCH_POSIXTIME_MODIFIED,)
    annotmatch_posixtime_modified_list = ibs.db.get(
        const.ANNOTMATCH_TABLE,
        colnames,
        id_iter,
        id_colname='rowid',
        eager=eager,
        nInput=nInput,
    )
    return annotmatch_posixtime_modified_list


@register_ibs_method
@accessor_decors.getter_1to1
def get_annotmatch_reviewer(ibs, annotmatch_rowid_list, eager=True, nInput=None):
    r"""annotmatch_reviewer_list <- annotmatch.annotmatch_reviewer[annotmatch_rowid_list]

    gets data from the "native" column "annotmatch_reviewer" in the "annotmatch" table

    Args:
        annotmatch_rowid_list (list):

    Returns:
        list: annotmatch_reviewer_list

    TemplateInfo:
        Tgetter_table_column
        col = annotmatch_reviewer
        tbl = annotmatch

    Example:
        >>> # ENABLE_DOCTEST
        >>> from wbia.control.manual_annotmatch_funcs import *  # NOQA
        >>> ibs, config2_ = testdata_annotmatch()
        >>> annotmatch_rowid_list = ibs._get_all_annotmatch_rowids()
        >>> eager = True
        >>> annotmatch_reviewer_list = ibs.get_annotmatch_reviewer(annotmatch_rowid_list, eager=eager)
        >>> assert len(annotmatch_rowid_list) == len(annotmatch_reviewer_list)
    """
    id_iter = annotmatch_rowid_list
    colnames = (ANNOTMATCH_REVIEWER,)
    annotmatch_reviewer_list = ibs.db.get(
        const.ANNOTMATCH_TABLE,
        colnames,
        id_iter,
        id_colname='rowid',
        eager=eager,
        nInput=nInput,
    )
    return annotmatch_reviewer_list


@register_ibs_method
@accessor_decors.getter_1to1
def get_annotmatch_rowid(ibs, annotmatch_rowid_list, eager=True, nInput=None):
    r"""annotmatch_rowid_list <- annotmatch.annotmatch_rowid[annotmatch_rowid_list]

    gets data from the "native" column "annotmatch_rowid" in the "annotmatch" table

    Args:
        annotmatch_rowid_list (list):

    Returns:
        list: annotmatch_rowid_list

    TemplateInfo:
        Tgetter_table_column
        col = annotmatch_rowid
        tbl = annotmatch

    Example:
        >>> # ENABLE_DOCTEST
        >>> from wbia.control.manual_annotmatch_funcs import *  # NOQA
        >>> ibs, config2_ = testdata_annotmatch()
        >>> annotmatch_rowid_list = ibs._get_all_annotmatch_rowids()
        >>> eager = True
        >>> annotmatch_rowid_list = ibs.get_annotmatch_rowid(annotmatch_rowid_list, eager=eager)
        >>> assert len(annotmatch_rowid_list) == len(annotmatch_rowid_list)
    """
    id_iter = annotmatch_rowid_list
    colnames = (ANNOTMATCH_ROWID,)
    annotmatch_rowid_list = ibs.db.get(
        const.ANNOTMATCH_TABLE,
        colnames,
        id_iter,
        id_colname='rowid',
        eager=eager,
        nInput=nInput,
    )
    return annotmatch_rowid_list


@register_ibs_method
def get_annotmatch_rowid_from_superkey(
    ibs, aid1_list, aid2_list, eager=True, nInput=None
):
    r"""annotmatch_rowid_list <- annotmatch[aid1_list, aid2_list]

    Args:
        superkey lists: aid1_list, aid2_list

    Returns:
        annotmatch_rowid_list

    TemplateInfo:
        Tgetter_native_rowid_from_superkey
        tbl = annotmatch
    """
    colnames = (ANNOTMATCH_ROWID,)
    # FIXME: col_rowid is not correct
    params_iter = zip(aid1_list, aid2_list)
    andwhere_colnames = [ANNOT_ROWID1, ANNOT_ROWID2]
    annotmatch_rowid_list = ibs.db.get_where_eq(
        const.ANNOTMATCH_TABLE,
        colnames,
        params_iter,
        andwhere_colnames,
        eager=eager,
        nInput=nInput,
    )
    return annotmatch_rowid_list


@register_ibs_method
@accessor_decors.getter_1to1
def get_annotmatch_tag_text(ibs, annotmatch_rowid_list, eager=True, nInput=None):
    r"""annotmatch_tag_text_list <- annotmatch.annotmatch_tag_text[annotmatch_rowid_list]

    gets data from the "native" column "annotmatch_tag_text" in the "annotmatch" table

    Args:
        annotmatch_rowid_list (list):

    Returns:
        list: annotmatch_tag_text_list

    TemplateInfo:
        Tgetter_table_column
        col = annotmatch_tag_text
        tbl = annotmatch

    Example:
        >>> # ENABLE_DOCTEST
        >>> from wbia.control.manual_annotmatch_funcs import *  # NOQA
        >>> ibs, config2_ = testdata_annotmatch()
        >>> annotmatch_rowid_list = ibs._get_all_annotmatch_rowids()
        >>> eager = True
        >>> annotmatch_tag_text_list = ibs.get_annotmatch_tag_text(annotmatch_rowid_list, eager=eager)
        >>> assert len(annotmatch_rowid_list) == len(annotmatch_tag_text_list)
    """
    id_iter = annotmatch_rowid_list
    colnames = (ANNOTMATCH_TAG_TEXT,)
    annotmatch_tag_text_list = ibs.db.get(
        const.ANNOTMATCH_TABLE,
        colnames,
        id_iter,
        id_colname='rowid',
        eager=eager,
        nInput=nInput,
    )
    return annotmatch_tag_text_list


@register_ibs_method
@accessor_decors.getter_1to1
def get_annotmatch_evidence_decision(ibs, annotmatch_rowid_list, eager=True, nInput=None):
    r"""

    gets data from the "native" column "annotmatch_evidence_decision" in the "annotmatch" table

    Args:
        annotmatch_rowid_list (list):

    Returns:
        list: annotmatch_evidence_decision_list

    TemplateInfo:
        Tgetter_table_column
        col = annotmatch_evidence_decision
        tbl = annotmatch

    Example:
        >>> # ENABLE_DOCTEST
        >>> from wbia.control.manual_annotmatch_funcs import *  # NOQA
        >>> ibs, config2_ = testdata_annotmatch()
        >>> annotmatch_rowid_list = ibs._get_all_annotmatch_rowids()
        >>> eager = True
        >>> decisions = ibs.get_annotmatch_evidence_decision(annotmatch_rowid_list, eager=eager)
        >>> assert len(annotmatch_rowid_list) == len(decisions)
    """
    id_iter = annotmatch_rowid_list
    colnames = (ANNOTMATCH_EVIDENCE_DECISION,)
    annotmatch_evidence_decision_list = ibs.db.get(
        const.ANNOTMATCH_TABLE,
        colnames,
        id_iter,
        id_colname='rowid',
        eager=eager,
        nInput=nInput,
    )
    return annotmatch_evidence_decision_list


@register_ibs_method
@accessor_decors.getter_1to1
def get_annotmatch_meta_decision(ibs, annotmatch_rowid_list, eager=True, nInput=None):
    id_iter = annotmatch_rowid_list
    colnames = (ANNOTMATCH_META_DECISION,)
    annotmatch_evidence_decision_list = ibs.db.get(
        const.ANNOTMATCH_TABLE,
        colnames,
        id_iter,
        id_colname='rowid',
        eager=eager,
        nInput=nInput,
    )
    return annotmatch_evidence_decision_list


@register_ibs_method
@accessor_decors.getter_1to1
def get_annotmatch_count(ibs, annotmatch_rowid_list, eager=True, nInput=None):
    id_iter = annotmatch_rowid_list
    colnames = (ANNOTMATCH_COUNT,)
    return ibs.db.get(
        const.ANNOTMATCH_TABLE,
        colnames,
        id_iter,
        id_colname='rowid',
        eager=eager,
        nInput=nInput,
    )


@register_ibs_method
@accessor_decors.setter
@register_api('/api/match/confidence/', methods=['PUT'])
def set_annotmatch_confidence(
    ibs, annotmatch_rowid_list, annotmatch_confidence_list, duplicate_behavior='error'
):
    r"""annotmatch_confidence_list -> annotmatch.annotmatch_confidence[annotmatch_rowid_list]

    Args:
        annotmatch_rowid_list
        annotmatch_confidence_list

    TemplateInfo:
        Tsetter_native_column
        tbl = annotmatch
        col = annotmatch_confidence
    """
    id_iter = annotmatch_rowid_list
    ibs.db.set(
        const.ANNOTMATCH_TABLE,
        (ANNOTMATCH_CONFIDENCE,),
        annotmatch_confidence_list,
        id_iter,
        duplicate_behavior=duplicate_behavior,
    )


@register_ibs_method
@accessor_decors.setter
def set_annotmatch_posixtime_modified(
    ibs,
    annotmatch_rowid_list,
    annotmatch_posixtime_modified_list,
    duplicate_behavior='error',
):
    r"""annotmatch_posixtime_modified_list -> annotmatch.annotmatch_posixtime_modified[annotmatch_rowid_list]

    Args:
        annotmatch_rowid_list
        annotmatch_posixtime_modified_list

    TemplateInfo:
        Tsetter_native_column
        tbl = annotmatch
        col = annotmatch_posixtime_modified
    """
    id_iter = annotmatch_rowid_list
    colnames = (ANNOTMATCH_POSIXTIME_MODIFIED,)
    ibs.db.set(
        const.ANNOTMATCH_TABLE,
        colnames,
        annotmatch_posixtime_modified_list,
        id_iter,
        duplicate_behavior=duplicate_behavior,
    )


@register_ibs_method
@accessor_decors.setter
@register_api('/api/match/user/', methods=['PUT'])
def set_annotmatch_reviewer(
    ibs, annotmatch_rowid_list, annotmatch_reviewer_list, duplicate_behavior='error'
):
    r"""annotmatch_reviewer_list -> annotmatch.annotmatch_reviewer[annotmatch_rowid_list]

    Args:
        annotmatch_rowid_list
        annotmatch_reviewer_list

    TemplateInfo:
        Tsetter_native_column
        tbl = annotmatch
        col = annotmatch_reviewer
    """
    id_iter = annotmatch_rowid_list
    colnames = (ANNOTMATCH_REVIEWER,)
    ibs.db.set(
        const.ANNOTMATCH_TABLE,
        colnames,
        annotmatch_reviewer_list,
        id_iter,
        duplicate_behavior=duplicate_behavior,
    )


@register_ibs_method
@accessor_decors.setter
@register_api('/api/match/tags/', methods=['PUT'], __api_plural_check__=False)
def set_annotmatch_tag_text(
    ibs, annotmatch_rowid_list, annotmatch_tag_text_list, duplicate_behavior='error'
):
    r"""annotmatch_tag_text_list -> annotmatch.annotmatch_tag_text[annotmatch_rowid_list]

    Args:
        annotmatch_rowid_list
        annotmatch_tag_text_list

    TemplateInfo:
        Tsetter_native_column
        tbl = annotmatch
        col = annotmatch_tag_text
    """
    id_iter = annotmatch_rowid_list
    colnames = (ANNOTMATCH_TAG_TEXT,)
    ibs.db.set(
        const.ANNOTMATCH_TABLE,
        colnames,
        annotmatch_tag_text_list,
        id_iter,
        duplicate_behavior=duplicate_behavior,
    )


@register_ibs_method
@accessor_decors.setter
@register_api('/api/match/decision/evidence/', methods=['PUT'])
def set_annotmatch_evidence_decision(
    ibs,
    annotmatch_rowid_list,
    annotmatch_evidence_decision_list,
    duplicate_behavior='error',
):
    id_iter = annotmatch_rowid_list
    colnames = (ANNOTMATCH_EVIDENCE_DECISION,)
    ibs.db.set(
        const.ANNOTMATCH_TABLE,
        colnames,
        annotmatch_evidence_decision_list,
        id_iter,
        duplicate_behavior=duplicate_behavior,
    )


@register_ibs_method
@accessor_decors.setter
@register_api('/api/match/decision/meta/', methods=['PUT'])
def set_annotmatch_meta_decision(
    ibs, annotmatch_rowid_list, annotmatch_meta_decision_list, duplicate_behavior='error'
):
    id_iter = annotmatch_rowid_list
    colnames = (ANNOTMATCH_META_DECISION,)
    ibs.db.set(
        const.ANNOTMATCH_TABLE,
        colnames,
        annotmatch_meta_decision_list,
        id_iter,
        duplicate_behavior=duplicate_behavior,
    )


@register_ibs_method
@accessor_decors.setter
@register_api('/api/match/count/', methods=['PUT'])
def set_annotmatch_count(
    ibs, annotmatch_rowid_list, annotmatch_count_list, duplicate_behavior='error'
):
    id_iter = annotmatch_rowid_list
    colnames = (ANNOTMATCH_COUNT,)
    ibs.db.set(
        const.ANNOTMATCH_TABLE,
        colnames,
        annotmatch_count_list,
        id_iter,
        duplicate_behavior=duplicate_behavior,
    )
