# Generated by Django 3.1.6 on 2021-02-01 05:51

from django.conf import settings
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('appointments', '0003_auto_20200226_0756'),
        ('projects', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='AttributeFilterSet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('filters', django.contrib.postgres.fields.jsonb.JSONField(default=dict)),
            ],
        ),
        migrations.CreateModel(
            name='ContactHistory',
            fields=[
                ('pseudonym', models.CharField(editable=False, max_length=64, primary_key=True, serialize=False)),
            ],
        ),
        migrations.CreateModel(
            name='Participation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('pseudonym', models.CharField(max_length=255, unique=True, verbose_name='Pseudonym')),
                ('status', models.PositiveSmallIntegerField(choices=[(0, 'Pending'), (1, 'Declined'), (2, 'Accepted'), (3, 'In progress'), (4, 'Canceled'), (5, 'Finished')], default=0, verbose_name='Status')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('attribute_filterset', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='participations', to='recruitment.attributefilterset')),
            ],
        ),
        migrations.CreateModel(
            name='SubjectGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=126)),
                ('description', models.TextField(blank=True, default='')),
                ('order', models.PositiveSmallIntegerField(blank=True, default=0)),
                ('project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='subject_groups', to='projects.project')),
            ],
        ),
        migrations.CreateModel(
            name='Recall',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('appointment', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='appointments.appointment')),
                ('participation', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='recall', to='recruitment.participation')),
            ],
        ),
        migrations.CreateModel(
            name='ContactHistoryItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.PositiveSmallIntegerField(choices=[(0, 'Not reached'), (1, 'Recall'), (2, 'Invited')], default=0, verbose_name='Status')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('contact_history', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='contact_history_items', to='recruitment.contacthistory')),
                ('creator', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL)),
                ('project', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='projects.project')),
            ],
        ),
        migrations.AddField(
            model_name='attributefilterset',
            name='subject_group',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='attribute_filtersets', to='recruitment.subjectgroup'),
        ),
    ]
