<?xml version="1.0" encoding="UTF-8"?>
<!--
======================================================================
	ISO 19115 and 19115-2 XML to HTML Stylesheet June 2011

	This is the XML Style sheet that displays metadata conforming to ISO 19115:2003(E) and ISO 19115-2:2009(E).  
	This stylesheet can be applied to ISO XML to generate ISO HTML that includes a Header that displays the title 
	of the resource as well as listing the main sections that the ISO metadata contains while linking to them. 

	This file was generated by Altova MapForce 2009sp1

	Authors:
	This is the result of a collaboration of the Metadata Transform Working Group. 
	For further information, please contact NOAA's National Coastal Data 
	Development Center (NCDDC).
				National Coastal Data Development Center
				Toll Free: 866.732.2382
				E-mail: ncddcmetadata@noaa.gov

	Distribution Liability:
		NOAA makes no warranty regarding these data, expressed or implied, 
		nor does the fact of distribution constitute such a warranty. NOAA, NESDIS, 
		NODC and NCDDC cannot assume liability for any damages caused by any 
		errors or omissions in these data, nor as a result of the failure of these data 
		to function on a particular system. These files were developed for opensource uses.
	
	Use Constraints:
		The user is responsible for the results of any application of these stylsheets for other than its
		intended purpose. These stylesheets cannot guarantee valid output. Please feel free to edit 
		stylesheet as needed for your organizations needs. 

	Revisions:
		20111109 (JLM) Edited stylesheet to allow the title header to display for service metadata (19119)
		20120329 (JLM) Updated some element names to display correctly. Aslo added combined FC view.

-->
<!-- Top level directives -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:gco="http://www.isotc211.org/2005/gco" xmlns:gmd="http://www.isotc211.org/2005/gmd" xmlns:srv="http://www.isotc211.org/2005/srv" xmlns:gml="http://www.opengis.net/gml" xmlns:gts="http://www.isotc211.org/2005/gts" xmlns:gmi="http://www.isotc211.org/2005/gmi" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xlink="http://www.w3.org/1999/xlink">
	<xsl:import href="printFormatted.xsl"/>
	<xsl:import href="printTextLines.xsl"/>
	<xsl:import href="displayElement.xsl"/>	
	<xsl:output method="html" indent="no"/>
	<!-- Global parameters -->
	<!-- 
  g-tag-translation-URI 
    This parameter specifies the URI of the external document
    containing the lookup table for the tag name translation. The
    default is the name of a file in the same directory as the
    stylesheet. Make sure this is a network accessible URI if
    delivering to a browser for translation.
-->
	<xsl:param name="g-tag-translation-URI" select="'elements-ISO.xml'"/>
	<xsl:param name="g-header-translation-URI" select="'headers-ISO.xml'"/>
	<!--
  g-indent-increment
    This parameter specifies the character string to be added before a
    label for each level of indentation. I.e. if you want each level
    indented by four spaces, then make this a four space character
    string. Set this to the empty string to forego indenting.
-->
	<xsl:param name="g-indent-increment" select="'  '"/>
	<!--
  g-fold-width
    This parameter specifies the maximum length of a line when
    word-wrapping lines. It must match the value specified in
    printTextLines.xsl.
-->
	<xsl:param name="g-fold-width" select="'120'"/>
	<!--
  g-text-field-handler
    This parameter specifies the handler to use for formatting text
    fields. The choices are 'fold' to fold lines at a maximum length
    and 'print-lines' to print lines with line breaks preserved as in
    the source XML document. If unspecified, or if an invalid choice
    is specified, 'print-lines' will be used.
  
  [OBSOLETE: replaced by printFormatted template]
-->
	<xsl:param name="g-text-field-handler" select="'print-lines'"/>
	<!-- Global variables -->
	<xsl:variable name="newline">
		<xsl:text>&#xA;</xsl:text>
	</xsl:variable>
	<!-- Get the g-tag-translation-URI (elements.xml) node-set just once.
    This should improve performance on large XML files.
    This also works around a memory-leak problem using JSTL \<x:transform xsltSystemId
    (the memory-leak may also be present in direct Transformer calls from Java).
    /// We see this in Xalan 2.6.0; is it fixed in 2.7.0 ?
-->
	<xsl:variable name="g-tag-translations" select="document($g-tag-translation-URI)"/>
	<xsl:variable name="g-header-translations" select="document($g-header-translation-URI)"/>
	<!-- Templates -->
	<xsl:template match="/">
		<html>
			<body>
					<font size="+3">
			        <xsl:element name="a">
					<xsl:attribute name="name">
					<xsl:value-of select="'title'" />
					</xsl:attribute>
						<xsl:value-of select="//gmd:identificationInfo/gmd:MD_DataIdentification/gmd:citation/gmd:CI_Citation/gmd:title/gco:CharacterString"/>
					</xsl:element>		
					</font>
					<font size="+3">
			        <xsl:element name="a">
					<xsl:attribute name="name">
					<xsl:value-of select="'title'" />
					</xsl:attribute>
						<xsl:value-of select="//gmd:identificationInfo/srv:SV_ServiceIdentification/gmd:citation/gmd:CI_Citation/gmd:title/gco:CharacterString"/>
					</xsl:element>		
					</font>
					<br></br>
					<br></br>
						<xsl:for-each select="./*/*">
							<xsl:variable name="transname" select="name()"/>
							<xsl:if test="contains($transname,'gmd:spatialRepresentationInfo') or contains($transname,'gmd:referenceSystemInfo') or contains($transname,'gmd:metadataExtensionInfo') or contains($transname,'gmd:identificationInfo') or contains($transname,'gmd:contentInfo') or contains($transname,'gmd:distributionInfo') or contains($transname,'gmd:dataQualityInfo') or contains($transname,'gmd:portrayalCatalogueInfo') or contains($transname,'gmd:metadataConstraints') or contains($transname,'gmd:applicationSchemaInfo') or contains($transname,'gmd:metadataMaintenance') or contains($transname,'gmd:metadataMaintenanceInfo') or contains($transname,'gmi:acquisitionInformation') or contains($transname,'gfc:FC_FeatureCatalogue')">
								<xsl:element name="a">
								<xsl:attribute name="href">
								<xsl:value-of select="'#'" /><xsl:value-of select="substring-after($transname,':')"/>
								</xsl:attribute>
									<span style="text-transform: capitalize;">
										<xsl:apply-templates select="child::title" mode="outIt"/>
									<xsl:value-of select="$g-header-translations/*/name[@tagname=$transname]"/>
									</span>
								</xsl:element>		
								<br></br>
							</xsl:if>
						</xsl:for-each>
				<hr></hr>
				<pre>
						<xsl:apply-templates select="*"/>
						<xsl:element name="a">
						<xsl:attribute name="href">
						<xsl:value-of select="'#title'" />
						</xsl:attribute>
						<div align="left">Return To Index</div>
						</xsl:element>		
				</pre>
			</body>
		</html>
	</xsl:template>
	<!--
  Apply to all elements. Determine whether it's a compound or text element
  and call the appropriate template.
-->
	<xsl:template match="*">
		<xsl:param name="indent" select="''"/>
		<xsl:param name="indent-increment" select="$g-indent-increment"/>
		<xsl:variable name="tagname" select="name()"/>
		<xsl:variable name="tag-longname" select="$g-tag-translations/*/name[@tagname=$tagname]"/>
		<xsl:variable name="tag-translation">
			<!-- Display long name if we can translate the tag, else just display the tag name itself -->
			<xsl:choose>
				<xsl:when test="$tag-longname">
					<xsl:value-of select="$tag-longname"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$tagname"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="output">
			<!-- do not output element names w/ gco namespaces -->
			<xsl:if test="not(contains($tag-translation, 'gco'))">
				<xsl:value-of select="concat($indent, $tag-translation, ': ')"/>
			</xsl:if>
		</xsl:variable>
		<xsl:if test="string-length(normalize-space($tag-translation)) &gt; 0">
				<xsl:choose>
					<xsl:when test="count(ancestor::*) = 1 ">
						<xsl:choose>
							<xsl:when test="contains($tagname,'gmd:spatialRepresentationInfo') or contains($tagname,'gmd:referenceSystemInfo') or contains($tagname,'gmd:metadataExtensionInfo') or contains($tagname,'gmd:identificationInfo') or contains($tagname,'gmd:contentInfo') or contains($tagname,'gmd:distributionInfo') or contains($tagname,'gmd:dataQualityInfo') or contains($tagname,'gmd:portrayalCatalogueInfo') or contains($tagname,'gmd:metadataConstraints') or contains($tagname,'gmd:applicationSchemaInfo') or contains($tagname,'gmd:metadataMaintenance') or contains($tagname,'gmd:metadataMaintenanceInfo') or contains($tagname,'gmi:acquisitionInformation') or contains($tagname,'gfc:FC_FeatureCatalogue')">
								<xsl:if test="(position()>1)">
									<xsl:element name="a">
									<xsl:attribute name="href">
									<xsl:value-of select="'#title'" />
									</xsl:attribute>
									<div align="left">Return To Index</div>
									</xsl:element>		
									<hr></hr>
								</xsl:if>
								<b>
									<xsl:element name="a">
									<xsl:attribute name="name">
									<xsl:value-of select="substring-after($tagname,':')"/>
									</xsl:attribute>
									<xsl:value-of select="$output"/>
									</xsl:element>
								</b>
							</xsl:when>
							<xsl:otherwise>
								<b>
									<xsl:value-of select="$output"/>
								</b>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<b>
							<xsl:value-of select="$output"/>
						</b>
					</xsl:otherwise>
				</xsl:choose>
		</xsl:if>
		<xsl:choose>
			<xsl:when test="*">
				<!-- This is a compound element (i.e., it has children) -->
				<xsl:choose>
					<xsl:when test="string-length(normalize-space($tag-translation)) &gt; 0">
						<xsl:call-template name="printAttributes"/>
						<!-- There is a tag translation -->
						<xsl:value-of select="$newline"/>
						<xsl:apply-templates select="*">
							<xsl:with-param name="indent" select="concat($indent, $indent-increment)"/>
						</xsl:apply-templates>
					</xsl:when>
					<xsl:otherwise>
						<!-- No tag translation -->
						<xsl:apply-templates select="*">
							<xsl:with-param name="indent" select="concat($indent, $indent-increment)"/>
						</xsl:apply-templates>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<!-- else a content element: display the text -->
			<xsl:otherwise>
				<xsl:call-template name="printAttributes"/>
				<!-- if tag name has gco namespace - do not add a new line-->
				<xsl:if test="not(contains($tag-translation,'gco'))">
					<xsl:value-of select="$newline"/>
				</xsl:if>
				<!-- Call the imported printFormatted template to print both
            preformatted text and word-wrapped paragraphs. 
            This will parse each line, and call back to the
            printFormattedLine and printParagraphLine templates
            in this file. -->
				<xsl:call-template name="printFormatted">
					<xsl:with-param name="elementContent">
						<!-- strip leading whitespace only from first line of text -->
						<xsl:call-template name="strip-leading-whitespace">
							<!-- display element attributes OR content (note: not all attributes are included for translation-->
							<xsl:with-param name="content" select="@codeListValue|@gco:nilReason|@indeterminatePosition|node()"/>
						</xsl:call-template>
					</xsl:with-param>
					<xsl:with-param name="startFormattedSectionString" select="''"/>
					<!-- nothing needed -->
					<xsl:with-param name="endFormattedSectionString" select="''"/>
					<!-- nothing needed -->
					<xsl:with-param name="optional-param-1" select="concat($indent, $indent-increment)"/>
					<xsl:with-param name="optional-param-2" select="number($g-fold-width) - string-length($indent)"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="printAttributes">
		<xsl:choose>
			<xsl:when test="./@*">
					<xsl:if test="./@uuid"> <xsl:value-of select="concat('uuid: ', @uuid)"/></xsl:if>
					<xsl:if test="./@uuidref"><xsl:value-of select="concat('uuidref: ', @uuidref)"/></xsl:if>
					<xsl:if test="./@uom"><xsl:value-of select="concat('uom: ', @uom)"/></xsl:if>
					<xsl:if test="./@xlink:href"> <xsl:value-of select="concat('xlink: ', @xlink:href)"/></xsl:if>
					<xsl:if test="./@xlink:title"><xsl:value-of select="concat(' title: ', @xlink:title)"/> </xsl:if>
					<!--<xsl:if test="./@codeListValue"> (<xsl:value-of select="concat('codeListValue: ', @codeListValue)"/>)</xsl:if>-->
					<xsl:if test="./@locale"> <xsl:value-of select="concat('locale: ', @locale)"/></xsl:if>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!--
  Text formatting template. Use existing line breaks. Indent each line
  to the current indent level. Return the next line each time the template
  is called.  
  -->
</xsl:stylesheet>