import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::MWAA::Environment`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html
 */
export interface CfnEnvironmentProps {
    /**
     * `AWS::MWAA::Environment.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-name
     */
    readonly name: string;
    /**
     * `AWS::MWAA::Environment.AirflowConfigurationOptions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-airflowconfigurationoptions
     */
    readonly airflowConfigurationOptions?: CfnEnvironment.AirflowConfigurationOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::MWAA::Environment.AirflowVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-airflowversion
     */
    readonly airflowVersion?: string;
    /**
     * `AWS::MWAA::Environment.DagS3Path`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-dags3path
     */
    readonly dagS3Path?: string;
    /**
     * `AWS::MWAA::Environment.EnvironmentClass`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-environmentclass
     */
    readonly environmentClass?: string;
    /**
     * `AWS::MWAA::Environment.ExecutionRoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-executionrolearn
     */
    readonly executionRoleArn?: string;
    /**
     * `AWS::MWAA::Environment.KmsKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-kmskey
     */
    readonly kmsKey?: string;
    /**
     * `AWS::MWAA::Environment.LoggingConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-loggingconfiguration
     */
    readonly loggingConfiguration?: CfnEnvironment.LoggingConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::MWAA::Environment.MaxWorkers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-maxworkers
     */
    readonly maxWorkers?: number;
    /**
     * `AWS::MWAA::Environment.NetworkConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-networkconfiguration
     */
    readonly networkConfiguration?: CfnEnvironment.NetworkConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::MWAA::Environment.PluginsS3ObjectVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-pluginss3objectversion
     */
    readonly pluginsS3ObjectVersion?: string;
    /**
     * `AWS::MWAA::Environment.PluginsS3Path`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-pluginss3path
     */
    readonly pluginsS3Path?: string;
    /**
     * `AWS::MWAA::Environment.RequirementsS3ObjectVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-requirementss3objectversion
     */
    readonly requirementsS3ObjectVersion?: string;
    /**
     * `AWS::MWAA::Environment.RequirementsS3Path`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-requirementss3path
     */
    readonly requirementsS3Path?: string;
    /**
     * `AWS::MWAA::Environment.SourceBucketArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-sourcebucketarn
     */
    readonly sourceBucketArn?: string;
    /**
     * `AWS::MWAA::Environment.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-tags
     */
    readonly tags?: CfnEnvironment.TagMapProperty;
    /**
     * `AWS::MWAA::Environment.WebserverAccessMode`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-webserveraccessmode
     */
    readonly webserverAccessMode?: string;
    /**
     * `AWS::MWAA::Environment.WeeklyMaintenanceWindowStart`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-weeklymaintenancewindowstart
     */
    readonly weeklyMaintenanceWindowStart?: string;
}
/**
 * A CloudFormation `AWS::MWAA::Environment`.
 *
 * @external
 * @cloudformationResource AWS::MWAA::Environment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html
 */
export declare class CfnEnvironment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MWAA::Environment";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEnvironment;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute WebserverUrl
     */
    readonly attrWebserverUrl: string;
    /**
     * `AWS::MWAA::Environment.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-name
     */
    name: string;
    /**
     * `AWS::MWAA::Environment.AirflowConfigurationOptions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-airflowconfigurationoptions
     */
    airflowConfigurationOptions: CfnEnvironment.AirflowConfigurationOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MWAA::Environment.AirflowVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-airflowversion
     */
    airflowVersion: string | undefined;
    /**
     * `AWS::MWAA::Environment.DagS3Path`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-dags3path
     */
    dagS3Path: string | undefined;
    /**
     * `AWS::MWAA::Environment.EnvironmentClass`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-environmentclass
     */
    environmentClass: string | undefined;
    /**
     * `AWS::MWAA::Environment.ExecutionRoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-executionrolearn
     */
    executionRoleArn: string | undefined;
    /**
     * `AWS::MWAA::Environment.KmsKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-kmskey
     */
    kmsKey: string | undefined;
    /**
     * `AWS::MWAA::Environment.LoggingConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-loggingconfiguration
     */
    loggingConfiguration: CfnEnvironment.LoggingConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MWAA::Environment.MaxWorkers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-maxworkers
     */
    maxWorkers: number | undefined;
    /**
     * `AWS::MWAA::Environment.NetworkConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-networkconfiguration
     */
    networkConfiguration: CfnEnvironment.NetworkConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MWAA::Environment.PluginsS3ObjectVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-pluginss3objectversion
     */
    pluginsS3ObjectVersion: string | undefined;
    /**
     * `AWS::MWAA::Environment.PluginsS3Path`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-pluginss3path
     */
    pluginsS3Path: string | undefined;
    /**
     * `AWS::MWAA::Environment.RequirementsS3ObjectVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-requirementss3objectversion
     */
    requirementsS3ObjectVersion: string | undefined;
    /**
     * `AWS::MWAA::Environment.RequirementsS3Path`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-requirementss3path
     */
    requirementsS3Path: string | undefined;
    /**
     * `AWS::MWAA::Environment.SourceBucketArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-sourcebucketarn
     */
    sourceBucketArn: string | undefined;
    /**
     * `AWS::MWAA::Environment.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-tags
     */
    tags: CfnEnvironment.TagMapProperty | undefined;
    /**
     * `AWS::MWAA::Environment.WebserverAccessMode`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-webserveraccessmode
     */
    webserverAccessMode: string | undefined;
    /**
     * `AWS::MWAA::Environment.WeeklyMaintenanceWindowStart`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-weeklymaintenancewindowstart
     */
    weeklyMaintenanceWindowStart: string | undefined;
    /**
     * Create a new `AWS::MWAA::Environment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEnvironmentProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MWAA::Environment`.
 *
 * @external
 * @cloudformationResource AWS::MWAA::Environment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html
 */
export declare namespace CfnEnvironment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-airflowconfigurationoptions.html
     */
    interface AirflowConfigurationOptionsProperty {
    }
}
/**
 * A CloudFormation `AWS::MWAA::Environment`.
 *
 * @external
 * @cloudformationResource AWS::MWAA::Environment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html
 */
export declare namespace CfnEnvironment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-loggingconfiguration.html
     */
    interface LoggingConfigurationProperty {
        /**
         * `CfnEnvironment.LoggingConfigurationProperty.DagProcessingLogs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-loggingconfiguration.html#cfn-mwaa-environment-loggingconfiguration-dagprocessinglogs
         */
        readonly dagProcessingLogs?: CfnEnvironment.ModuleLoggingConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnEnvironment.LoggingConfigurationProperty.SchedulerLogs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-loggingconfiguration.html#cfn-mwaa-environment-loggingconfiguration-schedulerlogs
         */
        readonly schedulerLogs?: CfnEnvironment.ModuleLoggingConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnEnvironment.LoggingConfigurationProperty.TaskLogs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-loggingconfiguration.html#cfn-mwaa-environment-loggingconfiguration-tasklogs
         */
        readonly taskLogs?: CfnEnvironment.ModuleLoggingConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnEnvironment.LoggingConfigurationProperty.WebserverLogs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-loggingconfiguration.html#cfn-mwaa-environment-loggingconfiguration-webserverlogs
         */
        readonly webserverLogs?: CfnEnvironment.ModuleLoggingConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnEnvironment.LoggingConfigurationProperty.WorkerLogs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-loggingconfiguration.html#cfn-mwaa-environment-loggingconfiguration-workerlogs
         */
        readonly workerLogs?: CfnEnvironment.ModuleLoggingConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MWAA::Environment`.
 *
 * @external
 * @cloudformationResource AWS::MWAA::Environment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html
 */
export declare namespace CfnEnvironment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-moduleloggingconfiguration.html
     */
    interface ModuleLoggingConfigurationProperty {
        /**
         * `CfnEnvironment.ModuleLoggingConfigurationProperty.CloudWatchLogGroupArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-moduleloggingconfiguration.html#cfn-mwaa-environment-moduleloggingconfiguration-cloudwatchloggrouparn
         */
        readonly cloudWatchLogGroupArn?: string;
        /**
         * `CfnEnvironment.ModuleLoggingConfigurationProperty.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-moduleloggingconfiguration.html#cfn-mwaa-environment-moduleloggingconfiguration-enabled
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnEnvironment.ModuleLoggingConfigurationProperty.LogLevel`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-moduleloggingconfiguration.html#cfn-mwaa-environment-moduleloggingconfiguration-loglevel
         */
        readonly logLevel?: string;
    }
}
/**
 * A CloudFormation `AWS::MWAA::Environment`.
 *
 * @external
 * @cloudformationResource AWS::MWAA::Environment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html
 */
export declare namespace CfnEnvironment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-networkconfiguration.html
     */
    interface NetworkConfigurationProperty {
        /**
         * `CfnEnvironment.NetworkConfigurationProperty.SecurityGroupIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-networkconfiguration.html#cfn-mwaa-environment-networkconfiguration-securitygroupids
         */
        readonly securityGroupIds?: string[];
        /**
         * `CfnEnvironment.NetworkConfigurationProperty.SubnetIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-networkconfiguration.html#cfn-mwaa-environment-networkconfiguration-subnetids
         */
        readonly subnetIds?: string[];
    }
}
/**
 * A CloudFormation `AWS::MWAA::Environment`.
 *
 * @external
 * @cloudformationResource AWS::MWAA::Environment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html
 */
export declare namespace CfnEnvironment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-tagmap.html
     */
    interface TagMapProperty {
    }
}
