from typing import List
from rikai_sklearn.models import SklearnModelType

class DimensionalityReduction(SklearnModelType):
    """Dimensionality reduction models.

    - PCA
    """

    def schema(self) -> str:
        return "array<float>"

    def predict(self, x, *args, **kwargs) -> List[float]:
        return self.model.transform(x).tolist()

MODEL_TYPE=DimensionalityReduction()
