# Generated by Django 3.2.12 on 2022-03-23 17:47

from decimal import Decimal
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import mptt.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='TransactionType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(help_text='This unique code will used as Transaction Inner ID prefix eg: TRX.0202.001', max_length=3, unique=True, verbose_name='Code')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('description', models.CharField(blank=True, max_length=255, null=True, verbose_name='Description')),
                ('lft', models.PositiveIntegerField(editable=False)),
                ('rght', models.PositiveIntegerField(editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(editable=False)),
                ('parent', mptt.fields.TreeForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='children', to='simpel_journals.transactiontype')),
            ],
            options={
                'verbose_name': 'Transaction Type',
                'verbose_name_plural': 'Transaction Types',
                'db_table': 'simpel_accounting_transaction_type',
            },
        ),
        migrations.CreateModel(
            name='Transaction',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('reg_number', models.PositiveIntegerField(blank=True, editable=False, null=True, verbose_name='Reg number')),
                ('inner_id', models.CharField(blank=True, editable=False, max_length=50, null=True, unique=True, verbose_name='Inner ID')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='created at')),
                ('status', models.CharField(choices=[('pending', 'Pending'), ('confirmed', 'Confirmed'), ('canceled', 'Canceled')], default='pending', max_length=15, verbose_name='Status')),
                ('group', models.CharField(blank=True, max_length=3, null=True, verbose_name='Group')),
                ('reference_id', models.CharField(max_length=255, verbose_name='Reference')),
                ('note', models.CharField(blank=True, max_length=255, null=True, verbose_name='Memo')),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_simpel_journals.transaction_set+', to='contenttypes.contenttype')),
                ('reference_type', models.ForeignKey(blank=True, limit_choices_to={'model__in': ['salesorder', 'invoice', 'payment']}, null=True, on_delete=django.db.models.deletion.SET_NULL, to='contenttypes.contenttype')),
                ('type', mptt.fields.TreeForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='transactions', to='simpel_journals.transactiontype', verbose_name='Type')),
            ],
            options={
                'verbose_name': 'Transaction',
                'verbose_name_plural': 'Transactions',
                'db_table': 'simpel_accounting_transaction',
                'index_together': {('created_at', 'inner_id', 'status')},
            },
        ),
        migrations.CreateModel(
            name='AccountType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('debit', models.IntegerField(choices=[(1, 'Increase'), (-1, 'Decrease')], default=1)),
                ('code', models.CharField(blank=True, max_length=128, null=True, unique=True)),
                ('name', models.CharField(max_length=255)),
                ('lft', models.PositiveIntegerField(editable=False)),
                ('rght', models.PositiveIntegerField(editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(editable=False)),
                ('parent', mptt.fields.TreeForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='children', to='simpel_journals.accounttype')),
            ],
            options={
                'verbose_name': 'Account Type',
                'verbose_name_plural': 'Account Types',
                'db_table': 'simpel_accounting_account_type',
            },
        ),
        migrations.CreateModel(
            name='Account',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='Created at')),
                ('last_modified_at', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='Created at')),
                ('start_date', models.DateTimeField(blank=True, null=True)),
                ('end_date', models.DateTimeField(blank=True, null=True)),
                ('code', models.CharField(blank=True, max_length=128, null=True, unique=True)),
                ('linked_object_id', models.IntegerField(blank=True, help_text='Linked instance primary key.', null=True)),
                ('name', models.CharField(blank=True, max_length=128, null=True)),
                ('description', models.TextField(blank=True, help_text='This text is shown to customers during checkout', null=True)),
                ('status', models.CharField(choices=[('Open', 'Open'), ('Frozen', 'Frozen'), ('Closed', 'Closed')], default='Open', max_length=32)),
                ('credit_limit', models.DecimalField(blank=True, decimal_places=2, default=Decimal('0.00'), max_digits=12, null=True)),
                ('balance', models.DecimalField(decimal_places=2, default=0, editable=False, max_digits=15, verbose_name='Balance')),
                ('account_type', mptt.fields.TreeForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='accounts', to='simpel_journals.accounttype')),
                ('linked_object_type', models.ForeignKey(blank=True, help_text='Linked instance type', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='accounts', to='contenttypes.contenttype')),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_simpel_journals.account_set+', to='contenttypes.contenttype')),
            ],
            options={
                'verbose_name': 'Account',
                'verbose_name_plural': 'Accounts',
                'db_table': 'simpel_accounting_account',
            },
        ),
        migrations.CreateModel(
            name='Entry',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(db_index=True, default=django.utils.timezone.now, editable=False)),
                ('flow', models.IntegerField(choices=[(1, 'Debit'), (-1, 'Credit')])),
                ('amount', models.DecimalField(decimal_places=2, max_digits=12)),
                ('computed_amount', models.DecimalField(decimal_places=2, max_digits=12)),
                ('status', models.CharField(choices=[('pending', 'Pending'), ('confirmed', 'Confirmed'), ('canceled', 'Canceled')], default='pending', max_length=15, verbose_name='Status')),
                ('account', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='entries', to='simpel_journals.account')),
                ('trx', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='entries', to='simpel_journals.transaction', verbose_name='Transaction')),
            ],
            options={
                'verbose_name': 'Entry',
                'verbose_name_plural': 'Entries',
                'db_table': 'simpel_accounting_entry',
                'unique_together': {('trx', 'account')},
                'index_together': {('id', 'trx', 'account')},
            },
        ),
    ]
