# coding: utf-8

"""
    Fabric Orchestrator API

    This is Fabric Orchestrator API  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: kthare10@unc.edu
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from fabric_cf.orchestrator.swagger_client.api_client import ApiClient


class SliversApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def slivers_get(self, slice_id, **kwargs):  # noqa: E501
        """Retrieve a listing of user slivers  # noqa: E501

        Retrieve a listing of user slivers  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slivers_get(slice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str slice_id: Slice identifier as UUID (required)
        :return: Success
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.slivers_get_with_http_info(slice_id, **kwargs)  # noqa: E501
        else:
            (data) = self.slivers_get_with_http_info(slice_id, **kwargs)  # noqa: E501
            return data

    def slivers_get_with_http_info(self, slice_id, **kwargs):  # noqa: E501
        """Retrieve a listing of user slivers  # noqa: E501

        Retrieve a listing of user slivers  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slivers_get_with_http_info(slice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str slice_id: Slice identifier as UUID (required)
        :return: Success
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['slice_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method slivers_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'slice_id' is set
        if ('slice_id' not in params or
                params['slice_id'] is None):
            raise ValueError("Missing the required parameter `slice_id` when calling `slivers_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'slice_id' in params:
            query_params.append(('sliceID', params['slice_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/slivers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Success',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def slivers_modify_sliver_id_put(self, body, slice_id, sliver_id, **kwargs):  # noqa: E501
        """Modify sliver  # noqa: E501

        Request to modify slice as described in the request. Request would be a Graph ML describing the requested resources for slice or a dictionary for sliver. On success, for one or more slivers are modified. This API returns list and description of the resources reserved for the slice in the form of Graph ML. Orchestrator would also trigger provisioning of the new resources on the appropriate sites either now or in the future based as requested. Modify operations may include add/delete/modify a container/VM/Baremetal server/network or other resources to the slice.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slivers_modify_sliver_id_put(body, slice_id, sliver_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str slice_id: Slice identifier as UUID (required)
        :param str sliver_id: Sliver identifier as UUID (required)
        :return: Success
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.slivers_modify_sliver_id_put_with_http_info(body, slice_id, sliver_id, **kwargs)  # noqa: E501
        else:
            (data) = self.slivers_modify_sliver_id_put_with_http_info(body, slice_id, sliver_id, **kwargs)  # noqa: E501
            return data

    def slivers_modify_sliver_id_put_with_http_info(self, body, slice_id, sliver_id, **kwargs):  # noqa: E501
        """Modify sliver  # noqa: E501

        Request to modify slice as described in the request. Request would be a Graph ML describing the requested resources for slice or a dictionary for sliver. On success, for one or more slivers are modified. This API returns list and description of the resources reserved for the slice in the form of Graph ML. Orchestrator would also trigger provisioning of the new resources on the appropriate sites either now or in the future based as requested. Modify operations may include add/delete/modify a container/VM/Baremetal server/network or other resources to the slice.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slivers_modify_sliver_id_put_with_http_info(body, slice_id, sliver_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str slice_id: Slice identifier as UUID (required)
        :param str sliver_id: Sliver identifier as UUID (required)
        :return: Success
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'slice_id', 'sliver_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method slivers_modify_sliver_id_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `slivers_modify_sliver_id_put`")  # noqa: E501
        # verify the required parameter 'slice_id' is set
        if ('slice_id' not in params or
                params['slice_id'] is None):
            raise ValueError("Missing the required parameter `slice_id` when calling `slivers_modify_sliver_id_put`")  # noqa: E501
        # verify the required parameter 'sliver_id' is set
        if ('sliver_id' not in params or
                params['sliver_id'] is None):
            raise ValueError("Missing the required parameter `sliver_id` when calling `slivers_modify_sliver_id_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sliver_id' in params:
            path_params['sliverID'] = params['sliver_id']  # noqa: E501

        query_params = []
        if 'slice_id' in params:
            query_params.append(('sliceID', params['slice_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/slivers/modify/{sliverID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Success',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def slivers_poa_sliver_id_post(self, body, sliver_id, **kwargs):  # noqa: E501
        """Perform Operational Action  # noqa: E501

        Perform the named operational action on the named resources, possibly changing the operational status of the named resources. E.G. 'reboot' a VM.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slivers_poa_sliver_id_post(body, sliver_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str sliver_id: Sliver identifier as UUID (required)
        :return: Success
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.slivers_poa_sliver_id_post_with_http_info(body, sliver_id, **kwargs)  # noqa: E501
        else:
            (data) = self.slivers_poa_sliver_id_post_with_http_info(body, sliver_id, **kwargs)  # noqa: E501
            return data

    def slivers_poa_sliver_id_post_with_http_info(self, body, sliver_id, **kwargs):  # noqa: E501
        """Perform Operational Action  # noqa: E501

        Perform the named operational action on the named resources, possibly changing the operational status of the named resources. E.G. 'reboot' a VM.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slivers_poa_sliver_id_post_with_http_info(body, sliver_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str sliver_id: Sliver identifier as UUID (required)
        :return: Success
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'sliver_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method slivers_poa_sliver_id_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `slivers_poa_sliver_id_post`")  # noqa: E501
        # verify the required parameter 'sliver_id' is set
        if ('sliver_id' not in params or
                params['sliver_id'] is None):
            raise ValueError("Missing the required parameter `sliver_id` when calling `slivers_poa_sliver_id_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sliver_id' in params:
            path_params['sliverID'] = params['sliver_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/slivers/poa/{sliverID}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Success',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def slivers_sliver_id_get(self, slice_id, sliver_id, **kwargs):  # noqa: E501
        """slivers properties  # noqa: E501

        Retrieve Sliver properties  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slivers_sliver_id_get(slice_id, sliver_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str slice_id: Slice identifier as UUID (required)
        :param str sliver_id: Sliver identifier as UUID (required)
        :return: Success
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.slivers_sliver_id_get_with_http_info(slice_id, sliver_id, **kwargs)  # noqa: E501
        else:
            (data) = self.slivers_sliver_id_get_with_http_info(slice_id, sliver_id, **kwargs)  # noqa: E501
            return data

    def slivers_sliver_id_get_with_http_info(self, slice_id, sliver_id, **kwargs):  # noqa: E501
        """slivers properties  # noqa: E501

        Retrieve Sliver properties  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slivers_sliver_id_get_with_http_info(slice_id, sliver_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str slice_id: Slice identifier as UUID (required)
        :param str sliver_id: Sliver identifier as UUID (required)
        :return: Success
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['slice_id', 'sliver_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method slivers_sliver_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'slice_id' is set
        if ('slice_id' not in params or
                params['slice_id'] is None):
            raise ValueError("Missing the required parameter `slice_id` when calling `slivers_sliver_id_get`")  # noqa: E501
        # verify the required parameter 'sliver_id' is set
        if ('sliver_id' not in params or
                params['sliver_id'] is None):
            raise ValueError("Missing the required parameter `sliver_id` when calling `slivers_sliver_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sliver_id' in params:
            path_params['sliverID'] = params['sliver_id']  # noqa: E501

        query_params = []
        if 'slice_id' in params:
            query_params.append(('sliceID', params['slice_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/slivers/{sliverID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Success',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def slivers_status_sliver_id_get(self, slice_id, sliver_id, **kwargs):  # noqa: E501
        """slivers status  # noqa: E501

        Retrieve the status of a sliver. Status would include dynamic reservation or instantiation information. This API is used to provide updates on the state of the resources after the completion of create, which began to asynchronously provision the resources. The response would contain relatively dynamic data, not descriptive data as returned in the Graph ML.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slivers_status_sliver_id_get(slice_id, sliver_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str slice_id: Slice identifier as UUID (required)
        :param str sliver_id: Sliver identifier as UUID (required)
        :return: Success
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.slivers_status_sliver_id_get_with_http_info(slice_id, sliver_id, **kwargs)  # noqa: E501
        else:
            (data) = self.slivers_status_sliver_id_get_with_http_info(slice_id, sliver_id, **kwargs)  # noqa: E501
            return data

    def slivers_status_sliver_id_get_with_http_info(self, slice_id, sliver_id, **kwargs):  # noqa: E501
        """slivers status  # noqa: E501

        Retrieve the status of a sliver. Status would include dynamic reservation or instantiation information. This API is used to provide updates on the state of the resources after the completion of create, which began to asynchronously provision the resources. The response would contain relatively dynamic data, not descriptive data as returned in the Graph ML.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slivers_status_sliver_id_get_with_http_info(slice_id, sliver_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str slice_id: Slice identifier as UUID (required)
        :param str sliver_id: Sliver identifier as UUID (required)
        :return: Success
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['slice_id', 'sliver_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method slivers_status_sliver_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'slice_id' is set
        if ('slice_id' not in params or
                params['slice_id'] is None):
            raise ValueError("Missing the required parameter `slice_id` when calling `slivers_status_sliver_id_get`")  # noqa: E501
        # verify the required parameter 'sliver_id' is set
        if ('sliver_id' not in params or
                params['sliver_id'] is None):
            raise ValueError("Missing the required parameter `sliver_id` when calling `slivers_status_sliver_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sliver_id' in params:
            path_params['sliverID'] = params['sliver_id']  # noqa: E501

        query_params = []
        if 'slice_id' in params:
            query_params.append(('sliceID', params['slice_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/slivers/status/{sliverID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Success',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
