"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Archive = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const events_generated_1 = require("./events.generated");
const util_1 = require("./util");
/**
 * Define an EventBridge Archive.
 *
 * @stability stable
 * @resource AWS::Events::Archive
 */
class Archive extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id, { physicalName: props.archiveName });
        jsiiDeprecationWarnings._aws_cdk_aws_events_ArchiveProps(props);
        let archive = new events_generated_1.CfnArchive(this, 'Archive', {
            sourceArn: props.sourceEventBus.eventBusArn,
            description: props.description,
            eventPattern: util_1.renderEventPattern(props.eventPattern),
            retentionDays: ((_b = props.retention) === null || _b === void 0 ? void 0 : _b.toDays({ integral: true })) || 0,
            archiveName: this.physicalName,
        });
        this.archiveArn = archive.attrArn;
        this.archiveName = archive.attrArchiveName;
    }
}
exports.Archive = Archive;
_a = JSII_RTTI_SYMBOL_1;
Archive[_a] = { fqn: "@aws-cdk/aws-events.Archive", version: "1.143.0" };
//# sourceMappingURL=data:application/json;base64,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