import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GcpAuthBackendRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend_role#add_group_aliases GcpAuthBackendRole#add_group_aliases}
    */
    readonly addGroupAliases?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend_role#allow_gce_inference GcpAuthBackendRole#allow_gce_inference}
    */
    readonly allowGceInference?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend_role#backend GcpAuthBackendRole#backend}
    */
    readonly backend?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend_role#bound_instance_groups GcpAuthBackendRole#bound_instance_groups}
    */
    readonly boundInstanceGroups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend_role#bound_labels GcpAuthBackendRole#bound_labels}
    */
    readonly boundLabels?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend_role#bound_projects GcpAuthBackendRole#bound_projects}
    */
    readonly boundProjects?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend_role#bound_regions GcpAuthBackendRole#bound_regions}
    */
    readonly boundRegions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend_role#bound_service_accounts GcpAuthBackendRole#bound_service_accounts}
    */
    readonly boundServiceAccounts?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend_role#bound_zones GcpAuthBackendRole#bound_zones}
    */
    readonly boundZones?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend_role#id GcpAuthBackendRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend_role#max_jwt_exp GcpAuthBackendRole#max_jwt_exp}
    */
    readonly maxJwtExp?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend_role#namespace GcpAuthBackendRole#namespace}
    */
    readonly namespace?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend_role#role GcpAuthBackendRole#role}
    */
    readonly role: string;
    /**
    * Specifies the blocks of IP addresses which are allowed to use the generated token
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend_role#token_bound_cidrs GcpAuthBackendRole#token_bound_cidrs}
    */
    readonly tokenBoundCidrs?: string[];
    /**
    * Generated Token's Explicit Maximum TTL in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend_role#token_explicit_max_ttl GcpAuthBackendRole#token_explicit_max_ttl}
    */
    readonly tokenExplicitMaxTtl?: number;
    /**
    * The maximum lifetime of the generated token
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend_role#token_max_ttl GcpAuthBackendRole#token_max_ttl}
    */
    readonly tokenMaxTtl?: number;
    /**
    * If true, the 'default' policy will not automatically be added to generated tokens
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend_role#token_no_default_policy GcpAuthBackendRole#token_no_default_policy}
    */
    readonly tokenNoDefaultPolicy?: boolean | cdktf.IResolvable;
    /**
    * The maximum number of times a token may be used, a value of zero means unlimited
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend_role#token_num_uses GcpAuthBackendRole#token_num_uses}
    */
    readonly tokenNumUses?: number;
    /**
    * Generated Token's Period
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend_role#token_period GcpAuthBackendRole#token_period}
    */
    readonly tokenPeriod?: number;
    /**
    * Generated Token's Policies
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend_role#token_policies GcpAuthBackendRole#token_policies}
    */
    readonly tokenPolicies?: string[];
    /**
    * The initial ttl of the token to generate in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend_role#token_ttl GcpAuthBackendRole#token_ttl}
    */
    readonly tokenTtl?: number;
    /**
    * The type of token to generate, service or batch
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend_role#token_type GcpAuthBackendRole#token_type}
    */
    readonly tokenType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend_role#type GcpAuthBackendRole#type}
    */
    readonly type: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend_role vault_gcp_auth_backend_role}
*/
export declare class GcpAuthBackendRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_gcp_auth_backend_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend_role vault_gcp_auth_backend_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GcpAuthBackendRoleConfig
    */
    constructor(scope: Construct, id: string, config: GcpAuthBackendRoleConfig);
    private _addGroupAliases?;
    get addGroupAliases(): boolean | cdktf.IResolvable;
    set addGroupAliases(value: boolean | cdktf.IResolvable);
    resetAddGroupAliases(): void;
    get addGroupAliasesInput(): boolean | cdktf.IResolvable | undefined;
    private _allowGceInference?;
    get allowGceInference(): boolean | cdktf.IResolvable;
    set allowGceInference(value: boolean | cdktf.IResolvable);
    resetAllowGceInference(): void;
    get allowGceInferenceInput(): boolean | cdktf.IResolvable | undefined;
    private _backend?;
    get backend(): string;
    set backend(value: string);
    resetBackend(): void;
    get backendInput(): string | undefined;
    private _boundInstanceGroups?;
    get boundInstanceGroups(): string[];
    set boundInstanceGroups(value: string[]);
    resetBoundInstanceGroups(): void;
    get boundInstanceGroupsInput(): string[] | undefined;
    private _boundLabels?;
    get boundLabels(): string[];
    set boundLabels(value: string[]);
    resetBoundLabels(): void;
    get boundLabelsInput(): string[] | undefined;
    private _boundProjects?;
    get boundProjects(): string[];
    set boundProjects(value: string[]);
    resetBoundProjects(): void;
    get boundProjectsInput(): string[] | undefined;
    private _boundRegions?;
    get boundRegions(): string[];
    set boundRegions(value: string[]);
    resetBoundRegions(): void;
    get boundRegionsInput(): string[] | undefined;
    private _boundServiceAccounts?;
    get boundServiceAccounts(): string[];
    set boundServiceAccounts(value: string[]);
    resetBoundServiceAccounts(): void;
    get boundServiceAccountsInput(): string[] | undefined;
    private _boundZones?;
    get boundZones(): string[];
    set boundZones(value: string[]);
    resetBoundZones(): void;
    get boundZonesInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maxJwtExp?;
    get maxJwtExp(): string;
    set maxJwtExp(value: string);
    resetMaxJwtExp(): void;
    get maxJwtExpInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _tokenBoundCidrs?;
    get tokenBoundCidrs(): string[];
    set tokenBoundCidrs(value: string[]);
    resetTokenBoundCidrs(): void;
    get tokenBoundCidrsInput(): string[] | undefined;
    private _tokenExplicitMaxTtl?;
    get tokenExplicitMaxTtl(): number;
    set tokenExplicitMaxTtl(value: number);
    resetTokenExplicitMaxTtl(): void;
    get tokenExplicitMaxTtlInput(): number | undefined;
    private _tokenMaxTtl?;
    get tokenMaxTtl(): number;
    set tokenMaxTtl(value: number);
    resetTokenMaxTtl(): void;
    get tokenMaxTtlInput(): number | undefined;
    private _tokenNoDefaultPolicy?;
    get tokenNoDefaultPolicy(): boolean | cdktf.IResolvable;
    set tokenNoDefaultPolicy(value: boolean | cdktf.IResolvable);
    resetTokenNoDefaultPolicy(): void;
    get tokenNoDefaultPolicyInput(): boolean | cdktf.IResolvable | undefined;
    private _tokenNumUses?;
    get tokenNumUses(): number;
    set tokenNumUses(value: number);
    resetTokenNumUses(): void;
    get tokenNumUsesInput(): number | undefined;
    private _tokenPeriod?;
    get tokenPeriod(): number;
    set tokenPeriod(value: number);
    resetTokenPeriod(): void;
    get tokenPeriodInput(): number | undefined;
    private _tokenPolicies?;
    get tokenPolicies(): string[];
    set tokenPolicies(value: string[]);
    resetTokenPolicies(): void;
    get tokenPoliciesInput(): string[] | undefined;
    private _tokenTtl?;
    get tokenTtl(): number;
    set tokenTtl(value: number);
    resetTokenTtl(): void;
    get tokenTtlInput(): number | undefined;
    private _tokenType?;
    get tokenType(): string;
    set tokenType(value: string);
    resetTokenType(): void;
    get tokenTypeInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
