#!/usr/bin/env python3
# -*- coding: utf-8 -*-
__copyright__ = """ This code is licensed under the 3-clause BSD license.
Copyright ETH Zurich, Laboratory of Physical Chemistry, Reiher Group.
See LICENSE.txt for details.
"""
import numpy as np
from typing import List


class LebedevSphere:
    """
    A 5810 point Lebedev unit sphere and the nearest neighbors for each point.
    """

    @property
    def points(self) -> np.ndarray:
        """np.ndarray :: The points of the Lebedev sphere."""
        return self._points

    @property
    def nearest_neighbors(self) -> List[List[int]]:
        """List[List[int]] :: The nearest neighbors of all points on the sphere."""
        return self._nearest_neighbors

    def __init__(self):
        self._points = np.array(
            [
                [+1.0000000, +0.0000000, +0.0000000],
                [-1.0000000, +0.0000000, +0.0000000],
                [+0.0000000, +1.0000000, +0.0000000],
                [+0.0000000, -1.0000000, +0.0000000],
                [+0.0000000, +0.0000000, +1.0000000],
                [+0.0000000, +0.0000000, -1.0000000],
                [+0.0000000, +0.7071070, +0.7071070],
                [+0.0000000, -0.7071070, +0.7071070],
                [+0.0000000, +0.7071070, -0.7071070],
                [+0.0000000, -0.7071070, -0.7071070],
                [+0.7071070, +0.0000000, +0.7071070],
                [-0.7071070, +0.0000000, +0.7071070],
                [+0.7071070, +0.0000000, -0.7071070],
                [-0.7071070, +0.0000000, -0.7071070],
                [+0.7071070, +0.7071070, +0.0000000],
                [-0.7071070, +0.7071070, +0.0000000],
                [+0.7071070, -0.7071070, +0.0000000],
                [-0.7071070, -0.7071070, +0.0000000],
                [+0.5773500, +0.5773500, +0.5773500],
                [-0.5773500, +0.5773500, +0.5773500],
                [+0.5773500, -0.5773500, +0.5773500],
                [-0.5773500, -0.5773500, +0.5773500],
                [+0.5773500, +0.5773500, -0.5773500],
                [-0.5773500, +0.5773500, -0.5773500],
                [+0.5773500, -0.5773500, -0.5773500],
                [-0.5773500, -0.5773500, -0.5773500],
                [+0.0118236, +0.0118236, +0.9998600],
                [-0.0118236, +0.0118236, +0.9998600],
                [+0.0118236, -0.0118236, +0.9998600],
                [-0.0118236, -0.0118236, +0.9998600],
                [+0.0118236, +0.0118236, -0.9998600],
                [-0.0118236, +0.0118236, -0.9998600],
                [+0.0118236, -0.0118236, -0.9998600],
                [-0.0118236, -0.0118236, -0.9998600],
                [+0.0118236, +0.9998600, +0.0118236],
                [-0.0118236, +0.9998600, +0.0118236],
                [+0.0118236, -0.9998600, +0.0118236],
                [-0.0118236, -0.9998600, +0.0118236],
                [+0.0118236, +0.9998600, -0.0118236],
                [-0.0118236, +0.9998600, -0.0118236],
                [+0.0118236, -0.9998600, -0.0118236],
                [-0.0118236, -0.9998600, -0.0118236],
                [+0.9998600, +0.0118236, +0.0118236],
                [-0.9998600, +0.0118236, +0.0118236],
                [+0.9998600, -0.0118236, +0.0118236],
                [-0.9998600, -0.0118236, +0.0118236],
                [+0.9998600, +0.0118236, -0.0118236],
                [-0.9998600, +0.0118236, -0.0118236],
                [+0.9998600, -0.0118236, -0.0118236],
                [-0.9998600, -0.0118236, -0.0118236],
                [+0.0306215, +0.0306215, +0.9990620],
                [-0.0306215, +0.0306215, +0.9990620],
                [+0.0306215, -0.0306215, +0.9990620],
                [-0.0306215, -0.0306215, +0.9990620],
                [+0.0306215, +0.0306215, -0.9990620],
                [-0.0306215, +0.0306215, -0.9990620],
                [+0.0306215, -0.0306215, -0.9990620],
                [-0.0306215, -0.0306215, -0.9990620],
                [+0.0306215, +0.9990620, +0.0306215],
                [-0.0306215, +0.9990620, +0.0306215],
                [+0.0306215, -0.9990620, +0.0306215],
                [-0.0306215, -0.9990620, +0.0306215],
                [+0.0306215, +0.9990620, -0.0306215],
                [-0.0306215, +0.9990620, -0.0306215],
                [+0.0306215, -0.9990620, -0.0306215],
                [-0.0306215, -0.9990620, -0.0306215],
                [+0.9990620, +0.0306215, +0.0306215],
                [-0.9990620, +0.0306215, +0.0306215],
                [+0.9990620, -0.0306215, +0.0306215],
                [-0.9990620, -0.0306215, +0.0306215],
                [+0.9990620, +0.0306215, -0.0306215],
                [-0.9990620, +0.0306215, -0.0306215],
                [+0.9990620, -0.0306215, -0.0306215],
                [-0.9990620, -0.0306215, -0.0306215],
                [+0.0532979, +0.0532979, +0.9971550],
                [-0.0532979, +0.0532979, +0.9971550],
                [+0.0532979, -0.0532979, +0.9971550],
                [-0.0532979, -0.0532979, +0.9971550],
                [+0.0532979, +0.0532979, -0.9971550],
                [-0.0532979, +0.0532979, -0.9971550],
                [+0.0532979, -0.0532979, -0.9971550],
                [-0.0532979, -0.0532979, -0.9971550],
                [+0.0532979, +0.9971550, +0.0532979],
                [-0.0532979, +0.9971550, +0.0532979],
                [+0.0532979, -0.9971550, +0.0532979],
                [-0.0532979, -0.9971550, +0.0532979],
                [+0.0532979, +0.9971550, -0.0532979],
                [-0.0532979, +0.9971550, -0.0532979],
                [+0.0532979, -0.9971550, -0.0532979],
                [-0.0532979, -0.9971550, -0.0532979],
                [+0.9971550, +0.0532979, +0.0532979],
                [-0.9971550, +0.0532979, +0.0532979],
                [+0.9971550, -0.0532979, +0.0532979],
                [-0.9971550, -0.0532979, +0.0532979],
                [+0.9971550, +0.0532979, -0.0532979],
                [-0.9971550, +0.0532979, -0.0532979],
                [+0.9971550, -0.0532979, -0.0532979],
                [-0.9971550, -0.0532979, -0.0532979],
                [+0.0784817, +0.0784817, +0.9938220],
                [-0.0784817, +0.0784817, +0.9938220],
                [+0.0784817, -0.0784817, +0.9938220],
                [-0.0784817, -0.0784817, +0.9938220],
                [+0.0784817, +0.0784817, -0.9938220],
                [-0.0784817, +0.0784817, -0.9938220],
                [+0.0784817, -0.0784817, -0.9938220],
                [-0.0784817, -0.0784817, -0.9938220],
                [+0.0784817, +0.9938220, +0.0784817],
                [-0.0784817, +0.9938220, +0.0784817],
                [+0.0784817, -0.9938220, +0.0784817],
                [-0.0784817, -0.9938220, +0.0784817],
                [+0.0784817, +0.9938220, -0.0784817],
                [-0.0784817, +0.9938220, -0.0784817],
                [+0.0784817, -0.9938220, -0.0784817],
                [-0.0784817, -0.9938220, -0.0784817],
                [+0.9938220, +0.0784817, +0.0784817],
                [-0.9938220, +0.0784817, +0.0784817],
                [+0.9938220, -0.0784817, +0.0784817],
                [-0.9938220, -0.0784817, +0.0784817],
                [+0.9938220, +0.0784817, -0.0784817],
                [-0.9938220, +0.0784817, -0.0784817],
                [+0.9938220, -0.0784817, -0.0784817],
                [-0.9938220, -0.0784817, -0.0784817],
                [+0.1054040, +0.1054040, +0.9888280],
                [-0.1054040, +0.1054040, +0.9888280],
                [+0.1054040, -0.1054040, +0.9888280],
                [-0.1054040, -0.1054040, +0.9888280],
                [+0.1054040, +0.1054040, -0.9888280],
                [-0.1054040, +0.1054040, -0.9888280],
                [+0.1054040, -0.1054040, -0.9888280],
                [-0.1054040, -0.1054040, -0.9888280],
                [+0.1054040, +0.9888280, +0.1054040],
                [-0.1054040, +0.9888280, +0.1054040],
                [+0.1054040, -0.9888280, +0.1054040],
                [-0.1054040, -0.9888280, +0.1054040],
                [+0.1054040, +0.9888280, -0.1054040],
                [-0.1054040, +0.9888280, -0.1054040],
                [+0.1054040, -0.9888280, -0.1054040],
                [-0.1054040, -0.9888280, -0.1054040],
                [+0.9888280, +0.1054040, +0.1054040],
                [-0.9888280, +0.1054040, +0.1054040],
                [+0.9888280, -0.1054040, +0.1054040],
                [-0.9888280, -0.1054040, +0.1054040],
                [+0.9888280, +0.1054040, -0.1054040],
                [-0.9888280, +0.1054040, -0.1054040],
                [+0.9888280, -0.1054040, -0.1054040],
                [-0.9888280, -0.1054040, -0.1054040],
                [+0.1335580, +0.1335580, +0.9820000],
                [-0.1335580, +0.1335580, +0.9820000],
                [+0.1335580, -0.1335580, +0.9820000],
                [-0.1335580, -0.1335580, +0.9820000],
                [+0.1335580, +0.1335580, -0.9820000],
                [-0.1335580, +0.1335580, -0.9820000],
                [+0.1335580, -0.1335580, -0.9820000],
                [-0.1335580, -0.1335580, -0.9820000],
                [+0.1335580, +0.9820000, +0.1335580],
                [-0.1335580, +0.9820000, +0.1335580],
                [+0.1335580, -0.9820000, +0.1335580],
                [-0.1335580, -0.9820000, +0.1335580],
                [+0.1335580, +0.9820000, -0.1335580],
                [-0.1335580, +0.9820000, -0.1335580],
                [+0.1335580, -0.9820000, -0.1335580],
                [-0.1335580, -0.9820000, -0.1335580],
                [+0.9820000, +0.1335580, +0.1335580],
                [-0.9820000, +0.1335580, +0.1335580],
                [+0.9820000, -0.1335580, +0.1335580],
                [-0.9820000, -0.1335580, +0.1335580],
                [+0.9820000, +0.1335580, -0.1335580],
                [-0.9820000, +0.1335580, -0.1335580],
                [+0.9820000, -0.1335580, -0.1335580],
                [-0.9820000, -0.1335580, -0.1335580],
                [+0.1625770, +0.1625770, +0.9732100],
                [-0.1625770, +0.1625770, +0.9732100],
                [+0.1625770, -0.1625770, +0.9732100],
                [-0.1625770, -0.1625770, +0.9732100],
                [+0.1625770, +0.1625770, -0.9732100],
                [-0.1625770, +0.1625770, -0.9732100],
                [+0.1625770, -0.1625770, -0.9732100],
                [-0.1625770, -0.1625770, -0.9732100],
                [+0.1625770, +0.9732100, +0.1625770],
                [-0.1625770, +0.9732100, +0.1625770],
                [+0.1625770, -0.9732100, +0.1625770],
                [-0.1625770, -0.9732100, +0.1625770],
                [+0.1625770, +0.9732100, -0.1625770],
                [-0.1625770, +0.9732100, -0.1625770],
                [+0.1625770, -0.9732100, -0.1625770],
                [-0.1625770, -0.9732100, -0.1625770],
                [+0.9732100, +0.1625770, +0.1625770],
                [-0.9732100, +0.1625770, +0.1625770],
                [+0.9732100, -0.1625770, +0.1625770],
                [-0.9732100, -0.1625770, +0.1625770],
                [+0.9732100, +0.1625770, -0.1625770],
                [-0.9732100, +0.1625770, -0.1625770],
                [+0.9732100, -0.1625770, -0.1625770],
                [-0.9732100, -0.1625770, -0.1625770],
                [+0.1921790, +0.1921790, +0.9623590],
                [-0.1921790, +0.1921790, +0.9623590],
                [+0.1921790, -0.1921790, +0.9623590],
                [-0.1921790, -0.1921790, +0.9623590],
                [+0.1921790, +0.1921790, -0.9623590],
                [-0.1921790, +0.1921790, -0.9623590],
                [+0.1921790, -0.1921790, -0.9623590],
                [-0.1921790, -0.1921790, -0.9623590],
                [+0.1921790, +0.9623590, +0.1921790],
                [-0.1921790, +0.9623590, +0.1921790],
                [+0.1921790, -0.9623590, +0.1921790],
                [-0.1921790, -0.9623590, +0.1921790],
                [+0.1921790, +0.9623590, -0.1921790],
                [-0.1921790, +0.9623590, -0.1921790],
                [+0.1921790, -0.9623590, -0.1921790],
                [-0.1921790, -0.9623590, -0.1921790],
                [+0.9623590, +0.1921790, +0.1921790],
                [-0.9623590, +0.1921790, +0.1921790],
                [+0.9623590, -0.1921790, +0.1921790],
                [-0.9623590, -0.1921790, +0.1921790],
                [+0.9623590, +0.1921790, -0.1921790],
                [-0.9623590, +0.1921790, -0.1921790],
                [+0.9623590, -0.1921790, -0.1921790],
                [-0.9623590, -0.1921790, -0.1921790],
                [+0.2221340, +0.2221340, +0.9493750],
                [-0.2221340, +0.2221340, +0.9493750],
                [+0.2221340, -0.2221340, +0.9493750],
                [-0.2221340, -0.2221340, +0.9493750],
                [+0.2221340, +0.2221340, -0.9493750],
                [-0.2221340, +0.2221340, -0.9493750],
                [+0.2221340, -0.2221340, -0.9493750],
                [-0.2221340, -0.2221340, -0.9493750],
                [+0.2221340, +0.9493750, +0.2221340],
                [-0.2221340, +0.9493750, +0.2221340],
                [+0.2221340, -0.9493750, +0.2221340],
                [-0.2221340, -0.9493750, +0.2221340],
                [+0.2221340, +0.9493750, -0.2221340],
                [-0.2221340, +0.9493750, -0.2221340],
                [+0.2221340, -0.9493750, -0.2221340],
                [-0.2221340, -0.9493750, -0.2221340],
                [+0.9493750, +0.2221340, +0.2221340],
                [-0.9493750, +0.2221340, +0.2221340],
                [+0.9493750, -0.2221340, +0.2221340],
                [-0.9493750, -0.2221340, +0.2221340],
                [+0.9493750, +0.2221340, -0.2221340],
                [-0.9493750, +0.2221340, -0.2221340],
                [+0.9493750, -0.2221340, -0.2221340],
                [-0.9493750, -0.2221340, -0.2221340],
                [+0.2522500, +0.2522500, +0.9342050],
                [-0.2522500, +0.2522500, +0.9342050],
                [+0.2522500, -0.2522500, +0.9342050],
                [-0.2522500, -0.2522500, +0.9342050],
                [+0.2522500, +0.2522500, -0.9342050],
                [-0.2522500, +0.2522500, -0.9342050],
                [+0.2522500, -0.2522500, -0.9342050],
                [-0.2522500, -0.2522500, -0.9342050],
                [+0.2522500, +0.9342050, +0.2522500],
                [-0.2522500, +0.9342050, +0.2522500],
                [+0.2522500, -0.9342050, +0.2522500],
                [-0.2522500, -0.9342050, +0.2522500],
                [+0.2522500, +0.9342050, -0.2522500],
                [-0.2522500, +0.9342050, -0.2522500],
                [+0.2522500, -0.9342050, -0.2522500],
                [-0.2522500, -0.9342050, -0.2522500],
                [+0.9342050, +0.2522500, +0.2522500],
                [-0.9342050, +0.2522500, +0.2522500],
                [+0.9342050, -0.2522500, +0.2522500],
                [-0.9342050, -0.2522500, +0.2522500],
                [+0.9342050, +0.2522500, -0.2522500],
                [-0.9342050, +0.2522500, -0.2522500],
                [+0.9342050, -0.2522500, -0.2522500],
                [-0.9342050, -0.2522500, -0.2522500],
                [+0.2823610, +0.2823610, +0.9168120],
                [-0.2823610, +0.2823610, +0.9168120],
                [+0.2823610, -0.2823610, +0.9168120],
                [-0.2823610, -0.2823610, +0.9168120],
                [+0.2823610, +0.2823610, -0.9168120],
                [-0.2823610, +0.2823610, -0.9168120],
                [+0.2823610, -0.2823610, -0.9168120],
                [-0.2823610, -0.2823610, -0.9168120],
                [+0.2823610, +0.9168120, +0.2823610],
                [-0.2823610, +0.9168120, +0.2823610],
                [+0.2823610, -0.9168120, +0.2823610],
                [-0.2823610, -0.9168120, +0.2823610],
                [+0.2823610, +0.9168120, -0.2823610],
                [-0.2823610, +0.9168120, -0.2823610],
                [+0.2823610, -0.9168120, -0.2823610],
                [-0.2823610, -0.9168120, -0.2823610],
                [+0.9168120, +0.2823610, +0.2823610],
                [-0.9168120, +0.2823610, +0.2823610],
                [+0.9168120, -0.2823610, +0.2823610],
                [-0.9168120, -0.2823610, +0.2823610],
                [+0.9168120, +0.2823610, -0.2823610],
                [-0.9168120, +0.2823610, -0.2823610],
                [+0.9168120, -0.2823610, -0.2823610],
                [-0.9168120, -0.2823610, -0.2823610],
                [+0.3123170, +0.3123170, +0.8971710],
                [-0.3123170, +0.3123170, +0.8971710],
                [+0.3123170, -0.3123170, +0.8971710],
                [-0.3123170, -0.3123170, +0.8971710],
                [+0.3123170, +0.3123170, -0.8971710],
                [-0.3123170, +0.3123170, -0.8971710],
                [+0.3123170, -0.3123170, -0.8971710],
                [-0.3123170, -0.3123170, -0.8971710],
                [+0.3123170, +0.8971710, +0.3123170],
                [-0.3123170, +0.8971710, +0.3123170],
                [+0.3123170, -0.8971710, +0.3123170],
                [-0.3123170, -0.8971710, +0.3123170],
                [+0.3123170, +0.8971710, -0.3123170],
                [-0.3123170, +0.8971710, -0.3123170],
                [+0.3123170, -0.8971710, -0.3123170],
                [-0.3123170, -0.8971710, -0.3123170],
                [+0.8971710, +0.3123170, +0.3123170],
                [-0.8971710, +0.3123170, +0.3123170],
                [+0.8971710, -0.3123170, +0.3123170],
                [-0.8971710, -0.3123170, +0.3123170],
                [+0.8971710, +0.3123170, -0.3123170],
                [-0.8971710, +0.3123170, -0.3123170],
                [+0.8971710, -0.3123170, -0.3123170],
                [-0.8971710, -0.3123170, -0.3123170],
                [+0.3419850, +0.3419850, +0.8752670],
                [-0.3419850, +0.3419850, +0.8752670],
                [+0.3419850, -0.3419850, +0.8752670],
                [-0.3419850, -0.3419850, +0.8752670],
                [+0.3419850, +0.3419850, -0.8752670],
                [-0.3419850, +0.3419850, -0.8752670],
                [+0.3419850, -0.3419850, -0.8752670],
                [-0.3419850, -0.3419850, -0.8752670],
                [+0.3419850, +0.8752670, +0.3419850],
                [-0.3419850, +0.8752670, +0.3419850],
                [+0.3419850, -0.8752670, +0.3419850],
                [-0.3419850, -0.8752670, +0.3419850],
                [+0.3419850, +0.8752670, -0.3419850],
                [-0.3419850, +0.8752670, -0.3419850],
                [+0.3419850, -0.8752670, -0.3419850],
                [-0.3419850, -0.8752670, -0.3419850],
                [+0.8752670, +0.3419850, +0.3419850],
                [-0.8752670, +0.3419850, +0.3419850],
                [+0.8752670, -0.3419850, +0.3419850],
                [-0.8752670, -0.3419850, +0.3419850],
                [+0.8752670, +0.3419850, -0.3419850],
                [-0.8752670, +0.3419850, -0.3419850],
                [+0.8752670, -0.3419850, -0.3419850],
                [-0.8752670, -0.3419850, -0.3419850],
                [+0.3712390, +0.3712390, +0.8510960],
                [-0.3712390, +0.3712390, +0.8510960],
                [+0.3712390, -0.3712390, +0.8510960],
                [-0.3712390, -0.3712390, +0.8510960],
                [+0.3712390, +0.3712390, -0.8510960],
                [-0.3712390, +0.3712390, -0.8510960],
                [+0.3712390, -0.3712390, -0.8510960],
                [-0.3712390, -0.3712390, -0.8510960],
                [+0.3712390, +0.8510960, +0.3712390],
                [-0.3712390, +0.8510960, +0.3712390],
                [+0.3712390, -0.8510960, +0.3712390],
                [-0.3712390, -0.8510960, +0.3712390],
                [+0.3712390, +0.8510960, -0.3712390],
                [-0.3712390, +0.8510960, -0.3712390],
                [+0.3712390, -0.8510960, -0.3712390],
                [-0.3712390, -0.8510960, -0.3712390],
                [+0.8510960, +0.3712390, +0.3712390],
                [-0.8510960, +0.3712390, +0.3712390],
                [+0.8510960, -0.3712390, +0.3712390],
                [-0.8510960, -0.3712390, +0.3712390],
                [+0.8510960, +0.3712390, -0.3712390],
                [-0.8510960, +0.3712390, -0.3712390],
                [+0.8510960, -0.3712390, -0.3712390],
                [-0.8510960, -0.3712390, -0.3712390],
                [+0.3999630, +0.3999630, +0.8246570],
                [-0.3999630, +0.3999630, +0.8246570],
                [+0.3999630, -0.3999630, +0.8246570],
                [-0.3999630, -0.3999630, +0.8246570],
                [+0.3999630, +0.3999630, -0.8246570],
                [-0.3999630, +0.3999630, -0.8246570],
                [+0.3999630, -0.3999630, -0.8246570],
                [-0.3999630, -0.3999630, -0.8246570],
                [+0.3999630, +0.8246570, +0.3999630],
                [-0.3999630, +0.8246570, +0.3999630],
                [+0.3999630, -0.8246570, +0.3999630],
                [-0.3999630, -0.8246570, +0.3999630],
                [+0.3999630, +0.8246570, -0.3999630],
                [-0.3999630, +0.8246570, -0.3999630],
                [+0.3999630, -0.8246570, -0.3999630],
                [-0.3999630, -0.8246570, -0.3999630],
                [+0.8246570, +0.3999630, +0.3999630],
                [-0.8246570, +0.3999630, +0.3999630],
                [+0.8246570, -0.3999630, +0.3999630],
                [-0.8246570, -0.3999630, +0.3999630],
                [+0.8246570, +0.3999630, -0.3999630],
                [-0.8246570, +0.3999630, -0.3999630],
                [+0.8246570, -0.3999630, -0.3999630],
                [-0.8246570, -0.3999630, -0.3999630],
                [+0.4280470, +0.4280470, +0.7959600],
                [-0.4280470, +0.4280470, +0.7959600],
                [+0.4280470, -0.4280470, +0.7959600],
                [-0.4280470, -0.4280470, +0.7959600],
                [+0.4280470, +0.4280470, -0.7959600],
                [-0.4280470, +0.4280470, -0.7959600],
                [+0.4280470, -0.4280470, -0.7959600],
                [-0.4280470, -0.4280470, -0.7959600],
                [+0.4280470, +0.7959600, +0.4280470],
                [-0.4280470, +0.7959600, +0.4280470],
                [+0.4280470, -0.7959600, +0.4280470],
                [-0.4280470, -0.7959600, +0.4280470],
                [+0.4280470, +0.7959600, -0.4280470],
                [-0.4280470, +0.7959600, -0.4280470],
                [+0.4280470, -0.7959600, -0.4280470],
                [-0.4280470, -0.7959600, -0.4280470],
                [+0.7959600, +0.4280470, +0.4280470],
                [-0.7959600, +0.4280470, +0.4280470],
                [+0.7959600, -0.4280470, +0.4280470],
                [-0.7959600, -0.4280470, +0.4280470],
                [+0.7959600, +0.4280470, -0.4280470],
                [-0.7959600, +0.4280470, -0.4280470],
                [+0.7959600, -0.4280470, -0.4280470],
                [-0.7959600, -0.4280470, -0.4280470],
                [+0.4553840, +0.4553840, +0.7650160],
                [-0.4553840, +0.4553840, +0.7650160],
                [+0.4553840, -0.4553840, +0.7650160],
                [-0.4553840, -0.4553840, +0.7650160],
                [+0.4553840, +0.4553840, -0.7650160],
                [-0.4553840, +0.4553840, -0.7650160],
                [+0.4553840, -0.4553840, -0.7650160],
                [-0.4553840, -0.4553840, -0.7650160],
                [+0.4553840, +0.7650160, +0.4553840],
                [-0.4553840, +0.7650160, +0.4553840],
                [+0.4553840, -0.7650160, +0.4553840],
                [-0.4553840, -0.7650160, +0.4553840],
                [+0.4553840, +0.7650160, -0.4553840],
                [-0.4553840, +0.7650160, -0.4553840],
                [+0.4553840, -0.7650160, -0.4553840],
                [-0.4553840, -0.7650160, -0.4553840],
                [+0.7650160, +0.4553840, +0.4553840],
                [-0.7650160, +0.4553840, +0.4553840],
                [+0.7650160, -0.4553840, +0.4553840],
                [-0.7650160, -0.4553840, +0.4553840],
                [+0.7650160, +0.4553840, -0.4553840],
                [-0.7650160, +0.4553840, -0.4553840],
                [+0.7650160, -0.4553840, -0.4553840],
                [-0.7650160, -0.4553840, -0.4553840],
                [+0.4818740, +0.4818740, +0.7318440],
                [-0.4818740, +0.4818740, +0.7318440],
                [+0.4818740, -0.4818740, +0.7318440],
                [-0.4818740, -0.4818740, +0.7318440],
                [+0.4818740, +0.4818740, -0.7318440],
                [-0.4818740, +0.4818740, -0.7318440],
                [+0.4818740, -0.4818740, -0.7318440],
                [-0.4818740, -0.4818740, -0.7318440],
                [+0.4818740, +0.7318440, +0.4818740],
                [-0.4818740, +0.7318440, +0.4818740],
                [+0.4818740, -0.7318440, +0.4818740],
                [-0.4818740, -0.7318440, +0.4818740],
                [+0.4818740, +0.7318440, -0.4818740],
                [-0.4818740, +0.7318440, -0.4818740],
                [+0.4818740, -0.7318440, -0.4818740],
                [-0.4818740, -0.7318440, -0.4818740],
                [+0.7318440, +0.4818740, +0.4818740],
                [-0.7318440, +0.4818740, +0.4818740],
                [+0.7318440, -0.4818740, +0.4818740],
                [-0.7318440, -0.4818740, +0.4818740],
                [+0.7318440, +0.4818740, -0.4818740],
                [-0.7318440, +0.4818740, -0.4818740],
                [+0.7318440, -0.4818740, -0.4818740],
                [-0.7318440, -0.4818740, -0.4818740],
                [+0.5074140, +0.5074140, +0.6964640],
                [-0.5074140, +0.5074140, +0.6964640],
                [+0.5074140, -0.5074140, +0.6964640],
                [-0.5074140, -0.5074140, +0.6964640],
                [+0.5074140, +0.5074140, -0.6964640],
                [-0.5074140, +0.5074140, -0.6964640],
                [+0.5074140, -0.5074140, -0.6964640],
                [-0.5074140, -0.5074140, -0.6964640],
                [+0.5074140, +0.6964640, +0.5074140],
                [-0.5074140, +0.6964640, +0.5074140],
                [+0.5074140, -0.6964640, +0.5074140],
                [-0.5074140, -0.6964640, +0.5074140],
                [+0.5074140, +0.6964640, -0.5074140],
                [-0.5074140, +0.6964640, -0.5074140],
                [+0.5074140, -0.6964640, -0.5074140],
                [-0.5074140, -0.6964640, -0.5074140],
                [+0.6964640, +0.5074140, +0.5074140],
                [-0.6964640, +0.5074140, +0.5074140],
                [+0.6964640, -0.5074140, +0.5074140],
                [-0.6964640, -0.5074140, +0.5074140],
                [+0.6964640, +0.5074140, -0.5074140],
                [-0.6964640, +0.5074140, -0.5074140],
                [+0.6964640, -0.5074140, -0.5074140],
                [-0.6964640, -0.5074140, -0.5074140],
                [+0.5319060, +0.5319060, +0.6589020],
                [-0.5319060, +0.5319060, +0.6589020],
                [+0.5319060, -0.5319060, +0.6589020],
                [-0.5319060, -0.5319060, +0.6589020],
                [+0.5319060, +0.5319060, -0.6589020],
                [-0.5319060, +0.5319060, -0.6589020],
                [+0.5319060, -0.5319060, -0.6589020],
                [-0.5319060, -0.5319060, -0.6589020],
                [+0.5319060, +0.6589020, +0.5319060],
                [-0.5319060, +0.6589020, +0.5319060],
                [+0.5319060, -0.6589020, +0.5319060],
                [-0.5319060, -0.6589020, +0.5319060],
                [+0.5319060, +0.6589020, -0.5319060],
                [-0.5319060, +0.6589020, -0.5319060],
                [+0.5319060, -0.6589020, -0.5319060],
                [-0.5319060, -0.6589020, -0.5319060],
                [+0.6589020, +0.5319060, +0.5319060],
                [-0.6589020, +0.5319060, +0.5319060],
                [+0.6589020, -0.5319060, +0.5319060],
                [-0.6589020, -0.5319060, +0.5319060],
                [+0.6589020, +0.5319060, -0.5319060],
                [-0.6589020, +0.5319060, -0.5319060],
                [+0.6589020, -0.5319060, -0.5319060],
                [-0.6589020, -0.5319060, -0.5319060],
                [+0.5552510, +0.5552510, +0.6191860],
                [-0.5552510, +0.5552510, +0.6191860],
                [+0.5552510, -0.5552510, +0.6191860],
                [-0.5552510, -0.5552510, +0.6191860],
                [+0.5552510, +0.5552510, -0.6191860],
                [-0.5552510, +0.5552510, -0.6191860],
                [+0.5552510, -0.5552510, -0.6191860],
                [-0.5552510, -0.5552510, -0.6191860],
                [+0.5552510, +0.6191860, +0.5552510],
                [-0.5552510, +0.6191860, +0.5552510],
                [+0.5552510, -0.6191860, +0.5552510],
                [-0.5552510, -0.6191860, +0.5552510],
                [+0.5552510, +0.6191860, -0.5552510],
                [-0.5552510, +0.6191860, -0.5552510],
                [+0.5552510, -0.6191860, -0.5552510],
                [-0.5552510, -0.6191860, -0.5552510],
                [+0.6191860, +0.5552510, +0.5552510],
                [-0.6191860, +0.5552510, +0.5552510],
                [+0.6191860, -0.5552510, +0.5552510],
                [-0.6191860, -0.5552510, +0.5552510],
                [+0.6191860, +0.5552510, -0.5552510],
                [-0.6191860, +0.5552510, -0.5552510],
                [+0.6191860, -0.5552510, -0.5552510],
                [-0.6191860, -0.5552510, -0.5552510],
                [+0.5981010, +0.5981010, +0.5334330],
                [-0.5981010, +0.5981010, +0.5334330],
                [+0.5981010, -0.5981010, +0.5334330],
                [-0.5981010, -0.5981010, +0.5334330],
                [+0.5981010, +0.5981010, -0.5334330],
                [-0.5981010, +0.5981010, -0.5334330],
                [+0.5981010, -0.5981010, -0.5334330],
                [-0.5981010, -0.5981010, -0.5334330],
                [+0.5981010, +0.5334330, +0.5981010],
                [-0.5981010, +0.5334330, +0.5981010],
                [+0.5981010, -0.5334330, +0.5981010],
                [-0.5981010, -0.5334330, +0.5981010],
                [+0.5981010, +0.5334330, -0.5981010],
                [-0.5981010, +0.5334330, -0.5981010],
                [+0.5981010, -0.5334330, -0.5981010],
                [-0.5981010, -0.5334330, -0.5981010],
                [+0.5334330, +0.5981010, +0.5981010],
                [-0.5334330, +0.5981010, +0.5981010],
                [+0.5334330, -0.5981010, +0.5981010],
                [-0.5334330, -0.5981010, +0.5981010],
                [+0.5334330, +0.5981010, -0.5981010],
                [-0.5334330, +0.5981010, -0.5981010],
                [+0.5334330, -0.5981010, -0.5981010],
                [-0.5334330, -0.5981010, -0.5981010],
                [+0.6173990, +0.6173990, +0.4874800],
                [-0.6173990, +0.6173990, +0.4874800],
                [+0.6173990, -0.6173990, +0.4874800],
                [-0.6173990, -0.6173990, +0.4874800],
                [+0.6173990, +0.6173990, -0.4874800],
                [-0.6173990, +0.6173990, -0.4874800],
                [+0.6173990, -0.6173990, -0.4874800],
                [-0.6173990, -0.6173990, -0.4874800],
                [+0.6173990, +0.4874800, +0.6173990],
                [-0.6173990, +0.4874800, +0.6173990],
                [+0.6173990, -0.4874800, +0.6173990],
                [-0.6173990, -0.4874800, +0.6173990],
                [+0.6173990, +0.4874800, -0.6173990],
                [-0.6173990, +0.4874800, -0.6173990],
                [+0.6173990, -0.4874800, -0.6173990],
                [-0.6173990, -0.4874800, -0.6173990],
                [+0.4874800, +0.6173990, +0.6173990],
                [-0.4874800, +0.6173990, +0.6173990],
                [+0.4874800, -0.6173990, +0.6173990],
                [-0.4874800, -0.6173990, +0.6173990],
                [+0.4874800, +0.6173990, -0.6173990],
                [-0.4874800, +0.6173990, -0.6173990],
                [+0.4874800, -0.6173990, -0.6173990],
                [-0.4874800, -0.6173990, -0.6173990],
                [+0.6351370, +0.6351370, +0.4395490],
                [-0.6351370, +0.6351370, +0.4395490],
                [+0.6351370, -0.6351370, +0.4395490],
                [-0.6351370, -0.6351370, +0.4395490],
                [+0.6351370, +0.6351370, -0.4395490],
                [-0.6351370, +0.6351370, -0.4395490],
                [+0.6351370, -0.6351370, -0.4395490],
                [-0.6351370, -0.6351370, -0.4395490],
                [+0.6351370, +0.4395490, +0.6351370],
                [-0.6351370, +0.4395490, +0.6351370],
                [+0.6351370, -0.4395490, +0.6351370],
                [-0.6351370, -0.4395490, +0.6351370],
                [+0.6351370, +0.4395490, -0.6351370],
                [-0.6351370, +0.4395490, -0.6351370],
                [+0.6351370, -0.4395490, -0.6351370],
                [-0.6351370, -0.4395490, -0.6351370],
                [+0.4395490, +0.6351370, +0.6351370],
                [-0.4395490, +0.6351370, +0.6351370],
                [+0.4395490, -0.6351370, +0.6351370],
                [-0.4395490, -0.6351370, +0.6351370],
                [+0.4395490, +0.6351370, -0.6351370],
                [-0.4395490, +0.6351370, -0.6351370],
                [+0.4395490, -0.6351370, -0.6351370],
                [-0.4395490, -0.6351370, -0.6351370],
                [+0.6512010, +0.6512010, +0.3897110],
                [-0.6512010, +0.6512010, +0.3897110],
                [+0.6512010, -0.6512010, +0.3897110],
                [-0.6512010, -0.6512010, +0.3897110],
                [+0.6512010, +0.6512010, -0.3897110],
                [-0.6512010, +0.6512010, -0.3897110],
                [+0.6512010, -0.6512010, -0.3897110],
                [-0.6512010, -0.6512010, -0.3897110],
                [+0.6512010, +0.3897110, +0.6512010],
                [-0.6512010, +0.3897110, +0.6512010],
                [+0.6512010, -0.3897110, +0.6512010],
                [-0.6512010, -0.3897110, +0.6512010],
                [+0.6512010, +0.3897110, -0.6512010],
                [-0.6512010, +0.3897110, -0.6512010],
                [+0.6512010, -0.3897110, -0.6512010],
                [-0.6512010, -0.3897110, -0.6512010],
                [+0.3897110, +0.6512010, +0.6512010],
                [-0.3897110, +0.6512010, +0.6512010],
                [+0.3897110, -0.6512010, +0.6512010],
                [-0.3897110, -0.6512010, +0.6512010],
                [+0.3897110, +0.6512010, -0.6512010],
                [-0.3897110, +0.6512010, -0.6512010],
                [+0.3897110, -0.6512010, -0.6512010],
                [-0.3897110, -0.6512010, -0.6512010],
                [+0.6654760, +0.6654760, +0.3380590],
                [-0.6654760, +0.6654760, +0.3380590],
                [+0.6654760, -0.6654760, +0.3380590],
                [-0.6654760, -0.6654760, +0.3380590],
                [+0.6654760, +0.6654760, -0.3380590],
                [-0.6654760, +0.6654760, -0.3380590],
                [+0.6654760, -0.6654760, -0.3380590],
                [-0.6654760, -0.6654760, -0.3380590],
                [+0.6654760, +0.3380590, +0.6654760],
                [-0.6654760, +0.3380590, +0.6654760],
                [+0.6654760, -0.3380590, +0.6654760],
                [-0.6654760, -0.3380590, +0.6654760],
                [+0.6654760, +0.3380590, -0.6654760],
                [-0.6654760, +0.3380590, -0.6654760],
                [+0.6654760, -0.3380590, -0.6654760],
                [-0.6654760, -0.3380590, -0.6654760],
                [+0.3380590, +0.6654760, +0.6654760],
                [-0.3380590, +0.6654760, +0.6654760],
                [+0.3380590, -0.6654760, +0.6654760],
                [-0.3380590, -0.6654760, +0.6654760],
                [+0.3380590, +0.6654760, -0.6654760],
                [-0.3380590, +0.6654760, -0.6654760],
                [+0.3380590, -0.6654760, -0.6654760],
                [-0.3380590, -0.6654760, -0.6654760],
                [+0.6778410, +0.6778410, +0.2847160],
                [-0.6778410, +0.6778410, +0.2847160],
                [+0.6778410, -0.6778410, +0.2847160],
                [-0.6778410, -0.6778410, +0.2847160],
                [+0.6778410, +0.6778410, -0.2847160],
                [-0.6778410, +0.6778410, -0.2847160],
                [+0.6778410, -0.6778410, -0.2847160],
                [-0.6778410, -0.6778410, -0.2847160],
                [+0.6778410, +0.2847160, +0.6778410],
                [-0.6778410, +0.2847160, +0.6778410],
                [+0.6778410, -0.2847160, +0.6778410],
                [-0.6778410, -0.2847160, +0.6778410],
                [+0.6778410, +0.2847160, -0.6778410],
                [-0.6778410, +0.2847160, -0.6778410],
                [+0.6778410, -0.2847160, -0.6778410],
                [-0.6778410, -0.2847160, -0.6778410],
                [+0.2847160, +0.6778410, +0.6778410],
                [-0.2847160, +0.6778410, +0.6778410],
                [+0.2847160, -0.6778410, +0.6778410],
                [-0.2847160, -0.6778410, +0.6778410],
                [+0.2847160, +0.6778410, -0.6778410],
                [-0.2847160, +0.6778410, -0.6778410],
                [+0.2847160, -0.6778410, -0.6778410],
                [-0.2847160, -0.6778410, -0.6778410],
                [+0.6881760, +0.6881760, +0.2298420],
                [-0.6881760, +0.6881760, +0.2298420],
                [+0.6881760, -0.6881760, +0.2298420],
                [-0.6881760, -0.6881760, +0.2298420],
                [+0.6881760, +0.6881760, -0.2298420],
                [-0.6881760, +0.6881760, -0.2298420],
                [+0.6881760, -0.6881760, -0.2298420],
                [-0.6881760, -0.6881760, -0.2298420],
                [+0.6881760, +0.2298420, +0.6881760],
                [-0.6881760, +0.2298420, +0.6881760],
                [+0.6881760, -0.2298420, +0.6881760],
                [-0.6881760, -0.2298420, +0.6881760],
                [+0.6881760, +0.2298420, -0.6881760],
                [-0.6881760, +0.2298420, -0.6881760],
                [+0.6881760, -0.2298420, -0.6881760],
                [-0.6881760, -0.2298420, -0.6881760],
                [+0.2298420, +0.6881760, +0.6881760],
                [-0.2298420, +0.6881760, +0.6881760],
                [+0.2298420, -0.6881760, +0.6881760],
                [-0.2298420, -0.6881760, +0.6881760],
                [+0.2298420, +0.6881760, -0.6881760],
                [-0.2298420, +0.6881760, -0.6881760],
                [+0.2298420, -0.6881760, -0.6881760],
                [-0.2298420, -0.6881760, -0.6881760],
                [+0.6963650, +0.6963650, +0.1736460],
                [-0.6963650, +0.6963650, +0.1736460],
                [+0.6963650, -0.6963650, +0.1736460],
                [-0.6963650, -0.6963650, +0.1736460],
                [+0.6963650, +0.6963650, -0.1736460],
                [-0.6963650, +0.6963650, -0.1736460],
                [+0.6963650, -0.6963650, -0.1736460],
                [-0.6963650, -0.6963650, -0.1736460],
                [+0.6963650, +0.1736460, +0.6963650],
                [-0.6963650, +0.1736460, +0.6963650],
                [+0.6963650, -0.1736460, +0.6963650],
                [-0.6963650, -0.1736460, +0.6963650],
                [+0.6963650, +0.1736460, -0.6963650],
                [-0.6963650, +0.1736460, -0.6963650],
                [+0.6963650, -0.1736460, -0.6963650],
                [-0.6963650, -0.1736460, -0.6963650],
                [+0.1736460, +0.6963650, +0.6963650],
                [-0.1736460, +0.6963650, +0.6963650],
                [+0.1736460, -0.6963650, +0.6963650],
                [-0.1736460, -0.6963650, +0.6963650],
                [+0.1736460, +0.6963650, -0.6963650],
                [-0.1736460, +0.6963650, -0.6963650],
                [+0.1736460, -0.6963650, -0.6963650],
                [-0.1736460, -0.6963650, -0.6963650],
                [+0.7023010, +0.7023010, +0.1163890],
                [-0.7023010, +0.7023010, +0.1163890],
                [+0.7023010, -0.7023010, +0.1163890],
                [-0.7023010, -0.7023010, +0.1163890],
                [+0.7023010, +0.7023010, -0.1163890],
                [-0.7023010, +0.7023010, -0.1163890],
                [+0.7023010, -0.7023010, -0.1163890],
                [-0.7023010, -0.7023010, -0.1163890],
                [+0.7023010, +0.1163890, +0.7023010],
                [-0.7023010, +0.1163890, +0.7023010],
                [+0.7023010, -0.1163890, +0.7023010],
                [-0.7023010, -0.1163890, +0.7023010],
                [+0.7023010, +0.1163890, -0.7023010],
                [-0.7023010, +0.1163890, -0.7023010],
                [+0.7023010, -0.1163890, -0.7023010],
                [-0.7023010, -0.1163890, -0.7023010],
                [+0.1163890, +0.7023010, +0.7023010],
                [-0.1163890, +0.7023010, +0.7023010],
                [+0.1163890, -0.7023010, +0.7023010],
                [-0.1163890, -0.7023010, +0.7023010],
                [+0.1163890, +0.7023010, -0.7023010],
                [-0.1163890, +0.7023010, -0.7023010],
                [+0.1163890, -0.7023010, -0.7023010],
                [-0.1163890, -0.7023010, -0.7023010],
                [+0.7059000, +0.7059000, +0.0583872],
                [-0.7059000, +0.7059000, +0.0583872],
                [+0.7059000, -0.7059000, +0.0583872],
                [-0.7059000, -0.7059000, +0.0583872],
                [+0.7059000, +0.7059000, -0.0583872],
                [-0.7059000, +0.7059000, -0.0583872],
                [+0.7059000, -0.7059000, -0.0583872],
                [-0.7059000, -0.7059000, -0.0583872],
                [+0.7059000, +0.0583872, +0.7059000],
                [-0.7059000, +0.0583872, +0.7059000],
                [+0.7059000, -0.0583872, +0.7059000],
                [-0.7059000, -0.0583872, +0.7059000],
                [+0.7059000, +0.0583872, -0.7059000],
                [-0.7059000, +0.0583872, -0.7059000],
                [+0.7059000, -0.0583872, -0.7059000],
                [-0.7059000, -0.0583872, -0.7059000],
                [+0.0583872, +0.7059000, +0.7059000],
                [-0.0583872, +0.7059000, +0.7059000],
                [+0.0583872, -0.7059000, +0.7059000],
                [-0.0583872, -0.7059000, +0.7059000],
                [+0.0583872, +0.7059000, -0.7059000],
                [-0.0583872, +0.7059000, -0.7059000],
                [+0.0583872, -0.7059000, -0.7059000],
                [-0.0583872, -0.7059000, -0.7059000],
                [+0.0355247, +0.9993690, +0.0000000],
                [-0.0355247, +0.9993690, +0.0000000],
                [+0.0355247, -0.9993690, +0.0000000],
                [-0.0355247, -0.9993690, +0.0000000],
                [+0.9993690, +0.0355247, +0.0000000],
                [-0.9993690, +0.0355247, +0.0000000],
                [+0.9993690, -0.0355247, +0.0000000],
                [-0.9993690, -0.0355247, +0.0000000],
                [+0.0355247, +0.0000000, +0.9993690],
                [-0.0355247, +0.0000000, +0.9993690],
                [+0.0355247, +0.0000000, -0.9993690],
                [-0.0355247, +0.0000000, -0.9993690],
                [+0.9993690, +0.0000000, +0.0355247],
                [-0.9993690, +0.0000000, +0.0355247],
                [+0.9993690, +0.0000000, -0.0355247],
                [-0.9993690, +0.0000000, -0.0355247],
                [+0.0000000, +0.0355247, +0.9993690],
                [+0.0000000, -0.0355247, +0.9993690],
                [+0.0000000, +0.0355247, -0.9993690],
                [+0.0000000, -0.0355247, -0.9993690],
                [+0.0000000, +0.9993690, +0.0355247],
                [+0.0000000, -0.9993690, +0.0355247],
                [+0.0000000, +0.9993690, -0.0355247],
                [+0.0000000, -0.9993690, -0.0355247],
                [+0.0915118, +0.9958040, +0.0000000],
                [-0.0915118, +0.9958040, +0.0000000],
                [+0.0915118, -0.9958040, +0.0000000],
                [-0.0915118, -0.9958040, +0.0000000],
                [+0.9958040, +0.0915118, +0.0000000],
                [-0.9958040, +0.0915118, +0.0000000],
                [+0.9958040, -0.0915118, +0.0000000],
                [-0.9958040, -0.0915118, +0.0000000],
                [+0.0915118, +0.0000000, +0.9958040],
                [-0.0915118, +0.0000000, +0.9958040],
                [+0.0915118, +0.0000000, -0.9958040],
                [-0.0915118, +0.0000000, -0.9958040],
                [+0.9958040, +0.0000000, +0.0915118],
                [-0.9958040, +0.0000000, +0.0915118],
                [+0.9958040, +0.0000000, -0.0915118],
                [-0.9958040, +0.0000000, -0.0915118],
                [+0.0000000, +0.0915118, +0.9958040],
                [+0.0000000, -0.0915118, +0.9958040],
                [+0.0000000, +0.0915118, -0.9958040],
                [+0.0000000, -0.0915118, -0.9958040],
                [+0.0000000, +0.9958040, +0.0915118],
                [+0.0000000, -0.9958040, +0.0915118],
                [+0.0000000, +0.9958040, -0.0915118],
                [+0.0000000, -0.9958040, -0.0915118],
                [+0.1566200, +0.9876590, +0.0000000],
                [-0.1566200, +0.9876590, +0.0000000],
                [+0.1566200, -0.9876590, +0.0000000],
                [-0.1566200, -0.9876590, +0.0000000],
                [+0.9876590, +0.1566200, +0.0000000],
                [-0.9876590, +0.1566200, +0.0000000],
                [+0.9876590, -0.1566200, +0.0000000],
                [-0.9876590, -0.1566200, +0.0000000],
                [+0.1566200, +0.0000000, +0.9876590],
                [-0.1566200, +0.0000000, +0.9876590],
                [+0.1566200, +0.0000000, -0.9876590],
                [-0.1566200, +0.0000000, -0.9876590],
                [+0.9876590, +0.0000000, +0.1566200],
                [-0.9876590, +0.0000000, +0.1566200],
                [+0.9876590, +0.0000000, -0.1566200],
                [-0.9876590, +0.0000000, -0.1566200],
                [+0.0000000, +0.1566200, +0.9876590],
                [+0.0000000, -0.1566200, +0.9876590],
                [+0.0000000, +0.1566200, -0.9876590],
                [+0.0000000, -0.1566200, -0.9876590],
                [+0.0000000, +0.9876590, +0.1566200],
                [+0.0000000, -0.9876590, +0.1566200],
                [+0.0000000, +0.9876590, -0.1566200],
                [+0.0000000, -0.9876590, -0.1566200],
                [+0.2265470, +0.9740000, +0.0000000],
                [-0.2265470, +0.9740000, +0.0000000],
                [+0.2265470, -0.9740000, +0.0000000],
                [-0.2265470, -0.9740000, +0.0000000],
                [+0.9740000, +0.2265470, +0.0000000],
                [-0.9740000, +0.2265470, +0.0000000],
                [+0.9740000, -0.2265470, +0.0000000],
                [-0.9740000, -0.2265470, +0.0000000],
                [+0.2265470, +0.0000000, +0.9740000],
                [-0.2265470, +0.0000000, +0.9740000],
                [+0.2265470, +0.0000000, -0.9740000],
                [-0.2265470, +0.0000000, -0.9740000],
                [+0.9740000, +0.0000000, +0.2265470],
                [-0.9740000, +0.0000000, +0.2265470],
                [+0.9740000, +0.0000000, -0.2265470],
                [-0.9740000, +0.0000000, -0.2265470],
                [+0.0000000, +0.2265470, +0.9740000],
                [+0.0000000, -0.2265470, +0.9740000],
                [+0.0000000, +0.2265470, -0.9740000],
                [+0.0000000, -0.2265470, -0.9740000],
                [+0.0000000, +0.9740000, +0.2265470],
                [+0.0000000, -0.9740000, +0.2265470],
                [+0.0000000, +0.9740000, -0.2265470],
                [+0.0000000, -0.9740000, -0.2265470],
                [+0.2988240, +0.9543080, +0.0000000],
                [-0.2988240, +0.9543080, +0.0000000],
                [+0.2988240, -0.9543080, +0.0000000],
                [-0.2988240, -0.9543080, +0.0000000],
                [+0.9543080, +0.2988240, +0.0000000],
                [-0.9543080, +0.2988240, +0.0000000],
                [+0.9543080, -0.2988240, +0.0000000],
                [-0.9543080, -0.2988240, +0.0000000],
                [+0.2988240, +0.0000000, +0.9543080],
                [-0.2988240, +0.0000000, +0.9543080],
                [+0.2988240, +0.0000000, -0.9543080],
                [-0.2988240, +0.0000000, -0.9543080],
                [+0.9543080, +0.0000000, +0.2988240],
                [-0.9543080, +0.0000000, +0.2988240],
                [+0.9543080, +0.0000000, -0.2988240],
                [-0.9543080, +0.0000000, -0.2988240],
                [+0.0000000, +0.2988240, +0.9543080],
                [+0.0000000, -0.2988240, +0.9543080],
                [+0.0000000, +0.2988240, -0.9543080],
                [+0.0000000, -0.2988240, -0.9543080],
                [+0.0000000, +0.9543080, +0.2988240],
                [+0.0000000, -0.9543080, +0.2988240],
                [+0.0000000, +0.9543080, -0.2988240],
                [+0.0000000, -0.9543080, -0.2988240],
                [+0.3717480, +0.9283340, +0.0000000],
                [-0.3717480, +0.9283340, +0.0000000],
                [+0.3717480, -0.9283340, +0.0000000],
                [-0.3717480, -0.9283340, +0.0000000],
                [+0.9283340, +0.3717480, +0.0000000],
                [-0.9283340, +0.3717480, +0.0000000],
                [+0.9283340, -0.3717480, +0.0000000],
                [-0.9283340, -0.3717480, +0.0000000],
                [+0.3717480, +0.0000000, +0.9283340],
                [-0.3717480, +0.0000000, +0.9283340],
                [+0.3717480, +0.0000000, -0.9283340],
                [-0.3717480, +0.0000000, -0.9283340],
                [+0.9283340, +0.0000000, +0.3717480],
                [-0.9283340, +0.0000000, +0.3717480],
                [+0.9283340, +0.0000000, -0.3717480],
                [-0.9283340, +0.0000000, -0.3717480],
                [+0.0000000, +0.3717480, +0.9283340],
                [+0.0000000, -0.3717480, +0.9283340],
                [+0.0000000, +0.3717480, -0.9283340],
                [+0.0000000, -0.3717480, -0.9283340],
                [+0.0000000, +0.9283340, +0.3717480],
                [+0.0000000, -0.9283340, +0.3717480],
                [+0.0000000, +0.9283340, -0.3717480],
                [+0.0000000, -0.9283340, -0.3717480],
                [+0.4440090, +0.8960220, +0.0000000],
                [-0.4440090, +0.8960220, +0.0000000],
                [+0.4440090, -0.8960220, +0.0000000],
                [-0.4440090, -0.8960220, +0.0000000],
                [+0.8960220, +0.4440090, +0.0000000],
                [-0.8960220, +0.4440090, +0.0000000],
                [+0.8960220, -0.4440090, +0.0000000],
                [-0.8960220, -0.4440090, +0.0000000],
                [+0.4440090, +0.0000000, +0.8960220],
                [-0.4440090, +0.0000000, +0.8960220],
                [+0.4440090, +0.0000000, -0.8960220],
                [-0.4440090, +0.0000000, -0.8960220],
                [+0.8960220, +0.0000000, +0.4440090],
                [-0.8960220, +0.0000000, +0.4440090],
                [+0.8960220, +0.0000000, -0.4440090],
                [-0.8960220, +0.0000000, -0.4440090],
                [+0.0000000, +0.4440090, +0.8960220],
                [+0.0000000, -0.4440090, +0.8960220],
                [+0.0000000, +0.4440090, -0.8960220],
                [+0.0000000, -0.4440090, -0.8960220],
                [+0.0000000, +0.8960220, +0.4440090],
                [+0.0000000, -0.8960220, +0.4440090],
                [+0.0000000, +0.8960220, -0.4440090],
                [+0.0000000, -0.8960220, -0.4440090],
                [+0.5145340, +0.8574700, +0.0000000],
                [-0.5145340, +0.8574700, +0.0000000],
                [+0.5145340, -0.8574700, +0.0000000],
                [-0.5145340, -0.8574700, +0.0000000],
                [+0.8574700, +0.5145340, +0.0000000],
                [-0.8574700, +0.5145340, +0.0000000],
                [+0.8574700, -0.5145340, +0.0000000],
                [-0.8574700, -0.5145340, +0.0000000],
                [+0.5145340, +0.0000000, +0.8574700],
                [-0.5145340, +0.0000000, +0.8574700],
                [+0.5145340, +0.0000000, -0.8574700],
                [-0.5145340, +0.0000000, -0.8574700],
                [+0.8574700, +0.0000000, +0.5145340],
                [-0.8574700, +0.0000000, +0.5145340],
                [+0.8574700, +0.0000000, -0.5145340],
                [-0.8574700, +0.0000000, -0.5145340],
                [+0.0000000, +0.5145340, +0.8574700],
                [+0.0000000, -0.5145340, +0.8574700],
                [+0.0000000, +0.5145340, -0.8574700],
                [+0.0000000, -0.5145340, -0.8574700],
                [+0.0000000, +0.8574700, +0.5145340],
                [+0.0000000, -0.8574700, +0.5145340],
                [+0.0000000, +0.8574700, -0.5145340],
                [+0.0000000, -0.8574700, -0.5145340],
                [+0.5824050, +0.8128990, +0.0000000],
                [-0.5824050, +0.8128990, +0.0000000],
                [+0.5824050, -0.8128990, +0.0000000],
                [-0.5824050, -0.8128990, +0.0000000],
                [+0.8128990, +0.5824050, +0.0000000],
                [-0.8128990, +0.5824050, +0.0000000],
                [+0.8128990, -0.5824050, +0.0000000],
                [-0.8128990, -0.5824050, +0.0000000],
                [+0.5824050, +0.0000000, +0.8128990],
                [-0.5824050, +0.0000000, +0.8128990],
                [+0.5824050, +0.0000000, -0.8128990],
                [-0.5824050, +0.0000000, -0.8128990],
                [+0.8128990, +0.0000000, +0.5824050],
                [-0.8128990, +0.0000000, +0.5824050],
                [+0.8128990, +0.0000000, -0.5824050],
                [-0.8128990, +0.0000000, -0.5824050],
                [+0.0000000, +0.5824050, +0.8128990],
                [+0.0000000, -0.5824050, +0.8128990],
                [+0.0000000, +0.5824050, -0.8128990],
                [+0.0000000, -0.5824050, -0.8128990],
                [+0.0000000, +0.8128990, +0.5824050],
                [+0.0000000, -0.8128990, +0.5824050],
                [+0.0000000, +0.8128990, -0.5824050],
                [+0.0000000, -0.8128990, -0.5824050],
                [+0.6468280, +0.7626360, +0.0000000],
                [-0.6468280, +0.7626360, +0.0000000],
                [+0.6468280, -0.7626360, +0.0000000],
                [-0.6468280, -0.7626360, +0.0000000],
                [+0.7626360, +0.6468280, +0.0000000],
                [-0.7626360, +0.6468280, +0.0000000],
                [+0.7626360, -0.6468280, +0.0000000],
                [-0.7626360, -0.6468280, +0.0000000],
                [+0.6468280, +0.0000000, +0.7626360],
                [-0.6468280, +0.0000000, +0.7626360],
                [+0.6468280, +0.0000000, -0.7626360],
                [-0.6468280, +0.0000000, -0.7626360],
                [+0.7626360, +0.0000000, +0.6468280],
                [-0.7626360, +0.0000000, +0.6468280],
                [+0.7626360, +0.0000000, -0.6468280],
                [-0.7626360, +0.0000000, -0.6468280],
                [+0.0000000, +0.6468280, +0.7626360],
                [+0.0000000, -0.6468280, +0.7626360],
                [+0.0000000, +0.6468280, -0.7626360],
                [+0.0000000, -0.6468280, -0.7626360],
                [+0.0000000, +0.7626360, +0.6468280],
                [+0.0000000, -0.7626360, +0.6468280],
                [+0.0000000, +0.7626360, -0.6468280],
                [+0.0000000, -0.7626360, -0.6468280],
                [+0.0609596, +0.0178783, +0.9979800],
                [-0.0609596, +0.0178783, +0.9979800],
                [+0.0609596, -0.0178783, +0.9979800],
                [-0.0609596, -0.0178783, +0.9979800],
                [+0.0609596, +0.0178783, -0.9979800],
                [-0.0609596, +0.0178783, -0.9979800],
                [+0.0609596, -0.0178783, -0.9979800],
                [-0.0609596, -0.0178783, -0.9979800],
                [+0.0609596, +0.9979800, +0.0178783],
                [-0.0609596, +0.9979800, +0.0178783],
                [+0.0609596, -0.9979800, +0.0178783],
                [-0.0609596, -0.9979800, +0.0178783],
                [+0.0609596, +0.9979800, -0.0178783],
                [-0.0609596, +0.9979800, -0.0178783],
                [+0.0609596, -0.9979800, -0.0178783],
                [-0.0609596, -0.9979800, -0.0178783],
                [+0.0178783, +0.0609596, +0.9979800],
                [-0.0178783, +0.0609596, +0.9979800],
                [+0.0178783, -0.0609596, +0.9979800],
                [-0.0178783, -0.0609596, +0.9979800],
                [+0.0178783, +0.0609596, -0.9979800],
                [-0.0178783, +0.0609596, -0.9979800],
                [+0.0178783, -0.0609596, -0.9979800],
                [-0.0178783, -0.0609596, -0.9979800],
                [+0.0178783, +0.9979800, +0.0609596],
                [-0.0178783, +0.9979800, +0.0609596],
                [+0.0178783, -0.9979800, +0.0609596],
                [-0.0178783, -0.9979800, +0.0609596],
                [+0.0178783, +0.9979800, -0.0609596],
                [-0.0178783, +0.9979800, -0.0609596],
                [+0.0178783, -0.9979800, -0.0609596],
                [-0.0178783, -0.9979800, -0.0609596],
                [+0.9979800, +0.0609596, +0.0178783],
                [-0.9979800, +0.0609596, +0.0178783],
                [+0.9979800, -0.0609596, +0.0178783],
                [-0.9979800, -0.0609596, +0.0178783],
                [+0.9979800, +0.0609596, -0.0178783],
                [-0.9979800, +0.0609596, -0.0178783],
                [+0.9979800, -0.0609596, -0.0178783],
                [-0.9979800, -0.0609596, -0.0178783],
                [+0.9979800, +0.0178783, +0.0609596],
                [-0.9979800, +0.0178783, +0.0609596],
                [+0.9979800, -0.0178783, +0.0609596],
                [-0.9979800, -0.0178783, +0.0609596],
                [+0.9979800, +0.0178783, -0.0609596],
                [-0.9979800, +0.0178783, -0.0609596],
                [+0.9979800, -0.0178783, -0.0609596],
                [-0.9979800, -0.0178783, -0.0609596],
                [+0.0881196, +0.0395389, +0.9953250],
                [-0.0881196, +0.0395389, +0.9953250],
                [+0.0881196, -0.0395389, +0.9953250],
                [-0.0881196, -0.0395389, +0.9953250],
                [+0.0881196, +0.0395389, -0.9953250],
                [-0.0881196, +0.0395389, -0.9953250],
                [+0.0881196, -0.0395389, -0.9953250],
                [-0.0881196, -0.0395389, -0.9953250],
                [+0.0881196, +0.9953250, +0.0395389],
                [-0.0881196, +0.9953250, +0.0395389],
                [+0.0881196, -0.9953250, +0.0395389],
                [-0.0881196, -0.9953250, +0.0395389],
                [+0.0881196, +0.9953250, -0.0395389],
                [-0.0881196, +0.9953250, -0.0395389],
                [+0.0881196, -0.9953250, -0.0395389],
                [-0.0881196, -0.9953250, -0.0395389],
                [+0.0395389, +0.0881196, +0.9953250],
                [-0.0395389, +0.0881196, +0.9953250],
                [+0.0395389, -0.0881196, +0.9953250],
                [-0.0395389, -0.0881196, +0.9953250],
                [+0.0395389, +0.0881196, -0.9953250],
                [-0.0395389, +0.0881196, -0.9953250],
                [+0.0395389, -0.0881196, -0.9953250],
                [-0.0395389, -0.0881196, -0.9953250],
                [+0.0395389, +0.9953250, +0.0881196],
                [-0.0395389, +0.9953250, +0.0881196],
                [+0.0395389, -0.9953250, +0.0881196],
                [-0.0395389, -0.9953250, +0.0881196],
                [+0.0395389, +0.9953250, -0.0881196],
                [-0.0395389, +0.9953250, -0.0881196],
                [+0.0395389, -0.9953250, -0.0881196],
                [-0.0395389, -0.9953250, -0.0881196],
                [+0.9953250, +0.0881196, +0.0395389],
                [-0.9953250, +0.0881196, +0.0395389],
                [+0.9953250, -0.0881196, +0.0395389],
                [-0.9953250, -0.0881196, +0.0395389],
                [+0.9953250, +0.0881196, -0.0395389],
                [-0.9953250, +0.0881196, -0.0395389],
                [+0.9953250, -0.0881196, -0.0395389],
                [-0.9953250, -0.0881196, -0.0395389],
                [+0.9953250, +0.0395389, +0.0881196],
                [-0.9953250, +0.0395389, +0.0881196],
                [+0.9953250, -0.0395389, +0.0881196],
                [-0.9953250, -0.0395389, +0.0881196],
                [+0.9953250, +0.0395389, -0.0881196],
                [-0.9953250, +0.0395389, -0.0881196],
                [+0.9953250, -0.0395389, -0.0881196],
                [-0.9953250, -0.0395389, -0.0881196],
                [+0.1165940, +0.0637812, +0.9911300],
                [-0.1165940, +0.0637812, +0.9911300],
                [+0.1165940, -0.0637812, +0.9911300],
                [-0.1165940, -0.0637812, +0.9911300],
                [+0.1165940, +0.0637812, -0.9911300],
                [-0.1165940, +0.0637812, -0.9911300],
                [+0.1165940, -0.0637812, -0.9911300],
                [-0.1165940, -0.0637812, -0.9911300],
                [+0.1165940, +0.9911300, +0.0637812],
                [-0.1165940, +0.9911300, +0.0637812],
                [+0.1165940, -0.9911300, +0.0637812],
                [-0.1165940, -0.9911300, +0.0637812],
                [+0.1165940, +0.9911300, -0.0637812],
                [-0.1165940, +0.9911300, -0.0637812],
                [+0.1165940, -0.9911300, -0.0637812],
                [-0.1165940, -0.9911300, -0.0637812],
                [+0.0637812, +0.1165940, +0.9911300],
                [-0.0637812, +0.1165940, +0.9911300],
                [+0.0637812, -0.1165940, +0.9911300],
                [-0.0637812, -0.1165940, +0.9911300],
                [+0.0637812, +0.1165940, -0.9911300],
                [-0.0637812, +0.1165940, -0.9911300],
                [+0.0637812, -0.1165940, -0.9911300],
                [-0.0637812, -0.1165940, -0.9911300],
                [+0.0637812, +0.9911300, +0.1165940],
                [-0.0637812, +0.9911300, +0.1165940],
                [+0.0637812, -0.9911300, +0.1165940],
                [-0.0637812, -0.9911300, +0.1165940],
                [+0.0637812, +0.9911300, -0.1165940],
                [-0.0637812, +0.9911300, -0.1165940],
                [+0.0637812, -0.9911300, -0.1165940],
                [-0.0637812, -0.9911300, -0.1165940],
                [+0.9911300, +0.1165940, +0.0637812],
                [-0.9911300, +0.1165940, +0.0637812],
                [+0.9911300, -0.1165940, +0.0637812],
                [-0.9911300, -0.1165940, +0.0637812],
                [+0.9911300, +0.1165940, -0.0637812],
                [-0.9911300, +0.1165940, -0.0637812],
                [+0.9911300, -0.1165940, -0.0637812],
                [-0.9911300, -0.1165940, -0.0637812],
                [+0.9911300, +0.0637812, +0.1165940],
                [-0.9911300, +0.0637812, +0.1165940],
                [+0.9911300, -0.0637812, +0.1165940],
                [-0.9911300, -0.0637812, +0.1165940],
                [+0.9911300, +0.0637812, -0.1165940],
                [-0.9911300, +0.0637812, -0.1165940],
                [+0.9911300, -0.0637812, -0.1165940],
                [-0.9911300, -0.0637812, -0.1165940],
                [+0.1460230, +0.0898589, +0.9851920],
                [-0.1460230, +0.0898589, +0.9851920],
                [+0.1460230, -0.0898589, +0.9851920],
                [-0.1460230, -0.0898589, +0.9851920],
                [+0.1460230, +0.0898589, -0.9851920],
                [-0.1460230, +0.0898589, -0.9851920],
                [+0.1460230, -0.0898589, -0.9851920],
                [-0.1460230, -0.0898589, -0.9851920],
                [+0.1460230, +0.9851920, +0.0898589],
                [-0.1460230, +0.9851920, +0.0898589],
                [+0.1460230, -0.9851920, +0.0898589],
                [-0.1460230, -0.9851920, +0.0898589],
                [+0.1460230, +0.9851920, -0.0898589],
                [-0.1460230, +0.9851920, -0.0898589],
                [+0.1460230, -0.9851920, -0.0898589],
                [-0.1460230, -0.9851920, -0.0898589],
                [+0.0898589, +0.1460230, +0.9851920],
                [-0.0898589, +0.1460230, +0.9851920],
                [+0.0898589, -0.1460230, +0.9851920],
                [-0.0898589, -0.1460230, +0.9851920],
                [+0.0898589, +0.1460230, -0.9851920],
                [-0.0898589, +0.1460230, -0.9851920],
                [+0.0898589, -0.1460230, -0.9851920],
                [-0.0898589, -0.1460230, -0.9851920],
                [+0.0898589, +0.9851920, +0.1460230],
                [-0.0898589, +0.9851920, +0.1460230],
                [+0.0898589, -0.9851920, +0.1460230],
                [-0.0898589, -0.9851920, +0.1460230],
                [+0.0898589, +0.9851920, -0.1460230],
                [-0.0898589, +0.9851920, -0.1460230],
                [+0.0898589, -0.9851920, -0.1460230],
                [-0.0898589, -0.9851920, -0.1460230],
                [+0.9851920, +0.1460230, +0.0898589],
                [-0.9851920, +0.1460230, +0.0898589],
                [+0.9851920, -0.1460230, +0.0898589],
                [-0.9851920, -0.1460230, +0.0898589],
                [+0.9851920, +0.1460230, -0.0898589],
                [-0.9851920, +0.1460230, -0.0898589],
                [+0.9851920, -0.1460230, -0.0898589],
                [-0.9851920, -0.1460230, -0.0898589],
                [+0.9851920, +0.0898589, +0.1460230],
                [-0.9851920, +0.0898589, +0.1460230],
                [+0.9851920, -0.0898589, +0.1460230],
                [-0.9851920, -0.0898589, +0.1460230],
                [+0.9851920, +0.0898589, -0.1460230],
                [-0.9851920, +0.0898589, -0.1460230],
                [+0.9851920, -0.0898589, -0.1460230],
                [-0.9851920, -0.0898589, -0.1460230],
                [+0.1761200, +0.1172610, +0.9773600],
                [-0.1761200, +0.1172610, +0.9773600],
                [+0.1761200, -0.1172610, +0.9773600],
                [-0.1761200, -0.1172610, +0.9773600],
                [+0.1761200, +0.1172610, -0.9773600],
                [-0.1761200, +0.1172610, -0.9773600],
                [+0.1761200, -0.1172610, -0.9773600],
                [-0.1761200, -0.1172610, -0.9773600],
                [+0.1761200, +0.9773600, +0.1172610],
                [-0.1761200, +0.9773600, +0.1172610],
                [+0.1761200, -0.9773600, +0.1172610],
                [-0.1761200, -0.9773600, +0.1172610],
                [+0.1761200, +0.9773600, -0.1172610],
                [-0.1761200, +0.9773600, -0.1172610],
                [+0.1761200, -0.9773600, -0.1172610],
                [-0.1761200, -0.9773600, -0.1172610],
                [+0.1172610, +0.1761200, +0.9773600],
                [-0.1172610, +0.1761200, +0.9773600],
                [+0.1172610, -0.1761200, +0.9773600],
                [-0.1172610, -0.1761200, +0.9773600],
                [+0.1172610, +0.1761200, -0.9773600],
                [-0.1172610, +0.1761200, -0.9773600],
                [+0.1172610, -0.1761200, -0.9773600],
                [-0.1172610, -0.1761200, -0.9773600],
                [+0.1172610, +0.9773600, +0.1761200],
                [-0.1172610, +0.9773600, +0.1761200],
                [+0.1172610, -0.9773600, +0.1761200],
                [-0.1172610, -0.9773600, +0.1761200],
                [+0.1172610, +0.9773600, -0.1761200],
                [-0.1172610, +0.9773600, -0.1761200],
                [+0.1172610, -0.9773600, -0.1761200],
                [-0.1172610, -0.9773600, -0.1761200],
                [+0.9773600, +0.1761200, +0.1172610],
                [-0.9773600, +0.1761200, +0.1172610],
                [+0.9773600, -0.1761200, +0.1172610],
                [-0.9773600, -0.1761200, +0.1172610],
                [+0.9773600, +0.1761200, -0.1172610],
                [-0.9773600, +0.1761200, -0.1172610],
                [+0.9773600, -0.1761200, -0.1172610],
                [-0.9773600, -0.1761200, -0.1172610],
                [+0.9773600, +0.1172610, +0.1761200],
                [-0.9773600, +0.1172610, +0.1761200],
                [+0.9773600, -0.1172610, +0.1761200],
                [-0.9773600, -0.1172610, +0.1761200],
                [+0.9773600, +0.1172610, -0.1761200],
                [-0.9773600, +0.1172610, -0.1761200],
                [+0.9773600, -0.1172610, -0.1761200],
                [-0.9773600, -0.1172610, -0.1761200],
                [+0.2066470, +0.1456100, +0.9675200],
                [-0.2066470, +0.1456100, +0.9675200],
                [+0.2066470, -0.1456100, +0.9675200],
                [-0.2066470, -0.1456100, +0.9675200],
                [+0.2066470, +0.1456100, -0.9675200],
                [-0.2066470, +0.1456100, -0.9675200],
                [+0.2066470, -0.1456100, -0.9675200],
                [-0.2066470, -0.1456100, -0.9675200],
                [+0.2066470, +0.9675200, +0.1456100],
                [-0.2066470, +0.9675200, +0.1456100],
                [+0.2066470, -0.9675200, +0.1456100],
                [-0.2066470, -0.9675200, +0.1456100],
                [+0.2066470, +0.9675200, -0.1456100],
                [-0.2066470, +0.9675200, -0.1456100],
                [+0.2066470, -0.9675200, -0.1456100],
                [-0.2066470, -0.9675200, -0.1456100],
                [+0.1456100, +0.2066470, +0.9675200],
                [-0.1456100, +0.2066470, +0.9675200],
                [+0.1456100, -0.2066470, +0.9675200],
                [-0.1456100, -0.2066470, +0.9675200],
                [+0.1456100, +0.2066470, -0.9675200],
                [-0.1456100, +0.2066470, -0.9675200],
                [+0.1456100, -0.2066470, -0.9675200],
                [-0.1456100, -0.2066470, -0.9675200],
                [+0.1456100, +0.9675200, +0.2066470],
                [-0.1456100, +0.9675200, +0.2066470],
                [+0.1456100, -0.9675200, +0.2066470],
                [-0.1456100, -0.9675200, +0.2066470],
                [+0.1456100, +0.9675200, -0.2066470],
                [-0.1456100, +0.9675200, -0.2066470],
                [+0.1456100, -0.9675200, -0.2066470],
                [-0.1456100, -0.9675200, -0.2066470],
                [+0.9675200, +0.2066470, +0.1456100],
                [-0.9675200, +0.2066470, +0.1456100],
                [+0.9675200, -0.2066470, +0.1456100],
                [-0.9675200, -0.2066470, +0.1456100],
                [+0.9675200, +0.2066470, -0.1456100],
                [-0.9675200, +0.2066470, -0.1456100],
                [+0.9675200, -0.2066470, -0.1456100],
                [-0.9675200, -0.2066470, -0.1456100],
                [+0.9675200, +0.1456100, +0.2066470],
                [-0.9675200, +0.1456100, +0.2066470],
                [+0.9675200, -0.1456100, +0.2066470],
                [-0.9675200, -0.1456100, +0.2066470],
                [+0.9675200, +0.1456100, -0.2066470],
                [-0.9675200, +0.1456100, -0.2066470],
                [+0.9675200, -0.1456100, -0.2066470],
                [-0.9675200, -0.1456100, -0.2066470],
                [+0.2374080, +0.1746150, +0.9555870],
                [-0.2374080, +0.1746150, +0.9555870],
                [+0.2374080, -0.1746150, +0.9555870],
                [-0.2374080, -0.1746150, +0.9555870],
                [+0.2374080, +0.1746150, -0.9555870],
                [-0.2374080, +0.1746150, -0.9555870],
                [+0.2374080, -0.1746150, -0.9555870],
                [-0.2374080, -0.1746150, -0.9555870],
                [+0.2374080, +0.9555870, +0.1746150],
                [-0.2374080, +0.9555870, +0.1746150],
                [+0.2374080, -0.9555870, +0.1746150],
                [-0.2374080, -0.9555870, +0.1746150],
                [+0.2374080, +0.9555870, -0.1746150],
                [-0.2374080, +0.9555870, -0.1746150],
                [+0.2374080, -0.9555870, -0.1746150],
                [-0.2374080, -0.9555870, -0.1746150],
                [+0.1746150, +0.2374080, +0.9555870],
                [-0.1746150, +0.2374080, +0.9555870],
                [+0.1746150, -0.2374080, +0.9555870],
                [-0.1746150, -0.2374080, +0.9555870],
                [+0.1746150, +0.2374080, -0.9555870],
                [-0.1746150, +0.2374080, -0.9555870],
                [+0.1746150, -0.2374080, -0.9555870],
                [-0.1746150, -0.2374080, -0.9555870],
                [+0.1746150, +0.9555870, +0.2374080],
                [-0.1746150, +0.9555870, +0.2374080],
                [+0.1746150, -0.9555870, +0.2374080],
                [-0.1746150, -0.9555870, +0.2374080],
                [+0.1746150, +0.9555870, -0.2374080],
                [-0.1746150, +0.9555870, -0.2374080],
                [+0.1746150, -0.9555870, -0.2374080],
                [-0.1746150, -0.9555870, -0.2374080],
                [+0.9555870, +0.2374080, +0.1746150],
                [-0.9555870, +0.2374080, +0.1746150],
                [+0.9555870, -0.2374080, +0.1746150],
                [-0.9555870, -0.2374080, +0.1746150],
                [+0.9555870, +0.2374080, -0.1746150],
                [-0.9555870, +0.2374080, -0.1746150],
                [+0.9555870, -0.2374080, -0.1746150],
                [-0.9555870, -0.2374080, -0.1746150],
                [+0.9555870, +0.1746150, +0.2374080],
                [-0.9555870, +0.1746150, +0.2374080],
                [+0.9555870, -0.1746150, +0.2374080],
                [-0.9555870, -0.1746150, +0.2374080],
                [+0.9555870, +0.1746150, -0.2374080],
                [-0.9555870, +0.1746150, -0.2374080],
                [+0.9555870, -0.1746150, -0.2374080],
                [-0.9555870, -0.1746150, -0.2374080],
                [+0.2682310, +0.2040380, +0.9414990],
                [-0.2682310, +0.2040380, +0.9414990],
                [+0.2682310, -0.2040380, +0.9414990],
                [-0.2682310, -0.2040380, +0.9414990],
                [+0.2682310, +0.2040380, -0.9414990],
                [-0.2682310, +0.2040380, -0.9414990],
                [+0.2682310, -0.2040380, -0.9414990],
                [-0.2682310, -0.2040380, -0.9414990],
                [+0.2682310, +0.9414990, +0.2040380],
                [-0.2682310, +0.9414990, +0.2040380],
                [+0.2682310, -0.9414990, +0.2040380],
                [-0.2682310, -0.9414990, +0.2040380],
                [+0.2682310, +0.9414990, -0.2040380],
                [-0.2682310, +0.9414990, -0.2040380],
                [+0.2682310, -0.9414990, -0.2040380],
                [-0.2682310, -0.9414990, -0.2040380],
                [+0.2040380, +0.2682310, +0.9414990],
                [-0.2040380, +0.2682310, +0.9414990],
                [+0.2040380, -0.2682310, +0.9414990],
                [-0.2040380, -0.2682310, +0.9414990],
                [+0.2040380, +0.2682310, -0.9414990],
                [-0.2040380, +0.2682310, -0.9414990],
                [+0.2040380, -0.2682310, -0.9414990],
                [-0.2040380, -0.2682310, -0.9414990],
                [+0.2040380, +0.9414990, +0.2682310],
                [-0.2040380, +0.9414990, +0.2682310],
                [+0.2040380, -0.9414990, +0.2682310],
                [-0.2040380, -0.9414990, +0.2682310],
                [+0.2040380, +0.9414990, -0.2682310],
                [-0.2040380, +0.9414990, -0.2682310],
                [+0.2040380, -0.9414990, -0.2682310],
                [-0.2040380, -0.9414990, -0.2682310],
                [+0.9414990, +0.2682310, +0.2040380],
                [-0.9414990, +0.2682310, +0.2040380],
                [+0.9414990, -0.2682310, +0.2040380],
                [-0.9414990, -0.2682310, +0.2040380],
                [+0.9414990, +0.2682310, -0.2040380],
                [-0.9414990, +0.2682310, -0.2040380],
                [+0.9414990, -0.2682310, -0.2040380],
                [-0.9414990, -0.2682310, -0.2040380],
                [+0.9414990, +0.2040380, +0.2682310],
                [-0.9414990, +0.2040380, +0.2682310],
                [+0.9414990, -0.2040380, +0.2682310],
                [-0.9414990, -0.2040380, +0.2682310],
                [+0.9414990, +0.2040380, -0.2682310],
                [-0.9414990, +0.2040380, -0.2682310],
                [+0.9414990, -0.2040380, -0.2682310],
                [-0.9414990, -0.2040380, -0.2682310],
                [+0.2989650, +0.2336790, +0.9252100],
                [-0.2989650, +0.2336790, +0.9252100],
                [+0.2989650, -0.2336790, +0.9252100],
                [-0.2989650, -0.2336790, +0.9252100],
                [+0.2989650, +0.2336790, -0.9252100],
                [-0.2989650, +0.2336790, -0.9252100],
                [+0.2989650, -0.2336790, -0.9252100],
                [-0.2989650, -0.2336790, -0.9252100],
                [+0.2989650, +0.9252100, +0.2336790],
                [-0.2989650, +0.9252100, +0.2336790],
                [+0.2989650, -0.9252100, +0.2336790],
                [-0.2989650, -0.9252100, +0.2336790],
                [+0.2989650, +0.9252100, -0.2336790],
                [-0.2989650, +0.9252100, -0.2336790],
                [+0.2989650, -0.9252100, -0.2336790],
                [-0.2989650, -0.9252100, -0.2336790],
                [+0.2336790, +0.2989650, +0.9252100],
                [-0.2336790, +0.2989650, +0.9252100],
                [+0.2336790, -0.2989650, +0.9252100],
                [-0.2336790, -0.2989650, +0.9252100],
                [+0.2336790, +0.2989650, -0.9252100],
                [-0.2336790, +0.2989650, -0.9252100],
                [+0.2336790, -0.2989650, -0.9252100],
                [-0.2336790, -0.2989650, -0.9252100],
                [+0.2336790, +0.9252100, +0.2989650],
                [-0.2336790, +0.9252100, +0.2989650],
                [+0.2336790, -0.9252100, +0.2989650],
                [-0.2336790, -0.9252100, +0.2989650],
                [+0.2336790, +0.9252100, -0.2989650],
                [-0.2336790, +0.9252100, -0.2989650],
                [+0.2336790, -0.9252100, -0.2989650],
                [-0.2336790, -0.9252100, -0.2989650],
                [+0.9252100, +0.2989650, +0.2336790],
                [-0.9252100, +0.2989650, +0.2336790],
                [+0.9252100, -0.2989650, +0.2336790],
                [-0.9252100, -0.2989650, +0.2336790],
                [+0.9252100, +0.2989650, -0.2336790],
                [-0.9252100, +0.2989650, -0.2336790],
                [+0.9252100, -0.2989650, -0.2336790],
                [-0.9252100, -0.2989650, -0.2336790],
                [+0.9252100, +0.2336790, +0.2989650],
                [-0.9252100, +0.2336790, +0.2989650],
                [+0.9252100, -0.2336790, +0.2989650],
                [-0.9252100, -0.2336790, +0.2989650],
                [+0.9252100, +0.2336790, -0.2989650],
                [-0.9252100, +0.2336790, -0.2989650],
                [+0.9252100, -0.2336790, -0.2989650],
                [-0.9252100, -0.2336790, -0.2989650],
                [+0.3294760, +0.2633630, +0.9066890],
                [-0.3294760, +0.2633630, +0.9066890],
                [+0.3294760, -0.2633630, +0.9066890],
                [-0.3294760, -0.2633630, +0.9066890],
                [+0.3294760, +0.2633630, -0.9066890],
                [-0.3294760, +0.2633630, -0.9066890],
                [+0.3294760, -0.2633630, -0.9066890],
                [-0.3294760, -0.2633630, -0.9066890],
                [+0.3294760, +0.9066890, +0.2633630],
                [-0.3294760, +0.9066890, +0.2633630],
                [+0.3294760, -0.9066890, +0.2633630],
                [-0.3294760, -0.9066890, +0.2633630],
                [+0.3294760, +0.9066890, -0.2633630],
                [-0.3294760, +0.9066890, -0.2633630],
                [+0.3294760, -0.9066890, -0.2633630],
                [-0.3294760, -0.9066890, -0.2633630],
                [+0.2633630, +0.3294760, +0.9066890],
                [-0.2633630, +0.3294760, +0.9066890],
                [+0.2633630, -0.3294760, +0.9066890],
                [-0.2633630, -0.3294760, +0.9066890],
                [+0.2633630, +0.3294760, -0.9066890],
                [-0.2633630, +0.3294760, -0.9066890],
                [+0.2633630, -0.3294760, -0.9066890],
                [-0.2633630, -0.3294760, -0.9066890],
                [+0.2633630, +0.9066890, +0.3294760],
                [-0.2633630, +0.9066890, +0.3294760],
                [+0.2633630, -0.9066890, +0.3294760],
                [-0.2633630, -0.9066890, +0.3294760],
                [+0.2633630, +0.9066890, -0.3294760],
                [-0.2633630, +0.9066890, -0.3294760],
                [+0.2633630, -0.9066890, -0.3294760],
                [-0.2633630, -0.9066890, -0.3294760],
                [+0.9066890, +0.3294760, +0.2633630],
                [-0.9066890, +0.3294760, +0.2633630],
                [+0.9066890, -0.3294760, +0.2633630],
                [-0.9066890, -0.3294760, +0.2633630],
                [+0.9066890, +0.3294760, -0.2633630],
                [-0.9066890, +0.3294760, -0.2633630],
                [+0.9066890, -0.3294760, -0.2633630],
                [-0.9066890, -0.3294760, -0.2633630],
                [+0.9066890, +0.2633630, +0.3294760],
                [-0.9066890, +0.2633630, +0.3294760],
                [+0.9066890, -0.2633630, +0.3294760],
                [-0.9066890, -0.2633630, +0.3294760],
                [+0.9066890, +0.2633630, -0.3294760],
                [-0.9066890, +0.2633630, -0.3294760],
                [+0.9066890, -0.2633630, -0.3294760],
                [-0.9066890, -0.2633630, -0.3294760],
                [+0.3596390, +0.2929370, +0.8859160],
                [-0.3596390, +0.2929370, +0.8859160],
                [+0.3596390, -0.2929370, +0.8859160],
                [-0.3596390, -0.2929370, +0.8859160],
                [+0.3596390, +0.2929370, -0.8859160],
                [-0.3596390, +0.2929370, -0.8859160],
                [+0.3596390, -0.2929370, -0.8859160],
                [-0.3596390, -0.2929370, -0.8859160],
                [+0.3596390, +0.8859160, +0.2929370],
                [-0.3596390, +0.8859160, +0.2929370],
                [+0.3596390, -0.8859160, +0.2929370],
                [-0.3596390, -0.8859160, +0.2929370],
                [+0.3596390, +0.8859160, -0.2929370],
                [-0.3596390, +0.8859160, -0.2929370],
                [+0.3596390, -0.8859160, -0.2929370],
                [-0.3596390, -0.8859160, -0.2929370],
                [+0.2929370, +0.3596390, +0.8859160],
                [-0.2929370, +0.3596390, +0.8859160],
                [+0.2929370, -0.3596390, +0.8859160],
                [-0.2929370, -0.3596390, +0.8859160],
                [+0.2929370, +0.3596390, -0.8859160],
                [-0.2929370, +0.3596390, -0.8859160],
                [+0.2929370, -0.3596390, -0.8859160],
                [-0.2929370, -0.3596390, -0.8859160],
                [+0.2929370, +0.8859160, +0.3596390],
                [-0.2929370, +0.8859160, +0.3596390],
                [+0.2929370, -0.8859160, +0.3596390],
                [-0.2929370, -0.8859160, +0.3596390],
                [+0.2929370, +0.8859160, -0.3596390],
                [-0.2929370, +0.8859160, -0.3596390],
                [+0.2929370, -0.8859160, -0.3596390],
                [-0.2929370, -0.8859160, -0.3596390],
                [+0.8859160, +0.3596390, +0.2929370],
                [-0.8859160, +0.3596390, +0.2929370],
                [+0.8859160, -0.3596390, +0.2929370],
                [-0.8859160, -0.3596390, +0.2929370],
                [+0.8859160, +0.3596390, -0.2929370],
                [-0.8859160, +0.3596390, -0.2929370],
                [+0.8859160, -0.3596390, -0.2929370],
                [-0.8859160, -0.3596390, -0.2929370],
                [+0.8859160, +0.2929370, +0.3596390],
                [-0.8859160, +0.2929370, +0.3596390],
                [+0.8859160, -0.2929370, +0.3596390],
                [-0.8859160, -0.2929370, +0.3596390],
                [+0.8859160, +0.2929370, -0.3596390],
                [-0.8859160, +0.2929370, -0.3596390],
                [+0.8859160, -0.2929370, -0.3596390],
                [-0.8859160, -0.2929370, -0.3596390],
                [+0.3893380, +0.3222590, +0.8628820],
                [-0.3893380, +0.3222590, +0.8628820],
                [+0.3893380, -0.3222590, +0.8628820],
                [-0.3893380, -0.3222590, +0.8628820],
                [+0.3893380, +0.3222590, -0.8628820],
                [-0.3893380, +0.3222590, -0.8628820],
                [+0.3893380, -0.3222590, -0.8628820],
                [-0.3893380, -0.3222590, -0.8628820],
                [+0.3893380, +0.8628820, +0.3222590],
                [-0.3893380, +0.8628820, +0.3222590],
                [+0.3893380, -0.8628820, +0.3222590],
                [-0.3893380, -0.8628820, +0.3222590],
                [+0.3893380, +0.8628820, -0.3222590],
                [-0.3893380, +0.8628820, -0.3222590],
                [+0.3893380, -0.8628820, -0.3222590],
                [-0.3893380, -0.8628820, -0.3222590],
                [+0.3222590, +0.3893380, +0.8628820],
                [-0.3222590, +0.3893380, +0.8628820],
                [+0.3222590, -0.3893380, +0.8628820],
                [-0.3222590, -0.3893380, +0.8628820],
                [+0.3222590, +0.3893380, -0.8628820],
                [-0.3222590, +0.3893380, -0.8628820],
                [+0.3222590, -0.3893380, -0.8628820],
                [-0.3222590, -0.3893380, -0.8628820],
                [+0.3222590, +0.8628820, +0.3893380],
                [-0.3222590, +0.8628820, +0.3893380],
                [+0.3222590, -0.8628820, +0.3893380],
                [-0.3222590, -0.8628820, +0.3893380],
                [+0.3222590, +0.8628820, -0.3893380],
                [-0.3222590, +0.8628820, -0.3893380],
                [+0.3222590, -0.8628820, -0.3893380],
                [-0.3222590, -0.8628820, -0.3893380],
                [+0.8628820, +0.3893380, +0.3222590],
                [-0.8628820, +0.3893380, +0.3222590],
                [+0.8628820, -0.3893380, +0.3222590],
                [-0.8628820, -0.3893380, +0.3222590],
                [+0.8628820, +0.3893380, -0.3222590],
                [-0.8628820, +0.3893380, -0.3222590],
                [+0.8628820, -0.3893380, -0.3222590],
                [-0.8628820, -0.3893380, -0.3222590],
                [+0.8628820, +0.3222590, +0.3893380],
                [-0.8628820, +0.3222590, +0.3893380],
                [+0.8628820, -0.3222590, +0.3893380],
                [-0.8628820, -0.3222590, +0.3893380],
                [+0.8628820, +0.3222590, -0.3893380],
                [-0.8628820, +0.3222590, -0.3893380],
                [+0.8628820, -0.3222590, -0.3893380],
                [-0.8628820, -0.3222590, -0.3893380],
                [+0.4184650, +0.3512000, +0.8375830],
                [-0.4184650, +0.3512000, +0.8375830],
                [+0.4184650, -0.3512000, +0.8375830],
                [-0.4184650, -0.3512000, +0.8375830],
                [+0.4184650, +0.3512000, -0.8375830],
                [-0.4184650, +0.3512000, -0.8375830],
                [+0.4184650, -0.3512000, -0.8375830],
                [-0.4184650, -0.3512000, -0.8375830],
                [+0.4184650, +0.8375830, +0.3512000],
                [-0.4184650, +0.8375830, +0.3512000],
                [+0.4184650, -0.8375830, +0.3512000],
                [-0.4184650, -0.8375830, +0.3512000],
                [+0.4184650, +0.8375830, -0.3512000],
                [-0.4184650, +0.8375830, -0.3512000],
                [+0.4184650, -0.8375830, -0.3512000],
                [-0.4184650, -0.8375830, -0.3512000],
                [+0.3512000, +0.4184650, +0.8375830],
                [-0.3512000, +0.4184650, +0.8375830],
                [+0.3512000, -0.4184650, +0.8375830],
                [-0.3512000, -0.4184650, +0.8375830],
                [+0.3512000, +0.4184650, -0.8375830],
                [-0.3512000, +0.4184650, -0.8375830],
                [+0.3512000, -0.4184650, -0.8375830],
                [-0.3512000, -0.4184650, -0.8375830],
                [+0.3512000, +0.8375830, +0.4184650],
                [-0.3512000, +0.8375830, +0.4184650],
                [+0.3512000, -0.8375830, +0.4184650],
                [-0.3512000, -0.8375830, +0.4184650],
                [+0.3512000, +0.8375830, -0.4184650],
                [-0.3512000, +0.8375830, -0.4184650],
                [+0.3512000, -0.8375830, -0.4184650],
                [-0.3512000, -0.8375830, -0.4184650],
                [+0.8375830, +0.4184650, +0.3512000],
                [-0.8375830, +0.4184650, +0.3512000],
                [+0.8375830, -0.4184650, +0.3512000],
                [-0.8375830, -0.4184650, +0.3512000],
                [+0.8375830, +0.4184650, -0.3512000],
                [-0.8375830, +0.4184650, -0.3512000],
                [+0.8375830, -0.4184650, -0.3512000],
                [-0.8375830, -0.4184650, -0.3512000],
                [+0.8375830, +0.3512000, +0.4184650],
                [-0.8375830, +0.3512000, +0.4184650],
                [+0.8375830, -0.3512000, +0.4184650],
                [-0.8375830, -0.3512000, +0.4184650],
                [+0.8375830, +0.3512000, -0.4184650],
                [-0.8375830, +0.3512000, -0.4184650],
                [+0.8375830, -0.3512000, -0.4184650],
                [-0.8375830, -0.3512000, -0.4184650],
                [+0.4469170, +0.3796390, +0.8100240],
                [-0.4469170, +0.3796390, +0.8100240],
                [+0.4469170, -0.3796390, +0.8100240],
                [-0.4469170, -0.3796390, +0.8100240],
                [+0.4469170, +0.3796390, -0.8100240],
                [-0.4469170, +0.3796390, -0.8100240],
                [+0.4469170, -0.3796390, -0.8100240],
                [-0.4469170, -0.3796390, -0.8100240],
                [+0.4469170, +0.8100240, +0.3796390],
                [-0.4469170, +0.8100240, +0.3796390],
                [+0.4469170, -0.8100240, +0.3796390],
                [-0.4469170, -0.8100240, +0.3796390],
                [+0.4469170, +0.8100240, -0.3796390],
                [-0.4469170, +0.8100240, -0.3796390],
                [+0.4469170, -0.8100240, -0.3796390],
                [-0.4469170, -0.8100240, -0.3796390],
                [+0.3796390, +0.4469170, +0.8100240],
                [-0.3796390, +0.4469170, +0.8100240],
                [+0.3796390, -0.4469170, +0.8100240],
                [-0.3796390, -0.4469170, +0.8100240],
                [+0.3796390, +0.4469170, -0.8100240],
                [-0.3796390, +0.4469170, -0.8100240],
                [+0.3796390, -0.4469170, -0.8100240],
                [-0.3796390, -0.4469170, -0.8100240],
                [+0.3796390, +0.8100240, +0.4469170],
                [-0.3796390, +0.8100240, +0.4469170],
                [+0.3796390, -0.8100240, +0.4469170],
                [-0.3796390, -0.8100240, +0.4469170],
                [+0.3796390, +0.8100240, -0.4469170],
                [-0.3796390, +0.8100240, -0.4469170],
                [+0.3796390, -0.8100240, -0.4469170],
                [-0.3796390, -0.8100240, -0.4469170],
                [+0.8100240, +0.4469170, +0.3796390],
                [-0.8100240, +0.4469170, +0.3796390],
                [+0.8100240, -0.4469170, +0.3796390],
                [-0.8100240, -0.4469170, +0.3796390],
                [+0.8100240, +0.4469170, -0.3796390],
                [-0.8100240, +0.4469170, -0.3796390],
                [+0.8100240, -0.4469170, -0.3796390],
                [-0.8100240, -0.4469170, -0.3796390],
                [+0.8100240, +0.3796390, +0.4469170],
                [-0.8100240, +0.3796390, +0.4469170],
                [+0.8100240, -0.3796390, +0.4469170],
                [-0.8100240, -0.3796390, +0.4469170],
                [+0.8100240, +0.3796390, -0.4469170],
                [-0.8100240, +0.3796390, -0.4469170],
                [+0.8100240, -0.3796390, -0.4469170],
                [-0.8100240, -0.3796390, -0.4469170],
                [+0.4745950, +0.4074580, +0.7802170],
                [-0.4745950, +0.4074580, +0.7802170],
                [+0.4745950, -0.4074580, +0.7802170],
                [-0.4745950, -0.4074580, +0.7802170],
                [+0.4745950, +0.4074580, -0.7802170],
                [-0.4745950, +0.4074580, -0.7802170],
                [+0.4745950, -0.4074580, -0.7802170],
                [-0.4745950, -0.4074580, -0.7802170],
                [+0.4745950, +0.7802170, +0.4074580],
                [-0.4745950, +0.7802170, +0.4074580],
                [+0.4745950, -0.7802170, +0.4074580],
                [-0.4745950, -0.7802170, +0.4074580],
                [+0.4745950, +0.7802170, -0.4074580],
                [-0.4745950, +0.7802170, -0.4074580],
                [+0.4745950, -0.7802170, -0.4074580],
                [-0.4745950, -0.7802170, -0.4074580],
                [+0.4074580, +0.4745950, +0.7802170],
                [-0.4074580, +0.4745950, +0.7802170],
                [+0.4074580, -0.4745950, +0.7802170],
                [-0.4074580, -0.4745950, +0.7802170],
                [+0.4074580, +0.4745950, -0.7802170],
                [-0.4074580, +0.4745950, -0.7802170],
                [+0.4074580, -0.4745950, -0.7802170],
                [-0.4074580, -0.4745950, -0.7802170],
                [+0.4074580, +0.7802170, +0.4745950],
                [-0.4074580, +0.7802170, +0.4745950],
                [+0.4074580, -0.7802170, +0.4745950],
                [-0.4074580, -0.7802170, +0.4745950],
                [+0.4074580, +0.7802170, -0.4745950],
                [-0.4074580, +0.7802170, -0.4745950],
                [+0.4074580, -0.7802170, -0.4745950],
                [-0.4074580, -0.7802170, -0.4745950],
                [+0.7802170, +0.4745950, +0.4074580],
                [-0.7802170, +0.4745950, +0.4074580],
                [+0.7802170, -0.4745950, +0.4074580],
                [-0.7802170, -0.4745950, +0.4074580],
                [+0.7802170, +0.4745950, -0.4074580],
                [-0.7802170, +0.4745950, -0.4074580],
                [+0.7802170, -0.4745950, -0.4074580],
                [-0.7802170, -0.4745950, -0.4074580],
                [+0.7802170, +0.4074580, +0.4745950],
                [-0.7802170, +0.4074580, +0.4745950],
                [+0.7802170, -0.4074580, +0.4745950],
                [-0.7802170, -0.4074580, +0.4745950],
                [+0.7802170, +0.4074580, -0.4745950],
                [-0.7802170, +0.4074580, -0.4745950],
                [+0.7802170, -0.4074580, -0.4745950],
                [-0.7802170, -0.4074580, -0.4745950],
                [+0.5014030, +0.4345460, +0.7481740],
                [-0.5014030, +0.4345460, +0.7481740],
                [+0.5014030, -0.4345460, +0.7481740],
                [-0.5014030, -0.4345460, +0.7481740],
                [+0.5014030, +0.4345460, -0.7481740],
                [-0.5014030, +0.4345460, -0.7481740],
                [+0.5014030, -0.4345460, -0.7481740],
                [-0.5014030, -0.4345460, -0.7481740],
                [+0.5014030, +0.7481740, +0.4345460],
                [-0.5014030, +0.7481740, +0.4345460],
                [+0.5014030, -0.7481740, +0.4345460],
                [-0.5014030, -0.7481740, +0.4345460],
                [+0.5014030, +0.7481740, -0.4345460],
                [-0.5014030, +0.7481740, -0.4345460],
                [+0.5014030, -0.7481740, -0.4345460],
                [-0.5014030, -0.7481740, -0.4345460],
                [+0.4345460, +0.5014030, +0.7481740],
                [-0.4345460, +0.5014030, +0.7481740],
                [+0.4345460, -0.5014030, +0.7481740],
                [-0.4345460, -0.5014030, +0.7481740],
                [+0.4345460, +0.5014030, -0.7481740],
                [-0.4345460, +0.5014030, -0.7481740],
                [+0.4345460, -0.5014030, -0.7481740],
                [-0.4345460, -0.5014030, -0.7481740],
                [+0.4345460, +0.7481740, +0.5014030],
                [-0.4345460, +0.7481740, +0.5014030],
                [+0.4345460, -0.7481740, +0.5014030],
                [-0.4345460, -0.7481740, +0.5014030],
                [+0.4345460, +0.7481740, -0.5014030],
                [-0.4345460, +0.7481740, -0.5014030],
                [+0.4345460, -0.7481740, -0.5014030],
                [-0.4345460, -0.7481740, -0.5014030],
                [+0.7481740, +0.5014030, +0.4345460],
                [-0.7481740, +0.5014030, +0.4345460],
                [+0.7481740, -0.5014030, +0.4345460],
                [-0.7481740, -0.5014030, +0.4345460],
                [+0.7481740, +0.5014030, -0.4345460],
                [-0.7481740, +0.5014030, -0.4345460],
                [+0.7481740, -0.5014030, -0.4345460],
                [-0.7481740, -0.5014030, -0.4345460],
                [+0.7481740, +0.4345460, +0.5014030],
                [-0.7481740, +0.4345460, +0.5014030],
                [+0.7481740, -0.4345460, +0.5014030],
                [-0.7481740, -0.4345460, +0.5014030],
                [+0.7481740, +0.4345460, -0.5014030],
                [-0.7481740, +0.4345460, -0.5014030],
                [+0.7481740, -0.4345460, -0.5014030],
                [-0.7481740, -0.4345460, -0.5014030],
                [+0.5272490, +0.4607940, +0.7139170],
                [-0.5272490, +0.4607940, +0.7139170],
                [+0.5272490, -0.4607940, +0.7139170],
                [-0.5272490, -0.4607940, +0.7139170],
                [+0.5272490, +0.4607940, -0.7139170],
                [-0.5272490, +0.4607940, -0.7139170],
                [+0.5272490, -0.4607940, -0.7139170],
                [-0.5272490, -0.4607940, -0.7139170],
                [+0.5272490, +0.7139170, +0.4607940],
                [-0.5272490, +0.7139170, +0.4607940],
                [+0.5272490, -0.7139170, +0.4607940],
                [-0.5272490, -0.7139170, +0.4607940],
                [+0.5272490, +0.7139170, -0.4607940],
                [-0.5272490, +0.7139170, -0.4607940],
                [+0.5272490, -0.7139170, -0.4607940],
                [-0.5272490, -0.7139170, -0.4607940],
                [+0.4607940, +0.5272490, +0.7139170],
                [-0.4607940, +0.5272490, +0.7139170],
                [+0.4607940, -0.5272490, +0.7139170],
                [-0.4607940, -0.5272490, +0.7139170],
                [+0.4607940, +0.5272490, -0.7139170],
                [-0.4607940, +0.5272490, -0.7139170],
                [+0.4607940, -0.5272490, -0.7139170],
                [-0.4607940, -0.5272490, -0.7139170],
                [+0.4607940, +0.7139170, +0.5272490],
                [-0.4607940, +0.7139170, +0.5272490],
                [+0.4607940, -0.7139170, +0.5272490],
                [-0.4607940, -0.7139170, +0.5272490],
                [+0.4607940, +0.7139170, -0.5272490],
                [-0.4607940, +0.7139170, -0.5272490],
                [+0.4607940, -0.7139170, -0.5272490],
                [-0.4607940, -0.7139170, -0.5272490],
                [+0.7139170, +0.5272490, +0.4607940],
                [-0.7139170, +0.5272490, +0.4607940],
                [+0.7139170, -0.5272490, +0.4607940],
                [-0.7139170, -0.5272490, +0.4607940],
                [+0.7139170, +0.5272490, -0.4607940],
                [-0.7139170, +0.5272490, -0.4607940],
                [+0.7139170, -0.5272490, -0.4607940],
                [-0.7139170, -0.5272490, -0.4607940],
                [+0.7139170, +0.4607940, +0.5272490],
                [-0.7139170, +0.4607940, +0.5272490],
                [+0.7139170, -0.4607940, +0.5272490],
                [-0.7139170, -0.4607940, +0.5272490],
                [+0.7139170, +0.4607940, -0.5272490],
                [-0.7139170, +0.4607940, -0.5272490],
                [+0.7139170, -0.4607940, -0.5272490],
                [-0.7139170, -0.4607940, -0.5272490],
                [+0.5520410, +0.4860960, +0.6774670],
                [-0.5520410, +0.4860960, +0.6774670],
                [+0.5520410, -0.4860960, +0.6774670],
                [-0.5520410, -0.4860960, +0.6774670],
                [+0.5520410, +0.4860960, -0.6774670],
                [-0.5520410, +0.4860960, -0.6774670],
                [+0.5520410, -0.4860960, -0.6774670],
                [-0.5520410, -0.4860960, -0.6774670],
                [+0.5520410, +0.6774670, +0.4860960],
                [-0.5520410, +0.6774670, +0.4860960],
                [+0.5520410, -0.6774670, +0.4860960],
                [-0.5520410, -0.6774670, +0.4860960],
                [+0.5520410, +0.6774670, -0.4860960],
                [-0.5520410, +0.6774670, -0.4860960],
                [+0.5520410, -0.6774670, -0.4860960],
                [-0.5520410, -0.6774670, -0.4860960],
                [+0.4860960, +0.5520410, +0.6774670],
                [-0.4860960, +0.5520410, +0.6774670],
                [+0.4860960, -0.5520410, +0.6774670],
                [-0.4860960, -0.5520410, +0.6774670],
                [+0.4860960, +0.5520410, -0.6774670],
                [-0.4860960, +0.5520410, -0.6774670],
                [+0.4860960, -0.5520410, -0.6774670],
                [-0.4860960, -0.5520410, -0.6774670],
                [+0.4860960, +0.6774670, +0.5520410],
                [-0.4860960, +0.6774670, +0.5520410],
                [+0.4860960, -0.6774670, +0.5520410],
                [-0.4860960, -0.6774670, +0.5520410],
                [+0.4860960, +0.6774670, -0.5520410],
                [-0.4860960, +0.6774670, -0.5520410],
                [+0.4860960, -0.6774670, -0.5520410],
                [-0.4860960, -0.6774670, -0.5520410],
                [+0.6774670, +0.5520410, +0.4860960],
                [-0.6774670, +0.5520410, +0.4860960],
                [+0.6774670, -0.5520410, +0.4860960],
                [-0.6774670, -0.5520410, +0.4860960],
                [+0.6774670, +0.5520410, -0.4860960],
                [-0.6774670, +0.5520410, -0.4860960],
                [+0.6774670, -0.5520410, -0.4860960],
                [-0.6774670, -0.5520410, -0.4860960],
                [+0.6774670, +0.4860960, +0.5520410],
                [-0.6774670, +0.4860960, +0.5520410],
                [+0.6774670, -0.4860960, +0.5520410],
                [-0.6774670, -0.4860960, +0.5520410],
                [+0.6774670, +0.4860960, -0.5520410],
                [-0.6774670, +0.4860960, -0.5520410],
                [+0.6774670, -0.4860960, -0.5520410],
                [-0.6774670, -0.4860960, -0.5520410],
                [+0.5756890, +0.5103450, +0.6388510],
                [-0.5756890, +0.5103450, +0.6388510],
                [+0.5756890, -0.5103450, +0.6388510],
                [-0.5756890, -0.5103450, +0.6388510],
                [+0.5756890, +0.5103450, -0.6388510],
                [-0.5756890, +0.5103450, -0.6388510],
                [+0.5756890, -0.5103450, -0.6388510],
                [-0.5756890, -0.5103450, -0.6388510],
                [+0.5756890, +0.6388510, +0.5103450],
                [-0.5756890, +0.6388510, +0.5103450],
                [+0.5756890, -0.6388510, +0.5103450],
                [-0.5756890, -0.6388510, +0.5103450],
                [+0.5756890, +0.6388510, -0.5103450],
                [-0.5756890, +0.6388510, -0.5103450],
                [+0.5756890, -0.6388510, -0.5103450],
                [-0.5756890, -0.6388510, -0.5103450],
                [+0.5103450, +0.5756890, +0.6388510],
                [-0.5103450, +0.5756890, +0.6388510],
                [+0.5103450, -0.5756890, +0.6388510],
                [-0.5103450, -0.5756890, +0.6388510],
                [+0.5103450, +0.5756890, -0.6388510],
                [-0.5103450, +0.5756890, -0.6388510],
                [+0.5103450, -0.5756890, -0.6388510],
                [-0.5103450, -0.5756890, -0.6388510],
                [+0.5103450, +0.6388510, +0.5756890],
                [-0.5103450, +0.6388510, +0.5756890],
                [+0.5103450, -0.6388510, +0.5756890],
                [-0.5103450, -0.6388510, +0.5756890],
                [+0.5103450, +0.6388510, -0.5756890],
                [-0.5103450, +0.6388510, -0.5756890],
                [+0.5103450, -0.6388510, -0.5756890],
                [-0.5103450, -0.6388510, -0.5756890],
                [+0.6388510, +0.5756890, +0.5103450],
                [-0.6388510, +0.5756890, +0.5103450],
                [+0.6388510, -0.5756890, +0.5103450],
                [-0.6388510, -0.5756890, +0.5103450],
                [+0.6388510, +0.5756890, -0.5103450],
                [-0.6388510, +0.5756890, -0.5103450],
                [+0.6388510, -0.5756890, -0.5103450],
                [-0.6388510, -0.5756890, -0.5103450],
                [+0.6388510, +0.5103450, +0.5756890],
                [-0.6388510, +0.5103450, +0.5756890],
                [+0.6388510, -0.5103450, +0.5756890],
                [-0.6388510, -0.5103450, +0.5756890],
                [+0.6388510, +0.5103450, -0.5756890],
                [-0.6388510, +0.5103450, -0.5756890],
                [+0.6388510, -0.5103450, -0.5756890],
                [-0.6388510, -0.5103450, -0.5756890],
                [+0.1225040, +0.0213646, +0.9922380],
                [-0.1225040, +0.0213646, +0.9922380],
                [+0.1225040, -0.0213646, +0.9922380],
                [-0.1225040, -0.0213646, +0.9922380],
                [+0.1225040, +0.0213646, -0.9922380],
                [-0.1225040, +0.0213646, -0.9922380],
                [+0.1225040, -0.0213646, -0.9922380],
                [-0.1225040, -0.0213646, -0.9922380],
                [+0.1225040, +0.9922380, +0.0213646],
                [-0.1225040, +0.9922380, +0.0213646],
                [+0.1225040, -0.9922380, +0.0213646],
                [-0.1225040, -0.9922380, +0.0213646],
                [+0.1225040, +0.9922380, -0.0213646],
                [-0.1225040, +0.9922380, -0.0213646],
                [+0.1225040, -0.9922380, -0.0213646],
                [-0.1225040, -0.9922380, -0.0213646],
                [+0.0213646, +0.1225040, +0.9922380],
                [-0.0213646, +0.1225040, +0.9922380],
                [+0.0213646, -0.1225040, +0.9922380],
                [-0.0213646, -0.1225040, +0.9922380],
                [+0.0213646, +0.1225040, -0.9922380],
                [-0.0213646, +0.1225040, -0.9922380],
                [+0.0213646, -0.1225040, -0.9922380],
                [-0.0213646, -0.1225040, -0.9922380],
                [+0.0213646, +0.9922380, +0.1225040],
                [-0.0213646, +0.9922380, +0.1225040],
                [+0.0213646, -0.9922380, +0.1225040],
                [-0.0213646, -0.9922380, +0.1225040],
                [+0.0213646, +0.9922380, -0.1225040],
                [-0.0213646, +0.9922380, -0.1225040],
                [+0.0213646, -0.9922380, -0.1225040],
                [-0.0213646, -0.9922380, -0.1225040],
                [+0.9922380, +0.1225040, +0.0213646],
                [-0.9922380, +0.1225040, +0.0213646],
                [+0.9922380, -0.1225040, +0.0213646],
                [-0.9922380, -0.1225040, +0.0213646],
                [+0.9922380, +0.1225040, -0.0213646],
                [-0.9922380, +0.1225040, -0.0213646],
                [+0.9922380, -0.1225040, -0.0213646],
                [-0.9922380, -0.1225040, -0.0213646],
                [+0.9922380, +0.0213646, +0.1225040],
                [-0.9922380, +0.0213646, +0.1225040],
                [+0.9922380, -0.0213646, +0.1225040],
                [-0.9922380, -0.0213646, +0.1225040],
                [+0.9922380, +0.0213646, -0.1225040],
                [-0.9922380, +0.0213646, -0.1225040],
                [+0.9922380, -0.0213646, -0.1225040],
                [-0.9922380, -0.0213646, -0.1225040],
                [+0.1539110, +0.0452093, +0.9870500],
                [-0.1539110, +0.0452093, +0.9870500],
                [+0.1539110, -0.0452093, +0.9870500],
                [-0.1539110, -0.0452093, +0.9870500],
                [+0.1539110, +0.0452093, -0.9870500],
                [-0.1539110, +0.0452093, -0.9870500],
                [+0.1539110, -0.0452093, -0.9870500],
                [-0.1539110, -0.0452093, -0.9870500],
                [+0.1539110, +0.9870500, +0.0452093],
                [-0.1539110, +0.9870500, +0.0452093],
                [+0.1539110, -0.9870500, +0.0452093],
                [-0.1539110, -0.9870500, +0.0452093],
                [+0.1539110, +0.9870500, -0.0452093],
                [-0.1539110, +0.9870500, -0.0452093],
                [+0.1539110, -0.9870500, -0.0452093],
                [-0.1539110, -0.9870500, -0.0452093],
                [+0.0452093, +0.1539110, +0.9870500],
                [-0.0452093, +0.1539110, +0.9870500],
                [+0.0452093, -0.1539110, +0.9870500],
                [-0.0452093, -0.1539110, +0.9870500],
                [+0.0452093, +0.1539110, -0.9870500],
                [-0.0452093, +0.1539110, -0.9870500],
                [+0.0452093, -0.1539110, -0.9870500],
                [-0.0452093, -0.1539110, -0.9870500],
                [+0.0452093, +0.9870500, +0.1539110],
                [-0.0452093, +0.9870500, +0.1539110],
                [+0.0452093, -0.9870500, +0.1539110],
                [-0.0452093, -0.9870500, +0.1539110],
                [+0.0452093, +0.9870500, -0.1539110],
                [-0.0452093, +0.9870500, -0.1539110],
                [+0.0452093, -0.9870500, -0.1539110],
                [-0.0452093, -0.9870500, -0.1539110],
                [+0.9870500, +0.1539110, +0.0452093],
                [-0.9870500, +0.1539110, +0.0452093],
                [+0.9870500, -0.1539110, +0.0452093],
                [-0.9870500, -0.1539110, +0.0452093],
                [+0.9870500, +0.1539110, -0.0452093],
                [-0.9870500, +0.1539110, -0.0452093],
                [+0.9870500, -0.1539110, -0.0452093],
                [-0.9870500, -0.1539110, -0.0452093],
                [+0.9870500, +0.0452093, +0.1539110],
                [-0.9870500, +0.0452093, +0.1539110],
                [+0.9870500, -0.0452093, +0.1539110],
                [-0.9870500, -0.0452093, +0.1539110],
                [+0.9870500, +0.0452093, -0.1539110],
                [-0.9870500, +0.0452093, -0.1539110],
                [+0.9870500, -0.0452093, -0.1539110],
                [-0.9870500, -0.0452093, -0.1539110],
                [+0.1856210, +0.0708647, +0.9800630],
                [-0.1856210, +0.0708647, +0.9800630],
                [+0.1856210, -0.0708647, +0.9800630],
                [-0.1856210, -0.0708647, +0.9800630],
                [+0.1856210, +0.0708647, -0.9800630],
                [-0.1856210, +0.0708647, -0.9800630],
                [+0.1856210, -0.0708647, -0.9800630],
                [-0.1856210, -0.0708647, -0.9800630],
                [+0.1856210, +0.9800630, +0.0708647],
                [-0.1856210, +0.9800630, +0.0708647],
                [+0.1856210, -0.9800630, +0.0708647],
                [-0.1856210, -0.9800630, +0.0708647],
                [+0.1856210, +0.9800630, -0.0708647],
                [-0.1856210, +0.9800630, -0.0708647],
                [+0.1856210, -0.9800630, -0.0708647],
                [-0.1856210, -0.9800630, -0.0708647],
                [+0.0708647, +0.1856210, +0.9800630],
                [-0.0708647, +0.1856210, +0.9800630],
                [+0.0708647, -0.1856210, +0.9800630],
                [-0.0708647, -0.1856210, +0.9800630],
                [+0.0708647, +0.1856210, -0.9800630],
                [-0.0708647, +0.1856210, -0.9800630],
                [+0.0708647, -0.1856210, -0.9800630],
                [-0.0708647, -0.1856210, -0.9800630],
                [+0.0708647, +0.9800630, +0.1856210],
                [-0.0708647, +0.9800630, +0.1856210],
                [+0.0708647, -0.9800630, +0.1856210],
                [-0.0708647, -0.9800630, +0.1856210],
                [+0.0708647, +0.9800630, -0.1856210],
                [-0.0708647, +0.9800630, -0.1856210],
                [+0.0708647, -0.9800630, -0.1856210],
                [-0.0708647, -0.9800630, -0.1856210],
                [+0.9800630, +0.1856210, +0.0708647],
                [-0.9800630, +0.1856210, +0.0708647],
                [+0.9800630, -0.1856210, +0.0708647],
                [-0.9800630, -0.1856210, +0.0708647],
                [+0.9800630, +0.1856210, -0.0708647],
                [-0.9800630, +0.1856210, -0.0708647],
                [+0.9800630, -0.1856210, -0.0708647],
                [-0.9800630, -0.1856210, -0.0708647],
                [+0.9800630, +0.0708647, +0.1856210],
                [-0.9800630, +0.0708647, +0.1856210],
                [+0.9800630, -0.0708647, +0.1856210],
                [-0.9800630, -0.0708647, +0.1856210],
                [+0.9800630, +0.0708647, -0.1856210],
                [-0.9800630, +0.0708647, -0.1856210],
                [+0.9800630, -0.0708647, -0.1856210],
                [-0.9800630, -0.0708647, -0.1856210],
                [+0.2175000, +0.0978524, +0.9711430],
                [-0.2175000, +0.0978524, +0.9711430],
                [+0.2175000, -0.0978524, +0.9711430],
                [-0.2175000, -0.0978524, +0.9711430],
                [+0.2175000, +0.0978524, -0.9711430],
                [-0.2175000, +0.0978524, -0.9711430],
                [+0.2175000, -0.0978524, -0.9711430],
                [-0.2175000, -0.0978524, -0.9711430],
                [+0.2175000, +0.9711430, +0.0978524],
                [-0.2175000, +0.9711430, +0.0978524],
                [+0.2175000, -0.9711430, +0.0978524],
                [-0.2175000, -0.9711430, +0.0978524],
                [+0.2175000, +0.9711430, -0.0978524],
                [-0.2175000, +0.9711430, -0.0978524],
                [+0.2175000, -0.9711430, -0.0978524],
                [-0.2175000, -0.9711430, -0.0978524],
                [+0.0978524, +0.2175000, +0.9711430],
                [-0.0978524, +0.2175000, +0.9711430],
                [+0.0978524, -0.2175000, +0.9711430],
                [-0.0978524, -0.2175000, +0.9711430],
                [+0.0978524, +0.2175000, -0.9711430],
                [-0.0978524, +0.2175000, -0.9711430],
                [+0.0978524, -0.2175000, -0.9711430],
                [-0.0978524, -0.2175000, -0.9711430],
                [+0.0978524, +0.9711430, +0.2175000],
                [-0.0978524, +0.9711430, +0.2175000],
                [+0.0978524, -0.9711430, +0.2175000],
                [-0.0978524, -0.9711430, +0.2175000],
                [+0.0978524, +0.9711430, -0.2175000],
                [-0.0978524, +0.9711430, -0.2175000],
                [+0.0978524, -0.9711430, -0.2175000],
                [-0.0978524, -0.9711430, -0.2175000],
                [+0.9711430, +0.2175000, +0.0978524],
                [-0.9711430, +0.2175000, +0.0978524],
                [+0.9711430, -0.2175000, +0.0978524],
                [-0.9711430, -0.2175000, +0.0978524],
                [+0.9711430, +0.2175000, -0.0978524],
                [-0.9711430, +0.2175000, -0.0978524],
                [+0.9711430, -0.2175000, -0.0978524],
                [-0.9711430, -0.2175000, -0.0978524],
                [+0.9711430, +0.0978524, +0.2175000],
                [-0.9711430, +0.0978524, +0.2175000],
                [+0.9711430, -0.0978524, +0.2175000],
                [-0.9711430, -0.0978524, +0.2175000],
                [+0.9711430, +0.0978524, -0.2175000],
                [-0.9711430, +0.0978524, -0.2175000],
                [+0.9711430, -0.0978524, -0.2175000],
                [-0.9711430, -0.0978524, -0.2175000],
                [+0.2494130, +0.1258110, +0.9601900],
                [-0.2494130, +0.1258110, +0.9601900],
                [+0.2494130, -0.1258110, +0.9601900],
                [-0.2494130, -0.1258110, +0.9601900],
                [+0.2494130, +0.1258110, -0.9601900],
                [-0.2494130, +0.1258110, -0.9601900],
                [+0.2494130, -0.1258110, -0.9601900],
                [-0.2494130, -0.1258110, -0.9601900],
                [+0.2494130, +0.9601900, +0.1258110],
                [-0.2494130, +0.9601900, +0.1258110],
                [+0.2494130, -0.9601900, +0.1258110],
                [-0.2494130, -0.9601900, +0.1258110],
                [+0.2494130, +0.9601900, -0.1258110],
                [-0.2494130, +0.9601900, -0.1258110],
                [+0.2494130, -0.9601900, -0.1258110],
                [-0.2494130, -0.9601900, -0.1258110],
                [+0.1258110, +0.2494130, +0.9601900],
                [-0.1258110, +0.2494130, +0.9601900],
                [+0.1258110, -0.2494130, +0.9601900],
                [-0.1258110, -0.2494130, +0.9601900],
                [+0.1258110, +0.2494130, -0.9601900],
                [-0.1258110, +0.2494130, -0.9601900],
                [+0.1258110, -0.2494130, -0.9601900],
                [-0.1258110, -0.2494130, -0.9601900],
                [+0.1258110, +0.9601900, +0.2494130],
                [-0.1258110, +0.9601900, +0.2494130],
                [+0.1258110, -0.9601900, +0.2494130],
                [-0.1258110, -0.9601900, +0.2494130],
                [+0.1258110, +0.9601900, -0.2494130],
                [-0.1258110, +0.9601900, -0.2494130],
                [+0.1258110, -0.9601900, -0.2494130],
                [-0.1258110, -0.9601900, -0.2494130],
                [+0.9601900, +0.2494130, +0.1258110],
                [-0.9601900, +0.2494130, +0.1258110],
                [+0.9601900, -0.2494130, +0.1258110],
                [-0.9601900, -0.2494130, +0.1258110],
                [+0.9601900, +0.2494130, -0.1258110],
                [-0.9601900, +0.2494130, -0.1258110],
                [+0.9601900, -0.2494130, -0.1258110],
                [-0.9601900, -0.2494130, -0.1258110],
                [+0.9601900, +0.1258110, +0.2494130],
                [-0.9601900, +0.1258110, +0.2494130],
                [+0.9601900, -0.1258110, +0.2494130],
                [-0.9601900, -0.1258110, +0.2494130],
                [+0.9601900, +0.1258110, -0.2494130],
                [-0.9601900, +0.1258110, -0.2494130],
                [+0.9601900, -0.1258110, -0.2494130],
                [-0.9601900, -0.1258110, -0.2494130],
                [+0.2812320, +0.1544530, +0.9471290],
                [-0.2812320, +0.1544530, +0.9471290],
                [+0.2812320, -0.1544530, +0.9471290],
                [-0.2812320, -0.1544530, +0.9471290],
                [+0.2812320, +0.1544530, -0.9471290],
                [-0.2812320, +0.1544530, -0.9471290],
                [+0.2812320, -0.1544530, -0.9471290],
                [-0.2812320, -0.1544530, -0.9471290],
                [+0.2812320, +0.9471290, +0.1544530],
                [-0.2812320, +0.9471290, +0.1544530],
                [+0.2812320, -0.9471290, +0.1544530],
                [-0.2812320, -0.9471290, +0.1544530],
                [+0.2812320, +0.9471290, -0.1544530],
                [-0.2812320, +0.9471290, -0.1544530],
                [+0.2812320, -0.9471290, -0.1544530],
                [-0.2812320, -0.9471290, -0.1544530],
                [+0.1544530, +0.2812320, +0.9471290],
                [-0.1544530, +0.2812320, +0.9471290],
                [+0.1544530, -0.2812320, +0.9471290],
                [-0.1544530, -0.2812320, +0.9471290],
                [+0.1544530, +0.2812320, -0.9471290],
                [-0.1544530, +0.2812320, -0.9471290],
                [+0.1544530, -0.2812320, -0.9471290],
                [-0.1544530, -0.2812320, -0.9471290],
                [+0.1544530, +0.9471290, +0.2812320],
                [-0.1544530, +0.9471290, +0.2812320],
                [+0.1544530, -0.9471290, +0.2812320],
                [-0.1544530, -0.9471290, +0.2812320],
                [+0.1544530, +0.9471290, -0.2812320],
                [-0.1544530, +0.9471290, -0.2812320],
                [+0.1544530, -0.9471290, -0.2812320],
                [-0.1544530, -0.9471290, -0.2812320],
                [+0.9471290, +0.2812320, +0.1544530],
                [-0.9471290, +0.2812320, +0.1544530],
                [+0.9471290, -0.2812320, +0.1544530],
                [-0.9471290, -0.2812320, +0.1544530],
                [+0.9471290, +0.2812320, -0.1544530],
                [-0.9471290, +0.2812320, -0.1544530],
                [+0.9471290, -0.2812320, -0.1544530],
                [-0.9471290, -0.2812320, -0.1544530],
                [+0.9471290, +0.1544530, +0.2812320],
                [-0.9471290, +0.1544530, +0.2812320],
                [+0.9471290, -0.1544530, +0.2812320],
                [-0.9471290, -0.1544530, +0.2812320],
                [+0.9471290, +0.1544530, -0.2812320],
                [-0.9471290, +0.1544530, -0.2812320],
                [+0.9471290, -0.1544530, -0.2812320],
                [-0.9471290, -0.1544530, -0.2812320],
                [+0.3128370, +0.1835430, +0.9319040],
                [-0.3128370, +0.1835430, +0.9319040],
                [+0.3128370, -0.1835430, +0.9319040],
                [-0.3128370, -0.1835430, +0.9319040],
                [+0.3128370, +0.1835430, -0.9319040],
                [-0.3128370, +0.1835430, -0.9319040],
                [+0.3128370, -0.1835430, -0.9319040],
                [-0.3128370, -0.1835430, -0.9319040],
                [+0.3128370, +0.9319040, +0.1835430],
                [-0.3128370, +0.9319040, +0.1835430],
                [+0.3128370, -0.9319040, +0.1835430],
                [-0.3128370, -0.9319040, +0.1835430],
                [+0.3128370, +0.9319040, -0.1835430],
                [-0.3128370, +0.9319040, -0.1835430],
                [+0.3128370, -0.9319040, -0.1835430],
                [-0.3128370, -0.9319040, -0.1835430],
                [+0.1835430, +0.3128370, +0.9319040],
                [-0.1835430, +0.3128370, +0.9319040],
                [+0.1835430, -0.3128370, +0.9319040],
                [-0.1835430, -0.3128370, +0.9319040],
                [+0.1835430, +0.3128370, -0.9319040],
                [-0.1835430, +0.3128370, -0.9319040],
                [+0.1835430, -0.3128370, -0.9319040],
                [-0.1835430, -0.3128370, -0.9319040],
                [+0.1835430, +0.9319040, +0.3128370],
                [-0.1835430, +0.9319040, +0.3128370],
                [+0.1835430, -0.9319040, +0.3128370],
                [-0.1835430, -0.9319040, +0.3128370],
                [+0.1835430, +0.9319040, -0.3128370],
                [-0.1835430, +0.9319040, -0.3128370],
                [+0.1835430, -0.9319040, -0.3128370],
                [-0.1835430, -0.9319040, -0.3128370],
                [+0.9319040, +0.3128370, +0.1835430],
                [-0.9319040, +0.3128370, +0.1835430],
                [+0.9319040, -0.3128370, +0.1835430],
                [-0.9319040, -0.3128370, +0.1835430],
                [+0.9319040, +0.3128370, -0.1835430],
                [-0.9319040, +0.3128370, -0.1835430],
                [+0.9319040, -0.3128370, -0.1835430],
                [-0.9319040, -0.3128370, -0.1835430],
                [+0.9319040, +0.1835430, +0.3128370],
                [-0.9319040, +0.1835430, +0.3128370],
                [+0.9319040, -0.1835430, +0.3128370],
                [-0.9319040, -0.1835430, +0.3128370],
                [+0.9319040, +0.1835430, -0.3128370],
                [-0.9319040, +0.1835430, -0.3128370],
                [+0.9319040, -0.1835430, -0.3128370],
                [-0.9319040, -0.1835430, -0.3128370],
                [+0.3441150, +0.2128810, +0.9144760],
                [-0.3441150, +0.2128810, +0.9144760],
                [+0.3441150, -0.2128810, +0.9144760],
                [-0.3441150, -0.2128810, +0.9144760],
                [+0.3441150, +0.2128810, -0.9144760],
                [-0.3441150, +0.2128810, -0.9144760],
                [+0.3441150, -0.2128810, -0.9144760],
                [-0.3441150, -0.2128810, -0.9144760],
                [+0.3441150, +0.9144760, +0.2128810],
                [-0.3441150, +0.9144760, +0.2128810],
                [+0.3441150, -0.9144760, +0.2128810],
                [-0.3441150, -0.9144760, +0.2128810],
                [+0.3441150, +0.9144760, -0.2128810],
                [-0.3441150, +0.9144760, -0.2128810],
                [+0.3441150, -0.9144760, -0.2128810],
                [-0.3441150, -0.9144760, -0.2128810],
                [+0.2128810, +0.3441150, +0.9144760],
                [-0.2128810, +0.3441150, +0.9144760],
                [+0.2128810, -0.3441150, +0.9144760],
                [-0.2128810, -0.3441150, +0.9144760],
                [+0.2128810, +0.3441150, -0.9144760],
                [-0.2128810, +0.3441150, -0.9144760],
                [+0.2128810, -0.3441150, -0.9144760],
                [-0.2128810, -0.3441150, -0.9144760],
                [+0.2128810, +0.9144760, +0.3441150],
                [-0.2128810, +0.9144760, +0.3441150],
                [+0.2128810, -0.9144760, +0.3441150],
                [-0.2128810, -0.9144760, +0.3441150],
                [+0.2128810, +0.9144760, -0.3441150],
                [-0.2128810, +0.9144760, -0.3441150],
                [+0.2128810, -0.9144760, -0.3441150],
                [-0.2128810, -0.9144760, -0.3441150],
                [+0.9144760, +0.3441150, +0.2128810],
                [-0.9144760, +0.3441150, +0.2128810],
                [+0.9144760, -0.3441150, +0.2128810],
                [-0.9144760, -0.3441150, +0.2128810],
                [+0.9144760, +0.3441150, -0.2128810],
                [-0.9144760, +0.3441150, -0.2128810],
                [+0.9144760, -0.3441150, -0.2128810],
                [-0.9144760, -0.3441150, -0.2128810],
                [+0.9144760, +0.2128810, +0.3441150],
                [-0.9144760, +0.2128810, +0.3441150],
                [+0.9144760, -0.2128810, +0.3441150],
                [-0.9144760, -0.2128810, +0.3441150],
                [+0.9144760, +0.2128810, -0.3441150],
                [-0.9144760, +0.2128810, -0.3441150],
                [+0.9144760, -0.2128810, -0.3441150],
                [-0.9144760, -0.2128810, -0.3441150],
                [+0.3749570, +0.2422910, +0.8948200],
                [-0.3749570, +0.2422910, +0.8948200],
                [+0.3749570, -0.2422910, +0.8948200],
                [-0.3749570, -0.2422910, +0.8948200],
                [+0.3749570, +0.2422910, -0.8948200],
                [-0.3749570, +0.2422910, -0.8948200],
                [+0.3749570, -0.2422910, -0.8948200],
                [-0.3749570, -0.2422910, -0.8948200],
                [+0.3749570, +0.8948200, +0.2422910],
                [-0.3749570, +0.8948200, +0.2422910],
                [+0.3749570, -0.8948200, +0.2422910],
                [-0.3749570, -0.8948200, +0.2422910],
                [+0.3749570, +0.8948200, -0.2422910],
                [-0.3749570, +0.8948200, -0.2422910],
                [+0.3749570, -0.8948200, -0.2422910],
                [-0.3749570, -0.8948200, -0.2422910],
                [+0.2422910, +0.3749570, +0.8948200],
                [-0.2422910, +0.3749570, +0.8948200],
                [+0.2422910, -0.3749570, +0.8948200],
                [-0.2422910, -0.3749570, +0.8948200],
                [+0.2422910, +0.3749570, -0.8948200],
                [-0.2422910, +0.3749570, -0.8948200],
                [+0.2422910, -0.3749570, -0.8948200],
                [-0.2422910, -0.3749570, -0.8948200],
                [+0.2422910, +0.8948200, +0.3749570],
                [-0.2422910, +0.8948200, +0.3749570],
                [+0.2422910, -0.8948200, +0.3749570],
                [-0.2422910, -0.8948200, +0.3749570],
                [+0.2422910, +0.8948200, -0.3749570],
                [-0.2422910, +0.8948200, -0.3749570],
                [+0.2422910, -0.8948200, -0.3749570],
                [-0.2422910, -0.8948200, -0.3749570],
                [+0.8948200, +0.3749570, +0.2422910],
                [-0.8948200, +0.3749570, +0.2422910],
                [+0.8948200, -0.3749570, +0.2422910],
                [-0.8948200, -0.3749570, +0.2422910],
                [+0.8948200, +0.3749570, -0.2422910],
                [-0.8948200, +0.3749570, -0.2422910],
                [+0.8948200, -0.3749570, -0.2422910],
                [-0.8948200, -0.3749570, -0.2422910],
                [+0.8948200, +0.2422910, +0.3749570],
                [-0.8948200, +0.2422910, +0.3749570],
                [+0.8948200, -0.2422910, +0.3749570],
                [-0.8948200, -0.2422910, +0.3749570],
                [+0.8948200, +0.2422910, -0.3749570],
                [-0.8948200, +0.2422910, -0.3749570],
                [+0.8948200, -0.2422910, -0.3749570],
                [-0.8948200, -0.2422910, -0.3749570],
                [+0.4052620, +0.2716160, +0.8729190],
                [-0.4052620, +0.2716160, +0.8729190],
                [+0.4052620, -0.2716160, +0.8729190],
                [-0.4052620, -0.2716160, +0.8729190],
                [+0.4052620, +0.2716160, -0.8729190],
                [-0.4052620, +0.2716160, -0.8729190],
                [+0.4052620, -0.2716160, -0.8729190],
                [-0.4052620, -0.2716160, -0.8729190],
                [+0.4052620, +0.8729190, +0.2716160],
                [-0.4052620, +0.8729190, +0.2716160],
                [+0.4052620, -0.8729190, +0.2716160],
                [-0.4052620, -0.8729190, +0.2716160],
                [+0.4052620, +0.8729190, -0.2716160],
                [-0.4052620, +0.8729190, -0.2716160],
                [+0.4052620, -0.8729190, -0.2716160],
                [-0.4052620, -0.8729190, -0.2716160],
                [+0.2716160, +0.4052620, +0.8729190],
                [-0.2716160, +0.4052620, +0.8729190],
                [+0.2716160, -0.4052620, +0.8729190],
                [-0.2716160, -0.4052620, +0.8729190],
                [+0.2716160, +0.4052620, -0.8729190],
                [-0.2716160, +0.4052620, -0.8729190],
                [+0.2716160, -0.4052620, -0.8729190],
                [-0.2716160, -0.4052620, -0.8729190],
                [+0.2716160, +0.8729190, +0.4052620],
                [-0.2716160, +0.8729190, +0.4052620],
                [+0.2716160, -0.8729190, +0.4052620],
                [-0.2716160, -0.8729190, +0.4052620],
                [+0.2716160, +0.8729190, -0.4052620],
                [-0.2716160, +0.8729190, -0.4052620],
                [+0.2716160, -0.8729190, -0.4052620],
                [-0.2716160, -0.8729190, -0.4052620],
                [+0.8729190, +0.4052620, +0.2716160],
                [-0.8729190, +0.4052620, +0.2716160],
                [+0.8729190, -0.4052620, +0.2716160],
                [-0.8729190, -0.4052620, +0.2716160],
                [+0.8729190, +0.4052620, -0.2716160],
                [-0.8729190, +0.4052620, -0.2716160],
                [+0.8729190, -0.4052620, -0.2716160],
                [-0.8729190, -0.4052620, -0.2716160],
                [+0.8729190, +0.2716160, +0.4052620],
                [-0.8729190, +0.2716160, +0.4052620],
                [+0.8729190, -0.2716160, +0.4052620],
                [-0.8729190, -0.2716160, +0.4052620],
                [+0.8729190, +0.2716160, -0.4052620],
                [-0.8729190, +0.2716160, -0.4052620],
                [+0.8729190, -0.2716160, -0.4052620],
                [-0.8729190, -0.2716160, -0.4052620],
                [+0.4349340, +0.3007130, +0.8487670],
                [-0.4349340, +0.3007130, +0.8487670],
                [+0.4349340, -0.3007130, +0.8487670],
                [-0.4349340, -0.3007130, +0.8487670],
                [+0.4349340, +0.3007130, -0.8487670],
                [-0.4349340, +0.3007130, -0.8487670],
                [+0.4349340, -0.3007130, -0.8487670],
                [-0.4349340, -0.3007130, -0.8487670],
                [+0.4349340, +0.8487670, +0.3007130],
                [-0.4349340, +0.8487670, +0.3007130],
                [+0.4349340, -0.8487670, +0.3007130],
                [-0.4349340, -0.8487670, +0.3007130],
                [+0.4349340, +0.8487670, -0.3007130],
                [-0.4349340, +0.8487670, -0.3007130],
                [+0.4349340, -0.8487670, -0.3007130],
                [-0.4349340, -0.8487670, -0.3007130],
                [+0.3007130, +0.4349340, +0.8487670],
                [-0.3007130, +0.4349340, +0.8487670],
                [+0.3007130, -0.4349340, +0.8487670],
                [-0.3007130, -0.4349340, +0.8487670],
                [+0.3007130, +0.4349340, -0.8487670],
                [-0.3007130, +0.4349340, -0.8487670],
                [+0.3007130, -0.4349340, -0.8487670],
                [-0.3007130, -0.4349340, -0.8487670],
                [+0.3007130, +0.8487670, +0.4349340],
                [-0.3007130, +0.8487670, +0.4349340],
                [+0.3007130, -0.8487670, +0.4349340],
                [-0.3007130, -0.8487670, +0.4349340],
                [+0.3007130, +0.8487670, -0.4349340],
                [-0.3007130, +0.8487670, -0.4349340],
                [+0.3007130, -0.8487670, -0.4349340],
                [-0.3007130, -0.8487670, -0.4349340],
                [+0.8487670, +0.4349340, +0.3007130],
                [-0.8487670, +0.4349340, +0.3007130],
                [+0.8487670, -0.4349340, +0.3007130],
                [-0.8487670, -0.4349340, +0.3007130],
                [+0.8487670, +0.4349340, -0.3007130],
                [-0.8487670, +0.4349340, -0.3007130],
                [+0.8487670, -0.4349340, -0.3007130],
                [-0.8487670, -0.4349340, -0.3007130],
                [+0.8487670, +0.3007130, +0.4349340],
                [-0.8487670, +0.3007130, +0.4349340],
                [+0.8487670, -0.3007130, +0.4349340],
                [-0.8487670, -0.3007130, +0.4349340],
                [+0.8487670, +0.3007130, -0.4349340],
                [-0.8487670, +0.3007130, -0.4349340],
                [+0.8487670, -0.3007130, -0.4349340],
                [-0.8487670, -0.3007130, -0.4349340],
                [+0.4638780, +0.3294470, +0.8223640],
                [-0.4638780, +0.3294470, +0.8223640],
                [+0.4638780, -0.3294470, +0.8223640],
                [-0.4638780, -0.3294470, +0.8223640],
                [+0.4638780, +0.3294470, -0.8223640],
                [-0.4638780, +0.3294470, -0.8223640],
                [+0.4638780, -0.3294470, -0.8223640],
                [-0.4638780, -0.3294470, -0.8223640],
                [+0.4638780, +0.8223640, +0.3294470],
                [-0.4638780, +0.8223640, +0.3294470],
                [+0.4638780, -0.8223640, +0.3294470],
                [-0.4638780, -0.8223640, +0.3294470],
                [+0.4638780, +0.8223640, -0.3294470],
                [-0.4638780, +0.8223640, -0.3294470],
                [+0.4638780, -0.8223640, -0.3294470],
                [-0.4638780, -0.8223640, -0.3294470],
                [+0.3294470, +0.4638780, +0.8223640],
                [-0.3294470, +0.4638780, +0.8223640],
                [+0.3294470, -0.4638780, +0.8223640],
                [-0.3294470, -0.4638780, +0.8223640],
                [+0.3294470, +0.4638780, -0.8223640],
                [-0.3294470, +0.4638780, -0.8223640],
                [+0.3294470, -0.4638780, -0.8223640],
                [-0.3294470, -0.4638780, -0.8223640],
                [+0.3294470, +0.8223640, +0.4638780],
                [-0.3294470, +0.8223640, +0.4638780],
                [+0.3294470, -0.8223640, +0.4638780],
                [-0.3294470, -0.8223640, +0.4638780],
                [+0.3294470, +0.8223640, -0.4638780],
                [-0.3294470, +0.8223640, -0.4638780],
                [+0.3294470, -0.8223640, -0.4638780],
                [-0.3294470, -0.8223640, -0.4638780],
                [+0.8223640, +0.4638780, +0.3294470],
                [-0.8223640, +0.4638780, +0.3294470],
                [+0.8223640, -0.4638780, +0.3294470],
                [-0.8223640, -0.4638780, +0.3294470],
                [+0.8223640, +0.4638780, -0.3294470],
                [-0.8223640, +0.4638780, -0.3294470],
                [+0.8223640, -0.4638780, -0.3294470],
                [-0.8223640, -0.4638780, -0.3294470],
                [+0.8223640, +0.3294470, +0.4638780],
                [-0.8223640, +0.3294470, +0.4638780],
                [+0.8223640, -0.3294470, +0.4638780],
                [-0.8223640, -0.3294470, +0.4638780],
                [+0.8223640, +0.3294470, -0.4638780],
                [-0.8223640, +0.3294470, -0.4638780],
                [+0.8223640, -0.3294470, -0.4638780],
                [-0.8223640, -0.3294470, -0.4638780],
                [+0.4920050, +0.3576930, +0.7937170],
                [-0.4920050, +0.3576930, +0.7937170],
                [+0.4920050, -0.3576930, +0.7937170],
                [-0.4920050, -0.3576930, +0.7937170],
                [+0.4920050, +0.3576930, -0.7937170],
                [-0.4920050, +0.3576930, -0.7937170],
                [+0.4920050, -0.3576930, -0.7937170],
                [-0.4920050, -0.3576930, -0.7937170],
                [+0.4920050, +0.7937170, +0.3576930],
                [-0.4920050, +0.7937170, +0.3576930],
                [+0.4920050, -0.7937170, +0.3576930],
                [-0.4920050, -0.7937170, +0.3576930],
                [+0.4920050, +0.7937170, -0.3576930],
                [-0.4920050, +0.7937170, -0.3576930],
                [+0.4920050, -0.7937170, -0.3576930],
                [-0.4920050, -0.7937170, -0.3576930],
                [+0.3576930, +0.4920050, +0.7937170],
                [-0.3576930, +0.4920050, +0.7937170],
                [+0.3576930, -0.4920050, +0.7937170],
                [-0.3576930, -0.4920050, +0.7937170],
                [+0.3576930, +0.4920050, -0.7937170],
                [-0.3576930, +0.4920050, -0.7937170],
                [+0.3576930, -0.4920050, -0.7937170],
                [-0.3576930, -0.4920050, -0.7937170],
                [+0.3576930, +0.7937170, +0.4920050],
                [-0.3576930, +0.7937170, +0.4920050],
                [+0.3576930, -0.7937170, +0.4920050],
                [-0.3576930, -0.7937170, +0.4920050],
                [+0.3576930, +0.7937170, -0.4920050],
                [-0.3576930, +0.7937170, -0.4920050],
                [+0.3576930, -0.7937170, -0.4920050],
                [-0.3576930, -0.7937170, -0.4920050],
                [+0.7937170, +0.4920050, +0.3576930],
                [-0.7937170, +0.4920050, +0.3576930],
                [+0.7937170, -0.4920050, +0.3576930],
                [-0.7937170, -0.4920050, +0.3576930],
                [+0.7937170, +0.4920050, -0.3576930],
                [-0.7937170, +0.4920050, -0.3576930],
                [+0.7937170, -0.4920050, -0.3576930],
                [-0.7937170, -0.4920050, -0.3576930],
                [+0.7937170, +0.3576930, +0.4920050],
                [-0.7937170, +0.3576930, +0.4920050],
                [+0.7937170, -0.3576930, +0.4920050],
                [-0.7937170, -0.3576930, +0.4920050],
                [+0.7937170, +0.3576930, -0.4920050],
                [-0.7937170, +0.3576930, -0.4920050],
                [+0.7937170, -0.3576930, -0.4920050],
                [-0.7937170, -0.3576930, -0.4920050],
                [+0.5192270, +0.3853310, +0.7628390],
                [-0.5192270, +0.3853310, +0.7628390],
                [+0.5192270, -0.3853310, +0.7628390],
                [-0.5192270, -0.3853310, +0.7628390],
                [+0.5192270, +0.3853310, -0.7628390],
                [-0.5192270, +0.3853310, -0.7628390],
                [+0.5192270, -0.3853310, -0.7628390],
                [-0.5192270, -0.3853310, -0.7628390],
                [+0.5192270, +0.7628390, +0.3853310],
                [-0.5192270, +0.7628390, +0.3853310],
                [+0.5192270, -0.7628390, +0.3853310],
                [-0.5192270, -0.7628390, +0.3853310],
                [+0.5192270, +0.7628390, -0.3853310],
                [-0.5192270, +0.7628390, -0.3853310],
                [+0.5192270, -0.7628390, -0.3853310],
                [-0.5192270, -0.7628390, -0.3853310],
                [+0.3853310, +0.5192270, +0.7628390],
                [-0.3853310, +0.5192270, +0.7628390],
                [+0.3853310, -0.5192270, +0.7628390],
                [-0.3853310, -0.5192270, +0.7628390],
                [+0.3853310, +0.5192270, -0.7628390],
                [-0.3853310, +0.5192270, -0.7628390],
                [+0.3853310, -0.5192270, -0.7628390],
                [-0.3853310, -0.5192270, -0.7628390],
                [+0.3853310, +0.7628390, +0.5192270],
                [-0.3853310, +0.7628390, +0.5192270],
                [+0.3853310, -0.7628390, +0.5192270],
                [-0.3853310, -0.7628390, +0.5192270],
                [+0.3853310, +0.7628390, -0.5192270],
                [-0.3853310, +0.7628390, -0.5192270],
                [+0.3853310, -0.7628390, -0.5192270],
                [-0.3853310, -0.7628390, -0.5192270],
                [+0.7628390, +0.5192270, +0.3853310],
                [-0.7628390, +0.5192270, +0.3853310],
                [+0.7628390, -0.5192270, +0.3853310],
                [-0.7628390, -0.5192270, +0.3853310],
                [+0.7628390, +0.5192270, -0.3853310],
                [-0.7628390, +0.5192270, -0.3853310],
                [+0.7628390, -0.5192270, -0.3853310],
                [-0.7628390, -0.5192270, -0.3853310],
                [+0.7628390, +0.3853310, +0.5192270],
                [-0.7628390, +0.3853310, +0.5192270],
                [+0.7628390, -0.3853310, +0.5192270],
                [-0.7628390, -0.3853310, +0.5192270],
                [+0.7628390, +0.3853310, -0.5192270],
                [-0.7628390, +0.3853310, -0.5192270],
                [+0.7628390, -0.3853310, -0.5192270],
                [-0.7628390, -0.3853310, -0.5192270],
                [+0.5454610, +0.4122430, +0.7297460],
                [-0.5454610, +0.4122430, +0.7297460],
                [+0.5454610, -0.4122430, +0.7297460],
                [-0.5454610, -0.4122430, +0.7297460],
                [+0.5454610, +0.4122430, -0.7297460],
                [-0.5454610, +0.4122430, -0.7297460],
                [+0.5454610, -0.4122430, -0.7297460],
                [-0.5454610, -0.4122430, -0.7297460],
                [+0.5454610, +0.7297460, +0.4122430],
                [-0.5454610, +0.7297460, +0.4122430],
                [+0.5454610, -0.7297460, +0.4122430],
                [-0.5454610, -0.7297460, +0.4122430],
                [+0.5454610, +0.7297460, -0.4122430],
                [-0.5454610, +0.7297460, -0.4122430],
                [+0.5454610, -0.7297460, -0.4122430],
                [-0.5454610, -0.7297460, -0.4122430],
                [+0.4122430, +0.5454610, +0.7297460],
                [-0.4122430, +0.5454610, +0.7297460],
                [+0.4122430, -0.5454610, +0.7297460],
                [-0.4122430, -0.5454610, +0.7297460],
                [+0.4122430, +0.5454610, -0.7297460],
                [-0.4122430, +0.5454610, -0.7297460],
                [+0.4122430, -0.5454610, -0.7297460],
                [-0.4122430, -0.5454610, -0.7297460],
                [+0.4122430, +0.7297460, +0.5454610],
                [-0.4122430, +0.7297460, +0.5454610],
                [+0.4122430, -0.7297460, +0.5454610],
                [-0.4122430, -0.7297460, +0.5454610],
                [+0.4122430, +0.7297460, -0.5454610],
                [-0.4122430, +0.7297460, -0.5454610],
                [+0.4122430, -0.7297460, -0.5454610],
                [-0.4122430, -0.7297460, -0.5454610],
                [+0.7297460, +0.5454610, +0.4122430],
                [-0.7297460, +0.5454610, +0.4122430],
                [+0.7297460, -0.5454610, +0.4122430],
                [-0.7297460, -0.5454610, +0.4122430],
                [+0.7297460, +0.5454610, -0.4122430],
                [-0.7297460, +0.5454610, -0.4122430],
                [+0.7297460, -0.5454610, -0.4122430],
                [-0.7297460, -0.5454610, -0.4122430],
                [+0.7297460, +0.4122430, +0.5454610],
                [-0.7297460, +0.4122430, +0.5454610],
                [+0.7297460, -0.4122430, +0.5454610],
                [-0.7297460, -0.4122430, +0.5454610],
                [+0.7297460, +0.4122430, -0.5454610],
                [-0.7297460, +0.4122430, -0.5454610],
                [+0.7297460, -0.4122430, -0.5454610],
                [-0.7297460, -0.4122430, -0.5454610],
                [+0.5706220, +0.4383140, +0.6944580],
                [-0.5706220, +0.4383140, +0.6944580],
                [+0.5706220, -0.4383140, +0.6944580],
                [-0.5706220, -0.4383140, +0.6944580],
                [+0.5706220, +0.4383140, -0.6944580],
                [-0.5706220, +0.4383140, -0.6944580],
                [+0.5706220, -0.4383140, -0.6944580],
                [-0.5706220, -0.4383140, -0.6944580],
                [+0.5706220, +0.6944580, +0.4383140],
                [-0.5706220, +0.6944580, +0.4383140],
                [+0.5706220, -0.6944580, +0.4383140],
                [-0.5706220, -0.6944580, +0.4383140],
                [+0.5706220, +0.6944580, -0.4383140],
                [-0.5706220, +0.6944580, -0.4383140],
                [+0.5706220, -0.6944580, -0.4383140],
                [-0.5706220, -0.6944580, -0.4383140],
                [+0.4383140, +0.5706220, +0.6944580],
                [-0.4383140, +0.5706220, +0.6944580],
                [+0.4383140, -0.5706220, +0.6944580],
                [-0.4383140, -0.5706220, +0.6944580],
                [+0.4383140, +0.5706220, -0.6944580],
                [-0.4383140, +0.5706220, -0.6944580],
                [+0.4383140, -0.5706220, -0.6944580],
                [-0.4383140, -0.5706220, -0.6944580],
                [+0.4383140, +0.6944580, +0.5706220],
                [-0.4383140, +0.6944580, +0.5706220],
                [+0.4383140, -0.6944580, +0.5706220],
                [-0.4383140, -0.6944580, +0.5706220],
                [+0.4383140, +0.6944580, -0.5706220],
                [-0.4383140, +0.6944580, -0.5706220],
                [+0.4383140, -0.6944580, -0.5706220],
                [-0.4383140, -0.6944580, -0.5706220],
                [+0.6944580, +0.5706220, +0.4383140],
                [-0.6944580, +0.5706220, +0.4383140],
                [+0.6944580, -0.5706220, +0.4383140],
                [-0.6944580, -0.5706220, +0.4383140],
                [+0.6944580, +0.5706220, -0.4383140],
                [-0.6944580, +0.5706220, -0.4383140],
                [+0.6944580, -0.5706220, -0.4383140],
                [-0.6944580, -0.5706220, -0.4383140],
                [+0.6944580, +0.4383140, +0.5706220],
                [-0.6944580, +0.4383140, +0.5706220],
                [+0.6944580, -0.4383140, +0.5706220],
                [-0.6944580, -0.4383140, +0.5706220],
                [+0.6944580, +0.4383140, -0.5706220],
                [-0.6944580, +0.4383140, -0.5706220],
                [+0.6944580, -0.4383140, -0.5706220],
                [-0.6944580, -0.4383140, -0.5706220],
                [+0.5946290, +0.4634310, +0.6569990],
                [-0.5946290, +0.4634310, +0.6569990],
                [+0.5946290, -0.4634310, +0.6569990],
                [-0.5946290, -0.4634310, +0.6569990],
                [+0.5946290, +0.4634310, -0.6569990],
                [-0.5946290, +0.4634310, -0.6569990],
                [+0.5946290, -0.4634310, -0.6569990],
                [-0.5946290, -0.4634310, -0.6569990],
                [+0.5946290, +0.6569990, +0.4634310],
                [-0.5946290, +0.6569990, +0.4634310],
                [+0.5946290, -0.6569990, +0.4634310],
                [-0.5946290, -0.6569990, +0.4634310],
                [+0.5946290, +0.6569990, -0.4634310],
                [-0.5946290, +0.6569990, -0.4634310],
                [+0.5946290, -0.6569990, -0.4634310],
                [-0.5946290, -0.6569990, -0.4634310],
                [+0.4634310, +0.5946290, +0.6569990],
                [-0.4634310, +0.5946290, +0.6569990],
                [+0.4634310, -0.5946290, +0.6569990],
                [-0.4634310, -0.5946290, +0.6569990],
                [+0.4634310, +0.5946290, -0.6569990],
                [-0.4634310, +0.5946290, -0.6569990],
                [+0.4634310, -0.5946290, -0.6569990],
                [-0.4634310, -0.5946290, -0.6569990],
                [+0.4634310, +0.6569990, +0.5946290],
                [-0.4634310, +0.6569990, +0.5946290],
                [+0.4634310, -0.6569990, +0.5946290],
                [-0.4634310, -0.6569990, +0.5946290],
                [+0.4634310, +0.6569990, -0.5946290],
                [-0.4634310, +0.6569990, -0.5946290],
                [+0.4634310, -0.6569990, -0.5946290],
                [-0.4634310, -0.6569990, -0.5946290],
                [+0.6569990, +0.5946290, +0.4634310],
                [-0.6569990, +0.5946290, +0.4634310],
                [+0.6569990, -0.5946290, +0.4634310],
                [-0.6569990, -0.5946290, +0.4634310],
                [+0.6569990, +0.5946290, -0.4634310],
                [-0.6569990, +0.5946290, -0.4634310],
                [+0.6569990, -0.5946290, -0.4634310],
                [-0.6569990, -0.5946290, -0.4634310],
                [+0.6569990, +0.4634310, +0.5946290],
                [-0.6569990, +0.4634310, +0.5946290],
                [+0.6569990, -0.4634310, +0.5946290],
                [-0.6569990, -0.4634310, +0.5946290],
                [+0.6569990, +0.4634310, -0.5946290],
                [-0.6569990, +0.4634310, -0.5946290],
                [+0.6569990, -0.4634310, -0.5946290],
                [-0.6569990, -0.4634310, -0.5946290],
                [+0.1905370, +0.0237131, +0.9813940],
                [-0.1905370, +0.0237131, +0.9813940],
                [+0.1905370, -0.0237131, +0.9813940],
                [-0.1905370, -0.0237131, +0.9813940],
                [+0.1905370, +0.0237131, -0.9813940],
                [-0.1905370, +0.0237131, -0.9813940],
                [+0.1905370, -0.0237131, -0.9813940],
                [-0.1905370, -0.0237131, -0.9813940],
                [+0.1905370, +0.9813940, +0.0237131],
                [-0.1905370, +0.9813940, +0.0237131],
                [+0.1905370, -0.9813940, +0.0237131],
                [-0.1905370, -0.9813940, +0.0237131],
                [+0.1905370, +0.9813940, -0.0237131],
                [-0.1905370, +0.9813940, -0.0237131],
                [+0.1905370, -0.9813940, -0.0237131],
                [-0.1905370, -0.9813940, -0.0237131],
                [+0.0237131, +0.1905370, +0.9813940],
                [-0.0237131, +0.1905370, +0.9813940],
                [+0.0237131, -0.1905370, +0.9813940],
                [-0.0237131, -0.1905370, +0.9813940],
                [+0.0237131, +0.1905370, -0.9813940],
                [-0.0237131, +0.1905370, -0.9813940],
                [+0.0237131, -0.1905370, -0.9813940],
                [-0.0237131, -0.1905370, -0.9813940],
                [+0.0237131, +0.9813940, +0.1905370],
                [-0.0237131, +0.9813940, +0.1905370],
                [+0.0237131, -0.9813940, +0.1905370],
                [-0.0237131, -0.9813940, +0.1905370],
                [+0.0237131, +0.9813940, -0.1905370],
                [-0.0237131, +0.9813940, -0.1905370],
                [+0.0237131, -0.9813940, -0.1905370],
                [-0.0237131, -0.9813940, -0.1905370],
                [+0.9813940, +0.1905370, +0.0237131],
                [-0.9813940, +0.1905370, +0.0237131],
                [+0.9813940, -0.1905370, +0.0237131],
                [-0.9813940, -0.1905370, +0.0237131],
                [+0.9813940, +0.1905370, -0.0237131],
                [-0.9813940, +0.1905370, -0.0237131],
                [+0.9813940, -0.1905370, -0.0237131],
                [-0.9813940, -0.1905370, -0.0237131],
                [+0.9813940, +0.0237131, +0.1905370],
                [-0.9813940, +0.0237131, +0.1905370],
                [+0.9813940, -0.0237131, +0.1905370],
                [-0.9813940, -0.0237131, +0.1905370],
                [+0.9813940, +0.0237131, -0.1905370],
                [-0.9813940, +0.0237131, -0.1905370],
                [+0.9813940, -0.0237131, -0.1905370],
                [-0.9813940, -0.0237131, -0.1905370],
                [+0.2242520, +0.0491788, +0.9732900],
                [-0.2242520, +0.0491788, +0.9732900],
                [+0.2242520, -0.0491788, +0.9732900],
                [-0.2242520, -0.0491788, +0.9732900],
                [+0.2242520, +0.0491788, -0.9732900],
                [-0.2242520, +0.0491788, -0.9732900],
                [+0.2242520, -0.0491788, -0.9732900],
                [-0.2242520, -0.0491788, -0.9732900],
                [+0.2242520, +0.9732900, +0.0491788],
                [-0.2242520, +0.9732900, +0.0491788],
                [+0.2242520, -0.9732900, +0.0491788],
                [-0.2242520, -0.9732900, +0.0491788],
                [+0.2242520, +0.9732900, -0.0491788],
                [-0.2242520, +0.9732900, -0.0491788],
                [+0.2242520, -0.9732900, -0.0491788],
                [-0.2242520, -0.9732900, -0.0491788],
                [+0.0491788, +0.2242520, +0.9732900],
                [-0.0491788, +0.2242520, +0.9732900],
                [+0.0491788, -0.2242520, +0.9732900],
                [-0.0491788, -0.2242520, +0.9732900],
                [+0.0491788, +0.2242520, -0.9732900],
                [-0.0491788, +0.2242520, -0.9732900],
                [+0.0491788, -0.2242520, -0.9732900],
                [-0.0491788, -0.2242520, -0.9732900],
                [+0.0491788, +0.9732900, +0.2242520],
                [-0.0491788, +0.9732900, +0.2242520],
                [+0.0491788, -0.9732900, +0.2242520],
                [-0.0491788, -0.9732900, +0.2242520],
                [+0.0491788, +0.9732900, -0.2242520],
                [-0.0491788, +0.9732900, -0.2242520],
                [+0.0491788, -0.9732900, -0.2242520],
                [-0.0491788, -0.9732900, -0.2242520],
                [+0.9732900, +0.2242520, +0.0491788],
                [-0.9732900, +0.2242520, +0.0491788],
                [+0.9732900, -0.2242520, +0.0491788],
                [-0.9732900, -0.2242520, +0.0491788],
                [+0.9732900, +0.2242520, -0.0491788],
                [-0.9732900, +0.2242520, -0.0491788],
                [+0.9732900, -0.2242520, -0.0491788],
                [-0.9732900, -0.2242520, -0.0491788],
                [+0.9732900, +0.0491788, +0.2242520],
                [-0.9732900, +0.0491788, +0.2242520],
                [+0.9732900, -0.0491788, +0.2242520],
                [-0.9732900, -0.0491788, +0.2242520],
                [+0.9732900, +0.0491788, -0.2242520],
                [-0.9732900, +0.0491788, -0.2242520],
                [+0.9732900, -0.0491788, -0.2242520],
                [-0.9732900, -0.0491788, -0.2242520],
                [+0.2577190, +0.0759550, +0.9632300],
                [-0.2577190, +0.0759550, +0.9632300],
                [+0.2577190, -0.0759550, +0.9632300],
                [-0.2577190, -0.0759550, +0.9632300],
                [+0.2577190, +0.0759550, -0.9632300],
                [-0.2577190, +0.0759550, -0.9632300],
                [+0.2577190, -0.0759550, -0.9632300],
                [-0.2577190, -0.0759550, -0.9632300],
                [+0.2577190, +0.9632300, +0.0759550],
                [-0.2577190, +0.9632300, +0.0759550],
                [+0.2577190, -0.9632300, +0.0759550],
                [-0.2577190, -0.9632300, +0.0759550],
                [+0.2577190, +0.9632300, -0.0759550],
                [-0.2577190, +0.9632300, -0.0759550],
                [+0.2577190, -0.9632300, -0.0759550],
                [-0.2577190, -0.9632300, -0.0759550],
                [+0.0759550, +0.2577190, +0.9632300],
                [-0.0759550, +0.2577190, +0.9632300],
                [+0.0759550, -0.2577190, +0.9632300],
                [-0.0759550, -0.2577190, +0.9632300],
                [+0.0759550, +0.2577190, -0.9632300],
                [-0.0759550, +0.2577190, -0.9632300],
                [+0.0759550, -0.2577190, -0.9632300],
                [-0.0759550, -0.2577190, -0.9632300],
                [+0.0759550, +0.9632300, +0.2577190],
                [-0.0759550, +0.9632300, +0.2577190],
                [+0.0759550, -0.9632300, +0.2577190],
                [-0.0759550, -0.9632300, +0.2577190],
                [+0.0759550, +0.9632300, -0.2577190],
                [-0.0759550, +0.9632300, -0.2577190],
                [+0.0759550, -0.9632300, -0.2577190],
                [-0.0759550, -0.9632300, -0.2577190],
                [+0.9632300, +0.2577190, +0.0759550],
                [-0.9632300, +0.2577190, +0.0759550],
                [+0.9632300, -0.2577190, +0.0759550],
                [-0.9632300, -0.2577190, +0.0759550],
                [+0.9632300, +0.2577190, -0.0759550],
                [-0.9632300, +0.2577190, -0.0759550],
                [+0.9632300, -0.2577190, -0.0759550],
                [-0.9632300, -0.2577190, -0.0759550],
                [+0.9632300, +0.0759550, +0.2577190],
                [-0.9632300, +0.0759550, +0.2577190],
                [+0.9632300, -0.0759550, +0.2577190],
                [-0.9632300, -0.0759550, +0.2577190],
                [+0.9632300, +0.0759550, -0.2577190],
                [-0.9632300, +0.0759550, -0.2577190],
                [+0.9632300, -0.0759550, -0.2577190],
                [-0.9632300, -0.0759550, -0.2577190],
                [+0.2908720, +0.1036990, +0.9511250],
                [-0.2908720, +0.1036990, +0.9511250],
                [+0.2908720, -0.1036990, +0.9511250],
                [-0.2908720, -0.1036990, +0.9511250],
                [+0.2908720, +0.1036990, -0.9511250],
                [-0.2908720, +0.1036990, -0.9511250],
                [+0.2908720, -0.1036990, -0.9511250],
                [-0.2908720, -0.1036990, -0.9511250],
                [+0.2908720, +0.9511250, +0.1036990],
                [-0.2908720, +0.9511250, +0.1036990],
                [+0.2908720, -0.9511250, +0.1036990],
                [-0.2908720, -0.9511250, +0.1036990],
                [+0.2908720, +0.9511250, -0.1036990],
                [-0.2908720, +0.9511250, -0.1036990],
                [+0.2908720, -0.9511250, -0.1036990],
                [-0.2908720, -0.9511250, -0.1036990],
                [+0.1036990, +0.2908720, +0.9511250],
                [-0.1036990, +0.2908720, +0.9511250],
                [+0.1036990, -0.2908720, +0.9511250],
                [-0.1036990, -0.2908720, +0.9511250],
                [+0.1036990, +0.2908720, -0.9511250],
                [-0.1036990, +0.2908720, -0.9511250],
                [+0.1036990, -0.2908720, -0.9511250],
                [-0.1036990, -0.2908720, -0.9511250],
                [+0.1036990, +0.9511250, +0.2908720],
                [-0.1036990, +0.9511250, +0.2908720],
                [+0.1036990, -0.9511250, +0.2908720],
                [-0.1036990, -0.9511250, +0.2908720],
                [+0.1036990, +0.9511250, -0.2908720],
                [-0.1036990, +0.9511250, -0.2908720],
                [+0.1036990, -0.9511250, -0.2908720],
                [-0.1036990, -0.9511250, -0.2908720],
                [+0.9511250, +0.2908720, +0.1036990],
                [-0.9511250, +0.2908720, +0.1036990],
                [+0.9511250, -0.2908720, +0.1036990],
                [-0.9511250, -0.2908720, +0.1036990],
                [+0.9511250, +0.2908720, -0.1036990],
                [-0.9511250, +0.2908720, -0.1036990],
                [+0.9511250, -0.2908720, -0.1036990],
                [-0.9511250, -0.2908720, -0.1036990],
                [+0.9511250, +0.1036990, +0.2908720],
                [-0.9511250, +0.1036990, +0.2908720],
                [+0.9511250, -0.1036990, +0.2908720],
                [-0.9511250, -0.1036990, +0.2908720],
                [+0.9511250, +0.1036990, -0.2908720],
                [-0.9511250, +0.1036990, -0.2908720],
                [+0.9511250, -0.1036990, -0.2908720],
                [-0.9511250, -0.1036990, -0.2908720],
                [+0.3236350, +0.1321350, +0.9369100],
                [-0.3236350, +0.1321350, +0.9369100],
                [+0.3236350, -0.1321350, +0.9369100],
                [-0.3236350, -0.1321350, +0.9369100],
                [+0.3236350, +0.1321350, -0.9369100],
                [-0.3236350, +0.1321350, -0.9369100],
                [+0.3236350, -0.1321350, -0.9369100],
                [-0.3236350, -0.1321350, -0.9369100],
                [+0.3236350, +0.9369100, +0.1321350],
                [-0.3236350, +0.9369100, +0.1321350],
                [+0.3236350, -0.9369100, +0.1321350],
                [-0.3236350, -0.9369100, +0.1321350],
                [+0.3236350, +0.9369100, -0.1321350],
                [-0.3236350, +0.9369100, -0.1321350],
                [+0.3236350, -0.9369100, -0.1321350],
                [-0.3236350, -0.9369100, -0.1321350],
                [+0.1321350, +0.3236350, +0.9369100],
                [-0.1321350, +0.3236350, +0.9369100],
                [+0.1321350, -0.3236350, +0.9369100],
                [-0.1321350, -0.3236350, +0.9369100],
                [+0.1321350, +0.3236350, -0.9369100],
                [-0.1321350, +0.3236350, -0.9369100],
                [+0.1321350, -0.3236350, -0.9369100],
                [-0.1321350, -0.3236350, -0.9369100],
                [+0.1321350, +0.9369100, +0.3236350],
                [-0.1321350, +0.9369100, +0.3236350],
                [+0.1321350, -0.9369100, +0.3236350],
                [-0.1321350, -0.9369100, +0.3236350],
                [+0.1321350, +0.9369100, -0.3236350],
                [-0.1321350, +0.9369100, -0.3236350],
                [+0.1321350, -0.9369100, -0.3236350],
                [-0.1321350, -0.9369100, -0.3236350],
                [+0.9369100, +0.3236350, +0.1321350],
                [-0.9369100, +0.3236350, +0.1321350],
                [+0.9369100, -0.3236350, +0.1321350],
                [-0.9369100, -0.3236350, +0.1321350],
                [+0.9369100, +0.3236350, -0.1321350],
                [-0.9369100, +0.3236350, -0.1321350],
                [+0.9369100, -0.3236350, -0.1321350],
                [-0.9369100, -0.3236350, -0.1321350],
                [+0.9369100, +0.1321350, +0.3236350],
                [-0.9369100, +0.1321350, +0.3236350],
                [+0.9369100, -0.1321350, +0.3236350],
                [-0.9369100, -0.1321350, +0.3236350],
                [+0.9369100, +0.1321350, -0.3236350],
                [-0.9369100, +0.1321350, -0.3236350],
                [+0.9369100, -0.1321350, -0.3236350],
                [-0.9369100, -0.1321350, -0.3236350],
                [+0.3559270, +0.1610320, +0.9205350],
                [-0.3559270, +0.1610320, +0.9205350],
                [+0.3559270, -0.1610320, +0.9205350],
                [-0.3559270, -0.1610320, +0.9205350],
                [+0.3559270, +0.1610320, -0.9205350],
                [-0.3559270, +0.1610320, -0.9205350],
                [+0.3559270, -0.1610320, -0.9205350],
                [-0.3559270, -0.1610320, -0.9205350],
                [+0.3559270, +0.9205350, +0.1610320],
                [-0.3559270, +0.9205350, +0.1610320],
                [+0.3559270, -0.9205350, +0.1610320],
                [-0.3559270, -0.9205350, +0.1610320],
                [+0.3559270, +0.9205350, -0.1610320],
                [-0.3559270, +0.9205350, -0.1610320],
                [+0.3559270, -0.9205350, -0.1610320],
                [-0.3559270, -0.9205350, -0.1610320],
                [+0.1610320, +0.3559270, +0.9205350],
                [-0.1610320, +0.3559270, +0.9205350],
                [+0.1610320, -0.3559270, +0.9205350],
                [-0.1610320, -0.3559270, +0.9205350],
                [+0.1610320, +0.3559270, -0.9205350],
                [-0.1610320, +0.3559270, -0.9205350],
                [+0.1610320, -0.3559270, -0.9205350],
                [-0.1610320, -0.3559270, -0.9205350],
                [+0.1610320, +0.9205350, +0.3559270],
                [-0.1610320, +0.9205350, +0.3559270],
                [+0.1610320, -0.9205350, +0.3559270],
                [-0.1610320, -0.9205350, +0.3559270],
                [+0.1610320, +0.9205350, -0.3559270],
                [-0.1610320, +0.9205350, -0.3559270],
                [+0.1610320, -0.9205350, -0.3559270],
                [-0.1610320, -0.9205350, -0.3559270],
                [+0.9205350, +0.3559270, +0.1610320],
                [-0.9205350, +0.3559270, +0.1610320],
                [+0.9205350, -0.3559270, +0.1610320],
                [-0.9205350, -0.3559270, +0.1610320],
                [+0.9205350, +0.3559270, -0.1610320],
                [-0.9205350, +0.3559270, -0.1610320],
                [+0.9205350, -0.3559270, -0.1610320],
                [-0.9205350, -0.3559270, -0.1610320],
                [+0.9205350, +0.1610320, +0.3559270],
                [-0.9205350, +0.1610320, +0.3559270],
                [+0.9205350, -0.1610320, +0.3559270],
                [-0.9205350, -0.1610320, +0.3559270],
                [+0.9205350, +0.1610320, -0.3559270],
                [-0.9205350, +0.1610320, -0.3559270],
                [+0.9205350, -0.1610320, -0.3559270],
                [-0.9205350, -0.1610320, -0.3559270],
                [+0.3876640, +0.1901910, +0.9019670],
                [-0.3876640, +0.1901910, +0.9019670],
                [+0.3876640, -0.1901910, +0.9019670],
                [-0.3876640, -0.1901910, +0.9019670],
                [+0.3876640, +0.1901910, -0.9019670],
                [-0.3876640, +0.1901910, -0.9019670],
                [+0.3876640, -0.1901910, -0.9019670],
                [-0.3876640, -0.1901910, -0.9019670],
                [+0.3876640, +0.9019670, +0.1901910],
                [-0.3876640, +0.9019670, +0.1901910],
                [+0.3876640, -0.9019670, +0.1901910],
                [-0.3876640, -0.9019670, +0.1901910],
                [+0.3876640, +0.9019670, -0.1901910],
                [-0.3876640, +0.9019670, -0.1901910],
                [+0.3876640, -0.9019670, -0.1901910],
                [-0.3876640, -0.9019670, -0.1901910],
                [+0.1901910, +0.3876640, +0.9019670],
                [-0.1901910, +0.3876640, +0.9019670],
                [+0.1901910, -0.3876640, +0.9019670],
                [-0.1901910, -0.3876640, +0.9019670],
                [+0.1901910, +0.3876640, -0.9019670],
                [-0.1901910, +0.3876640, -0.9019670],
                [+0.1901910, -0.3876640, -0.9019670],
                [-0.1901910, -0.3876640, -0.9019670],
                [+0.1901910, +0.9019670, +0.3876640],
                [-0.1901910, +0.9019670, +0.3876640],
                [+0.1901910, -0.9019670, +0.3876640],
                [-0.1901910, -0.9019670, +0.3876640],
                [+0.1901910, +0.9019670, -0.3876640],
                [-0.1901910, +0.9019670, -0.3876640],
                [+0.1901910, -0.9019670, -0.3876640],
                [-0.1901910, -0.9019670, -0.3876640],
                [+0.9019670, +0.3876640, +0.1901910],
                [-0.9019670, +0.3876640, +0.1901910],
                [+0.9019670, -0.3876640, +0.1901910],
                [-0.9019670, -0.3876640, +0.1901910],
                [+0.9019670, +0.3876640, -0.1901910],
                [-0.9019670, +0.3876640, -0.1901910],
                [+0.9019670, -0.3876640, -0.1901910],
                [-0.9019670, -0.3876640, -0.1901910],
                [+0.9019670, +0.1901910, +0.3876640],
                [-0.9019670, +0.1901910, +0.3876640],
                [+0.9019670, -0.1901910, +0.3876640],
                [-0.9019670, -0.1901910, +0.3876640],
                [+0.9019670, +0.1901910, -0.3876640],
                [-0.9019670, +0.1901910, -0.3876640],
                [+0.9019670, -0.1901910, -0.3876640],
                [-0.9019670, -0.1901910, -0.3876640],
                [+0.4187640, +0.2194380, +0.8811830],
                [-0.4187640, +0.2194380, +0.8811830],
                [+0.4187640, -0.2194380, +0.8811830],
                [-0.4187640, -0.2194380, +0.8811830],
                [+0.4187640, +0.2194380, -0.8811830],
                [-0.4187640, +0.2194380, -0.8811830],
                [+0.4187640, -0.2194380, -0.8811830],
                [-0.4187640, -0.2194380, -0.8811830],
                [+0.4187640, +0.8811830, +0.2194380],
                [-0.4187640, +0.8811830, +0.2194380],
                [+0.4187640, -0.8811830, +0.2194380],
                [-0.4187640, -0.8811830, +0.2194380],
                [+0.4187640, +0.8811830, -0.2194380],
                [-0.4187640, +0.8811830, -0.2194380],
                [+0.4187640, -0.8811830, -0.2194380],
                [-0.4187640, -0.8811830, -0.2194380],
                [+0.2194380, +0.4187640, +0.8811830],
                [-0.2194380, +0.4187640, +0.8811830],
                [+0.2194380, -0.4187640, +0.8811830],
                [-0.2194380, -0.4187640, +0.8811830],
                [+0.2194380, +0.4187640, -0.8811830],
                [-0.2194380, +0.4187640, -0.8811830],
                [+0.2194380, -0.4187640, -0.8811830],
                [-0.2194380, -0.4187640, -0.8811830],
                [+0.2194380, +0.8811830, +0.4187640],
                [-0.2194380, +0.8811830, +0.4187640],
                [+0.2194380, -0.8811830, +0.4187640],
                [-0.2194380, -0.8811830, +0.4187640],
                [+0.2194380, +0.8811830, -0.4187640],
                [-0.2194380, +0.8811830, -0.4187640],
                [+0.2194380, -0.8811830, -0.4187640],
                [-0.2194380, -0.8811830, -0.4187640],
                [+0.8811830, +0.4187640, +0.2194380],
                [-0.8811830, +0.4187640, +0.2194380],
                [+0.8811830, -0.4187640, +0.2194380],
                [-0.8811830, -0.4187640, +0.2194380],
                [+0.8811830, +0.4187640, -0.2194380],
                [-0.8811830, +0.4187640, -0.2194380],
                [+0.8811830, -0.4187640, -0.2194380],
                [-0.8811830, -0.4187640, -0.2194380],
                [+0.8811830, +0.2194380, +0.4187640],
                [-0.8811830, +0.2194380, +0.4187640],
                [+0.8811830, -0.2194380, +0.4187640],
                [-0.8811830, -0.2194380, +0.4187640],
                [+0.8811830, +0.2194380, -0.4187640],
                [-0.8811830, +0.2194380, -0.4187640],
                [+0.8811830, -0.2194380, -0.4187640],
                [-0.8811830, -0.2194380, -0.4187640],
                [+0.4491450, +0.2486160, +0.8581720],
                [-0.4491450, +0.2486160, +0.8581720],
                [+0.4491450, -0.2486160, +0.8581720],
                [-0.4491450, -0.2486160, +0.8581720],
                [+0.4491450, +0.2486160, -0.8581720],
                [-0.4491450, +0.2486160, -0.8581720],
                [+0.4491450, -0.2486160, -0.8581720],
                [-0.4491450, -0.2486160, -0.8581720],
                [+0.4491450, +0.8581720, +0.2486160],
                [-0.4491450, +0.8581720, +0.2486160],
                [+0.4491450, -0.8581720, +0.2486160],
                [-0.4491450, -0.8581720, +0.2486160],
                [+0.4491450, +0.8581720, -0.2486160],
                [-0.4491450, +0.8581720, -0.2486160],
                [+0.4491450, -0.8581720, -0.2486160],
                [-0.4491450, -0.8581720, -0.2486160],
                [+0.2486160, +0.4491450, +0.8581720],
                [-0.2486160, +0.4491450, +0.8581720],
                [+0.2486160, -0.4491450, +0.8581720],
                [-0.2486160, -0.4491450, +0.8581720],
                [+0.2486160, +0.4491450, -0.8581720],
                [-0.2486160, +0.4491450, -0.8581720],
                [+0.2486160, -0.4491450, -0.8581720],
                [-0.2486160, -0.4491450, -0.8581720],
                [+0.2486160, +0.8581720, +0.4491450],
                [-0.2486160, +0.8581720, +0.4491450],
                [+0.2486160, -0.8581720, +0.4491450],
                [-0.2486160, -0.8581720, +0.4491450],
                [+0.2486160, +0.8581720, -0.4491450],
                [-0.2486160, +0.8581720, -0.4491450],
                [+0.2486160, -0.8581720, -0.4491450],
                [-0.2486160, -0.8581720, -0.4491450],
                [+0.8581720, +0.4491450, +0.2486160],
                [-0.8581720, +0.4491450, +0.2486160],
                [+0.8581720, -0.4491450, +0.2486160],
                [-0.8581720, -0.4491450, +0.2486160],
                [+0.8581720, +0.4491450, -0.2486160],
                [-0.8581720, +0.4491450, -0.2486160],
                [+0.8581720, -0.4491450, -0.2486160],
                [-0.8581720, -0.4491450, -0.2486160],
                [+0.8581720, +0.2486160, +0.4491450],
                [-0.8581720, +0.2486160, +0.4491450],
                [+0.8581720, -0.2486160, +0.4491450],
                [-0.8581720, -0.2486160, +0.4491450],
                [+0.8581720, +0.2486160, -0.4491450],
                [-0.8581720, +0.2486160, -0.4491450],
                [+0.8581720, -0.2486160, -0.4491450],
                [-0.8581720, -0.2486160, -0.4491450],
                [+0.4787270, +0.2775770, +0.8329290],
                [-0.4787270, +0.2775770, +0.8329290],
                [+0.4787270, -0.2775770, +0.8329290],
                [-0.4787270, -0.2775770, +0.8329290],
                [+0.4787270, +0.2775770, -0.8329290],
                [-0.4787270, +0.2775770, -0.8329290],
                [+0.4787270, -0.2775770, -0.8329290],
                [-0.4787270, -0.2775770, -0.8329290],
                [+0.4787270, +0.8329290, +0.2775770],
                [-0.4787270, +0.8329290, +0.2775770],
                [+0.4787270, -0.8329290, +0.2775770],
                [-0.4787270, -0.8329290, +0.2775770],
                [+0.4787270, +0.8329290, -0.2775770],
                [-0.4787270, +0.8329290, -0.2775770],
                [+0.4787270, -0.8329290, -0.2775770],
                [-0.4787270, -0.8329290, -0.2775770],
                [+0.2775770, +0.4787270, +0.8329290],
                [-0.2775770, +0.4787270, +0.8329290],
                [+0.2775770, -0.4787270, +0.8329290],
                [-0.2775770, -0.4787270, +0.8329290],
                [+0.2775770, +0.4787270, -0.8329290],
                [-0.2775770, +0.4787270, -0.8329290],
                [+0.2775770, -0.4787270, -0.8329290],
                [-0.2775770, -0.4787270, -0.8329290],
                [+0.2775770, +0.8329290, +0.4787270],
                [-0.2775770, +0.8329290, +0.4787270],
                [+0.2775770, -0.8329290, +0.4787270],
                [-0.2775770, -0.8329290, +0.4787270],
                [+0.2775770, +0.8329290, -0.4787270],
                [-0.2775770, +0.8329290, -0.4787270],
                [+0.2775770, -0.8329290, -0.4787270],
                [-0.2775770, -0.8329290, -0.4787270],
                [+0.8329290, +0.4787270, +0.2775770],
                [-0.8329290, +0.4787270, +0.2775770],
                [+0.8329290, -0.4787270, +0.2775770],
                [-0.8329290, -0.4787270, +0.2775770],
                [+0.8329290, +0.4787270, -0.2775770],
                [-0.8329290, +0.4787270, -0.2775770],
                [+0.8329290, -0.4787270, -0.2775770],
                [-0.8329290, -0.4787270, -0.2775770],
                [+0.8329290, +0.2775770, +0.4787270],
                [-0.8329290, +0.2775770, +0.4787270],
                [+0.8329290, -0.2775770, +0.4787270],
                [-0.8329290, -0.2775770, +0.4787270],
                [+0.8329290, +0.2775770, -0.4787270],
                [-0.8329290, +0.2775770, -0.4787270],
                [+0.8329290, -0.2775770, -0.4787270],
                [-0.8329290, -0.2775770, -0.4787270],
                [+0.5074320, +0.3061860, +0.8054580],
                [-0.5074320, +0.3061860, +0.8054580],
                [+0.5074320, -0.3061860, +0.8054580],
                [-0.5074320, -0.3061860, +0.8054580],
                [+0.5074320, +0.3061860, -0.8054580],
                [-0.5074320, +0.3061860, -0.8054580],
                [+0.5074320, -0.3061860, -0.8054580],
                [-0.5074320, -0.3061860, -0.8054580],
                [+0.5074320, +0.8054580, +0.3061860],
                [-0.5074320, +0.8054580, +0.3061860],
                [+0.5074320, -0.8054580, +0.3061860],
                [-0.5074320, -0.8054580, +0.3061860],
                [+0.5074320, +0.8054580, -0.3061860],
                [-0.5074320, +0.8054580, -0.3061860],
                [+0.5074320, -0.8054580, -0.3061860],
                [-0.5074320, -0.8054580, -0.3061860],
                [+0.3061860, +0.5074320, +0.8054580],
                [-0.3061860, +0.5074320, +0.8054580],
                [+0.3061860, -0.5074320, +0.8054580],
                [-0.3061860, -0.5074320, +0.8054580],
                [+0.3061860, +0.5074320, -0.8054580],
                [-0.3061860, +0.5074320, -0.8054580],
                [+0.3061860, -0.5074320, -0.8054580],
                [-0.3061860, -0.5074320, -0.8054580],
                [+0.3061860, +0.8054580, +0.5074320],
                [-0.3061860, +0.8054580, +0.5074320],
                [+0.3061860, -0.8054580, +0.5074320],
                [-0.3061860, -0.8054580, +0.5074320],
                [+0.3061860, +0.8054580, -0.5074320],
                [-0.3061860, +0.8054580, -0.5074320],
                [+0.3061860, -0.8054580, -0.5074320],
                [-0.3061860, -0.8054580, -0.5074320],
                [+0.8054580, +0.5074320, +0.3061860],
                [-0.8054580, +0.5074320, +0.3061860],
                [+0.8054580, -0.5074320, +0.3061860],
                [-0.8054580, -0.5074320, +0.3061860],
                [+0.8054580, +0.5074320, -0.3061860],
                [-0.8054580, +0.5074320, -0.3061860],
                [+0.8054580, -0.5074320, -0.3061860],
                [-0.8054580, -0.5074320, -0.3061860],
                [+0.8054580, +0.3061860, +0.5074320],
                [-0.8054580, +0.3061860, +0.5074320],
                [+0.8054580, -0.3061860, +0.5074320],
                [-0.8054580, -0.3061860, +0.5074320],
                [+0.8054580, +0.3061860, -0.5074320],
                [-0.8054580, +0.3061860, -0.5074320],
                [+0.8054580, -0.3061860, -0.5074320],
                [-0.8054580, -0.3061860, -0.5074320],
                [+0.5351810, +0.3343140, +0.7757670],
                [-0.5351810, +0.3343140, +0.7757670],
                [+0.5351810, -0.3343140, +0.7757670],
                [-0.5351810, -0.3343140, +0.7757670],
                [+0.5351810, +0.3343140, -0.7757670],
                [-0.5351810, +0.3343140, -0.7757670],
                [+0.5351810, -0.3343140, -0.7757670],
                [-0.5351810, -0.3343140, -0.7757670],
                [+0.5351810, +0.7757670, +0.3343140],
                [-0.5351810, +0.7757670, +0.3343140],
                [+0.5351810, -0.7757670, +0.3343140],
                [-0.5351810, -0.7757670, +0.3343140],
                [+0.5351810, +0.7757670, -0.3343140],
                [-0.5351810, +0.7757670, -0.3343140],
                [+0.5351810, -0.7757670, -0.3343140],
                [-0.5351810, -0.7757670, -0.3343140],
                [+0.3343140, +0.5351810, +0.7757670],
                [-0.3343140, +0.5351810, +0.7757670],
                [+0.3343140, -0.5351810, +0.7757670],
                [-0.3343140, -0.5351810, +0.7757670],
                [+0.3343140, +0.5351810, -0.7757670],
                [-0.3343140, +0.5351810, -0.7757670],
                [+0.3343140, -0.5351810, -0.7757670],
                [-0.3343140, -0.5351810, -0.7757670],
                [+0.3343140, +0.7757670, +0.5351810],
                [-0.3343140, +0.7757670, +0.5351810],
                [+0.3343140, -0.7757670, +0.5351810],
                [-0.3343140, -0.7757670, +0.5351810],
                [+0.3343140, +0.7757670, -0.5351810],
                [-0.3343140, +0.7757670, -0.5351810],
                [+0.3343140, -0.7757670, -0.5351810],
                [-0.3343140, -0.7757670, -0.5351810],
                [+0.7757670, +0.5351810, +0.3343140],
                [-0.7757670, +0.5351810, +0.3343140],
                [+0.7757670, -0.5351810, +0.3343140],
                [-0.7757670, -0.5351810, +0.3343140],
                [+0.7757670, +0.5351810, -0.3343140],
                [-0.7757670, +0.5351810, -0.3343140],
                [+0.7757670, -0.5351810, -0.3343140],
                [-0.7757670, -0.5351810, -0.3343140],
                [+0.7757670, +0.3343140, +0.5351810],
                [-0.7757670, +0.3343140, +0.5351810],
                [+0.7757670, -0.3343140, +0.5351810],
                [-0.7757670, -0.3343140, +0.5351810],
                [+0.7757670, +0.3343140, -0.5351810],
                [-0.7757670, +0.3343140, -0.5351810],
                [+0.7757670, -0.3343140, -0.5351810],
                [-0.7757670, -0.3343140, -0.5351810],
                [+0.5619000, +0.3618360, +0.7438700],
                [-0.5619000, +0.3618360, +0.7438700],
                [+0.5619000, -0.3618360, +0.7438700],
                [-0.5619000, -0.3618360, +0.7438700],
                [+0.5619000, +0.3618360, -0.7438700],
                [-0.5619000, +0.3618360, -0.7438700],
                [+0.5619000, -0.3618360, -0.7438700],
                [-0.5619000, -0.3618360, -0.7438700],
                [+0.5619000, +0.7438700, +0.3618360],
                [-0.5619000, +0.7438700, +0.3618360],
                [+0.5619000, -0.7438700, +0.3618360],
                [-0.5619000, -0.7438700, +0.3618360],
                [+0.5619000, +0.7438700, -0.3618360],
                [-0.5619000, +0.7438700, -0.3618360],
                [+0.5619000, -0.7438700, -0.3618360],
                [-0.5619000, -0.7438700, -0.3618360],
                [+0.3618360, +0.5619000, +0.7438700],
                [-0.3618360, +0.5619000, +0.7438700],
                [+0.3618360, -0.5619000, +0.7438700],
                [-0.3618360, -0.5619000, +0.7438700],
                [+0.3618360, +0.5619000, -0.7438700],
                [-0.3618360, +0.5619000, -0.7438700],
                [+0.3618360, -0.5619000, -0.7438700],
                [-0.3618360, -0.5619000, -0.7438700],
                [+0.3618360, +0.7438700, +0.5619000],
                [-0.3618360, +0.7438700, +0.5619000],
                [+0.3618360, -0.7438700, +0.5619000],
                [-0.3618360, -0.7438700, +0.5619000],
                [+0.3618360, +0.7438700, -0.5619000],
                [-0.3618360, +0.7438700, -0.5619000],
                [+0.3618360, -0.7438700, -0.5619000],
                [-0.3618360, -0.7438700, -0.5619000],
                [+0.7438700, +0.5619000, +0.3618360],
                [-0.7438700, +0.5619000, +0.3618360],
                [+0.7438700, -0.5619000, +0.3618360],
                [-0.7438700, -0.5619000, +0.3618360],
                [+0.7438700, +0.5619000, -0.3618360],
                [-0.7438700, +0.5619000, -0.3618360],
                [+0.7438700, -0.5619000, -0.3618360],
                [-0.7438700, -0.5619000, -0.3618360],
                [+0.7438700, +0.3618360, +0.5619000],
                [-0.7438700, +0.3618360, +0.5619000],
                [+0.7438700, -0.3618360, +0.5619000],
                [-0.7438700, -0.3618360, +0.5619000],
                [+0.7438700, +0.3618360, -0.5619000],
                [-0.7438700, +0.3618360, -0.5619000],
                [+0.7438700, -0.3618360, -0.5619000],
                [-0.7438700, -0.3618360, -0.5619000],
                [+0.5875140, +0.3886300, +0.7097840],
                [-0.5875140, +0.3886300, +0.7097840],
                [+0.5875140, -0.3886300, +0.7097840],
                [-0.5875140, -0.3886300, +0.7097840],
                [+0.5875140, +0.3886300, -0.7097840],
                [-0.5875140, +0.3886300, -0.7097840],
                [+0.5875140, -0.3886300, -0.7097840],
                [-0.5875140, -0.3886300, -0.7097840],
                [+0.5875140, +0.7097840, +0.3886300],
                [-0.5875140, +0.7097840, +0.3886300],
                [+0.5875140, -0.7097840, +0.3886300],
                [-0.5875140, -0.7097840, +0.3886300],
                [+0.5875140, +0.7097840, -0.3886300],
                [-0.5875140, +0.7097840, -0.3886300],
                [+0.5875140, -0.7097840, -0.3886300],
                [-0.5875140, -0.7097840, -0.3886300],
                [+0.3886300, +0.5875140, +0.7097840],
                [-0.3886300, +0.5875140, +0.7097840],
                [+0.3886300, -0.5875140, +0.7097840],
                [-0.3886300, -0.5875140, +0.7097840],
                [+0.3886300, +0.5875140, -0.7097840],
                [-0.3886300, +0.5875140, -0.7097840],
                [+0.3886300, -0.5875140, -0.7097840],
                [-0.3886300, -0.5875140, -0.7097840],
                [+0.3886300, +0.7097840, +0.5875140],
                [-0.3886300, +0.7097840, +0.5875140],
                [+0.3886300, -0.7097840, +0.5875140],
                [-0.3886300, -0.7097840, +0.5875140],
                [+0.3886300, +0.7097840, -0.5875140],
                [-0.3886300, +0.7097840, -0.5875140],
                [+0.3886300, -0.7097840, -0.5875140],
                [-0.3886300, -0.7097840, -0.5875140],
                [+0.7097840, +0.5875140, +0.3886300],
                [-0.7097840, +0.5875140, +0.3886300],
                [+0.7097840, -0.5875140, +0.3886300],
                [-0.7097840, -0.5875140, +0.3886300],
                [+0.7097840, +0.5875140, -0.3886300],
                [-0.7097840, +0.5875140, -0.3886300],
                [+0.7097840, -0.5875140, -0.3886300],
                [-0.7097840, -0.5875140, -0.3886300],
                [+0.7097840, +0.3886300, +0.5875140],
                [-0.7097840, +0.3886300, +0.5875140],
                [+0.7097840, -0.3886300, +0.5875140],
                [-0.7097840, -0.3886300, +0.5875140],
                [+0.7097840, +0.3886300, -0.5875140],
                [-0.7097840, +0.3886300, -0.5875140],
                [+0.7097840, -0.3886300, -0.5875140],
                [-0.7097840, -0.3886300, -0.5875140],
                [+0.6119510, +0.4145740, +0.6735310],
                [-0.6119510, +0.4145740, +0.6735310],
                [+0.6119510, -0.4145740, +0.6735310],
                [-0.6119510, -0.4145740, +0.6735310],
                [+0.6119510, +0.4145740, -0.6735310],
                [-0.6119510, +0.4145740, -0.6735310],
                [+0.6119510, -0.4145740, -0.6735310],
                [-0.6119510, -0.4145740, -0.6735310],
                [+0.6119510, +0.6735310, +0.4145740],
                [-0.6119510, +0.6735310, +0.4145740],
                [+0.6119510, -0.6735310, +0.4145740],
                [-0.6119510, -0.6735310, +0.4145740],
                [+0.6119510, +0.6735310, -0.4145740],
                [-0.6119510, +0.6735310, -0.4145740],
                [+0.6119510, -0.6735310, -0.4145740],
                [-0.6119510, -0.6735310, -0.4145740],
                [+0.4145740, +0.6119510, +0.6735310],
                [-0.4145740, +0.6119510, +0.6735310],
                [+0.4145740, -0.6119510, +0.6735310],
                [-0.4145740, -0.6119510, +0.6735310],
                [+0.4145740, +0.6119510, -0.6735310],
                [-0.4145740, +0.6119510, -0.6735310],
                [+0.4145740, -0.6119510, -0.6735310],
                [-0.4145740, -0.6119510, -0.6735310],
                [+0.4145740, +0.6735310, +0.6119510],
                [-0.4145740, +0.6735310, +0.6119510],
                [+0.4145740, -0.6735310, +0.6119510],
                [-0.4145740, -0.6735310, +0.6119510],
                [+0.4145740, +0.6735310, -0.6119510],
                [-0.4145740, +0.6735310, -0.6119510],
                [+0.4145740, -0.6735310, -0.6119510],
                [-0.4145740, -0.6735310, -0.6119510],
                [+0.6735310, +0.6119510, +0.4145740],
                [-0.6735310, +0.6119510, +0.4145740],
                [+0.6735310, -0.6119510, +0.4145740],
                [-0.6735310, -0.6119510, +0.4145740],
                [+0.6735310, +0.6119510, -0.4145740],
                [-0.6735310, +0.6119510, -0.4145740],
                [+0.6735310, -0.6119510, -0.4145740],
                [-0.6735310, -0.6119510, -0.4145740],
                [+0.6735310, +0.4145740, +0.6119510],
                [-0.6735310, +0.4145740, +0.6119510],
                [+0.6735310, -0.4145740, +0.6119510],
                [-0.6735310, -0.4145740, +0.6119510],
                [+0.6735310, +0.4145740, -0.6119510],
                [-0.6735310, +0.4145740, -0.6119510],
                [+0.6735310, -0.4145740, -0.6119510],
                [-0.6735310, -0.4145740, -0.6119510],
                [+0.2619730, +0.0254005, +0.9647410],
                [-0.2619730, +0.0254005, +0.9647410],
                [+0.2619730, -0.0254005, +0.9647410],
                [-0.2619730, -0.0254005, +0.9647410],
                [+0.2619730, +0.0254005, -0.9647410],
                [-0.2619730, +0.0254005, -0.9647410],
                [+0.2619730, -0.0254005, -0.9647410],
                [-0.2619730, -0.0254005, -0.9647410],
                [+0.2619730, +0.9647410, +0.0254005],
                [-0.2619730, +0.9647410, +0.0254005],
                [+0.2619730, -0.9647410, +0.0254005],
                [-0.2619730, -0.9647410, +0.0254005],
                [+0.2619730, +0.9647410, -0.0254005],
                [-0.2619730, +0.9647410, -0.0254005],
                [+0.2619730, -0.9647410, -0.0254005],
                [-0.2619730, -0.9647410, -0.0254005],
                [+0.0254005, +0.2619730, +0.9647410],
                [-0.0254005, +0.2619730, +0.9647410],
                [+0.0254005, -0.2619730, +0.9647410],
                [-0.0254005, -0.2619730, +0.9647410],
                [+0.0254005, +0.2619730, -0.9647410],
                [-0.0254005, +0.2619730, -0.9647410],
                [+0.0254005, -0.2619730, -0.9647410],
                [-0.0254005, -0.2619730, -0.9647410],
                [+0.0254005, +0.9647410, +0.2619730],
                [-0.0254005, +0.9647410, +0.2619730],
                [+0.0254005, -0.9647410, +0.2619730],
                [-0.0254005, -0.9647410, +0.2619730],
                [+0.0254005, +0.9647410, -0.2619730],
                [-0.0254005, +0.9647410, -0.2619730],
                [+0.0254005, -0.9647410, -0.2619730],
                [-0.0254005, -0.9647410, -0.2619730],
                [+0.9647410, +0.2619730, +0.0254005],
                [-0.9647410, +0.2619730, +0.0254005],
                [+0.9647410, -0.2619730, +0.0254005],
                [-0.9647410, -0.2619730, +0.0254005],
                [+0.9647410, +0.2619730, -0.0254005],
                [-0.9647410, +0.2619730, -0.0254005],
                [+0.9647410, -0.2619730, -0.0254005],
                [-0.9647410, -0.2619730, -0.0254005],
                [+0.9647410, +0.0254005, +0.2619730],
                [-0.9647410, +0.0254005, +0.2619730],
                [+0.9647410, -0.0254005, +0.2619730],
                [-0.9647410, -0.0254005, +0.2619730],
                [+0.9647410, +0.0254005, -0.2619730],
                [-0.9647410, +0.0254005, -0.2619730],
                [+0.9647410, -0.0254005, -0.2619730],
                [-0.9647410, -0.0254005, -0.2619730],
                [+0.2968150, +0.0520811, +0.9535140],
                [-0.2968150, +0.0520811, +0.9535140],
                [+0.2968150, -0.0520811, +0.9535140],
                [-0.2968150, -0.0520811, +0.9535140],
                [+0.2968150, +0.0520811, -0.9535140],
                [-0.2968150, +0.0520811, -0.9535140],
                [+0.2968150, -0.0520811, -0.9535140],
                [-0.2968150, -0.0520811, -0.9535140],
                [+0.2968150, +0.9535140, +0.0520811],
                [-0.2968150, +0.9535140, +0.0520811],
                [+0.2968150, -0.9535140, +0.0520811],
                [-0.2968150, -0.9535140, +0.0520811],
                [+0.2968150, +0.9535140, -0.0520811],
                [-0.2968150, +0.9535140, -0.0520811],
                [+0.2968150, -0.9535140, -0.0520811],
                [-0.2968150, -0.9535140, -0.0520811],
                [+0.0520811, +0.2968150, +0.9535140],
                [-0.0520811, +0.2968150, +0.9535140],
                [+0.0520811, -0.2968150, +0.9535140],
                [-0.0520811, -0.2968150, +0.9535140],
                [+0.0520811, +0.2968150, -0.9535140],
                [-0.0520811, +0.2968150, -0.9535140],
                [+0.0520811, -0.2968150, -0.9535140],
                [-0.0520811, -0.2968150, -0.9535140],
                [+0.0520811, +0.9535140, +0.2968150],
                [-0.0520811, +0.9535140, +0.2968150],
                [+0.0520811, -0.9535140, +0.2968150],
                [-0.0520811, -0.9535140, +0.2968150],
                [+0.0520811, +0.9535140, -0.2968150],
                [-0.0520811, +0.9535140, -0.2968150],
                [+0.0520811, -0.9535140, -0.2968150],
                [-0.0520811, -0.9535140, -0.2968150],
                [+0.9535140, +0.2968150, +0.0520811],
                [-0.9535140, +0.2968150, +0.0520811],
                [+0.9535140, -0.2968150, +0.0520811],
                [-0.9535140, -0.2968150, +0.0520811],
                [+0.9535140, +0.2968150, -0.0520811],
                [-0.9535140, +0.2968150, -0.0520811],
                [+0.9535140, -0.2968150, -0.0520811],
                [-0.9535140, -0.2968150, -0.0520811],
                [+0.9535140, +0.0520811, +0.2968150],
                [-0.9535140, +0.0520811, +0.2968150],
                [+0.9535140, -0.0520811, +0.2968150],
                [-0.9535140, -0.0520811, +0.2968150],
                [+0.9535140, +0.0520811, -0.2968150],
                [-0.9535140, +0.0520811, -0.2968150],
                [+0.9535140, -0.0520811, -0.2968150],
                [-0.9535140, -0.0520811, -0.2968150],
                [+0.3310450, +0.0797183, +0.9402420],
                [-0.3310450, +0.0797183, +0.9402420],
                [+0.3310450, -0.0797183, +0.9402420],
                [-0.3310450, -0.0797183, +0.9402420],
                [+0.3310450, +0.0797183, -0.9402420],
                [-0.3310450, +0.0797183, -0.9402420],
                [+0.3310450, -0.0797183, -0.9402420],
                [-0.3310450, -0.0797183, -0.9402420],
                [+0.3310450, +0.9402420, +0.0797183],
                [-0.3310450, +0.9402420, +0.0797183],
                [+0.3310450, -0.9402420, +0.0797183],
                [-0.3310450, -0.9402420, +0.0797183],
                [+0.3310450, +0.9402420, -0.0797183],
                [-0.3310450, +0.9402420, -0.0797183],
                [+0.3310450, -0.9402420, -0.0797183],
                [-0.3310450, -0.9402420, -0.0797183],
                [+0.0797183, +0.3310450, +0.9402420],
                [-0.0797183, +0.3310450, +0.9402420],
                [+0.0797183, -0.3310450, +0.9402420],
                [-0.0797183, -0.3310450, +0.9402420],
                [+0.0797183, +0.3310450, -0.9402420],
                [-0.0797183, +0.3310450, -0.9402420],
                [+0.0797183, -0.3310450, -0.9402420],
                [-0.0797183, -0.3310450, -0.9402420],
                [+0.0797183, +0.9402420, +0.3310450],
                [-0.0797183, +0.9402420, +0.3310450],
                [+0.0797183, -0.9402420, +0.3310450],
                [-0.0797183, -0.9402420, +0.3310450],
                [+0.0797183, +0.9402420, -0.3310450],
                [-0.0797183, +0.9402420, -0.3310450],
                [+0.0797183, -0.9402420, -0.3310450],
                [-0.0797183, -0.9402420, -0.3310450],
                [+0.9402420, +0.3310450, +0.0797183],
                [-0.9402420, +0.3310450, +0.0797183],
                [+0.9402420, -0.3310450, +0.0797183],
                [-0.9402420, -0.3310450, +0.0797183],
                [+0.9402420, +0.3310450, -0.0797183],
                [-0.9402420, +0.3310450, -0.0797183],
                [+0.9402420, -0.3310450, -0.0797183],
                [-0.9402420, -0.3310450, -0.0797183],
                [+0.9402420, +0.0797183, +0.3310450],
                [-0.9402420, +0.0797183, +0.3310450],
                [+0.9402420, -0.0797183, +0.3310450],
                [-0.9402420, -0.0797183, +0.3310450],
                [+0.9402420, +0.0797183, -0.3310450],
                [-0.9402420, +0.0797183, -0.3310450],
                [+0.9402420, -0.0797183, -0.3310450],
                [-0.9402420, -0.0797183, -0.3310450],
                [+0.3646220, +0.1080470, +0.9248660],
                [-0.3646220, +0.1080470, +0.9248660],
                [+0.3646220, -0.1080470, +0.9248660],
                [-0.3646220, -0.1080470, +0.9248660],
                [+0.3646220, +0.1080470, -0.9248660],
                [-0.3646220, +0.1080470, -0.9248660],
                [+0.3646220, -0.1080470, -0.9248660],
                [-0.3646220, -0.1080470, -0.9248660],
                [+0.3646220, +0.9248660, +0.1080470],
                [-0.3646220, +0.9248660, +0.1080470],
                [+0.3646220, -0.9248660, +0.1080470],
                [-0.3646220, -0.9248660, +0.1080470],
                [+0.3646220, +0.9248660, -0.1080470],
                [-0.3646220, +0.9248660, -0.1080470],
                [+0.3646220, -0.9248660, -0.1080470],
                [-0.3646220, -0.9248660, -0.1080470],
                [+0.1080470, +0.3646220, +0.9248660],
                [-0.1080470, +0.3646220, +0.9248660],
                [+0.1080470, -0.3646220, +0.9248660],
                [-0.1080470, -0.3646220, +0.9248660],
                [+0.1080470, +0.3646220, -0.9248660],
                [-0.1080470, +0.3646220, -0.9248660],
                [+0.1080470, -0.3646220, -0.9248660],
                [-0.1080470, -0.3646220, -0.9248660],
                [+0.1080470, +0.9248660, +0.3646220],
                [-0.1080470, +0.9248660, +0.3646220],
                [+0.1080470, -0.9248660, +0.3646220],
                [-0.1080470, -0.9248660, +0.3646220],
                [+0.1080470, +0.9248660, -0.3646220],
                [-0.1080470, +0.9248660, -0.3646220],
                [+0.1080470, -0.9248660, -0.3646220],
                [-0.1080470, -0.9248660, -0.3646220],
                [+0.9248660, +0.3646220, +0.1080470],
                [-0.9248660, +0.3646220, +0.1080470],
                [+0.9248660, -0.3646220, +0.1080470],
                [-0.9248660, -0.3646220, +0.1080470],
                [+0.9248660, +0.3646220, -0.1080470],
                [-0.9248660, +0.3646220, -0.1080470],
                [+0.9248660, -0.3646220, -0.1080470],
                [-0.9248660, -0.3646220, -0.1080470],
                [+0.9248660, +0.1080470, +0.3646220],
                [-0.9248660, +0.1080470, +0.3646220],
                [+0.9248660, -0.1080470, +0.3646220],
                [-0.9248660, -0.1080470, +0.3646220],
                [+0.9248660, +0.1080470, -0.3646220],
                [-0.9248660, +0.1080470, -0.3646220],
                [+0.9248660, -0.1080470, -0.3646220],
                [-0.9248660, -0.1080470, -0.3646220],
                [+0.3974920, +0.1368410, +0.9073450],
                [-0.3974920, +0.1368410, +0.9073450],
                [+0.3974920, -0.1368410, +0.9073450],
                [-0.3974920, -0.1368410, +0.9073450],
                [+0.3974920, +0.1368410, -0.9073450],
                [-0.3974920, +0.1368410, -0.9073450],
                [+0.3974920, -0.1368410, -0.9073450],
                [-0.3974920, -0.1368410, -0.9073450],
                [+0.3974920, +0.9073450, +0.1368410],
                [-0.3974920, +0.9073450, +0.1368410],
                [+0.3974920, -0.9073450, +0.1368410],
                [-0.3974920, -0.9073450, +0.1368410],
                [+0.3974920, +0.9073450, -0.1368410],
                [-0.3974920, +0.9073450, -0.1368410],
                [+0.3974920, -0.9073450, -0.1368410],
                [-0.3974920, -0.9073450, -0.1368410],
                [+0.1368410, +0.3974920, +0.9073450],
                [-0.1368410, +0.3974920, +0.9073450],
                [+0.1368410, -0.3974920, +0.9073450],
                [-0.1368410, -0.3974920, +0.9073450],
                [+0.1368410, +0.3974920, -0.9073450],
                [-0.1368410, +0.3974920, -0.9073450],
                [+0.1368410, -0.3974920, -0.9073450],
                [-0.1368410, -0.3974920, -0.9073450],
                [+0.1368410, +0.9073450, +0.3974920],
                [-0.1368410, +0.9073450, +0.3974920],
                [+0.1368410, -0.9073450, +0.3974920],
                [-0.1368410, -0.9073450, +0.3974920],
                [+0.1368410, +0.9073450, -0.3974920],
                [-0.1368410, +0.9073450, -0.3974920],
                [+0.1368410, -0.9073450, -0.3974920],
                [-0.1368410, -0.9073450, -0.3974920],
                [+0.9073450, +0.3974920, +0.1368410],
                [-0.9073450, +0.3974920, +0.1368410],
                [+0.9073450, -0.3974920, +0.1368410],
                [-0.9073450, -0.3974920, +0.1368410],
                [+0.9073450, +0.3974920, -0.1368410],
                [-0.9073450, +0.3974920, -0.1368410],
                [+0.9073450, -0.3974920, -0.1368410],
                [-0.9073450, -0.3974920, -0.1368410],
                [+0.9073450, +0.1368410, +0.3974920],
                [-0.9073450, +0.1368410, +0.3974920],
                [+0.9073450, -0.1368410, +0.3974920],
                [-0.9073450, -0.1368410, +0.3974920],
                [+0.9073450, +0.1368410, -0.3974920],
                [-0.9073450, +0.1368410, -0.3974920],
                [+0.9073450, -0.1368410, -0.3974920],
                [-0.9073450, -0.1368410, -0.3974920],
                [+0.4295970, +0.1659070, +0.8876490],
                [-0.4295970, +0.1659070, +0.8876490],
                [+0.4295970, -0.1659070, +0.8876490],
                [-0.4295970, -0.1659070, +0.8876490],
                [+0.4295970, +0.1659070, -0.8876490],
                [-0.4295970, +0.1659070, -0.8876490],
                [+0.4295970, -0.1659070, -0.8876490],
                [-0.4295970, -0.1659070, -0.8876490],
                [+0.4295970, +0.8876490, +0.1659070],
                [-0.4295970, +0.8876490, +0.1659070],
                [+0.4295970, -0.8876490, +0.1659070],
                [-0.4295970, -0.8876490, +0.1659070],
                [+0.4295970, +0.8876490, -0.1659070],
                [-0.4295970, +0.8876490, -0.1659070],
                [+0.4295970, -0.8876490, -0.1659070],
                [-0.4295970, -0.8876490, -0.1659070],
                [+0.1659070, +0.4295970, +0.8876490],
                [-0.1659070, +0.4295970, +0.8876490],
                [+0.1659070, -0.4295970, +0.8876490],
                [-0.1659070, -0.4295970, +0.8876490],
                [+0.1659070, +0.4295970, -0.8876490],
                [-0.1659070, +0.4295970, -0.8876490],
                [+0.1659070, -0.4295970, -0.8876490],
                [-0.1659070, -0.4295970, -0.8876490],
                [+0.1659070, +0.8876490, +0.4295970],
                [-0.1659070, +0.8876490, +0.4295970],
                [+0.1659070, -0.8876490, +0.4295970],
                [-0.1659070, -0.8876490, +0.4295970],
                [+0.1659070, +0.8876490, -0.4295970],
                [-0.1659070, +0.8876490, -0.4295970],
                [+0.1659070, -0.8876490, -0.4295970],
                [-0.1659070, -0.8876490, -0.4295970],
                [+0.8876490, +0.4295970, +0.1659070],
                [-0.8876490, +0.4295970, +0.1659070],
                [+0.8876490, -0.4295970, +0.1659070],
                [-0.8876490, -0.4295970, +0.1659070],
                [+0.8876490, +0.4295970, -0.1659070],
                [-0.8876490, +0.4295970, -0.1659070],
                [+0.8876490, -0.4295970, -0.1659070],
                [-0.8876490, -0.4295970, -0.1659070],
                [+0.8876490, +0.1659070, +0.4295970],
                [-0.8876490, +0.1659070, +0.4295970],
                [+0.8876490, -0.1659070, +0.4295970],
                [-0.8876490, -0.1659070, +0.4295970],
                [+0.8876490, +0.1659070, -0.4295970],
                [-0.8876490, +0.1659070, -0.4295970],
                [+0.8876490, -0.1659070, -0.4295970],
                [-0.8876490, -0.1659070, -0.4295970],
                [+0.4608740, +0.1950700, +0.8657610],
                [-0.4608740, +0.1950700, +0.8657610],
                [+0.4608740, -0.1950700, +0.8657610],
                [-0.4608740, -0.1950700, +0.8657610],
                [+0.4608740, +0.1950700, -0.8657610],
                [-0.4608740, +0.1950700, -0.8657610],
                [+0.4608740, -0.1950700, -0.8657610],
                [-0.4608740, -0.1950700, -0.8657610],
                [+0.4608740, +0.8657610, +0.1950700],
                [-0.4608740, +0.8657610, +0.1950700],
                [+0.4608740, -0.8657610, +0.1950700],
                [-0.4608740, -0.8657610, +0.1950700],
                [+0.4608740, +0.8657610, -0.1950700],
                [-0.4608740, +0.8657610, -0.1950700],
                [+0.4608740, -0.8657610, -0.1950700],
                [-0.4608740, -0.8657610, -0.1950700],
                [+0.1950700, +0.4608740, +0.8657610],
                [-0.1950700, +0.4608740, +0.8657610],
                [+0.1950700, -0.4608740, +0.8657610],
                [-0.1950700, -0.4608740, +0.8657610],
                [+0.1950700, +0.4608740, -0.8657610],
                [-0.1950700, +0.4608740, -0.8657610],
                [+0.1950700, -0.4608740, -0.8657610],
                [-0.1950700, -0.4608740, -0.8657610],
                [+0.1950700, +0.8657610, +0.4608740],
                [-0.1950700, +0.8657610, +0.4608740],
                [+0.1950700, -0.8657610, +0.4608740],
                [-0.1950700, -0.8657610, +0.4608740],
                [+0.1950700, +0.8657610, -0.4608740],
                [-0.1950700, +0.8657610, -0.4608740],
                [+0.1950700, -0.8657610, -0.4608740],
                [-0.1950700, -0.8657610, -0.4608740],
                [+0.8657610, +0.4608740, +0.1950700],
                [-0.8657610, +0.4608740, +0.1950700],
                [+0.8657610, -0.4608740, +0.1950700],
                [-0.8657610, -0.4608740, +0.1950700],
                [+0.8657610, +0.4608740, -0.1950700],
                [-0.8657610, +0.4608740, -0.1950700],
                [+0.8657610, -0.4608740, -0.1950700],
                [-0.8657610, -0.4608740, -0.1950700],
                [+0.8657610, +0.1950700, +0.4608740],
                [-0.8657610, +0.1950700, +0.4608740],
                [+0.8657610, -0.1950700, +0.4608740],
                [-0.8657610, -0.1950700, +0.4608740],
                [+0.8657610, +0.1950700, -0.4608740],
                [-0.8657610, +0.1950700, -0.4608740],
                [+0.8657610, -0.1950700, -0.4608740],
                [-0.8657610, -0.1950700, -0.4608740],
                [+0.4912600, +0.2241720, +0.8416710],
                [-0.4912600, +0.2241720, +0.8416710],
                [+0.4912600, -0.2241720, +0.8416710],
                [-0.4912600, -0.2241720, +0.8416710],
                [+0.4912600, +0.2241720, -0.8416710],
                [-0.4912600, +0.2241720, -0.8416710],
                [+0.4912600, -0.2241720, -0.8416710],
                [-0.4912600, -0.2241720, -0.8416710],
                [+0.4912600, +0.8416710, +0.2241720],
                [-0.4912600, +0.8416710, +0.2241720],
                [+0.4912600, -0.8416710, +0.2241720],
                [-0.4912600, -0.8416710, +0.2241720],
                [+0.4912600, +0.8416710, -0.2241720],
                [-0.4912600, +0.8416710, -0.2241720],
                [+0.4912600, -0.8416710, -0.2241720],
                [-0.4912600, -0.8416710, -0.2241720],
                [+0.2241720, +0.4912600, +0.8416710],
                [-0.2241720, +0.4912600, +0.8416710],
                [+0.2241720, -0.4912600, +0.8416710],
                [-0.2241720, -0.4912600, +0.8416710],
                [+0.2241720, +0.4912600, -0.8416710],
                [-0.2241720, +0.4912600, -0.8416710],
                [+0.2241720, -0.4912600, -0.8416710],
                [-0.2241720, -0.4912600, -0.8416710],
                [+0.2241720, +0.8416710, +0.4912600],
                [-0.2241720, +0.8416710, +0.4912600],
                [+0.2241720, -0.8416710, +0.4912600],
                [-0.2241720, -0.8416710, +0.4912600],
                [+0.2241720, +0.8416710, -0.4912600],
                [-0.2241720, +0.8416710, -0.4912600],
                [+0.2241720, -0.8416710, -0.4912600],
                [-0.2241720, -0.8416710, -0.4912600],
                [+0.8416710, +0.4912600, +0.2241720],
                [-0.8416710, +0.4912600, +0.2241720],
                [+0.8416710, -0.4912600, +0.2241720],
                [-0.8416710, -0.4912600, +0.2241720],
                [+0.8416710, +0.4912600, -0.2241720],
                [-0.8416710, +0.4912600, -0.2241720],
                [+0.8416710, -0.4912600, -0.2241720],
                [-0.8416710, -0.4912600, -0.2241720],
                [+0.8416710, +0.2241720, +0.4912600],
                [-0.8416710, +0.2241720, +0.4912600],
                [+0.8416710, -0.2241720, +0.4912600],
                [-0.8416710, -0.2241720, +0.4912600],
                [+0.8416710, +0.2241720, -0.4912600],
                [-0.8416710, +0.2241720, -0.4912600],
                [+0.8416710, -0.2241720, -0.4912600],
                [-0.8416710, -0.2241720, -0.4912600],
                [+0.5206880, +0.2530660, +0.8153780],
                [-0.5206880, +0.2530660, +0.8153780],
                [+0.5206880, -0.2530660, +0.8153780],
                [-0.5206880, -0.2530660, +0.8153780],
                [+0.5206880, +0.2530660, -0.8153780],
                [-0.5206880, +0.2530660, -0.8153780],
                [+0.5206880, -0.2530660, -0.8153780],
                [-0.5206880, -0.2530660, -0.8153780],
                [+0.5206880, +0.8153780, +0.2530660],
                [-0.5206880, +0.8153780, +0.2530660],
                [+0.5206880, -0.8153780, +0.2530660],
                [-0.5206880, -0.8153780, +0.2530660],
                [+0.5206880, +0.8153780, -0.2530660],
                [-0.5206880, +0.8153780, -0.2530660],
                [+0.5206880, -0.8153780, -0.2530660],
                [-0.5206880, -0.8153780, -0.2530660],
                [+0.2530660, +0.5206880, +0.8153780],
                [-0.2530660, +0.5206880, +0.8153780],
                [+0.2530660, -0.5206880, +0.8153780],
                [-0.2530660, -0.5206880, +0.8153780],
                [+0.2530660, +0.5206880, -0.8153780],
                [-0.2530660, +0.5206880, -0.8153780],
                [+0.2530660, -0.5206880, -0.8153780],
                [-0.2530660, -0.5206880, -0.8153780],
                [+0.2530660, +0.8153780, +0.5206880],
                [-0.2530660, +0.8153780, +0.5206880],
                [+0.2530660, -0.8153780, +0.5206880],
                [-0.2530660, -0.8153780, +0.5206880],
                [+0.2530660, +0.8153780, -0.5206880],
                [-0.2530660, +0.8153780, -0.5206880],
                [+0.2530660, -0.8153780, -0.5206880],
                [-0.2530660, -0.8153780, -0.5206880],
                [+0.8153780, +0.5206880, +0.2530660],
                [-0.8153780, +0.5206880, +0.2530660],
                [+0.8153780, -0.5206880, +0.2530660],
                [-0.8153780, -0.5206880, +0.2530660],
                [+0.8153780, +0.5206880, -0.2530660],
                [-0.8153780, +0.5206880, -0.2530660],
                [+0.8153780, -0.5206880, -0.2530660],
                [-0.8153780, -0.5206880, -0.2530660],
                [+0.8153780, +0.2530660, +0.5206880],
                [-0.8153780, +0.2530660, +0.5206880],
                [+0.8153780, -0.2530660, +0.5206880],
                [-0.8153780, -0.2530660, +0.5206880],
                [+0.8153780, +0.2530660, -0.5206880],
                [-0.8153780, +0.2530660, -0.5206880],
                [+0.8153780, -0.2530660, -0.5206880],
                [-0.8153780, -0.2530660, -0.5206880],
                [+0.5490940, +0.2816120, +0.7868870],
                [-0.5490940, +0.2816120, +0.7868870],
                [+0.5490940, -0.2816120, +0.7868870],
                [-0.5490940, -0.2816120, +0.7868870],
                [+0.5490940, +0.2816120, -0.7868870],
                [-0.5490940, +0.2816120, -0.7868870],
                [+0.5490940, -0.2816120, -0.7868870],
                [-0.5490940, -0.2816120, -0.7868870],
                [+0.5490940, +0.7868870, +0.2816120],
                [-0.5490940, +0.7868870, +0.2816120],
                [+0.5490940, -0.7868870, +0.2816120],
                [-0.5490940, -0.7868870, +0.2816120],
                [+0.5490940, +0.7868870, -0.2816120],
                [-0.5490940, +0.7868870, -0.2816120],
                [+0.5490940, -0.7868870, -0.2816120],
                [-0.5490940, -0.7868870, -0.2816120],
                [+0.2816120, +0.5490940, +0.7868870],
                [-0.2816120, +0.5490940, +0.7868870],
                [+0.2816120, -0.5490940, +0.7868870],
                [-0.2816120, -0.5490940, +0.7868870],
                [+0.2816120, +0.5490940, -0.7868870],
                [-0.2816120, +0.5490940, -0.7868870],
                [+0.2816120, -0.5490940, -0.7868870],
                [-0.2816120, -0.5490940, -0.7868870],
                [+0.2816120, +0.7868870, +0.5490940],
                [-0.2816120, +0.7868870, +0.5490940],
                [+0.2816120, -0.7868870, +0.5490940],
                [-0.2816120, -0.7868870, +0.5490940],
                [+0.2816120, +0.7868870, -0.5490940],
                [-0.2816120, +0.7868870, -0.5490940],
                [+0.2816120, -0.7868870, -0.5490940],
                [-0.2816120, -0.7868870, -0.5490940],
                [+0.7868870, +0.5490940, +0.2816120],
                [-0.7868870, +0.5490940, +0.2816120],
                [+0.7868870, -0.5490940, +0.2816120],
                [-0.7868870, -0.5490940, +0.2816120],
                [+0.7868870, +0.5490940, -0.2816120],
                [-0.7868870, +0.5490940, -0.2816120],
                [+0.7868870, -0.5490940, -0.2816120],
                [-0.7868870, -0.5490940, -0.2816120],
                [+0.7868870, +0.2816120, +0.5490940],
                [-0.7868870, +0.2816120, +0.5490940],
                [+0.7868870, -0.2816120, +0.5490940],
                [-0.7868870, -0.2816120, +0.5490940],
                [+0.7868870, +0.2816120, -0.5490940],
                [-0.7868870, +0.2816120, -0.5490940],
                [+0.7868870, -0.2816120, -0.5490940],
                [-0.7868870, -0.2816120, -0.5490940],
                [+0.5764120, +0.3096780, +0.7562070],
                [-0.5764120, +0.3096780, +0.7562070],
                [+0.5764120, -0.3096780, +0.7562070],
                [-0.5764120, -0.3096780, +0.7562070],
                [+0.5764120, +0.3096780, -0.7562070],
                [-0.5764120, +0.3096780, -0.7562070],
                [+0.5764120, -0.3096780, -0.7562070],
                [-0.5764120, -0.3096780, -0.7562070],
                [+0.5764120, +0.7562070, +0.3096780],
                [-0.5764120, +0.7562070, +0.3096780],
                [+0.5764120, -0.7562070, +0.3096780],
                [-0.5764120, -0.7562070, +0.3096780],
                [+0.5764120, +0.7562070, -0.3096780],
                [-0.5764120, +0.7562070, -0.3096780],
                [+0.5764120, -0.7562070, -0.3096780],
                [-0.5764120, -0.7562070, -0.3096780],
                [+0.3096780, +0.5764120, +0.7562070],
                [-0.3096780, +0.5764120, +0.7562070],
                [+0.3096780, -0.5764120, +0.7562070],
                [-0.3096780, -0.5764120, +0.7562070],
                [+0.3096780, +0.5764120, -0.7562070],
                [-0.3096780, +0.5764120, -0.7562070],
                [+0.3096780, -0.5764120, -0.7562070],
                [-0.3096780, -0.5764120, -0.7562070],
                [+0.3096780, +0.7562070, +0.5764120],
                [-0.3096780, +0.7562070, +0.5764120],
                [+0.3096780, -0.7562070, +0.5764120],
                [-0.3096780, -0.7562070, +0.5764120],
                [+0.3096780, +0.7562070, -0.5764120],
                [-0.3096780, +0.7562070, -0.5764120],
                [+0.3096780, -0.7562070, -0.5764120],
                [-0.3096780, -0.7562070, -0.5764120],
                [+0.7562070, +0.5764120, +0.3096780],
                [-0.7562070, +0.5764120, +0.3096780],
                [+0.7562070, -0.5764120, +0.3096780],
                [-0.7562070, -0.5764120, +0.3096780],
                [+0.7562070, +0.5764120, -0.3096780],
                [-0.7562070, +0.5764120, -0.3096780],
                [+0.7562070, -0.5764120, -0.3096780],
                [-0.7562070, -0.5764120, -0.3096780],
                [+0.7562070, +0.3096780, +0.5764120],
                [-0.7562070, +0.3096780, +0.5764120],
                [+0.7562070, -0.3096780, +0.5764120],
                [-0.7562070, -0.3096780, +0.5764120],
                [+0.7562070, +0.3096780, -0.5764120],
                [-0.7562070, +0.3096780, -0.5764120],
                [+0.7562070, -0.3096780, -0.5764120],
                [-0.7562070, -0.3096780, -0.5764120],
                [+0.6025790, +0.3371350, +0.7233530],
                [-0.6025790, +0.3371350, +0.7233530],
                [+0.6025790, -0.3371350, +0.7233530],
                [-0.6025790, -0.3371350, +0.7233530],
                [+0.6025790, +0.3371350, -0.7233530],
                [-0.6025790, +0.3371350, -0.7233530],
                [+0.6025790, -0.3371350, -0.7233530],
                [-0.6025790, -0.3371350, -0.7233530],
                [+0.6025790, +0.7233530, +0.3371350],
                [-0.6025790, +0.7233530, +0.3371350],
                [+0.6025790, -0.7233530, +0.3371350],
                [-0.6025790, -0.7233530, +0.3371350],
                [+0.6025790, +0.7233530, -0.3371350],
                [-0.6025790, +0.7233530, -0.3371350],
                [+0.6025790, -0.7233530, -0.3371350],
                [-0.6025790, -0.7233530, -0.3371350],
                [+0.3371350, +0.6025790, +0.7233530],
                [-0.3371350, +0.6025790, +0.7233530],
                [+0.3371350, -0.6025790, +0.7233530],
                [-0.3371350, -0.6025790, +0.7233530],
                [+0.3371350, +0.6025790, -0.7233530],
                [-0.3371350, +0.6025790, -0.7233530],
                [+0.3371350, -0.6025790, -0.7233530],
                [-0.3371350, -0.6025790, -0.7233530],
                [+0.3371350, +0.7233530, +0.6025790],
                [-0.3371350, +0.7233530, +0.6025790],
                [+0.3371350, -0.7233530, +0.6025790],
                [-0.3371350, -0.7233530, +0.6025790],
                [+0.3371350, +0.7233530, -0.6025790],
                [-0.3371350, +0.7233530, -0.6025790],
                [+0.3371350, -0.7233530, -0.6025790],
                [-0.3371350, -0.7233530, -0.6025790],
                [+0.7233530, +0.6025790, +0.3371350],
                [-0.7233530, +0.6025790, +0.3371350],
                [+0.7233530, -0.6025790, +0.3371350],
                [-0.7233530, -0.6025790, +0.3371350],
                [+0.7233530, +0.6025790, -0.3371350],
                [-0.7233530, +0.6025790, -0.3371350],
                [+0.7233530, -0.6025790, -0.3371350],
                [-0.7233530, -0.6025790, -0.3371350],
                [+0.7233530, +0.3371350, +0.6025790],
                [-0.7233530, +0.3371350, +0.6025790],
                [+0.7233530, -0.3371350, +0.6025790],
                [-0.7233530, -0.3371350, +0.6025790],
                [+0.7233530, +0.3371350, -0.6025790],
                [-0.7233530, +0.3371350, -0.6025790],
                [+0.7233530, -0.3371350, -0.6025790],
                [-0.7233530, -0.3371350, -0.6025790],
                [+0.6275290, +0.3638550, +0.6883440],
                [-0.6275290, +0.3638550, +0.6883440],
                [+0.6275290, -0.3638550, +0.6883440],
                [-0.6275290, -0.3638550, +0.6883440],
                [+0.6275290, +0.3638550, -0.6883440],
                [-0.6275290, +0.3638550, -0.6883440],
                [+0.6275290, -0.3638550, -0.6883440],
                [-0.6275290, -0.3638550, -0.6883440],
                [+0.6275290, +0.6883440, +0.3638550],
                [-0.6275290, +0.6883440, +0.3638550],
                [+0.6275290, -0.6883440, +0.3638550],
                [-0.6275290, -0.6883440, +0.3638550],
                [+0.6275290, +0.6883440, -0.3638550],
                [-0.6275290, +0.6883440, -0.3638550],
                [+0.6275290, -0.6883440, -0.3638550],
                [-0.6275290, -0.6883440, -0.3638550],
                [+0.3638550, +0.6275290, +0.6883440],
                [-0.3638550, +0.6275290, +0.6883440],
                [+0.3638550, -0.6275290, +0.6883440],
                [-0.3638550, -0.6275290, +0.6883440],
                [+0.3638550, +0.6275290, -0.6883440],
                [-0.3638550, +0.6275290, -0.6883440],
                [+0.3638550, -0.6275290, -0.6883440],
                [-0.3638550, -0.6275290, -0.6883440],
                [+0.3638550, +0.6883440, +0.6275290],
                [-0.3638550, +0.6883440, +0.6275290],
                [+0.3638550, -0.6883440, +0.6275290],
                [-0.3638550, -0.6883440, +0.6275290],
                [+0.3638550, +0.6883440, -0.6275290],
                [-0.3638550, +0.6883440, -0.6275290],
                [+0.3638550, -0.6883440, -0.6275290],
                [-0.3638550, -0.6883440, -0.6275290],
                [+0.6883440, +0.6275290, +0.3638550],
                [-0.6883440, +0.6275290, +0.3638550],
                [+0.6883440, -0.6275290, +0.3638550],
                [-0.6883440, -0.6275290, +0.3638550],
                [+0.6883440, +0.6275290, -0.3638550],
                [-0.6883440, +0.6275290, -0.3638550],
                [+0.6883440, -0.6275290, -0.3638550],
                [-0.6883440, -0.6275290, -0.3638550],
                [+0.6883440, +0.3638550, +0.6275290],
                [-0.6883440, +0.3638550, +0.6275290],
                [+0.6883440, -0.3638550, +0.6275290],
                [-0.6883440, -0.3638550, +0.6275290],
                [+0.6883440, +0.3638550, -0.6275290],
                [-0.6883440, +0.3638550, -0.6275290],
                [+0.6883440, -0.3638550, -0.6275290],
                [-0.6883440, -0.3638550, -0.6275290],
                [+0.3348190, +0.0266484, +0.9419060],
                [-0.3348190, +0.0266484, +0.9419060],
                [+0.3348190, -0.0266484, +0.9419060],
                [-0.3348190, -0.0266484, +0.9419060],
                [+0.3348190, +0.0266484, -0.9419060],
                [-0.3348190, +0.0266484, -0.9419060],
                [+0.3348190, -0.0266484, -0.9419060],
                [-0.3348190, -0.0266484, -0.9419060],
                [+0.3348190, +0.9419060, +0.0266484],
                [-0.3348190, +0.9419060, +0.0266484],
                [+0.3348190, -0.9419060, +0.0266484],
                [-0.3348190, -0.9419060, +0.0266484],
                [+0.3348190, +0.9419060, -0.0266484],
                [-0.3348190, +0.9419060, -0.0266484],
                [+0.3348190, -0.9419060, -0.0266484],
                [-0.3348190, -0.9419060, -0.0266484],
                [+0.0266484, +0.3348190, +0.9419060],
                [-0.0266484, +0.3348190, +0.9419060],
                [+0.0266484, -0.3348190, +0.9419060],
                [-0.0266484, -0.3348190, +0.9419060],
                [+0.0266484, +0.3348190, -0.9419060],
                [-0.0266484, +0.3348190, -0.9419060],
                [+0.0266484, -0.3348190, -0.9419060],
                [-0.0266484, -0.3348190, -0.9419060],
                [+0.0266484, +0.9419060, +0.3348190],
                [-0.0266484, +0.9419060, +0.3348190],
                [+0.0266484, -0.9419060, +0.3348190],
                [-0.0266484, -0.9419060, +0.3348190],
                [+0.0266484, +0.9419060, -0.3348190],
                [-0.0266484, +0.9419060, -0.3348190],
                [+0.0266484, -0.9419060, -0.3348190],
                [-0.0266484, -0.9419060, -0.3348190],
                [+0.9419060, +0.3348190, +0.0266484],
                [-0.9419060, +0.3348190, +0.0266484],
                [+0.9419060, -0.3348190, +0.0266484],
                [-0.9419060, -0.3348190, +0.0266484],
                [+0.9419060, +0.3348190, -0.0266484],
                [-0.9419060, +0.3348190, -0.0266484],
                [+0.9419060, -0.3348190, -0.0266484],
                [-0.9419060, -0.3348190, -0.0266484],
                [+0.9419060, +0.0266484, +0.3348190],
                [-0.9419060, +0.0266484, +0.3348190],
                [+0.9419060, -0.0266484, +0.3348190],
                [-0.9419060, -0.0266484, +0.3348190],
                [+0.9419060, +0.0266484, -0.3348190],
                [-0.9419060, +0.0266484, -0.3348190],
                [+0.9419060, -0.0266484, -0.3348190],
                [-0.9419060, -0.0266484, -0.3348190],
                [+0.3699520, +0.0542400, +0.9274660],
                [-0.3699520, +0.0542400, +0.9274660],
                [+0.3699520, -0.0542400, +0.9274660],
                [-0.3699520, -0.0542400, +0.9274660],
                [+0.3699520, +0.0542400, -0.9274660],
                [-0.3699520, +0.0542400, -0.9274660],
                [+0.3699520, -0.0542400, -0.9274660],
                [-0.3699520, -0.0542400, -0.9274660],
                [+0.3699520, +0.9274660, +0.0542400],
                [-0.3699520, +0.9274660, +0.0542400],
                [+0.3699520, -0.9274660, +0.0542400],
                [-0.3699520, -0.9274660, +0.0542400],
                [+0.3699520, +0.9274660, -0.0542400],
                [-0.3699520, +0.9274660, -0.0542400],
                [+0.3699520, -0.9274660, -0.0542400],
                [-0.3699520, -0.9274660, -0.0542400],
                [+0.0542400, +0.3699520, +0.9274660],
                [-0.0542400, +0.3699520, +0.9274660],
                [+0.0542400, -0.3699520, +0.9274660],
                [-0.0542400, -0.3699520, +0.9274660],
                [+0.0542400, +0.3699520, -0.9274660],
                [-0.0542400, +0.3699520, -0.9274660],
                [+0.0542400, -0.3699520, -0.9274660],
                [-0.0542400, -0.3699520, -0.9274660],
                [+0.0542400, +0.9274660, +0.3699520],
                [-0.0542400, +0.9274660, +0.3699520],
                [+0.0542400, -0.9274660, +0.3699520],
                [-0.0542400, -0.9274660, +0.3699520],
                [+0.0542400, +0.9274660, -0.3699520],
                [-0.0542400, +0.9274660, -0.3699520],
                [+0.0542400, -0.9274660, -0.3699520],
                [-0.0542400, -0.9274660, -0.3699520],
                [+0.9274660, +0.3699520, +0.0542400],
                [-0.9274660, +0.3699520, +0.0542400],
                [+0.9274660, -0.3699520, +0.0542400],
                [-0.9274660, -0.3699520, +0.0542400],
                [+0.9274660, +0.3699520, -0.0542400],
                [-0.9274660, +0.3699520, -0.0542400],
                [+0.9274660, -0.3699520, -0.0542400],
                [-0.9274660, -0.3699520, -0.0542400],
                [+0.9274660, +0.0542400, +0.3699520],
                [-0.9274660, +0.0542400, +0.3699520],
                [+0.9274660, -0.0542400, +0.3699520],
                [-0.9274660, -0.0542400, +0.3699520],
                [+0.9274660, +0.0542400, -0.3699520],
                [-0.9274660, +0.0542400, -0.3699520],
                [+0.9274660, -0.0542400, -0.3699520],
                [-0.9274660, -0.0542400, -0.3699520],
                [+0.4042000, +0.0825199, +0.9109400],
                [-0.4042000, +0.0825199, +0.9109400],
                [+0.4042000, -0.0825199, +0.9109400],
                [-0.4042000, -0.0825199, +0.9109400],
                [+0.4042000, +0.0825199, -0.9109400],
                [-0.4042000, +0.0825199, -0.9109400],
                [+0.4042000, -0.0825199, -0.9109400],
                [-0.4042000, -0.0825199, -0.9109400],
                [+0.4042000, +0.9109400, +0.0825199],
                [-0.4042000, +0.9109400, +0.0825199],
                [+0.4042000, -0.9109400, +0.0825199],
                [-0.4042000, -0.9109400, +0.0825199],
                [+0.4042000, +0.9109400, -0.0825199],
                [-0.4042000, +0.9109400, -0.0825199],
                [+0.4042000, -0.9109400, -0.0825199],
                [-0.4042000, -0.9109400, -0.0825199],
                [+0.0825199, +0.4042000, +0.9109400],
                [-0.0825199, +0.4042000, +0.9109400],
                [+0.0825199, -0.4042000, +0.9109400],
                [-0.0825199, -0.4042000, +0.9109400],
                [+0.0825199, +0.4042000, -0.9109400],
                [-0.0825199, +0.4042000, -0.9109400],
                [+0.0825199, -0.4042000, -0.9109400],
                [-0.0825199, -0.4042000, -0.9109400],
                [+0.0825199, +0.9109400, +0.4042000],
                [-0.0825199, +0.9109400, +0.4042000],
                [+0.0825199, -0.9109400, +0.4042000],
                [-0.0825199, -0.9109400, +0.4042000],
                [+0.0825199, +0.9109400, -0.4042000],
                [-0.0825199, +0.9109400, -0.4042000],
                [+0.0825199, -0.9109400, -0.4042000],
                [-0.0825199, -0.9109400, -0.4042000],
                [+0.9109400, +0.4042000, +0.0825199],
                [-0.9109400, +0.4042000, +0.0825199],
                [+0.9109400, -0.4042000, +0.0825199],
                [-0.9109400, -0.4042000, +0.0825199],
                [+0.9109400, +0.4042000, -0.0825199],
                [-0.9109400, +0.4042000, -0.0825199],
                [+0.9109400, -0.4042000, -0.0825199],
                [-0.9109400, -0.4042000, -0.0825199],
                [+0.9109400, +0.0825199, +0.4042000],
                [-0.9109400, +0.0825199, +0.4042000],
                [+0.9109400, -0.0825199, +0.4042000],
                [-0.9109400, -0.0825199, +0.4042000],
                [+0.9109400, +0.0825199, -0.4042000],
                [-0.9109400, +0.0825199, -0.4042000],
                [+0.9109400, -0.0825199, -0.4042000],
                [-0.9109400, -0.0825199, -0.4042000],
                [+0.4375320, +0.1112700, +0.8922920],
                [-0.4375320, +0.1112700, +0.8922920],
                [+0.4375320, -0.1112700, +0.8922920],
                [-0.4375320, -0.1112700, +0.8922920],
                [+0.4375320, +0.1112700, -0.8922920],
                [-0.4375320, +0.1112700, -0.8922920],
                [+0.4375320, -0.1112700, -0.8922920],
                [-0.4375320, -0.1112700, -0.8922920],
                [+0.4375320, +0.8922920, +0.1112700],
                [-0.4375320, +0.8922920, +0.1112700],
                [+0.4375320, -0.8922920, +0.1112700],
                [-0.4375320, -0.8922920, +0.1112700],
                [+0.4375320, +0.8922920, -0.1112700],
                [-0.4375320, +0.8922920, -0.1112700],
                [+0.4375320, -0.8922920, -0.1112700],
                [-0.4375320, -0.8922920, -0.1112700],
                [+0.1112700, +0.4375320, +0.8922920],
                [-0.1112700, +0.4375320, +0.8922920],
                [+0.1112700, -0.4375320, +0.8922920],
                [-0.1112700, -0.4375320, +0.8922920],
                [+0.1112700, +0.4375320, -0.8922920],
                [-0.1112700, +0.4375320, -0.8922920],
                [+0.1112700, -0.4375320, -0.8922920],
                [-0.1112700, -0.4375320, -0.8922920],
                [+0.1112700, +0.8922920, +0.4375320],
                [-0.1112700, +0.8922920, +0.4375320],
                [+0.1112700, -0.8922920, +0.4375320],
                [-0.1112700, -0.8922920, +0.4375320],
                [+0.1112700, +0.8922920, -0.4375320],
                [-0.1112700, +0.8922920, -0.4375320],
                [+0.1112700, -0.8922920, -0.4375320],
                [-0.1112700, -0.8922920, -0.4375320],
                [+0.8922920, +0.4375320, +0.1112700],
                [-0.8922920, +0.4375320, +0.1112700],
                [+0.8922920, -0.4375320, +0.1112700],
                [-0.8922920, -0.4375320, +0.1112700],
                [+0.8922920, +0.4375320, -0.1112700],
                [-0.8922920, +0.4375320, -0.1112700],
                [+0.8922920, -0.4375320, -0.1112700],
                [-0.8922920, -0.4375320, -0.1112700],
                [+0.8922920, +0.1112700, +0.4375320],
                [-0.8922920, +0.1112700, +0.4375320],
                [+0.8922920, -0.1112700, +0.4375320],
                [-0.8922920, -0.1112700, +0.4375320],
                [+0.8922920, +0.1112700, -0.4375320],
                [-0.8922920, +0.1112700, -0.4375320],
                [+0.8922920, -0.1112700, -0.4375320],
                [-0.8922920, -0.1112700, -0.4375320],
                [+0.4699050, +0.1402960, +0.8714960],
                [-0.4699050, +0.1402960, +0.8714960],
                [+0.4699050, -0.1402960, +0.8714960],
                [-0.4699050, -0.1402960, +0.8714960],
                [+0.4699050, +0.1402960, -0.8714960],
                [-0.4699050, +0.1402960, -0.8714960],
                [+0.4699050, -0.1402960, -0.8714960],
                [-0.4699050, -0.1402960, -0.8714960],
                [+0.4699050, +0.8714960, +0.1402960],
                [-0.4699050, +0.8714960, +0.1402960],
                [+0.4699050, -0.8714960, +0.1402960],
                [-0.4699050, -0.8714960, +0.1402960],
                [+0.4699050, +0.8714960, -0.1402960],
                [-0.4699050, +0.8714960, -0.1402960],
                [+0.4699050, -0.8714960, -0.1402960],
                [-0.4699050, -0.8714960, -0.1402960],
                [+0.1402960, +0.4699050, +0.8714960],
                [-0.1402960, +0.4699050, +0.8714960],
                [+0.1402960, -0.4699050, +0.8714960],
                [-0.1402960, -0.4699050, +0.8714960],
                [+0.1402960, +0.4699050, -0.8714960],
                [-0.1402960, +0.4699050, -0.8714960],
                [+0.1402960, -0.4699050, -0.8714960],
                [-0.1402960, -0.4699050, -0.8714960],
                [+0.1402960, +0.8714960, +0.4699050],
                [-0.1402960, +0.8714960, +0.4699050],
                [+0.1402960, -0.8714960, +0.4699050],
                [-0.1402960, -0.8714960, +0.4699050],
                [+0.1402960, +0.8714960, -0.4699050],
                [-0.1402960, +0.8714960, -0.4699050],
                [+0.1402960, -0.8714960, -0.4699050],
                [-0.1402960, -0.8714960, -0.4699050],
                [+0.8714960, +0.4699050, +0.1402960],
                [-0.8714960, +0.4699050, +0.1402960],
                [+0.8714960, -0.4699050, +0.1402960],
                [-0.8714960, -0.4699050, +0.1402960],
                [+0.8714960, +0.4699050, -0.1402960],
                [-0.8714960, +0.4699050, -0.1402960],
                [+0.8714960, -0.4699050, -0.1402960],
                [-0.8714960, -0.4699050, -0.1402960],
                [+0.8714960, +0.1402960, +0.4699050],
                [-0.8714960, +0.1402960, +0.4699050],
                [+0.8714960, -0.1402960, +0.4699050],
                [-0.8714960, -0.1402960, +0.4699050],
                [+0.8714960, +0.1402960, -0.4699050],
                [-0.8714960, +0.1402960, -0.4699050],
                [+0.8714960, -0.1402960, -0.4699050],
                [-0.8714960, -0.1402960, -0.4699050],
                [+0.5012740, +0.1694280, +0.8485390],
                [-0.5012740, +0.1694280, +0.8485390],
                [+0.5012740, -0.1694280, +0.8485390],
                [-0.5012740, -0.1694280, +0.8485390],
                [+0.5012740, +0.1694280, -0.8485390],
                [-0.5012740, +0.1694280, -0.8485390],
                [+0.5012740, -0.1694280, -0.8485390],
                [-0.5012740, -0.1694280, -0.8485390],
                [+0.5012740, +0.8485390, +0.1694280],
                [-0.5012740, +0.8485390, +0.1694280],
                [+0.5012740, -0.8485390, +0.1694280],
                [-0.5012740, -0.8485390, +0.1694280],
                [+0.5012740, +0.8485390, -0.1694280],
                [-0.5012740, +0.8485390, -0.1694280],
                [+0.5012740, -0.8485390, -0.1694280],
                [-0.5012740, -0.8485390, -0.1694280],
                [+0.1694280, +0.5012740, +0.8485390],
                [-0.1694280, +0.5012740, +0.8485390],
                [+0.1694280, -0.5012740, +0.8485390],
                [-0.1694280, -0.5012740, +0.8485390],
                [+0.1694280, +0.5012740, -0.8485390],
                [-0.1694280, +0.5012740, -0.8485390],
                [+0.1694280, -0.5012740, -0.8485390],
                [-0.1694280, -0.5012740, -0.8485390],
                [+0.1694280, +0.8485390, +0.5012740],
                [-0.1694280, +0.8485390, +0.5012740],
                [+0.1694280, -0.8485390, +0.5012740],
                [-0.1694280, -0.8485390, +0.5012740],
                [+0.1694280, +0.8485390, -0.5012740],
                [-0.1694280, +0.8485390, -0.5012740],
                [+0.1694280, -0.8485390, -0.5012740],
                [-0.1694280, -0.8485390, -0.5012740],
                [+0.8485390, +0.5012740, +0.1694280],
                [-0.8485390, +0.5012740, +0.1694280],
                [+0.8485390, -0.5012740, +0.1694280],
                [-0.8485390, -0.5012740, +0.1694280],
                [+0.8485390, +0.5012740, -0.1694280],
                [-0.8485390, +0.5012740, -0.1694280],
                [+0.8485390, -0.5012740, -0.1694280],
                [-0.8485390, -0.5012740, -0.1694280],
                [+0.8485390, +0.1694280, +0.5012740],
                [-0.8485390, +0.1694280, +0.5012740],
                [+0.8485390, -0.1694280, +0.5012740],
                [-0.8485390, -0.1694280, +0.5012740],
                [+0.8485390, +0.1694280, -0.5012740],
                [-0.8485390, +0.1694280, -0.5012740],
                [+0.8485390, -0.1694280, -0.5012740],
                [-0.8485390, -0.1694280, -0.5012740],
                [+0.5315870, +0.1985040, +0.8234140],
                [-0.5315870, +0.1985040, +0.8234140],
                [+0.5315870, -0.1985040, +0.8234140],
                [-0.5315870, -0.1985040, +0.8234140],
                [+0.5315870, +0.1985040, -0.8234140],
                [-0.5315870, +0.1985040, -0.8234140],
                [+0.5315870, -0.1985040, -0.8234140],
                [-0.5315870, -0.1985040, -0.8234140],
                [+0.5315870, +0.8234140, +0.1985040],
                [-0.5315870, +0.8234140, +0.1985040],
                [+0.5315870, -0.8234140, +0.1985040],
                [-0.5315870, -0.8234140, +0.1985040],
                [+0.5315870, +0.8234140, -0.1985040],
                [-0.5315870, +0.8234140, -0.1985040],
                [+0.5315870, -0.8234140, -0.1985040],
                [-0.5315870, -0.8234140, -0.1985040],
                [+0.1985040, +0.5315870, +0.8234140],
                [-0.1985040, +0.5315870, +0.8234140],
                [+0.1985040, -0.5315870, +0.8234140],
                [-0.1985040, -0.5315870, +0.8234140],
                [+0.1985040, +0.5315870, -0.8234140],
                [-0.1985040, +0.5315870, -0.8234140],
                [+0.1985040, -0.5315870, -0.8234140],
                [-0.1985040, -0.5315870, -0.8234140],
                [+0.1985040, +0.8234140, +0.5315870],
                [-0.1985040, +0.8234140, +0.5315870],
                [+0.1985040, -0.8234140, +0.5315870],
                [-0.1985040, -0.8234140, +0.5315870],
                [+0.1985040, +0.8234140, -0.5315870],
                [-0.1985040, +0.8234140, -0.5315870],
                [+0.1985040, -0.8234140, -0.5315870],
                [-0.1985040, -0.8234140, -0.5315870],
                [+0.8234140, +0.5315870, +0.1985040],
                [-0.8234140, +0.5315870, +0.1985040],
                [+0.8234140, -0.5315870, +0.1985040],
                [-0.8234140, -0.5315870, +0.1985040],
                [+0.8234140, +0.5315870, -0.1985040],
                [-0.8234140, +0.5315870, -0.1985040],
                [+0.8234140, -0.5315870, -0.1985040],
                [-0.8234140, -0.5315870, -0.1985040],
                [+0.8234140, +0.1985040, +0.5315870],
                [-0.8234140, +0.1985040, +0.5315870],
                [+0.8234140, -0.1985040, +0.5315870],
                [-0.8234140, -0.1985040, +0.5315870],
                [+0.8234140, +0.1985040, -0.5315870],
                [-0.8234140, +0.1985040, -0.5315870],
                [+0.8234140, -0.1985040, -0.5315870],
                [-0.8234140, -0.1985040, -0.5315870],
                [+0.5607940, +0.2273770, +0.7961220],
                [-0.5607940, +0.2273770, +0.7961220],
                [+0.5607940, -0.2273770, +0.7961220],
                [-0.5607940, -0.2273770, +0.7961220],
                [+0.5607940, +0.2273770, -0.7961220],
                [-0.5607940, +0.2273770, -0.7961220],
                [+0.5607940, -0.2273770, -0.7961220],
                [-0.5607940, -0.2273770, -0.7961220],
                [+0.5607940, +0.7961220, +0.2273770],
                [-0.5607940, +0.7961220, +0.2273770],
                [+0.5607940, -0.7961220, +0.2273770],
                [-0.5607940, -0.7961220, +0.2273770],
                [+0.5607940, +0.7961220, -0.2273770],
                [-0.5607940, +0.7961220, -0.2273770],
                [+0.5607940, -0.7961220, -0.2273770],
                [-0.5607940, -0.7961220, -0.2273770],
                [+0.2273770, +0.5607940, +0.7961220],
                [-0.2273770, +0.5607940, +0.7961220],
                [+0.2273770, -0.5607940, +0.7961220],
                [-0.2273770, -0.5607940, +0.7961220],
                [+0.2273770, +0.5607940, -0.7961220],
                [-0.2273770, +0.5607940, -0.7961220],
                [+0.2273770, -0.5607940, -0.7961220],
                [-0.2273770, -0.5607940, -0.7961220],
                [+0.2273770, +0.7961220, +0.5607940],
                [-0.2273770, +0.7961220, +0.5607940],
                [+0.2273770, -0.7961220, +0.5607940],
                [-0.2273770, -0.7961220, +0.5607940],
                [+0.2273770, +0.7961220, -0.5607940],
                [-0.2273770, +0.7961220, -0.5607940],
                [+0.2273770, -0.7961220, -0.5607940],
                [-0.2273770, -0.7961220, -0.5607940],
                [+0.7961220, +0.5607940, +0.2273770],
                [-0.7961220, +0.5607940, +0.2273770],
                [+0.7961220, -0.5607940, +0.2273770],
                [-0.7961220, -0.5607940, +0.2273770],
                [+0.7961220, +0.5607940, -0.2273770],
                [-0.7961220, +0.5607940, -0.2273770],
                [+0.7961220, -0.5607940, -0.2273770],
                [-0.7961220, -0.5607940, -0.2273770],
                [+0.7961220, +0.2273770, +0.5607940],
                [-0.7961220, +0.2273770, +0.5607940],
                [+0.7961220, -0.2273770, +0.5607940],
                [-0.7961220, -0.2273770, +0.5607940],
                [+0.7961220, +0.2273770, -0.5607940],
                [-0.7961220, +0.2273770, -0.5607940],
                [+0.7961220, -0.2273770, -0.5607940],
                [-0.7961220, -0.2273770, -0.5607940],
                [+0.5888390, +0.2559040, +0.7666690],
                [-0.5888390, +0.2559040, +0.7666690],
                [+0.5888390, -0.2559040, +0.7666690],
                [-0.5888390, -0.2559040, +0.7666690],
                [+0.5888390, +0.2559040, -0.7666690],
                [-0.5888390, +0.2559040, -0.7666690],
                [+0.5888390, -0.2559040, -0.7666690],
                [-0.5888390, -0.2559040, -0.7666690],
                [+0.5888390, +0.7666690, +0.2559040],
                [-0.5888390, +0.7666690, +0.2559040],
                [+0.5888390, -0.7666690, +0.2559040],
                [-0.5888390, -0.7666690, +0.2559040],
                [+0.5888390, +0.7666690, -0.2559040],
                [-0.5888390, +0.7666690, -0.2559040],
                [+0.5888390, -0.7666690, -0.2559040],
                [-0.5888390, -0.7666690, -0.2559040],
                [+0.2559040, +0.5888390, +0.7666690],
                [-0.2559040, +0.5888390, +0.7666690],
                [+0.2559040, -0.5888390, +0.7666690],
                [-0.2559040, -0.5888390, +0.7666690],
                [+0.2559040, +0.5888390, -0.7666690],
                [-0.2559040, +0.5888390, -0.7666690],
                [+0.2559040, -0.5888390, -0.7666690],
                [-0.2559040, -0.5888390, -0.7666690],
                [+0.2559040, +0.7666690, +0.5888390],
                [-0.2559040, +0.7666690, +0.5888390],
                [+0.2559040, -0.7666690, +0.5888390],
                [-0.2559040, -0.7666690, +0.5888390],
                [+0.2559040, +0.7666690, -0.5888390],
                [-0.2559040, +0.7666690, -0.5888390],
                [+0.2559040, -0.7666690, -0.5888390],
                [-0.2559040, -0.7666690, -0.5888390],
                [+0.7666690, +0.5888390, +0.2559040],
                [-0.7666690, +0.5888390, +0.2559040],
                [+0.7666690, -0.5888390, +0.2559040],
                [-0.7666690, -0.5888390, +0.2559040],
                [+0.7666690, +0.5888390, -0.2559040],
                [-0.7666690, +0.5888390, -0.2559040],
                [+0.7666690, -0.5888390, -0.2559040],
                [-0.7666690, -0.5888390, -0.2559040],
                [+0.7666690, +0.2559040, +0.5888390],
                [-0.7666690, +0.2559040, +0.5888390],
                [+0.7666690, -0.2559040, +0.5888390],
                [-0.7666690, -0.2559040, +0.5888390],
                [+0.7666690, +0.2559040, -0.5888390],
                [-0.7666690, +0.2559040, -0.5888390],
                [+0.7666690, -0.2559040, -0.5888390],
                [-0.7666690, -0.2559040, -0.5888390],
                [+0.6156710, +0.2839500, +0.7350660],
                [-0.6156710, +0.2839500, +0.7350660],
                [+0.6156710, -0.2839500, +0.7350660],
                [-0.6156710, -0.2839500, +0.7350660],
                [+0.6156710, +0.2839500, -0.7350660],
                [-0.6156710, +0.2839500, -0.7350660],
                [+0.6156710, -0.2839500, -0.7350660],
                [-0.6156710, -0.2839500, -0.7350660],
                [+0.6156710, +0.7350660, +0.2839500],
                [-0.6156710, +0.7350660, +0.2839500],
                [+0.6156710, -0.7350660, +0.2839500],
                [-0.6156710, -0.7350660, +0.2839500],
                [+0.6156710, +0.7350660, -0.2839500],
                [-0.6156710, +0.7350660, -0.2839500],
                [+0.6156710, -0.7350660, -0.2839500],
                [-0.6156710, -0.7350660, -0.2839500],
                [+0.2839500, +0.6156710, +0.7350660],
                [-0.2839500, +0.6156710, +0.7350660],
                [+0.2839500, -0.6156710, +0.7350660],
                [-0.2839500, -0.6156710, +0.7350660],
                [+0.2839500, +0.6156710, -0.7350660],
                [-0.2839500, +0.6156710, -0.7350660],
                [+0.2839500, -0.6156710, -0.7350660],
                [-0.2839500, -0.6156710, -0.7350660],
                [+0.2839500, +0.7350660, +0.6156710],
                [-0.2839500, +0.7350660, +0.6156710],
                [+0.2839500, -0.7350660, +0.6156710],
                [-0.2839500, -0.7350660, +0.6156710],
                [+0.2839500, +0.7350660, -0.6156710],
                [-0.2839500, +0.7350660, -0.6156710],
                [+0.2839500, -0.7350660, -0.6156710],
                [-0.2839500, -0.7350660, -0.6156710],
                [+0.7350660, +0.6156710, +0.2839500],
                [-0.7350660, +0.6156710, +0.2839500],
                [+0.7350660, -0.6156710, +0.2839500],
                [-0.7350660, -0.6156710, +0.2839500],
                [+0.7350660, +0.6156710, -0.2839500],
                [-0.7350660, +0.6156710, -0.2839500],
                [+0.7350660, -0.6156710, -0.2839500],
                [-0.7350660, -0.6156710, -0.2839500],
                [+0.7350660, +0.2839500, +0.6156710],
                [-0.7350660, +0.2839500, +0.6156710],
                [+0.7350660, -0.2839500, +0.6156710],
                [-0.7350660, -0.2839500, +0.6156710],
                [+0.7350660, +0.2839500, -0.6156710],
                [-0.7350660, +0.2839500, -0.6156710],
                [+0.7350660, -0.2839500, -0.6156710],
                [-0.7350660, -0.2839500, -0.6156710],
                [+0.6412340, +0.3113790, +0.7013290],
                [-0.6412340, +0.3113790, +0.7013290],
                [+0.6412340, -0.3113790, +0.7013290],
                [-0.6412340, -0.3113790, +0.7013290],
                [+0.6412340, +0.3113790, -0.7013290],
                [-0.6412340, +0.3113790, -0.7013290],
                [+0.6412340, -0.3113790, -0.7013290],
                [-0.6412340, -0.3113790, -0.7013290],
                [+0.6412340, +0.7013290, +0.3113790],
                [-0.6412340, +0.7013290, +0.3113790],
                [+0.6412340, -0.7013290, +0.3113790],
                [-0.6412340, -0.7013290, +0.3113790],
                [+0.6412340, +0.7013290, -0.3113790],
                [-0.6412340, +0.7013290, -0.3113790],
                [+0.6412340, -0.7013290, -0.3113790],
                [-0.6412340, -0.7013290, -0.3113790],
                [+0.3113790, +0.6412340, +0.7013290],
                [-0.3113790, +0.6412340, +0.7013290],
                [+0.3113790, -0.6412340, +0.7013290],
                [-0.3113790, -0.6412340, +0.7013290],
                [+0.3113790, +0.6412340, -0.7013290],
                [-0.3113790, +0.6412340, -0.7013290],
                [+0.3113790, -0.6412340, -0.7013290],
                [-0.3113790, -0.6412340, -0.7013290],
                [+0.3113790, +0.7013290, +0.6412340],
                [-0.3113790, +0.7013290, +0.6412340],
                [+0.3113790, -0.7013290, +0.6412340],
                [-0.3113790, -0.7013290, +0.6412340],
                [+0.3113790, +0.7013290, -0.6412340],
                [-0.3113790, +0.7013290, -0.6412340],
                [+0.3113790, -0.7013290, -0.6412340],
                [-0.3113790, -0.7013290, -0.6412340],
                [+0.7013290, +0.6412340, +0.3113790],
                [-0.7013290, +0.6412340, +0.3113790],
                [+0.7013290, -0.6412340, +0.3113790],
                [-0.7013290, -0.6412340, +0.3113790],
                [+0.7013290, +0.6412340, -0.3113790],
                [-0.7013290, +0.6412340, -0.3113790],
                [+0.7013290, -0.6412340, -0.3113790],
                [-0.7013290, -0.6412340, -0.3113790],
                [+0.7013290, +0.3113790, +0.6412340],
                [-0.7013290, +0.3113790, +0.6412340],
                [+0.7013290, -0.3113790, +0.6412340],
                [-0.7013290, -0.3113790, +0.6412340],
                [+0.7013290, +0.3113790, -0.6412340],
                [-0.7013290, +0.3113790, -0.6412340],
                [+0.7013290, -0.3113790, -0.6412340],
                [-0.7013290, -0.3113790, -0.6412340],
                [+0.4076050, +0.0275779, +0.9127420],
                [-0.4076050, +0.0275779, +0.9127420],
                [+0.4076050, -0.0275779, +0.9127420],
                [-0.4076050, -0.0275779, +0.9127420],
                [+0.4076050, +0.0275779, -0.9127420],
                [-0.4076050, +0.0275779, -0.9127420],
                [+0.4076050, -0.0275779, -0.9127420],
                [-0.4076050, -0.0275779, -0.9127420],
                [+0.4076050, +0.9127420, +0.0275779],
                [-0.4076050, +0.9127420, +0.0275779],
                [+0.4076050, -0.9127420, +0.0275779],
                [-0.4076050, -0.9127420, +0.0275779],
                [+0.4076050, +0.9127420, -0.0275779],
                [-0.4076050, +0.9127420, -0.0275779],
                [+0.4076050, -0.9127420, -0.0275779],
                [-0.4076050, -0.9127420, -0.0275779],
                [+0.0275779, +0.4076050, +0.9127420],
                [-0.0275779, +0.4076050, +0.9127420],
                [+0.0275779, -0.4076050, +0.9127420],
                [-0.0275779, -0.4076050, +0.9127420],
                [+0.0275779, +0.4076050, -0.9127420],
                [-0.0275779, +0.4076050, -0.9127420],
                [+0.0275779, -0.4076050, -0.9127420],
                [-0.0275779, -0.4076050, -0.9127420],
                [+0.0275779, +0.9127420, +0.4076050],
                [-0.0275779, +0.9127420, +0.4076050],
                [+0.0275779, -0.9127420, +0.4076050],
                [-0.0275779, -0.9127420, +0.4076050],
                [+0.0275779, +0.9127420, -0.4076050],
                [-0.0275779, +0.9127420, -0.4076050],
                [+0.0275779, -0.9127420, -0.4076050],
                [-0.0275779, -0.9127420, -0.4076050],
                [+0.9127420, +0.4076050, +0.0275779],
                [-0.9127420, +0.4076050, +0.0275779],
                [+0.9127420, -0.4076050, +0.0275779],
                [-0.9127420, -0.4076050, +0.0275779],
                [+0.9127420, +0.4076050, -0.0275779],
                [-0.9127420, +0.4076050, -0.0275779],
                [+0.9127420, -0.4076050, -0.0275779],
                [-0.9127420, -0.4076050, -0.0275779],
                [+0.9127420, +0.0275779, +0.4076050],
                [-0.9127420, +0.0275779, +0.4076050],
                [+0.9127420, -0.0275779, +0.4076050],
                [-0.9127420, -0.0275779, +0.4076050],
                [+0.9127420, +0.0275779, -0.4076050],
                [-0.9127420, +0.0275779, -0.4076050],
                [+0.9127420, -0.0275779, -0.4076050],
                [-0.9127420, -0.0275779, -0.4076050],
                [+0.4423790, +0.0558414, +0.8950880],
                [-0.4423790, +0.0558414, +0.8950880],
                [+0.4423790, -0.0558414, +0.8950880],
                [-0.4423790, -0.0558414, +0.8950880],
                [+0.4423790, +0.0558414, -0.8950880],
                [-0.4423790, +0.0558414, -0.8950880],
                [+0.4423790, -0.0558414, -0.8950880],
                [-0.4423790, -0.0558414, -0.8950880],
                [+0.4423790, +0.8950880, +0.0558414],
                [-0.4423790, +0.8950880, +0.0558414],
                [+0.4423790, -0.8950880, +0.0558414],
                [-0.4423790, -0.8950880, +0.0558414],
                [+0.4423790, +0.8950880, -0.0558414],
                [-0.4423790, +0.8950880, -0.0558414],
                [+0.4423790, -0.8950880, -0.0558414],
                [-0.4423790, -0.8950880, -0.0558414],
                [+0.0558414, +0.4423790, +0.8950880],
                [-0.0558414, +0.4423790, +0.8950880],
                [+0.0558414, -0.4423790, +0.8950880],
                [-0.0558414, -0.4423790, +0.8950880],
                [+0.0558414, +0.4423790, -0.8950880],
                [-0.0558414, +0.4423790, -0.8950880],
                [+0.0558414, -0.4423790, -0.8950880],
                [-0.0558414, -0.4423790, -0.8950880],
                [+0.0558414, +0.8950880, +0.4423790],
                [-0.0558414, +0.8950880, +0.4423790],
                [+0.0558414, -0.8950880, +0.4423790],
                [-0.0558414, -0.8950880, +0.4423790],
                [+0.0558414, +0.8950880, -0.4423790],
                [-0.0558414, +0.8950880, -0.4423790],
                [+0.0558414, -0.8950880, -0.4423790],
                [-0.0558414, -0.8950880, -0.4423790],
                [+0.8950880, +0.4423790, +0.0558414],
                [-0.8950880, +0.4423790, +0.0558414],
                [+0.8950880, -0.4423790, +0.0558414],
                [-0.8950880, -0.4423790, +0.0558414],
                [+0.8950880, +0.4423790, -0.0558414],
                [-0.8950880, +0.4423790, -0.0558414],
                [+0.8950880, -0.4423790, -0.0558414],
                [-0.8950880, -0.4423790, -0.0558414],
                [+0.8950880, +0.0558414, +0.4423790],
                [-0.8950880, +0.0558414, +0.4423790],
                [+0.8950880, -0.0558414, +0.4423790],
                [-0.8950880, -0.0558414, +0.4423790],
                [+0.8950880, +0.0558414, -0.4423790],
                [-0.8950880, +0.0558414, -0.4423790],
                [+0.8950880, -0.0558414, -0.4423790],
                [-0.8950880, -0.0558414, -0.4423790],
                [+0.4760480, +0.0845777, +0.8753430],
                [-0.4760480, +0.0845777, +0.8753430],
                [+0.4760480, -0.0845777, +0.8753430],
                [-0.4760480, -0.0845777, +0.8753430],
                [+0.4760480, +0.0845777, -0.8753430],
                [-0.4760480, +0.0845777, -0.8753430],
                [+0.4760480, -0.0845777, -0.8753430],
                [-0.4760480, -0.0845777, -0.8753430],
                [+0.4760480, +0.8753430, +0.0845777],
                [-0.4760480, +0.8753430, +0.0845777],
                [+0.4760480, -0.8753430, +0.0845777],
                [-0.4760480, -0.8753430, +0.0845777],
                [+0.4760480, +0.8753430, -0.0845777],
                [-0.4760480, +0.8753430, -0.0845777],
                [+0.4760480, -0.8753430, -0.0845777],
                [-0.4760480, -0.8753430, -0.0845777],
                [+0.0845777, +0.4760480, +0.8753430],
                [-0.0845777, +0.4760480, +0.8753430],
                [+0.0845777, -0.4760480, +0.8753430],
                [-0.0845777, -0.4760480, +0.8753430],
                [+0.0845777, +0.4760480, -0.8753430],
                [-0.0845777, +0.4760480, -0.8753430],
                [+0.0845777, -0.4760480, -0.8753430],
                [-0.0845777, -0.4760480, -0.8753430],
                [+0.0845777, +0.8753430, +0.4760480],
                [-0.0845777, +0.8753430, +0.4760480],
                [+0.0845777, -0.8753430, +0.4760480],
                [-0.0845777, -0.8753430, +0.4760480],
                [+0.0845777, +0.8753430, -0.4760480],
                [-0.0845777, +0.8753430, -0.4760480],
                [+0.0845777, -0.8753430, -0.4760480],
                [-0.0845777, -0.8753430, -0.4760480],
                [+0.8753430, +0.4760480, +0.0845777],
                [-0.8753430, +0.4760480, +0.0845777],
                [+0.8753430, -0.4760480, +0.0845777],
                [-0.8753430, -0.4760480, +0.0845777],
                [+0.8753430, +0.4760480, -0.0845777],
                [-0.8753430, +0.4760480, -0.0845777],
                [+0.8753430, -0.4760480, -0.0845777],
                [-0.8753430, -0.4760480, -0.0845777],
                [+0.8753430, +0.0845777, +0.4760480],
                [-0.8753430, +0.0845777, +0.4760480],
                [+0.8753430, -0.0845777, +0.4760480],
                [-0.8753430, -0.0845777, +0.4760480],
                [+0.8753430, +0.0845777, -0.4760480],
                [-0.8753430, +0.0845777, -0.4760480],
                [+0.8753430, -0.0845777, -0.4760480],
                [-0.8753430, -0.0845777, -0.4760480],
                [+0.5085840, +0.1135980, +0.8534860],
                [-0.5085840, +0.1135980, +0.8534860],
                [+0.5085840, -0.1135980, +0.8534860],
                [-0.5085840, -0.1135980, +0.8534860],
                [+0.5085840, +0.1135980, -0.8534860],
                [-0.5085840, +0.1135980, -0.8534860],
                [+0.5085840, -0.1135980, -0.8534860],
                [-0.5085840, -0.1135980, -0.8534860],
                [+0.5085840, +0.8534860, +0.1135980],
                [-0.5085840, +0.8534860, +0.1135980],
                [+0.5085840, -0.8534860, +0.1135980],
                [-0.5085840, -0.8534860, +0.1135980],
                [+0.5085840, +0.8534860, -0.1135980],
                [-0.5085840, +0.8534860, -0.1135980],
                [+0.5085840, -0.8534860, -0.1135980],
                [-0.5085840, -0.8534860, -0.1135980],
                [+0.1135980, +0.5085840, +0.8534860],
                [-0.1135980, +0.5085840, +0.8534860],
                [+0.1135980, -0.5085840, +0.8534860],
                [-0.1135980, -0.5085840, +0.8534860],
                [+0.1135980, +0.5085840, -0.8534860],
                [-0.1135980, +0.5085840, -0.8534860],
                [+0.1135980, -0.5085840, -0.8534860],
                [-0.1135980, -0.5085840, -0.8534860],
                [+0.1135980, +0.8534860, +0.5085840],
                [-0.1135980, +0.8534860, +0.5085840],
                [+0.1135980, -0.8534860, +0.5085840],
                [-0.1135980, -0.8534860, +0.5085840],
                [+0.1135980, +0.8534860, -0.5085840],
                [-0.1135980, +0.8534860, -0.5085840],
                [+0.1135980, -0.8534860, -0.5085840],
                [-0.1135980, -0.8534860, -0.5085840],
                [+0.8534860, +0.5085840, +0.1135980],
                [-0.8534860, +0.5085840, +0.1135980],
                [+0.8534860, -0.5085840, +0.1135980],
                [-0.8534860, -0.5085840, +0.1135980],
                [+0.8534860, +0.5085840, -0.1135980],
                [-0.8534860, +0.5085840, -0.1135980],
                [+0.8534860, -0.5085840, -0.1135980],
                [-0.8534860, -0.5085840, -0.1135980],
                [+0.8534860, +0.1135980, +0.5085840],
                [-0.8534860, +0.1135980, +0.5085840],
                [+0.8534860, -0.1135980, +0.5085840],
                [-0.8534860, -0.1135980, +0.5085840],
                [+0.8534860, +0.1135980, -0.5085840],
                [-0.8534860, +0.1135980, -0.5085840],
                [+0.8534860, -0.1135980, -0.5085840],
                [-0.8534860, -0.1135980, -0.5085840],
                [+0.5399510, +0.1427290, +0.8295070],
                [-0.5399510, +0.1427290, +0.8295070],
                [+0.5399510, -0.1427290, +0.8295070],
                [-0.5399510, -0.1427290, +0.8295070],
                [+0.5399510, +0.1427290, -0.8295070],
                [-0.5399510, +0.1427290, -0.8295070],
                [+0.5399510, -0.1427290, -0.8295070],
                [-0.5399510, -0.1427290, -0.8295070],
                [+0.5399510, +0.8295070, +0.1427290],
                [-0.5399510, +0.8295070, +0.1427290],
                [+0.5399510, -0.8295070, +0.1427290],
                [-0.5399510, -0.8295070, +0.1427290],
                [+0.5399510, +0.8295070, -0.1427290],
                [-0.5399510, +0.8295070, -0.1427290],
                [+0.5399510, -0.8295070, -0.1427290],
                [-0.5399510, -0.8295070, -0.1427290],
                [+0.1427290, +0.5399510, +0.8295070],
                [-0.1427290, +0.5399510, +0.8295070],
                [+0.1427290, -0.5399510, +0.8295070],
                [-0.1427290, -0.5399510, +0.8295070],
                [+0.1427290, +0.5399510, -0.8295070],
                [-0.1427290, +0.5399510, -0.8295070],
                [+0.1427290, -0.5399510, -0.8295070],
                [-0.1427290, -0.5399510, -0.8295070],
                [+0.1427290, +0.8295070, +0.5399510],
                [-0.1427290, +0.8295070, +0.5399510],
                [+0.1427290, -0.8295070, +0.5399510],
                [-0.1427290, -0.8295070, +0.5399510],
                [+0.1427290, +0.8295070, -0.5399510],
                [-0.1427290, +0.8295070, -0.5399510],
                [+0.1427290, -0.8295070, -0.5399510],
                [-0.1427290, -0.8295070, -0.5399510],
                [+0.8295070, +0.5399510, +0.1427290],
                [-0.8295070, +0.5399510, +0.1427290],
                [+0.8295070, -0.5399510, +0.1427290],
                [-0.8295070, -0.5399510, +0.1427290],
                [+0.8295070, +0.5399510, -0.1427290],
                [-0.8295070, +0.5399510, -0.1427290],
                [+0.8295070, -0.5399510, -0.1427290],
                [-0.8295070, -0.5399510, -0.1427290],
                [+0.8295070, +0.1427290, +0.5399510],
                [-0.8295070, +0.1427290, +0.5399510],
                [+0.8295070, -0.1427290, +0.5399510],
                [-0.8295070, -0.1427290, +0.5399510],
                [+0.8295070, +0.1427290, -0.5399510],
                [-0.8295070, +0.1427290, -0.5399510],
                [+0.8295070, -0.1427290, -0.5399510],
                [-0.8295070, -0.1427290, -0.5399510],
                [+0.5701120, +0.1718110, +0.8034010],
                [-0.5701120, +0.1718110, +0.8034010],
                [+0.5701120, -0.1718110, +0.8034010],
                [-0.5701120, -0.1718110, +0.8034010],
                [+0.5701120, +0.1718110, -0.8034010],
                [-0.5701120, +0.1718110, -0.8034010],
                [+0.5701120, -0.1718110, -0.8034010],
                [-0.5701120, -0.1718110, -0.8034010],
                [+0.5701120, +0.8034010, +0.1718110],
                [-0.5701120, +0.8034010, +0.1718110],
                [+0.5701120, -0.8034010, +0.1718110],
                [-0.5701120, -0.8034010, +0.1718110],
                [+0.5701120, +0.8034010, -0.1718110],
                [-0.5701120, +0.8034010, -0.1718110],
                [+0.5701120, -0.8034010, -0.1718110],
                [-0.5701120, -0.8034010, -0.1718110],
                [+0.1718110, +0.5701120, +0.8034010],
                [-0.1718110, +0.5701120, +0.8034010],
                [+0.1718110, -0.5701120, +0.8034010],
                [-0.1718110, -0.5701120, +0.8034010],
                [+0.1718110, +0.5701120, -0.8034010],
                [-0.1718110, +0.5701120, -0.8034010],
                [+0.1718110, -0.5701120, -0.8034010],
                [-0.1718110, -0.5701120, -0.8034010],
                [+0.1718110, +0.8034010, +0.5701120],
                [-0.1718110, +0.8034010, +0.5701120],
                [+0.1718110, -0.8034010, +0.5701120],
                [-0.1718110, -0.8034010, +0.5701120],
                [+0.1718110, +0.8034010, -0.5701120],
                [-0.1718110, +0.8034010, -0.5701120],
                [+0.1718110, -0.8034010, -0.5701120],
                [-0.1718110, -0.8034010, -0.5701120],
                [+0.8034010, +0.5701120, +0.1718110],
                [-0.8034010, +0.5701120, +0.1718110],
                [+0.8034010, -0.5701120, +0.1718110],
                [-0.8034010, -0.5701120, +0.1718110],
                [+0.8034010, +0.5701120, -0.1718110],
                [-0.8034010, +0.5701120, -0.1718110],
                [+0.8034010, -0.5701120, -0.1718110],
                [-0.8034010, -0.5701120, -0.1718110],
                [+0.8034010, +0.1718110, +0.5701120],
                [-0.8034010, +0.1718110, +0.5701120],
                [+0.8034010, -0.1718110, +0.5701120],
                [-0.8034010, -0.1718110, +0.5701120],
                [+0.8034010, +0.1718110, -0.5701120],
                [-0.8034010, +0.1718110, -0.5701120],
                [+0.8034010, -0.1718110, -0.5701120],
                [-0.8034010, -0.1718110, -0.5701120],
                [+0.5990240, +0.2006940, +0.7751720],
                [-0.5990240, +0.2006940, +0.7751720],
                [+0.5990240, -0.2006940, +0.7751720],
                [-0.5990240, -0.2006940, +0.7751720],
                [+0.5990240, +0.2006940, -0.7751720],
                [-0.5990240, +0.2006940, -0.7751720],
                [+0.5990240, -0.2006940, -0.7751720],
                [-0.5990240, -0.2006940, -0.7751720],
                [+0.5990240, +0.7751720, +0.2006940],
                [-0.5990240, +0.7751720, +0.2006940],
                [+0.5990240, -0.7751720, +0.2006940],
                [-0.5990240, -0.7751720, +0.2006940],
                [+0.5990240, +0.7751720, -0.2006940],
                [-0.5990240, +0.7751720, -0.2006940],
                [+0.5990240, -0.7751720, -0.2006940],
                [-0.5990240, -0.7751720, -0.2006940],
                [+0.2006940, +0.5990240, +0.7751720],
                [-0.2006940, +0.5990240, +0.7751720],
                [+0.2006940, -0.5990240, +0.7751720],
                [-0.2006940, -0.5990240, +0.7751720],
                [+0.2006940, +0.5990240, -0.7751720],
                [-0.2006940, +0.5990240, -0.7751720],
                [+0.2006940, -0.5990240, -0.7751720],
                [-0.2006940, -0.5990240, -0.7751720],
                [+0.2006940, +0.7751720, +0.5990240],
                [-0.2006940, +0.7751720, +0.5990240],
                [+0.2006940, -0.7751720, +0.5990240],
                [-0.2006940, -0.7751720, +0.5990240],
                [+0.2006940, +0.7751720, -0.5990240],
                [-0.2006940, +0.7751720, -0.5990240],
                [+0.2006940, -0.7751720, -0.5990240],
                [-0.2006940, -0.7751720, -0.5990240],
                [+0.7751720, +0.5990240, +0.2006940],
                [-0.7751720, +0.5990240, +0.2006940],
                [+0.7751720, -0.5990240, +0.2006940],
                [-0.7751720, -0.5990240, +0.2006940],
                [+0.7751720, +0.5990240, -0.2006940],
                [-0.7751720, +0.5990240, -0.2006940],
                [+0.7751720, -0.5990240, -0.2006940],
                [-0.7751720, -0.5990240, -0.2006940],
                [+0.7751720, +0.2006940, +0.5990240],
                [-0.7751720, +0.2006940, +0.5990240],
                [+0.7751720, -0.2006940, +0.5990240],
                [-0.7751720, -0.2006940, +0.5990240],
                [+0.7751720, +0.2006940, -0.5990240],
                [-0.7751720, +0.2006940, -0.5990240],
                [+0.7751720, -0.2006940, -0.5990240],
                [-0.7751720, -0.2006940, -0.5990240],
                [+0.6266450, +0.2292340, +0.7448270],
                [-0.6266450, +0.2292340, +0.7448270],
                [+0.6266450, -0.2292340, +0.7448270],
                [-0.6266450, -0.2292340, +0.7448270],
                [+0.6266450, +0.2292340, -0.7448270],
                [-0.6266450, +0.2292340, -0.7448270],
                [+0.6266450, -0.2292340, -0.7448270],
                [-0.6266450, -0.2292340, -0.7448270],
                [+0.6266450, +0.7448270, +0.2292340],
                [-0.6266450, +0.7448270, +0.2292340],
                [+0.6266450, -0.7448270, +0.2292340],
                [-0.6266450, -0.7448270, +0.2292340],
                [+0.6266450, +0.7448270, -0.2292340],
                [-0.6266450, +0.7448270, -0.2292340],
                [+0.6266450, -0.7448270, -0.2292340],
                [-0.6266450, -0.7448270, -0.2292340],
                [+0.2292340, +0.6266450, +0.7448270],
                [-0.2292340, +0.6266450, +0.7448270],
                [+0.2292340, -0.6266450, +0.7448270],
                [-0.2292340, -0.6266450, +0.7448270],
                [+0.2292340, +0.6266450, -0.7448270],
                [-0.2292340, +0.6266450, -0.7448270],
                [+0.2292340, -0.6266450, -0.7448270],
                [-0.2292340, -0.6266450, -0.7448270],
                [+0.2292340, +0.7448270, +0.6266450],
                [-0.2292340, +0.7448270, +0.6266450],
                [+0.2292340, -0.7448270, +0.6266450],
                [-0.2292340, -0.7448270, +0.6266450],
                [+0.2292340, +0.7448270, -0.6266450],
                [-0.2292340, +0.7448270, -0.6266450],
                [+0.2292340, -0.7448270, -0.6266450],
                [-0.2292340, -0.7448270, -0.6266450],
                [+0.7448270, +0.6266450, +0.2292340],
                [-0.7448270, +0.6266450, +0.2292340],
                [+0.7448270, -0.6266450, +0.2292340],
                [-0.7448270, -0.6266450, +0.2292340],
                [+0.7448270, +0.6266450, -0.2292340],
                [-0.7448270, +0.6266450, -0.2292340],
                [+0.7448270, -0.6266450, -0.2292340],
                [-0.7448270, -0.6266450, -0.2292340],
                [+0.7448270, +0.2292340, +0.6266450],
                [-0.7448270, +0.2292340, +0.6266450],
                [+0.7448270, -0.2292340, +0.6266450],
                [-0.7448270, -0.2292340, +0.6266450],
                [+0.7448270, +0.2292340, -0.6266450],
                [-0.7448270, +0.2292340, -0.6266450],
                [+0.7448270, -0.2292340, -0.6266450],
                [-0.7448270, -0.2292340, -0.6266450],
                [+0.6529320, +0.2572870, +0.7123780],
                [-0.6529320, +0.2572870, +0.7123780],
                [+0.6529320, -0.2572870, +0.7123780],
                [-0.6529320, -0.2572870, +0.7123780],
                [+0.6529320, +0.2572870, -0.7123780],
                [-0.6529320, +0.2572870, -0.7123780],
                [+0.6529320, -0.2572870, -0.7123780],
                [-0.6529320, -0.2572870, -0.7123780],
                [+0.6529320, +0.7123780, +0.2572870],
                [-0.6529320, +0.7123780, +0.2572870],
                [+0.6529320, -0.7123780, +0.2572870],
                [-0.6529320, -0.7123780, +0.2572870],
                [+0.6529320, +0.7123780, -0.2572870],
                [-0.6529320, +0.7123780, -0.2572870],
                [+0.6529320, -0.7123780, -0.2572870],
                [-0.6529320, -0.7123780, -0.2572870],
                [+0.2572870, +0.6529320, +0.7123780],
                [-0.2572870, +0.6529320, +0.7123780],
                [+0.2572870, -0.6529320, +0.7123780],
                [-0.2572870, -0.6529320, +0.7123780],
                [+0.2572870, +0.6529320, -0.7123780],
                [-0.2572870, +0.6529320, -0.7123780],
                [+0.2572870, -0.6529320, -0.7123780],
                [-0.2572870, -0.6529320, -0.7123780],
                [+0.2572870, +0.7123780, +0.6529320],
                [-0.2572870, +0.7123780, +0.6529320],
                [+0.2572870, -0.7123780, +0.6529320],
                [-0.2572870, -0.7123780, +0.6529320],
                [+0.2572870, +0.7123780, -0.6529320],
                [-0.2572870, +0.7123780, -0.6529320],
                [+0.2572870, -0.7123780, -0.6529320],
                [-0.2572870, -0.7123780, -0.6529320],
                [+0.7123780, +0.6529320, +0.2572870],
                [-0.7123780, +0.6529320, +0.2572870],
                [+0.7123780, -0.6529320, +0.2572870],
                [-0.7123780, -0.6529320, +0.2572870],
                [+0.7123780, +0.6529320, -0.2572870],
                [-0.7123780, +0.6529320, -0.2572870],
                [+0.7123780, -0.6529320, -0.2572870],
                [-0.7123780, -0.6529320, -0.2572870],
                [+0.7123780, +0.2572870, +0.6529320],
                [-0.7123780, +0.2572870, +0.6529320],
                [+0.7123780, -0.2572870, +0.6529320],
                [-0.7123780, -0.2572870, +0.6529320],
                [+0.7123780, +0.2572870, -0.6529320],
                [-0.7123780, +0.2572870, -0.6529320],
                [+0.7123780, -0.2572870, -0.6529320],
                [-0.7123780, -0.2572870, -0.6529320],
                [+0.4791580, +0.0282609, +0.8772730],
                [-0.4791580, +0.0282609, +0.8772730],
                [+0.4791580, -0.0282609, +0.8772730],
                [-0.4791580, -0.0282609, +0.8772730],
                [+0.4791580, +0.0282609, -0.8772730],
                [-0.4791580, +0.0282609, -0.8772730],
                [+0.4791580, -0.0282609, -0.8772730],
                [-0.4791580, -0.0282609, -0.8772730],
                [+0.4791580, +0.8772730, +0.0282609],
                [-0.4791580, +0.8772730, +0.0282609],
                [+0.4791580, -0.8772730, +0.0282609],
                [-0.4791580, -0.8772730, +0.0282609],
                [+0.4791580, +0.8772730, -0.0282609],
                [-0.4791580, +0.8772730, -0.0282609],
                [+0.4791580, -0.8772730, -0.0282609],
                [-0.4791580, -0.8772730, -0.0282609],
                [+0.0282609, +0.4791580, +0.8772730],
                [-0.0282609, +0.4791580, +0.8772730],
                [+0.0282609, -0.4791580, +0.8772730],
                [-0.0282609, -0.4791580, +0.8772730],
                [+0.0282609, +0.4791580, -0.8772730],
                [-0.0282609, +0.4791580, -0.8772730],
                [+0.0282609, -0.4791580, -0.8772730],
                [-0.0282609, -0.4791580, -0.8772730],
                [+0.0282609, +0.8772730, +0.4791580],
                [-0.0282609, +0.8772730, +0.4791580],
                [+0.0282609, -0.8772730, +0.4791580],
                [-0.0282609, -0.8772730, +0.4791580],
                [+0.0282609, +0.8772730, -0.4791580],
                [-0.0282609, +0.8772730, -0.4791580],
                [+0.0282609, -0.8772730, -0.4791580],
                [-0.0282609, -0.8772730, -0.4791580],
                [+0.8772730, +0.4791580, +0.0282609],
                [-0.8772730, +0.4791580, +0.0282609],
                [+0.8772730, -0.4791580, +0.0282609],
                [-0.8772730, -0.4791580, +0.0282609],
                [+0.8772730, +0.4791580, -0.0282609],
                [-0.8772730, +0.4791580, -0.0282609],
                [+0.8772730, -0.4791580, -0.0282609],
                [-0.8772730, -0.4791580, -0.0282609],
                [+0.8772730, +0.0282609, +0.4791580],
                [-0.8772730, +0.0282609, +0.4791580],
                [+0.8772730, -0.0282609, +0.4791580],
                [-0.8772730, -0.0282609, +0.4791580],
                [+0.8772730, +0.0282609, -0.4791580],
                [-0.8772730, +0.0282609, -0.4791580],
                [+0.8772730, -0.0282609, -0.4791580],
                [-0.8772730, -0.0282609, -0.4791580],
                [+0.5130370, +0.0569987, +0.8564720],
                [-0.5130370, +0.0569987, +0.8564720],
                [+0.5130370, -0.0569987, +0.8564720],
                [-0.5130370, -0.0569987, +0.8564720],
                [+0.5130370, +0.0569987, -0.8564720],
                [-0.5130370, +0.0569987, -0.8564720],
                [+0.5130370, -0.0569987, -0.8564720],
                [-0.5130370, -0.0569987, -0.8564720],
                [+0.5130370, +0.8564720, +0.0569987],
                [-0.5130370, +0.8564720, +0.0569987],
                [+0.5130370, -0.8564720, +0.0569987],
                [-0.5130370, -0.8564720, +0.0569987],
                [+0.5130370, +0.8564720, -0.0569987],
                [-0.5130370, +0.8564720, -0.0569987],
                [+0.5130370, -0.8564720, -0.0569987],
                [-0.5130370, -0.8564720, -0.0569987],
                [+0.0569987, +0.5130370, +0.8564720],
                [-0.0569987, +0.5130370, +0.8564720],
                [+0.0569987, -0.5130370, +0.8564720],
                [-0.0569987, -0.5130370, +0.8564720],
                [+0.0569987, +0.5130370, -0.8564720],
                [-0.0569987, +0.5130370, -0.8564720],
                [+0.0569987, -0.5130370, -0.8564720],
                [-0.0569987, -0.5130370, -0.8564720],
                [+0.0569987, +0.8564720, +0.5130370],
                [-0.0569987, +0.8564720, +0.5130370],
                [+0.0569987, -0.8564720, +0.5130370],
                [-0.0569987, -0.8564720, +0.5130370],
                [+0.0569987, +0.8564720, -0.5130370],
                [-0.0569987, +0.8564720, -0.5130370],
                [+0.0569987, -0.8564720, -0.5130370],
                [-0.0569987, -0.8564720, -0.5130370],
                [+0.8564720, +0.5130370, +0.0569987],
                [-0.8564720, +0.5130370, +0.0569987],
                [+0.8564720, -0.5130370, +0.0569987],
                [-0.8564720, -0.5130370, +0.0569987],
                [+0.8564720, +0.5130370, -0.0569987],
                [-0.8564720, +0.5130370, -0.0569987],
                [+0.8564720, -0.5130370, -0.0569987],
                [-0.8564720, -0.5130370, -0.0569987],
                [+0.8564720, +0.0569987, +0.5130370],
                [-0.8564720, +0.0569987, +0.5130370],
                [+0.8564720, -0.0569987, +0.5130370],
                [-0.8564720, -0.0569987, +0.5130370],
                [+0.8564720, +0.0569987, -0.5130370],
                [-0.8564720, +0.0569987, -0.5130370],
                [+0.8564720, -0.0569987, -0.5130370],
                [-0.8564720, -0.0569987, -0.5130370],
                [+0.5456250, +0.0860271, +0.8336020],
                [-0.5456250, +0.0860271, +0.8336020],
                [+0.5456250, -0.0860271, +0.8336020],
                [-0.5456250, -0.0860271, +0.8336020],
                [+0.5456250, +0.0860271, -0.8336020],
                [-0.5456250, +0.0860271, -0.8336020],
                [+0.5456250, -0.0860271, -0.8336020],
                [-0.5456250, -0.0860271, -0.8336020],
                [+0.5456250, +0.8336020, +0.0860271],
                [-0.5456250, +0.8336020, +0.0860271],
                [+0.5456250, -0.8336020, +0.0860271],
                [-0.5456250, -0.8336020, +0.0860271],
                [+0.5456250, +0.8336020, -0.0860271],
                [-0.5456250, +0.8336020, -0.0860271],
                [+0.5456250, -0.8336020, -0.0860271],
                [-0.5456250, -0.8336020, -0.0860271],
                [+0.0860271, +0.5456250, +0.8336020],
                [-0.0860271, +0.5456250, +0.8336020],
                [+0.0860271, -0.5456250, +0.8336020],
                [-0.0860271, -0.5456250, +0.8336020],
                [+0.0860271, +0.5456250, -0.8336020],
                [-0.0860271, +0.5456250, -0.8336020],
                [+0.0860271, -0.5456250, -0.8336020],
                [-0.0860271, -0.5456250, -0.8336020],
                [+0.0860271, +0.8336020, +0.5456250],
                [-0.0860271, +0.8336020, +0.5456250],
                [+0.0860271, -0.8336020, +0.5456250],
                [-0.0860271, -0.8336020, +0.5456250],
                [+0.0860271, +0.8336020, -0.5456250],
                [-0.0860271, +0.8336020, -0.5456250],
                [+0.0860271, -0.8336020, -0.5456250],
                [-0.0860271, -0.8336020, -0.5456250],
                [+0.8336020, +0.5456250, +0.0860271],
                [-0.8336020, +0.5456250, +0.0860271],
                [+0.8336020, -0.5456250, +0.0860271],
                [-0.8336020, -0.5456250, +0.0860271],
                [+0.8336020, +0.5456250, -0.0860271],
                [-0.8336020, +0.5456250, -0.0860271],
                [+0.8336020, -0.5456250, -0.0860271],
                [-0.8336020, -0.5456250, -0.0860271],
                [+0.8336020, +0.0860271, +0.5456250],
                [-0.8336020, +0.0860271, +0.5456250],
                [+0.8336020, -0.0860271, +0.5456250],
                [-0.8336020, -0.0860271, +0.5456250],
                [+0.8336020, +0.0860271, -0.5456250],
                [-0.8336020, +0.0860271, -0.5456250],
                [+0.8336020, -0.0860271, -0.5456250],
                [-0.8336020, -0.0860271, -0.5456250],
                [+0.5768960, +0.1151750, +0.8086570],
                [-0.5768960, +0.1151750, +0.8086570],
                [+0.5768960, -0.1151750, +0.8086570],
                [-0.5768960, -0.1151750, +0.8086570],
                [+0.5768960, +0.1151750, -0.8086570],
                [-0.5768960, +0.1151750, -0.8086570],
                [+0.5768960, -0.1151750, -0.8086570],
                [-0.5768960, -0.1151750, -0.8086570],
                [+0.5768960, +0.8086570, +0.1151750],
                [-0.5768960, +0.8086570, +0.1151750],
                [+0.5768960, -0.8086570, +0.1151750],
                [-0.5768960, -0.8086570, +0.1151750],
                [+0.5768960, +0.8086570, -0.1151750],
                [-0.5768960, +0.8086570, -0.1151750],
                [+0.5768960, -0.8086570, -0.1151750],
                [-0.5768960, -0.8086570, -0.1151750],
                [+0.1151750, +0.5768960, +0.8086570],
                [-0.1151750, +0.5768960, +0.8086570],
                [+0.1151750, -0.5768960, +0.8086570],
                [-0.1151750, -0.5768960, +0.8086570],
                [+0.1151750, +0.5768960, -0.8086570],
                [-0.1151750, +0.5768960, -0.8086570],
                [+0.1151750, -0.5768960, -0.8086570],
                [-0.1151750, -0.5768960, -0.8086570],
                [+0.1151750, +0.8086570, +0.5768960],
                [-0.1151750, +0.8086570, +0.5768960],
                [+0.1151750, -0.8086570, +0.5768960],
                [-0.1151750, -0.8086570, +0.5768960],
                [+0.1151750, +0.8086570, -0.5768960],
                [-0.1151750, +0.8086570, -0.5768960],
                [+0.1151750, -0.8086570, -0.5768960],
                [-0.1151750, -0.8086570, -0.5768960],
                [+0.8086570, +0.5768960, +0.1151750],
                [-0.8086570, +0.5768960, +0.1151750],
                [+0.8086570, -0.5768960, +0.1151750],
                [-0.8086570, -0.5768960, +0.1151750],
                [+0.8086570, +0.5768960, -0.1151750],
                [-0.8086570, +0.5768960, -0.1151750],
                [+0.8086570, -0.5768960, -0.1151750],
                [-0.8086570, -0.5768960, -0.1151750],
                [+0.8086570, +0.1151750, +0.5768960],
                [-0.8086570, +0.1151750, +0.5768960],
                [+0.8086570, -0.1151750, +0.5768960],
                [-0.8086570, -0.1151750, +0.5768960],
                [+0.8086570, +0.1151750, -0.5768960],
                [-0.8086570, +0.1151750, -0.5768960],
                [+0.8086570, -0.1151750, -0.5768960],
                [-0.8086570, -0.1151750, -0.5768960],
                [+0.6068190, +0.1442810, +0.7816350],
                [-0.6068190, +0.1442810, +0.7816350],
                [+0.6068190, -0.1442810, +0.7816350],
                [-0.6068190, -0.1442810, +0.7816350],
                [+0.6068190, +0.1442810, -0.7816350],
                [-0.6068190, +0.1442810, -0.7816350],
                [+0.6068190, -0.1442810, -0.7816350],
                [-0.6068190, -0.1442810, -0.7816350],
                [+0.6068190, +0.7816350, +0.1442810],
                [-0.6068190, +0.7816350, +0.1442810],
                [+0.6068190, -0.7816350, +0.1442810],
                [-0.6068190, -0.7816350, +0.1442810],
                [+0.6068190, +0.7816350, -0.1442810],
                [-0.6068190, +0.7816350, -0.1442810],
                [+0.6068190, -0.7816350, -0.1442810],
                [-0.6068190, -0.7816350, -0.1442810],
                [+0.1442810, +0.6068190, +0.7816350],
                [-0.1442810, +0.6068190, +0.7816350],
                [+0.1442810, -0.6068190, +0.7816350],
                [-0.1442810, -0.6068190, +0.7816350],
                [+0.1442810, +0.6068190, -0.7816350],
                [-0.1442810, +0.6068190, -0.7816350],
                [+0.1442810, -0.6068190, -0.7816350],
                [-0.1442810, -0.6068190, -0.7816350],
                [+0.1442810, +0.7816350, +0.6068190],
                [-0.1442810, +0.7816350, +0.6068190],
                [+0.1442810, -0.7816350, +0.6068190],
                [-0.1442810, -0.7816350, +0.6068190],
                [+0.1442810, +0.7816350, -0.6068190],
                [-0.1442810, +0.7816350, -0.6068190],
                [+0.1442810, -0.7816350, -0.6068190],
                [-0.1442810, -0.7816350, -0.6068190],
                [+0.7816350, +0.6068190, +0.1442810],
                [-0.7816350, +0.6068190, +0.1442810],
                [+0.7816350, -0.6068190, +0.1442810],
                [-0.7816350, -0.6068190, +0.1442810],
                [+0.7816350, +0.6068190, -0.1442810],
                [-0.7816350, +0.6068190, -0.1442810],
                [+0.7816350, -0.6068190, -0.1442810],
                [-0.7816350, -0.6068190, -0.1442810],
                [+0.7816350, +0.1442810, +0.6068190],
                [-0.7816350, +0.1442810, +0.6068190],
                [+0.7816350, -0.1442810, +0.6068190],
                [-0.7816350, -0.1442810, +0.6068190],
                [+0.7816350, +0.1442810, -0.6068190],
                [-0.7816350, +0.1442810, -0.6068190],
                [+0.7816350, -0.1442810, -0.6068190],
                [-0.7816350, -0.1442810, -0.6068190],
                [+0.6353620, +0.1731930, +0.7525420],
                [-0.6353620, +0.1731930, +0.7525420],
                [+0.6353620, -0.1731930, +0.7525420],
                [-0.6353620, -0.1731930, +0.7525420],
                [+0.6353620, +0.1731930, -0.7525420],
                [-0.6353620, +0.1731930, -0.7525420],
                [+0.6353620, -0.1731930, -0.7525420],
                [-0.6353620, -0.1731930, -0.7525420],
                [+0.6353620, +0.7525420, +0.1731930],
                [-0.6353620, +0.7525420, +0.1731930],
                [+0.6353620, -0.7525420, +0.1731930],
                [-0.6353620, -0.7525420, +0.1731930],
                [+0.6353620, +0.7525420, -0.1731930],
                [-0.6353620, +0.7525420, -0.1731930],
                [+0.6353620, -0.7525420, -0.1731930],
                [-0.6353620, -0.7525420, -0.1731930],
                [+0.1731930, +0.6353620, +0.7525420],
                [-0.1731930, +0.6353620, +0.7525420],
                [+0.1731930, -0.6353620, +0.7525420],
                [-0.1731930, -0.6353620, +0.7525420],
                [+0.1731930, +0.6353620, -0.7525420],
                [-0.1731930, +0.6353620, -0.7525420],
                [+0.1731930, -0.6353620, -0.7525420],
                [-0.1731930, -0.6353620, -0.7525420],
                [+0.1731930, +0.7525420, +0.6353620],
                [-0.1731930, +0.7525420, +0.6353620],
                [+0.1731930, -0.7525420, +0.6353620],
                [-0.1731930, -0.7525420, +0.6353620],
                [+0.1731930, +0.7525420, -0.6353620],
                [-0.1731930, +0.7525420, -0.6353620],
                [+0.1731930, -0.7525420, -0.6353620],
                [-0.1731930, -0.7525420, -0.6353620],
                [+0.7525420, +0.6353620, +0.1731930],
                [-0.7525420, +0.6353620, +0.1731930],
                [+0.7525420, -0.6353620, +0.1731930],
                [-0.7525420, -0.6353620, +0.1731930],
                [+0.7525420, +0.6353620, -0.1731930],
                [-0.7525420, +0.6353620, -0.1731930],
                [+0.7525420, -0.6353620, -0.1731930],
                [-0.7525420, -0.6353620, -0.1731930],
                [+0.7525420, +0.1731930, +0.6353620],
                [-0.7525420, +0.1731930, +0.6353620],
                [+0.7525420, -0.1731930, +0.6353620],
                [-0.7525420, -0.1731930, +0.6353620],
                [+0.7525420, +0.1731930, -0.6353620],
                [-0.7525420, +0.1731930, -0.6353620],
                [+0.7525420, -0.1731930, -0.6353620],
                [-0.7525420, -0.1731930, -0.6353620],
                [+0.6624930, +0.2017620, +0.7213840],
                [-0.6624930, +0.2017620, +0.7213840],
                [+0.6624930, -0.2017620, +0.7213840],
                [-0.6624930, -0.2017620, +0.7213840],
                [+0.6624930, +0.2017620, -0.7213840],
                [-0.6624930, +0.2017620, -0.7213840],
                [+0.6624930, -0.2017620, -0.7213840],
                [-0.6624930, -0.2017620, -0.7213840],
                [+0.6624930, +0.7213840, +0.2017620],
                [-0.6624930, +0.7213840, +0.2017620],
                [+0.6624930, -0.7213840, +0.2017620],
                [-0.6624930, -0.7213840, +0.2017620],
                [+0.6624930, +0.7213840, -0.2017620],
                [-0.6624930, +0.7213840, -0.2017620],
                [+0.6624930, -0.7213840, -0.2017620],
                [-0.6624930, -0.7213840, -0.2017620],
                [+0.2017620, +0.6624930, +0.7213840],
                [-0.2017620, +0.6624930, +0.7213840],
                [+0.2017620, -0.6624930, +0.7213840],
                [-0.2017620, -0.6624930, +0.7213840],
                [+0.2017620, +0.6624930, -0.7213840],
                [-0.2017620, +0.6624930, -0.7213840],
                [+0.2017620, -0.6624930, -0.7213840],
                [-0.2017620, -0.6624930, -0.7213840],
                [+0.2017620, +0.7213840, +0.6624930],
                [-0.2017620, +0.7213840, +0.6624930],
                [+0.2017620, -0.7213840, +0.6624930],
                [-0.2017620, -0.7213840, +0.6624930],
                [+0.2017620, +0.7213840, -0.6624930],
                [-0.2017620, +0.7213840, -0.6624930],
                [+0.2017620, -0.7213840, -0.6624930],
                [-0.2017620, -0.7213840, -0.6624930],
                [+0.7213840, +0.6624930, +0.2017620],
                [-0.7213840, +0.6624930, +0.2017620],
                [+0.7213840, -0.6624930, +0.2017620],
                [-0.7213840, -0.6624930, +0.2017620],
                [+0.7213840, +0.6624930, -0.2017620],
                [-0.7213840, +0.6624930, -0.2017620],
                [+0.7213840, -0.6624930, -0.2017620],
                [-0.7213840, -0.6624930, -0.2017620],
                [+0.7213840, +0.2017620, +0.6624930],
                [-0.7213840, +0.2017620, +0.6624930],
                [+0.7213840, -0.2017620, +0.6624930],
                [-0.7213840, -0.2017620, +0.6624930],
                [+0.7213840, +0.2017620, -0.6624930],
                [-0.7213840, +0.2017620, -0.6624930],
                [+0.7213840, -0.2017620, -0.6624930],
                [-0.7213840, -0.2017620, -0.6624930],
                [+0.5484930, +0.0287422, +0.8356610],
                [-0.5484930, +0.0287422, +0.8356610],
                [+0.5484930, -0.0287422, +0.8356610],
                [-0.5484930, -0.0287422, +0.8356610],
                [+0.5484930, +0.0287422, -0.8356610],
                [-0.5484930, +0.0287422, -0.8356610],
                [+0.5484930, -0.0287422, -0.8356610],
                [-0.5484930, -0.0287422, -0.8356610],
                [+0.5484930, +0.8356610, +0.0287422],
                [-0.5484930, +0.8356610, +0.0287422],
                [+0.5484930, -0.8356610, +0.0287422],
                [-0.5484930, -0.8356610, +0.0287422],
                [+0.5484930, +0.8356610, -0.0287422],
                [-0.5484930, +0.8356610, -0.0287422],
                [+0.5484930, -0.8356610, -0.0287422],
                [-0.5484930, -0.8356610, -0.0287422],
                [+0.0287422, +0.5484930, +0.8356610],
                [-0.0287422, +0.5484930, +0.8356610],
                [+0.0287422, -0.5484930, +0.8356610],
                [-0.0287422, -0.5484930, +0.8356610],
                [+0.0287422, +0.5484930, -0.8356610],
                [-0.0287422, +0.5484930, -0.8356610],
                [+0.0287422, -0.5484930, -0.8356610],
                [-0.0287422, -0.5484930, -0.8356610],
                [+0.0287422, +0.8356610, +0.5484930],
                [-0.0287422, +0.8356610, +0.5484930],
                [+0.0287422, -0.8356610, +0.5484930],
                [-0.0287422, -0.8356610, +0.5484930],
                [+0.0287422, +0.8356610, -0.5484930],
                [-0.0287422, +0.8356610, -0.5484930],
                [+0.0287422, -0.8356610, -0.5484930],
                [-0.0287422, -0.8356610, -0.5484930],
                [+0.8356610, +0.5484930, +0.0287422],
                [-0.8356610, +0.5484930, +0.0287422],
                [+0.8356610, -0.5484930, +0.0287422],
                [-0.8356610, -0.5484930, +0.0287422],
                [+0.8356610, +0.5484930, -0.0287422],
                [-0.8356610, +0.5484930, -0.0287422],
                [+0.8356610, -0.5484930, -0.0287422],
                [-0.8356610, -0.5484930, -0.0287422],
                [+0.8356610, +0.0287422, +0.5484930],
                [-0.8356610, +0.0287422, +0.5484930],
                [+0.8356610, -0.0287422, +0.5484930],
                [-0.8356610, -0.0287422, +0.5484930],
                [+0.8356610, +0.0287422, -0.5484930],
                [-0.8356610, +0.0287422, -0.5484930],
                [+0.8356610, -0.0287422, -0.5484930],
                [-0.8356610, -0.0287422, -0.5484930],
                [+0.5810210, +0.0577831, +0.8118350],
                [-0.5810210, +0.0577831, +0.8118350],
                [+0.5810210, -0.0577831, +0.8118350],
                [-0.5810210, -0.0577831, +0.8118350],
                [+0.5810210, +0.0577831, -0.8118350],
                [-0.5810210, +0.0577831, -0.8118350],
                [+0.5810210, -0.0577831, -0.8118350],
                [-0.5810210, -0.0577831, -0.8118350],
                [+0.5810210, +0.8118350, +0.0577831],
                [-0.5810210, +0.8118350, +0.0577831],
                [+0.5810210, -0.8118350, +0.0577831],
                [-0.5810210, -0.8118350, +0.0577831],
                [+0.5810210, +0.8118350, -0.0577831],
                [-0.5810210, +0.8118350, -0.0577831],
                [+0.5810210, -0.8118350, -0.0577831],
                [-0.5810210, -0.8118350, -0.0577831],
                [+0.0577831, +0.5810210, +0.8118350],
                [-0.0577831, +0.5810210, +0.8118350],
                [+0.0577831, -0.5810210, +0.8118350],
                [-0.0577831, -0.5810210, +0.8118350],
                [+0.0577831, +0.5810210, -0.8118350],
                [-0.0577831, +0.5810210, -0.8118350],
                [+0.0577831, -0.5810210, -0.8118350],
                [-0.0577831, -0.5810210, -0.8118350],
                [+0.0577831, +0.8118350, +0.5810210],
                [-0.0577831, +0.8118350, +0.5810210],
                [+0.0577831, -0.8118350, +0.5810210],
                [-0.0577831, -0.8118350, +0.5810210],
                [+0.0577831, +0.8118350, -0.5810210],
                [-0.0577831, +0.8118350, -0.5810210],
                [+0.0577831, -0.8118350, -0.5810210],
                [-0.0577831, -0.8118350, -0.5810210],
                [+0.8118350, +0.5810210, +0.0577831],
                [-0.8118350, +0.5810210, +0.0577831],
                [+0.8118350, -0.5810210, +0.0577831],
                [-0.8118350, -0.5810210, +0.0577831],
                [+0.8118350, +0.5810210, -0.0577831],
                [-0.8118350, +0.5810210, -0.0577831],
                [+0.8118350, -0.5810210, -0.0577831],
                [-0.8118350, -0.5810210, -0.0577831],
                [+0.8118350, +0.0577831, +0.5810210],
                [-0.8118350, +0.0577831, +0.5810210],
                [+0.8118350, -0.0577831, +0.5810210],
                [-0.8118350, -0.0577831, +0.5810210],
                [+0.8118350, +0.0577831, -0.5810210],
                [-0.8118350, +0.0577831, -0.5810210],
                [+0.8118350, -0.0577831, -0.5810210],
                [-0.8118350, -0.0577831, -0.5810210],
                [+0.6120960, +0.0869526, +0.7859890],
                [-0.6120960, +0.0869526, +0.7859890],
                [+0.6120960, -0.0869526, +0.7859890],
                [-0.6120960, -0.0869526, +0.7859890],
                [+0.6120960, +0.0869526, -0.7859890],
                [-0.6120960, +0.0869526, -0.7859890],
                [+0.6120960, -0.0869526, -0.7859890],
                [-0.6120960, -0.0869526, -0.7859890],
                [+0.6120960, +0.7859890, +0.0869526],
                [-0.6120960, +0.7859890, +0.0869526],
                [+0.6120960, -0.7859890, +0.0869526],
                [-0.6120960, -0.7859890, +0.0869526],
                [+0.6120960, +0.7859890, -0.0869526],
                [-0.6120960, +0.7859890, -0.0869526],
                [+0.6120960, -0.7859890, -0.0869526],
                [-0.6120960, -0.7859890, -0.0869526],
                [+0.0869526, +0.6120960, +0.7859890],
                [-0.0869526, +0.6120960, +0.7859890],
                [+0.0869526, -0.6120960, +0.7859890],
                [-0.0869526, -0.6120960, +0.7859890],
                [+0.0869526, +0.6120960, -0.7859890],
                [-0.0869526, +0.6120960, -0.7859890],
                [+0.0869526, -0.6120960, -0.7859890],
                [-0.0869526, -0.6120960, -0.7859890],
                [+0.0869526, +0.7859890, +0.6120960],
                [-0.0869526, +0.7859890, +0.6120960],
                [+0.0869526, -0.7859890, +0.6120960],
                [-0.0869526, -0.7859890, +0.6120960],
                [+0.0869526, +0.7859890, -0.6120960],
                [-0.0869526, +0.7859890, -0.6120960],
                [+0.0869526, -0.7859890, -0.6120960],
                [-0.0869526, -0.7859890, -0.6120960],
                [+0.7859890, +0.6120960, +0.0869526],
                [-0.7859890, +0.6120960, +0.0869526],
                [+0.7859890, -0.6120960, +0.0869526],
                [-0.7859890, -0.6120960, +0.0869526],
                [+0.7859890, +0.6120960, -0.0869526],
                [-0.7859890, +0.6120960, -0.0869526],
                [+0.7859890, -0.6120960, -0.0869526],
                [-0.7859890, -0.6120960, -0.0869526],
                [+0.7859890, +0.0869526, +0.6120960],
                [-0.7859890, +0.0869526, +0.6120960],
                [+0.7859890, -0.0869526, +0.6120960],
                [-0.7859890, -0.0869526, +0.6120960],
                [+0.7859890, +0.0869526, -0.6120960],
                [-0.7859890, +0.0869526, -0.6120960],
                [+0.7859890, -0.0869526, -0.6120960],
                [-0.7859890, -0.0869526, -0.6120960],
                [+0.6416940, +0.1160890, +0.7581240],
                [-0.6416940, +0.1160890, +0.7581240],
                [+0.6416940, -0.1160890, +0.7581240],
                [-0.6416940, -0.1160890, +0.7581240],
                [+0.6416940, +0.1160890, -0.7581240],
                [-0.6416940, +0.1160890, -0.7581240],
                [+0.6416940, -0.1160890, -0.7581240],
                [-0.6416940, -0.1160890, -0.7581240],
                [+0.6416940, +0.7581240, +0.1160890],
                [-0.6416940, +0.7581240, +0.1160890],
                [+0.6416940, -0.7581240, +0.1160890],
                [-0.6416940, -0.7581240, +0.1160890],
                [+0.6416940, +0.7581240, -0.1160890],
                [-0.6416940, +0.7581240, -0.1160890],
                [+0.6416940, -0.7581240, -0.1160890],
                [-0.6416940, -0.7581240, -0.1160890],
                [+0.1160890, +0.6416940, +0.7581240],
                [-0.1160890, +0.6416940, +0.7581240],
                [+0.1160890, -0.6416940, +0.7581240],
                [-0.1160890, -0.6416940, +0.7581240],
                [+0.1160890, +0.6416940, -0.7581240],
                [-0.1160890, +0.6416940, -0.7581240],
                [+0.1160890, -0.6416940, -0.7581240],
                [-0.1160890, -0.6416940, -0.7581240],
                [+0.1160890, +0.7581240, +0.6416940],
                [-0.1160890, +0.7581240, +0.6416940],
                [+0.1160890, -0.7581240, +0.6416940],
                [-0.1160890, -0.7581240, +0.6416940],
                [+0.1160890, +0.7581240, -0.6416940],
                [-0.1160890, +0.7581240, -0.6416940],
                [+0.1160890, -0.7581240, -0.6416940],
                [-0.1160890, -0.7581240, -0.6416940],
                [+0.7581240, +0.6416940, +0.1160890],
                [-0.7581240, +0.6416940, +0.1160890],
                [+0.7581240, -0.6416940, +0.1160890],
                [-0.7581240, -0.6416940, +0.1160890],
                [+0.7581240, +0.6416940, -0.1160890],
                [-0.7581240, +0.6416940, -0.1160890],
                [+0.7581240, -0.6416940, -0.1160890],
                [-0.7581240, -0.6416940, -0.1160890],
                [+0.7581240, +0.1160890, +0.6416940],
                [-0.7581240, +0.1160890, +0.6416940],
                [+0.7581240, -0.1160890, +0.6416940],
                [-0.7581240, -0.1160890, +0.6416940],
                [+0.7581240, +0.1160890, -0.6416940],
                [-0.7581240, +0.1160890, -0.6416940],
                [+0.7581240, -0.1160890, -0.6416940],
                [-0.7581240, -0.1160890, -0.6416940],
                [+0.6697930, +0.1450380, +0.7282460],
                [-0.6697930, +0.1450380, +0.7282460],
                [+0.6697930, -0.1450380, +0.7282460],
                [-0.6697930, -0.1450380, +0.7282460],
                [+0.6697930, +0.1450380, -0.7282460],
                [-0.6697930, +0.1450380, -0.7282460],
                [+0.6697930, -0.1450380, -0.7282460],
                [-0.6697930, -0.1450380, -0.7282460],
                [+0.6697930, +0.7282460, +0.1450380],
                [-0.6697930, +0.7282460, +0.1450380],
                [+0.6697930, -0.7282460, +0.1450380],
                [-0.6697930, -0.7282460, +0.1450380],
                [+0.6697930, +0.7282460, -0.1450380],
                [-0.6697930, +0.7282460, -0.1450380],
                [+0.6697930, -0.7282460, -0.1450380],
                [-0.6697930, -0.7282460, -0.1450380],
                [+0.1450380, +0.6697930, +0.7282460],
                [-0.1450380, +0.6697930, +0.7282460],
                [+0.1450380, -0.6697930, +0.7282460],
                [-0.1450380, -0.6697930, +0.7282460],
                [+0.1450380, +0.6697930, -0.7282460],
                [-0.1450380, +0.6697930, -0.7282460],
                [+0.1450380, -0.6697930, -0.7282460],
                [-0.1450380, -0.6697930, -0.7282460],
                [+0.1450380, +0.7282460, +0.6697930],
                [-0.1450380, +0.7282460, +0.6697930],
                [+0.1450380, -0.7282460, +0.6697930],
                [-0.1450380, -0.7282460, +0.6697930],
                [+0.1450380, +0.7282460, -0.6697930],
                [-0.1450380, +0.7282460, -0.6697930],
                [+0.1450380, -0.7282460, -0.6697930],
                [-0.1450380, -0.7282460, -0.6697930],
                [+0.7282460, +0.6697930, +0.1450380],
                [-0.7282460, +0.6697930, +0.1450380],
                [+0.7282460, -0.6697930, +0.1450380],
                [-0.7282460, -0.6697930, +0.1450380],
                [+0.7282460, +0.6697930, -0.1450380],
                [-0.7282460, +0.6697930, -0.1450380],
                [+0.7282460, -0.6697930, -0.1450380],
                [-0.7282460, -0.6697930, -0.1450380],
                [+0.7282460, +0.1450380, +0.6697930],
                [-0.7282460, +0.1450380, +0.6697930],
                [+0.7282460, -0.1450380, +0.6697930],
                [-0.7282460, -0.1450380, +0.6697930],
                [+0.7282460, +0.1450380, -0.6697930],
                [-0.7282460, +0.1450380, -0.6697930],
                [+0.7282460, -0.1450380, -0.6697930],
                [-0.7282460, -0.1450380, -0.6697930],
                [+0.6147590, +0.0290496, +0.7881800],
                [-0.6147590, +0.0290496, +0.7881800],
                [+0.6147590, -0.0290496, +0.7881800],
                [-0.6147590, -0.0290496, +0.7881800],
                [+0.6147590, +0.0290496, -0.7881800],
                [-0.6147590, +0.0290496, -0.7881800],
                [+0.6147590, -0.0290496, -0.7881800],
                [-0.6147590, -0.0290496, -0.7881800],
                [+0.6147590, +0.7881800, +0.0290496],
                [-0.6147590, +0.7881800, +0.0290496],
                [+0.6147590, -0.7881800, +0.0290496],
                [-0.6147590, -0.7881800, +0.0290496],
                [+0.6147590, +0.7881800, -0.0290496],
                [-0.6147590, +0.7881800, -0.0290496],
                [+0.6147590, -0.7881800, -0.0290496],
                [-0.6147590, -0.7881800, -0.0290496],
                [+0.0290496, +0.6147590, +0.7881800],
                [-0.0290496, +0.6147590, +0.7881800],
                [+0.0290496, -0.6147590, +0.7881800],
                [-0.0290496, -0.6147590, +0.7881800],
                [+0.0290496, +0.6147590, -0.7881800],
                [-0.0290496, +0.6147590, -0.7881800],
                [+0.0290496, -0.6147590, -0.7881800],
                [-0.0290496, -0.6147590, -0.7881800],
                [+0.0290496, +0.7881800, +0.6147590],
                [-0.0290496, +0.7881800, +0.6147590],
                [+0.0290496, -0.7881800, +0.6147590],
                [-0.0290496, -0.7881800, +0.6147590],
                [+0.0290496, +0.7881800, -0.6147590],
                [-0.0290496, +0.7881800, -0.6147590],
                [+0.0290496, -0.7881800, -0.6147590],
                [-0.0290496, -0.7881800, -0.6147590],
                [+0.7881800, +0.6147590, +0.0290496],
                [-0.7881800, +0.6147590, +0.0290496],
                [+0.7881800, -0.6147590, +0.0290496],
                [-0.7881800, -0.6147590, +0.0290496],
                [+0.7881800, +0.6147590, -0.0290496],
                [-0.7881800, +0.6147590, -0.0290496],
                [+0.7881800, -0.6147590, -0.0290496],
                [-0.7881800, -0.6147590, -0.0290496],
                [+0.7881800, +0.0290496, +0.6147590],
                [-0.7881800, +0.0290496, +0.6147590],
                [+0.7881800, -0.0290496, +0.6147590],
                [-0.7881800, -0.0290496, +0.6147590],
                [+0.7881800, +0.0290496, -0.6147590],
                [-0.7881800, +0.0290496, -0.6147590],
                [+0.7881800, -0.0290496, -0.6147590],
                [-0.7881800, -0.0290496, -0.6147590],
                [+0.6455390, +0.0582381, +0.7615040],
                [-0.6455390, +0.0582381, +0.7615040],
                [+0.6455390, -0.0582381, +0.7615040],
                [-0.6455390, -0.0582381, +0.7615040],
                [+0.6455390, +0.0582381, -0.7615040],
                [-0.6455390, +0.0582381, -0.7615040],
                [+0.6455390, -0.0582381, -0.7615040],
                [-0.6455390, -0.0582381, -0.7615040],
                [+0.6455390, +0.7615040, +0.0582381],
                [-0.6455390, +0.7615040, +0.0582381],
                [+0.6455390, -0.7615040, +0.0582381],
                [-0.6455390, -0.7615040, +0.0582381],
                [+0.6455390, +0.7615040, -0.0582381],
                [-0.6455390, +0.7615040, -0.0582381],
                [+0.6455390, -0.7615040, -0.0582381],
                [-0.6455390, -0.7615040, -0.0582381],
                [+0.0582381, +0.6455390, +0.7615040],
                [-0.0582381, +0.6455390, +0.7615040],
                [+0.0582381, -0.6455390, +0.7615040],
                [-0.0582381, -0.6455390, +0.7615040],
                [+0.0582381, +0.6455390, -0.7615040],
                [-0.0582381, +0.6455390, -0.7615040],
                [+0.0582381, -0.6455390, -0.7615040],
                [-0.0582381, -0.6455390, -0.7615040],
                [+0.0582381, +0.7615040, +0.6455390],
                [-0.0582381, +0.7615040, +0.6455390],
                [+0.0582381, -0.7615040, +0.6455390],
                [-0.0582381, -0.7615040, +0.6455390],
                [+0.0582381, +0.7615040, -0.6455390],
                [-0.0582381, +0.7615040, -0.6455390],
                [+0.0582381, -0.7615040, -0.6455390],
                [-0.0582381, -0.7615040, -0.6455390],
                [+0.7615040, +0.6455390, +0.0582381],
                [-0.7615040, +0.6455390, +0.0582381],
                [+0.7615040, -0.6455390, +0.0582381],
                [-0.7615040, -0.6455390, +0.0582381],
                [+0.7615040, +0.6455390, -0.0582381],
                [-0.7615040, +0.6455390, -0.0582381],
                [+0.7615040, -0.6455390, -0.0582381],
                [-0.7615040, -0.6455390, -0.0582381],
                [+0.7615040, +0.0582381, +0.6455390],
                [-0.7615040, +0.0582381, +0.6455390],
                [+0.7615040, -0.0582381, +0.6455390],
                [-0.7615040, -0.0582381, +0.6455390],
                [+0.7615040, +0.0582381, -0.6455390],
                [-0.7615040, +0.0582381, -0.6455390],
                [+0.7615040, -0.0582381, -0.6455390],
                [-0.7615040, -0.0582381, -0.6455390],
                [+0.6747260, +0.0874038, +0.7328750],
                [-0.6747260, +0.0874038, +0.7328750],
                [+0.6747260, -0.0874038, +0.7328750],
                [-0.6747260, -0.0874038, +0.7328750],
                [+0.6747260, +0.0874038, -0.7328750],
                [-0.6747260, +0.0874038, -0.7328750],
                [+0.6747260, -0.0874038, -0.7328750],
                [-0.6747260, -0.0874038, -0.7328750],
                [+0.6747260, +0.7328750, +0.0874038],
                [-0.6747260, +0.7328750, +0.0874038],
                [+0.6747260, -0.7328750, +0.0874038],
                [-0.6747260, -0.7328750, +0.0874038],
                [+0.6747260, +0.7328750, -0.0874038],
                [-0.6747260, +0.7328750, -0.0874038],
                [+0.6747260, -0.7328750, -0.0874038],
                [-0.6747260, -0.7328750, -0.0874038],
                [+0.0874038, +0.6747260, +0.7328750],
                [-0.0874038, +0.6747260, +0.7328750],
                [+0.0874038, -0.6747260, +0.7328750],
                [-0.0874038, -0.6747260, +0.7328750],
                [+0.0874038, +0.6747260, -0.7328750],
                [-0.0874038, +0.6747260, -0.7328750],
                [+0.0874038, -0.6747260, -0.7328750],
                [-0.0874038, -0.6747260, -0.7328750],
                [+0.0874038, +0.7328750, +0.6747260],
                [-0.0874038, +0.7328750, +0.6747260],
                [+0.0874038, -0.7328750, +0.6747260],
                [-0.0874038, -0.7328750, +0.6747260],
                [+0.0874038, +0.7328750, -0.6747260],
                [-0.0874038, +0.7328750, -0.6747260],
                [+0.0874038, -0.7328750, -0.6747260],
                [-0.0874038, -0.7328750, -0.6747260],
                [+0.7328750, +0.6747260, +0.0874038],
                [-0.7328750, +0.6747260, +0.0874038],
                [+0.7328750, -0.6747260, +0.0874038],
                [-0.7328750, -0.6747260, +0.0874038],
                [+0.7328750, +0.6747260, -0.0874038],
                [-0.7328750, +0.6747260, -0.0874038],
                [+0.7328750, -0.6747260, -0.0874038],
                [-0.7328750, -0.6747260, -0.0874038],
                [+0.7328750, +0.0874038, +0.6747260],
                [-0.7328750, +0.0874038, +0.6747260],
                [+0.7328750, -0.0874038, +0.6747260],
                [-0.7328750, -0.0874038, +0.6747260],
                [+0.7328750, +0.0874038, -0.6747260],
                [-0.7328750, +0.0874038, -0.6747260],
                [+0.7328750, -0.0874038, -0.6747260],
                [-0.7328750, -0.0874038, -0.6747260],
                [+0.6772140, +0.0291995, +0.7352070],
                [-0.6772140, +0.0291995, +0.7352070],
                [+0.6772140, -0.0291995, +0.7352070],
                [-0.6772140, -0.0291995, +0.7352070],
                [+0.6772140, +0.0291995, -0.7352070],
                [-0.6772140, +0.0291995, -0.7352070],
                [+0.6772140, -0.0291995, -0.7352070],
                [-0.6772140, -0.0291995, -0.7352070],
                [+0.6772140, +0.7352070, +0.0291995],
                [-0.6772140, +0.7352070, +0.0291995],
                [+0.6772140, -0.7352070, +0.0291995],
                [-0.6772140, -0.7352070, +0.0291995],
                [+0.6772140, +0.7352070, -0.0291995],
                [-0.6772140, +0.7352070, -0.0291995],
                [+0.6772140, -0.7352070, -0.0291995],
                [-0.6772140, -0.7352070, -0.0291995],
                [+0.0291995, +0.6772140, +0.7352070],
                [-0.0291995, +0.6772140, +0.7352070],
                [+0.0291995, -0.6772140, +0.7352070],
                [-0.0291995, -0.6772140, +0.7352070],
                [+0.0291995, +0.6772140, -0.7352070],
                [-0.0291995, +0.6772140, -0.7352070],
                [+0.0291995, -0.6772140, -0.7352070],
                [-0.0291995, -0.6772140, -0.7352070],
                [+0.0291995, +0.7352070, +0.6772140],
                [-0.0291995, +0.7352070, +0.6772140],
                [+0.0291995, -0.7352070, +0.6772140],
                [-0.0291995, -0.7352070, +0.6772140],
                [+0.0291995, +0.7352070, -0.6772140],
                [-0.0291995, +0.7352070, -0.6772140],
                [+0.0291995, -0.7352070, -0.6772140],
                [-0.0291995, -0.7352070, -0.6772140],
                [+0.7352070, +0.6772140, +0.0291995],
                [-0.7352070, +0.6772140, +0.0291995],
                [+0.7352070, -0.6772140, +0.0291995],
                [-0.7352070, -0.6772140, +0.0291995],
                [+0.7352070, +0.6772140, -0.0291995],
                [-0.7352070, +0.6772140, -0.0291995],
                [+0.7352070, -0.6772140, -0.0291995],
                [-0.7352070, -0.6772140, -0.0291995],
                [+0.7352070, +0.0291995, +0.6772140],
                [-0.7352070, +0.0291995, +0.6772140],
                [+0.7352070, -0.0291995, +0.6772140],
                [-0.7352070, -0.0291995, +0.6772140],
                [+0.7352070, +0.0291995, -0.6772140],
                [-0.7352070, +0.0291995, -0.6772140],
                [+0.7352070, -0.0291995, -0.6772140],
                [-0.7352070, -0.0291995, -0.677214],
            ]
        )

        self._nearest_neighbors = [
            [42, 44, 46, 48],
            [43, 45, 47, 49],
            [34, 35, 38, 39],
            [36, 37, 40, 41],
            [26, 27, 28, 29],
            [30, 31, 32, 33],
            [5778, 5779, 5786, 5787, 762, 763],
            [5780, 5781, 5788, 5789, 764, 765],
            [5782, 5783, 5790, 5791, 766, 767],
            [5784, 5785, 5792, 5793, 768, 769],
            [5762, 5764, 5802, 5804, 754, 756],
            [5763, 5765, 5803, 5805, 755, 757],
            [5766, 5768, 5806, 5808, 758, 760],
            [5767, 5769, 5807, 5809, 759, 761],
            [5770, 5774, 5794, 5798, 746, 750],
            [5771, 5775, 5795, 5799, 747, 751],
            [5772, 5776, 5796, 5800, 748, 752],
            [5773, 5777, 5797, 5801, 749, 753],
            [506, 514, 522, 530, 538, 546],
            [507, 515, 523, 531, 539, 547],
            [508, 516, 524, 532, 540, 548],
            [509, 517, 525, 533, 541, 549],
            [510, 518, 526, 534, 542, 550],
            [511, 519, 527, 535, 543, 551],
            [512, 520, 528, 536, 544, 552],
            [513, 521, 529, 537, 545, 553],
            [4, 27, 28, 778, 786, 50],
            [4, 26, 29, 779, 786, 51],
            [4, 26, 29, 778, 787, 52],
            [4, 27, 28, 779, 787, 53],
            [5, 31, 32, 780, 788, 54],
            [5, 30, 33, 781, 788, 55],
            [5, 30, 33, 780, 789, 56],
            [5, 31, 32, 781, 789, 57],
            [2, 35, 38, 770, 790, 58],
            [2, 34, 39, 771, 790, 59],
            [3, 37, 40, 772, 791, 60],
            [3, 36, 41, 773, 791, 61],
            [2, 34, 39, 770, 792, 62],
            [2, 35, 38, 771, 792, 63],
            [3, 36, 41, 772, 793, 64],
            [3, 37, 40, 773, 793, 65],
            [0, 44, 46, 774, 782, 66],
            [1, 45, 47, 775, 783, 67],
            [0, 42, 48, 776, 782, 68],
            [1, 43, 49, 777, 783, 69],
            [0, 42, 48, 774, 784, 70],
            [1, 43, 49, 775, 785, 71],
            [0, 44, 46, 776, 784, 72],
            [1, 45, 47, 777, 785, 73],
            [26, 778, 786, 74, 1010, 1026],
            [27, 779, 786, 75, 1011, 1027],
            [28, 778, 787, 76, 1012, 1028],
            [29, 779, 787, 77, 1013, 1029],
            [30, 780, 788, 78, 1014, 1030],
            [31, 781, 788, 79, 1015, 1031],
            [32, 780, 789, 80, 1016, 1032],
            [33, 781, 789, 81, 1017, 1033],
            [34, 770, 790, 82, 1018, 1034],
            [35, 771, 790, 83, 1019, 1035],
            [36, 772, 791, 84, 1020, 1036],
            [37, 773, 791, 85, 1021, 1037],
            [38, 770, 792, 86, 1022, 1038],
            [39, 771, 792, 87, 1023, 1039],
            [40, 772, 793, 88, 1024, 1040],
            [41, 773, 793, 89, 1025, 1041],
            [42, 774, 782, 90, 1042, 1050],
            [43, 775, 783, 91, 1043, 1051],
            [44, 776, 782, 92, 1044, 1052],
            [45, 777, 783, 93, 1045, 1053],
            [46, 774, 784, 94, 1046, 1054],
            [47, 775, 785, 95, 1047, 1055],
            [48, 776, 784, 96, 1048, 1056],
            [49, 777, 785, 97, 1049, 1057],
            [50, 98, 1010, 1026, 1058, 1074],
            [51, 99, 1011, 1027, 1059, 1075],
            [52, 100, 1012, 1028, 1060, 1076],
            [53, 101, 1013, 1029, 1061, 1077],
            [54, 102, 1014, 1030, 1062, 1078],
            [55, 103, 1015, 1031, 1063, 1079],
            [56, 104, 1016, 1032, 1064, 1080],
            [57, 105, 1017, 1033, 1065, 1081],
            [58, 106, 1018, 1034, 1066, 1082],
            [59, 107, 1019, 1035, 1067, 1083],
            [60, 108, 1020, 1036, 1068, 1084],
            [61, 109, 1021, 1037, 1069, 1085],
            [62, 110, 1022, 1038, 1070, 1086],
            [63, 111, 1023, 1039, 1071, 1087],
            [64, 112, 1024, 1040, 1072, 1088],
            [65, 113, 1025, 1041, 1073, 1089],
            [66, 114, 1042, 1050, 1090, 1098],
            [67, 115, 1043, 1051, 1091, 1099],
            [68, 116, 1044, 1052, 1092, 1100],
            [69, 117, 1045, 1053, 1093, 1101],
            [70, 118, 1046, 1054, 1094, 1102],
            [71, 119, 1047, 1055, 1095, 1103],
            [72, 120, 1048, 1056, 1096, 1104],
            [73, 121, 1049, 1057, 1097, 1105],
            [74, 122, 1058, 1074, 1106, 1122],
            [75, 123, 1059, 1075, 1107, 1123],
            [76, 124, 1060, 1076, 1108, 1124],
            [77, 125, 1061, 1077, 1109, 1125],
            [78, 126, 1062, 1078, 1110, 1126],
            [79, 127, 1063, 1079, 1111, 1127],
            [80, 128, 1064, 1080, 1112, 1128],
            [81, 129, 1065, 1081, 1113, 1129],
            [82, 130, 1066, 1082, 1114, 1130],
            [83, 131, 1067, 1083, 1115, 1131],
            [84, 132, 1068, 1084, 1116, 1132],
            [85, 133, 1069, 1085, 1117, 1133],
            [86, 134, 1070, 1086, 1118, 1134],
            [87, 135, 1071, 1087, 1119, 1135],
            [88, 136, 1072, 1088, 1120, 1136],
            [89, 137, 1073, 1089, 1121, 1137],
            [90, 138, 1090, 1098, 1138, 1146],
            [91, 139, 1091, 1099, 1139, 1147],
            [92, 140, 1092, 1100, 1140, 1148],
            [93, 141, 1093, 1101, 1141, 1149],
            [94, 142, 1094, 1102, 1142, 1150],
            [95, 143, 1095, 1103, 1143, 1151],
            [96, 144, 1096, 1104, 1144, 1152],
            [97, 145, 1097, 1105, 1145, 1153],
            [98, 146, 1106, 1122, 1154, 1170],
            [99, 147, 1107, 1123, 1155, 1171],
            [100, 148, 1108, 1124, 1156, 1172],
            [101, 149, 1109, 1125, 1157, 1173],
            [102, 150, 1110, 1126, 1158, 1174],
            [103, 151, 1111, 1127, 1159, 1175],
            [104, 152, 1112, 1128, 1160, 1176],
            [105, 153, 1113, 1129, 1161, 1177],
            [106, 154, 1114, 1130, 1162, 1178],
            [107, 155, 1115, 1131, 1163, 1179],
            [108, 156, 1116, 1132, 1164, 1180],
            [109, 157, 1117, 1133, 1165, 1181],
            [110, 158, 1118, 1134, 1166, 1182],
            [111, 159, 1119, 1135, 1167, 1183],
            [112, 160, 1120, 1136, 1168, 1184],
            [113, 161, 1121, 1137, 1169, 1185],
            [114, 162, 1138, 1146, 1186, 1194],
            [115, 163, 1139, 1147, 1187, 1195],
            [116, 164, 1140, 1148, 1188, 1196],
            [117, 165, 1141, 1149, 1189, 1197],
            [118, 166, 1142, 1150, 1190, 1198],
            [119, 167, 1143, 1151, 1191, 1199],
            [120, 168, 1144, 1152, 1192, 1200],
            [121, 169, 1145, 1153, 1193, 1201],
            [122, 170, 1154, 1170, 1202, 1218],
            [123, 171, 1155, 1171, 1203, 1219],
            [124, 172, 1156, 1172, 1204, 1220],
            [125, 173, 1157, 1173, 1205, 1221],
            [126, 174, 1158, 1174, 1206, 1222],
            [127, 175, 1159, 1175, 1207, 1223],
            [128, 176, 1160, 1176, 1208, 1224],
            [129, 177, 1161, 1177, 1209, 1225],
            [130, 178, 1162, 1178, 1210, 1226],
            [131, 179, 1163, 1179, 1211, 1227],
            [132, 180, 1164, 1180, 1212, 1228],
            [133, 181, 1165, 1181, 1213, 1229],
            [134, 182, 1166, 1182, 1214, 1230],
            [135, 183, 1167, 1183, 1215, 1231],
            [136, 184, 1168, 1184, 1216, 1232],
            [137, 185, 1169, 1185, 1217, 1233],
            [138, 186, 1186, 1194, 1234, 1242],
            [139, 187, 1187, 1195, 1235, 1243],
            [140, 188, 1188, 1196, 1236, 1244],
            [141, 189, 1189, 1197, 1237, 1245],
            [142, 190, 1190, 1198, 1238, 1246],
            [143, 191, 1191, 1199, 1239, 1247],
            [144, 192, 1192, 1200, 1240, 1248],
            [145, 193, 1193, 1201, 1241, 1249],
            [146, 194, 1202, 1218, 1250, 1266],
            [147, 195, 1203, 1219, 1251, 1267],
            [148, 196, 1204, 1220, 1252, 1268],
            [149, 197, 1205, 1221, 1253, 1269],
            [150, 198, 1206, 1222, 1254, 1270],
            [151, 199, 1207, 1223, 1255, 1271],
            [152, 200, 1208, 1224, 1256, 1272],
            [153, 201, 1209, 1225, 1257, 1273],
            [154, 202, 1210, 1226, 1258, 1274],
            [155, 203, 1211, 1227, 1259, 1275],
            [156, 204, 1212, 1228, 1260, 1276],
            [157, 205, 1213, 1229, 1261, 1277],
            [158, 206, 1214, 1230, 1262, 1278],
            [159, 207, 1215, 1231, 1263, 1279],
            [160, 208, 1216, 1232, 1264, 1280],
            [161, 209, 1217, 1233, 1265, 1281],
            [162, 210, 1234, 1242, 1282, 1290],
            [163, 211, 1235, 1243, 1283, 1291],
            [164, 212, 1236, 1244, 1284, 1292],
            [165, 213, 1237, 1245, 1285, 1293],
            [166, 214, 1238, 1246, 1286, 1294],
            [167, 215, 1239, 1247, 1287, 1295],
            [168, 216, 1240, 1248, 1288, 1296],
            [169, 217, 1241, 1249, 1289, 1297],
            [170, 218, 1298, 1314, 1250, 1266],
            [171, 219, 1299, 1315, 1251, 1267],
            [172, 220, 1300, 1316, 1252, 1268],
            [173, 221, 1301, 1317, 1253, 1269],
            [174, 222, 1302, 1318, 1254, 1270],
            [175, 223, 1303, 1319, 1255, 1271],
            [176, 224, 1304, 1320, 1256, 1272],
            [177, 225, 1305, 1321, 1257, 1273],
            [178, 226, 1306, 1322, 1258, 1274],
            [179, 227, 1307, 1323, 1259, 1275],
            [180, 228, 1308, 1324, 1260, 1276],
            [181, 229, 1309, 1325, 1261, 1277],
            [182, 230, 1310, 1326, 1262, 1278],
            [183, 231, 1311, 1327, 1263, 1279],
            [184, 232, 1312, 1328, 1264, 1280],
            [185, 233, 1313, 1329, 1265, 1281],
            [186, 234, 1330, 1338, 1282, 1290],
            [187, 235, 1331, 1339, 1283, 1291],
            [188, 236, 1332, 1340, 1284, 1292],
            [189, 237, 1333, 1341, 1285, 1293],
            [190, 238, 1334, 1342, 1286, 1294],
            [191, 239, 1335, 1343, 1287, 1295],
            [192, 240, 1336, 1344, 1288, 1296],
            [193, 241, 1337, 1345, 1289, 1297],
            [194, 242, 1346, 1362, 1298, 1314],
            [195, 243, 1347, 1363, 1299, 1315],
            [196, 244, 1348, 1364, 1300, 1316],
            [197, 245, 1349, 1365, 1301, 1317],
            [198, 246, 1350, 1366, 1302, 1318],
            [199, 247, 1351, 1367, 1303, 1319],
            [200, 248, 1352, 1368, 1304, 1320],
            [201, 249, 1353, 1369, 1305, 1321],
            [202, 250, 1354, 1370, 1322, 1306],
            [203, 251, 1355, 1371, 1323, 1307],
            [204, 252, 1356, 1372, 1324, 1308],
            [205, 253, 1357, 1373, 1325, 1309],
            [206, 254, 1358, 1374, 1326, 1310],
            [207, 255, 1359, 1375, 1327, 1311],
            [208, 256, 1360, 1376, 1328, 1312],
            [209, 257, 1361, 1377, 1329, 1313],
            [210, 258, 1378, 1386, 1338, 1330],
            [211, 259, 1379, 1387, 1339, 1331],
            [212, 260, 1380, 1388, 1340, 1332],
            [213, 261, 1381, 1389, 1341, 1333],
            [214, 262, 1382, 1390, 1342, 1334],
            [215, 263, 1383, 1391, 1343, 1335],
            [216, 264, 1384, 1392, 1344, 1336],
            [217, 265, 1385, 1393, 1345, 1337],
            [218, 266, 1394, 1410, 1346, 1362],
            [219, 267, 1395, 1411, 1347, 1363],
            [220, 268, 1396, 1412, 1348, 1364],
            [221, 269, 1397, 1413, 1349, 1365],
            [222, 270, 1398, 1414, 1350, 1366],
            [223, 271, 1399, 1415, 1351, 1367],
            [224, 272, 1400, 1416, 1352, 1368],
            [225, 273, 1401, 1417, 1353, 1369],
            [226, 274, 1402, 1418, 1354, 1370],
            [227, 275, 1403, 1419, 1355, 1371],
            [228, 276, 1404, 1420, 1356, 1372],
            [229, 277, 1405, 1421, 1357, 1373],
            [230, 278, 1406, 1422, 1358, 1374],
            [231, 279, 1407, 1423, 1359, 1375],
            [232, 280, 1408, 1424, 1360, 1376],
            [233, 281, 1409, 1425, 1361, 1377],
            [234, 282, 1426, 1434, 1378, 1386],
            [235, 283, 1427, 1435, 1379, 1387],
            [236, 284, 1428, 1436, 1380, 1388],
            [237, 285, 1429, 1437, 1381, 1389],
            [238, 286, 1430, 1438, 1382, 1390],
            [239, 287, 1431, 1439, 1383, 1391],
            [240, 288, 1432, 1440, 1384, 1392],
            [241, 289, 1433, 1441, 1385, 1393],
            [242, 290, 1442, 1458, 1394, 1410],
            [243, 291, 1443, 1459, 1395, 1411],
            [244, 292, 1444, 1460, 1396, 1412],
            [245, 293, 1445, 1461, 1397, 1413],
            [246, 294, 1446, 1462, 1398, 1414],
            [247, 295, 1447, 1463, 1399, 1415],
            [248, 296, 1448, 1464, 1400, 1416],
            [249, 297, 1449, 1465, 1401, 1417],
            [250, 298, 1450, 1466, 1402, 1418],
            [251, 299, 1451, 1467, 1403, 1419],
            [252, 300, 1452, 1468, 1404, 1420],
            [253, 301, 1453, 1469, 1405, 1421],
            [254, 302, 1454, 1470, 1406, 1422],
            [255, 303, 1455, 1471, 1407, 1423],
            [256, 304, 1456, 1472, 1408, 1424],
            [257, 305, 1457, 1473, 1409, 1425],
            [258, 306, 1474, 1482, 1426, 1434],
            [259, 307, 1475, 1483, 1427, 1435],
            [260, 308, 1476, 1484, 1428, 1436],
            [261, 309, 1477, 1485, 1429, 1437],
            [262, 310, 1478, 1486, 1430, 1438],
            [263, 311, 1479, 1487, 1431, 1439],
            [264, 312, 1480, 1488, 1432, 1440],
            [265, 313, 1481, 1489, 1433, 1441],
            [266, 314, 1490, 1506, 1442, 1458],
            [267, 315, 1491, 1507, 1443, 1459],
            [268, 316, 1492, 1508, 1444, 1460],
            [269, 317, 1493, 1509, 1445, 1461],
            [270, 318, 1494, 1510, 1446, 1462],
            [271, 319, 1495, 1511, 1447, 1463],
            [272, 320, 1496, 1512, 1448, 1464],
            [273, 321, 1497, 1513, 1449, 1465],
            [274, 322, 1514, 1498, 1450, 1466],
            [275, 323, 1515, 1499, 1451, 1467],
            [276, 324, 1516, 1500, 1452, 1468],
            [277, 325, 1517, 1501, 1453, 1469],
            [278, 326, 1518, 1502, 1454, 1470],
            [279, 327, 1519, 1503, 1455, 1471],
            [280, 328, 1520, 1504, 1456, 1472],
            [281, 329, 1521, 1505, 1457, 1473],
            [282, 330, 1530, 1522, 1474, 1482],
            [283, 331, 1531, 1523, 1475, 1483],
            [284, 332, 1532, 1524, 1476, 1484],
            [285, 333, 1533, 1525, 1477, 1485],
            [286, 334, 1534, 1526, 1478, 1486],
            [287, 335, 1535, 1527, 1479, 1487],
            [288, 336, 1536, 1528, 1480, 1488],
            [289, 337, 1537, 1529, 1481, 1489],
            [290, 338, 1538, 1554, 1490, 1506],
            [291, 339, 1539, 1555, 1491, 1507],
            [292, 340, 1540, 1556, 1492, 1508],
            [293, 341, 1541, 1557, 1493, 1509],
            [294, 342, 1542, 1558, 1494, 1510],
            [295, 343, 1543, 1559, 1495, 1511],
            [296, 344, 1544, 1560, 1496, 1512],
            [297, 345, 1545, 1561, 1497, 1513],
            [298, 346, 1546, 1562, 1498, 1514],
            [299, 347, 1547, 1563, 1499, 1515],
            [300, 348, 1548, 1564, 1500, 1516],
            [301, 349, 1549, 1565, 1501, 1517],
            [302, 350, 1550, 1566, 1502, 1518],
            [303, 351, 1551, 1567, 1503, 1519],
            [304, 352, 1552, 1568, 1504, 1520],
            [305, 353, 1553, 1569, 1505, 1521],
            [306, 354, 1570, 1578, 1522, 1530],
            [307, 355, 1571, 1579, 1523, 1531],
            [308, 356, 1572, 1580, 1524, 1532],
            [309, 357, 1573, 1581, 1525, 1533],
            [310, 358, 1574, 1582, 1526, 1534],
            [311, 359, 1575, 1583, 1527, 1535],
            [312, 360, 1576, 1584, 1528, 1536],
            [313, 361, 1577, 1585, 1529, 1537],
            [314, 362, 1586, 1602, 1538, 1554],
            [315, 363, 1587, 1603, 1539, 1555],
            [316, 364, 1588, 1604, 1540, 1556],
            [317, 365, 1589, 1605, 1541, 1557],
            [318, 366, 1590, 1606, 1542, 1558],
            [319, 367, 1591, 1607, 1543, 1559],
            [320, 368, 1592, 1608, 1544, 1560],
            [321, 369, 1593, 1609, 1545, 1561],
            [322, 370, 1594, 1610, 1546, 1562],
            [323, 371, 1595, 1611, 1547, 1563],
            [324, 372, 1596, 1612, 1548, 1564],
            [325, 373, 1597, 1613, 1549, 1565],
            [326, 374, 1598, 1614, 1550, 1566],
            [327, 375, 1599, 1615, 1551, 1567],
            [328, 376, 1600, 1616, 1552, 1568],
            [329, 377, 1601, 1617, 1553, 1569],
            [330, 378, 1618, 1626, 1570, 1578],
            [331, 379, 1619, 1627, 1571, 1579],
            [332, 380, 1620, 1628, 1572, 1580],
            [333, 381, 1621, 1629, 1573, 1581],
            [334, 382, 1622, 1630, 1574, 1582],
            [335, 383, 1623, 1631, 1575, 1583],
            [336, 384, 1624, 1632, 1576, 1584],
            [337, 385, 1625, 1633, 1577, 1585],
            [338, 386, 1634, 1650, 1586, 1602],
            [339, 387, 1635, 1651, 1587, 1603],
            [340, 388, 1636, 1652, 1588, 1604],
            [341, 389, 1637, 1653, 1589, 1605],
            [342, 390, 1638, 1654, 1590, 1606],
            [343, 391, 1639, 1655, 1591, 1607],
            [344, 392, 1640, 1656, 1592, 1608],
            [345, 393, 1641, 1657, 1593, 1609],
            [346, 394, 1642, 1658, 1594, 1610],
            [347, 395, 1643, 1659, 1595, 1611],
            [348, 396, 1644, 1660, 1596, 1612],
            [349, 397, 1645, 1661, 1597, 1613],
            [350, 398, 1646, 1662, 1598, 1614],
            [351, 399, 1647, 1663, 1599, 1615],
            [352, 400, 1648, 1664, 1600, 1616],
            [353, 401, 1649, 1665, 1601, 1617],
            [354, 402, 1666, 1674, 1618, 1626],
            [355, 403, 1667, 1675, 1619, 1627],
            [356, 404, 1668, 1676, 1620, 1628],
            [357, 405, 1669, 1677, 1621, 1629],
            [358, 406, 1670, 1678, 1622, 1630],
            [359, 407, 1671, 1679, 1623, 1631],
            [360, 408, 1672, 1680, 1624, 1632],
            [361, 409, 1673, 1681, 1625, 1633],
            [362, 410, 1682, 1698, 1634, 1650],
            [363, 411, 1683, 1699, 1635, 1651],
            [364, 412, 1684, 1700, 1636, 1652],
            [365, 413, 1685, 1701, 1637, 1653],
            [366, 414, 1686, 1702, 1638, 1654],
            [367, 415, 1687, 1703, 1639, 1655],
            [368, 416, 1688, 1704, 1640, 1656],
            [369, 417, 1689, 1705, 1641, 1657],
            [370, 418, 1690, 1706, 1642, 1658],
            [371, 419, 1691, 1707, 1643, 1659],
            [372, 420, 1692, 1708, 1644, 1660],
            [373, 421, 1693, 1709, 1645, 1661],
            [374, 422, 1694, 1710, 1646, 1662],
            [375, 423, 1695, 1711, 1647, 1663],
            [376, 424, 1696, 1712, 1648, 1664],
            [377, 425, 1697, 1713, 1649, 1665],
            [378, 426, 1714, 1722, 1666, 1674],
            [379, 427, 1715, 1723, 1667, 1675],
            [380, 428, 1716, 1724, 1668, 1676],
            [381, 429, 1717, 1725, 1669, 1677],
            [382, 430, 1718, 1726, 1670, 1678],
            [383, 431, 1719, 1727, 1671, 1679],
            [384, 432, 1720, 1728, 1672, 1680],
            [385, 433, 1721, 1729, 1673, 1681],
            [386, 434, 1730, 1746, 1682, 1698],
            [387, 435, 1731, 1747, 1683, 1699],
            [388, 436, 1732, 1748, 1684, 1700],
            [389, 437, 1733, 1749, 1685, 1701],
            [390, 438, 1734, 1750, 1686, 1702],
            [391, 439, 1735, 1751, 1687, 1703],
            [392, 440, 1736, 1752, 1688, 1704],
            [393, 441, 1737, 1753, 1689, 1705],
            [394, 442, 1738, 1754, 1690, 1706],
            [395, 443, 1739, 1755, 1691, 1707],
            [396, 444, 1740, 1756, 1692, 1708],
            [397, 445, 1741, 1757, 1693, 1709],
            [398, 446, 1742, 1758, 1694, 1710],
            [399, 447, 1743, 1759, 1695, 1711],
            [400, 448, 1744, 1760, 1696, 1712],
            [401, 449, 1745, 1761, 1697, 1713],
            [402, 450, 1762, 1770, 1714, 1722],
            [403, 451, 1763, 1771, 1715, 1723],
            [404, 452, 1764, 1772, 1716, 1724],
            [405, 453, 1765, 1773, 1717, 1725],
            [406, 454, 1766, 1774, 1718, 1726],
            [407, 455, 1767, 1775, 1719, 1727],
            [408, 456, 1768, 1776, 1720, 1728],
            [409, 457, 1769, 1777, 1721, 1729],
            [410, 458, 1778, 1794, 1730, 1746],
            [411, 459, 1779, 1795, 1731, 1747],
            [412, 460, 1780, 1796, 1732, 1748],
            [413, 461, 1781, 1797, 1733, 1749],
            [414, 462, 1782, 1798, 1734, 1750],
            [415, 463, 1783, 1799, 1735, 1751],
            [416, 464, 1784, 1800, 1736, 1752],
            [417, 465, 1785, 1801, 1737, 1753],
            [418, 466, 1786, 1802, 1738, 1754],
            [419, 467, 1787, 1803, 1739, 1755],
            [420, 468, 1788, 1804, 1740, 1756],
            [421, 469, 1789, 1805, 1741, 1757],
            [422, 470, 1790, 1806, 1742, 1758],
            [423, 471, 1791, 1807, 1743, 1759],
            [424, 472, 1792, 1808, 1744, 1760],
            [425, 473, 1793, 1809, 1745, 1761],
            [426, 474, 1810, 1818, 1762, 1770],
            [427, 475, 1811, 1819, 1763, 1771],
            [428, 476, 1812, 1820, 1764, 1772],
            [429, 477, 1813, 1821, 1765, 1773],
            [430, 478, 1814, 1822, 1766, 1774],
            [431, 479, 1815, 1823, 1767, 1775],
            [432, 480, 1816, 1824, 1768, 1776],
            [433, 481, 1817, 1825, 1769, 1777],
            [434, 482, 1826, 1842, 1778, 1794],
            [435, 483, 1827, 1843, 1779, 1795],
            [436, 484, 1828, 1844, 1780, 1796],
            [437, 485, 1829, 1845, 1781, 1797],
            [438, 486, 1830, 1846, 1782, 1798],
            [439, 487, 1831, 1847, 1783, 1799],
            [440, 488, 1832, 1848, 1784, 1800],
            [441, 489, 1833, 1849, 1785, 1801],
            [442, 490, 1834, 1850, 1786, 1802],
            [443, 491, 1835, 1851, 1787, 1803],
            [444, 492, 1836, 1852, 1788, 1804],
            [445, 493, 1837, 1853, 1789, 1805],
            [446, 494, 1838, 1854, 1790, 1806],
            [447, 495, 1839, 1855, 1791, 1807],
            [448, 496, 1840, 1856, 1792, 1808],
            [449, 497, 1841, 1857, 1793, 1809],
            [450, 498, 1858, 1866, 1810, 1818],
            [451, 499, 1859, 1867, 1811, 1819],
            [452, 500, 1860, 1868, 1812, 1820],
            [453, 501, 1861, 1869, 1813, 1821],
            [454, 502, 1862, 1870, 1814, 1822],
            [455, 503, 1863, 1871, 1815, 1823],
            [456, 504, 1864, 1872, 1816, 1824],
            [457, 505, 1865, 1873, 1817, 1825],
            [458, 506, 1874, 1890, 1826, 1842],
            [459, 507, 1875, 1891, 1827, 1843],
            [460, 508, 1876, 1892, 1828, 1844],
            [461, 509, 1877, 1893, 1829, 1845],
            [462, 510, 1878, 1894, 1830, 1846],
            [463, 511, 1879, 1895, 1831, 1847],
            [464, 512, 1880, 1896, 1832, 1848],
            [465, 513, 1881, 1897, 1833, 1849],
            [466, 514, 1882, 1898, 1834, 1850],
            [467, 515, 1883, 1899, 1835, 1851],
            [468, 516, 1884, 1900, 1836, 1852],
            [469, 517, 1885, 1901, 1837, 1853],
            [470, 518, 1886, 1902, 1838, 1854],
            [471, 519, 1887, 1903, 1839, 1855],
            [472, 520, 1888, 1904, 1840, 1856],
            [473, 521, 1889, 1905, 1841, 1857],
            [474, 522, 1906, 1914, 1858, 1866],
            [475, 523, 1907, 1915, 1859, 1867],
            [476, 524, 1908, 1916, 1860, 1868],
            [477, 525, 1909, 1917, 1861, 1869],
            [478, 526, 1910, 1918, 1862, 1870],
            [479, 527, 1911, 1919, 1863, 1871],
            [480, 528, 1912, 1920, 1864, 1872],
            [481, 529, 1913, 1921, 1865, 1873],
            [482, 18, 538, 546, 1874, 1890],
            [483, 19, 539, 547, 1875, 1891],
            [484, 20, 540, 548, 1876, 1892],
            [485, 21, 541, 549, 1877, 1893],
            [486, 22, 542, 550, 1878, 1894],
            [487, 23, 543, 551, 1879, 1895],
            [488, 24, 544, 552, 1880, 1896],
            [489, 25, 545, 553, 1881, 1897],
            [490, 18, 546, 530, 1882, 1898],
            [491, 19, 547, 531, 1883, 1899],
            [492, 20, 548, 532, 1884, 1900],
            [493, 21, 549, 533, 1885, 1901],
            [494, 22, 550, 534, 1886, 1902],
            [495, 23, 551, 535, 1887, 1903],
            [496, 24, 552, 536, 1888, 1904],
            [497, 25, 553, 537, 1889, 1905],
            [498, 18, 538, 530, 1906, 1914],
            [499, 19, 539, 531, 1907, 1915],
            [500, 20, 540, 532, 1908, 1916],
            [501, 21, 541, 533, 1909, 1917],
            [502, 22, 542, 534, 1910, 1918],
            [503, 23, 543, 535, 1911, 1919],
            [504, 24, 544, 536, 1912, 1920],
            [505, 25, 545, 537, 1913, 1921],
            [1882, 1906, 514, 522, 18, 554],
            [1883, 1907, 515, 523, 19, 555],
            [1884, 1908, 516, 524, 20, 556],
            [1885, 1909, 517, 525, 21, 557],
            [1886, 1910, 518, 526, 22, 558],
            [1887, 1911, 519, 527, 23, 559],
            [1888, 1912, 520, 528, 24, 560],
            [1889, 1913, 521, 529, 25, 561],
            [1914, 1874, 522, 506, 18, 562],
            [1915, 1875, 523, 507, 19, 563],
            [1916, 1876, 524, 508, 20, 564],
            [1917, 1877, 525, 509, 21, 565],
            [1918, 1878, 526, 510, 22, 566],
            [1919, 1879, 527, 511, 23, 567],
            [1920, 1880, 528, 512, 24, 568],
            [1921, 1881, 529, 513, 25, 569],
            [1898, 1890, 514, 506, 18, 570],
            [1899, 1891, 515, 507, 19, 571],
            [1900, 1892, 516, 508, 20, 572],
            [1901, 1893, 517, 509, 21, 573],
            [1902, 1894, 518, 510, 22, 574],
            [1903, 1895, 519, 511, 23, 575],
            [1904, 1896, 520, 512, 24, 576],
            [1905, 1897, 521, 513, 25, 577],
            [2698, 2722, 1882, 1906, 530, 578],
            [2699, 2723, 1883, 1907, 531, 579],
            [2700, 2724, 1884, 1908, 532, 580],
            [2701, 2725, 1885, 1909, 533, 581],
            [2702, 2726, 1886, 1910, 534, 582],
            [2703, 2727, 1887, 1911, 535, 583],
            [2704, 2728, 1888, 1912, 536, 584],
            [2705, 2729, 1889, 1913, 537, 585],
            [2690, 2730, 1874, 1914, 538, 586],
            [2691, 2731, 1875, 1915, 539, 587],
            [2692, 2732, 1876, 1916, 540, 588],
            [2693, 2733, 1877, 1917, 541, 589],
            [2694, 2734, 1878, 1918, 542, 590],
            [2695, 2735, 1879, 1919, 543, 591],
            [2696, 2736, 1880, 1920, 544, 592],
            [2697, 2737, 1881, 1921, 545, 593],
            [2706, 2714, 1890, 1898, 546, 594],
            [2707, 2715, 1891, 1899, 547, 595],
            [2708, 2716, 1892, 1900, 548, 596],
            [2709, 2717, 1893, 1901, 549, 597],
            [2710, 2718, 1894, 1902, 550, 598],
            [2711, 2719, 1895, 1903, 551, 599],
            [2712, 2720, 1896, 1904, 552, 600],
            [2713, 2721, 1897, 1905, 553, 601],
            [3418, 3442, 2698, 2722, 554, 602],
            [3419, 3443, 2699, 2723, 555, 603],
            [3420, 3444, 2700, 2724, 556, 604],
            [3421, 3445, 2701, 2725, 557, 605],
            [3422, 3446, 2702, 2726, 558, 606],
            [3423, 3447, 2703, 2727, 559, 607],
            [3424, 3448, 2704, 2728, 560, 608],
            [3425, 3449, 2705, 2729, 561, 609],
            [3450, 3410, 2690, 2730, 562, 610],
            [3451, 3411, 2691, 2731, 563, 611],
            [3452, 3412, 2692, 2732, 564, 612],
            [3453, 3413, 2693, 2733, 565, 613],
            [3454, 3414, 2694, 2734, 566, 614],
            [3455, 3415, 2695, 2735, 567, 615],
            [3456, 3416, 2696, 2736, 568, 616],
            [3457, 3417, 2697, 2737, 569, 617],
            [3434, 3426, 2706, 2714, 570, 618],
            [3435, 3427, 2707, 2715, 571, 619],
            [3436, 3428, 2708, 2716, 572, 620],
            [3437, 3429, 2709, 2717, 573, 621],
            [3438, 3430, 2710, 2718, 574, 622],
            [3439, 3431, 2711, 2719, 575, 623],
            [3440, 3432, 2712, 2720, 576, 624],
            [3441, 3433, 2713, 2721, 577, 625],
            [4042, 4066, 3418, 3442, 578, 626],
            [4043, 4067, 3419, 3443, 579, 627],
            [4044, 4068, 3420, 3444, 580, 628],
            [4045, 4069, 3421, 3445, 581, 629],
            [4046, 4070, 3422, 3446, 582, 630],
            [4047, 4071, 3423, 3447, 583, 631],
            [4048, 4072, 3424, 3448, 584, 632],
            [4049, 4073, 3425, 3449, 585, 633],
            [4034, 4074, 3410, 3450, 586, 634],
            [4035, 4075, 3411, 3451, 587, 635],
            [4036, 4076, 3412, 3452, 588, 636],
            [4037, 4077, 3413, 3453, 589, 637],
            [4038, 4078, 3414, 3454, 590, 638],
            [4039, 4079, 3415, 3455, 591, 639],
            [4040, 4080, 3416, 3456, 592, 640],
            [4041, 4081, 3417, 3457, 593, 641],
            [4050, 4058, 3426, 3434, 594, 642],
            [4051, 4059, 3427, 3435, 595, 643],
            [4052, 4060, 3428, 3436, 596, 644],
            [4053, 4061, 3429, 3437, 597, 645],
            [4054, 4062, 3430, 3438, 598, 646],
            [4055, 4063, 3431, 3439, 599, 647],
            [4056, 4064, 3432, 3440, 600, 648],
            [4057, 4065, 3433, 3441, 601, 649],
            [4570, 4594, 4042, 4066, 602, 650],
            [4571, 4595, 4043, 4067, 603, 651],
            [4572, 4596, 4044, 4068, 604, 652],
            [4573, 4597, 4045, 4069, 605, 653],
            [4574, 4598, 4046, 4070, 606, 654],
            [4575, 4599, 4047, 4071, 607, 655],
            [4576, 4600, 4048, 4072, 608, 656],
            [4577, 4601, 4049, 4073, 609, 657],
            [4562, 4602, 4034, 4074, 610, 658],
            [4563, 4603, 4035, 4075, 611, 659],
            [4564, 4604, 4036, 4076, 612, 660],
            [4565, 4605, 4037, 4077, 613, 661],
            [4566, 4606, 4038, 4078, 614, 662],
            [4567, 4607, 4039, 4079, 615, 663],
            [4568, 4608, 4040, 4080, 616, 664],
            [4569, 4609, 4041, 4081, 617, 665],
            [4578, 4586, 4050, 4058, 618, 666],
            [4579, 4587, 4051, 4059, 619, 667],
            [4580, 4588, 4052, 4060, 620, 668],
            [4581, 4589, 4053, 4061, 621, 669],
            [4582, 4590, 4054, 4062, 622, 670],
            [4583, 4591, 4055, 4063, 623, 671],
            [4584, 4592, 4056, 4064, 624, 672],
            [4585, 4593, 4057, 4065, 625, 673],
            [5002, 5026, 4570, 4594, 626, 674],
            [5003, 5027, 4571, 4595, 627, 675],
            [5004, 5028, 4572, 4596, 628, 676],
            [5005, 5029, 4573, 4597, 629, 677],
            [5006, 5030, 4574, 4598, 630, 678],
            [5007, 5031, 4575, 4599, 631, 679],
            [5008, 5032, 4576, 4600, 632, 680],
            [5009, 5033, 4577, 4601, 633, 681],
            [4994, 5034, 4562, 4602, 634, 682],
            [4995, 5035, 4563, 4603, 635, 683],
            [4996, 5036, 4564, 4604, 636, 684],
            [4997, 5037, 4565, 4605, 637, 685],
            [4998, 5038, 4566, 4606, 638, 686],
            [4999, 5039, 4567, 4607, 639, 687],
            [5000, 5040, 4568, 4608, 640, 688],
            [5001, 5041, 4569, 4609, 641, 689],
            [5010, 5018, 4578, 4586, 642, 690],
            [5011, 5019, 4579, 4587, 643, 691],
            [5012, 5020, 4580, 4588, 644, 692],
            [5013, 5021, 4581, 4589, 645, 693],
            [5014, 5022, 4582, 4590, 646, 694],
            [5015, 5023, 4583, 4591, 647, 695],
            [5016, 5024, 4584, 4592, 648, 696],
            [5017, 5025, 4585, 4593, 649, 697],
            [5338, 5362, 5002, 5026, 650, 698],
            [5339, 5363, 5003, 5027, 651, 699],
            [5340, 5364, 5004, 5028, 652, 700],
            [5341, 5365, 5005, 5029, 653, 701],
            [5342, 5366, 5006, 5030, 654, 702],
            [5343, 5367, 5007, 5031, 655, 703],
            [5344, 5368, 5008, 5032, 656, 704],
            [5345, 5369, 5009, 5033, 657, 705],
            [5330, 5370, 4994, 5034, 658, 706],
            [5331, 5371, 4995, 5035, 659, 707],
            [5332, 5372, 4996, 5036, 660, 708],
            [5333, 5373, 4997, 5037, 661, 709],
            [5334, 5374, 4998, 5038, 662, 710],
            [5335, 5375, 4999, 5039, 663, 711],
            [5336, 5376, 5000, 5040, 664, 712],
            [5337, 5377, 5001, 5041, 665, 713],
            [5346, 5354, 5010, 5018, 666, 714],
            [5347, 5355, 5011, 5019, 667, 715],
            [5348, 5356, 5012, 5020, 668, 716],
            [5349, 5357, 5013, 5021, 669, 717],
            [5350, 5358, 5014, 5022, 670, 718],
            [5351, 5359, 5015, 5023, 671, 719],
            [5352, 5360, 5016, 5024, 672, 720],
            [5353, 5361, 5017, 5025, 673, 721],
            [5578, 5602, 5338, 5362, 674, 722],
            [5579, 5603, 5339, 5363, 675, 723],
            [5580, 5604, 5340, 5364, 676, 724],
            [5581, 5605, 5341, 5365, 677, 725],
            [5582, 5606, 5342, 5366, 678, 726],
            [5583, 5607, 5343, 5367, 679, 727],
            [5584, 5608, 5344, 5368, 680, 728],
            [5585, 5609, 5345, 5369, 681, 729],
            [5570, 5610, 5330, 5370, 682, 730],
            [5571, 5611, 5331, 5371, 683, 731],
            [5572, 5612, 5332, 5372, 684, 732],
            [5573, 5613, 5333, 5373, 685, 733],
            [5574, 5614, 5334, 5374, 686, 734],
            [5575, 5615, 5335, 5375, 687, 735],
            [5576, 5616, 5336, 5376, 688, 736],
            [5577, 5617, 5337, 5377, 689, 737],
            [5586, 5594, 5346, 5354, 690, 738],
            [5587, 5595, 5347, 5355, 691, 739],
            [5588, 5596, 5348, 5356, 692, 740],
            [5589, 5597, 5349, 5357, 693, 741],
            [5590, 5598, 5350, 5358, 694, 742],
            [5591, 5599, 5351, 5359, 695, 743],
            [5592, 5600, 5352, 5360, 696, 744],
            [5593, 5601, 5353, 5361, 697, 745],
            [5722, 5746, 5578, 5602, 698, 746],
            [5723, 5747, 5579, 5603, 699, 747],
            [5724, 5748, 5580, 5604, 700, 748],
            [5725, 5749, 5581, 5605, 701, 749],
            [5726, 5750, 5582, 5606, 702, 750],
            [5727, 5751, 5583, 5607, 703, 751],
            [5728, 5752, 5584, 5608, 704, 752],
            [5729, 5753, 5585, 5609, 705, 753],
            [5714, 5754, 5570, 5610, 706, 754],
            [5715, 5755, 5571, 5611, 707, 755],
            [5716, 5756, 5572, 5612, 708, 756],
            [5717, 5757, 5573, 5613, 709, 757],
            [5718, 5758, 5574, 5614, 710, 758],
            [5719, 5759, 5575, 5615, 711, 759],
            [5720, 5760, 5576, 5616, 712, 760],
            [5721, 5761, 5577, 5617, 713, 761],
            [5730, 5738, 5586, 5594, 714, 762],
            [5731, 5739, 5587, 5595, 715, 763],
            [5732, 5740, 5588, 5596, 716, 764],
            [5733, 5741, 5589, 5597, 717, 765],
            [5734, 5742, 5590, 5598, 718, 766],
            [5735, 5743, 5591, 5599, 719, 767],
            [5736, 5744, 5592, 5600, 720, 768],
            [5737, 5745, 5593, 5601, 721, 769],
            [5770, 5794, 5722, 5746, 722, 14],
            [5771, 5795, 5723, 5747, 723, 15],
            [5772, 5796, 5724, 5748, 724, 16],
            [5773, 5797, 5725, 5749, 725, 17],
            [5774, 5798, 5726, 5750, 726, 14],
            [5775, 5799, 5727, 5751, 727, 15],
            [5776, 5800, 5728, 5752, 728, 16],
            [5777, 5801, 5729, 5753, 729, 17],
            [5762, 5802, 5714, 5754, 730, 10],
            [5763, 5803, 5715, 5755, 731, 11],
            [5764, 5804, 5716, 5756, 732, 10],
            [5765, 5805, 5717, 5757, 733, 11],
            [5766, 5806, 5718, 5758, 734, 12],
            [5767, 5807, 5719, 5759, 735, 13],
            [5768, 5808, 5720, 5760, 736, 12],
            [5769, 5809, 5721, 5761, 737, 13],
            [5778, 5786, 5730, 5738, 738, 6],
            [5779, 5787, 5731, 5739, 739, 6],
            [5780, 5788, 5732, 5740, 740, 7],
            [5781, 5789, 5733, 5741, 741, 7],
            [5782, 5790, 5734, 5742, 742, 8],
            [5783, 5791, 5735, 5743, 743, 8],
            [5784, 5792, 5736, 5744, 744, 9],
            [5785, 5793, 5737, 5745, 745, 9],
            [34, 38, 58, 62, 1018, 1022],
            [35, 39, 59, 63, 1019, 1023],
            [36, 40, 60, 64, 1020, 1024],
            [37, 41, 61, 65, 1021, 1025],
            [42, 46, 66, 70, 1042, 1046],
            [43, 47, 67, 71, 1043, 1047],
            [44, 48, 68, 72, 1044, 1048],
            [45, 49, 69, 73, 1045, 1049],
            [26, 28, 50, 52, 1010, 1012],
            [27, 29, 51, 53, 1011, 1013],
            [30, 32, 54, 56, 1014, 1016],
            [31, 33, 55, 57, 1015, 1017],
            [42, 44, 66, 68, 1050, 1052],
            [43, 45, 67, 69, 1051, 1053],
            [46, 48, 70, 72, 1054, 1056],
            [47, 49, 71, 73, 1055, 1057],
            [26, 27, 50, 51, 1026, 1027],
            [28, 29, 52, 53, 1028, 1029],
            [30, 31, 54, 55, 1030, 1031],
            [32, 33, 56, 57, 1032, 1033],
            [34, 35, 58, 59, 1034, 1035],
            [36, 37, 60, 61, 1036, 1037],
            [38, 39, 62, 63, 1038, 1039],
            [40, 41, 64, 65, 1040, 1041],
            [1018, 1022, 1930, 1934, 1066, 1070],
            [1019, 1023, 1931, 1935, 1067, 1071],
            [1020, 1024, 1932, 1936, 1068, 1072],
            [1021, 1025, 1933, 1937, 1069, 1073],
            [1042, 1046, 1954, 1958, 1090, 1094],
            [1043, 1047, 1955, 1959, 1091, 1095],
            [1044, 1048, 1956, 1960, 1092, 1096],
            [1045, 1049, 1957, 1961, 1093, 1097],
            [1010, 1012, 1922, 1924, 1058, 1060],
            [1011, 1013, 1923, 1925, 1059, 1061],
            [1014, 1016, 1926, 1928, 1062, 1064],
            [1015, 1017, 1927, 1929, 1063, 1065],
            [1050, 1052, 1962, 1964, 1098, 1100],
            [1051, 1053, 1963, 1965, 1099, 1101],
            [1054, 1056, 1966, 1968, 1102, 1104],
            [1055, 1057, 1967, 1969, 1103, 1105],
            [1026, 1027, 1938, 1939, 1074, 1075],
            [1028, 1029, 1940, 1941, 1076, 1077],
            [1030, 1031, 1942, 1943, 1078, 1079],
            [1032, 1033, 1944, 1945, 1080, 1081],
            [1034, 1035, 1946, 1947, 1082, 1083],
            [1036, 1037, 1948, 1949, 1084, 1085],
            [1038, 1039, 1950, 1951, 1086, 1087],
            [1040, 1041, 1952, 1953, 1088, 1089],
            [1930, 1934, 2746, 2750, 1978, 1982],
            [1931, 1935, 2747, 2751, 1979, 1983],
            [1932, 1936, 2748, 2752, 1980, 1984],
            [1933, 1937, 2749, 2753, 1981, 1985],
            [1954, 1958, 2770, 2774, 2002, 2006],
            [1955, 1959, 2771, 2775, 2003, 2007],
            [1956, 1960, 2772, 2776, 2004, 2008],
            [1957, 1961, 2773, 2777, 2005, 2009],
            [1922, 1924, 2738, 2740, 1970, 1972],
            [1923, 1925, 2739, 2741, 1971, 1973],
            [1926, 1928, 2742, 2744, 1974, 1976],
            [1927, 1929, 2743, 2745, 1975, 1977],
            [1962, 1964, 2778, 2780, 2010, 2012],
            [1963, 1965, 2779, 2781, 2011, 2013],
            [1966, 1968, 2782, 2784, 2014, 2016],
            [1967, 1969, 2783, 2785, 2015, 2017],
            [1938, 1939, 2754, 2755, 1986, 1987],
            [1940, 1941, 2756, 2757, 1988, 1989],
            [1942, 1943, 2758, 2759, 1990, 1991],
            [1944, 1945, 2760, 2761, 1992, 1993],
            [1946, 1947, 2762, 2763, 1994, 1995],
            [1948, 1949, 2764, 2765, 1996, 1997],
            [1950, 1951, 2766, 2767, 1998, 1999],
            [1952, 1953, 2768, 2769, 2000, 2001],
            [2746, 2750, 3466, 3470, 2794, 2798],
            [2747, 2751, 3467, 3471, 2795, 2799],
            [2748, 2752, 3468, 3472, 2796, 2800],
            [2749, 2753, 3469, 3473, 2797, 2801],
            [2770, 2774, 3490, 3494, 2818, 2822],
            [2771, 2775, 3491, 3495, 2819, 2823],
            [2772, 2776, 3492, 3496, 2820, 2824],
            [2773, 2777, 3493, 3497, 2821, 2825],
            [2738, 2740, 3458, 3460, 2786, 2788],
            [2739, 2741, 3459, 3461, 2787, 2789],
            [2742, 2744, 3462, 3464, 2790, 2792],
            [2743, 2745, 3463, 3465, 2791, 2793],
            [2778, 2780, 3498, 3500, 2826, 2828],
            [2779, 2781, 3499, 3501, 2827, 2829],
            [2782, 2784, 3502, 3504, 2830, 2832],
            [2783, 2785, 3503, 3505, 2831, 2833],
            [2754, 2755, 3474, 3475, 2802, 2803],
            [2756, 2757, 3476, 3477, 2804, 2805],
            [2758, 2759, 3478, 3479, 2806, 2807],
            [2760, 2761, 3480, 3481, 2808, 2809],
            [2762, 2763, 3482, 3483, 2810, 2811],
            [2764, 2765, 3484, 3485, 2812, 2813],
            [2766, 2767, 3486, 3487, 2814, 2815],
            [2768, 2769, 3488, 3489, 2816, 2817],
            [3466, 3470, 4090, 4094, 3514, 3518],
            [3467, 3471, 4091, 4095, 3515, 3519],
            [3468, 3472, 4092, 4096, 3516, 3520],
            [3469, 3473, 4093, 4097, 3517, 3521],
            [3490, 3494, 4114, 4118, 3538, 3542],
            [3491, 3495, 4115, 4119, 3539, 3543],
            [3492, 3496, 4116, 4120, 3540, 3544],
            [3493, 3497, 4117, 4121, 3541, 3545],
            [3458, 3460, 4082, 4084, 3506, 3508],
            [3459, 3461, 4083, 4085, 3507, 3509],
            [3462, 3464, 4086, 4088, 3510, 3512],
            [3463, 3465, 4087, 4089, 3511, 3513],
            [3498, 3500, 4122, 4124, 3546, 3548],
            [3499, 3501, 4123, 4125, 3547, 3549],
            [3502, 3504, 4126, 4128, 3550, 3552],
            [3503, 3505, 4127, 4129, 3551, 3553],
            [3474, 3475, 4098, 4099, 3522, 3523],
            [3476, 3477, 4100, 4101, 3524, 3525],
            [3478, 3479, 4102, 4103, 3526, 3527],
            [3480, 3481, 4104, 4105, 3528, 3529],
            [3482, 3483, 4106, 4107, 3530, 3531],
            [3484, 3485, 4108, 4109, 3532, 3533],
            [3486, 3487, 4110, 4111, 3534, 3535],
            [3488, 3489, 4112, 4113, 3536, 3537],
            [4090, 4094, 4618, 4622, 4138, 4142],
            [4091, 4095, 4619, 4623, 4139, 4143],
            [4092, 4096, 4620, 4624, 4140, 4144],
            [4093, 4097, 4621, 4625, 4141, 4145],
            [4114, 4118, 4642, 4646, 4162, 4166],
            [4115, 4119, 4643, 4647, 4163, 4167],
            [4116, 4120, 4644, 4648, 4164, 4168],
            [4117, 4121, 4645, 4649, 4165, 4169],
            [4082, 4084, 4610, 4612, 4130, 4132],
            [4083, 4085, 4611, 4613, 4131, 4133],
            [4086, 4088, 4614, 4616, 4134, 4136],
            [4087, 4089, 4615, 4617, 4135, 4137],
            [4122, 4124, 4650, 4652, 4170, 4172],
            [4123, 4125, 4651, 4653, 4171, 4173],
            [4126, 4128, 4654, 4656, 4174, 4176],
            [4127, 4129, 4655, 4657, 4175, 4177],
            [4098, 4099, 4626, 4627, 4146, 4147],
            [4100, 4101, 4628, 4629, 4148, 4149],
            [4102, 4103, 4630, 4631, 4150, 4151],
            [4104, 4105, 4632, 4633, 4152, 4153],
            [4106, 4107, 4634, 4635, 4154, 4155],
            [4108, 4109, 4636, 4637, 4156, 4157],
            [4110, 4111, 4638, 4639, 4158, 4159],
            [4112, 4113, 4640, 4641, 4160, 4161],
            [4618, 4622, 5050, 5054, 4666, 4670],
            [4619, 4623, 5051, 5055, 4667, 4671],
            [4620, 4624, 5052, 5056, 4668, 4672],
            [4621, 4625, 5053, 5057, 4669, 4673],
            [4642, 4646, 5074, 5078, 4690, 4694],
            [4643, 4647, 5075, 5079, 4691, 4695],
            [4644, 4648, 5076, 5080, 4692, 4696],
            [4645, 4649, 5077, 5081, 4693, 4697],
            [4610, 4612, 5042, 5044, 4658, 4660],
            [4611, 4613, 5043, 5045, 4659, 4661],
            [4614, 4616, 5046, 5048, 4662, 4664],
            [4615, 4617, 5047, 5049, 4663, 4665],
            [4650, 4652, 5082, 5084, 4698, 4700],
            [4651, 4653, 5083, 5085, 4699, 4701],
            [4654, 4656, 5086, 5088, 4702, 4704],
            [4655, 4657, 5087, 5089, 4703, 4705],
            [4626, 4627, 5058, 5059, 4674, 4675],
            [4628, 4629, 5060, 5061, 4676, 4677],
            [4630, 4631, 5062, 5063, 4678, 4679],
            [4632, 4633, 5064, 5065, 4680, 4681],
            [4634, 4635, 5066, 5067, 4682, 4683],
            [4636, 4637, 5068, 5069, 4684, 4685],
            [4638, 4639, 5070, 5071, 4686, 4687],
            [4640, 4641, 5072, 5073, 4688, 4689],
            [5050, 5054, 5386, 5390, 5098, 5102],
            [5051, 5055, 5387, 5391, 5099, 5103],
            [5052, 5056, 5388, 5392, 5100, 5104],
            [5053, 5057, 5389, 5393, 5101, 5105],
            [5074, 5078, 5410, 5414, 5122, 5126],
            [5075, 5079, 5411, 5415, 5123, 5127],
            [5076, 5080, 5412, 5416, 5124, 5128],
            [5077, 5081, 5413, 5417, 5125, 5129],
            [5042, 5044, 5378, 5380, 5090, 5092],
            [5043, 5045, 5379, 5381, 5091, 5093],
            [5046, 5048, 5382, 5384, 5094, 5096],
            [5047, 5049, 5383, 5385, 5095, 5097],
            [5082, 5084, 5418, 5420, 5130, 5132],
            [5083, 5085, 5419, 5421, 5131, 5133],
            [5086, 5088, 5422, 5424, 5134, 5136],
            [5087, 5089, 5423, 5425, 5135, 5137],
            [5058, 5059, 5394, 5395, 5106, 5107],
            [5060, 5061, 5396, 5397, 5108, 5109],
            [5062, 5063, 5398, 5399, 5110, 5111],
            [5064, 5065, 5400, 5401, 5112, 5113],
            [5066, 5067, 5402, 5403, 5114, 5115],
            [5068, 5069, 5404, 5405, 5116, 5117],
            [5070, 5071, 5406, 5407, 5118, 5119],
            [5072, 5073, 5408, 5409, 5120, 5121],
            [5386, 5390, 5626, 5630, 5434, 5438],
            [5387, 5391, 5627, 5631, 5435, 5439],
            [5388, 5392, 5628, 5632, 5436, 5440],
            [5389, 5393, 5629, 5633, 5437, 5441],
            [5410, 5414, 5650, 5654, 5458, 5462],
            [5411, 5415, 5651, 5655, 5459, 5463],
            [5412, 5416, 5652, 5656, 5460, 5464],
            [5413, 5417, 5653, 5657, 5461, 5465],
            [5378, 5380, 5618, 5620, 5426, 5428],
            [5379, 5381, 5619, 5621, 5427, 5429],
            [5382, 5384, 5622, 5624, 5430, 5432],
            [5383, 5385, 5623, 5625, 5431, 5433],
            [5418, 5420, 5658, 5660, 5466, 5468],
            [5419, 5421, 5659, 5661, 5467, 5469],
            [5422, 5424, 5662, 5664, 5470, 5472],
            [5423, 5425, 5663, 5665, 5471, 5473],
            [5394, 5395, 5634, 5635, 5442, 5443],
            [5396, 5397, 5636, 5637, 5444, 5445],
            [5398, 5399, 5638, 5639, 5446, 5447],
            [5400, 5401, 5640, 5641, 5448, 5449],
            [5402, 5403, 5642, 5643, 5450, 5451],
            [5404, 5405, 5644, 5645, 5452, 5453],
            [5406, 5407, 5646, 5647, 5454, 5455],
            [5408, 5409, 5648, 5649, 5456, 5457],
            [5626, 5630, 5770, 5774, 5674, 5678],
            [5627, 5631, 5771, 5775, 5675, 5679],
            [5628, 5632, 5772, 5776, 5676, 5680],
            [5629, 5633, 5773, 5777, 5677, 5681],
            [5650, 5654, 5794, 5798, 5698, 5702],
            [5651, 5655, 5795, 5799, 5699, 5703],
            [5652, 5656, 5796, 5800, 5700, 5704],
            [5653, 5657, 5797, 5801, 5701, 5705],
            [5618, 5620, 5762, 5764, 5666, 5668],
            [5619, 5621, 5763, 5765, 5667, 5669],
            [5622, 5624, 5766, 5768, 5670, 5672],
            [5623, 5625, 5767, 5769, 5671, 5673],
            [5658, 5660, 5802, 5804, 5706, 5708],
            [5659, 5661, 5803, 5805, 5707, 5709],
            [5662, 5664, 5806, 5808, 5710, 5712],
            [5663, 5665, 5807, 5809, 5711, 5713],
            [5634, 5635, 5778, 5779, 5682, 5683],
            [5636, 5637, 5780, 5781, 5684, 5685],
            [5638, 5639, 5782, 5783, 5686, 5687],
            [5640, 5641, 5784, 5785, 5688, 5689],
            [5642, 5643, 5786, 5787, 5690, 5691],
            [5644, 5645, 5788, 5789, 5692, 5693],
            [5646, 5647, 5790, 5791, 5694, 5695],
            [5648, 5649, 5792, 5793, 5696, 5697],
            [778, 50, 1058, 802, 1012, 74],
            [779, 51, 1059, 803, 1013, 75],
            [778, 52, 1060, 802, 1010, 76],
            [779, 53, 1061, 803, 1011, 77],
            [780, 54, 1062, 804, 1016, 78],
            [781, 55, 1063, 805, 1017, 79],
            [780, 56, 1064, 804, 1014, 80],
            [781, 57, 1065, 805, 1015, 81],
            [770, 58, 1066, 794, 1022, 82],
            [771, 59, 1067, 795, 1023, 83],
            [772, 60, 1068, 796, 1024, 84],
            [773, 61, 1069, 797, 1025, 85],
            [770, 62, 1070, 794, 1018, 86],
            [771, 63, 1071, 795, 1019, 87],
            [772, 64, 1072, 796, 1020, 88],
            [773, 65, 1073, 797, 1021, 89],
            [786, 50, 1074, 810, 1027, 74],
            [786, 51, 1075, 810, 1026, 75],
            [787, 52, 1076, 811, 1029, 76],
            [787, 53, 1077, 811, 1028, 77],
            [788, 54, 1078, 812, 1031, 78],
            [788, 55, 1079, 812, 1030, 79],
            [789, 56, 1080, 813, 1033, 80],
            [789, 57, 1081, 813, 1032, 81],
            [790, 58, 1082, 814, 1035, 82],
            [790, 59, 1083, 814, 1034, 83],
            [791, 60, 1084, 815, 1037, 84],
            [791, 61, 1085, 815, 1036, 85],
            [792, 62, 1086, 816, 1039, 86],
            [792, 63, 1087, 816, 1038, 87],
            [793, 64, 1088, 817, 1041, 88],
            [793, 65, 1089, 817, 1040, 89],
            [774, 66, 1090, 798, 1046, 90],
            [775, 67, 1091, 799, 1047, 91],
            [776, 68, 1092, 800, 1048, 92],
            [777, 69, 1093, 801, 1049, 93],
            [774, 70, 1094, 798, 1042, 94],
            [775, 71, 1095, 799, 1043, 95],
            [776, 72, 1096, 800, 1044, 96],
            [777, 73, 1097, 801, 1045, 97],
            [782, 66, 1098, 806, 1052, 90],
            [783, 67, 1099, 807, 1053, 91],
            [782, 68, 1100, 806, 1050, 92],
            [783, 69, 1101, 807, 1051, 93],
            [784, 70, 1102, 808, 1056, 94],
            [785, 71, 1103, 809, 1057, 95],
            [784, 72, 1104, 808, 1054, 96],
            [785, 73, 1105, 809, 1055, 97],
            [1010, 74, 1106, 1922, 802, 98],
            [1011, 75, 1107, 1923, 803, 99],
            [1012, 76, 1108, 1924, 802, 100],
            [1013, 77, 1109, 1925, 803, 101],
            [1014, 78, 1110, 1926, 804, 102],
            [1015, 79, 1111, 1927, 805, 103],
            [1016, 80, 1112, 1928, 804, 104],
            [1017, 81, 1113, 1929, 805, 105],
            [1018, 82, 1114, 1930, 794, 106],
            [1019, 83, 1115, 1931, 795, 107],
            [1020, 84, 1116, 1932, 796, 108],
            [1021, 85, 1117, 1933, 797, 109],
            [1022, 86, 1118, 1934, 794, 110],
            [1023, 87, 1119, 1935, 795, 111],
            [1024, 88, 1120, 1936, 796, 112],
            [1025, 89, 1121, 1937, 797, 113],
            [1026, 74, 1122, 1938, 810, 98],
            [1027, 75, 1123, 1939, 810, 99],
            [1028, 76, 1124, 1940, 811, 100],
            [1029, 77, 1125, 1941, 811, 101],
            [1030, 78, 1126, 1942, 812, 102],
            [1031, 79, 1127, 1943, 812, 103],
            [1032, 80, 1128, 1944, 813, 104],
            [1033, 81, 1129, 1945, 813, 105],
            [1034, 82, 1130, 1946, 814, 106],
            [1035, 83, 1131, 1947, 814, 107],
            [1036, 84, 1132, 1948, 815, 108],
            [1037, 85, 1133, 1949, 815, 109],
            [1038, 86, 1134, 1950, 816, 110],
            [1039, 87, 1135, 1951, 816, 111],
            [1040, 88, 1136, 1952, 817, 112],
            [1041, 89, 1137, 1953, 817, 113],
            [1042, 90, 1138, 1954, 798, 114],
            [1043, 91, 1139, 1955, 799, 115],
            [1044, 92, 1140, 1956, 800, 116],
            [1045, 93, 1141, 1957, 801, 117],
            [1046, 94, 1142, 1958, 798, 118],
            [1047, 95, 1143, 1959, 799, 119],
            [1048, 96, 1144, 1960, 800, 120],
            [1049, 97, 1145, 1961, 801, 121],
            [1050, 90, 1146, 1962, 806, 114],
            [1051, 91, 1147, 1963, 807, 115],
            [1052, 92, 1148, 1964, 806, 116],
            [1053, 93, 1149, 1965, 807, 117],
            [1054, 94, 1150, 1966, 808, 118],
            [1055, 95, 1151, 1967, 809, 119],
            [1056, 96, 1152, 1968, 808, 120],
            [1057, 97, 1153, 1969, 809, 121],
            [1058, 1154, 98, 1970, 1922, 122],
            [1059, 1155, 99, 1971, 1923, 123],
            [1060, 1156, 100, 1972, 1924, 124],
            [1061, 1157, 101, 1973, 1925, 125],
            [1062, 1158, 102, 1974, 1926, 126],
            [1063, 1159, 103, 1975, 1927, 127],
            [1064, 1160, 104, 1976, 1928, 128],
            [1065, 1161, 105, 1977, 1929, 129],
            [1066, 1162, 106, 1978, 1930, 130],
            [1067, 1163, 107, 1979, 1931, 131],
            [1068, 1164, 108, 1980, 1932, 132],
            [1069, 1165, 109, 1981, 1933, 133],
            [1070, 1166, 110, 1982, 1934, 134],
            [1071, 1167, 111, 1983, 1935, 135],
            [1072, 1168, 112, 1984, 1936, 136],
            [1073, 1169, 113, 1985, 1937, 137],
            [1074, 1170, 98, 1986, 1938, 122],
            [1075, 1171, 99, 1987, 1939, 123],
            [1076, 1172, 100, 1988, 1940, 124],
            [1077, 1173, 101, 1989, 1941, 125],
            [1078, 1174, 102, 1990, 1942, 126],
            [1079, 1175, 103, 1991, 1943, 127],
            [1080, 1176, 104, 1992, 1944, 128],
            [1081, 1177, 105, 1993, 1945, 129],
            [1082, 1178, 106, 1994, 1946, 130],
            [1083, 1179, 107, 1995, 1947, 131],
            [1084, 1180, 108, 1996, 1948, 132],
            [1085, 1181, 109, 1997, 1949, 133],
            [1086, 1182, 110, 1998, 1950, 134],
            [1087, 1183, 111, 1999, 1951, 135],
            [1088, 1184, 112, 2000, 1952, 136],
            [1089, 1185, 113, 2001, 1953, 137],
            [1090, 1186, 114, 2002, 1954, 138],
            [1091, 1187, 115, 2003, 1955, 139],
            [1092, 1188, 116, 2004, 1956, 140],
            [1093, 1189, 117, 2005, 1957, 141],
            [1094, 1190, 118, 2006, 1958, 142],
            [1095, 1191, 119, 2007, 1959, 143],
            [1096, 1192, 120, 2008, 1960, 144],
            [1097, 1193, 121, 2009, 1961, 145],
            [1098, 1194, 114, 2010, 1962, 138],
            [1099, 1195, 115, 2011, 1963, 139],
            [1100, 1196, 116, 2012, 1964, 140],
            [1101, 1197, 117, 2013, 1965, 141],
            [1102, 1198, 118, 2014, 1966, 142],
            [1103, 1199, 119, 2015, 1967, 143],
            [1104, 1200, 120, 2016, 1968, 144],
            [1105, 1201, 121, 2017, 1969, 145],
            [1106, 1202, 122, 2018, 1970, 146],
            [1107, 1203, 123, 2019, 1971, 147],
            [1108, 1204, 124, 2020, 1972, 148],
            [1109, 1205, 125, 2021, 1973, 149],
            [1110, 1206, 126, 2022, 1974, 150],
            [1111, 1207, 127, 2023, 1975, 151],
            [1112, 1208, 128, 2024, 1976, 152],
            [1113, 1209, 129, 2025, 1977, 153],
            [1114, 1210, 130, 2026, 1978, 154],
            [1115, 1211, 131, 2027, 1979, 155],
            [1116, 1212, 132, 2028, 1980, 156],
            [1117, 1213, 133, 2029, 1981, 157],
            [1118, 1214, 134, 2030, 1982, 158],
            [1119, 1215, 135, 2031, 1983, 159],
            [1120, 1216, 136, 2032, 1984, 160],
            [1121, 1217, 137, 2033, 1985, 161],
            [1122, 1218, 122, 2034, 1986, 146],
            [1123, 1219, 123, 2035, 1987, 147],
            [1124, 1220, 124, 2036, 1988, 148],
            [1125, 1221, 125, 2037, 1989, 149],
            [1126, 1222, 126, 2038, 1990, 150],
            [1127, 1223, 127, 2039, 1991, 151],
            [1128, 1224, 128, 2040, 1992, 152],
            [1129, 1225, 129, 2041, 1993, 153],
            [1130, 1226, 130, 2042, 1994, 154],
            [1131, 1227, 131, 2043, 1995, 155],
            [1132, 1228, 132, 2044, 1996, 156],
            [1133, 1229, 133, 2045, 1997, 157],
            [1134, 1230, 134, 2046, 1998, 158],
            [1135, 1231, 135, 2047, 1999, 159],
            [1136, 1232, 136, 2048, 2000, 160],
            [1137, 1233, 137, 2049, 2001, 161],
            [1138, 1234, 138, 2050, 2002, 162],
            [1139, 1235, 139, 2051, 2003, 163],
            [1140, 1236, 140, 2052, 2004, 164],
            [1141, 1237, 141, 2053, 2005, 165],
            [1142, 1238, 142, 2054, 2006, 166],
            [1143, 1239, 143, 2055, 2007, 167],
            [1144, 1240, 144, 2056, 2008, 168],
            [1145, 1241, 145, 2057, 2009, 169],
            [1146, 1242, 138, 2058, 2010, 162],
            [1147, 1243, 139, 2059, 2011, 163],
            [1148, 1244, 140, 2060, 2012, 164],
            [1149, 1245, 141, 2061, 2013, 165],
            [1150, 1246, 142, 2062, 2014, 166],
            [1151, 1247, 143, 2063, 2015, 167],
            [1152, 1248, 144, 2064, 2016, 168],
            [1153, 1249, 145, 2065, 2017, 169],
            [1154, 1250, 146, 2066, 2018, 170],
            [1155, 1251, 147, 2067, 2019, 171],
            [1156, 1252, 148, 2068, 2020, 172],
            [1157, 1253, 149, 2069, 2021, 173],
            [1158, 1254, 150, 2070, 2022, 174],
            [1159, 1255, 151, 2071, 2023, 175],
            [1160, 1256, 152, 2072, 2024, 176],
            [1161, 1257, 153, 2073, 2025, 177],
            [1162, 1258, 154, 2074, 2026, 178],
            [1163, 1259, 155, 2075, 2027, 179],
            [1164, 1260, 156, 2076, 2028, 180],
            [1165, 1261, 157, 2077, 2029, 181],
            [1166, 1262, 158, 2078, 2030, 182],
            [1167, 1263, 159, 2079, 2031, 183],
            [1168, 1264, 160, 2080, 2032, 184],
            [1169, 1265, 161, 2081, 2033, 185],
            [1170, 1266, 146, 2082, 2034, 170],
            [1171, 1267, 147, 2083, 2035, 171],
            [1172, 1268, 148, 2084, 2036, 172],
            [1173, 1269, 149, 2085, 2037, 173],
            [1174, 1270, 150, 2086, 2038, 174],
            [1175, 1271, 151, 2087, 2039, 175],
            [1176, 1272, 152, 2088, 2040, 176],
            [1177, 1273, 153, 2089, 2041, 177],
            [1178, 1274, 154, 2090, 2042, 178],
            [1179, 1275, 155, 2091, 2043, 179],
            [1180, 1276, 156, 2092, 2044, 180],
            [1181, 1277, 157, 2093, 2045, 181],
            [1182, 1278, 158, 2094, 2046, 182],
            [1183, 1279, 159, 2095, 2047, 183],
            [1184, 1280, 160, 2096, 2048, 184],
            [1185, 1281, 161, 2097, 2049, 185],
            [1186, 1282, 162, 2098, 2050, 186],
            [1187, 1283, 163, 2099, 2051, 187],
            [1188, 1284, 164, 2100, 2052, 188],
            [1189, 1285, 165, 2101, 2053, 189],
            [1190, 1286, 166, 2102, 2054, 190],
            [1191, 1287, 167, 2103, 2055, 191],
            [1192, 1288, 168, 2104, 2056, 192],
            [1193, 1289, 169, 2105, 2057, 193],
            [1194, 1290, 162, 2106, 2058, 186],
            [1195, 1291, 163, 2107, 2059, 187],
            [1196, 1292, 164, 2108, 2060, 188],
            [1197, 1293, 165, 2109, 2061, 189],
            [1198, 1294, 166, 2110, 2062, 190],
            [1199, 1295, 167, 2111, 2063, 191],
            [1200, 1296, 168, 2112, 2064, 192],
            [1201, 1297, 169, 2113, 2065, 193],
            [1202, 1298, 170, 2114, 194, 2066],
            [1203, 1299, 171, 2115, 195, 2067],
            [1204, 1300, 172, 2116, 196, 2068],
            [1205, 1301, 173, 2117, 197, 2069],
            [1206, 1302, 174, 2118, 198, 2070],
            [1207, 1303, 175, 2119, 199, 2071],
            [1208, 1304, 176, 2120, 200, 2072],
            [1209, 1305, 177, 2121, 201, 2073],
            [1210, 1306, 178, 2122, 202, 2074],
            [1211, 1307, 179, 2123, 203, 2075],
            [1212, 1308, 180, 2124, 204, 2076],
            [1213, 1309, 181, 2125, 205, 2077],
            [1214, 1310, 182, 2126, 206, 2078],
            [1215, 1311, 183, 2127, 207, 2079],
            [1216, 1312, 184, 2128, 208, 2080],
            [1217, 1313, 185, 2129, 209, 2081],
            [1218, 1314, 170, 2130, 194, 2082],
            [1219, 1315, 171, 2131, 195, 2083],
            [1220, 1316, 172, 2132, 196, 2084],
            [1221, 1317, 173, 2133, 197, 2085],
            [1222, 1318, 174, 2134, 198, 2086],
            [1223, 1319, 175, 2135, 199, 2087],
            [1224, 1320, 176, 2136, 200, 2088],
            [1225, 1321, 177, 2137, 201, 2089],
            [1226, 1322, 178, 2138, 202, 2090],
            [1227, 1323, 179, 2139, 203, 2091],
            [1228, 1324, 180, 2140, 204, 2092],
            [1229, 1325, 181, 2141, 205, 2093],
            [1230, 1326, 182, 2142, 206, 2094],
            [1231, 1327, 183, 2143, 207, 2095],
            [1232, 1328, 184, 2144, 208, 2096],
            [1233, 1329, 185, 2145, 209, 2097],
            [1234, 1330, 186, 2146, 210, 2098],
            [1235, 1331, 187, 2147, 211, 2099],
            [1236, 1332, 188, 2148, 212, 2100],
            [1237, 1333, 189, 2149, 213, 2101],
            [1238, 1334, 190, 2150, 214, 2102],
            [1239, 1335, 191, 2151, 215, 2103],
            [1240, 1336, 192, 2152, 216, 2104],
            [1241, 1337, 193, 2153, 217, 2105],
            [1242, 1338, 186, 2154, 210, 2106],
            [1243, 1339, 187, 2155, 211, 2107],
            [1244, 1340, 188, 2156, 212, 2108],
            [1245, 1341, 189, 2157, 213, 2109],
            [1246, 1342, 190, 2158, 214, 2110],
            [1247, 1343, 191, 2159, 215, 2111],
            [1248, 1344, 192, 2160, 216, 2112],
            [1249, 1345, 193, 2161, 217, 2113],
            [1250, 1346, 2162, 194, 218, 2114],
            [1251, 1347, 2163, 195, 219, 2115],
            [1252, 1348, 2164, 196, 220, 2116],
            [1253, 1349, 2165, 197, 221, 2117],
            [1254, 1350, 2166, 198, 222, 2118],
            [1255, 1351, 2167, 199, 223, 2119],
            [1256, 1352, 2168, 200, 224, 2120],
            [1257, 1353, 2169, 201, 225, 2121],
            [1258, 1354, 2170, 202, 226, 2122],
            [1259, 1355, 2171, 203, 227, 2123],
            [1260, 1356, 2172, 204, 228, 2124],
            [1261, 1357, 2173, 205, 229, 2125],
            [1262, 1358, 2174, 206, 230, 2126],
            [1263, 1359, 2175, 207, 231, 2127],
            [1264, 1360, 2176, 208, 232, 2128],
            [1265, 1361, 2177, 209, 233, 2129],
            [1266, 1362, 2178, 194, 218, 2130],
            [1267, 1363, 2179, 195, 219, 2131],
            [1268, 1364, 2180, 196, 220, 2132],
            [1269, 1365, 2181, 197, 221, 2133],
            [1270, 1366, 2182, 198, 222, 2134],
            [1271, 1367, 2183, 199, 223, 2135],
            [1272, 1368, 2184, 200, 224, 2136],
            [1273, 1369, 2185, 201, 225, 2137],
            [1274, 1370, 2186, 202, 226, 2138],
            [1275, 1371, 2187, 203, 227, 2139],
            [1276, 1372, 2188, 204, 228, 2140],
            [1277, 1373, 2189, 205, 229, 2141],
            [1278, 1374, 2190, 206, 230, 2142],
            [1279, 1375, 2191, 207, 231, 2143],
            [1280, 1376, 2192, 208, 232, 2144],
            [1281, 1377, 2193, 209, 233, 2145],
            [1282, 1378, 2194, 210, 234, 2146],
            [1283, 1379, 2195, 211, 235, 2147],
            [1284, 1380, 2196, 212, 236, 2148],
            [1285, 1381, 2197, 213, 237, 2149],
            [1286, 1382, 2198, 214, 238, 2150],
            [1287, 1383, 2199, 215, 239, 2151],
            [1288, 1384, 2200, 216, 240, 2152],
            [1289, 1385, 2201, 217, 241, 2153],
            [1290, 1386, 2202, 210, 234, 2154],
            [1291, 1387, 2203, 211, 235, 2155],
            [1292, 1388, 2204, 212, 236, 2156],
            [1293, 1389, 2205, 213, 237, 2157],
            [1294, 1390, 2206, 214, 238, 2158],
            [1295, 1391, 2207, 215, 239, 2159],
            [1296, 1392, 2208, 216, 240, 2160],
            [1297, 1393, 2209, 217, 241, 2161],
            [1298, 1394, 2210, 218, 242, 2162],
            [1299, 1395, 2211, 219, 243, 2163],
            [1300, 1396, 2212, 220, 244, 2164],
            [1301, 1397, 2213, 221, 245, 2165],
            [1302, 1398, 2214, 222, 246, 2166],
            [1303, 1399, 2215, 223, 247, 2167],
            [1304, 1400, 2216, 224, 248, 2168],
            [1305, 1401, 2217, 225, 249, 2169],
            [1306, 1402, 2218, 226, 250, 2170],
            [1307, 1403, 2219, 227, 251, 2171],
            [1308, 1404, 2220, 228, 252, 2172],
            [1309, 1405, 2221, 229, 253, 2173],
            [1310, 1406, 2222, 230, 254, 2174],
            [1311, 1407, 2223, 231, 255, 2175],
            [1312, 1408, 2224, 232, 256, 2176],
            [1313, 1409, 2225, 233, 257, 2177],
            [1314, 1410, 2226, 218, 242, 2178],
            [1315, 1411, 2227, 219, 243, 2179],
            [1316, 1412, 2228, 220, 244, 2180],
            [1317, 1413, 2229, 221, 245, 2181],
            [1318, 1414, 2230, 222, 246, 2182],
            [1319, 1415, 2231, 223, 247, 2183],
            [1320, 1416, 2232, 224, 248, 2184],
            [1321, 1417, 2233, 225, 249, 2185],
            [1322, 1418, 2234, 226, 250, 2186],
            [1323, 1419, 2235, 227, 251, 2187],
            [1324, 1420, 2236, 228, 252, 2188],
            [1325, 1421, 2237, 229, 253, 2189],
            [1326, 1422, 2238, 230, 254, 2190],
            [1327, 1423, 2239, 231, 255, 2191],
            [1328, 1424, 2240, 232, 256, 2192],
            [1329, 1425, 2241, 233, 257, 2193],
            [1330, 1426, 2242, 234, 258, 2194],
            [1331, 1427, 2243, 235, 259, 2195],
            [1332, 1428, 2244, 236, 260, 2196],
            [1333, 1429, 2245, 237, 261, 2197],
            [1334, 1430, 2246, 238, 262, 2198],
            [1335, 1431, 2247, 239, 263, 2199],
            [1336, 1432, 2248, 240, 264, 2200],
            [1337, 1433, 2249, 241, 265, 2201],
            [1338, 1434, 2250, 234, 258, 2202],
            [1339, 1435, 2251, 235, 259, 2203],
            [1340, 1436, 2252, 236, 260, 2204],
            [1341, 1437, 2253, 237, 261, 2205],
            [1342, 1438, 2254, 238, 262, 2206],
            [1343, 1439, 2255, 239, 263, 2207],
            [1344, 1440, 2256, 240, 264, 2208],
            [1345, 1441, 2257, 241, 265, 2209],
            [1346, 1442, 2258, 242, 266, 2210],
            [1347, 1443, 2259, 243, 267, 2211],
            [1348, 1444, 2260, 244, 268, 2212],
            [1349, 1445, 2261, 245, 269, 2213],
            [1350, 1446, 2262, 246, 270, 2214],
            [1351, 1447, 2263, 247, 271, 2215],
            [1352, 1448, 2264, 248, 272, 2216],
            [1353, 1449, 2265, 249, 273, 2217],
            [1354, 1450, 2266, 250, 274, 2218],
            [1355, 1451, 2267, 251, 275, 2219],
            [1356, 1452, 2268, 252, 276, 2220],
            [1357, 1453, 2269, 253, 277, 2221],
            [1358, 1454, 2270, 254, 278, 2222],
            [1359, 1455, 2271, 255, 279, 2223],
            [1360, 1456, 2272, 256, 280, 2224],
            [1361, 1457, 2273, 257, 281, 2225],
            [1362, 1458, 2274, 242, 266, 2226],
            [1363, 1459, 2275, 243, 267, 2227],
            [1364, 1460, 2276, 244, 268, 2228],
            [1365, 1461, 2277, 245, 269, 2229],
            [1366, 1462, 2278, 246, 270, 2230],
            [1367, 1463, 2279, 247, 271, 2231],
            [1368, 1464, 2280, 248, 272, 2232],
            [1369, 1465, 2281, 249, 273, 2233],
            [1370, 1466, 2282, 250, 274, 2234],
            [1371, 1467, 2283, 251, 275, 2235],
            [1372, 1468, 2284, 252, 276, 2236],
            [1373, 1469, 2285, 253, 277, 2237],
            [1374, 1470, 2286, 254, 278, 2238],
            [1375, 1471, 2287, 255, 279, 2239],
            [1376, 1472, 2288, 256, 280, 2240],
            [1377, 1473, 2289, 257, 281, 2241],
            [1378, 1474, 2290, 258, 282, 2242],
            [1379, 1475, 2291, 259, 283, 2243],
            [1380, 1476, 2292, 260, 284, 2244],
            [1381, 1477, 2293, 261, 285, 2245],
            [1382, 1478, 2294, 262, 286, 2246],
            [1383, 1479, 2295, 263, 287, 2247],
            [1384, 1480, 2296, 264, 288, 2248],
            [1385, 1481, 2297, 265, 289, 2249],
            [1386, 1482, 2298, 258, 282, 2250],
            [1387, 1483, 2299, 259, 283, 2251],
            [1388, 1484, 2300, 260, 284, 2252],
            [1389, 1485, 2301, 261, 285, 2253],
            [1390, 1486, 2302, 262, 286, 2254],
            [1391, 1487, 2303, 263, 287, 2255],
            [1392, 1488, 2304, 264, 288, 2256],
            [1393, 1489, 2305, 265, 289, 2257],
            [1394, 1490, 2306, 266, 290, 2258],
            [1395, 1491, 2307, 267, 291, 2259],
            [1396, 1492, 2308, 268, 292, 2260],
            [1397, 1493, 2309, 269, 293, 2261],
            [1398, 1494, 2310, 270, 294, 2262],
            [1399, 1495, 2311, 271, 295, 2263],
            [1400, 1496, 2312, 272, 296, 2264],
            [1401, 1497, 2313, 273, 297, 2265],
            [1402, 1498, 2314, 274, 298, 2266],
            [1403, 1499, 2315, 275, 299, 2267],
            [1404, 1500, 2316, 276, 300, 2268],
            [1405, 1501, 2317, 277, 301, 2269],
            [1406, 1502, 2318, 278, 302, 2270],
            [1407, 1503, 2319, 279, 303, 2271],
            [1408, 1504, 2320, 280, 304, 2272],
            [1409, 1505, 2321, 281, 305, 2273],
            [1410, 1506, 2322, 266, 290, 2274],
            [1411, 1507, 2323, 267, 291, 2275],
            [1412, 1508, 2324, 268, 292, 2276],
            [1413, 1509, 2325, 269, 293, 2277],
            [1414, 1510, 2326, 270, 294, 2278],
            [1415, 1511, 2327, 271, 295, 2279],
            [1416, 1512, 2328, 272, 296, 2280],
            [1417, 1513, 2329, 273, 297, 2281],
            [1418, 1514, 2330, 274, 298, 2282],
            [1419, 1515, 2331, 275, 299, 2283],
            [1420, 1516, 2332, 276, 300, 2284],
            [1421, 1517, 2333, 277, 301, 2285],
            [1422, 1518, 2334, 278, 302, 2286],
            [1423, 1519, 2335, 279, 303, 2287],
            [1424, 1520, 2336, 280, 304, 2288],
            [1425, 1521, 2337, 281, 305, 2289],
            [1426, 1522, 2338, 282, 306, 2290],
            [1427, 1523, 2339, 283, 307, 2291],
            [1428, 1524, 2340, 284, 308, 2292],
            [1429, 1525, 2341, 285, 309, 2293],
            [1430, 1526, 2342, 286, 310, 2294],
            [1431, 1527, 2343, 287, 311, 2295],
            [1432, 1528, 2344, 288, 312, 2296],
            [1433, 1529, 2345, 289, 313, 2297],
            [1434, 1530, 2346, 282, 306, 2298],
            [1435, 1531, 2347, 283, 307, 2299],
            [1436, 1532, 2348, 284, 308, 2300],
            [1437, 1533, 2349, 285, 309, 2301],
            [1438, 1534, 2350, 286, 310, 2302],
            [1439, 1535, 2351, 287, 311, 2303],
            [1440, 1536, 2352, 288, 312, 2304],
            [1441, 1537, 2353, 289, 313, 2305],
            [1442, 1538, 2354, 290, 314, 2306],
            [1443, 1539, 2355, 291, 315, 2307],
            [1444, 1540, 2356, 292, 316, 2308],
            [1445, 1541, 2357, 293, 317, 2309],
            [1446, 1542, 2358, 294, 318, 2310],
            [1447, 1543, 2359, 295, 319, 2311],
            [1448, 1544, 2360, 296, 320, 2312],
            [1449, 1545, 2361, 297, 321, 2313],
            [1450, 1546, 2362, 298, 322, 2314],
            [1451, 1547, 2363, 299, 323, 2315],
            [1452, 1548, 2364, 300, 324, 2316],
            [1453, 1549, 2365, 301, 325, 2317],
            [1454, 1550, 2366, 302, 326, 2318],
            [1455, 1551, 2367, 303, 327, 2319],
            [1456, 1552, 2368, 304, 328, 2320],
            [1457, 1553, 2369, 305, 329, 2321],
            [1458, 1554, 2370, 290, 314, 2322],
            [1459, 1555, 2371, 291, 315, 2323],
            [1460, 1556, 2372, 292, 316, 2324],
            [1461, 1557, 2373, 293, 317, 2325],
            [1462, 1558, 2374, 294, 318, 2326],
            [1463, 1559, 2375, 295, 319, 2327],
            [1464, 1560, 2376, 296, 320, 2328],
            [1465, 1561, 2377, 297, 321, 2329],
            [1466, 1562, 2378, 298, 322, 2330],
            [1467, 1563, 2379, 299, 323, 2331],
            [1468, 1564, 2380, 300, 324, 2332],
            [1469, 1565, 2381, 301, 325, 2333],
            [1470, 1566, 2382, 302, 326, 2334],
            [1471, 1567, 2383, 303, 327, 2335],
            [1472, 1568, 2384, 304, 328, 2336],
            [1473, 1569, 2385, 305, 329, 2337],
            [1474, 1570, 2386, 306, 330, 2338],
            [1475, 1571, 2387, 307, 331, 2339],
            [1476, 1572, 2388, 308, 332, 2340],
            [1477, 1573, 2389, 309, 333, 2341],
            [1478, 1574, 2390, 310, 334, 2342],
            [1479, 1575, 2391, 311, 335, 2343],
            [1480, 1576, 2392, 312, 336, 2344],
            [1481, 1577, 2393, 313, 337, 2345],
            [1482, 1578, 2394, 306, 330, 2346],
            [1483, 1579, 2395, 307, 331, 2347],
            [1484, 1580, 2396, 308, 332, 2348],
            [1485, 1581, 2397, 309, 333, 2349],
            [1486, 1582, 2398, 310, 334, 2350],
            [1487, 1583, 2399, 311, 335, 2351],
            [1488, 1584, 2400, 312, 336, 2352],
            [1489, 1585, 2401, 313, 337, 2353],
            [1490, 1586, 2402, 314, 338, 2354],
            [1491, 1587, 2403, 315, 339, 2355],
            [1492, 1588, 2404, 316, 340, 2356],
            [1493, 1589, 2405, 317, 341, 2357],
            [1494, 1590, 2406, 318, 342, 2358],
            [1495, 1591, 2407, 319, 343, 2359],
            [1496, 1592, 2408, 320, 344, 2360],
            [1497, 1593, 2409, 321, 345, 2361],
            [1498, 1594, 2410, 322, 346, 2362],
            [1499, 1595, 2411, 323, 347, 2363],
            [1500, 1596, 2412, 324, 348, 2364],
            [1501, 1597, 2413, 325, 349, 2365],
            [1502, 1598, 2414, 326, 350, 2366],
            [1503, 1599, 2415, 327, 351, 2367],
            [1504, 1600, 2416, 328, 352, 2368],
            [1505, 1601, 2417, 329, 353, 2369],
            [1506, 1602, 2418, 314, 338, 2370],
            [1507, 1603, 2419, 315, 339, 2371],
            [1508, 1604, 2420, 316, 340, 2372],
            [1509, 1605, 2421, 317, 341, 2373],
            [1510, 1606, 2422, 318, 342, 2374],
            [1511, 1607, 2423, 319, 343, 2375],
            [1512, 1608, 2424, 320, 344, 2376],
            [1513, 1609, 2425, 321, 345, 2377],
            [1514, 1610, 2426, 322, 346, 2378],
            [1515, 1611, 2427, 323, 347, 2379],
            [1516, 1612, 2428, 324, 348, 2380],
            [1517, 1613, 2429, 325, 349, 2381],
            [1518, 1614, 2430, 326, 350, 2382],
            [1519, 1615, 2431, 327, 351, 2383],
            [1520, 1616, 2432, 328, 352, 2384],
            [1521, 1617, 2433, 329, 353, 2385],
            [1522, 1618, 2434, 330, 354, 2386],
            [1523, 1619, 2435, 331, 355, 2387],
            [1524, 1620, 2436, 332, 356, 2388],
            [1525, 1621, 2437, 333, 357, 2389],
            [1526, 1622, 2438, 334, 358, 2390],
            [1527, 1623, 2439, 335, 359, 2391],
            [1528, 1624, 2440, 336, 360, 2392],
            [1529, 1625, 2441, 337, 361, 2393],
            [1530, 1626, 2442, 330, 354, 2394],
            [1531, 1627, 2443, 331, 355, 2395],
            [1532, 1628, 2444, 332, 356, 2396],
            [1533, 1629, 2445, 333, 357, 2397],
            [1534, 1630, 2446, 334, 358, 2398],
            [1535, 1631, 2447, 335, 359, 2399],
            [1536, 1632, 2448, 336, 360, 2400],
            [1537, 1633, 2449, 337, 361, 2401],
            [1538, 1634, 2450, 338, 362, 2402],
            [1539, 1635, 2451, 339, 363, 2403],
            [1540, 1636, 2452, 340, 364, 2404],
            [1541, 1637, 2453, 341, 365, 2405],
            [1542, 1638, 2454, 342, 366, 2406],
            [1543, 1639, 2455, 343, 367, 2407],
            [1544, 1640, 2456, 344, 368, 2408],
            [1545, 1641, 2457, 345, 369, 2409],
            [1546, 1642, 2458, 346, 370, 2410],
            [1547, 1643, 2459, 347, 371, 2411],
            [1548, 1644, 2460, 348, 372, 2412],
            [1549, 1645, 2461, 349, 373, 2413],
            [1550, 1646, 2462, 350, 374, 2414],
            [1551, 1647, 2463, 351, 375, 2415],
            [1552, 1648, 2464, 352, 376, 2416],
            [1553, 1649, 2465, 353, 377, 2417],
            [1554, 1650, 2466, 338, 362, 2418],
            [1555, 1651, 2467, 339, 363, 2419],
            [1556, 1652, 2468, 340, 364, 2420],
            [1557, 1653, 2469, 341, 365, 2421],
            [1558, 1654, 2470, 342, 366, 2422],
            [1559, 1655, 2471, 343, 367, 2423],
            [1560, 1656, 2472, 344, 368, 2424],
            [1561, 1657, 2473, 345, 369, 2425],
            [1562, 1658, 2474, 346, 370, 2426],
            [1563, 1659, 2475, 347, 371, 2427],
            [1564, 1660, 2476, 348, 372, 2428],
            [1565, 1661, 2477, 349, 373, 2429],
            [1566, 1662, 2478, 350, 374, 2430],
            [1567, 1663, 2479, 351, 375, 2431],
            [1568, 1664, 2480, 352, 376, 2432],
            [1569, 1665, 2481, 353, 377, 2433],
            [1570, 1666, 2482, 354, 378, 2434],
            [1571, 1667, 2483, 355, 379, 2435],
            [1572, 1668, 2484, 356, 380, 2436],
            [1573, 1669, 2485, 357, 381, 2437],
            [1574, 1670, 2486, 358, 382, 2438],
            [1575, 1671, 2487, 359, 383, 2439],
            [1576, 1672, 2488, 360, 384, 2440],
            [1577, 1673, 2489, 361, 385, 2441],
            [1578, 1674, 2490, 354, 378, 2442],
            [1579, 1675, 2491, 355, 379, 2443],
            [1580, 1676, 2492, 356, 380, 2444],
            [1581, 1677, 2493, 357, 381, 2445],
            [1582, 1678, 2494, 358, 382, 2446],
            [1583, 1679, 2495, 359, 383, 2447],
            [1584, 1680, 2496, 360, 384, 2448],
            [1585, 1681, 2497, 361, 385, 2449],
            [1586, 1682, 2498, 362, 386, 2450],
            [1587, 1683, 2499, 363, 387, 2451],
            [1588, 1684, 2500, 364, 388, 2452],
            [1589, 1685, 2501, 365, 389, 2453],
            [1590, 1686, 2502, 366, 390, 2454],
            [1591, 1687, 2503, 367, 391, 2455],
            [1592, 1688, 2504, 368, 392, 2456],
            [1593, 1689, 2505, 369, 393, 2457],
            [1594, 1690, 2506, 370, 394, 2458],
            [1595, 1691, 2507, 371, 395, 2459],
            [1596, 1692, 2508, 372, 396, 2460],
            [1597, 1693, 2509, 373, 397, 2461],
            [1598, 1694, 2510, 374, 398, 2462],
            [1599, 1695, 2511, 375, 399, 2463],
            [1600, 1696, 2512, 376, 400, 2464],
            [1601, 1697, 2513, 377, 401, 2465],
            [1602, 1698, 2514, 362, 386, 2466],
            [1603, 1699, 2515, 363, 387, 2467],
            [1604, 1700, 2516, 364, 388, 2468],
            [1605, 1701, 2517, 365, 389, 2469],
            [1606, 1702, 2518, 366, 390, 2470],
            [1607, 1703, 2519, 367, 391, 2471],
            [1608, 1704, 2520, 368, 392, 2472],
            [1609, 1705, 2521, 369, 393, 2473],
            [1610, 1706, 2522, 370, 394, 2474],
            [1611, 1707, 2523, 371, 395, 2475],
            [1612, 1708, 2524, 372, 396, 2476],
            [1613, 1709, 2525, 373, 397, 2477],
            [1614, 1710, 2526, 374, 398, 2478],
            [1615, 1711, 2527, 375, 399, 2479],
            [1616, 1712, 2528, 376, 400, 2480],
            [1617, 1713, 2529, 377, 401, 2481],
            [1618, 1714, 2530, 378, 402, 2482],
            [1619, 1715, 2531, 379, 403, 2483],
            [1620, 1716, 2532, 380, 404, 2484],
            [1621, 1717, 2533, 381, 405, 2485],
            [1622, 1718, 2534, 382, 406, 2486],
            [1623, 1719, 2535, 383, 407, 2487],
            [1624, 1720, 2536, 384, 408, 2488],
            [1625, 1721, 2537, 385, 409, 2489],
            [1626, 1722, 2538, 378, 402, 2490],
            [1627, 1723, 2539, 379, 403, 2491],
            [1628, 1724, 2540, 380, 404, 2492],
            [1629, 1725, 2541, 381, 405, 2493],
            [1630, 1726, 2542, 382, 406, 2494],
            [1631, 1727, 2543, 383, 407, 2495],
            [1632, 1728, 2544, 384, 408, 2496],
            [1633, 1729, 2545, 385, 409, 2497],
            [1634, 1730, 2546, 386, 410, 2498],
            [1635, 1731, 2547, 387, 411, 2499],
            [1636, 1732, 2548, 388, 412, 2500],
            [1637, 1733, 2549, 389, 413, 2501],
            [1638, 1734, 2550, 390, 414, 2502],
            [1639, 1735, 2551, 391, 415, 2503],
            [1640, 1736, 2552, 392, 416, 2504],
            [1641, 1737, 2553, 393, 417, 2505],
            [1642, 1738, 2554, 394, 418, 2506],
            [1643, 1739, 2555, 395, 419, 2507],
            [1644, 1740, 2556, 396, 420, 2508],
            [1645, 1741, 2557, 397, 421, 2509],
            [1646, 1742, 2558, 398, 422, 2510],
            [1647, 1743, 2559, 399, 423, 2511],
            [1648, 1744, 2560, 400, 424, 2512],
            [1649, 1745, 2561, 401, 425, 2513],
            [1650, 1746, 2562, 386, 410, 2514],
            [1651, 1747, 2563, 387, 411, 2515],
            [1652, 1748, 2564, 388, 412, 2516],
            [1653, 1749, 2565, 389, 413, 2517],
            [1654, 1750, 2566, 390, 414, 2518],
            [1655, 1751, 2567, 391, 415, 2519],
            [1656, 1752, 2568, 392, 416, 2520],
            [1657, 1753, 2569, 393, 417, 2521],
            [1658, 1754, 2570, 394, 418, 2522],
            [1659, 1755, 2571, 395, 419, 2523],
            [1660, 1756, 2572, 396, 420, 2524],
            [1661, 1757, 2573, 397, 421, 2525],
            [1662, 1758, 2574, 398, 422, 2526],
            [1663, 1759, 2575, 399, 423, 2527],
            [1664, 1760, 2576, 400, 424, 2528],
            [1665, 1761, 2577, 401, 425, 2529],
            [1666, 1762, 2578, 402, 426, 2530],
            [1667, 1763, 2579, 403, 427, 2531],
            [1668, 1764, 2580, 404, 428, 2532],
            [1669, 1765, 2581, 405, 429, 2533],
            [1670, 1766, 2582, 406, 430, 2534],
            [1671, 1767, 2583, 407, 431, 2535],
            [1672, 1768, 2584, 408, 432, 2536],
            [1673, 1769, 2585, 409, 433, 2537],
            [1674, 1770, 2586, 402, 426, 2538],
            [1675, 1771, 2587, 403, 427, 2539],
            [1676, 1772, 2588, 404, 428, 2540],
            [1677, 1773, 2589, 405, 429, 2541],
            [1678, 1774, 2590, 406, 430, 2542],
            [1679, 1775, 2591, 407, 431, 2543],
            [1680, 1776, 2592, 408, 432, 2544],
            [1681, 1777, 2593, 409, 433, 2545],
            [1682, 1778, 2594, 410, 434, 2546],
            [1683, 1779, 2595, 411, 435, 2547],
            [1684, 1780, 2596, 412, 436, 2548],
            [1685, 1781, 2597, 413, 437, 2549],
            [1686, 1782, 2598, 414, 438, 2550],
            [1687, 1783, 2599, 415, 439, 2551],
            [1688, 1784, 2600, 416, 440, 2552],
            [1689, 1785, 2601, 417, 441, 2553],
            [1690, 1786, 2602, 418, 442, 2554],
            [1691, 1787, 2603, 419, 443, 2555],
            [1692, 1788, 2604, 420, 444, 2556],
            [1693, 1789, 2605, 421, 445, 2557],
            [1694, 1790, 2606, 422, 446, 2558],
            [1695, 1791, 2607, 423, 447, 2559],
            [1696, 1792, 2608, 424, 448, 2560],
            [1697, 1793, 2609, 425, 449, 2561],
            [1698, 1794, 2610, 410, 434, 2562],
            [1699, 1795, 2611, 411, 435, 2563],
            [1700, 1796, 2612, 412, 436, 2564],
            [1701, 1797, 2613, 413, 437, 2565],
            [1702, 1798, 2614, 414, 438, 2566],
            [1703, 1799, 2615, 415, 439, 2567],
            [1704, 1800, 2616, 416, 440, 2568],
            [1705, 1801, 2617, 417, 441, 2569],
            [1706, 1802, 2618, 418, 442, 2570],
            [1707, 1803, 2619, 419, 443, 2571],
            [1708, 1804, 2620, 420, 444, 2572],
            [1709, 1805, 2621, 421, 445, 2573],
            [1710, 1806, 2622, 422, 446, 2574],
            [1711, 1807, 2623, 423, 447, 2575],
            [1712, 1808, 2624, 424, 448, 2576],
            [1713, 1809, 2625, 425, 449, 2577],
            [1714, 1810, 2626, 426, 450, 2578],
            [1715, 1811, 2627, 427, 451, 2579],
            [1716, 1812, 2628, 428, 452, 2580],
            [1717, 1813, 2629, 429, 453, 2581],
            [1718, 1814, 2630, 430, 454, 2582],
            [1719, 1815, 2631, 431, 455, 2583],
            [1720, 1816, 2632, 432, 456, 2584],
            [1721, 1817, 2633, 433, 457, 2585],
            [1722, 1818, 2634, 426, 450, 2586],
            [1723, 1819, 2635, 427, 451, 2587],
            [1724, 1820, 2636, 428, 452, 2588],
            [1725, 1821, 2637, 429, 453, 2589],
            [1726, 1822, 2638, 430, 454, 2590],
            [1727, 1823, 2639, 431, 455, 2591],
            [1728, 1824, 2640, 432, 456, 2592],
            [1729, 1825, 2641, 433, 457, 2593],
            [1730, 1826, 2642, 434, 458, 2594],
            [1731, 1827, 2643, 435, 459, 2595],
            [1732, 1828, 2644, 436, 460, 2596],
            [1733, 1829, 2645, 437, 461, 2597],
            [1734, 1830, 2646, 438, 462, 2598],
            [1735, 1831, 2647, 439, 463, 2599],
            [1736, 1832, 2648, 440, 464, 2600],
            [1737, 1833, 2649, 441, 465, 2601],
            [1738, 1834, 2650, 442, 466, 2602],
            [1739, 1835, 2651, 443, 467, 2603],
            [1740, 1836, 2652, 444, 468, 2604],
            [1741, 1837, 2653, 445, 469, 2605],
            [1742, 1838, 2654, 446, 470, 2606],
            [1743, 1839, 2655, 447, 471, 2607],
            [1744, 1840, 2656, 448, 472, 2608],
            [1745, 1841, 2657, 449, 473, 2609],
            [1746, 1842, 2658, 434, 458, 2610],
            [1747, 1843, 2659, 435, 459, 2611],
            [1748, 1844, 2660, 436, 460, 2612],
            [1749, 1845, 2661, 437, 461, 2613],
            [1750, 1846, 2662, 438, 462, 2614],
            [1751, 1847, 2663, 439, 463, 2615],
            [1752, 1848, 2664, 440, 464, 2616],
            [1753, 1849, 2665, 441, 465, 2617],
            [1754, 1850, 2666, 442, 466, 2618],
            [1755, 1851, 2667, 443, 467, 2619],
            [1756, 1852, 2668, 444, 468, 2620],
            [1757, 1853, 2669, 445, 469, 2621],
            [1758, 1854, 2670, 446, 470, 2622],
            [1759, 1855, 2671, 447, 471, 2623],
            [1760, 1856, 2672, 448, 472, 2624],
            [1761, 1857, 2673, 449, 473, 2625],
            [1762, 1858, 2674, 450, 474, 2626],
            [1763, 1859, 2675, 451, 475, 2627],
            [1764, 1860, 2676, 452, 476, 2628],
            [1765, 1861, 2677, 453, 477, 2629],
            [1766, 1862, 2678, 454, 478, 2630],
            [1767, 1863, 2679, 455, 479, 2631],
            [1768, 1864, 2680, 456, 480, 2632],
            [1769, 1865, 2681, 457, 481, 2633],
            [1770, 1866, 2682, 450, 474, 2634],
            [1771, 1867, 2683, 451, 475, 2635],
            [1772, 1868, 2684, 452, 476, 2636],
            [1773, 1869, 2685, 453, 477, 2637],
            [1774, 1870, 2686, 454, 478, 2638],
            [1775, 1871, 2687, 455, 479, 2639],
            [1776, 1872, 2688, 456, 480, 2640],
            [1777, 1873, 2689, 457, 481, 2641],
            [1778, 1874, 2690, 458, 482, 2642],
            [1779, 1875, 2691, 459, 483, 2643],
            [1780, 1876, 2692, 460, 484, 2644],
            [1781, 1877, 2693, 461, 485, 2645],
            [1782, 1878, 2694, 462, 486, 2646],
            [1783, 1879, 2695, 463, 487, 2647],
            [1784, 1880, 2696, 464, 488, 2648],
            [1785, 1881, 2697, 465, 489, 2649],
            [1786, 1882, 2698, 466, 490, 2650],
            [1787, 1883, 2699, 467, 491, 2651],
            [1788, 1884, 2700, 468, 492, 2652],
            [1789, 1885, 2701, 469, 493, 2653],
            [1790, 1886, 2702, 470, 494, 2654],
            [1791, 1887, 2703, 471, 495, 2655],
            [1792, 1888, 2704, 472, 496, 2656],
            [1793, 1889, 2705, 473, 497, 2657],
            [1794, 1890, 2706, 458, 482, 2658],
            [1795, 1891, 2707, 459, 483, 2659],
            [1796, 1892, 2708, 460, 484, 2660],
            [1797, 1893, 2709, 461, 485, 2661],
            [1798, 1894, 2710, 462, 486, 2662],
            [1799, 1895, 2711, 463, 487, 2663],
            [1800, 1896, 2712, 464, 488, 2664],
            [1801, 1897, 2713, 465, 489, 2665],
            [1802, 1898, 2714, 466, 490, 2666],
            [1803, 1899, 2715, 467, 491, 2667],
            [1804, 1900, 2716, 468, 492, 2668],
            [1805, 1901, 2717, 469, 493, 2669],
            [1806, 1902, 2718, 470, 494, 2670],
            [1807, 1903, 2719, 471, 495, 2671],
            [1808, 1904, 2720, 472, 496, 2672],
            [1809, 1905, 2721, 473, 497, 2673],
            [1810, 1906, 2722, 474, 498, 2674],
            [1811, 1907, 2723, 475, 499, 2675],
            [1812, 1908, 2724, 476, 500, 2676],
            [1813, 1909, 2725, 477, 501, 2677],
            [1814, 1910, 2726, 478, 502, 2678],
            [1815, 1911, 2727, 479, 503, 2679],
            [1816, 1912, 2728, 480, 504, 2680],
            [1817, 1913, 2729, 481, 505, 2681],
            [1818, 1914, 2730, 474, 498, 2682],
            [1819, 1915, 2731, 475, 499, 2683],
            [1820, 1916, 2732, 476, 500, 2684],
            [1821, 1917, 2733, 477, 501, 2685],
            [1822, 1918, 2734, 478, 502, 2686],
            [1823, 1919, 2735, 479, 503, 2687],
            [1824, 1920, 2736, 480, 504, 2688],
            [1825, 1921, 2737, 481, 505, 2689],
            [1826, 538, 562, 482, 506, 2690],
            [1827, 539, 563, 483, 507, 2691],
            [1828, 540, 564, 484, 508, 2692],
            [1829, 541, 565, 485, 509, 2693],
            [1830, 542, 566, 486, 510, 2694],
            [1831, 543, 567, 487, 511, 2695],
            [1832, 544, 568, 488, 512, 2696],
            [1833, 545, 569, 489, 513, 2697],
            [1834, 530, 554, 490, 514, 2698],
            [1835, 531, 555, 491, 515, 2699],
            [1836, 532, 556, 492, 516, 2700],
            [1837, 533, 557, 493, 517, 2701],
            [1838, 534, 558, 494, 518, 2702],
            [1839, 535, 559, 495, 519, 2703],
            [1840, 536, 560, 496, 520, 2704],
            [1841, 537, 561, 497, 521, 2705],
            [1842, 546, 570, 482, 506, 2706],
            [1843, 547, 571, 483, 507, 2707],
            [1844, 548, 572, 484, 508, 2708],
            [1845, 549, 573, 485, 509, 2709],
            [1846, 550, 574, 486, 510, 2710],
            [1847, 551, 575, 487, 511, 2711],
            [1848, 552, 576, 488, 512, 2712],
            [1849, 553, 577, 489, 513, 2713],
            [1850, 546, 570, 490, 514, 2714],
            [1851, 547, 571, 491, 515, 2715],
            [1852, 548, 572, 492, 516, 2716],
            [1853, 549, 573, 493, 517, 2717],
            [1854, 550, 574, 494, 518, 2718],
            [1855, 551, 575, 495, 519, 2719],
            [1856, 552, 576, 496, 520, 2720],
            [1857, 553, 577, 497, 521, 2721],
            [1858, 530, 554, 498, 522, 2722],
            [1859, 531, 555, 499, 523, 2723],
            [1860, 532, 556, 500, 524, 2724],
            [1861, 533, 557, 501, 525, 2725],
            [1862, 534, 558, 502, 526, 2726],
            [1863, 535, 559, 503, 527, 2727],
            [1864, 536, 560, 504, 528, 2728],
            [1865, 537, 561, 505, 529, 2729],
            [1866, 538, 562, 498, 522, 2730],
            [1867, 539, 563, 499, 523, 2731],
            [1868, 540, 564, 500, 524, 2732],
            [1869, 541, 565, 501, 525, 2733],
            [1870, 542, 566, 502, 526, 2734],
            [1871, 543, 567, 503, 527, 2735],
            [1872, 544, 568, 504, 528, 2736],
            [1873, 545, 569, 505, 529, 2737],
            [802, 1058, 1970, 826, 1924, 1106],
            [803, 1059, 1971, 827, 1925, 1107],
            [802, 1060, 1972, 826, 1922, 1108],
            [803, 1061, 1973, 827, 1923, 1109],
            [804, 1062, 1974, 828, 1928, 1110],
            [805, 1063, 1975, 829, 1929, 1111],
            [804, 1064, 1976, 828, 1926, 1112],
            [805, 1065, 1977, 829, 1927, 1113],
            [794, 1066, 1978, 818, 1934, 1114],
            [795, 1067, 1979, 819, 1935, 1115],
            [796, 1068, 1980, 820, 1936, 1116],
            [797, 1069, 1981, 821, 1937, 1117],
            [794, 1070, 1982, 818, 1930, 1118],
            [795, 1071, 1983, 819, 1931, 1119],
            [796, 1072, 1984, 820, 1932, 1120],
            [797, 1073, 1985, 821, 1933, 1121],
            [810, 1074, 1986, 834, 1939, 1122],
            [810, 1075, 1987, 834, 1938, 1123],
            [811, 1076, 1988, 835, 1941, 1124],
            [811, 1077, 1989, 835, 1940, 1125],
            [812, 1078, 1990, 836, 1943, 1126],
            [812, 1079, 1991, 836, 1942, 1127],
            [813, 1080, 1992, 837, 1945, 1128],
            [813, 1081, 1993, 837, 1944, 1129],
            [814, 1082, 1994, 838, 1947, 1130],
            [814, 1083, 1995, 838, 1946, 1131],
            [815, 1084, 1996, 839, 1949, 1132],
            [815, 1085, 1997, 839, 1948, 1133],
            [816, 1086, 1998, 840, 1951, 1134],
            [816, 1087, 1999, 840, 1950, 1135],
            [817, 1088, 2000, 841, 1953, 1136],
            [817, 1089, 2001, 841, 1952, 1137],
            [798, 1090, 2002, 822, 1958, 1138],
            [799, 1091, 2003, 823, 1959, 1139],
            [800, 1092, 2004, 824, 1960, 1140],
            [801, 1093, 2005, 825, 1961, 1141],
            [798, 1094, 2006, 822, 1954, 1142],
            [799, 1095, 2007, 823, 1955, 1143],
            [800, 1096, 2008, 824, 1956, 1144],
            [801, 1097, 2009, 825, 1957, 1145],
            [806, 1098, 2010, 830, 1964, 1146],
            [807, 1099, 2011, 831, 1965, 1147],
            [806, 1100, 2012, 830, 1962, 1148],
            [807, 1101, 2013, 831, 1963, 1149],
            [808, 1102, 2014, 832, 1968, 1150],
            [809, 1103, 2015, 833, 1969, 1151],
            [808, 1104, 2016, 832, 1966, 1152],
            [809, 1105, 2017, 833, 1967, 1153],
            [1922, 2018, 1106, 2738, 826, 1154],
            [1923, 2019, 1107, 2739, 827, 1155],
            [1924, 2020, 1108, 2740, 826, 1156],
            [1925, 2021, 1109, 2741, 827, 1157],
            [1926, 2022, 1110, 2742, 828, 1158],
            [1927, 2023, 1111, 2743, 829, 1159],
            [1928, 2024, 1112, 2744, 828, 1160],
            [1929, 2025, 1113, 2745, 829, 1161],
            [1930, 2026, 1114, 2746, 818, 1162],
            [1931, 2027, 1115, 2747, 819, 1163],
            [1932, 2028, 1116, 2748, 820, 1164],
            [1933, 2029, 1117, 2749, 821, 1165],
            [1934, 2030, 1118, 2750, 818, 1166],
            [1935, 2031, 1119, 2751, 819, 1167],
            [1936, 2032, 1120, 2752, 820, 1168],
            [1937, 2033, 1121, 2753, 821, 1169],
            [1938, 2034, 1122, 2754, 834, 1170],
            [1939, 2035, 1123, 2755, 834, 1171],
            [1940, 2036, 1124, 2756, 835, 1172],
            [1941, 2037, 1125, 2757, 835, 1173],
            [1942, 2038, 1126, 2758, 836, 1174],
            [1943, 2039, 1127, 2759, 836, 1175],
            [1944, 2040, 1128, 2760, 837, 1176],
            [1945, 2041, 1129, 2761, 837, 1177],
            [1946, 2042, 1130, 2762, 838, 1178],
            [1947, 2043, 1131, 2763, 838, 1179],
            [1948, 2044, 1132, 2764, 839, 1180],
            [1949, 2045, 1133, 2765, 839, 1181],
            [1950, 2046, 1134, 2766, 840, 1182],
            [1951, 2047, 1135, 2767, 840, 1183],
            [1952, 2048, 1136, 2768, 841, 1184],
            [1953, 2049, 1137, 2769, 841, 1185],
            [1954, 2050, 1138, 2770, 822, 1186],
            [1955, 2051, 1139, 2771, 823, 1187],
            [1956, 2052, 1140, 2772, 824, 1188],
            [1957, 2053, 1141, 2773, 825, 1189],
            [1958, 2054, 1142, 2774, 822, 1190],
            [1959, 2055, 1143, 2775, 823, 1191],
            [1960, 2056, 1144, 2776, 824, 1192],
            [1961, 2057, 1145, 2777, 825, 1193],
            [1962, 2058, 1146, 2778, 830, 1194],
            [1963, 2059, 1147, 2779, 831, 1195],
            [1964, 2060, 1148, 2780, 830, 1196],
            [1965, 2061, 1149, 2781, 831, 1197],
            [1966, 2062, 1150, 2782, 832, 1198],
            [1967, 2063, 1151, 2783, 833, 1199],
            [1968, 2064, 1152, 2784, 832, 1200],
            [1969, 2065, 1153, 2785, 833, 1201],
            [1970, 2066, 1154, 2786, 2738, 1202],
            [1971, 2067, 1155, 2787, 2739, 1203],
            [1972, 2068, 1156, 2788, 2740, 1204],
            [1973, 2069, 1157, 2789, 2741, 1205],
            [1974, 2070, 1158, 2790, 2742, 1206],
            [1975, 2071, 1159, 2791, 2743, 1207],
            [1976, 2072, 1160, 2792, 2744, 1208],
            [1977, 2073, 1161, 2793, 2745, 1209],
            [1978, 2074, 1162, 2794, 2746, 1210],
            [1979, 2075, 1163, 2795, 2747, 1211],
            [1980, 2076, 1164, 2796, 2748, 1212],
            [1981, 2077, 1165, 2797, 2749, 1213],
            [1982, 2078, 1166, 2798, 2750, 1214],
            [1983, 2079, 1167, 2799, 2751, 1215],
            [1984, 2080, 1168, 2800, 2752, 1216],
            [1985, 2081, 1169, 2801, 2753, 1217],
            [1986, 2082, 1170, 2802, 2754, 1218],
            [1987, 2083, 1171, 2803, 2755, 1219],
            [1988, 2084, 1172, 2804, 2756, 1220],
            [1989, 2085, 1173, 2805, 2757, 1221],
            [1990, 2086, 1174, 2806, 2758, 1222],
            [1991, 2087, 1175, 2807, 2759, 1223],
            [1992, 2088, 1176, 2808, 2760, 1224],
            [1993, 2089, 1177, 2809, 2761, 1225],
            [1994, 2090, 1178, 2810, 2762, 1226],
            [1995, 2091, 1179, 2811, 2763, 1227],
            [1996, 2092, 1180, 2812, 2764, 1228],
            [1997, 2093, 1181, 2813, 2765, 1229],
            [1998, 2094, 1182, 2814, 2766, 1230],
            [1999, 2095, 1183, 2815, 2767, 1231],
            [2000, 2096, 1184, 2816, 2768, 1232],
            [2001, 2097, 1185, 2817, 2769, 1233],
            [2002, 2098, 1186, 2818, 2770, 1234],
            [2003, 2099, 1187, 2819, 2771, 1235],
            [2004, 2100, 1188, 2820, 2772, 1236],
            [2005, 2101, 1189, 2821, 2773, 1237],
            [2006, 2102, 1190, 2822, 2774, 1238],
            [2007, 2103, 1191, 2823, 2775, 1239],
            [2008, 2104, 1192, 2824, 2776, 1240],
            [2009, 2105, 1193, 2825, 2777, 1241],
            [2010, 2106, 1194, 2826, 2778, 1242],
            [2011, 2107, 1195, 2827, 2779, 1243],
            [2012, 2108, 1196, 2828, 2780, 1244],
            [2013, 2109, 1197, 2829, 2781, 1245],
            [2014, 2110, 1198, 2830, 2782, 1246],
            [2015, 2111, 1199, 2831, 2783, 1247],
            [2016, 2112, 1200, 2832, 2784, 1248],
            [2017, 2113, 1201, 2833, 2785, 1249],
            [2018, 2114, 1202, 2834, 1250, 2786],
            [2019, 2115, 1203, 2835, 1251, 2787],
            [2020, 2116, 1204, 2836, 1252, 2788],
            [2021, 2117, 1205, 2837, 1253, 2789],
            [2022, 2118, 1206, 2838, 1254, 2790],
            [2023, 2119, 1207, 2839, 1255, 2791],
            [2024, 2120, 1208, 2840, 1256, 2792],
            [2025, 2121, 1209, 2841, 1257, 2793],
            [2026, 2122, 1210, 2842, 1258, 2794],
            [2027, 2123, 1211, 2843, 1259, 2795],
            [2028, 2124, 1212, 2844, 1260, 2796],
            [2029, 2125, 1213, 2845, 1261, 2797],
            [2030, 2126, 1214, 2846, 1262, 2798],
            [2031, 2127, 1215, 2847, 1263, 2799],
            [2032, 2128, 1216, 2848, 1264, 2800],
            [2033, 2129, 1217, 2849, 1265, 2801],
            [2034, 2130, 1218, 2850, 1266, 2802],
            [2035, 2131, 1219, 2851, 1267, 2803],
            [2036, 2132, 1220, 2852, 1268, 2804],
            [2037, 2133, 1221, 2853, 1269, 2805],
            [2038, 2134, 1222, 2854, 1270, 2806],
            [2039, 2135, 1223, 2855, 1271, 2807],
            [2040, 2136, 1224, 2856, 1272, 2808],
            [2041, 2137, 1225, 2857, 1273, 2809],
            [2042, 2138, 1226, 2858, 1274, 2810],
            [2043, 2139, 1227, 2859, 1275, 2811],
            [2044, 2140, 1228, 2860, 1276, 2812],
            [2045, 2141, 1229, 2861, 1277, 2813],
            [2046, 2142, 1230, 2862, 1278, 2814],
            [2047, 2143, 1231, 2863, 1279, 2815],
            [2048, 2144, 1232, 2864, 1280, 2816],
            [2049, 2145, 1233, 2865, 1281, 2817],
            [2050, 2146, 1234, 2866, 1282, 2818],
            [2051, 2147, 1235, 2867, 1283, 2819],
            [2052, 2148, 1236, 2868, 1284, 2820],
            [2053, 2149, 1237, 2869, 1285, 2821],
            [2054, 2150, 1238, 2870, 1286, 2822],
            [2055, 2151, 1239, 2871, 1287, 2823],
            [2056, 2152, 1240, 2872, 1288, 2824],
            [2057, 2153, 1241, 2873, 1289, 2825],
            [2058, 2154, 1242, 2874, 1290, 2826],
            [2059, 2155, 1243, 2875, 1291, 2827],
            [2060, 2156, 1244, 2876, 1292, 2828],
            [2061, 2157, 1245, 2877, 1293, 2829],
            [2062, 2158, 1246, 2878, 1294, 2830],
            [2063, 2159, 1247, 2879, 1295, 2831],
            [2064, 2160, 1248, 2880, 1296, 2832],
            [2065, 2161, 1249, 2881, 1297, 2833],
            [2066, 2162, 1250, 2882, 1298, 2834],
            [2067, 2163, 1251, 2883, 1299, 2835],
            [2068, 2164, 1252, 2884, 1300, 2836],
            [2069, 2165, 1253, 2885, 1301, 2837],
            [2070, 2166, 1254, 2886, 1302, 2838],
            [2071, 2167, 1255, 2887, 1303, 2839],
            [2072, 2168, 1256, 2888, 1304, 2840],
            [2073, 2169, 1257, 2889, 1305, 2841],
            [2074, 2170, 1258, 2890, 1306, 2842],
            [2075, 2171, 1259, 2891, 1307, 2843],
            [2076, 2172, 1260, 2892, 1308, 2844],
            [2077, 2173, 1261, 2893, 1309, 2845],
            [2078, 2174, 1262, 2894, 1310, 2846],
            [2079, 2175, 1263, 2895, 1311, 2847],
            [2080, 2176, 1264, 2896, 1312, 2848],
            [2081, 2177, 1265, 2897, 1313, 2849],
            [2082, 2178, 1266, 2898, 1314, 2850],
            [2083, 2179, 1267, 2899, 1315, 2851],
            [2084, 2180, 1268, 2900, 1316, 2852],
            [2085, 2181, 1269, 2901, 1317, 2853],
            [2086, 2182, 1270, 2902, 1318, 2854],
            [2087, 2183, 1271, 2903, 1319, 2855],
            [2088, 2184, 1272, 2904, 1320, 2856],
            [2089, 2185, 1273, 2905, 1321, 2857],
            [2090, 2186, 1274, 2906, 1322, 2858],
            [2091, 2187, 1275, 2907, 1323, 2859],
            [2092, 2188, 1276, 2908, 1324, 2860],
            [2093, 2189, 1277, 2909, 1325, 2861],
            [2094, 2190, 1278, 2910, 1326, 2862],
            [2095, 2191, 1279, 2911, 1327, 2863],
            [2096, 2192, 1280, 2912, 1328, 2864],
            [2097, 2193, 1281, 2913, 1329, 2865],
            [2098, 2194, 1282, 2914, 1330, 2866],
            [2099, 2195, 1283, 2915, 1331, 2867],
            [2100, 2196, 1284, 2916, 1332, 2868],
            [2101, 2197, 1285, 2917, 1333, 2869],
            [2102, 2198, 1286, 2918, 1334, 2870],
            [2103, 2199, 1287, 2919, 1335, 2871],
            [2104, 2200, 1288, 2920, 1336, 2872],
            [2105, 2201, 1289, 2921, 1337, 2873],
            [2106, 2202, 1290, 2922, 1338, 2874],
            [2107, 2203, 1291, 2923, 1339, 2875],
            [2108, 2204, 1292, 2924, 1340, 2876],
            [2109, 2205, 1293, 2925, 1341, 2877],
            [2110, 2206, 1294, 2926, 1342, 2878],
            [2111, 2207, 1295, 2927, 1343, 2879],
            [2112, 2208, 1296, 2928, 1344, 2880],
            [2113, 2209, 1297, 2929, 1345, 2881],
            [2114, 2210, 1298, 2930, 1346, 2882],
            [2115, 2211, 1299, 2931, 1347, 2883],
            [2116, 2212, 1300, 2932, 1348, 2884],
            [2117, 2213, 1301, 2933, 1349, 2885],
            [2118, 2214, 1302, 2934, 1350, 2886],
            [2119, 2215, 1303, 2935, 1351, 2887],
            [2120, 2216, 1304, 2936, 1352, 2888],
            [2121, 2217, 1305, 2937, 1353, 2889],
            [2122, 2218, 1306, 2938, 1354, 2890],
            [2123, 2219, 1307, 2939, 1355, 2891],
            [2124, 2220, 1308, 2940, 1356, 2892],
            [2125, 2221, 1309, 2941, 1357, 2893],
            [2126, 2222, 1310, 2942, 1358, 2894],
            [2127, 2223, 1311, 2943, 1359, 2895],
            [2128, 2224, 1312, 2944, 1360, 2896],
            [2129, 2225, 1313, 2945, 1361, 2897],
            [2130, 2226, 1314, 2946, 1362, 2898],
            [2131, 2227, 1315, 2947, 1363, 2899],
            [2132, 2228, 1316, 2948, 1364, 2900],
            [2133, 2229, 1317, 2949, 1365, 2901],
            [2134, 2230, 1318, 2950, 1366, 2902],
            [2135, 2231, 1319, 2951, 1367, 2903],
            [2136, 2232, 1320, 2952, 1368, 2904],
            [2137, 2233, 1321, 2953, 1369, 2905],
            [2138, 2234, 1322, 2954, 1370, 2906],
            [2139, 2235, 1323, 2955, 1371, 2907],
            [2140, 2236, 1324, 2956, 1372, 2908],
            [2141, 2237, 1325, 2957, 1373, 2909],
            [2142, 2238, 1326, 2958, 1374, 2910],
            [2143, 2239, 1327, 2959, 1375, 2911],
            [2144, 2240, 1328, 2960, 1376, 2912],
            [2145, 2241, 1329, 2961, 1377, 2913],
            [2146, 2242, 1330, 2962, 1378, 2914],
            [2147, 2243, 1331, 2963, 1379, 2915],
            [2148, 2244, 1332, 2964, 1380, 2916],
            [2149, 2245, 1333, 2965, 1381, 2917],
            [2150, 2246, 1334, 2966, 1382, 2918],
            [2151, 2247, 1335, 2967, 1383, 2919],
            [2152, 2248, 1336, 2968, 1384, 2920],
            [2153, 2249, 1337, 2969, 1385, 2921],
            [2154, 2250, 1338, 2970, 1386, 2922],
            [2155, 2251, 1339, 2971, 1387, 2923],
            [2156, 2252, 1340, 2972, 1388, 2924],
            [2157, 2253, 1341, 2973, 1389, 2925],
            [2158, 2254, 1342, 2974, 1390, 2926],
            [2159, 2255, 1343, 2975, 1391, 2927],
            [2160, 2256, 1344, 2976, 1392, 2928],
            [2161, 2257, 1345, 2977, 1393, 2929],
            [2162, 2258, 2978, 1346, 1394, 2930],
            [2163, 2259, 2979, 1347, 1395, 2931],
            [2164, 2260, 2980, 1348, 1396, 2932],
            [2165, 2261, 2981, 1349, 1397, 2933],
            [2166, 2262, 2982, 1350, 1398, 2934],
            [2167, 2263, 2983, 1351, 1399, 2935],
            [2168, 2264, 2984, 1352, 1400, 2936],
            [2169, 2265, 2985, 1353, 1401, 2937],
            [2170, 2266, 2986, 1354, 1402, 2938],
            [2171, 2267, 2987, 1355, 1403, 2939],
            [2172, 2268, 2988, 1356, 1404, 2940],
            [2173, 2269, 2989, 1357, 1405, 2941],
            [2174, 2270, 2990, 1358, 1406, 2942],
            [2175, 2271, 2991, 1359, 1407, 2943],
            [2176, 2272, 2992, 1360, 1408, 2944],
            [2177, 2273, 2993, 1361, 1409, 2945],
            [2178, 2274, 2994, 1362, 1410, 2946],
            [2179, 2275, 2995, 1363, 1411, 2947],
            [2180, 2276, 2996, 1364, 1412, 2948],
            [2181, 2277, 2997, 1365, 1413, 2949],
            [2182, 2278, 2998, 1366, 1414, 2950],
            [2183, 2279, 2999, 1367, 1415, 2951],
            [2184, 2280, 3000, 1368, 1416, 2952],
            [2185, 2281, 3001, 1369, 1417, 2953],
            [2186, 2282, 3002, 1370, 1418, 2954],
            [2187, 2283, 3003, 1371, 1419, 2955],
            [2188, 2284, 3004, 1372, 1420, 2956],
            [2189, 2285, 3005, 1373, 1421, 2957],
            [2190, 2286, 3006, 1374, 1422, 2958],
            [2191, 2287, 3007, 1375, 1423, 2959],
            [2192, 2288, 3008, 1376, 1424, 2960],
            [2193, 2289, 3009, 1377, 1425, 2961],
            [2194, 2290, 3010, 1378, 1426, 2962],
            [2195, 2291, 3011, 1379, 1427, 2963],
            [2196, 2292, 3012, 1380, 1428, 2964],
            [2197, 2293, 3013, 1381, 1429, 2965],
            [2198, 2294, 3014, 1382, 1430, 2966],
            [2199, 2295, 3015, 1383, 1431, 2967],
            [2200, 2296, 3016, 1384, 1432, 2968],
            [2201, 2297, 3017, 1385, 1433, 2969],
            [2202, 2298, 3018, 1386, 1434, 2970],
            [2203, 2299, 3019, 1387, 1435, 2971],
            [2204, 2300, 3020, 1388, 1436, 2972],
            [2205, 2301, 3021, 1389, 1437, 2973],
            [2206, 2302, 3022, 1390, 1438, 2974],
            [2207, 2303, 3023, 1391, 1439, 2975],
            [2208, 2304, 3024, 1392, 1440, 2976],
            [2209, 2305, 3025, 1393, 1441, 2977],
            [2210, 2306, 3026, 1394, 1442, 2978],
            [2211, 2307, 3027, 1395, 1443, 2979],
            [2212, 2308, 3028, 1396, 1444, 2980],
            [2213, 2309, 3029, 1397, 1445, 2981],
            [2214, 2310, 3030, 1398, 1446, 2982],
            [2215, 2311, 3031, 1399, 1447, 2983],
            [2216, 2312, 3032, 1400, 1448, 2984],
            [2217, 2313, 3033, 1401, 1449, 2985],
            [2218, 2314, 3034, 1402, 1450, 2986],
            [2219, 2315, 3035, 1403, 1451, 2987],
            [2220, 2316, 3036, 1404, 1452, 2988],
            [2221, 2317, 3037, 1405, 1453, 2989],
            [2222, 2318, 3038, 1406, 1454, 2990],
            [2223, 2319, 3039, 1407, 1455, 2991],
            [2224, 2320, 3040, 1408, 1456, 2992],
            [2225, 2321, 3041, 1409, 1457, 2993],
            [2226, 2322, 3042, 1410, 1458, 2994],
            [2227, 2323, 3043, 1411, 1459, 2995],
            [2228, 2324, 3044, 1412, 1460, 2996],
            [2229, 2325, 3045, 1413, 1461, 2997],
            [2230, 2326, 3046, 1414, 1462, 2998],
            [2231, 2327, 3047, 1415, 1463, 2999],
            [2232, 2328, 3048, 1416, 1464, 3000],
            [2233, 2329, 3049, 1417, 1465, 3001],
            [2234, 2330, 3050, 1418, 1466, 3002],
            [2235, 2331, 3051, 1419, 1467, 3003],
            [2236, 2332, 3052, 1420, 1468, 3004],
            [2237, 2333, 3053, 1421, 1469, 3005],
            [2238, 2334, 3054, 1422, 1470, 3006],
            [2239, 2335, 3055, 1423, 1471, 3007],
            [2240, 2336, 3056, 1424, 1472, 3008],
            [2241, 2337, 3057, 1425, 1473, 3009],
            [2242, 2338, 3058, 1426, 1474, 3010],
            [2243, 2339, 3059, 1427, 1475, 3011],
            [2244, 2340, 3060, 1428, 1476, 3012],
            [2245, 2341, 3061, 1429, 1477, 3013],
            [2246, 2342, 3062, 1430, 1478, 3014],
            [2247, 2343, 3063, 1431, 1479, 3015],
            [2248, 2344, 3064, 1432, 1480, 3016],
            [2249, 2345, 3065, 1433, 1481, 3017],
            [2250, 2346, 3066, 1434, 1482, 3018],
            [2251, 2347, 3067, 1435, 1483, 3019],
            [2252, 2348, 3068, 1436, 1484, 3020],
            [2253, 2349, 3069, 1437, 1485, 3021],
            [2254, 2350, 3070, 1438, 1486, 3022],
            [2255, 2351, 3071, 1439, 1487, 3023],
            [2256, 2352, 3072, 1440, 1488, 3024],
            [2257, 2353, 3073, 1441, 1489, 3025],
            [2258, 2354, 3074, 1442, 1490, 3026],
            [2259, 2355, 3075, 1443, 1491, 3027],
            [2260, 2356, 3076, 1444, 1492, 3028],
            [2261, 2357, 3077, 1445, 1493, 3029],
            [2262, 2358, 3078, 1446, 1494, 3030],
            [2263, 2359, 3079, 1447, 1495, 3031],
            [2264, 2360, 3080, 1448, 1496, 3032],
            [2265, 2361, 3081, 1449, 1497, 3033],
            [2266, 2362, 3082, 1450, 1498, 3034],
            [2267, 2363, 3083, 1451, 1499, 3035],
            [2268, 2364, 3084, 1452, 1500, 3036],
            [2269, 2365, 3085, 1453, 1501, 3037],
            [2270, 2366, 3086, 1454, 1502, 3038],
            [2271, 2367, 3087, 1455, 1503, 3039],
            [2272, 2368, 3088, 1456, 1504, 3040],
            [2273, 2369, 3089, 1457, 1505, 3041],
            [2274, 2370, 3090, 1458, 1506, 3042],
            [2275, 2371, 3091, 1459, 1507, 3043],
            [2276, 2372, 3092, 1460, 1508, 3044],
            [2277, 2373, 3093, 1461, 1509, 3045],
            [2278, 2374, 3094, 1462, 1510, 3046],
            [2279, 2375, 3095, 1463, 1511, 3047],
            [2280, 2376, 3096, 1464, 1512, 3048],
            [2281, 2377, 3097, 1465, 1513, 3049],
            [2282, 2378, 3098, 1466, 1514, 3050],
            [2283, 2379, 3099, 1467, 1515, 3051],
            [2284, 2380, 3100, 1468, 1516, 3052],
            [2285, 2381, 3101, 1469, 1517, 3053],
            [2286, 2382, 3102, 1470, 1518, 3054],
            [2287, 2383, 3103, 1471, 1519, 3055],
            [2288, 2384, 3104, 1472, 1520, 3056],
            [2289, 2385, 3105, 1473, 1521, 3057],
            [2290, 2386, 3106, 1474, 1522, 3058],
            [2291, 2387, 3107, 1475, 1523, 3059],
            [2292, 2388, 3108, 1476, 1524, 3060],
            [2293, 2389, 3109, 1477, 1525, 3061],
            [2294, 2390, 3110, 1478, 1526, 3062],
            [2295, 2391, 3111, 1479, 1527, 3063],
            [2296, 2392, 3112, 1480, 1528, 3064],
            [2297, 2393, 3113, 1481, 1529, 3065],
            [2298, 2394, 3114, 1482, 1530, 3066],
            [2299, 2395, 3115, 1483, 1531, 3067],
            [2300, 2396, 3116, 1484, 1532, 3068],
            [2301, 2397, 3117, 1485, 1533, 3069],
            [2302, 2398, 3118, 1486, 1534, 3070],
            [2303, 2399, 3119, 1487, 1535, 3071],
            [2304, 2400, 3120, 1488, 1536, 3072],
            [2305, 2401, 3121, 1489, 1537, 3073],
            [2306, 2402, 3122, 1490, 1538, 3074],
            [2307, 2403, 3123, 1491, 1539, 3075],
            [2308, 2404, 3124, 1492, 1540, 3076],
            [2309, 2405, 3125, 1493, 1541, 3077],
            [2310, 2406, 3126, 1494, 1542, 3078],
            [2311, 2407, 3127, 1495, 1543, 3079],
            [2312, 2408, 3128, 1496, 1544, 3080],
            [2313, 2409, 3129, 1497, 1545, 3081],
            [2314, 2410, 3130, 1498, 1546, 3082],
            [2315, 2411, 3131, 1499, 1547, 3083],
            [2316, 2412, 3132, 1500, 1548, 3084],
            [2317, 2413, 3133, 1501, 1549, 3085],
            [2318, 2414, 3134, 1502, 1550, 3086],
            [2319, 2415, 3135, 1503, 1551, 3087],
            [2320, 2416, 3136, 1504, 1552, 3088],
            [2321, 2417, 3137, 1505, 1553, 3089],
            [2322, 2418, 3138, 1506, 1554, 3090],
            [2323, 2419, 3139, 1507, 1555, 3091],
            [2324, 2420, 3140, 1508, 1556, 3092],
            [2325, 2421, 3141, 1509, 1557, 3093],
            [2326, 2422, 3142, 1510, 1558, 3094],
            [2327, 2423, 3143, 1511, 1559, 3095],
            [2328, 2424, 3144, 1512, 1560, 3096],
            [2329, 2425, 3145, 1513, 1561, 3097],
            [2330, 2426, 3146, 1514, 1562, 3098],
            [2331, 2427, 3147, 1515, 1563, 3099],
            [2332, 2428, 3148, 1516, 1564, 3100],
            [2333, 2429, 3149, 1517, 1565, 3101],
            [2334, 2430, 3150, 1518, 1566, 3102],
            [2335, 2431, 3151, 1519, 1567, 3103],
            [2336, 2432, 3152, 1520, 1568, 3104],
            [2337, 2433, 3153, 1521, 1569, 3105],
            [2338, 2434, 3154, 1522, 1570, 3106],
            [2339, 2435, 3155, 1523, 1571, 3107],
            [2340, 2436, 3156, 1524, 1572, 3108],
            [2341, 2437, 3157, 1525, 1573, 3109],
            [2342, 2438, 3158, 1526, 1574, 3110],
            [2343, 2439, 3159, 1527, 1575, 3111],
            [2344, 2440, 3160, 1528, 1576, 3112],
            [2345, 2441, 3161, 1529, 1577, 3113],
            [2346, 2442, 3162, 1530, 1578, 3114],
            [2347, 2443, 3163, 1531, 1579, 3115],
            [2348, 2444, 3164, 1532, 1580, 3116],
            [2349, 2445, 3165, 1533, 1581, 3117],
            [2350, 2446, 3166, 1534, 1582, 3118],
            [2351, 2447, 3167, 1535, 1583, 3119],
            [2352, 2448, 3168, 1536, 1584, 3120],
            [2353, 2449, 3169, 1537, 1585, 3121],
            [2354, 2450, 3170, 1538, 1586, 3122],
            [2355, 2451, 3171, 1539, 1587, 3123],
            [2356, 2452, 3172, 1540, 1588, 3124],
            [2357, 2453, 3173, 1541, 1589, 3125],
            [2358, 2454, 3174, 1542, 1590, 3126],
            [2359, 2455, 3175, 1543, 1591, 3127],
            [2360, 2456, 3176, 1544, 1592, 3128],
            [2361, 2457, 3177, 1545, 1593, 3129],
            [2362, 2458, 3178, 1546, 1594, 3130],
            [2363, 2459, 3179, 1547, 1595, 3131],
            [2364, 2460, 3180, 1548, 1596, 3132],
            [2365, 2461, 3181, 1549, 1597, 3133],
            [2366, 2462, 3182, 1550, 1598, 3134],
            [2367, 2463, 3183, 1551, 1599, 3135],
            [2368, 2464, 3184, 1552, 1600, 3136],
            [2369, 2465, 3185, 1553, 1601, 3137],
            [2370, 2466, 3186, 1554, 1602, 3138],
            [2371, 2467, 3187, 1555, 1603, 3139],
            [2372, 2468, 3188, 1556, 1604, 3140],
            [2373, 2469, 3189, 1557, 1605, 3141],
            [2374, 2470, 3190, 1558, 1606, 3142],
            [2375, 2471, 3191, 1559, 1607, 3143],
            [2376, 2472, 3192, 1560, 1608, 3144],
            [2377, 2473, 3193, 1561, 1609, 3145],
            [2378, 2474, 3194, 1562, 1610, 3146],
            [2379, 2475, 3195, 1563, 1611, 3147],
            [2380, 2476, 3196, 1564, 1612, 3148],
            [2381, 2477, 3197, 1565, 1613, 3149],
            [2382, 2478, 3198, 1566, 1614, 3150],
            [2383, 2479, 3199, 1567, 1615, 3151],
            [2384, 2480, 3200, 1568, 1616, 3152],
            [2385, 2481, 3201, 1569, 1617, 3153],
            [2386, 2482, 3202, 1570, 1618, 3154],
            [2387, 2483, 3203, 1571, 1619, 3155],
            [2388, 2484, 3204, 1572, 1620, 3156],
            [2389, 2485, 3205, 1573, 1621, 3157],
            [2390, 2486, 3206, 1574, 1622, 3158],
            [2391, 2487, 3207, 1575, 1623, 3159],
            [2392, 2488, 3208, 1576, 1624, 3160],
            [2393, 2489, 3209, 1577, 1625, 3161],
            [2394, 2490, 3210, 1578, 1626, 3162],
            [2395, 2491, 3211, 1579, 1627, 3163],
            [2396, 2492, 3212, 1580, 1628, 3164],
            [2397, 2493, 3213, 1581, 1629, 3165],
            [2398, 2494, 3214, 1582, 1630, 3166],
            [2399, 2495, 3215, 1583, 1631, 3167],
            [2400, 2496, 3216, 1584, 1632, 3168],
            [2401, 2497, 3217, 1585, 1633, 3169],
            [2402, 2498, 3218, 1586, 1634, 3170],
            [2403, 2499, 3219, 1587, 1635, 3171],
            [2404, 2500, 3220, 1588, 1636, 3172],
            [2405, 2501, 3221, 1589, 1637, 3173],
            [2406, 2502, 3222, 1590, 1638, 3174],
            [2407, 2503, 3223, 1591, 1639, 3175],
            [2408, 2504, 3224, 1592, 1640, 3176],
            [2409, 2505, 3225, 1593, 1641, 3177],
            [2410, 2506, 3226, 1594, 1642, 3178],
            [2411, 2507, 3227, 1595, 1643, 3179],
            [2412, 2508, 3228, 1596, 1644, 3180],
            [2413, 2509, 3229, 1597, 1645, 3181],
            [2414, 2510, 3230, 1598, 1646, 3182],
            [2415, 2511, 3231, 1599, 1647, 3183],
            [2416, 2512, 3232, 1600, 1648, 3184],
            [2417, 2513, 3233, 1601, 1649, 3185],
            [2418, 2514, 3234, 1602, 1650, 3186],
            [2419, 2515, 3235, 1603, 1651, 3187],
            [2420, 2516, 3236, 1604, 1652, 3188],
            [2421, 2517, 3237, 1605, 1653, 3189],
            [2422, 2518, 3238, 1606, 1654, 3190],
            [2423, 2519, 3239, 1607, 1655, 3191],
            [2424, 2520, 3240, 1608, 1656, 3192],
            [2425, 2521, 3241, 1609, 1657, 3193],
            [2426, 2522, 3242, 1610, 1658, 3194],
            [2427, 2523, 3243, 1611, 1659, 3195],
            [2428, 2524, 3244, 1612, 1660, 3196],
            [2429, 2525, 3245, 1613, 1661, 3197],
            [2430, 2526, 3246, 1614, 1662, 3198],
            [2431, 2527, 3247, 1615, 1663, 3199],
            [2432, 2528, 3248, 1616, 1664, 3200],
            [2433, 2529, 3249, 1617, 1665, 3201],
            [2434, 2530, 3250, 1618, 1666, 3202],
            [2435, 2531, 3251, 1619, 1667, 3203],
            [2436, 2532, 3252, 1620, 1668, 3204],
            [2437, 2533, 3253, 1621, 1669, 3205],
            [2438, 2534, 3254, 1622, 1670, 3206],
            [2439, 2535, 3255, 1623, 1671, 3207],
            [2440, 2536, 3256, 1624, 1672, 3208],
            [2441, 2537, 3257, 1625, 1673, 3209],
            [2442, 2538, 3258, 1626, 1674, 3210],
            [2443, 2539, 3259, 1627, 1675, 3211],
            [2444, 2540, 3260, 1628, 1676, 3212],
            [2445, 2541, 3261, 1629, 1677, 3213],
            [2446, 2542, 3262, 1630, 1678, 3214],
            [2447, 2543, 3263, 1631, 1679, 3215],
            [2448, 2544, 3264, 1632, 1680, 3216],
            [2449, 2545, 3265, 1633, 1681, 3217],
            [2450, 2546, 3266, 1634, 1682, 3218],
            [2451, 2547, 3267, 1635, 1683, 3219],
            [2452, 2548, 3268, 1636, 1684, 3220],
            [2453, 2549, 3269, 1637, 1685, 3221],
            [2454, 2550, 3270, 1638, 1686, 3222],
            [2455, 2551, 3271, 1639, 1687, 3223],
            [2456, 2552, 3272, 1640, 1688, 3224],
            [2457, 2553, 3273, 1641, 1689, 3225],
            [2458, 2554, 3274, 1642, 1690, 3226],
            [2459, 2555, 3275, 1643, 1691, 3227],
            [2460, 2556, 3276, 1644, 1692, 3228],
            [2461, 2557, 3277, 1645, 1693, 3229],
            [2462, 2558, 3278, 1646, 1694, 3230],
            [2463, 2559, 3279, 1647, 1695, 3231],
            [2464, 2560, 3280, 1648, 1696, 3232],
            [2465, 2561, 3281, 1649, 1697, 3233],
            [2466, 2562, 3282, 1650, 1698, 3234],
            [2467, 2563, 3283, 1651, 1699, 3235],
            [2468, 2564, 3284, 1652, 1700, 3236],
            [2469, 2565, 3285, 1653, 1701, 3237],
            [2470, 2566, 3286, 1654, 1702, 3238],
            [2471, 2567, 3287, 1655, 1703, 3239],
            [2472, 2568, 3288, 1656, 1704, 3240],
            [2473, 2569, 3289, 1657, 1705, 3241],
            [2474, 2570, 3290, 1658, 1706, 3242],
            [2475, 2571, 3291, 1659, 1707, 3243],
            [2476, 2572, 3292, 1660, 1708, 3244],
            [2477, 2573, 3293, 1661, 1709, 3245],
            [2478, 2574, 3294, 1662, 1710, 3246],
            [2479, 2575, 3295, 1663, 1711, 3247],
            [2480, 2576, 3296, 1664, 1712, 3248],
            [2481, 2577, 3297, 1665, 1713, 3249],
            [2482, 2578, 3298, 1666, 1714, 3250],
            [2483, 2579, 3299, 1667, 1715, 3251],
            [2484, 2580, 3300, 1668, 1716, 3252],
            [2485, 2581, 3301, 1669, 1717, 3253],
            [2486, 2582, 3302, 1670, 1718, 3254],
            [2487, 2583, 3303, 1671, 1719, 3255],
            [2488, 2584, 3304, 1672, 1720, 3256],
            [2489, 2585, 3305, 1673, 1721, 3257],
            [2490, 2586, 3306, 1674, 1722, 3258],
            [2491, 2587, 3307, 1675, 1723, 3259],
            [2492, 2588, 3308, 1676, 1724, 3260],
            [2493, 2589, 3309, 1677, 1725, 3261],
            [2494, 2590, 3310, 1678, 1726, 3262],
            [2495, 2591, 3311, 1679, 1727, 3263],
            [2496, 2592, 3312, 1680, 1728, 3264],
            [2497, 2593, 3313, 1681, 1729, 3265],
            [2498, 2594, 3314, 1682, 1730, 3266],
            [2499, 2595, 3315, 1683, 1731, 3267],
            [2500, 2596, 3316, 1684, 1732, 3268],
            [2501, 2597, 3317, 1685, 1733, 3269],
            [2502, 2598, 3318, 1686, 1734, 3270],
            [2503, 2599, 3319, 1687, 1735, 3271],
            [2504, 2600, 3320, 1688, 1736, 3272],
            [2505, 2601, 3321, 1689, 1737, 3273],
            [2506, 2602, 3322, 1690, 1738, 3274],
            [2507, 2603, 3323, 1691, 1739, 3275],
            [2508, 2604, 3324, 1692, 1740, 3276],
            [2509, 2605, 3325, 1693, 1741, 3277],
            [2510, 2606, 3326, 1694, 1742, 3278],
            [2511, 2607, 3327, 1695, 1743, 3279],
            [2512, 2608, 3328, 1696, 1744, 3280],
            [2513, 2609, 3329, 1697, 1745, 3281],
            [2514, 2610, 3330, 1698, 1746, 3282],
            [2515, 2611, 3331, 1699, 1747, 3283],
            [2516, 2612, 3332, 1700, 1748, 3284],
            [2517, 2613, 3333, 1701, 1749, 3285],
            [2518, 2614, 3334, 1702, 1750, 3286],
            [2519, 2615, 3335, 1703, 1751, 3287],
            [2520, 2616, 3336, 1704, 1752, 3288],
            [2521, 2617, 3337, 1705, 1753, 3289],
            [2522, 2618, 3338, 1706, 1754, 3290],
            [2523, 2619, 3339, 1707, 1755, 3291],
            [2524, 2620, 3340, 1708, 1756, 3292],
            [2525, 2621, 3341, 1709, 1757, 3293],
            [2526, 2622, 3342, 1710, 1758, 3294],
            [2527, 2623, 3343, 1711, 1759, 3295],
            [2528, 2624, 3344, 1712, 1760, 3296],
            [2529, 2625, 3345, 1713, 1761, 3297],
            [2530, 2626, 3346, 1714, 1762, 3298],
            [2531, 2627, 3347, 1715, 1763, 3299],
            [2532, 2628, 3348, 1716, 1764, 3300],
            [2533, 2629, 3349, 1717, 1765, 3301],
            [2534, 2630, 3350, 1718, 1766, 3302],
            [2535, 2631, 3351, 1719, 1767, 3303],
            [2536, 2632, 3352, 1720, 1768, 3304],
            [2537, 2633, 3353, 1721, 1769, 3305],
            [2538, 2634, 3354, 1722, 1770, 3306],
            [2539, 2635, 3355, 1723, 1771, 3307],
            [2540, 2636, 3356, 1724, 1772, 3308],
            [2541, 2637, 3357, 1725, 1773, 3309],
            [2542, 2638, 3358, 1726, 1774, 3310],
            [2543, 2639, 3359, 1727, 1775, 3311],
            [2544, 2640, 3360, 1728, 1776, 3312],
            [2545, 2641, 3361, 1729, 1777, 3313],
            [2546, 2642, 3362, 1730, 1778, 3314],
            [2547, 2643, 3363, 1731, 1779, 3315],
            [2548, 2644, 3364, 1732, 1780, 3316],
            [2549, 2645, 3365, 1733, 1781, 3317],
            [2550, 2646, 3366, 1734, 1782, 3318],
            [2551, 2647, 3367, 1735, 1783, 3319],
            [2552, 2648, 3368, 1736, 1784, 3320],
            [2553, 2649, 3369, 1737, 1785, 3321],
            [2554, 2650, 3370, 1738, 1786, 3322],
            [2555, 2651, 3371, 1739, 1787, 3323],
            [2556, 2652, 3372, 1740, 1788, 3324],
            [2557, 2653, 3373, 1741, 1789, 3325],
            [2558, 2654, 3374, 1742, 1790, 3326],
            [2559, 2655, 3375, 1743, 1791, 3327],
            [2560, 2656, 3376, 1744, 1792, 3328],
            [2561, 2657, 3377, 1745, 1793, 3329],
            [2562, 2658, 3378, 1746, 1794, 3330],
            [2563, 2659, 3379, 1747, 1795, 3331],
            [2564, 2660, 3380, 1748, 1796, 3332],
            [2565, 2661, 3381, 1749, 1797, 3333],
            [2566, 2662, 3382, 1750, 1798, 3334],
            [2567, 2663, 3383, 1751, 1799, 3335],
            [2568, 2664, 3384, 1752, 1800, 3336],
            [2569, 2665, 3385, 1753, 1801, 3337],
            [2570, 2666, 3386, 1754, 1802, 3338],
            [2571, 2667, 3387, 1755, 1803, 3339],
            [2572, 2668, 3388, 1756, 1804, 3340],
            [2573, 2669, 3389, 1757, 1805, 3341],
            [2574, 2670, 3390, 1758, 1806, 3342],
            [2575, 2671, 3391, 1759, 1807, 3343],
            [2576, 2672, 3392, 1760, 1808, 3344],
            [2577, 2673, 3393, 1761, 1809, 3345],
            [2578, 2674, 3394, 1762, 1810, 3346],
            [2579, 2675, 3395, 1763, 1811, 3347],
            [2580, 2676, 3396, 1764, 1812, 3348],
            [2581, 2677, 3397, 1765, 1813, 3349],
            [2582, 2678, 3398, 1766, 1814, 3350],
            [2583, 2679, 3399, 1767, 1815, 3351],
            [2584, 2680, 3400, 1768, 1816, 3352],
            [2585, 2681, 3401, 1769, 1817, 3353],
            [2586, 2682, 3402, 1770, 1818, 3354],
            [2587, 2683, 3403, 1771, 1819, 3355],
            [2588, 2684, 3404, 1772, 1820, 3356],
            [2589, 2685, 3405, 1773, 1821, 3357],
            [2590, 2686, 3406, 1774, 1822, 3358],
            [2591, 2687, 3407, 1775, 1823, 3359],
            [2592, 2688, 3408, 1776, 1824, 3360],
            [2593, 2689, 3409, 1777, 1825, 3361],
            [2594, 2690, 3410, 1778, 1826, 3362],
            [2595, 2691, 3411, 1779, 1827, 3363],
            [2596, 2692, 3412, 1780, 1828, 3364],
            [2597, 2693, 3413, 1781, 1829, 3365],
            [2598, 2694, 3414, 1782, 1830, 3366],
            [2599, 2695, 3415, 1783, 1831, 3367],
            [2600, 2696, 3416, 1784, 1832, 3368],
            [2601, 2697, 3417, 1785, 1833, 3369],
            [2602, 2698, 3418, 1786, 1834, 3370],
            [2603, 2699, 3419, 1787, 1835, 3371],
            [2604, 2700, 3420, 1788, 1836, 3372],
            [2605, 2701, 3421, 1789, 1837, 3373],
            [2606, 2702, 3422, 1790, 1838, 3374],
            [2607, 2703, 3423, 1791, 1839, 3375],
            [2608, 2704, 3424, 1792, 1840, 3376],
            [2609, 2705, 3425, 1793, 1841, 3377],
            [2610, 2706, 3426, 1794, 1842, 3378],
            [2611, 2707, 3427, 1795, 1843, 3379],
            [2612, 2708, 3428, 1796, 1844, 3380],
            [2613, 2709, 3429, 1797, 1845, 3381],
            [2614, 2710, 3430, 1798, 1846, 3382],
            [2615, 2711, 3431, 1799, 1847, 3383],
            [2616, 2712, 3432, 1800, 1848, 3384],
            [2617, 2713, 3433, 1801, 1849, 3385],
            [2618, 2714, 3434, 1802, 1850, 3386],
            [2619, 2715, 3435, 1803, 1851, 3387],
            [2620, 2716, 3436, 1804, 1852, 3388],
            [2621, 2717, 3437, 1805, 1853, 3389],
            [2622, 2718, 3438, 1806, 1854, 3390],
            [2623, 2719, 3439, 1807, 1855, 3391],
            [2624, 2720, 3440, 1808, 1856, 3392],
            [2625, 2721, 3441, 1809, 1857, 3393],
            [2626, 2722, 3442, 1810, 1858, 3394],
            [2627, 2723, 3443, 1811, 1859, 3395],
            [2628, 2724, 3444, 1812, 1860, 3396],
            [2629, 2725, 3445, 1813, 1861, 3397],
            [2630, 2726, 3446, 1814, 1862, 3398],
            [2631, 2727, 3447, 1815, 1863, 3399],
            [2632, 2728, 3448, 1816, 1864, 3400],
            [2633, 2729, 3449, 1817, 1865, 3401],
            [2634, 2730, 3450, 1818, 1866, 3402],
            [2635, 2731, 3451, 1819, 1867, 3403],
            [2636, 2732, 3452, 1820, 1868, 3404],
            [2637, 2733, 3453, 1821, 1869, 3405],
            [2638, 2734, 3454, 1822, 1870, 3406],
            [2639, 2735, 3455, 1823, 1871, 3407],
            [2640, 2736, 3456, 1824, 1872, 3408],
            [2641, 2737, 3457, 1825, 1873, 3409],
            [2642, 562, 586, 1826, 1874, 3410],
            [2643, 563, 587, 1827, 1875, 3411],
            [2644, 564, 588, 1828, 1876, 3412],
            [2645, 565, 589, 1829, 1877, 3413],
            [2646, 566, 590, 1830, 1878, 3414],
            [2647, 567, 591, 1831, 1879, 3415],
            [2648, 568, 592, 1832, 1880, 3416],
            [2649, 569, 593, 1833, 1881, 3417],
            [2650, 554, 578, 1834, 1882, 3418],
            [2651, 555, 579, 1835, 1883, 3419],
            [2652, 556, 580, 1836, 1884, 3420],
            [2653, 557, 581, 1837, 1885, 3421],
            [2654, 558, 582, 1838, 1886, 3422],
            [2655, 559, 583, 1839, 1887, 3423],
            [2656, 560, 584, 1840, 1888, 3424],
            [2657, 561, 585, 1841, 1889, 3425],
            [2658, 570, 594, 1842, 1890, 3426],
            [2659, 571, 595, 1843, 1891, 3427],
            [2660, 572, 596, 1844, 1892, 3428],
            [2661, 573, 597, 1845, 1893, 3429],
            [2662, 574, 598, 1846, 1894, 3430],
            [2663, 575, 599, 1847, 1895, 3431],
            [2664, 576, 600, 1848, 1896, 3432],
            [2665, 577, 601, 1849, 1897, 3433],
            [2666, 570, 594, 1850, 1898, 3434],
            [2667, 571, 595, 1851, 1899, 3435],
            [2668, 572, 596, 1852, 1900, 3436],
            [2669, 573, 597, 1853, 1901, 3437],
            [2670, 574, 598, 1854, 1902, 3438],
            [2671, 575, 599, 1855, 1903, 3439],
            [2672, 576, 600, 1856, 1904, 3440],
            [2673, 577, 601, 1857, 1905, 3441],
            [2674, 554, 578, 1858, 1906, 3442],
            [2675, 555, 579, 1859, 1907, 3443],
            [2676, 556, 580, 1860, 1908, 3444],
            [2677, 557, 581, 1861, 1909, 3445],
            [2678, 558, 582, 1862, 1910, 3446],
            [2679, 559, 583, 1863, 1911, 3447],
            [2680, 560, 584, 1864, 1912, 3448],
            [2681, 561, 585, 1865, 1913, 3449],
            [2682, 562, 586, 1866, 1914, 3450],
            [2683, 563, 587, 1867, 1915, 3451],
            [2684, 564, 588, 1868, 1916, 3452],
            [2685, 565, 589, 1869, 1917, 3453],
            [2686, 566, 590, 1870, 1918, 3454],
            [2687, 567, 591, 1871, 1919, 3455],
            [2688, 568, 592, 1872, 1920, 3456],
            [2689, 569, 593, 1873, 1921, 3457],
            [826, 1970, 2786, 850, 2018, 2740],
            [827, 1971, 2787, 851, 2019, 2741],
            [826, 1972, 2788, 850, 2020, 2738],
            [827, 1973, 2789, 851, 2021, 2739],
            [828, 1974, 2790, 852, 2022, 2744],
            [829, 1975, 2791, 853, 2023, 2745],
            [828, 1976, 2792, 852, 2024, 2742],
            [829, 1977, 2793, 853, 2025, 2743],
            [818, 1978, 2794, 842, 2026, 2750],
            [819, 1979, 2795, 843, 2027, 2751],
            [820, 1980, 2796, 844, 2028, 2752],
            [821, 1981, 2797, 845, 2029, 2753],
            [818, 1982, 2798, 842, 2030, 2746],
            [819, 1983, 2799, 843, 2031, 2747],
            [820, 1984, 2800, 844, 2032, 2748],
            [821, 1985, 2801, 845, 2033, 2749],
            [834, 1986, 2802, 858, 2034, 2755],
            [834, 1987, 2803, 858, 2035, 2754],
            [835, 1988, 2804, 859, 2036, 2757],
            [835, 1989, 2805, 859, 2037, 2756],
            [836, 1990, 2806, 860, 2038, 2759],
            [836, 1991, 2807, 860, 2039, 2758],
            [837, 1992, 2808, 861, 2040, 2761],
            [837, 1993, 2809, 861, 2041, 2760],
            [838, 1994, 2810, 862, 2042, 2763],
            [838, 1995, 2811, 862, 2043, 2762],
            [839, 1996, 2812, 863, 2044, 2765],
            [839, 1997, 2813, 863, 2045, 2764],
            [840, 1998, 2814, 864, 2046, 2767],
            [840, 1999, 2815, 864, 2047, 2766],
            [841, 2000, 2816, 865, 2048, 2769],
            [841, 2001, 2817, 865, 2049, 2768],
            [822, 2002, 2818, 846, 2050, 2774],
            [823, 2003, 2819, 847, 2051, 2775],
            [824, 2004, 2820, 848, 2052, 2776],
            [825, 2005, 2821, 849, 2053, 2777],
            [822, 2006, 2822, 846, 2054, 2770],
            [823, 2007, 2823, 847, 2055, 2771],
            [824, 2008, 2824, 848, 2056, 2772],
            [825, 2009, 2825, 849, 2057, 2773],
            [830, 2010, 2826, 854, 2058, 2780],
            [831, 2011, 2827, 855, 2059, 2781],
            [830, 2012, 2828, 854, 2060, 2778],
            [831, 2013, 2829, 855, 2061, 2779],
            [832, 2014, 2830, 856, 2062, 2784],
            [833, 2015, 2831, 857, 2063, 2785],
            [832, 2016, 2832, 856, 2064, 2782],
            [833, 2017, 2833, 857, 2065, 2783],
            [2738, 2834, 2018, 3458, 2066, 850],
            [2739, 2835, 2019, 3459, 2067, 851],
            [2740, 2836, 2020, 3460, 2068, 850],
            [2741, 2837, 2021, 3461, 2069, 851],
            [2742, 2838, 2022, 3462, 2070, 852],
            [2743, 2839, 2023, 3463, 2071, 853],
            [2744, 2840, 2024, 3464, 2072, 852],
            [2745, 2841, 2025, 3465, 2073, 853],
            [2746, 2842, 2026, 3466, 2074, 842],
            [2747, 2843, 2027, 3467, 2075, 843],
            [2748, 2844, 2028, 3468, 2076, 844],
            [2749, 2845, 2029, 3469, 2077, 845],
            [2750, 2846, 2030, 3470, 2078, 842],
            [2751, 2847, 2031, 3471, 2079, 843],
            [2752, 2848, 2032, 3472, 2080, 844],
            [2753, 2849, 2033, 3473, 2081, 845],
            [2754, 2850, 2034, 3474, 2082, 858],
            [2755, 2851, 2035, 3475, 2083, 858],
            [2756, 2852, 2036, 3476, 2084, 859],
            [2757, 2853, 2037, 3477, 2085, 859],
            [2758, 2854, 2038, 3478, 2086, 860],
            [2759, 2855, 2039, 3479, 2087, 860],
            [2760, 2856, 2040, 3480, 2088, 861],
            [2761, 2857, 2041, 3481, 2089, 861],
            [2762, 2858, 2042, 3482, 2090, 862],
            [2763, 2859, 2043, 3483, 2091, 862],
            [2764, 2860, 2044, 3484, 2092, 863],
            [2765, 2861, 2045, 3485, 2093, 863],
            [2766, 2862, 2046, 3486, 2094, 864],
            [2767, 2863, 2047, 3487, 2095, 864],
            [2768, 2864, 2048, 3488, 2096, 865],
            [2769, 2865, 2049, 3489, 2097, 865],
            [2770, 2866, 2050, 3490, 2098, 846],
            [2771, 2867, 2051, 3491, 2099, 847],
            [2772, 2868, 2052, 3492, 2100, 848],
            [2773, 2869, 2053, 3493, 2101, 849],
            [2774, 2870, 2054, 3494, 2102, 846],
            [2775, 2871, 2055, 3495, 2103, 847],
            [2776, 2872, 2056, 3496, 2104, 848],
            [2777, 2873, 2057, 3497, 2105, 849],
            [2778, 2874, 2058, 3498, 2106, 854],
            [2779, 2875, 2059, 3499, 2107, 855],
            [2780, 2876, 2060, 3500, 2108, 854],
            [2781, 2877, 2061, 3501, 2109, 855],
            [2782, 2878, 2062, 3502, 2110, 856],
            [2783, 2879, 2063, 3503, 2111, 857],
            [2784, 2880, 2064, 3504, 2112, 856],
            [2785, 2881, 2065, 3505, 2113, 857],
            [2786, 2882, 2066, 3506, 2114, 3458],
            [2787, 2883, 2067, 3507, 2115, 3459],
            [2788, 2884, 2068, 3508, 2116, 3460],
            [2789, 2885, 2069, 3509, 2117, 3461],
            [2790, 2886, 2070, 3510, 2118, 3462],
            [2791, 2887, 2071, 3511, 2119, 3463],
            [2792, 2888, 2072, 3512, 2120, 3464],
            [2793, 2889, 2073, 3513, 2121, 3465],
            [2794, 2890, 2074, 3514, 2122, 3466],
            [2795, 2891, 2075, 3515, 2123, 3467],
            [2796, 2892, 2076, 3516, 2124, 3468],
            [2797, 2893, 2077, 3517, 2125, 3469],
            [2798, 2894, 2078, 3518, 2126, 3470],
            [2799, 2895, 2079, 3519, 2127, 3471],
            [2800, 2896, 2080, 3520, 2128, 3472],
            [2801, 2897, 2081, 3521, 2129, 3473],
            [2802, 2898, 2082, 3522, 2130, 3474],
            [2803, 2899, 2083, 3523, 2131, 3475],
            [2804, 2900, 2084, 3524, 2132, 3476],
            [2805, 2901, 2085, 3525, 2133, 3477],
            [2806, 2902, 2086, 3526, 2134, 3478],
            [2807, 2903, 2087, 3527, 2135, 3479],
            [2808, 2904, 2088, 3528, 2136, 3480],
            [2809, 2905, 2089, 3529, 2137, 3481],
            [2810, 2906, 2090, 3530, 2138, 3482],
            [2811, 2907, 2091, 3531, 2139, 3483],
            [2812, 2908, 2092, 3532, 2140, 3484],
            [2813, 2909, 2093, 3533, 2141, 3485],
            [2814, 2910, 2094, 3534, 2142, 3486],
            [2815, 2911, 2095, 3535, 2143, 3487],
            [2816, 2912, 2096, 3536, 2144, 3488],
            [2817, 2913, 2097, 3537, 2145, 3489],
            [2818, 2914, 2098, 3538, 2146, 3490],
            [2819, 2915, 2099, 3539, 2147, 3491],
            [2820, 2916, 2100, 3540, 2148, 3492],
            [2821, 2917, 2101, 3541, 2149, 3493],
            [2822, 2918, 2102, 3542, 2150, 3494],
            [2823, 2919, 2103, 3543, 2151, 3495],
            [2824, 2920, 2104, 3544, 2152, 3496],
            [2825, 2921, 2105, 3545, 2153, 3497],
            [2826, 2922, 2106, 3546, 2154, 3498],
            [2827, 2923, 2107, 3547, 2155, 3499],
            [2828, 2924, 2108, 3548, 2156, 3500],
            [2829, 2925, 2109, 3549, 2157, 3501],
            [2830, 2926, 2110, 3550, 2158, 3502],
            [2831, 2927, 2111, 3551, 2159, 3503],
            [2832, 2928, 2112, 3552, 2160, 3504],
            [2833, 2929, 2113, 3553, 2161, 3505],
            [2834, 2930, 2114, 3554, 2162, 3506],
            [2835, 2931, 2115, 3555, 2163, 3507],
            [2836, 2932, 2116, 3556, 2164, 3508],
            [2837, 2933, 2117, 3557, 2165, 3509],
            [2838, 2934, 2118, 3558, 2166, 3510],
            [2839, 2935, 2119, 3559, 2167, 3511],
            [2840, 2936, 2120, 3560, 2168, 3512],
            [2841, 2937, 2121, 3561, 2169, 3513],
            [2842, 2938, 2122, 3562, 2170, 3514],
            [2843, 2939, 2123, 3563, 2171, 3515],
            [2844, 2940, 2124, 3564, 2172, 3516],
            [2845, 2941, 2125, 3565, 2173, 3517],
            [2846, 2942, 2126, 3566, 2174, 3518],
            [2847, 2943, 2127, 3567, 2175, 3519],
            [2848, 2944, 2128, 3568, 2176, 3520],
            [2849, 2945, 2129, 3569, 2177, 3521],
            [2850, 2946, 2130, 3570, 2178, 3522],
            [2851, 2947, 2131, 3571, 2179, 3523],
            [2852, 2948, 2132, 3572, 2180, 3524],
            [2853, 2949, 2133, 3573, 2181, 3525],
            [2854, 2950, 2134, 3574, 2182, 3526],
            [2855, 2951, 2135, 3575, 2183, 3527],
            [2856, 2952, 2136, 3576, 2184, 3528],
            [2857, 2953, 2137, 3577, 2185, 3529],
            [2858, 2954, 2138, 3578, 2186, 3530],
            [2859, 2955, 2139, 3579, 2187, 3531],
            [2860, 2956, 2140, 3580, 2188, 3532],
            [2861, 2957, 2141, 3581, 2189, 3533],
            [2862, 2958, 2142, 3582, 2190, 3534],
            [2863, 2959, 2143, 3583, 2191, 3535],
            [2864, 2960, 2144, 3584, 2192, 3536],
            [2865, 2961, 2145, 3585, 2193, 3537],
            [2866, 2962, 2146, 3586, 2194, 3538],
            [2867, 2963, 2147, 3587, 2195, 3539],
            [2868, 2964, 2148, 3588, 2196, 3540],
            [2869, 2965, 2149, 3589, 2197, 3541],
            [2870, 2966, 2150, 3590, 2198, 3542],
            [2871, 2967, 2151, 3591, 2199, 3543],
            [2872, 2968, 2152, 3592, 2200, 3544],
            [2873, 2969, 2153, 3593, 2201, 3545],
            [2874, 2970, 2154, 3594, 2202, 3546],
            [2875, 2971, 2155, 3595, 2203, 3547],
            [2876, 2972, 2156, 3596, 2204, 3548],
            [2877, 2973, 2157, 3597, 2205, 3549],
            [2878, 2974, 2158, 3598, 2206, 3550],
            [2879, 2975, 2159, 3599, 2207, 3551],
            [2880, 2976, 2160, 3600, 2208, 3552],
            [2881, 2977, 2161, 3601, 2209, 3553],
            [2882, 2978, 2162, 3602, 2210, 3554],
            [2883, 2979, 2163, 3603, 2211, 3555],
            [2884, 2980, 2164, 3604, 2212, 3556],
            [2885, 2981, 2165, 3605, 2213, 3557],
            [2886, 2982, 2166, 3606, 2214, 3558],
            [2887, 2983, 2167, 3607, 2215, 3559],
            [2888, 2984, 2168, 3608, 2216, 3560],
            [2889, 2985, 2169, 3609, 2217, 3561],
            [2890, 2986, 2170, 3610, 2218, 3562],
            [2891, 2987, 2171, 3611, 2219, 3563],
            [2892, 2988, 2172, 3612, 2220, 3564],
            [2893, 2989, 2173, 3613, 2221, 3565],
            [2894, 2990, 2174, 3614, 2222, 3566],
            [2895, 2991, 2175, 3615, 2223, 3567],
            [2896, 2992, 2176, 3616, 2224, 3568],
            [2897, 2993, 2177, 3617, 2225, 3569],
            [2898, 2994, 2178, 3618, 2226, 3570],
            [2899, 2995, 2179, 3619, 2227, 3571],
            [2900, 2996, 2180, 3620, 2228, 3572],
            [2901, 2997, 2181, 3621, 2229, 3573],
            [2902, 2998, 2182, 3622, 2230, 3574],
            [2903, 2999, 2183, 3623, 2231, 3575],
            [2904, 3000, 2184, 3624, 2232, 3576],
            [2905, 3001, 2185, 3625, 2233, 3577],
            [2906, 3002, 2186, 3626, 2234, 3578],
            [2907, 3003, 2187, 3627, 2235, 3579],
            [2908, 3004, 2188, 3628, 2236, 3580],
            [2909, 3005, 2189, 3629, 2237, 3581],
            [2910, 3006, 2190, 3630, 2238, 3582],
            [2911, 3007, 2191, 3631, 2239, 3583],
            [2912, 3008, 2192, 3632, 2240, 3584],
            [2913, 3009, 2193, 3633, 2241, 3585],
            [2914, 3010, 2194, 3634, 2242, 3586],
            [2915, 3011, 2195, 3635, 2243, 3587],
            [2916, 3012, 2196, 3636, 2244, 3588],
            [2917, 3013, 2197, 3637, 2245, 3589],
            [2918, 3014, 2198, 3638, 2246, 3590],
            [2919, 3015, 2199, 3639, 2247, 3591],
            [2920, 3016, 2200, 3640, 2248, 3592],
            [2921, 3017, 2201, 3641, 2249, 3593],
            [2922, 3018, 2202, 3642, 2250, 3594],
            [2923, 3019, 2203, 3643, 2251, 3595],
            [2924, 3020, 2204, 3644, 2252, 3596],
            [2925, 3021, 2205, 3645, 2253, 3597],
            [2926, 3022, 2206, 3646, 2254, 3598],
            [2927, 3023, 2207, 3647, 2255, 3599],
            [2928, 3024, 2208, 3648, 2256, 3600],
            [2929, 3025, 2209, 3649, 2257, 3601],
            [2930, 3026, 3650, 2210, 2258, 3602],
            [2931, 3027, 3651, 2211, 2259, 3603],
            [2932, 3028, 3652, 2212, 2260, 3604],
            [2933, 3029, 3653, 2213, 2261, 3605],
            [2934, 3030, 3654, 2214, 2262, 3606],
            [2935, 3031, 3655, 2215, 2263, 3607],
            [2936, 3032, 3656, 2216, 2264, 3608],
            [2937, 3033, 3657, 2217, 2265, 3609],
            [2938, 3034, 3658, 2218, 2266, 3610],
            [2939, 3035, 3659, 2219, 2267, 3611],
            [2940, 3036, 3660, 2220, 2268, 3612],
            [2941, 3037, 3661, 2221, 2269, 3613],
            [2942, 3038, 3662, 2222, 2270, 3614],
            [2943, 3039, 3663, 2223, 2271, 3615],
            [2944, 3040, 3664, 2224, 2272, 3616],
            [2945, 3041, 3665, 2225, 2273, 3617],
            [2946, 3042, 3666, 2226, 2274, 3618],
            [2947, 3043, 3667, 2227, 2275, 3619],
            [2948, 3044, 3668, 2228, 2276, 3620],
            [2949, 3045, 3669, 2229, 2277, 3621],
            [2950, 3046, 3670, 2230, 2278, 3622],
            [2951, 3047, 3671, 2231, 2279, 3623],
            [2952, 3048, 3672, 2232, 2280, 3624],
            [2953, 3049, 3673, 2233, 2281, 3625],
            [2954, 3050, 3674, 2234, 2282, 3626],
            [2955, 3051, 3675, 2235, 2283, 3627],
            [2956, 3052, 3676, 2236, 2284, 3628],
            [2957, 3053, 3677, 2237, 2285, 3629],
            [2958, 3054, 3678, 2238, 2286, 3630],
            [2959, 3055, 3679, 2239, 2287, 3631],
            [2960, 3056, 3680, 2240, 2288, 3632],
            [2961, 3057, 3681, 2241, 2289, 3633],
            [2962, 3058, 3682, 2242, 2290, 3634],
            [2963, 3059, 3683, 2243, 2291, 3635],
            [2964, 3060, 3684, 2244, 2292, 3636],
            [2965, 3061, 3685, 2245, 2293, 3637],
            [2966, 3062, 3686, 2246, 2294, 3638],
            [2967, 3063, 3687, 2247, 2295, 3639],
            [2968, 3064, 3688, 2248, 2296, 3640],
            [2969, 3065, 3689, 2249, 2297, 3641],
            [2970, 3066, 3690, 2250, 2298, 3642],
            [2971, 3067, 3691, 2251, 2299, 3643],
            [2972, 3068, 3692, 2252, 2300, 3644],
            [2973, 3069, 3693, 2253, 2301, 3645],
            [2974, 3070, 3694, 2254, 2302, 3646],
            [2975, 3071, 3695, 2255, 2303, 3647],
            [2976, 3072, 3696, 2256, 2304, 3648],
            [2977, 3073, 3697, 2257, 2305, 3649],
            [2978, 3074, 3698, 2258, 2306, 3650],
            [2979, 3075, 3699, 2259, 2307, 3651],
            [2980, 3076, 3700, 2260, 2308, 3652],
            [2981, 3077, 3701, 2261, 2309, 3653],
            [2982, 3078, 3702, 2262, 2310, 3654],
            [2983, 3079, 3703, 2263, 2311, 3655],
            [2984, 3080, 3704, 2264, 2312, 3656],
            [2985, 3081, 3705, 2265, 2313, 3657],
            [2986, 3082, 3706, 2266, 2314, 3658],
            [2987, 3083, 3707, 2267, 2315, 3659],
            [2988, 3084, 3708, 2268, 2316, 3660],
            [2989, 3085, 3709, 2269, 2317, 3661],
            [2990, 3086, 3710, 2270, 2318, 3662],
            [2991, 3087, 3711, 2271, 2319, 3663],
            [2992, 3088, 3712, 2272, 2320, 3664],
            [2993, 3089, 3713, 2273, 2321, 3665],
            [2994, 3090, 3714, 2274, 2322, 3666],
            [2995, 3091, 3715, 2275, 2323, 3667],
            [2996, 3092, 3716, 2276, 2324, 3668],
            [2997, 3093, 3717, 2277, 2325, 3669],
            [2998, 3094, 3718, 2278, 2326, 3670],
            [2999, 3095, 3719, 2279, 2327, 3671],
            [3000, 3096, 3720, 2280, 2328, 3672],
            [3001, 3097, 3721, 2281, 2329, 3673],
            [3002, 3098, 3722, 2282, 2330, 3674],
            [3003, 3099, 3723, 2283, 2331, 3675],
            [3004, 3100, 3724, 2284, 2332, 3676],
            [3005, 3101, 3725, 2285, 2333, 3677],
            [3006, 3102, 3726, 2286, 2334, 3678],
            [3007, 3103, 3727, 2287, 2335, 3679],
            [3008, 3104, 3728, 2288, 2336, 3680],
            [3009, 3105, 3729, 2289, 2337, 3681],
            [3010, 3106, 3730, 2290, 2338, 3682],
            [3011, 3107, 3731, 2291, 2339, 3683],
            [3012, 3108, 3732, 2292, 2340, 3684],
            [3013, 3109, 3733, 2293, 2341, 3685],
            [3014, 3110, 3734, 2294, 2342, 3686],
            [3015, 3111, 3735, 2295, 2343, 3687],
            [3016, 3112, 3736, 2296, 2344, 3688],
            [3017, 3113, 3737, 2297, 2345, 3689],
            [3018, 3114, 3738, 2298, 2346, 3690],
            [3019, 3115, 3739, 2299, 2347, 3691],
            [3020, 3116, 3740, 2300, 2348, 3692],
            [3021, 3117, 3741, 2301, 2349, 3693],
            [3022, 3118, 3742, 2302, 2350, 3694],
            [3023, 3119, 3743, 2303, 2351, 3695],
            [3024, 3120, 3744, 2304, 2352, 3696],
            [3025, 3121, 3745, 2305, 2353, 3697],
            [3026, 3122, 3746, 2306, 2354, 3698],
            [3027, 3123, 3747, 2307, 2355, 3699],
            [3028, 3124, 3748, 2308, 2356, 3700],
            [3029, 3125, 3749, 2309, 2357, 3701],
            [3030, 3126, 3750, 2310, 2358, 3702],
            [3031, 3127, 3751, 2311, 2359, 3703],
            [3032, 3128, 3752, 2312, 2360, 3704],
            [3033, 3129, 3753, 2313, 2361, 3705],
            [3034, 3130, 3754, 2314, 2362, 3706],
            [3035, 3131, 3755, 2315, 2363, 3707],
            [3036, 3132, 3756, 2316, 2364, 3708],
            [3037, 3133, 3757, 2317, 2365, 3709],
            [3038, 3134, 3758, 2318, 2366, 3710],
            [3039, 3135, 3759, 2319, 2367, 3711],
            [3040, 3136, 3760, 2320, 2368, 3712],
            [3041, 3137, 3761, 2321, 2369, 3713],
            [3042, 3138, 3762, 2322, 2370, 3714],
            [3043, 3139, 3763, 2323, 2371, 3715],
            [3044, 3140, 3764, 2324, 2372, 3716],
            [3045, 3141, 3765, 2325, 2373, 3717],
            [3046, 3142, 3766, 2326, 2374, 3718],
            [3047, 3143, 3767, 2327, 2375, 3719],
            [3048, 3144, 3768, 2328, 2376, 3720],
            [3049, 3145, 3769, 2329, 2377, 3721],
            [3050, 3146, 3770, 2330, 2378, 3722],
            [3051, 3147, 3771, 2331, 2379, 3723],
            [3052, 3148, 3772, 2332, 2380, 3724],
            [3053, 3149, 3773, 2333, 2381, 3725],
            [3054, 3150, 3774, 2334, 2382, 3726],
            [3055, 3151, 3775, 2335, 2383, 3727],
            [3056, 3152, 3776, 2336, 2384, 3728],
            [3057, 3153, 3777, 2337, 2385, 3729],
            [3058, 3154, 3778, 2338, 2386, 3730],
            [3059, 3155, 3779, 2339, 2387, 3731],
            [3060, 3156, 3780, 2340, 2388, 3732],
            [3061, 3157, 3781, 2341, 2389, 3733],
            [3062, 3158, 3782, 2342, 2390, 3734],
            [3063, 3159, 3783, 2343, 2391, 3735],
            [3064, 3160, 3784, 2344, 2392, 3736],
            [3065, 3161, 3785, 2345, 2393, 3737],
            [3066, 3162, 3786, 2346, 2394, 3738],
            [3067, 3163, 3787, 2347, 2395, 3739],
            [3068, 3164, 3788, 2348, 2396, 3740],
            [3069, 3165, 3789, 2349, 2397, 3741],
            [3070, 3166, 3790, 2350, 2398, 3742],
            [3071, 3167, 3791, 2351, 2399, 3743],
            [3072, 3168, 3792, 2352, 2400, 3744],
            [3073, 3169, 3793, 2353, 2401, 3745],
            [3074, 3170, 3794, 2354, 2402, 3746],
            [3075, 3171, 3795, 2355, 2403, 3747],
            [3076, 3172, 3796, 2356, 2404, 3748],
            [3077, 3173, 3797, 2357, 2405, 3749],
            [3078, 3174, 3798, 2358, 2406, 3750],
            [3079, 3175, 3799, 2359, 2407, 3751],
            [3080, 3176, 3800, 2360, 2408, 3752],
            [3081, 3177, 3801, 2361, 2409, 3753],
            [3082, 3178, 3802, 2362, 2410, 3754],
            [3083, 3179, 3803, 2363, 2411, 3755],
            [3084, 3180, 3804, 2364, 2412, 3756],
            [3085, 3181, 3805, 2365, 2413, 3757],
            [3086, 3182, 3806, 2366, 2414, 3758],
            [3087, 3183, 3807, 2367, 2415, 3759],
            [3088, 3184, 3808, 2368, 2416, 3760],
            [3089, 3185, 3809, 2369, 2417, 3761],
            [3090, 3186, 3810, 2370, 2418, 3762],
            [3091, 3187, 3811, 2371, 2419, 3763],
            [3092, 3188, 3812, 2372, 2420, 3764],
            [3093, 3189, 3813, 2373, 2421, 3765],
            [3094, 3190, 3814, 2374, 2422, 3766],
            [3095, 3191, 3815, 2375, 2423, 3767],
            [3096, 3192, 3816, 2376, 2424, 3768],
            [3097, 3193, 3817, 2377, 2425, 3769],
            [3098, 3194, 3818, 2378, 2426, 3770],
            [3099, 3195, 3819, 2379, 2427, 3771],
            [3100, 3196, 3820, 2380, 2428, 3772],
            [3101, 3197, 3821, 2381, 2429, 3773],
            [3102, 3198, 3822, 2382, 2430, 3774],
            [3103, 3199, 3823, 2383, 2431, 3775],
            [3104, 3200, 3824, 2384, 2432, 3776],
            [3105, 3201, 3825, 2385, 2433, 3777],
            [3106, 3202, 3826, 2386, 2434, 3778],
            [3107, 3203, 3827, 2387, 2435, 3779],
            [3108, 3204, 3828, 2388, 2436, 3780],
            [3109, 3205, 3829, 2389, 2437, 3781],
            [3110, 3206, 3830, 2390, 2438, 3782],
            [3111, 3207, 3831, 2391, 2439, 3783],
            [3112, 3208, 3832, 2392, 2440, 3784],
            [3113, 3209, 3833, 2393, 2441, 3785],
            [3114, 3210, 3834, 2394, 2442, 3786],
            [3115, 3211, 3835, 2395, 2443, 3787],
            [3116, 3212, 3836, 2396, 2444, 3788],
            [3117, 3213, 3837, 2397, 2445, 3789],
            [3118, 3214, 3838, 2398, 2446, 3790],
            [3119, 3215, 3839, 2399, 2447, 3791],
            [3120, 3216, 3840, 2400, 2448, 3792],
            [3121, 3217, 3841, 2401, 2449, 3793],
            [3122, 3218, 3842, 2402, 2450, 3794],
            [3123, 3219, 3843, 2403, 2451, 3795],
            [3124, 3220, 3844, 2404, 2452, 3796],
            [3125, 3221, 3845, 2405, 2453, 3797],
            [3126, 3222, 3846, 2406, 2454, 3798],
            [3127, 3223, 3847, 2407, 2455, 3799],
            [3128, 3224, 3848, 2408, 2456, 3800],
            [3129, 3225, 3849, 2409, 2457, 3801],
            [3130, 3226, 3850, 2410, 2458, 3802],
            [3131, 3227, 3851, 2411, 2459, 3803],
            [3132, 3228, 3852, 2412, 2460, 3804],
            [3133, 3229, 3853, 2413, 2461, 3805],
            [3134, 3230, 3854, 2414, 2462, 3806],
            [3135, 3231, 3855, 2415, 2463, 3807],
            [3136, 3232, 3856, 2416, 2464, 3808],
            [3137, 3233, 3857, 2417, 2465, 3809],
            [3138, 3234, 3858, 2418, 2466, 3810],
            [3139, 3235, 3859, 2419, 2467, 3811],
            [3140, 3236, 3860, 2420, 2468, 3812],
            [3141, 3237, 3861, 2421, 2469, 3813],
            [3142, 3238, 3862, 2422, 2470, 3814],
            [3143, 3239, 3863, 2423, 2471, 3815],
            [3144, 3240, 3864, 2424, 2472, 3816],
            [3145, 3241, 3865, 2425, 2473, 3817],
            [3146, 3242, 3866, 2426, 2474, 3818],
            [3147, 3243, 3867, 2427, 2475, 3819],
            [3148, 3244, 3868, 2428, 2476, 3820],
            [3149, 3245, 3869, 2429, 2477, 3821],
            [3150, 3246, 3870, 2430, 2478, 3822],
            [3151, 3247, 3871, 2431, 2479, 3823],
            [3152, 3248, 3872, 2432, 2480, 3824],
            [3153, 3249, 3873, 2433, 2481, 3825],
            [3154, 3250, 3874, 2434, 2482, 3826],
            [3155, 3251, 3875, 2435, 2483, 3827],
            [3156, 3252, 3876, 2436, 2484, 3828],
            [3157, 3253, 3877, 2437, 2485, 3829],
            [3158, 3254, 3878, 2438, 2486, 3830],
            [3159, 3255, 3879, 2439, 2487, 3831],
            [3160, 3256, 3880, 2440, 2488, 3832],
            [3161, 3257, 3881, 2441, 2489, 3833],
            [3162, 3258, 3882, 2442, 2490, 3834],
            [3163, 3259, 3883, 2443, 2491, 3835],
            [3164, 3260, 3884, 2444, 2492, 3836],
            [3165, 3261, 3885, 2445, 2493, 3837],
            [3166, 3262, 3886, 2446, 2494, 3838],
            [3167, 3263, 3887, 2447, 2495, 3839],
            [3168, 3264, 3888, 2448, 2496, 3840],
            [3169, 3265, 3889, 2449, 2497, 3841],
            [3170, 3266, 3890, 2450, 2498, 3842],
            [3171, 3267, 3891, 2451, 2499, 3843],
            [3172, 3268, 3892, 2452, 2500, 3844],
            [3173, 3269, 3893, 2453, 2501, 3845],
            [3174, 3270, 3894, 2454, 2502, 3846],
            [3175, 3271, 3895, 2455, 2503, 3847],
            [3176, 3272, 3896, 2456, 2504, 3848],
            [3177, 3273, 3897, 2457, 2505, 3849],
            [3178, 3274, 3898, 2458, 2506, 3850],
            [3179, 3275, 3899, 2459, 2507, 3851],
            [3180, 3276, 3900, 2460, 2508, 3852],
            [3181, 3277, 3901, 2461, 2509, 3853],
            [3182, 3278, 3902, 2462, 2510, 3854],
            [3183, 3279, 3903, 2463, 2511, 3855],
            [3184, 3280, 3904, 2464, 2512, 3856],
            [3185, 3281, 3905, 2465, 2513, 3857],
            [3186, 3282, 3906, 2466, 2514, 3858],
            [3187, 3283, 3907, 2467, 2515, 3859],
            [3188, 3284, 3908, 2468, 2516, 3860],
            [3189, 3285, 3909, 2469, 2517, 3861],
            [3190, 3286, 3910, 2470, 2518, 3862],
            [3191, 3287, 3911, 2471, 2519, 3863],
            [3192, 3288, 3912, 2472, 2520, 3864],
            [3193, 3289, 3913, 2473, 2521, 3865],
            [3194, 3290, 3914, 2474, 2522, 3866],
            [3195, 3291, 3915, 2475, 2523, 3867],
            [3196, 3292, 3916, 2476, 2524, 3868],
            [3197, 3293, 3917, 2477, 2525, 3869],
            [3198, 3294, 3918, 2478, 2526, 3870],
            [3199, 3295, 3919, 2479, 2527, 3871],
            [3200, 3296, 3920, 2480, 2528, 3872],
            [3201, 3297, 3921, 2481, 2529, 3873],
            [3202, 3298, 3922, 2482, 2530, 3874],
            [3203, 3299, 3923, 2483, 2531, 3875],
            [3204, 3300, 3924, 2484, 2532, 3876],
            [3205, 3301, 3925, 2485, 2533, 3877],
            [3206, 3302, 3926, 2486, 2534, 3878],
            [3207, 3303, 3927, 2487, 2535, 3879],
            [3208, 3304, 3928, 2488, 2536, 3880],
            [3209, 3305, 3929, 2489, 2537, 3881],
            [3210, 3306, 3930, 2490, 2538, 3882],
            [3211, 3307, 3931, 2491, 2539, 3883],
            [3212, 3308, 3932, 2492, 2540, 3884],
            [3213, 3309, 3933, 2493, 2541, 3885],
            [3214, 3310, 3934, 2494, 2542, 3886],
            [3215, 3311, 3935, 2495, 2543, 3887],
            [3216, 3312, 3936, 2496, 2544, 3888],
            [3217, 3313, 3937, 2497, 2545, 3889],
            [3218, 3314, 3938, 2498, 2546, 3890],
            [3219, 3315, 3939, 2499, 2547, 3891],
            [3220, 3316, 3940, 2500, 2548, 3892],
            [3221, 3317, 3941, 2501, 2549, 3893],
            [3222, 3318, 3942, 2502, 2550, 3894],
            [3223, 3319, 3943, 2503, 2551, 3895],
            [3224, 3320, 3944, 2504, 2552, 3896],
            [3225, 3321, 3945, 2505, 2553, 3897],
            [3226, 3322, 3946, 2506, 2554, 3898],
            [3227, 3323, 3947, 2507, 2555, 3899],
            [3228, 3324, 3948, 2508, 2556, 3900],
            [3229, 3325, 3949, 2509, 2557, 3901],
            [3230, 3326, 3950, 2510, 2558, 3902],
            [3231, 3327, 3951, 2511, 2559, 3903],
            [3232, 3328, 3952, 2512, 2560, 3904],
            [3233, 3329, 3953, 2513, 2561, 3905],
            [3234, 3330, 3954, 2514, 2562, 3906],
            [3235, 3331, 3955, 2515, 2563, 3907],
            [3236, 3332, 3956, 2516, 2564, 3908],
            [3237, 3333, 3957, 2517, 2565, 3909],
            [3238, 3334, 3958, 2518, 2566, 3910],
            [3239, 3335, 3959, 2519, 2567, 3911],
            [3240, 3336, 3960, 2520, 2568, 3912],
            [3241, 3337, 3961, 2521, 2569, 3913],
            [3242, 3338, 3962, 2522, 2570, 3914],
            [3243, 3339, 3963, 2523, 2571, 3915],
            [3244, 3340, 3964, 2524, 2572, 3916],
            [3245, 3341, 3965, 2525, 2573, 3917],
            [3246, 3342, 3966, 2526, 2574, 3918],
            [3247, 3343, 3967, 2527, 2575, 3919],
            [3248, 3344, 3968, 2528, 2576, 3920],
            [3249, 3345, 3969, 2529, 2577, 3921],
            [3250, 3346, 3970, 2530, 2578, 3922],
            [3251, 3347, 3971, 2531, 2579, 3923],
            [3252, 3348, 3972, 2532, 2580, 3924],
            [3253, 3349, 3973, 2533, 2581, 3925],
            [3254, 3350, 3974, 2534, 2582, 3926],
            [3255, 3351, 3975, 2535, 2583, 3927],
            [3256, 3352, 3976, 2536, 2584, 3928],
            [3257, 3353, 3977, 2537, 2585, 3929],
            [3258, 3354, 3978, 2538, 2586, 3930],
            [3259, 3355, 3979, 2539, 2587, 3931],
            [3260, 3356, 3980, 2540, 2588, 3932],
            [3261, 3357, 3981, 2541, 2589, 3933],
            [3262, 3358, 3982, 2542, 2590, 3934],
            [3263, 3359, 3983, 2543, 2591, 3935],
            [3264, 3360, 3984, 2544, 2592, 3936],
            [3265, 3361, 3985, 2545, 2593, 3937],
            [3266, 3362, 3986, 2546, 2594, 3938],
            [3267, 3363, 3987, 2547, 2595, 3939],
            [3268, 3364, 3988, 2548, 2596, 3940],
            [3269, 3365, 3989, 2549, 2597, 3941],
            [3270, 3366, 3990, 2550, 2598, 3942],
            [3271, 3367, 3991, 2551, 2599, 3943],
            [3272, 3368, 3992, 2552, 2600, 3944],
            [3273, 3369, 3993, 2553, 2601, 3945],
            [3274, 3370, 3994, 2554, 2602, 3946],
            [3275, 3371, 3995, 2555, 2603, 3947],
            [3276, 3372, 3996, 2556, 2604, 3948],
            [3277, 3373, 3997, 2557, 2605, 3949],
            [3278, 3374, 3998, 2558, 2606, 3950],
            [3279, 3375, 3999, 2559, 2607, 3951],
            [3280, 3376, 4000, 2560, 2608, 3952],
            [3281, 3377, 4001, 2561, 2609, 3953],
            [3282, 3378, 4002, 2562, 2610, 3954],
            [3283, 3379, 4003, 2563, 2611, 3955],
            [3284, 3380, 4004, 2564, 2612, 3956],
            [3285, 3381, 4005, 2565, 2613, 3957],
            [3286, 3382, 4006, 2566, 2614, 3958],
            [3287, 3383, 4007, 2567, 2615, 3959],
            [3288, 3384, 4008, 2568, 2616, 3960],
            [3289, 3385, 4009, 2569, 2617, 3961],
            [3290, 3386, 4010, 2570, 2618, 3962],
            [3291, 3387, 4011, 2571, 2619, 3963],
            [3292, 3388, 4012, 2572, 2620, 3964],
            [3293, 3389, 4013, 2573, 2621, 3965],
            [3294, 3390, 4014, 2574, 2622, 3966],
            [3295, 3391, 4015, 2575, 2623, 3967],
            [3296, 3392, 4016, 2576, 2624, 3968],
            [3297, 3393, 4017, 2577, 2625, 3969],
            [3298, 3394, 4018, 2578, 2626, 3970],
            [3299, 3395, 4019, 2579, 2627, 3971],
            [3300, 3396, 4020, 2580, 2628, 3972],
            [3301, 3397, 4021, 2581, 2629, 3973],
            [3302, 3398, 4022, 2582, 2630, 3974],
            [3303, 3399, 4023, 2583, 2631, 3975],
            [3304, 3400, 4024, 2584, 2632, 3976],
            [3305, 3401, 4025, 2585, 2633, 3977],
            [3306, 3402, 4026, 2586, 2634, 3978],
            [3307, 3403, 4027, 2587, 2635, 3979],
            [3308, 3404, 4028, 2588, 2636, 3980],
            [3309, 3405, 4029, 2589, 2637, 3981],
            [3310, 3406, 4030, 2590, 2638, 3982],
            [3311, 3407, 4031, 2591, 2639, 3983],
            [3312, 3408, 4032, 2592, 2640, 3984],
            [3313, 3409, 4033, 2593, 2641, 3985],
            [3314, 3410, 4034, 2594, 2642, 3986],
            [3315, 3411, 4035, 2595, 2643, 3987],
            [3316, 3412, 4036, 2596, 2644, 3988],
            [3317, 3413, 4037, 2597, 2645, 3989],
            [3318, 3414, 4038, 2598, 2646, 3990],
            [3319, 3415, 4039, 2599, 2647, 3991],
            [3320, 3416, 4040, 2600, 2648, 3992],
            [3321, 3417, 4041, 2601, 2649, 3993],
            [3322, 3418, 4042, 2602, 2650, 3994],
            [3323, 3419, 4043, 2603, 2651, 3995],
            [3324, 3420, 4044, 2604, 2652, 3996],
            [3325, 3421, 4045, 2605, 2653, 3997],
            [3326, 3422, 4046, 2606, 2654, 3998],
            [3327, 3423, 4047, 2607, 2655, 3999],
            [3328, 3424, 4048, 2608, 2656, 4000],
            [3329, 3425, 4049, 2609, 2657, 4001],
            [3330, 3426, 4050, 2610, 2658, 4002],
            [3331, 3427, 4051, 2611, 2659, 4003],
            [3332, 3428, 4052, 2612, 2660, 4004],
            [3333, 3429, 4053, 2613, 2661, 4005],
            [3334, 3430, 4054, 2614, 2662, 4006],
            [3335, 3431, 4055, 2615, 2663, 4007],
            [3336, 3432, 4056, 2616, 2664, 4008],
            [3337, 3433, 4057, 2617, 2665, 4009],
            [3338, 3434, 4058, 2618, 2666, 4010],
            [3339, 3435, 4059, 2619, 2667, 4011],
            [3340, 3436, 4060, 2620, 2668, 4012],
            [3341, 3437, 4061, 2621, 2669, 4013],
            [3342, 3438, 4062, 2622, 2670, 4014],
            [3343, 3439, 4063, 2623, 2671, 4015],
            [3344, 3440, 4064, 2624, 2672, 4016],
            [3345, 3441, 4065, 2625, 2673, 4017],
            [3346, 3442, 4066, 2626, 2674, 4018],
            [3347, 3443, 4067, 2627, 2675, 4019],
            [3348, 3444, 4068, 2628, 2676, 4020],
            [3349, 3445, 4069, 2629, 2677, 4021],
            [3350, 3446, 4070, 2630, 2678, 4022],
            [3351, 3447, 4071, 2631, 2679, 4023],
            [3352, 3448, 4072, 2632, 2680, 4024],
            [3353, 3449, 4073, 2633, 2681, 4025],
            [3354, 3450, 4074, 2634, 2682, 4026],
            [3355, 3451, 4075, 2635, 2683, 4027],
            [3356, 3452, 4076, 2636, 2684, 4028],
            [3357, 3453, 4077, 2637, 2685, 4029],
            [3358, 3454, 4078, 2638, 2686, 4030],
            [3359, 3455, 4079, 2639, 2687, 4031],
            [3360, 3456, 4080, 2640, 2688, 4032],
            [3361, 3457, 4081, 2641, 2689, 4033],
            [3362, 586, 610, 2642, 2690, 4034],
            [3363, 587, 611, 2643, 2691, 4035],
            [3364, 588, 612, 2644, 2692, 4036],
            [3365, 589, 613, 2645, 2693, 4037],
            [3366, 590, 614, 2646, 2694, 4038],
            [3367, 591, 615, 2647, 2695, 4039],
            [3368, 592, 616, 2648, 2696, 4040],
            [3369, 593, 617, 2649, 2697, 4041],
            [3370, 578, 602, 2650, 2698, 4042],
            [3371, 579, 603, 2651, 2699, 4043],
            [3372, 580, 604, 2652, 2700, 4044],
            [3373, 581, 605, 2653, 2701, 4045],
            [3374, 582, 606, 2654, 2702, 4046],
            [3375, 583, 607, 2655, 2703, 4047],
            [3376, 584, 608, 2656, 2704, 4048],
            [3377, 585, 609, 2657, 2705, 4049],
            [3378, 594, 618, 2658, 2706, 4050],
            [3379, 595, 619, 2659, 2707, 4051],
            [3380, 596, 620, 2660, 2708, 4052],
            [3381, 597, 621, 2661, 2709, 4053],
            [3382, 598, 622, 2662, 2710, 4054],
            [3383, 599, 623, 2663, 2711, 4055],
            [3384, 600, 624, 2664, 2712, 4056],
            [3385, 601, 625, 2665, 2713, 4057],
            [3386, 594, 618, 2666, 2714, 4058],
            [3387, 595, 619, 2667, 2715, 4059],
            [3388, 596, 620, 2668, 2716, 4060],
            [3389, 597, 621, 2669, 2717, 4061],
            [3390, 598, 622, 2670, 2718, 4062],
            [3391, 599, 623, 2671, 2719, 4063],
            [3392, 600, 624, 2672, 2720, 4064],
            [3393, 601, 625, 2673, 2721, 4065],
            [3394, 578, 602, 2674, 2722, 4066],
            [3395, 579, 603, 2675, 2723, 4067],
            [3396, 580, 604, 2676, 2724, 4068],
            [3397, 581, 605, 2677, 2725, 4069],
            [3398, 582, 606, 2678, 2726, 4070],
            [3399, 583, 607, 2679, 2727, 4071],
            [3400, 584, 608, 2680, 2728, 4072],
            [3401, 585, 609, 2681, 2729, 4073],
            [3402, 586, 610, 2682, 2730, 4074],
            [3403, 587, 611, 2683, 2731, 4075],
            [3404, 588, 612, 2684, 2732, 4076],
            [3405, 589, 613, 2685, 2733, 4077],
            [3406, 590, 614, 2686, 2734, 4078],
            [3407, 591, 615, 2687, 2735, 4079],
            [3408, 592, 616, 2688, 2736, 4080],
            [3409, 593, 617, 2689, 2737, 4081],
            [850, 3506, 2786, 874, 2834, 3460],
            [851, 3507, 2787, 875, 2835, 3461],
            [850, 3508, 2788, 874, 2836, 3458],
            [851, 3509, 2789, 875, 2837, 3459],
            [852, 3510, 2790, 876, 2838, 3464],
            [853, 3511, 2791, 877, 2839, 3465],
            [852, 3512, 2792, 876, 2840, 3462],
            [853, 3513, 2793, 877, 2841, 3463],
            [842, 3514, 2794, 866, 2842, 3470],
            [843, 3515, 2795, 867, 2843, 3471],
            [844, 3516, 2796, 868, 2844, 3472],
            [845, 3517, 2797, 869, 2845, 3473],
            [842, 3518, 2798, 866, 2846, 3466],
            [843, 3519, 2799, 867, 2847, 3467],
            [844, 3520, 2800, 868, 2848, 3468],
            [845, 3521, 2801, 869, 2849, 3469],
            [858, 3522, 2802, 882, 2850, 3475],
            [858, 3523, 2803, 882, 2851, 3474],
            [859, 3524, 2804, 883, 2852, 3477],
            [859, 3525, 2805, 883, 2853, 3476],
            [860, 3526, 2806, 884, 2854, 3479],
            [860, 3527, 2807, 884, 2855, 3478],
            [861, 3528, 2808, 885, 2856, 3481],
            [861, 3529, 2809, 885, 2857, 3480],
            [862, 3530, 2810, 886, 2858, 3483],
            [862, 3531, 2811, 886, 2859, 3482],
            [863, 3532, 2812, 887, 2860, 3485],
            [863, 3533, 2813, 887, 2861, 3484],
            [864, 3534, 2814, 888, 2862, 3487],
            [864, 3535, 2815, 888, 2863, 3486],
            [865, 3536, 2816, 889, 2864, 3489],
            [865, 3537, 2817, 889, 2865, 3488],
            [846, 3538, 2818, 870, 2866, 3494],
            [847, 3539, 2819, 871, 2867, 3495],
            [848, 3540, 2820, 872, 2868, 3496],
            [849, 3541, 2821, 873, 2869, 3497],
            [846, 3542, 2822, 870, 2870, 3490],
            [847, 3543, 2823, 871, 2871, 3491],
            [848, 3544, 2824, 872, 2872, 3492],
            [849, 3545, 2825, 873, 2873, 3493],
            [854, 3546, 2826, 878, 2874, 3500],
            [855, 3547, 2827, 879, 2875, 3501],
            [854, 3548, 2828, 878, 2876, 3498],
            [855, 3549, 2829, 879, 2877, 3499],
            [856, 3550, 2830, 880, 2878, 3504],
            [857, 3551, 2831, 881, 2879, 3505],
            [856, 3552, 2832, 880, 2880, 3502],
            [857, 3553, 2833, 881, 2881, 3503],
            [3458, 3554, 2834, 4082, 2882, 874],
            [3459, 3555, 2835, 4083, 2883, 875],
            [3460, 3556, 2836, 4084, 2884, 874],
            [3461, 3557, 2837, 4085, 2885, 875],
            [3462, 3558, 2838, 4086, 2886, 876],
            [3463, 3559, 2839, 4087, 2887, 877],
            [3464, 3560, 2840, 4088, 2888, 876],
            [3465, 3561, 2841, 4089, 2889, 877],
            [3466, 3562, 2842, 4090, 2890, 866],
            [3467, 3563, 2843, 4091, 2891, 867],
            [3468, 3564, 2844, 4092, 2892, 868],
            [3469, 3565, 2845, 4093, 2893, 869],
            [3470, 3566, 2846, 4094, 2894, 866],
            [3471, 3567, 2847, 4095, 2895, 867],
            [3472, 3568, 2848, 4096, 2896, 868],
            [3473, 3569, 2849, 4097, 2897, 869],
            [3474, 3570, 2850, 4098, 2898, 882],
            [3475, 3571, 2851, 4099, 2899, 882],
            [3476, 3572, 2852, 4100, 2900, 883],
            [3477, 3573, 2853, 4101, 2901, 883],
            [3478, 3574, 2854, 4102, 2902, 884],
            [3479, 3575, 2855, 4103, 2903, 884],
            [3480, 3576, 2856, 4104, 2904, 885],
            [3481, 3577, 2857, 4105, 2905, 885],
            [3482, 3578, 2858, 4106, 2906, 886],
            [3483, 3579, 2859, 4107, 2907, 886],
            [3484, 3580, 2860, 4108, 2908, 887],
            [3485, 3581, 2861, 4109, 2909, 887],
            [3486, 3582, 2862, 4110, 2910, 888],
            [3487, 3583, 2863, 4111, 2911, 888],
            [3488, 3584, 2864, 4112, 2912, 889],
            [3489, 3585, 2865, 4113, 2913, 889],
            [3490, 3586, 2866, 4114, 2914, 870],
            [3491, 3587, 2867, 4115, 2915, 871],
            [3492, 3588, 2868, 4116, 2916, 872],
            [3493, 3589, 2869, 4117, 2917, 873],
            [3494, 3590, 2870, 4118, 2918, 870],
            [3495, 3591, 2871, 4119, 2919, 871],
            [3496, 3592, 2872, 4120, 2920, 872],
            [3497, 3593, 2873, 4121, 2921, 873],
            [3498, 3594, 2874, 4122, 2922, 878],
            [3499, 3595, 2875, 4123, 2923, 879],
            [3500, 3596, 2876, 4124, 2924, 878],
            [3501, 3597, 2877, 4125, 2925, 879],
            [3502, 3598, 2878, 4126, 2926, 880],
            [3503, 3599, 2879, 4127, 2927, 881],
            [3504, 3600, 2880, 4128, 2928, 880],
            [3505, 3601, 2881, 4129, 2929, 881],
            [3506, 3602, 2882, 4130, 2930, 4082],
            [3507, 3603, 2883, 4131, 2931, 4083],
            [3508, 3604, 2884, 4132, 2932, 4084],
            [3509, 3605, 2885, 4133, 2933, 4085],
            [3510, 3606, 2886, 4134, 2934, 4086],
            [3511, 3607, 2887, 4135, 2935, 4087],
            [3512, 3608, 2888, 4136, 2936, 4088],
            [3513, 3609, 2889, 4137, 2937, 4089],
            [3514, 3610, 2890, 4138, 2938, 4090],
            [3515, 3611, 2891, 4139, 2939, 4091],
            [3516, 3612, 2892, 4140, 2940, 4092],
            [3517, 3613, 2893, 4141, 2941, 4093],
            [3518, 3614, 2894, 4142, 2942, 4094],
            [3519, 3615, 2895, 4143, 2943, 4095],
            [3520, 3616, 2896, 4144, 2944, 4096],
            [3521, 3617, 2897, 4145, 2945, 4097],
            [3522, 3618, 2898, 4146, 2946, 4098],
            [3523, 3619, 2899, 4147, 2947, 4099],
            [3524, 3620, 2900, 4148, 2948, 4100],
            [3525, 3621, 2901, 4149, 2949, 4101],
            [3526, 3622, 2902, 4150, 2950, 4102],
            [3527, 3623, 2903, 4151, 2951, 4103],
            [3528, 3624, 2904, 4152, 2952, 4104],
            [3529, 3625, 2905, 4153, 2953, 4105],
            [3530, 3626, 2906, 4154, 2954, 4106],
            [3531, 3627, 2907, 4155, 2955, 4107],
            [3532, 3628, 2908, 4156, 2956, 4108],
            [3533, 3629, 2909, 4157, 2957, 4109],
            [3534, 3630, 2910, 4158, 2958, 4110],
            [3535, 3631, 2911, 4159, 2959, 4111],
            [3536, 3632, 2912, 4160, 2960, 4112],
            [3537, 3633, 2913, 4161, 2961, 4113],
            [3538, 3634, 2914, 4162, 2962, 4114],
            [3539, 3635, 2915, 4163, 2963, 4115],
            [3540, 3636, 2916, 4164, 2964, 4116],
            [3541, 3637, 2917, 4165, 2965, 4117],
            [3542, 3638, 2918, 4166, 2966, 4118],
            [3543, 3639, 2919, 4167, 2967, 4119],
            [3544, 3640, 2920, 4168, 2968, 4120],
            [3545, 3641, 2921, 4169, 2969, 4121],
            [3546, 3642, 2922, 4170, 2970, 4122],
            [3547, 3643, 2923, 4171, 2971, 4123],
            [3548, 3644, 2924, 4172, 2972, 4124],
            [3549, 3645, 2925, 4173, 2973, 4125],
            [3550, 3646, 2926, 4174, 2974, 4126],
            [3551, 3647, 2927, 4175, 2975, 4127],
            [3552, 3648, 2928, 4176, 2976, 4128],
            [3553, 3649, 2929, 4177, 2977, 4129],
            [3554, 3650, 2930, 4178, 2978, 4130],
            [3555, 3651, 2931, 4179, 2979, 4131],
            [3556, 3652, 2932, 4180, 2980, 4132],
            [3557, 3653, 2933, 4181, 2981, 4133],
            [3558, 3654, 2934, 4182, 2982, 4134],
            [3559, 3655, 2935, 4183, 2983, 4135],
            [3560, 3656, 2936, 4184, 2984, 4136],
            [3561, 3657, 2937, 4185, 2985, 4137],
            [3562, 3658, 2938, 4186, 2986, 4138],
            [3563, 3659, 2939, 4187, 2987, 4139],
            [3564, 3660, 2940, 4188, 2988, 4140],
            [3565, 3661, 2941, 4189, 2989, 4141],
            [3566, 3662, 2942, 4190, 2990, 4142],
            [3567, 3663, 2943, 4191, 2991, 4143],
            [3568, 3664, 2944, 4192, 2992, 4144],
            [3569, 3665, 2945, 4193, 2993, 4145],
            [3570, 3666, 2946, 4194, 2994, 4146],
            [3571, 3667, 2947, 4195, 2995, 4147],
            [3572, 3668, 2948, 4196, 2996, 4148],
            [3573, 3669, 2949, 4197, 2997, 4149],
            [3574, 3670, 2950, 4198, 2998, 4150],
            [3575, 3671, 2951, 4199, 2999, 4151],
            [3576, 3672, 2952, 4200, 3000, 4152],
            [3577, 3673, 2953, 4201, 3001, 4153],
            [3578, 3674, 2954, 4202, 3002, 4154],
            [3579, 3675, 2955, 4203, 3003, 4155],
            [3580, 3676, 2956, 4204, 3004, 4156],
            [3581, 3677, 2957, 4205, 3005, 4157],
            [3582, 3678, 2958, 4206, 3006, 4158],
            [3583, 3679, 2959, 4207, 3007, 4159],
            [3584, 3680, 2960, 4208, 3008, 4160],
            [3585, 3681, 2961, 4209, 3009, 4161],
            [3586, 3682, 2962, 4210, 3010, 4162],
            [3587, 3683, 2963, 4211, 3011, 4163],
            [3588, 3684, 2964, 4212, 3012, 4164],
            [3589, 3685, 2965, 4213, 3013, 4165],
            [3590, 3686, 2966, 4214, 3014, 4166],
            [3591, 3687, 2967, 4215, 3015, 4167],
            [3592, 3688, 2968, 4216, 3016, 4168],
            [3593, 3689, 2969, 4217, 3017, 4169],
            [3594, 3690, 2970, 4218, 3018, 4170],
            [3595, 3691, 2971, 4219, 3019, 4171],
            [3596, 3692, 2972, 4220, 3020, 4172],
            [3597, 3693, 2973, 4221, 3021, 4173],
            [3598, 3694, 2974, 4222, 3022, 4174],
            [3599, 3695, 2975, 4223, 3023, 4175],
            [3600, 3696, 2976, 4224, 3024, 4176],
            [3601, 3697, 2977, 4225, 3025, 4177],
            [3602, 3698, 4226, 2978, 3026, 4178],
            [3603, 3699, 4227, 2979, 3027, 4179],
            [3604, 3700, 4228, 2980, 3028, 4180],
            [3605, 3701, 4229, 2981, 3029, 4181],
            [3606, 3702, 4230, 2982, 3030, 4182],
            [3607, 3703, 4231, 2983, 3031, 4183],
            [3608, 3704, 4232, 2984, 3032, 4184],
            [3609, 3705, 4233, 2985, 3033, 4185],
            [3610, 3706, 4234, 2986, 3034, 4186],
            [3611, 3707, 4235, 2987, 3035, 4187],
            [3612, 3708, 4236, 2988, 3036, 4188],
            [3613, 3709, 4237, 2989, 3037, 4189],
            [3614, 3710, 4238, 2990, 3038, 4190],
            [3615, 3711, 4239, 2991, 3039, 4191],
            [3616, 3712, 4240, 2992, 3040, 4192],
            [3617, 3713, 4241, 2993, 3041, 4193],
            [3618, 3714, 4242, 2994, 3042, 4194],
            [3619, 3715, 4243, 2995, 3043, 4195],
            [3620, 3716, 4244, 2996, 3044, 4196],
            [3621, 3717, 4245, 2997, 3045, 4197],
            [3622, 3718, 4246, 2998, 3046, 4198],
            [3623, 3719, 4247, 2999, 3047, 4199],
            [3624, 3720, 4248, 3000, 3048, 4200],
            [3625, 3721, 4249, 3001, 3049, 4201],
            [3626, 3722, 4250, 3002, 3050, 4202],
            [3627, 3723, 4251, 3003, 3051, 4203],
            [3628, 3724, 4252, 3004, 3052, 4204],
            [3629, 3725, 4253, 3005, 3053, 4205],
            [3630, 3726, 4254, 3006, 3054, 4206],
            [3631, 3727, 4255, 3007, 3055, 4207],
            [3632, 3728, 4256, 3008, 3056, 4208],
            [3633, 3729, 4257, 3009, 3057, 4209],
            [3634, 3730, 4258, 3010, 3058, 4210],
            [3635, 3731, 4259, 3011, 3059, 4211],
            [3636, 3732, 4260, 3012, 3060, 4212],
            [3637, 3733, 4261, 3013, 3061, 4213],
            [3638, 3734, 4262, 3014, 3062, 4214],
            [3639, 3735, 4263, 3015, 3063, 4215],
            [3640, 3736, 4264, 3016, 3064, 4216],
            [3641, 3737, 4265, 3017, 3065, 4217],
            [3642, 3738, 4266, 3018, 3066, 4218],
            [3643, 3739, 4267, 3019, 3067, 4219],
            [3644, 3740, 4268, 3020, 3068, 4220],
            [3645, 3741, 4269, 3021, 3069, 4221],
            [3646, 3742, 4270, 3022, 3070, 4222],
            [3647, 3743, 4271, 3023, 3071, 4223],
            [3648, 3744, 4272, 3024, 3072, 4224],
            [3649, 3745, 4273, 3025, 3073, 4225],
            [3650, 3746, 4274, 3026, 3074, 4226],
            [3651, 3747, 4275, 3027, 3075, 4227],
            [3652, 3748, 4276, 3028, 3076, 4228],
            [3653, 3749, 4277, 3029, 3077, 4229],
            [3654, 3750, 4278, 3030, 3078, 4230],
            [3655, 3751, 4279, 3031, 3079, 4231],
            [3656, 3752, 4280, 3032, 3080, 4232],
            [3657, 3753, 4281, 3033, 3081, 4233],
            [3658, 3754, 4282, 3034, 3082, 4234],
            [3659, 3755, 4283, 3035, 3083, 4235],
            [3660, 3756, 4284, 3036, 3084, 4236],
            [3661, 3757, 4285, 3037, 3085, 4237],
            [3662, 3758, 4286, 3038, 3086, 4238],
            [3663, 3759, 4287, 3039, 3087, 4239],
            [3664, 3760, 4288, 3040, 3088, 4240],
            [3665, 3761, 4289, 3041, 3089, 4241],
            [3666, 3762, 4290, 3042, 3090, 4242],
            [3667, 3763, 4291, 3043, 3091, 4243],
            [3668, 3764, 4292, 3044, 3092, 4244],
            [3669, 3765, 4293, 3045, 3093, 4245],
            [3670, 3766, 4294, 3046, 3094, 4246],
            [3671, 3767, 4295, 3047, 3095, 4247],
            [3672, 3768, 4296, 3048, 3096, 4248],
            [3673, 3769, 4297, 3049, 3097, 4249],
            [3674, 3770, 4298, 3050, 3098, 4250],
            [3675, 3771, 4299, 3051, 3099, 4251],
            [3676, 3772, 4300, 3052, 3100, 4252],
            [3677, 3773, 4301, 3053, 3101, 4253],
            [3678, 3774, 4302, 3054, 3102, 4254],
            [3679, 3775, 4303, 3055, 3103, 4255],
            [3680, 3776, 4304, 3056, 3104, 4256],
            [3681, 3777, 4305, 3057, 3105, 4257],
            [3682, 3778, 4306, 3058, 3106, 4258],
            [3683, 3779, 4307, 3059, 3107, 4259],
            [3684, 3780, 4308, 3060, 3108, 4260],
            [3685, 3781, 4309, 3061, 3109, 4261],
            [3686, 3782, 4310, 3062, 3110, 4262],
            [3687, 3783, 4311, 3063, 3111, 4263],
            [3688, 3784, 4312, 3064, 3112, 4264],
            [3689, 3785, 4313, 3065, 3113, 4265],
            [3690, 3786, 4314, 3066, 3114, 4266],
            [3691, 3787, 4315, 3067, 3115, 4267],
            [3692, 3788, 4316, 3068, 3116, 4268],
            [3693, 3789, 4317, 3069, 3117, 4269],
            [3694, 3790, 4318, 3070, 3118, 4270],
            [3695, 3791, 4319, 3071, 3119, 4271],
            [3696, 3792, 4320, 3072, 3120, 4272],
            [3697, 3793, 4321, 3073, 3121, 4273],
            [3698, 3794, 4322, 3074, 3122, 4274],
            [3699, 3795, 4323, 3075, 3123, 4275],
            [3700, 3796, 4324, 3076, 3124, 4276],
            [3701, 3797, 4325, 3077, 3125, 4277],
            [3702, 3798, 4326, 3078, 3126, 4278],
            [3703, 3799, 4327, 3079, 3127, 4279],
            [3704, 3800, 4328, 3080, 3128, 4280],
            [3705, 3801, 4329, 3081, 3129, 4281],
            [3706, 3802, 4330, 3082, 3130, 4282],
            [3707, 3803, 4331, 3083, 3131, 4283],
            [3708, 3804, 4332, 3084, 3132, 4284],
            [3709, 3805, 4333, 3085, 3133, 4285],
            [3710, 3806, 4334, 3086, 3134, 4286],
            [3711, 3807, 4335, 3087, 3135, 4287],
            [3712, 3808, 4336, 3088, 3136, 4288],
            [3713, 3809, 4337, 3089, 3137, 4289],
            [3714, 3810, 4338, 3090, 3138, 4290],
            [3715, 3811, 4339, 3091, 3139, 4291],
            [3716, 3812, 4340, 3092, 3140, 4292],
            [3717, 3813, 4341, 3093, 3141, 4293],
            [3718, 3814, 4342, 3094, 3142, 4294],
            [3719, 3815, 4343, 3095, 3143, 4295],
            [3720, 3816, 4344, 3096, 3144, 4296],
            [3721, 3817, 4345, 3097, 3145, 4297],
            [3722, 3818, 4346, 3098, 3146, 4298],
            [3723, 3819, 4347, 3099, 3147, 4299],
            [3724, 3820, 4348, 3100, 3148, 4300],
            [3725, 3821, 4349, 3101, 3149, 4301],
            [3726, 3822, 4350, 3102, 3150, 4302],
            [3727, 3823, 4351, 3103, 3151, 4303],
            [3728, 3824, 4352, 3104, 3152, 4304],
            [3729, 3825, 4353, 3105, 3153, 4305],
            [3730, 3826, 4354, 3106, 3154, 4306],
            [3731, 3827, 4355, 3107, 3155, 4307],
            [3732, 3828, 4356, 3108, 3156, 4308],
            [3733, 3829, 4357, 3109, 3157, 4309],
            [3734, 3830, 4358, 3110, 3158, 4310],
            [3735, 3831, 4359, 3111, 3159, 4311],
            [3736, 3832, 4360, 3112, 3160, 4312],
            [3737, 3833, 4361, 3113, 3161, 4313],
            [3738, 3834, 4362, 3114, 3162, 4314],
            [3739, 3835, 4363, 3115, 3163, 4315],
            [3740, 3836, 4364, 3116, 3164, 4316],
            [3741, 3837, 4365, 3117, 3165, 4317],
            [3742, 3838, 4366, 3118, 3166, 4318],
            [3743, 3839, 4367, 3119, 3167, 4319],
            [3744, 3840, 4368, 3120, 3168, 4320],
            [3745, 3841, 4369, 3121, 3169, 4321],
            [3746, 3842, 4370, 3122, 3170, 4322],
            [3747, 3843, 4371, 3123, 3171, 4323],
            [3748, 3844, 4372, 3124, 3172, 4324],
            [3749, 3845, 4373, 3125, 3173, 4325],
            [3750, 3846, 4374, 3126, 3174, 4326],
            [3751, 3847, 4375, 3127, 3175, 4327],
            [3752, 3848, 4376, 3128, 3176, 4328],
            [3753, 3849, 4377, 3129, 3177, 4329],
            [3754, 3850, 4378, 3130, 3178, 4330],
            [3755, 3851, 4379, 3131, 3179, 4331],
            [3756, 3852, 4380, 3132, 3180, 4332],
            [3757, 3853, 4381, 3133, 3181, 4333],
            [3758, 3854, 4382, 3134, 3182, 4334],
            [3759, 3855, 4383, 3135, 3183, 4335],
            [3760, 3856, 4384, 3136, 3184, 4336],
            [3761, 3857, 4385, 3137, 3185, 4337],
            [3762, 3858, 4386, 3138, 3186, 4338],
            [3763, 3859, 4387, 3139, 3187, 4339],
            [3764, 3860, 4388, 3140, 3188, 4340],
            [3765, 3861, 4389, 3141, 3189, 4341],
            [3766, 3862, 4390, 3142, 3190, 4342],
            [3767, 3863, 4391, 3143, 3191, 4343],
            [3768, 3864, 4392, 3144, 3192, 4344],
            [3769, 3865, 4393, 3145, 3193, 4345],
            [3770, 3866, 4394, 3146, 3194, 4346],
            [3771, 3867, 4395, 3147, 3195, 4347],
            [3772, 3868, 4396, 3148, 3196, 4348],
            [3773, 3869, 4397, 3149, 3197, 4349],
            [3774, 3870, 4398, 3150, 3198, 4350],
            [3775, 3871, 4399, 3151, 3199, 4351],
            [3776, 3872, 4400, 3152, 3200, 4352],
            [3777, 3873, 4401, 3153, 3201, 4353],
            [3778, 3874, 4402, 3154, 3202, 4354],
            [3779, 3875, 4403, 3155, 3203, 4355],
            [3780, 3876, 4404, 3156, 3204, 4356],
            [3781, 3877, 4405, 3157, 3205, 4357],
            [3782, 3878, 4406, 3158, 3206, 4358],
            [3783, 3879, 4407, 3159, 3207, 4359],
            [3784, 3880, 4408, 3160, 3208, 4360],
            [3785, 3881, 4409, 3161, 3209, 4361],
            [3786, 3882, 4410, 3162, 3210, 4362],
            [3787, 3883, 4411, 3163, 3211, 4363],
            [3788, 3884, 4412, 3164, 3212, 4364],
            [3789, 3885, 4413, 3165, 3213, 4365],
            [3790, 3886, 4414, 3166, 3214, 4366],
            [3791, 3887, 4415, 3167, 3215, 4367],
            [3792, 3888, 4416, 3168, 3216, 4368],
            [3793, 3889, 4417, 3169, 3217, 4369],
            [3794, 3890, 4418, 3170, 3218, 4370],
            [3795, 3891, 4419, 3171, 3219, 4371],
            [3796, 3892, 4420, 3172, 3220, 4372],
            [3797, 3893, 4421, 3173, 3221, 4373],
            [3798, 3894, 4422, 3174, 3222, 4374],
            [3799, 3895, 4423, 3175, 3223, 4375],
            [3800, 3896, 4424, 3176, 3224, 4376],
            [3801, 3897, 4425, 3177, 3225, 4377],
            [3802, 3898, 4426, 3178, 3226, 4378],
            [3803, 3899, 4427, 3179, 3227, 4379],
            [3804, 3900, 4428, 3180, 3228, 4380],
            [3805, 3901, 4429, 3181, 3229, 4381],
            [3806, 3902, 4430, 3182, 3230, 4382],
            [3807, 3903, 4431, 3183, 3231, 4383],
            [3808, 3904, 4432, 3184, 3232, 4384],
            [3809, 3905, 4433, 3185, 3233, 4385],
            [3810, 3906, 4434, 3186, 3234, 4386],
            [3811, 3907, 4435, 3187, 3235, 4387],
            [3812, 3908, 4436, 3188, 3236, 4388],
            [3813, 3909, 4437, 3189, 3237, 4389],
            [3814, 3910, 4438, 3190, 3238, 4390],
            [3815, 3911, 4439, 3191, 3239, 4391],
            [3816, 3912, 4440, 3192, 3240, 4392],
            [3817, 3913, 4441, 3193, 3241, 4393],
            [3818, 3914, 4442, 3194, 3242, 4394],
            [3819, 3915, 4443, 3195, 3243, 4395],
            [3820, 3916, 4444, 3196, 3244, 4396],
            [3821, 3917, 4445, 3197, 3245, 4397],
            [3822, 3918, 4446, 3198, 3246, 4398],
            [3823, 3919, 4447, 3199, 3247, 4399],
            [3824, 3920, 4448, 3200, 3248, 4400],
            [3825, 3921, 4449, 3201, 3249, 4401],
            [3826, 3922, 4450, 3202, 3250, 4402],
            [3827, 3923, 4451, 3203, 3251, 4403],
            [3828, 3924, 4452, 3204, 3252, 4404],
            [3829, 3925, 4453, 3205, 3253, 4405],
            [3830, 3926, 4454, 3206, 3254, 4406],
            [3831, 3927, 4455, 3207, 3255, 4407],
            [3832, 3928, 4456, 3208, 3256, 4408],
            [3833, 3929, 4457, 3209, 3257, 4409],
            [3834, 3930, 4458, 3210, 3258, 4410],
            [3835, 3931, 4459, 3211, 3259, 4411],
            [3836, 3932, 4460, 3212, 3260, 4412],
            [3837, 3933, 4461, 3213, 3261, 4413],
            [3838, 3934, 4462, 3214, 3262, 4414],
            [3839, 3935, 4463, 3215, 3263, 4415],
            [3840, 3936, 4464, 3216, 3264, 4416],
            [3841, 3937, 4465, 3217, 3265, 4417],
            [3842, 3938, 4466, 3218, 3266, 4418],
            [3843, 3939, 4467, 3219, 3267, 4419],
            [3844, 3940, 4468, 3220, 3268, 4420],
            [3845, 3941, 4469, 3221, 3269, 4421],
            [3846, 3942, 4470, 3222, 3270, 4422],
            [3847, 3943, 4471, 3223, 3271, 4423],
            [3848, 3944, 4472, 3224, 3272, 4424],
            [3849, 3945, 4473, 3225, 3273, 4425],
            [3850, 3946, 4474, 3226, 3274, 4426],
            [3851, 3947, 4475, 3227, 3275, 4427],
            [3852, 3948, 4476, 3228, 3276, 4428],
            [3853, 3949, 4477, 3229, 3277, 4429],
            [3854, 3950, 4478, 3230, 3278, 4430],
            [3855, 3951, 4479, 3231, 3279, 4431],
            [3856, 3952, 4480, 3232, 3280, 4432],
            [3857, 3953, 4481, 3233, 3281, 4433],
            [3858, 3954, 4482, 3234, 3282, 4434],
            [3859, 3955, 4483, 3235, 3283, 4435],
            [3860, 3956, 4484, 3236, 3284, 4436],
            [3861, 3957, 4485, 3237, 3285, 4437],
            [3862, 3958, 4486, 3238, 3286, 4438],
            [3863, 3959, 4487, 3239, 3287, 4439],
            [3864, 3960, 4488, 3240, 3288, 4440],
            [3865, 3961, 4489, 3241, 3289, 4441],
            [3866, 3962, 4490, 3242, 3290, 4442],
            [3867, 3963, 4491, 3243, 3291, 4443],
            [3868, 3964, 4492, 3244, 3292, 4444],
            [3869, 3965, 4493, 3245, 3293, 4445],
            [3870, 3966, 4494, 3246, 3294, 4446],
            [3871, 3967, 4495, 3247, 3295, 4447],
            [3872, 3968, 4496, 3248, 3296, 4448],
            [3873, 3969, 4497, 3249, 3297, 4449],
            [3874, 3970, 4498, 3250, 3298, 4450],
            [3875, 3971, 4499, 3251, 3299, 4451],
            [3876, 3972, 4500, 3252, 3300, 4452],
            [3877, 3973, 4501, 3253, 3301, 4453],
            [3878, 3974, 4502, 3254, 3302, 4454],
            [3879, 3975, 4503, 3255, 3303, 4455],
            [3880, 3976, 4504, 3256, 3304, 4456],
            [3881, 3977, 4505, 3257, 3305, 4457],
            [3882, 3978, 4506, 3258, 3306, 4458],
            [3883, 3979, 4507, 3259, 3307, 4459],
            [3884, 3980, 4508, 3260, 3308, 4460],
            [3885, 3981, 4509, 3261, 3309, 4461],
            [3886, 3982, 4510, 3262, 3310, 4462],
            [3887, 3983, 4511, 3263, 3311, 4463],
            [3888, 3984, 4512, 3264, 3312, 4464],
            [3889, 3985, 4513, 3265, 3313, 4465],
            [3890, 3986, 4514, 3266, 3314, 4466],
            [3891, 3987, 4515, 3267, 3315, 4467],
            [3892, 3988, 4516, 3268, 3316, 4468],
            [3893, 3989, 4517, 3269, 3317, 4469],
            [3894, 3990, 4518, 3270, 3318, 4470],
            [3895, 3991, 4519, 3271, 3319, 4471],
            [3896, 3992, 4520, 3272, 3320, 4472],
            [3897, 3993, 4521, 3273, 3321, 4473],
            [3898, 3994, 4522, 3274, 3322, 4474],
            [3899, 3995, 4523, 3275, 3323, 4475],
            [3900, 3996, 4524, 3276, 3324, 4476],
            [3901, 3997, 4525, 3277, 3325, 4477],
            [3902, 3998, 4526, 3278, 3326, 4478],
            [3903, 3999, 4527, 3279, 3327, 4479],
            [3904, 4000, 4528, 3280, 3328, 4480],
            [3905, 4001, 4529, 3281, 3329, 4481],
            [3906, 4002, 4530, 3282, 3330, 4482],
            [3907, 4003, 4531, 3283, 3331, 4483],
            [3908, 4004, 4532, 3284, 3332, 4484],
            [3909, 4005, 4533, 3285, 3333, 4485],
            [3910, 4006, 4534, 3286, 3334, 4486],
            [3911, 4007, 4535, 3287, 3335, 4487],
            [3912, 4008, 4536, 3288, 3336, 4488],
            [3913, 4009, 4537, 3289, 3337, 4489],
            [3914, 4010, 4538, 3290, 3338, 4490],
            [3915, 4011, 4539, 3291, 3339, 4491],
            [3916, 4012, 4540, 3292, 3340, 4492],
            [3917, 4013, 4541, 3293, 3341, 4493],
            [3918, 4014, 4542, 3294, 3342, 4494],
            [3919, 4015, 4543, 3295, 3343, 4495],
            [3920, 4016, 4544, 3296, 3344, 4496],
            [3921, 4017, 4545, 3297, 3345, 4497],
            [3922, 4018, 4546, 3298, 3346, 4498],
            [3923, 4019, 4547, 3299, 3347, 4499],
            [3924, 4020, 4548, 3300, 3348, 4500],
            [3925, 4021, 4549, 3301, 3349, 4501],
            [3926, 4022, 4550, 3302, 3350, 4502],
            [3927, 4023, 4551, 3303, 3351, 4503],
            [3928, 4024, 4552, 3304, 3352, 4504],
            [3929, 4025, 4553, 3305, 3353, 4505],
            [3930, 4026, 4554, 3306, 3354, 4506],
            [3931, 4027, 4555, 3307, 3355, 4507],
            [3932, 4028, 4556, 3308, 3356, 4508],
            [3933, 4029, 4557, 3309, 3357, 4509],
            [3934, 4030, 4558, 3310, 3358, 4510],
            [3935, 4031, 4559, 3311, 3359, 4511],
            [3936, 4032, 4560, 3312, 3360, 4512],
            [3937, 4033, 4561, 3313, 3361, 4513],
            [3938, 4034, 4562, 3314, 3362, 4514],
            [3939, 4035, 4563, 3315, 3363, 4515],
            [3940, 4036, 4564, 3316, 3364, 4516],
            [3941, 4037, 4565, 3317, 3365, 4517],
            [3942, 4038, 4566, 3318, 3366, 4518],
            [3943, 4039, 4567, 3319, 3367, 4519],
            [3944, 4040, 4568, 3320, 3368, 4520],
            [3945, 4041, 4569, 3321, 3369, 4521],
            [3946, 4042, 4570, 3322, 3370, 4522],
            [3947, 4043, 4571, 3323, 3371, 4523],
            [3948, 4044, 4572, 3324, 3372, 4524],
            [3949, 4045, 4573, 3325, 3373, 4525],
            [3950, 4046, 4574, 3326, 3374, 4526],
            [3951, 4047, 4575, 3327, 3375, 4527],
            [3952, 4048, 4576, 3328, 3376, 4528],
            [3953, 4049, 4577, 3329, 3377, 4529],
            [3954, 4050, 4578, 3330, 3378, 4530],
            [3955, 4051, 4579, 3331, 3379, 4531],
            [3956, 4052, 4580, 3332, 3380, 4532],
            [3957, 4053, 4581, 3333, 3381, 4533],
            [3958, 4054, 4582, 3334, 3382, 4534],
            [3959, 4055, 4583, 3335, 3383, 4535],
            [3960, 4056, 4584, 3336, 3384, 4536],
            [3961, 4057, 4585, 3337, 3385, 4537],
            [3962, 4058, 4586, 3338, 3386, 4538],
            [3963, 4059, 4587, 3339, 3387, 4539],
            [3964, 4060, 4588, 3340, 3388, 4540],
            [3965, 4061, 4589, 3341, 3389, 4541],
            [3966, 4062, 4590, 3342, 3390, 4542],
            [3967, 4063, 4591, 3343, 3391, 4543],
            [3968, 4064, 4592, 3344, 3392, 4544],
            [3969, 4065, 4593, 3345, 3393, 4545],
            [3970, 4066, 4594, 3346, 3394, 4546],
            [3971, 4067, 4595, 3347, 3395, 4547],
            [3972, 4068, 4596, 3348, 3396, 4548],
            [3973, 4069, 4597, 3349, 3397, 4549],
            [3974, 4070, 4598, 3350, 3398, 4550],
            [3975, 4071, 4599, 3351, 3399, 4551],
            [3976, 4072, 4600, 3352, 3400, 4552],
            [3977, 4073, 4601, 3353, 3401, 4553],
            [3978, 4074, 4602, 3354, 3402, 4554],
            [3979, 4075, 4603, 3355, 3403, 4555],
            [3980, 4076, 4604, 3356, 3404, 4556],
            [3981, 4077, 4605, 3357, 3405, 4557],
            [3982, 4078, 4606, 3358, 3406, 4558],
            [3983, 4079, 4607, 3359, 3407, 4559],
            [3984, 4080, 4608, 3360, 3408, 4560],
            [3985, 4081, 4609, 3361, 3409, 4561],
            [3986, 610, 634, 3362, 3410, 4562],
            [3987, 611, 635, 3363, 3411, 4563],
            [3988, 612, 636, 3364, 3412, 4564],
            [3989, 613, 637, 3365, 3413, 4565],
            [3990, 614, 638, 3366, 3414, 4566],
            [3991, 615, 639, 3367, 3415, 4567],
            [3992, 616, 640, 3368, 3416, 4568],
            [3993, 617, 641, 3369, 3417, 4569],
            [3994, 602, 626, 3370, 3418, 4570],
            [3995, 603, 627, 3371, 3419, 4571],
            [3996, 604, 628, 3372, 3420, 4572],
            [3997, 605, 629, 3373, 3421, 4573],
            [3998, 606, 630, 3374, 3422, 4574],
            [3999, 607, 631, 3375, 3423, 4575],
            [4000, 608, 632, 3376, 3424, 4576],
            [4001, 609, 633, 3377, 3425, 4577],
            [4002, 618, 642, 3378, 3426, 4578],
            [4003, 619, 643, 3379, 3427, 4579],
            [4004, 620, 644, 3380, 3428, 4580],
            [4005, 621, 645, 3381, 3429, 4581],
            [4006, 622, 646, 3382, 3430, 4582],
            [4007, 623, 647, 3383, 3431, 4583],
            [4008, 624, 648, 3384, 3432, 4584],
            [4009, 625, 649, 3385, 3433, 4585],
            [4010, 618, 642, 3386, 3434, 4586],
            [4011, 619, 643, 3387, 3435, 4587],
            [4012, 620, 644, 3388, 3436, 4588],
            [4013, 621, 645, 3389, 3437, 4589],
            [4014, 622, 646, 3390, 3438, 4590],
            [4015, 623, 647, 3391, 3439, 4591],
            [4016, 624, 648, 3392, 3440, 4592],
            [4017, 625, 649, 3393, 3441, 4593],
            [4018, 602, 626, 3394, 3442, 4594],
            [4019, 603, 627, 3395, 3443, 4595],
            [4020, 604, 628, 3396, 3444, 4596],
            [4021, 605, 629, 3397, 3445, 4597],
            [4022, 606, 630, 3398, 3446, 4598],
            [4023, 607, 631, 3399, 3447, 4599],
            [4024, 608, 632, 3400, 3448, 4600],
            [4025, 609, 633, 3401, 3449, 4601],
            [4026, 610, 634, 3402, 3450, 4602],
            [4027, 611, 635, 3403, 3451, 4603],
            [4028, 612, 636, 3404, 3452, 4604],
            [4029, 613, 637, 3405, 3453, 4605],
            [4030, 614, 638, 3406, 3454, 4606],
            [4031, 615, 639, 3407, 3455, 4607],
            [4032, 616, 640, 3408, 3456, 4608],
            [4033, 617, 641, 3409, 3457, 4609],
            [874, 4130, 3506, 898, 3554, 4084],
            [875, 4131, 3507, 899, 3555, 4085],
            [874, 4132, 3508, 898, 3556, 4082],
            [875, 4133, 3509, 899, 3557, 4083],
            [876, 4134, 3510, 900, 3558, 4088],
            [877, 4135, 3511, 901, 3559, 4089],
            [876, 4136, 3512, 900, 3560, 4086],
            [877, 4137, 3513, 901, 3561, 4087],
            [866, 4138, 3514, 890, 3562, 4094],
            [867, 4139, 3515, 891, 3563, 4095],
            [868, 4140, 3516, 892, 3564, 4096],
            [869, 4141, 3517, 893, 3565, 4097],
            [866, 4142, 3518, 890, 3566, 4090],
            [867, 4143, 3519, 891, 3567, 4091],
            [868, 4144, 3520, 892, 3568, 4092],
            [869, 4145, 3521, 893, 3569, 4093],
            [882, 4146, 3522, 906, 3570, 4099],
            [882, 4147, 3523, 906, 3571, 4098],
            [883, 4148, 3524, 907, 3572, 4101],
            [883, 4149, 3525, 907, 3573, 4100],
            [884, 4150, 3526, 908, 3574, 4103],
            [884, 4151, 3527, 908, 3575, 4102],
            [885, 4152, 3528, 909, 3576, 4105],
            [885, 4153, 3529, 909, 3577, 4104],
            [886, 4154, 3530, 910, 3578, 4107],
            [886, 4155, 3531, 910, 3579, 4106],
            [887, 4156, 3532, 911, 3580, 4109],
            [887, 4157, 3533, 911, 3581, 4108],
            [888, 4158, 3534, 912, 3582, 4111],
            [888, 4159, 3535, 912, 3583, 4110],
            [889, 4160, 3536, 913, 3584, 4113],
            [889, 4161, 3537, 913, 3585, 4112],
            [870, 4162, 3538, 894, 3586, 4118],
            [871, 4163, 3539, 895, 3587, 4119],
            [872, 4164, 3540, 896, 3588, 4120],
            [873, 4165, 3541, 897, 3589, 4121],
            [870, 4166, 3542, 894, 3590, 4114],
            [871, 4167, 3543, 895, 3591, 4115],
            [872, 4168, 3544, 896, 3592, 4116],
            [873, 4169, 3545, 897, 3593, 4117],
            [878, 4170, 3546, 902, 3594, 4124],
            [879, 4171, 3547, 903, 3595, 4125],
            [878, 4172, 3548, 902, 3596, 4122],
            [879, 4173, 3549, 903, 3597, 4123],
            [880, 4174, 3550, 904, 3598, 4128],
            [881, 4175, 3551, 905, 3599, 4129],
            [880, 4176, 3552, 904, 3600, 4126],
            [881, 4177, 3553, 905, 3601, 4127],
            [4082, 4178, 3554, 4610, 3602, 898],
            [4083, 4179, 3555, 4611, 3603, 899],
            [4084, 4180, 3556, 4612, 3604, 898],
            [4085, 4181, 3557, 4613, 3605, 899],
            [4086, 4182, 3558, 4614, 3606, 900],
            [4087, 4183, 3559, 4615, 3607, 901],
            [4088, 4184, 3560, 4616, 3608, 900],
            [4089, 4185, 3561, 4617, 3609, 901],
            [4090, 4186, 3562, 4618, 3610, 890],
            [4091, 4187, 3563, 4619, 3611, 891],
            [4092, 4188, 3564, 4620, 3612, 892],
            [4093, 4189, 3565, 4621, 3613, 893],
            [4094, 4190, 3566, 4622, 3614, 890],
            [4095, 4191, 3567, 4623, 3615, 891],
            [4096, 4192, 3568, 4624, 3616, 892],
            [4097, 4193, 3569, 4625, 3617, 893],
            [4098, 4194, 3570, 4626, 3618, 906],
            [4099, 4195, 3571, 4627, 3619, 906],
            [4100, 4196, 3572, 4628, 3620, 907],
            [4101, 4197, 3573, 4629, 3621, 907],
            [4102, 4198, 3574, 4630, 3622, 908],
            [4103, 4199, 3575, 4631, 3623, 908],
            [4104, 4200, 3576, 4632, 3624, 909],
            [4105, 4201, 3577, 4633, 3625, 909],
            [4106, 4202, 3578, 4634, 3626, 910],
            [4107, 4203, 3579, 4635, 3627, 910],
            [4108, 4204, 3580, 4636, 3628, 911],
            [4109, 4205, 3581, 4637, 3629, 911],
            [4110, 4206, 3582, 4638, 3630, 912],
            [4111, 4207, 3583, 4639, 3631, 912],
            [4112, 4208, 3584, 4640, 3632, 913],
            [4113, 4209, 3585, 4641, 3633, 913],
            [4114, 4210, 3586, 4642, 3634, 894],
            [4115, 4211, 3587, 4643, 3635, 895],
            [4116, 4212, 3588, 4644, 3636, 896],
            [4117, 4213, 3589, 4645, 3637, 897],
            [4118, 4214, 3590, 4646, 3638, 894],
            [4119, 4215, 3591, 4647, 3639, 895],
            [4120, 4216, 3592, 4648, 3640, 896],
            [4121, 4217, 3593, 4649, 3641, 897],
            [4122, 4218, 3594, 4650, 3642, 902],
            [4123, 4219, 3595, 4651, 3643, 903],
            [4124, 4220, 3596, 4652, 3644, 902],
            [4125, 4221, 3597, 4653, 3645, 903],
            [4126, 4222, 3598, 4654, 3646, 904],
            [4127, 4223, 3599, 4655, 3647, 905],
            [4128, 4224, 3600, 4656, 3648, 904],
            [4129, 4225, 3601, 4657, 3649, 905],
            [4130, 4226, 3602, 4658, 3650, 4610],
            [4131, 4227, 3603, 4659, 3651, 4611],
            [4132, 4228, 3604, 4660, 3652, 4612],
            [4133, 4229, 3605, 4661, 3653, 4613],
            [4134, 4230, 3606, 4662, 3654, 4614],
            [4135, 4231, 3607, 4663, 3655, 4615],
            [4136, 4232, 3608, 4664, 3656, 4616],
            [4137, 4233, 3609, 4665, 3657, 4617],
            [4138, 4234, 3610, 4666, 3658, 4618],
            [4139, 4235, 3611, 4667, 3659, 4619],
            [4140, 4236, 3612, 4668, 3660, 4620],
            [4141, 4237, 3613, 4669, 3661, 4621],
            [4142, 4238, 3614, 4670, 3662, 4622],
            [4143, 4239, 3615, 4671, 3663, 4623],
            [4144, 4240, 3616, 4672, 3664, 4624],
            [4145, 4241, 3617, 4673, 3665, 4625],
            [4146, 4242, 3618, 4674, 3666, 4626],
            [4147, 4243, 3619, 4675, 3667, 4627],
            [4148, 4244, 3620, 4676, 3668, 4628],
            [4149, 4245, 3621, 4677, 3669, 4629],
            [4150, 4246, 3622, 4678, 3670, 4630],
            [4151, 4247, 3623, 4679, 3671, 4631],
            [4152, 4248, 3624, 4680, 3672, 4632],
            [4153, 4249, 3625, 4681, 3673, 4633],
            [4154, 4250, 3626, 4682, 3674, 4634],
            [4155, 4251, 3627, 4683, 3675, 4635],
            [4156, 4252, 3628, 4684, 3676, 4636],
            [4157, 4253, 3629, 4685, 3677, 4637],
            [4158, 4254, 3630, 4686, 3678, 4638],
            [4159, 4255, 3631, 4687, 3679, 4639],
            [4160, 4256, 3632, 4688, 3680, 4640],
            [4161, 4257, 3633, 4689, 3681, 4641],
            [4162, 4258, 3634, 4690, 3682, 4642],
            [4163, 4259, 3635, 4691, 3683, 4643],
            [4164, 4260, 3636, 4692, 3684, 4644],
            [4165, 4261, 3637, 4693, 3685, 4645],
            [4166, 4262, 3638, 4694, 3686, 4646],
            [4167, 4263, 3639, 4695, 3687, 4647],
            [4168, 4264, 3640, 4696, 3688, 4648],
            [4169, 4265, 3641, 4697, 3689, 4649],
            [4170, 4266, 3642, 4698, 3690, 4650],
            [4171, 4267, 3643, 4699, 3691, 4651],
            [4172, 4268, 3644, 4700, 3692, 4652],
            [4173, 4269, 3645, 4701, 3693, 4653],
            [4174, 4270, 3646, 4702, 3694, 4654],
            [4175, 4271, 3647, 4703, 3695, 4655],
            [4176, 4272, 3648, 4704, 3696, 4656],
            [4177, 4273, 3649, 4705, 3697, 4657],
            [4178, 4274, 4706, 3650, 3698, 4658],
            [4179, 4275, 4707, 3651, 3699, 4659],
            [4180, 4276, 4708, 3652, 3700, 4660],
            [4181, 4277, 4709, 3653, 3701, 4661],
            [4182, 4278, 4710, 3654, 3702, 4662],
            [4183, 4279, 4711, 3655, 3703, 4663],
            [4184, 4280, 4712, 3656, 3704, 4664],
            [4185, 4281, 4713, 3657, 3705, 4665],
            [4186, 4282, 4714, 3658, 3706, 4666],
            [4187, 4283, 4715, 3659, 3707, 4667],
            [4188, 4284, 4716, 3660, 3708, 4668],
            [4189, 4285, 4717, 3661, 3709, 4669],
            [4190, 4286, 4718, 3662, 3710, 4670],
            [4191, 4287, 4719, 3663, 3711, 4671],
            [4192, 4288, 4720, 3664, 3712, 4672],
            [4193, 4289, 4721, 3665, 3713, 4673],
            [4194, 4290, 4722, 3666, 3714, 4674],
            [4195, 4291, 4723, 3667, 3715, 4675],
            [4196, 4292, 4724, 3668, 3716, 4676],
            [4197, 4293, 4725, 3669, 3717, 4677],
            [4198, 4294, 4726, 3670, 3718, 4678],
            [4199, 4295, 4727, 3671, 3719, 4679],
            [4200, 4296, 4728, 3672, 3720, 4680],
            [4201, 4297, 4729, 3673, 3721, 4681],
            [4202, 4298, 4730, 3674, 3722, 4682],
            [4203, 4299, 4731, 3675, 3723, 4683],
            [4204, 4300, 4732, 3676, 3724, 4684],
            [4205, 4301, 4733, 3677, 3725, 4685],
            [4206, 4302, 4734, 3678, 3726, 4686],
            [4207, 4303, 4735, 3679, 3727, 4687],
            [4208, 4304, 4736, 3680, 3728, 4688],
            [4209, 4305, 4737, 3681, 3729, 4689],
            [4210, 4306, 4738, 3682, 3730, 4690],
            [4211, 4307, 4739, 3683, 3731, 4691],
            [4212, 4308, 4740, 3684, 3732, 4692],
            [4213, 4309, 4741, 3685, 3733, 4693],
            [4214, 4310, 4742, 3686, 3734, 4694],
            [4215, 4311, 4743, 3687, 3735, 4695],
            [4216, 4312, 4744, 3688, 3736, 4696],
            [4217, 4313, 4745, 3689, 3737, 4697],
            [4218, 4314, 4746, 3690, 3738, 4698],
            [4219, 4315, 4747, 3691, 3739, 4699],
            [4220, 4316, 4748, 3692, 3740, 4700],
            [4221, 4317, 4749, 3693, 3741, 4701],
            [4222, 4318, 4750, 3694, 3742, 4702],
            [4223, 4319, 4751, 3695, 3743, 4703],
            [4224, 4320, 4752, 3696, 3744, 4704],
            [4225, 4321, 4753, 3697, 3745, 4705],
            [4226, 4322, 4754, 3698, 3746, 4706],
            [4227, 4323, 4755, 3699, 3747, 4707],
            [4228, 4324, 4756, 3700, 3748, 4708],
            [4229, 4325, 4757, 3701, 3749, 4709],
            [4230, 4326, 4758, 3702, 3750, 4710],
            [4231, 4327, 4759, 3703, 3751, 4711],
            [4232, 4328, 4760, 3704, 3752, 4712],
            [4233, 4329, 4761, 3705, 3753, 4713],
            [4234, 4330, 4762, 3706, 3754, 4714],
            [4235, 4331, 4763, 3707, 3755, 4715],
            [4236, 4332, 4764, 3708, 3756, 4716],
            [4237, 4333, 4765, 3709, 3757, 4717],
            [4238, 4334, 4766, 3710, 3758, 4718],
            [4239, 4335, 4767, 3711, 3759, 4719],
            [4240, 4336, 4768, 3712, 3760, 4720],
            [4241, 4337, 4769, 3713, 3761, 4721],
            [4242, 4338, 4770, 3714, 3762, 4722],
            [4243, 4339, 4771, 3715, 3763, 4723],
            [4244, 4340, 4772, 3716, 3764, 4724],
            [4245, 4341, 4773, 3717, 3765, 4725],
            [4246, 4342, 4774, 3718, 3766, 4726],
            [4247, 4343, 4775, 3719, 3767, 4727],
            [4248, 4344, 4776, 3720, 3768, 4728],
            [4249, 4345, 4777, 3721, 3769, 4729],
            [4250, 4346, 4778, 3722, 3770, 4730],
            [4251, 4347, 4779, 3723, 3771, 4731],
            [4252, 4348, 4780, 3724, 3772, 4732],
            [4253, 4349, 4781, 3725, 3773, 4733],
            [4254, 4350, 4782, 3726, 3774, 4734],
            [4255, 4351, 4783, 3727, 3775, 4735],
            [4256, 4352, 4784, 3728, 3776, 4736],
            [4257, 4353, 4785, 3729, 3777, 4737],
            [4258, 4354, 4786, 3730, 3778, 4738],
            [4259, 4355, 4787, 3731, 3779, 4739],
            [4260, 4356, 4788, 3732, 3780, 4740],
            [4261, 4357, 4789, 3733, 3781, 4741],
            [4262, 4358, 4790, 3734, 3782, 4742],
            [4263, 4359, 4791, 3735, 3783, 4743],
            [4264, 4360, 4792, 3736, 3784, 4744],
            [4265, 4361, 4793, 3737, 3785, 4745],
            [4266, 4362, 4794, 3738, 3786, 4746],
            [4267, 4363, 4795, 3739, 3787, 4747],
            [4268, 4364, 4796, 3740, 3788, 4748],
            [4269, 4365, 4797, 3741, 3789, 4749],
            [4270, 4366, 4798, 3742, 3790, 4750],
            [4271, 4367, 4799, 3743, 3791, 4751],
            [4272, 4368, 4800, 3744, 3792, 4752],
            [4273, 4369, 4801, 3745, 3793, 4753],
            [4274, 4370, 4802, 3746, 3794, 4754],
            [4275, 4371, 4803, 3747, 3795, 4755],
            [4276, 4372, 4804, 3748, 3796, 4756],
            [4277, 4373, 4805, 3749, 3797, 4757],
            [4278, 4374, 4806, 3750, 3798, 4758],
            [4279, 4375, 4807, 3751, 3799, 4759],
            [4280, 4376, 4808, 3752, 3800, 4760],
            [4281, 4377, 4809, 3753, 3801, 4761],
            [4282, 4378, 4810, 3754, 3802, 4762],
            [4283, 4379, 4811, 3755, 3803, 4763],
            [4284, 4380, 4812, 3756, 3804, 4764],
            [4285, 4381, 4813, 3757, 3805, 4765],
            [4286, 4382, 4814, 3758, 3806, 4766],
            [4287, 4383, 4815, 3759, 3807, 4767],
            [4288, 4384, 4816, 3760, 3808, 4768],
            [4289, 4385, 4817, 3761, 3809, 4769],
            [4290, 4386, 4818, 3762, 3810, 4770],
            [4291, 4387, 4819, 3763, 3811, 4771],
            [4292, 4388, 4820, 3764, 3812, 4772],
            [4293, 4389, 4821, 3765, 3813, 4773],
            [4294, 4390, 4822, 3766, 3814, 4774],
            [4295, 4391, 4823, 3767, 3815, 4775],
            [4296, 4392, 4824, 3768, 3816, 4776],
            [4297, 4393, 4825, 3769, 3817, 4777],
            [4298, 4394, 4826, 3770, 3818, 4778],
            [4299, 4395, 4827, 3771, 3819, 4779],
            [4300, 4396, 4828, 3772, 3820, 4780],
            [4301, 4397, 4829, 3773, 3821, 4781],
            [4302, 4398, 4830, 3774, 3822, 4782],
            [4303, 4399, 4831, 3775, 3823, 4783],
            [4304, 4400, 4832, 3776, 3824, 4784],
            [4305, 4401, 4833, 3777, 3825, 4785],
            [4306, 4402, 4834, 3778, 3826, 4786],
            [4307, 4403, 4835, 3779, 3827, 4787],
            [4308, 4404, 4836, 3780, 3828, 4788],
            [4309, 4405, 4837, 3781, 3829, 4789],
            [4310, 4406, 4838, 3782, 3830, 4790],
            [4311, 4407, 4839, 3783, 3831, 4791],
            [4312, 4408, 4840, 3784, 3832, 4792],
            [4313, 4409, 4841, 3785, 3833, 4793],
            [4314, 4410, 4842, 3786, 3834, 4794],
            [4315, 4411, 4843, 3787, 3835, 4795],
            [4316, 4412, 4844, 3788, 3836, 4796],
            [4317, 4413, 4845, 3789, 3837, 4797],
            [4318, 4414, 4846, 3790, 3838, 4798],
            [4319, 4415, 4847, 3791, 3839, 4799],
            [4320, 4416, 4848, 3792, 3840, 4800],
            [4321, 4417, 4849, 3793, 3841, 4801],
            [4322, 4418, 4850, 3794, 3842, 4802],
            [4323, 4419, 4851, 3795, 3843, 4803],
            [4324, 4420, 4852, 3796, 3844, 4804],
            [4325, 4421, 4853, 3797, 3845, 4805],
            [4326, 4422, 4854, 3798, 3846, 4806],
            [4327, 4423, 4855, 3799, 3847, 4807],
            [4328, 4424, 4856, 3800, 3848, 4808],
            [4329, 4425, 4857, 3801, 3849, 4809],
            [4330, 4426, 4858, 3802, 3850, 4810],
            [4331, 4427, 4859, 3803, 3851, 4811],
            [4332, 4428, 4860, 3804, 3852, 4812],
            [4333, 4429, 4861, 3805, 3853, 4813],
            [4334, 4430, 4862, 3806, 3854, 4814],
            [4335, 4431, 4863, 3807, 3855, 4815],
            [4336, 4432, 4864, 3808, 3856, 4816],
            [4337, 4433, 4865, 3809, 3857, 4817],
            [4338, 4434, 4866, 3810, 3858, 4818],
            [4339, 4435, 4867, 3811, 3859, 4819],
            [4340, 4436, 4868, 3812, 3860, 4820],
            [4341, 4437, 4869, 3813, 3861, 4821],
            [4342, 4438, 4870, 3814, 3862, 4822],
            [4343, 4439, 4871, 3815, 3863, 4823],
            [4344, 4440, 4872, 3816, 3864, 4824],
            [4345, 4441, 4873, 3817, 3865, 4825],
            [4346, 4442, 4874, 3818, 3866, 4826],
            [4347, 4443, 4875, 3819, 3867, 4827],
            [4348, 4444, 4876, 3820, 3868, 4828],
            [4349, 4445, 4877, 3821, 3869, 4829],
            [4350, 4446, 4878, 3822, 3870, 4830],
            [4351, 4447, 4879, 3823, 3871, 4831],
            [4352, 4448, 4880, 3824, 3872, 4832],
            [4353, 4449, 4881, 3825, 3873, 4833],
            [4354, 4450, 4882, 3826, 3874, 4834],
            [4355, 4451, 4883, 3827, 3875, 4835],
            [4356, 4452, 4884, 3828, 3876, 4836],
            [4357, 4453, 4885, 3829, 3877, 4837],
            [4358, 4454, 4886, 3830, 3878, 4838],
            [4359, 4455, 4887, 3831, 3879, 4839],
            [4360, 4456, 4888, 3832, 3880, 4840],
            [4361, 4457, 4889, 3833, 3881, 4841],
            [4362, 4458, 4890, 3834, 3882, 4842],
            [4363, 4459, 4891, 3835, 3883, 4843],
            [4364, 4460, 4892, 3836, 3884, 4844],
            [4365, 4461, 4893, 3837, 3885, 4845],
            [4366, 4462, 4894, 3838, 3886, 4846],
            [4367, 4463, 4895, 3839, 3887, 4847],
            [4368, 4464, 4896, 3840, 3888, 4848],
            [4369, 4465, 4897, 3841, 3889, 4849],
            [4370, 4466, 4898, 3842, 3890, 4850],
            [4371, 4467, 4899, 3843, 3891, 4851],
            [4372, 4468, 4900, 3844, 3892, 4852],
            [4373, 4469, 4901, 3845, 3893, 4853],
            [4374, 4470, 4902, 3846, 3894, 4854],
            [4375, 4471, 4903, 3847, 3895, 4855],
            [4376, 4472, 4904, 3848, 3896, 4856],
            [4377, 4473, 4905, 3849, 3897, 4857],
            [4378, 4474, 4906, 3850, 3898, 4858],
            [4379, 4475, 4907, 3851, 3899, 4859],
            [4380, 4476, 4908, 3852, 3900, 4860],
            [4381, 4477, 4909, 3853, 3901, 4861],
            [4382, 4478, 4910, 3854, 3902, 4862],
            [4383, 4479, 4911, 3855, 3903, 4863],
            [4384, 4480, 4912, 3856, 3904, 4864],
            [4385, 4481, 4913, 3857, 3905, 4865],
            [4386, 4482, 4914, 3858, 3906, 4866],
            [4387, 4483, 4915, 3859, 3907, 4867],
            [4388, 4484, 4916, 3860, 3908, 4868],
            [4389, 4485, 4917, 3861, 3909, 4869],
            [4390, 4486, 4918, 3862, 3910, 4870],
            [4391, 4487, 4919, 3863, 3911, 4871],
            [4392, 4488, 4920, 3864, 3912, 4872],
            [4393, 4489, 4921, 3865, 3913, 4873],
            [4394, 4490, 4922, 3866, 3914, 4874],
            [4395, 4491, 4923, 3867, 3915, 4875],
            [4396, 4492, 4924, 3868, 3916, 4876],
            [4397, 4493, 4925, 3869, 3917, 4877],
            [4398, 4494, 4926, 3870, 3918, 4878],
            [4399, 4495, 4927, 3871, 3919, 4879],
            [4400, 4496, 4928, 3872, 3920, 4880],
            [4401, 4497, 4929, 3873, 3921, 4881],
            [4402, 4498, 4930, 3874, 3922, 4882],
            [4403, 4499, 4931, 3875, 3923, 4883],
            [4404, 4500, 4932, 3876, 3924, 4884],
            [4405, 4501, 4933, 3877, 3925, 4885],
            [4406, 4502, 4934, 3878, 3926, 4886],
            [4407, 4503, 4935, 3879, 3927, 4887],
            [4408, 4504, 4936, 3880, 3928, 4888],
            [4409, 4505, 4937, 3881, 3929, 4889],
            [4410, 4506, 4938, 3882, 3930, 4890],
            [4411, 4507, 4939, 3883, 3931, 4891],
            [4412, 4508, 4940, 3884, 3932, 4892],
            [4413, 4509, 4941, 3885, 3933, 4893],
            [4414, 4510, 4942, 3886, 3934, 4894],
            [4415, 4511, 4943, 3887, 3935, 4895],
            [4416, 4512, 4944, 3888, 3936, 4896],
            [4417, 4513, 4945, 3889, 3937, 4897],
            [4418, 4514, 4946, 3890, 3938, 4898],
            [4419, 4515, 4947, 3891, 3939, 4899],
            [4420, 4516, 4948, 3892, 3940, 4900],
            [4421, 4517, 4949, 3893, 3941, 4901],
            [4422, 4518, 4950, 3894, 3942, 4902],
            [4423, 4519, 4951, 3895, 3943, 4903],
            [4424, 4520, 4952, 3896, 3944, 4904],
            [4425, 4521, 4953, 3897, 3945, 4905],
            [4426, 4522, 4954, 3898, 3946, 4906],
            [4427, 4523, 4955, 3899, 3947, 4907],
            [4428, 4524, 4956, 3900, 3948, 4908],
            [4429, 4525, 4957, 3901, 3949, 4909],
            [4430, 4526, 4958, 3902, 3950, 4910],
            [4431, 4527, 4959, 3903, 3951, 4911],
            [4432, 4528, 4960, 3904, 3952, 4912],
            [4433, 4529, 4961, 3905, 3953, 4913],
            [4434, 4530, 4962, 3906, 3954, 4914],
            [4435, 4531, 4963, 3907, 3955, 4915],
            [4436, 4532, 4964, 3908, 3956, 4916],
            [4437, 4533, 4965, 3909, 3957, 4917],
            [4438, 4534, 4966, 3910, 3958, 4918],
            [4439, 4535, 4967, 3911, 3959, 4919],
            [4440, 4536, 4968, 3912, 3960, 4920],
            [4441, 4537, 4969, 3913, 3961, 4921],
            [4442, 4538, 4970, 3914, 3962, 4922],
            [4443, 4539, 4971, 3915, 3963, 4923],
            [4444, 4540, 4972, 3916, 3964, 4924],
            [4445, 4541, 4973, 3917, 3965, 4925],
            [4446, 4542, 4974, 3918, 3966, 4926],
            [4447, 4543, 4975, 3919, 3967, 4927],
            [4448, 4544, 4976, 3920, 3968, 4928],
            [4449, 4545, 4977, 3921, 3969, 4929],
            [4450, 4546, 4978, 3922, 3970, 4930],
            [4451, 4547, 4979, 3923, 3971, 4931],
            [4452, 4548, 4980, 3924, 3972, 4932],
            [4453, 4549, 4981, 3925, 3973, 4933],
            [4454, 4550, 4982, 3926, 3974, 4934],
            [4455, 4551, 4983, 3927, 3975, 4935],
            [4456, 4552, 4984, 3928, 3976, 4936],
            [4457, 4553, 4985, 3929, 3977, 4937],
            [4458, 4554, 4986, 3930, 3978, 4938],
            [4459, 4555, 4987, 3931, 3979, 4939],
            [4460, 4556, 4988, 3932, 3980, 4940],
            [4461, 4557, 4989, 3933, 3981, 4941],
            [4462, 4558, 4990, 3934, 3982, 4942],
            [4463, 4559, 4991, 3935, 3983, 4943],
            [4464, 4560, 4992, 3936, 3984, 4944],
            [4465, 4561, 4993, 3937, 3985, 4945],
            [4466, 4562, 4994, 3938, 3986, 4946],
            [4467, 4563, 4995, 3939, 3987, 4947],
            [4468, 4564, 4996, 3940, 3988, 4948],
            [4469, 4565, 4997, 3941, 3989, 4949],
            [4470, 4566, 4998, 3942, 3990, 4950],
            [4471, 4567, 4999, 3943, 3991, 4951],
            [4472, 4568, 5000, 3944, 3992, 4952],
            [4473, 4569, 5001, 3945, 3993, 4953],
            [4474, 4570, 5002, 3946, 3994, 4954],
            [4475, 4571, 5003, 3947, 3995, 4955],
            [4476, 4572, 5004, 3948, 3996, 4956],
            [4477, 4573, 5005, 3949, 3997, 4957],
            [4478, 4574, 5006, 3950, 3998, 4958],
            [4479, 4575, 5007, 3951, 3999, 4959],
            [4480, 4576, 5008, 3952, 4000, 4960],
            [4481, 4577, 5009, 3953, 4001, 4961],
            [4482, 4578, 5010, 3954, 4002, 4962],
            [4483, 4579, 5011, 3955, 4003, 4963],
            [4484, 4580, 5012, 3956, 4004, 4964],
            [4485, 4581, 5013, 3957, 4005, 4965],
            [4486, 4582, 5014, 3958, 4006, 4966],
            [4487, 4583, 5015, 3959, 4007, 4967],
            [4488, 4584, 5016, 3960, 4008, 4968],
            [4489, 4585, 5017, 3961, 4009, 4969],
            [4490, 4586, 5018, 3962, 4010, 4970],
            [4491, 4587, 5019, 3963, 4011, 4971],
            [4492, 4588, 5020, 3964, 4012, 4972],
            [4493, 4589, 5021, 3965, 4013, 4973],
            [4494, 4590, 5022, 3966, 4014, 4974],
            [4495, 4591, 5023, 3967, 4015, 4975],
            [4496, 4592, 5024, 3968, 4016, 4976],
            [4497, 4593, 5025, 3969, 4017, 4977],
            [4498, 4594, 5026, 3970, 4018, 4978],
            [4499, 4595, 5027, 3971, 4019, 4979],
            [4500, 4596, 5028, 3972, 4020, 4980],
            [4501, 4597, 5029, 3973, 4021, 4981],
            [4502, 4598, 5030, 3974, 4022, 4982],
            [4503, 4599, 5031, 3975, 4023, 4983],
            [4504, 4600, 5032, 3976, 4024, 4984],
            [4505, 4601, 5033, 3977, 4025, 4985],
            [4506, 4602, 5034, 3978, 4026, 4986],
            [4507, 4603, 5035, 3979, 4027, 4987],
            [4508, 4604, 5036, 3980, 4028, 4988],
            [4509, 4605, 5037, 3981, 4029, 4989],
            [4510, 4606, 5038, 3982, 4030, 4990],
            [4511, 4607, 5039, 3983, 4031, 4991],
            [4512, 4608, 5040, 3984, 4032, 4992],
            [4513, 4609, 5041, 3985, 4033, 4993],
            [4514, 634, 658, 3986, 4034, 4994],
            [4515, 635, 659, 3987, 4035, 4995],
            [4516, 636, 660, 3988, 4036, 4996],
            [4517, 637, 661, 3989, 4037, 4997],
            [4518, 638, 662, 3990, 4038, 4998],
            [4519, 639, 663, 3991, 4039, 4999],
            [4520, 640, 664, 3992, 4040, 5000],
            [4521, 641, 665, 3993, 4041, 5001],
            [4522, 626, 650, 3994, 4042, 5002],
            [4523, 627, 651, 3995, 4043, 5003],
            [4524, 628, 652, 3996, 4044, 5004],
            [4525, 629, 653, 3997, 4045, 5005],
            [4526, 630, 654, 3998, 4046, 5006],
            [4527, 631, 655, 3999, 4047, 5007],
            [4528, 632, 656, 4000, 4048, 5008],
            [4529, 633, 657, 4001, 4049, 5009],
            [4530, 642, 666, 4002, 4050, 5010],
            [4531, 643, 667, 4003, 4051, 5011],
            [4532, 644, 668, 4004, 4052, 5012],
            [4533, 645, 669, 4005, 4053, 5013],
            [4534, 646, 670, 4006, 4054, 5014],
            [4535, 647, 671, 4007, 4055, 5015],
            [4536, 648, 672, 4008, 4056, 5016],
            [4537, 649, 673, 4009, 4057, 5017],
            [4538, 642, 666, 4010, 4058, 5018],
            [4539, 643, 667, 4011, 4059, 5019],
            [4540, 644, 668, 4012, 4060, 5020],
            [4541, 645, 669, 4013, 4061, 5021],
            [4542, 646, 670, 4014, 4062, 5022],
            [4543, 647, 671, 4015, 4063, 5023],
            [4544, 648, 672, 4016, 4064, 5024],
            [4545, 649, 673, 4017, 4065, 5025],
            [4546, 626, 650, 4018, 4066, 5026],
            [4547, 627, 651, 4019, 4067, 5027],
            [4548, 628, 652, 4020, 4068, 5028],
            [4549, 629, 653, 4021, 4069, 5029],
            [4550, 630, 654, 4022, 4070, 5030],
            [4551, 631, 655, 4023, 4071, 5031],
            [4552, 632, 656, 4024, 4072, 5032],
            [4553, 633, 657, 4025, 4073, 5033],
            [4554, 634, 658, 4026, 4074, 5034],
            [4555, 635, 659, 4027, 4075, 5035],
            [4556, 636, 660, 4028, 4076, 5036],
            [4557, 637, 661, 4029, 4077, 5037],
            [4558, 638, 662, 4030, 4078, 5038],
            [4559, 639, 663, 4031, 4079, 5039],
            [4560, 640, 664, 4032, 4080, 5040],
            [4561, 641, 665, 4033, 4081, 5041],
            [898, 4658, 4130, 922, 4178, 4612],
            [899, 4659, 4131, 923, 4179, 4613],
            [898, 4660, 4132, 922, 4180, 4610],
            [899, 4661, 4133, 923, 4181, 4611],
            [900, 4662, 4134, 924, 4182, 4616],
            [901, 4663, 4135, 925, 4183, 4617],
            [900, 4664, 4136, 924, 4184, 4614],
            [901, 4665, 4137, 925, 4185, 4615],
            [890, 4666, 4138, 914, 4186, 4622],
            [891, 4667, 4139, 915, 4187, 4623],
            [892, 4668, 4140, 916, 4188, 4624],
            [893, 4669, 4141, 917, 4189, 4625],
            [890, 4670, 4142, 914, 4190, 4618],
            [891, 4671, 4143, 915, 4191, 4619],
            [892, 4672, 4144, 916, 4192, 4620],
            [893, 4673, 4145, 917, 4193, 4621],
            [906, 4674, 4146, 930, 4194, 4627],
            [906, 4675, 4147, 930, 4195, 4626],
            [907, 4676, 4148, 931, 4196, 4629],
            [907, 4677, 4149, 931, 4197, 4628],
            [908, 4678, 4150, 932, 4198, 4631],
            [908, 4679, 4151, 932, 4199, 4630],
            [909, 4680, 4152, 933, 4200, 4633],
            [909, 4681, 4153, 933, 4201, 4632],
            [910, 4682, 4154, 934, 4202, 4635],
            [910, 4683, 4155, 934, 4203, 4634],
            [911, 4684, 4156, 935, 4204, 4637],
            [911, 4685, 4157, 935, 4205, 4636],
            [912, 4686, 4158, 936, 4206, 4639],
            [912, 4687, 4159, 936, 4207, 4638],
            [913, 4688, 4160, 937, 4208, 4641],
            [913, 4689, 4161, 937, 4209, 4640],
            [894, 4690, 4162, 918, 4210, 4646],
            [895, 4691, 4163, 919, 4211, 4647],
            [896, 4692, 4164, 920, 4212, 4648],
            [897, 4693, 4165, 921, 4213, 4649],
            [894, 4694, 4166, 918, 4214, 4642],
            [895, 4695, 4167, 919, 4215, 4643],
            [896, 4696, 4168, 920, 4216, 4644],
            [897, 4697, 4169, 921, 4217, 4645],
            [902, 4698, 4170, 926, 4218, 4652],
            [903, 4699, 4171, 927, 4219, 4653],
            [902, 4700, 4172, 926, 4220, 4650],
            [903, 4701, 4173, 927, 4221, 4651],
            [904, 4702, 4174, 928, 4222, 4656],
            [905, 4703, 4175, 929, 4223, 4657],
            [904, 4704, 4176, 928, 4224, 4654],
            [905, 4705, 4177, 929, 4225, 4655],
            [4610, 4706, 4178, 5042, 4226, 922],
            [4611, 4707, 4179, 5043, 4227, 923],
            [4612, 4708, 4180, 5044, 4228, 922],
            [4613, 4709, 4181, 5045, 4229, 923],
            [4614, 4710, 4182, 5046, 4230, 924],
            [4615, 4711, 4183, 5047, 4231, 925],
            [4616, 4712, 4184, 5048, 4232, 924],
            [4617, 4713, 4185, 5049, 4233, 925],
            [4618, 4714, 4186, 5050, 4234, 914],
            [4619, 4715, 4187, 5051, 4235, 915],
            [4620, 4716, 4188, 5052, 4236, 916],
            [4621, 4717, 4189, 5053, 4237, 917],
            [4622, 4718, 4190, 5054, 4238, 914],
            [4623, 4719, 4191, 5055, 4239, 915],
            [4624, 4720, 4192, 5056, 4240, 916],
            [4625, 4721, 4193, 5057, 4241, 917],
            [4626, 4722, 4194, 5058, 4242, 930],
            [4627, 4723, 4195, 5059, 4243, 930],
            [4628, 4724, 4196, 5060, 4244, 931],
            [4629, 4725, 4197, 5061, 4245, 931],
            [4630, 4726, 4198, 5062, 4246, 932],
            [4631, 4727, 4199, 5063, 4247, 932],
            [4632, 4728, 4200, 5064, 4248, 933],
            [4633, 4729, 4201, 5065, 4249, 933],
            [4634, 4730, 4202, 5066, 4250, 934],
            [4635, 4731, 4203, 5067, 4251, 934],
            [4636, 4732, 4204, 5068, 4252, 935],
            [4637, 4733, 4205, 5069, 4253, 935],
            [4638, 4734, 4206, 5070, 4254, 936],
            [4639, 4735, 4207, 5071, 4255, 936],
            [4640, 4736, 4208, 5072, 4256, 937],
            [4641, 4737, 4209, 5073, 4257, 937],
            [4642, 4738, 4210, 5074, 4258, 918],
            [4643, 4739, 4211, 5075, 4259, 919],
            [4644, 4740, 4212, 5076, 4260, 920],
            [4645, 4741, 4213, 5077, 4261, 921],
            [4646, 4742, 4214, 5078, 4262, 918],
            [4647, 4743, 4215, 5079, 4263, 919],
            [4648, 4744, 4216, 5080, 4264, 920],
            [4649, 4745, 4217, 5081, 4265, 921],
            [4650, 4746, 4218, 5082, 4266, 926],
            [4651, 4747, 4219, 5083, 4267, 927],
            [4652, 4748, 4220, 5084, 4268, 926],
            [4653, 4749, 4221, 5085, 4269, 927],
            [4654, 4750, 4222, 5086, 4270, 928],
            [4655, 4751, 4223, 5087, 4271, 929],
            [4656, 4752, 4224, 5088, 4272, 928],
            [4657, 4753, 4225, 5089, 4273, 929],
            [4658, 4754, 4226, 5090, 4274, 5042],
            [4659, 4755, 4227, 5091, 4275, 5043],
            [4660, 4756, 4228, 5092, 4276, 5044],
            [4661, 4757, 4229, 5093, 4277, 5045],
            [4662, 4758, 4230, 5094, 4278, 5046],
            [4663, 4759, 4231, 5095, 4279, 5047],
            [4664, 4760, 4232, 5096, 4280, 5048],
            [4665, 4761, 4233, 5097, 4281, 5049],
            [4666, 4762, 4234, 5098, 4282, 5050],
            [4667, 4763, 4235, 5099, 4283, 5051],
            [4668, 4764, 4236, 5100, 4284, 5052],
            [4669, 4765, 4237, 5101, 4285, 5053],
            [4670, 4766, 4238, 5102, 4286, 5054],
            [4671, 4767, 4239, 5103, 4287, 5055],
            [4672, 4768, 4240, 5104, 4288, 5056],
            [4673, 4769, 4241, 5105, 4289, 5057],
            [4674, 4770, 4242, 5106, 4290, 5058],
            [4675, 4771, 4243, 5107, 4291, 5059],
            [4676, 4772, 4244, 5108, 4292, 5060],
            [4677, 4773, 4245, 5109, 4293, 5061],
            [4678, 4774, 4246, 5110, 4294, 5062],
            [4679, 4775, 4247, 5111, 4295, 5063],
            [4680, 4776, 4248, 5112, 4296, 5064],
            [4681, 4777, 4249, 5113, 4297, 5065],
            [4682, 4778, 4250, 5114, 4298, 5066],
            [4683, 4779, 4251, 5115, 4299, 5067],
            [4684, 4780, 4252, 5116, 4300, 5068],
            [4685, 4781, 4253, 5117, 4301, 5069],
            [4686, 4782, 4254, 5118, 4302, 5070],
            [4687, 4783, 4255, 5119, 4303, 5071],
            [4688, 4784, 4256, 5120, 4304, 5072],
            [4689, 4785, 4257, 5121, 4305, 5073],
            [4690, 4786, 4258, 5122, 4306, 5074],
            [4691, 4787, 4259, 5123, 4307, 5075],
            [4692, 4788, 4260, 5124, 4308, 5076],
            [4693, 4789, 4261, 5125, 4309, 5077],
            [4694, 4790, 4262, 5126, 4310, 5078],
            [4695, 4791, 4263, 5127, 4311, 5079],
            [4696, 4792, 4264, 5128, 4312, 5080],
            [4697, 4793, 4265, 5129, 4313, 5081],
            [4698, 4794, 4266, 5130, 4314, 5082],
            [4699, 4795, 4267, 5131, 4315, 5083],
            [4700, 4796, 4268, 5132, 4316, 5084],
            [4701, 4797, 4269, 5133, 4317, 5085],
            [4702, 4798, 4270, 5134, 4318, 5086],
            [4703, 4799, 4271, 5135, 4319, 5087],
            [4704, 4800, 4272, 5136, 4320, 5088],
            [4705, 4801, 4273, 5137, 4321, 5089],
            [4706, 4802, 5138, 4274, 4322, 5090],
            [4707, 4803, 5139, 4275, 4323, 5091],
            [4708, 4804, 5140, 4276, 4324, 5092],
            [4709, 4805, 5141, 4277, 4325, 5093],
            [4710, 4806, 5142, 4278, 4326, 5094],
            [4711, 4807, 5143, 4279, 4327, 5095],
            [4712, 4808, 5144, 4280, 4328, 5096],
            [4713, 4809, 5145, 4281, 4329, 5097],
            [4714, 4810, 5146, 4282, 4330, 5098],
            [4715, 4811, 5147, 4283, 4331, 5099],
            [4716, 4812, 5148, 4284, 4332, 5100],
            [4717, 4813, 5149, 4285, 4333, 5101],
            [4718, 4814, 5150, 4286, 4334, 5102],
            [4719, 4815, 5151, 4287, 4335, 5103],
            [4720, 4816, 5152, 4288, 4336, 5104],
            [4721, 4817, 5153, 4289, 4337, 5105],
            [4722, 4818, 5154, 4290, 4338, 5106],
            [4723, 4819, 5155, 4291, 4339, 5107],
            [4724, 4820, 5156, 4292, 4340, 5108],
            [4725, 4821, 5157, 4293, 4341, 5109],
            [4726, 4822, 5158, 4294, 4342, 5110],
            [4727, 4823, 5159, 4295, 4343, 5111],
            [4728, 4824, 5160, 4296, 4344, 5112],
            [4729, 4825, 5161, 4297, 4345, 5113],
            [4730, 4826, 5162, 4298, 4346, 5114],
            [4731, 4827, 5163, 4299, 4347, 5115],
            [4732, 4828, 5164, 4300, 4348, 5116],
            [4733, 4829, 5165, 4301, 4349, 5117],
            [4734, 4830, 5166, 4302, 4350, 5118],
            [4735, 4831, 5167, 4303, 4351, 5119],
            [4736, 4832, 5168, 4304, 4352, 5120],
            [4737, 4833, 5169, 4305, 4353, 5121],
            [4738, 4834, 5170, 4306, 4354, 5122],
            [4739, 4835, 5171, 4307, 4355, 5123],
            [4740, 4836, 5172, 4308, 4356, 5124],
            [4741, 4837, 5173, 4309, 4357, 5125],
            [4742, 4838, 5174, 4310, 4358, 5126],
            [4743, 4839, 5175, 4311, 4359, 5127],
            [4744, 4840, 5176, 4312, 4360, 5128],
            [4745, 4841, 5177, 4313, 4361, 5129],
            [4746, 4842, 5178, 4314, 4362, 5130],
            [4747, 4843, 5179, 4315, 4363, 5131],
            [4748, 4844, 5180, 4316, 4364, 5132],
            [4749, 4845, 5181, 4317, 4365, 5133],
            [4750, 4846, 5182, 4318, 4366, 5134],
            [4751, 4847, 5183, 4319, 4367, 5135],
            [4752, 4848, 5184, 4320, 4368, 5136],
            [4753, 4849, 5185, 4321, 4369, 5137],
            [4754, 4850, 5186, 4322, 4370, 5138],
            [4755, 4851, 5187, 4323, 4371, 5139],
            [4756, 4852, 5188, 4324, 4372, 5140],
            [4757, 4853, 5189, 4325, 4373, 5141],
            [4758, 4854, 5190, 4326, 4374, 5142],
            [4759, 4855, 5191, 4327, 4375, 5143],
            [4760, 4856, 5192, 4328, 4376, 5144],
            [4761, 4857, 5193, 4329, 4377, 5145],
            [4762, 4858, 5194, 4330, 4378, 5146],
            [4763, 4859, 5195, 4331, 4379, 5147],
            [4764, 4860, 5196, 4332, 4380, 5148],
            [4765, 4861, 5197, 4333, 4381, 5149],
            [4766, 4862, 5198, 4334, 4382, 5150],
            [4767, 4863, 5199, 4335, 4383, 5151],
            [4768, 4864, 5200, 4336, 4384, 5152],
            [4769, 4865, 5201, 4337, 4385, 5153],
            [4770, 4866, 5202, 4338, 4386, 5154],
            [4771, 4867, 5203, 4339, 4387, 5155],
            [4772, 4868, 5204, 4340, 4388, 5156],
            [4773, 4869, 5205, 4341, 4389, 5157],
            [4774, 4870, 5206, 4342, 4390, 5158],
            [4775, 4871, 5207, 4343, 4391, 5159],
            [4776, 4872, 5208, 4344, 4392, 5160],
            [4777, 4873, 5209, 4345, 4393, 5161],
            [4778, 4874, 5210, 4346, 4394, 5162],
            [4779, 4875, 5211, 4347, 4395, 5163],
            [4780, 4876, 5212, 4348, 4396, 5164],
            [4781, 4877, 5213, 4349, 4397, 5165],
            [4782, 4878, 5214, 4350, 4398, 5166],
            [4783, 4879, 5215, 4351, 4399, 5167],
            [4784, 4880, 5216, 4352, 4400, 5168],
            [4785, 4881, 5217, 4353, 4401, 5169],
            [4786, 4882, 5218, 4354, 4402, 5170],
            [4787, 4883, 5219, 4355, 4403, 5171],
            [4788, 4884, 5220, 4356, 4404, 5172],
            [4789, 4885, 5221, 4357, 4405, 5173],
            [4790, 4886, 5222, 4358, 4406, 5174],
            [4791, 4887, 5223, 4359, 4407, 5175],
            [4792, 4888, 5224, 4360, 4408, 5176],
            [4793, 4889, 5225, 4361, 4409, 5177],
            [4794, 4890, 5226, 4362, 4410, 5178],
            [4795, 4891, 5227, 4363, 4411, 5179],
            [4796, 4892, 5228, 4364, 4412, 5180],
            [4797, 4893, 5229, 4365, 4413, 5181],
            [4798, 4894, 5230, 4366, 4414, 5182],
            [4799, 4895, 5231, 4367, 4415, 5183],
            [4800, 4896, 5232, 4368, 4416, 5184],
            [4801, 4897, 5233, 4369, 4417, 5185],
            [4802, 4898, 5234, 4370, 4418, 5186],
            [4803, 4899, 5235, 4371, 4419, 5187],
            [4804, 4900, 5236, 4372, 4420, 5188],
            [4805, 4901, 5237, 4373, 4421, 5189],
            [4806, 4902, 5238, 4374, 4422, 5190],
            [4807, 4903, 5239, 4375, 4423, 5191],
            [4808, 4904, 5240, 4376, 4424, 5192],
            [4809, 4905, 5241, 4377, 4425, 5193],
            [4810, 4906, 5242, 4378, 4426, 5194],
            [4811, 4907, 5243, 4379, 4427, 5195],
            [4812, 4908, 5244, 4380, 4428, 5196],
            [4813, 4909, 5245, 4381, 4429, 5197],
            [4814, 4910, 5246, 4382, 4430, 5198],
            [4815, 4911, 5247, 4383, 4431, 5199],
            [4816, 4912, 5248, 4384, 4432, 5200],
            [4817, 4913, 5249, 4385, 4433, 5201],
            [4818, 4914, 5250, 4386, 4434, 5202],
            [4819, 4915, 5251, 4387, 4435, 5203],
            [4820, 4916, 5252, 4388, 4436, 5204],
            [4821, 4917, 5253, 4389, 4437, 5205],
            [4822, 4918, 5254, 4390, 4438, 5206],
            [4823, 4919, 5255, 4391, 4439, 5207],
            [4824, 4920, 5256, 4392, 4440, 5208],
            [4825, 4921, 5257, 4393, 4441, 5209],
            [4826, 4922, 5258, 4394, 4442, 5210],
            [4827, 4923, 5259, 4395, 4443, 5211],
            [4828, 4924, 5260, 4396, 4444, 5212],
            [4829, 4925, 5261, 4397, 4445, 5213],
            [4830, 4926, 5262, 4398, 4446, 5214],
            [4831, 4927, 5263, 4399, 4447, 5215],
            [4832, 4928, 5264, 4400, 4448, 5216],
            [4833, 4929, 5265, 4401, 4449, 5217],
            [4834, 4930, 5266, 4402, 4450, 5218],
            [4835, 4931, 5267, 4403, 4451, 5219],
            [4836, 4932, 5268, 4404, 4452, 5220],
            [4837, 4933, 5269, 4405, 4453, 5221],
            [4838, 4934, 5270, 4406, 4454, 5222],
            [4839, 4935, 5271, 4407, 4455, 5223],
            [4840, 4936, 5272, 4408, 4456, 5224],
            [4841, 4937, 5273, 4409, 4457, 5225],
            [4842, 4938, 5274, 4410, 4458, 5226],
            [4843, 4939, 5275, 4411, 4459, 5227],
            [4844, 4940, 5276, 4412, 4460, 5228],
            [4845, 4941, 5277, 4413, 4461, 5229],
            [4846, 4942, 5278, 4414, 4462, 5230],
            [4847, 4943, 5279, 4415, 4463, 5231],
            [4848, 4944, 5280, 4416, 4464, 5232],
            [4849, 4945, 5281, 4417, 4465, 5233],
            [4850, 4946, 5282, 4418, 4466, 5234],
            [4851, 4947, 5283, 4419, 4467, 5235],
            [4852, 4948, 5284, 4420, 4468, 5236],
            [4853, 4949, 5285, 4421, 4469, 5237],
            [4854, 4950, 5286, 4422, 4470, 5238],
            [4855, 4951, 5287, 4423, 4471, 5239],
            [4856, 4952, 5288, 4424, 4472, 5240],
            [4857, 4953, 5289, 4425, 4473, 5241],
            [4858, 4954, 5290, 4426, 4474, 5242],
            [4859, 4955, 5291, 4427, 4475, 5243],
            [4860, 4956, 5292, 4428, 4476, 5244],
            [4861, 4957, 5293, 4429, 4477, 5245],
            [4862, 4958, 5294, 4430, 4478, 5246],
            [4863, 4959, 5295, 4431, 4479, 5247],
            [4864, 4960, 5296, 4432, 4480, 5248],
            [4865, 4961, 5297, 4433, 4481, 5249],
            [4866, 4962, 5298, 4434, 4482, 5250],
            [4867, 4963, 5299, 4435, 4483, 5251],
            [4868, 4964, 5300, 4436, 4484, 5252],
            [4869, 4965, 5301, 4437, 4485, 5253],
            [4870, 4966, 5302, 4438, 4486, 5254],
            [4871, 4967, 5303, 4439, 4487, 5255],
            [4872, 4968, 5304, 4440, 4488, 5256],
            [4873, 4969, 5305, 4441, 4489, 5257],
            [4874, 4970, 5306, 4442, 4490, 5258],
            [4875, 4971, 5307, 4443, 4491, 5259],
            [4876, 4972, 5308, 4444, 4492, 5260],
            [4877, 4973, 5309, 4445, 4493, 5261],
            [4878, 4974, 5310, 4446, 4494, 5262],
            [4879, 4975, 5311, 4447, 4495, 5263],
            [4880, 4976, 5312, 4448, 4496, 5264],
            [4881, 4977, 5313, 4449, 4497, 5265],
            [4882, 4978, 5314, 4450, 4498, 5266],
            [4883, 4979, 5315, 4451, 4499, 5267],
            [4884, 4980, 5316, 4452, 4500, 5268],
            [4885, 4981, 5317, 4453, 4501, 5269],
            [4886, 4982, 5318, 4454, 4502, 5270],
            [4887, 4983, 5319, 4455, 4503, 5271],
            [4888, 4984, 5320, 4456, 4504, 5272],
            [4889, 4985, 5321, 4457, 4505, 5273],
            [4890, 4986, 5322, 4458, 4506, 5274],
            [4891, 4987, 5323, 4459, 4507, 5275],
            [4892, 4988, 5324, 4460, 4508, 5276],
            [4893, 4989, 5325, 4461, 4509, 5277],
            [4894, 4990, 5326, 4462, 4510, 5278],
            [4895, 4991, 5327, 4463, 4511, 5279],
            [4896, 4992, 5328, 4464, 4512, 5280],
            [4897, 4993, 5329, 4465, 4513, 5281],
            [4898, 4994, 5330, 4466, 4514, 5282],
            [4899, 4995, 5331, 4467, 4515, 5283],
            [4900, 4996, 5332, 4468, 4516, 5284],
            [4901, 4997, 5333, 4469, 4517, 5285],
            [4902, 4998, 5334, 4470, 4518, 5286],
            [4903, 4999, 5335, 4471, 4519, 5287],
            [4904, 5000, 5336, 4472, 4520, 5288],
            [4905, 5001, 5337, 4473, 4521, 5289],
            [4906, 5002, 5338, 4474, 4522, 5290],
            [4907, 5003, 5339, 4475, 4523, 5291],
            [4908, 5004, 5340, 4476, 4524, 5292],
            [4909, 5005, 5341, 4477, 4525, 5293],
            [4910, 5006, 5342, 4478, 4526, 5294],
            [4911, 5007, 5343, 4479, 4527, 5295],
            [4912, 5008, 5344, 4480, 4528, 5296],
            [4913, 5009, 5345, 4481, 4529, 5297],
            [4914, 5010, 5346, 4482, 4530, 5298],
            [4915, 5011, 5347, 4483, 4531, 5299],
            [4916, 5012, 5348, 4484, 4532, 5300],
            [4917, 5013, 5349, 4485, 4533, 5301],
            [4918, 5014, 5350, 4486, 4534, 5302],
            [4919, 5015, 5351, 4487, 4535, 5303],
            [4920, 5016, 5352, 4488, 4536, 5304],
            [4921, 5017, 5353, 4489, 4537, 5305],
            [4922, 5018, 5354, 4490, 4538, 5306],
            [4923, 5019, 5355, 4491, 4539, 5307],
            [4924, 5020, 5356, 4492, 4540, 5308],
            [4925, 5021, 5357, 4493, 4541, 5309],
            [4926, 5022, 5358, 4494, 4542, 5310],
            [4927, 5023, 5359, 4495, 4543, 5311],
            [4928, 5024, 5360, 4496, 4544, 5312],
            [4929, 5025, 5361, 4497, 4545, 5313],
            [4930, 5026, 5362, 4498, 4546, 5314],
            [4931, 5027, 5363, 4499, 4547, 5315],
            [4932, 5028, 5364, 4500, 4548, 5316],
            [4933, 5029, 5365, 4501, 4549, 5317],
            [4934, 5030, 5366, 4502, 4550, 5318],
            [4935, 5031, 5367, 4503, 4551, 5319],
            [4936, 5032, 5368, 4504, 4552, 5320],
            [4937, 5033, 5369, 4505, 4553, 5321],
            [4938, 5034, 5370, 4506, 4554, 5322],
            [4939, 5035, 5371, 4507, 4555, 5323],
            [4940, 5036, 5372, 4508, 4556, 5324],
            [4941, 5037, 5373, 4509, 4557, 5325],
            [4942, 5038, 5374, 4510, 4558, 5326],
            [4943, 5039, 5375, 4511, 4559, 5327],
            [4944, 5040, 5376, 4512, 4560, 5328],
            [4945, 5041, 5377, 4513, 4561, 5329],
            [4946, 658, 682, 4514, 4562, 5330],
            [4947, 659, 683, 4515, 4563, 5331],
            [4948, 660, 684, 4516, 4564, 5332],
            [4949, 661, 685, 4517, 4565, 5333],
            [4950, 662, 686, 4518, 4566, 5334],
            [4951, 663, 687, 4519, 4567, 5335],
            [4952, 664, 688, 4520, 4568, 5336],
            [4953, 665, 689, 4521, 4569, 5337],
            [4954, 650, 674, 4522, 4570, 5338],
            [4955, 651, 675, 4523, 4571, 5339],
            [4956, 652, 676, 4524, 4572, 5340],
            [4957, 653, 677, 4525, 4573, 5341],
            [4958, 654, 678, 4526, 4574, 5342],
            [4959, 655, 679, 4527, 4575, 5343],
            [4960, 656, 680, 4528, 4576, 5344],
            [4961, 657, 681, 4529, 4577, 5345],
            [4962, 666, 690, 4530, 4578, 5346],
            [4963, 667, 691, 4531, 4579, 5347],
            [4964, 668, 692, 4532, 4580, 5348],
            [4965, 669, 693, 4533, 4581, 5349],
            [4966, 670, 694, 4534, 4582, 5350],
            [4967, 671, 695, 4535, 4583, 5351],
            [4968, 672, 696, 4536, 4584, 5352],
            [4969, 673, 697, 4537, 4585, 5353],
            [4970, 666, 690, 4538, 4586, 5354],
            [4971, 667, 691, 4539, 4587, 5355],
            [4972, 668, 692, 4540, 4588, 5356],
            [4973, 669, 693, 4541, 4589, 5357],
            [4974, 670, 694, 4542, 4590, 5358],
            [4975, 671, 695, 4543, 4591, 5359],
            [4976, 672, 696, 4544, 4592, 5360],
            [4977, 673, 697, 4545, 4593, 5361],
            [4978, 650, 674, 4546, 4594, 5362],
            [4979, 651, 675, 4547, 4595, 5363],
            [4980, 652, 676, 4548, 4596, 5364],
            [4981, 653, 677, 4549, 4597, 5365],
            [4982, 654, 678, 4550, 4598, 5366],
            [4983, 655, 679, 4551, 4599, 5367],
            [4984, 656, 680, 4552, 4600, 5368],
            [4985, 657, 681, 4553, 4601, 5369],
            [4986, 658, 682, 4554, 4602, 5370],
            [4987, 659, 683, 4555, 4603, 5371],
            [4988, 660, 684, 4556, 4604, 5372],
            [4989, 661, 685, 4557, 4605, 5373],
            [4990, 662, 686, 4558, 4606, 5374],
            [4991, 663, 687, 4559, 4607, 5375],
            [4992, 664, 688, 4560, 4608, 5376],
            [4993, 665, 689, 4561, 4609, 5377],
            [922, 5090, 4658, 946, 4706, 5044],
            [923, 5091, 4659, 947, 4707, 5045],
            [922, 5092, 4660, 946, 4708, 5042],
            [923, 5093, 4661, 947, 4709, 5043],
            [924, 5094, 4662, 948, 4710, 5048],
            [925, 5095, 4663, 949, 4711, 5049],
            [924, 5096, 4664, 948, 4712, 5046],
            [925, 5097, 4665, 949, 4713, 5047],
            [914, 5098, 4666, 938, 4714, 5054],
            [915, 5099, 4667, 939, 4715, 5055],
            [916, 5100, 4668, 940, 4716, 5056],
            [917, 5101, 4669, 941, 4717, 5057],
            [914, 5102, 4670, 938, 4718, 5050],
            [915, 5103, 4671, 939, 4719, 5051],
            [916, 5104, 4672, 940, 4720, 5052],
            [917, 5105, 4673, 941, 4721, 5053],
            [930, 5106, 4674, 954, 4722, 5059],
            [930, 5107, 4675, 954, 4723, 5058],
            [931, 5108, 4676, 955, 4724, 5061],
            [931, 5109, 4677, 955, 4725, 5060],
            [932, 5110, 4678, 956, 4726, 5063],
            [932, 5111, 4679, 956, 4727, 5062],
            [933, 5112, 4680, 957, 4728, 5065],
            [933, 5113, 4681, 957, 4729, 5064],
            [934, 5114, 4682, 958, 4730, 5067],
            [934, 5115, 4683, 958, 4731, 5066],
            [935, 5116, 4684, 959, 4732, 5069],
            [935, 5117, 4685, 959, 4733, 5068],
            [936, 5118, 4686, 960, 4734, 5071],
            [936, 5119, 4687, 960, 4735, 5070],
            [937, 5120, 4688, 961, 4736, 5073],
            [937, 5121, 4689, 961, 4737, 5072],
            [918, 5122, 4690, 942, 4738, 5078],
            [919, 5123, 4691, 943, 4739, 5079],
            [920, 5124, 4692, 944, 4740, 5080],
            [921, 5125, 4693, 945, 4741, 5081],
            [918, 5126, 4694, 942, 4742, 5074],
            [919, 5127, 4695, 943, 4743, 5075],
            [920, 5128, 4696, 944, 4744, 5076],
            [921, 5129, 4697, 945, 4745, 5077],
            [926, 5130, 4698, 950, 4746, 5084],
            [927, 5131, 4699, 951, 4747, 5085],
            [926, 5132, 4700, 950, 4748, 5082],
            [927, 5133, 4701, 951, 4749, 5083],
            [928, 5134, 4702, 952, 4750, 5088],
            [929, 5135, 4703, 953, 4751, 5089],
            [928, 5136, 4704, 952, 4752, 5086],
            [929, 5137, 4705, 953, 4753, 5087],
            [5042, 5138, 4706, 5378, 4754, 946],
            [5043, 5139, 4707, 5379, 4755, 947],
            [5044, 5140, 4708, 5380, 4756, 946],
            [5045, 5141, 4709, 5381, 4757, 947],
            [5046, 5142, 4710, 5382, 4758, 948],
            [5047, 5143, 4711, 5383, 4759, 949],
            [5048, 5144, 4712, 5384, 4760, 948],
            [5049, 5145, 4713, 5385, 4761, 949],
            [5050, 5146, 4714, 5386, 4762, 938],
            [5051, 5147, 4715, 5387, 4763, 939],
            [5052, 5148, 4716, 5388, 4764, 940],
            [5053, 5149, 4717, 5389, 4765, 941],
            [5054, 5150, 4718, 5390, 4766, 938],
            [5055, 5151, 4719, 5391, 4767, 939],
            [5056, 5152, 4720, 5392, 4768, 940],
            [5057, 5153, 4721, 5393, 4769, 941],
            [5058, 5154, 4722, 5394, 4770, 954],
            [5059, 5155, 4723, 5395, 4771, 954],
            [5060, 5156, 4724, 5396, 4772, 955],
            [5061, 5157, 4725, 5397, 4773, 955],
            [5062, 5158, 4726, 5398, 4774, 956],
            [5063, 5159, 4727, 5399, 4775, 956],
            [5064, 5160, 4728, 5400, 4776, 957],
            [5065, 5161, 4729, 5401, 4777, 957],
            [5066, 5162, 4730, 5402, 4778, 958],
            [5067, 5163, 4731, 5403, 4779, 958],
            [5068, 5164, 4732, 5404, 4780, 959],
            [5069, 5165, 4733, 5405, 4781, 959],
            [5070, 5166, 4734, 5406, 4782, 960],
            [5071, 5167, 4735, 5407, 4783, 960],
            [5072, 5168, 4736, 5408, 4784, 961],
            [5073, 5169, 4737, 5409, 4785, 961],
            [5074, 5170, 4738, 5410, 4786, 942],
            [5075, 5171, 4739, 5411, 4787, 943],
            [5076, 5172, 4740, 5412, 4788, 944],
            [5077, 5173, 4741, 5413, 4789, 945],
            [5078, 5174, 4742, 5414, 4790, 942],
            [5079, 5175, 4743, 5415, 4791, 943],
            [5080, 5176, 4744, 5416, 4792, 944],
            [5081, 5177, 4745, 5417, 4793, 945],
            [5082, 5178, 4746, 5418, 4794, 950],
            [5083, 5179, 4747, 5419, 4795, 951],
            [5084, 5180, 4748, 5420, 4796, 950],
            [5085, 5181, 4749, 5421, 4797, 951],
            [5086, 5182, 4750, 5422, 4798, 952],
            [5087, 5183, 4751, 5423, 4799, 953],
            [5088, 5184, 4752, 5424, 4800, 952],
            [5089, 5185, 4753, 5425, 4801, 953],
            [5090, 5186, 5426, 4754, 4802, 5378],
            [5091, 5187, 5427, 4755, 4803, 5379],
            [5092, 5188, 5428, 4756, 4804, 5380],
            [5093, 5189, 5429, 4757, 4805, 5381],
            [5094, 5190, 5430, 4758, 4806, 5382],
            [5095, 5191, 5431, 4759, 4807, 5383],
            [5096, 5192, 5432, 4760, 4808, 5384],
            [5097, 5193, 5433, 4761, 4809, 5385],
            [5098, 5194, 5434, 4762, 4810, 5386],
            [5099, 5195, 5435, 4763, 4811, 5387],
            [5100, 5196, 5436, 4764, 4812, 5388],
            [5101, 5197, 5437, 4765, 4813, 5389],
            [5102, 5198, 5438, 4766, 4814, 5390],
            [5103, 5199, 5439, 4767, 4815, 5391],
            [5104, 5200, 5440, 4768, 4816, 5392],
            [5105, 5201, 5441, 4769, 4817, 5393],
            [5106, 5202, 5442, 4770, 4818, 5394],
            [5107, 5203, 5443, 4771, 4819, 5395],
            [5108, 5204, 5444, 4772, 4820, 5396],
            [5109, 5205, 5445, 4773, 4821, 5397],
            [5110, 5206, 5446, 4774, 4822, 5398],
            [5111, 5207, 5447, 4775, 4823, 5399],
            [5112, 5208, 5448, 4776, 4824, 5400],
            [5113, 5209, 5449, 4777, 4825, 5401],
            [5114, 5210, 5450, 4778, 4826, 5402],
            [5115, 5211, 5451, 4779, 4827, 5403],
            [5116, 5212, 5452, 4780, 4828, 5404],
            [5117, 5213, 5453, 4781, 4829, 5405],
            [5118, 5214, 5454, 4782, 4830, 5406],
            [5119, 5215, 5455, 4783, 4831, 5407],
            [5120, 5216, 5456, 4784, 4832, 5408],
            [5121, 5217, 5457, 4785, 4833, 5409],
            [5122, 5218, 5458, 4786, 4834, 5410],
            [5123, 5219, 5459, 4787, 4835, 5411],
            [5124, 5220, 5460, 4788, 4836, 5412],
            [5125, 5221, 5461, 4789, 4837, 5413],
            [5126, 5222, 5462, 4790, 4838, 5414],
            [5127, 5223, 5463, 4791, 4839, 5415],
            [5128, 5224, 5464, 4792, 4840, 5416],
            [5129, 5225, 5465, 4793, 4841, 5417],
            [5130, 5226, 5466, 4794, 4842, 5418],
            [5131, 5227, 5467, 4795, 4843, 5419],
            [5132, 5228, 5468, 4796, 4844, 5420],
            [5133, 5229, 5469, 4797, 4845, 5421],
            [5134, 5230, 5470, 4798, 4846, 5422],
            [5135, 5231, 5471, 4799, 4847, 5423],
            [5136, 5232, 5472, 4800, 4848, 5424],
            [5137, 5233, 5473, 4801, 4849, 5425],
            [5138, 5234, 5474, 4802, 4850, 5426],
            [5139, 5235, 5475, 4803, 4851, 5427],
            [5140, 5236, 5476, 4804, 4852, 5428],
            [5141, 5237, 5477, 4805, 4853, 5429],
            [5142, 5238, 5478, 4806, 4854, 5430],
            [5143, 5239, 5479, 4807, 4855, 5431],
            [5144, 5240, 5480, 4808, 4856, 5432],
            [5145, 5241, 5481, 4809, 4857, 5433],
            [5146, 5242, 5482, 4810, 4858, 5434],
            [5147, 5243, 5483, 4811, 4859, 5435],
            [5148, 5244, 5484, 4812, 4860, 5436],
            [5149, 5245, 5485, 4813, 4861, 5437],
            [5150, 5246, 5486, 4814, 4862, 5438],
            [5151, 5247, 5487, 4815, 4863, 5439],
            [5152, 5248, 5488, 4816, 4864, 5440],
            [5153, 5249, 5489, 4817, 4865, 5441],
            [5154, 5250, 5490, 4818, 4866, 5442],
            [5155, 5251, 5491, 4819, 4867, 5443],
            [5156, 5252, 5492, 4820, 4868, 5444],
            [5157, 5253, 5493, 4821, 4869, 5445],
            [5158, 5254, 5494, 4822, 4870, 5446],
            [5159, 5255, 5495, 4823, 4871, 5447],
            [5160, 5256, 5496, 4824, 4872, 5448],
            [5161, 5257, 5497, 4825, 4873, 5449],
            [5162, 5258, 5498, 4826, 4874, 5450],
            [5163, 5259, 5499, 4827, 4875, 5451],
            [5164, 5260, 5500, 4828, 4876, 5452],
            [5165, 5261, 5501, 4829, 4877, 5453],
            [5166, 5262, 5502, 4830, 4878, 5454],
            [5167, 5263, 5503, 4831, 4879, 5455],
            [5168, 5264, 5504, 4832, 4880, 5456],
            [5169, 5265, 5505, 4833, 4881, 5457],
            [5170, 5266, 5506, 4834, 4882, 5458],
            [5171, 5267, 5507, 4835, 4883, 5459],
            [5172, 5268, 5508, 4836, 4884, 5460],
            [5173, 5269, 5509, 4837, 4885, 5461],
            [5174, 5270, 5510, 4838, 4886, 5462],
            [5175, 5271, 5511, 4839, 4887, 5463],
            [5176, 5272, 5512, 4840, 4888, 5464],
            [5177, 5273, 5513, 4841, 4889, 5465],
            [5178, 5274, 5514, 4842, 4890, 5466],
            [5179, 5275, 5515, 4843, 4891, 5467],
            [5180, 5276, 5516, 4844, 4892, 5468],
            [5181, 5277, 5517, 4845, 4893, 5469],
            [5182, 5278, 5518, 4846, 4894, 5470],
            [5183, 5279, 5519, 4847, 4895, 5471],
            [5184, 5280, 5520, 4848, 4896, 5472],
            [5185, 5281, 5521, 4849, 4897, 5473],
            [5186, 5282, 5522, 4850, 4898, 5474],
            [5187, 5283, 5523, 4851, 4899, 5475],
            [5188, 5284, 5524, 4852, 4900, 5476],
            [5189, 5285, 5525, 4853, 4901, 5477],
            [5190, 5286, 5526, 4854, 4902, 5478],
            [5191, 5287, 5527, 4855, 4903, 5479],
            [5192, 5288, 5528, 4856, 4904, 5480],
            [5193, 5289, 5529, 4857, 4905, 5481],
            [5194, 5290, 5530, 4858, 4906, 5482],
            [5195, 5291, 5531, 4859, 4907, 5483],
            [5196, 5292, 5532, 4860, 4908, 5484],
            [5197, 5293, 5533, 4861, 4909, 5485],
            [5198, 5294, 5534, 4862, 4910, 5486],
            [5199, 5295, 5535, 4863, 4911, 5487],
            [5200, 5296, 5536, 4864, 4912, 5488],
            [5201, 5297, 5537, 4865, 4913, 5489],
            [5202, 5298, 5538, 4866, 4914, 5490],
            [5203, 5299, 5539, 4867, 4915, 5491],
            [5204, 5300, 5540, 4868, 4916, 5492],
            [5205, 5301, 5541, 4869, 4917, 5493],
            [5206, 5302, 5542, 4870, 4918, 5494],
            [5207, 5303, 5543, 4871, 4919, 5495],
            [5208, 5304, 5544, 4872, 4920, 5496],
            [5209, 5305, 5545, 4873, 4921, 5497],
            [5210, 5306, 5546, 4874, 4922, 5498],
            [5211, 5307, 5547, 4875, 4923, 5499],
            [5212, 5308, 5548, 4876, 4924, 5500],
            [5213, 5309, 5549, 4877, 4925, 5501],
            [5214, 5310, 5550, 4878, 4926, 5502],
            [5215, 5311, 5551, 4879, 4927, 5503],
            [5216, 5312, 5552, 4880, 4928, 5504],
            [5217, 5313, 5553, 4881, 4929, 5505],
            [5218, 5314, 5554, 4882, 4930, 5506],
            [5219, 5315, 5555, 4883, 4931, 5507],
            [5220, 5316, 5556, 4884, 4932, 5508],
            [5221, 5317, 5557, 4885, 4933, 5509],
            [5222, 5318, 5558, 4886, 4934, 5510],
            [5223, 5319, 5559, 4887, 4935, 5511],
            [5224, 5320, 5560, 4888, 4936, 5512],
            [5225, 5321, 5561, 4889, 4937, 5513],
            [5226, 5322, 5562, 4890, 4938, 5514],
            [5227, 5323, 5563, 4891, 4939, 5515],
            [5228, 5324, 5564, 4892, 4940, 5516],
            [5229, 5325, 5565, 4893, 4941, 5517],
            [5230, 5326, 5566, 4894, 4942, 5518],
            [5231, 5327, 5567, 4895, 4943, 5519],
            [5232, 5328, 5568, 4896, 4944, 5520],
            [5233, 5329, 5569, 4897, 4945, 5521],
            [5234, 5330, 5570, 4898, 4946, 5522],
            [5235, 5331, 5571, 4899, 4947, 5523],
            [5236, 5332, 5572, 4900, 4948, 5524],
            [5237, 5333, 5573, 4901, 4949, 5525],
            [5238, 5334, 5574, 4902, 4950, 5526],
            [5239, 5335, 5575, 4903, 4951, 5527],
            [5240, 5336, 5576, 4904, 4952, 5528],
            [5241, 5337, 5577, 4905, 4953, 5529],
            [5242, 5338, 5578, 4906, 4954, 5530],
            [5243, 5339, 5579, 4907, 4955, 5531],
            [5244, 5340, 5580, 4908, 4956, 5532],
            [5245, 5341, 5581, 4909, 4957, 5533],
            [5246, 5342, 5582, 4910, 4958, 5534],
            [5247, 5343, 5583, 4911, 4959, 5535],
            [5248, 5344, 5584, 4912, 4960, 5536],
            [5249, 5345, 5585, 4913, 4961, 5537],
            [5250, 5346, 5586, 4914, 4962, 5538],
            [5251, 5347, 5587, 4915, 4963, 5539],
            [5252, 5348, 5588, 4916, 4964, 5540],
            [5253, 5349, 5589, 4917, 4965, 5541],
            [5254, 5350, 5590, 4918, 4966, 5542],
            [5255, 5351, 5591, 4919, 4967, 5543],
            [5256, 5352, 5592, 4920, 4968, 5544],
            [5257, 5353, 5593, 4921, 4969, 5545],
            [5258, 5354, 5594, 4922, 4970, 5546],
            [5259, 5355, 5595, 4923, 4971, 5547],
            [5260, 5356, 5596, 4924, 4972, 5548],
            [5261, 5357, 5597, 4925, 4973, 5549],
            [5262, 5358, 5598, 4926, 4974, 5550],
            [5263, 5359, 5599, 4927, 4975, 5551],
            [5264, 5360, 5600, 4928, 4976, 5552],
            [5265, 5361, 5601, 4929, 4977, 5553],
            [5266, 5362, 5602, 4930, 4978, 5554],
            [5267, 5363, 5603, 4931, 4979, 5555],
            [5268, 5364, 5604, 4932, 4980, 5556],
            [5269, 5365, 5605, 4933, 4981, 5557],
            [5270, 5366, 5606, 4934, 4982, 5558],
            [5271, 5367, 5607, 4935, 4983, 5559],
            [5272, 5368, 5608, 4936, 4984, 5560],
            [5273, 5369, 5609, 4937, 4985, 5561],
            [5274, 5370, 5610, 4938, 4986, 5562],
            [5275, 5371, 5611, 4939, 4987, 5563],
            [5276, 5372, 5612, 4940, 4988, 5564],
            [5277, 5373, 5613, 4941, 4989, 5565],
            [5278, 5374, 5614, 4942, 4990, 5566],
            [5279, 5375, 5615, 4943, 4991, 5567],
            [5280, 5376, 5616, 4944, 4992, 5568],
            [5281, 5377, 5617, 4945, 4993, 5569],
            [5282, 682, 706, 4946, 4994, 5570],
            [5283, 683, 707, 4947, 4995, 5571],
            [5284, 684, 708, 4948, 4996, 5572],
            [5285, 685, 709, 4949, 4997, 5573],
            [5286, 686, 710, 4950, 4998, 5574],
            [5287, 687, 711, 4951, 4999, 5575],
            [5288, 688, 712, 4952, 5000, 5576],
            [5289, 689, 713, 4953, 5001, 5577],
            [5290, 674, 698, 4954, 5002, 5578],
            [5291, 675, 699, 4955, 5003, 5579],
            [5292, 676, 700, 4956, 5004, 5580],
            [5293, 677, 701, 4957, 5005, 5581],
            [5294, 678, 702, 4958, 5006, 5582],
            [5295, 679, 703, 4959, 5007, 5583],
            [5296, 680, 704, 4960, 5008, 5584],
            [5297, 681, 705, 4961, 5009, 5585],
            [5298, 690, 714, 4962, 5010, 5586],
            [5299, 691, 715, 4963, 5011, 5587],
            [5300, 692, 716, 4964, 5012, 5588],
            [5301, 693, 717, 4965, 5013, 5589],
            [5302, 694, 718, 4966, 5014, 5590],
            [5303, 695, 719, 4967, 5015, 5591],
            [5304, 696, 720, 4968, 5016, 5592],
            [5305, 697, 721, 4969, 5017, 5593],
            [5306, 690, 714, 4970, 5018, 5594],
            [5307, 691, 715, 4971, 5019, 5595],
            [5308, 692, 716, 4972, 5020, 5596],
            [5309, 693, 717, 4973, 5021, 5597],
            [5310, 694, 718, 4974, 5022, 5598],
            [5311, 695, 719, 4975, 5023, 5599],
            [5312, 696, 720, 4976, 5024, 5600],
            [5313, 697, 721, 4977, 5025, 5601],
            [5314, 674, 698, 4978, 5026, 5602],
            [5315, 675, 699, 4979, 5027, 5603],
            [5316, 676, 700, 4980, 5028, 5604],
            [5317, 677, 701, 4981, 5029, 5605],
            [5318, 678, 702, 4982, 5030, 5606],
            [5319, 679, 703, 4983, 5031, 5607],
            [5320, 680, 704, 4984, 5032, 5608],
            [5321, 681, 705, 4985, 5033, 5609],
            [5322, 682, 706, 4986, 5034, 5610],
            [5323, 683, 707, 4987, 5035, 5611],
            [5324, 684, 708, 4988, 5036, 5612],
            [5325, 685, 709, 4989, 5037, 5613],
            [5326, 686, 710, 4990, 5038, 5614],
            [5327, 687, 711, 4991, 5039, 5615],
            [5328, 688, 712, 4992, 5040, 5616],
            [5329, 689, 713, 4993, 5041, 5617],
            [946, 5426, 5090, 970, 5138, 5380],
            [947, 5427, 5091, 971, 5139, 5381],
            [946, 5428, 5092, 970, 5140, 5378],
            [947, 5429, 5093, 971, 5141, 5379],
            [948, 5430, 5094, 972, 5142, 5384],
            [949, 5431, 5095, 973, 5143, 5385],
            [948, 5432, 5096, 972, 5144, 5382],
            [949, 5433, 5097, 973, 5145, 5383],
            [938, 5434, 5098, 962, 5146, 5390],
            [939, 5435, 5099, 963, 5147, 5391],
            [940, 5436, 5100, 964, 5148, 5392],
            [941, 5437, 5101, 965, 5149, 5393],
            [938, 5438, 5102, 962, 5150, 5386],
            [939, 5439, 5103, 963, 5151, 5387],
            [940, 5440, 5104, 964, 5152, 5388],
            [941, 5441, 5105, 965, 5153, 5389],
            [954, 5442, 5106, 978, 5154, 5395],
            [954, 5443, 5107, 978, 5155, 5394],
            [955, 5444, 5108, 979, 5156, 5397],
            [955, 5445, 5109, 979, 5157, 5396],
            [956, 5446, 5110, 980, 5158, 5399],
            [956, 5447, 5111, 980, 5159, 5398],
            [957, 5448, 5112, 981, 5160, 5401],
            [957, 5449, 5113, 981, 5161, 5400],
            [958, 5450, 5114, 982, 5162, 5403],
            [958, 5451, 5115, 982, 5163, 5402],
            [959, 5452, 5116, 983, 5164, 5405],
            [959, 5453, 5117, 983, 5165, 5404],
            [960, 5454, 5118, 984, 5166, 5407],
            [960, 5455, 5119, 984, 5167, 5406],
            [961, 5456, 5120, 985, 5168, 5409],
            [961, 5457, 5121, 985, 5169, 5408],
            [942, 5458, 5122, 966, 5170, 5414],
            [943, 5459, 5123, 967, 5171, 5415],
            [944, 5460, 5124, 968, 5172, 5416],
            [945, 5461, 5125, 969, 5173, 5417],
            [942, 5462, 5126, 966, 5174, 5410],
            [943, 5463, 5127, 967, 5175, 5411],
            [944, 5464, 5128, 968, 5176, 5412],
            [945, 5465, 5129, 969, 5177, 5413],
            [950, 5466, 5130, 974, 5178, 5420],
            [951, 5467, 5131, 975, 5179, 5421],
            [950, 5468, 5132, 974, 5180, 5418],
            [951, 5469, 5133, 975, 5181, 5419],
            [952, 5470, 5134, 976, 5182, 5424],
            [953, 5471, 5135, 977, 5183, 5425],
            [952, 5472, 5136, 976, 5184, 5422],
            [953, 5473, 5137, 977, 5185, 5423],
            [5378, 5474, 5618, 5138, 5186, 970],
            [5379, 5475, 5619, 5139, 5187, 971],
            [5380, 5476, 5620, 5140, 5188, 970],
            [5381, 5477, 5621, 5141, 5189, 971],
            [5382, 5478, 5622, 5142, 5190, 972],
            [5383, 5479, 5623, 5143, 5191, 973],
            [5384, 5480, 5624, 5144, 5192, 972],
            [5385, 5481, 5625, 5145, 5193, 973],
            [5386, 5482, 5626, 5146, 5194, 962],
            [5387, 5483, 5627, 5147, 5195, 963],
            [5388, 5484, 5628, 5148, 5196, 964],
            [5389, 5485, 5629, 5149, 5197, 965],
            [5390, 5486, 5630, 5150, 5198, 962],
            [5391, 5487, 5631, 5151, 5199, 963],
            [5392, 5488, 5632, 5152, 5200, 964],
            [5393, 5489, 5633, 5153, 5201, 965],
            [5394, 5490, 5634, 5154, 5202, 978],
            [5395, 5491, 5635, 5155, 5203, 978],
            [5396, 5492, 5636, 5156, 5204, 979],
            [5397, 5493, 5637, 5157, 5205, 979],
            [5398, 5494, 5638, 5158, 5206, 980],
            [5399, 5495, 5639, 5159, 5207, 980],
            [5400, 5496, 5640, 5160, 5208, 981],
            [5401, 5497, 5641, 5161, 5209, 981],
            [5402, 5498, 5642, 5162, 5210, 982],
            [5403, 5499, 5643, 5163, 5211, 982],
            [5404, 5500, 5644, 5164, 5212, 983],
            [5405, 5501, 5645, 5165, 5213, 983],
            [5406, 5502, 5646, 5166, 5214, 984],
            [5407, 5503, 5647, 5167, 5215, 984],
            [5408, 5504, 5648, 5168, 5216, 985],
            [5409, 5505, 5649, 5169, 5217, 985],
            [5410, 5506, 5650, 5170, 5218, 966],
            [5411, 5507, 5651, 5171, 5219, 967],
            [5412, 5508, 5652, 5172, 5220, 968],
            [5413, 5509, 5653, 5173, 5221, 969],
            [5414, 5510, 5654, 5174, 5222, 966],
            [5415, 5511, 5655, 5175, 5223, 967],
            [5416, 5512, 5656, 5176, 5224, 968],
            [5417, 5513, 5657, 5177, 5225, 969],
            [5418, 5514, 5658, 5178, 5226, 974],
            [5419, 5515, 5659, 5179, 5227, 975],
            [5420, 5516, 5660, 5180, 5228, 974],
            [5421, 5517, 5661, 5181, 5229, 975],
            [5422, 5518, 5662, 5182, 5230, 976],
            [5423, 5519, 5663, 5183, 5231, 977],
            [5424, 5520, 5664, 5184, 5232, 976],
            [5425, 5521, 5665, 5185, 5233, 977],
            [5426, 5522, 5666, 5186, 5234, 5618],
            [5427, 5523, 5667, 5187, 5235, 5619],
            [5428, 5524, 5668, 5188, 5236, 5620],
            [5429, 5525, 5669, 5189, 5237, 5621],
            [5430, 5526, 5670, 5190, 5238, 5622],
            [5431, 5527, 5671, 5191, 5239, 5623],
            [5432, 5528, 5672, 5192, 5240, 5624],
            [5433, 5529, 5673, 5193, 5241, 5625],
            [5434, 5530, 5674, 5194, 5242, 5626],
            [5435, 5531, 5675, 5195, 5243, 5627],
            [5436, 5532, 5676, 5196, 5244, 5628],
            [5437, 5533, 5677, 5197, 5245, 5629],
            [5438, 5534, 5678, 5198, 5246, 5630],
            [5439, 5535, 5679, 5199, 5247, 5631],
            [5440, 5536, 5680, 5200, 5248, 5632],
            [5441, 5537, 5681, 5201, 5249, 5633],
            [5442, 5538, 5682, 5202, 5250, 5634],
            [5443, 5539, 5683, 5203, 5251, 5635],
            [5444, 5540, 5684, 5204, 5252, 5636],
            [5445, 5541, 5685, 5205, 5253, 5637],
            [5446, 5542, 5686, 5206, 5254, 5638],
            [5447, 5543, 5687, 5207, 5255, 5639],
            [5448, 5544, 5688, 5208, 5256, 5640],
            [5449, 5545, 5689, 5209, 5257, 5641],
            [5450, 5546, 5690, 5210, 5258, 5642],
            [5451, 5547, 5691, 5211, 5259, 5643],
            [5452, 5548, 5692, 5212, 5260, 5644],
            [5453, 5549, 5693, 5213, 5261, 5645],
            [5454, 5550, 5694, 5214, 5262, 5646],
            [5455, 5551, 5695, 5215, 5263, 5647],
            [5456, 5552, 5696, 5216, 5264, 5648],
            [5457, 5553, 5697, 5217, 5265, 5649],
            [5458, 5554, 5698, 5218, 5266, 5650],
            [5459, 5555, 5699, 5219, 5267, 5651],
            [5460, 5556, 5700, 5220, 5268, 5652],
            [5461, 5557, 5701, 5221, 5269, 5653],
            [5462, 5558, 5702, 5222, 5270, 5654],
            [5463, 5559, 5703, 5223, 5271, 5655],
            [5464, 5560, 5704, 5224, 5272, 5656],
            [5465, 5561, 5705, 5225, 5273, 5657],
            [5466, 5562, 5706, 5226, 5274, 5658],
            [5467, 5563, 5707, 5227, 5275, 5659],
            [5468, 5564, 5708, 5228, 5276, 5660],
            [5469, 5565, 5709, 5229, 5277, 5661],
            [5470, 5566, 5710, 5230, 5278, 5662],
            [5471, 5567, 5711, 5231, 5279, 5663],
            [5472, 5568, 5712, 5232, 5280, 5664],
            [5473, 5569, 5713, 5233, 5281, 5665],
            [5474, 5570, 5714, 5234, 5282, 5666],
            [5475, 5571, 5715, 5235, 5283, 5667],
            [5476, 5572, 5716, 5236, 5284, 5668],
            [5477, 5573, 5717, 5237, 5285, 5669],
            [5478, 5574, 5718, 5238, 5286, 5670],
            [5479, 5575, 5719, 5239, 5287, 5671],
            [5480, 5576, 5720, 5240, 5288, 5672],
            [5481, 5577, 5721, 5241, 5289, 5673],
            [5482, 5578, 5722, 5242, 5290, 5674],
            [5483, 5579, 5723, 5243, 5291, 5675],
            [5484, 5580, 5724, 5244, 5292, 5676],
            [5485, 5581, 5725, 5245, 5293, 5677],
            [5486, 5582, 5726, 5246, 5294, 5678],
            [5487, 5583, 5727, 5247, 5295, 5679],
            [5488, 5584, 5728, 5248, 5296, 5680],
            [5489, 5585, 5729, 5249, 5297, 5681],
            [5490, 5586, 5730, 5250, 5298, 5682],
            [5491, 5587, 5731, 5251, 5299, 5683],
            [5492, 5588, 5732, 5252, 5300, 5684],
            [5493, 5589, 5733, 5253, 5301, 5685],
            [5494, 5590, 5734, 5254, 5302, 5686],
            [5495, 5591, 5735, 5255, 5303, 5687],
            [5496, 5592, 5736, 5256, 5304, 5688],
            [5497, 5593, 5737, 5257, 5305, 5689],
            [5498, 5594, 5738, 5258, 5306, 5690],
            [5499, 5595, 5739, 5259, 5307, 5691],
            [5500, 5596, 5740, 5260, 5308, 5692],
            [5501, 5597, 5741, 5261, 5309, 5693],
            [5502, 5598, 5742, 5262, 5310, 5694],
            [5503, 5599, 5743, 5263, 5311, 5695],
            [5504, 5600, 5744, 5264, 5312, 5696],
            [5505, 5601, 5745, 5265, 5313, 5697],
            [5506, 5602, 5746, 5266, 5314, 5698],
            [5507, 5603, 5747, 5267, 5315, 5699],
            [5508, 5604, 5748, 5268, 5316, 5700],
            [5509, 5605, 5749, 5269, 5317, 5701],
            [5510, 5606, 5750, 5270, 5318, 5702],
            [5511, 5607, 5751, 5271, 5319, 5703],
            [5512, 5608, 5752, 5272, 5320, 5704],
            [5513, 5609, 5753, 5273, 5321, 5705],
            [5514, 5610, 5754, 5274, 5322, 5706],
            [5515, 5611, 5755, 5275, 5323, 5707],
            [5516, 5612, 5756, 5276, 5324, 5708],
            [5517, 5613, 5757, 5277, 5325, 5709],
            [5518, 5614, 5758, 5278, 5326, 5710],
            [5519, 5615, 5759, 5279, 5327, 5711],
            [5520, 5616, 5760, 5280, 5328, 5712],
            [5521, 5617, 5761, 5281, 5329, 5713],
            [5522, 706, 730, 5282, 5330, 5714],
            [5523, 707, 731, 5283, 5331, 5715],
            [5524, 708, 732, 5284, 5332, 5716],
            [5525, 709, 733, 5285, 5333, 5717],
            [5526, 710, 734, 5286, 5334, 5718],
            [5527, 711, 735, 5287, 5335, 5719],
            [5528, 712, 736, 5288, 5336, 5720],
            [5529, 713, 737, 5289, 5337, 5721],
            [5530, 698, 722, 5290, 5338, 5722],
            [5531, 699, 723, 5291, 5339, 5723],
            [5532, 700, 724, 5292, 5340, 5724],
            [5533, 701, 725, 5293, 5341, 5725],
            [5534, 702, 726, 5294, 5342, 5726],
            [5535, 703, 727, 5295, 5343, 5727],
            [5536, 704, 728, 5296, 5344, 5728],
            [5537, 705, 729, 5297, 5345, 5729],
            [5538, 714, 738, 5298, 5346, 5730],
            [5539, 715, 739, 5299, 5347, 5731],
            [5540, 716, 740, 5300, 5348, 5732],
            [5541, 717, 741, 5301, 5349, 5733],
            [5542, 718, 742, 5302, 5350, 5734],
            [5543, 719, 743, 5303, 5351, 5735],
            [5544, 720, 744, 5304, 5352, 5736],
            [5545, 721, 745, 5305, 5353, 5737],
            [5546, 714, 738, 5306, 5354, 5738],
            [5547, 715, 739, 5307, 5355, 5739],
            [5548, 716, 740, 5308, 5356, 5740],
            [5549, 717, 741, 5309, 5357, 5741],
            [5550, 718, 742, 5310, 5358, 5742],
            [5551, 719, 743, 5311, 5359, 5743],
            [5552, 720, 744, 5312, 5360, 5744],
            [5553, 721, 745, 5313, 5361, 5745],
            [5554, 698, 722, 5314, 5362, 5746],
            [5555, 699, 723, 5315, 5363, 5747],
            [5556, 700, 724, 5316, 5364, 5748],
            [5557, 701, 725, 5317, 5365, 5749],
            [5558, 702, 726, 5318, 5366, 5750],
            [5559, 703, 727, 5319, 5367, 5751],
            [5560, 704, 728, 5320, 5368, 5752],
            [5561, 705, 729, 5321, 5369, 5753],
            [5562, 706, 730, 5322, 5370, 5754],
            [5563, 707, 731, 5323, 5371, 5755],
            [5564, 708, 732, 5324, 5372, 5756],
            [5565, 709, 733, 5325, 5373, 5757],
            [5566, 710, 734, 5326, 5374, 5758],
            [5567, 711, 735, 5327, 5375, 5759],
            [5568, 712, 736, 5328, 5376, 5760],
            [5569, 713, 737, 5329, 5377, 5761],
            [970, 5666, 5426, 994, 5474, 5620],
            [971, 5667, 5427, 995, 5475, 5621],
            [970, 5668, 5428, 994, 5476, 5618],
            [971, 5669, 5429, 995, 5477, 5619],
            [972, 5670, 5430, 996, 5478, 5624],
            [973, 5671, 5431, 997, 5479, 5625],
            [972, 5672, 5432, 996, 5480, 5622],
            [973, 5673, 5433, 997, 5481, 5623],
            [962, 5674, 5434, 986, 5482, 5630],
            [963, 5675, 5435, 987, 5483, 5631],
            [964, 5676, 5436, 988, 5484, 5632],
            [965, 5677, 5437, 989, 5485, 5633],
            [962, 5678, 5438, 986, 5486, 5626],
            [963, 5679, 5439, 987, 5487, 5627],
            [964, 5680, 5440, 988, 5488, 5628],
            [965, 5681, 5441, 989, 5489, 5629],
            [978, 5682, 5442, 1002, 5490, 5635],
            [978, 5683, 5443, 1002, 5491, 5634],
            [979, 5684, 5444, 1003, 5492, 5637],
            [979, 5685, 5445, 1003, 5493, 5636],
            [980, 5686, 5446, 1004, 5494, 5639],
            [980, 5687, 5447, 1004, 5495, 5638],
            [981, 5688, 5448, 1005, 5496, 5641],
            [981, 5689, 5449, 1005, 5497, 5640],
            [982, 5690, 5450, 1006, 5498, 5643],
            [982, 5691, 5451, 1006, 5499, 5642],
            [983, 5692, 5452, 1007, 5500, 5645],
            [983, 5693, 5453, 1007, 5501, 5644],
            [984, 5694, 5454, 1008, 5502, 5647],
            [984, 5695, 5455, 1008, 5503, 5646],
            [985, 5696, 5456, 1009, 5504, 5649],
            [985, 5697, 5457, 1009, 5505, 5648],
            [966, 5698, 5458, 990, 5506, 5654],
            [967, 5699, 5459, 991, 5507, 5655],
            [968, 5700, 5460, 992, 5508, 5656],
            [969, 5701, 5461, 993, 5509, 5657],
            [966, 5702, 5462, 990, 5510, 5650],
            [967, 5703, 5463, 991, 5511, 5651],
            [968, 5704, 5464, 992, 5512, 5652],
            [969, 5705, 5465, 993, 5513, 5653],
            [974, 5706, 5466, 998, 5514, 5660],
            [975, 5707, 5467, 999, 5515, 5661],
            [974, 5708, 5468, 998, 5516, 5658],
            [975, 5709, 5469, 999, 5517, 5659],
            [976, 5710, 5470, 1000, 5518, 5664],
            [977, 5711, 5471, 1001, 5519, 5665],
            [976, 5712, 5472, 1000, 5520, 5662],
            [977, 5713, 5473, 1001, 5521, 5663],
            [5618, 5714, 5762, 5474, 5522, 994],
            [5619, 5715, 5763, 5475, 5523, 995],
            [5620, 5716, 5764, 5476, 5524, 994],
            [5621, 5717, 5765, 5477, 5525, 995],
            [5622, 5718, 5766, 5478, 5526, 996],
            [5623, 5719, 5767, 5479, 5527, 997],
            [5624, 5720, 5768, 5480, 5528, 996],
            [5625, 5721, 5769, 5481, 5529, 997],
            [5626, 5722, 5770, 5482, 5530, 986],
            [5627, 5723, 5771, 5483, 5531, 987],
            [5628, 5724, 5772, 5484, 5532, 988],
            [5629, 5725, 5773, 5485, 5533, 989],
            [5630, 5726, 5774, 5486, 5534, 986],
            [5631, 5727, 5775, 5487, 5535, 987],
            [5632, 5728, 5776, 5488, 5536, 988],
            [5633, 5729, 5777, 5489, 5537, 989],
            [5634, 5730, 5778, 5490, 5538, 1002],
            [5635, 5731, 5779, 5491, 5539, 1002],
            [5636, 5732, 5780, 5492, 5540, 1003],
            [5637, 5733, 5781, 5493, 5541, 1003],
            [5638, 5734, 5782, 5494, 5542, 1004],
            [5639, 5735, 5783, 5495, 5543, 1004],
            [5640, 5736, 5784, 5496, 5544, 1005],
            [5641, 5737, 5785, 5497, 5545, 1005],
            [5642, 5738, 5786, 5498, 5546, 1006],
            [5643, 5739, 5787, 5499, 5547, 1006],
            [5644, 5740, 5788, 5500, 5548, 1007],
            [5645, 5741, 5789, 5501, 5549, 1007],
            [5646, 5742, 5790, 5502, 5550, 1008],
            [5647, 5743, 5791, 5503, 5551, 1008],
            [5648, 5744, 5792, 5504, 5552, 1009],
            [5649, 5745, 5793, 5505, 5553, 1009],
            [5650, 5746, 5794, 5506, 5554, 990],
            [5651, 5747, 5795, 5507, 5555, 991],
            [5652, 5748, 5796, 5508, 5556, 992],
            [5653, 5749, 5797, 5509, 5557, 993],
            [5654, 5750, 5798, 5510, 5558, 990],
            [5655, 5751, 5799, 5511, 5559, 991],
            [5656, 5752, 5800, 5512, 5560, 992],
            [5657, 5753, 5801, 5513, 5561, 993],
            [5658, 5754, 5802, 5514, 5562, 998],
            [5659, 5755, 5803, 5515, 5563, 999],
            [5660, 5756, 5804, 5516, 5564, 998],
            [5661, 5757, 5805, 5517, 5565, 999],
            [5662, 5758, 5806, 5518, 5566, 1000],
            [5663, 5759, 5807, 5519, 5567, 1001],
            [5664, 5760, 5808, 5520, 5568, 1000],
            [5665, 5761, 5809, 5521, 5569, 1001],
            [5666, 730, 754, 5522, 5570, 5762],
            [5667, 731, 755, 5523, 5571, 5763],
            [5668, 732, 756, 5524, 5572, 5764],
            [5669, 733, 757, 5525, 5573, 5765],
            [5670, 734, 758, 5526, 5574, 5766],
            [5671, 735, 759, 5527, 5575, 5767],
            [5672, 736, 760, 5528, 5576, 5768],
            [5673, 737, 761, 5529, 5577, 5769],
            [5674, 722, 746, 5530, 5578, 5770],
            [5675, 723, 747, 5531, 5579, 5771],
            [5676, 724, 748, 5532, 5580, 5772],
            [5677, 725, 749, 5533, 5581, 5773],
            [5678, 726, 750, 5534, 5582, 5774],
            [5679, 727, 751, 5535, 5583, 5775],
            [5680, 728, 752, 5536, 5584, 5776],
            [5681, 729, 753, 5537, 5585, 5777],
            [5682, 738, 762, 5538, 5586, 5778],
            [5683, 739, 763, 5539, 5587, 5779],
            [5684, 740, 764, 5540, 5588, 5780],
            [5685, 741, 765, 5541, 5589, 5781],
            [5686, 742, 766, 5542, 5590, 5782],
            [5687, 743, 767, 5543, 5591, 5783],
            [5688, 744, 768, 5544, 5592, 5784],
            [5689, 745, 769, 5545, 5593, 5785],
            [5690, 738, 762, 5546, 5594, 5786],
            [5691, 739, 763, 5547, 5595, 5787],
            [5692, 740, 764, 5548, 5596, 5788],
            [5693, 741, 765, 5549, 5597, 5789],
            [5694, 742, 766, 5550, 5598, 5790],
            [5695, 743, 767, 5551, 5599, 5791],
            [5696, 744, 768, 5552, 5600, 5792],
            [5697, 745, 769, 5553, 5601, 5793],
            [5698, 722, 746, 5554, 5602, 5794],
            [5699, 723, 747, 5555, 5603, 5795],
            [5700, 724, 748, 5556, 5604, 5796],
            [5701, 725, 749, 5557, 5605, 5797],
            [5702, 726, 750, 5558, 5606, 5798],
            [5703, 727, 751, 5559, 5607, 5799],
            [5704, 728, 752, 5560, 5608, 5800],
            [5705, 729, 753, 5561, 5609, 5801],
            [5706, 730, 754, 5562, 5610, 5802],
            [5707, 731, 755, 5563, 5611, 5803],
            [5708, 732, 756, 5564, 5612, 5804],
            [5709, 733, 757, 5565, 5613, 5805],
            [5710, 734, 758, 5566, 5614, 5806],
            [5711, 735, 759, 5567, 5615, 5807],
            [5712, 736, 760, 5568, 5616, 5808],
            [5713, 737, 761, 5569, 5617, 5809],
            [994, 754, 10, 5666, 5714, 5764],
            [995, 755, 11, 5667, 5715, 5765],
            [994, 756, 10, 5668, 5716, 5762],
            [995, 757, 11, 5669, 5717, 5763],
            [996, 758, 12, 5670, 5718, 5768],
            [997, 759, 13, 5671, 5719, 5769],
            [996, 760, 12, 5672, 5720, 5766],
            [997, 761, 13, 5673, 5721, 5767],
            [986, 746, 14, 5674, 5722, 5774],
            [987, 747, 15, 5675, 5723, 5775],
            [988, 748, 16, 5676, 5724, 5776],
            [989, 749, 17, 5677, 5725, 5777],
            [986, 750, 14, 5678, 5726, 5770],
            [987, 751, 15, 5679, 5727, 5771],
            [988, 752, 16, 5680, 5728, 5772],
            [989, 753, 17, 5681, 5729, 5773],
            [1002, 762, 6, 5682, 5730, 5779],
            [1002, 763, 6, 5683, 5731, 5778],
            [1003, 764, 7, 5684, 5732, 5781],
            [1003, 765, 7, 5685, 5733, 5780],
            [1004, 766, 8, 5686, 5734, 5783],
            [1004, 767, 8, 5687, 5735, 5782],
            [1005, 768, 9, 5688, 5736, 5785],
            [1005, 769, 9, 5689, 5737, 5784],
            [1006, 762, 6, 5690, 5738, 5787],
            [1006, 763, 6, 5691, 5739, 5786],
            [1007, 764, 7, 5692, 5740, 5789],
            [1007, 765, 7, 5693, 5741, 5788],
            [1008, 766, 8, 5694, 5742, 5791],
            [1008, 767, 8, 5695, 5743, 5790],
            [1009, 768, 9, 5696, 5744, 5793],
            [1009, 769, 9, 5697, 5745, 5792],
            [990, 746, 14, 5698, 5746, 5798],
            [991, 747, 15, 5699, 5747, 5799],
            [992, 748, 16, 5700, 5748, 5800],
            [993, 749, 17, 5701, 5749, 5801],
            [990, 750, 14, 5702, 5750, 5794],
            [991, 751, 15, 5703, 5751, 5795],
            [992, 752, 16, 5704, 5752, 5796],
            [993, 753, 17, 5705, 5753, 5797],
            [998, 754, 10, 5706, 5754, 5804],
            [999, 755, 11, 5707, 5755, 5805],
            [998, 756, 10, 5708, 5756, 5802],
            [999, 757, 11, 5709, 5757, 5803],
            [1000, 758, 12, 5710, 5758, 5808],
            [1001, 759, 13, 5711, 5759, 5809],
            [1000, 760, 12, 5712, 5760, 5806],
            [1001, 761, 13, 5713, 5761, 5807],
        ]
