#!/usr/bin/env python3
# -*- coding: utf-8 -*-
__copyright__ = """ This code is licensed under the 3-clause BSD license.
Copyright ETH Zurich, Laboratory of Physical Chemistry, Reiher Group.
See LICENSE.txt for details.
"""
import numpy as np
from typing import List


class UnitCircle:
    """
    A class holding a unit circle of 100 points.
    """

    @property
    def points(self) -> np.ndarray:
        """np.ndarray :: The points of the circle."""
        return self._points

    @property
    def nearest_neighbors(self) -> List[List[int]]:
        """List[List[int]] :: The nearest neighbors of all points on the circle."""
        return self._nearest_neighbors

    def __init__(self):
        self._points = np.array(
            [
                [1.00000000e00, 0.00000000e00],
                [9.98026728e-01, 6.27905195e-02],
                [9.92114701e-01, 1.25333234e-01],
                [9.82287251e-01, 1.87381315e-01],
                [9.68583161e-01, 2.48689887e-01],
                [9.51056516e-01, 3.09016994e-01],
                [9.29776486e-01, 3.68124553e-01],
                [9.04827052e-01, 4.25779292e-01],
                [8.76306680e-01, 4.81753674e-01],
                [8.44327926e-01, 5.35826795e-01],
                [8.09016994e-01, 5.87785252e-01],
                [7.70513243e-01, 6.37423990e-01],
                [7.28968627e-01, 6.84547106e-01],
                [6.84547106e-01, 7.28968627e-01],
                [6.37423990e-01, 7.70513243e-01],
                [5.87785252e-01, 8.09016994e-01],
                [5.35826795e-01, 8.44327926e-01],
                [4.81753674e-01, 8.76306680e-01],
                [4.25779292e-01, 9.04827052e-01],
                [3.68124553e-01, 9.29776486e-01],
                [3.09016994e-01, 9.51056516e-01],
                [2.48689887e-01, 9.68583161e-01],
                [1.87381315e-01, 9.82287251e-01],
                [1.25333234e-01, 9.92114701e-01],
                [6.27905195e-02, 9.98026728e-01],
                [-1.60812265e-16, 1.00000000e00],
                [-6.27905195e-02, 9.98026728e-01],
                [-1.25333234e-01, 9.92114701e-01],
                [-1.87381315e-01, 9.82287251e-01],
                [-2.48689887e-01, 9.68583161e-01],
                [-3.09016994e-01, 9.51056516e-01],
                [-3.68124553e-01, 9.29776486e-01],
                [-4.25779292e-01, 9.04827052e-01],
                [-4.81753674e-01, 8.76306680e-01],
                [-5.35826795e-01, 8.44327926e-01],
                [-5.87785252e-01, 8.09016994e-01],
                [-6.37423990e-01, 7.70513243e-01],
                [-6.84547106e-01, 7.28968627e-01],
                [-7.28968627e-01, 6.84547106e-01],
                [-7.70513243e-01, 6.37423990e-01],
                [-8.09016994e-01, 5.87785252e-01],
                [-8.44327926e-01, 5.35826795e-01],
                [-8.76306680e-01, 4.81753674e-01],
                [-9.04827052e-01, 4.25779292e-01],
                [-9.29776486e-01, 3.68124553e-01],
                [-9.51056516e-01, 3.09016994e-01],
                [-9.68583161e-01, 2.48689887e-01],
                [-9.82287251e-01, 1.87381315e-01],
                [-9.92114701e-01, 1.25333234e-01],
                [-9.98026728e-01, 6.27905195e-02],
                [-1.00000000e00, -3.21624530e-16],
                [-9.98026728e-01, -6.27905195e-02],
                [-9.92114701e-01, -1.25333234e-01],
                [-9.82287251e-01, -1.87381315e-01],
                [-9.68583161e-01, -2.48689887e-01],
                [-9.51056516e-01, -3.09016994e-01],
                [-9.29776486e-01, -3.68124553e-01],
                [-9.04827052e-01, -4.25779292e-01],
                [-8.76306680e-01, -4.81753674e-01],
                [-8.44327926e-01, -5.35826795e-01],
                [-8.09016994e-01, -5.87785252e-01],
                [-7.70513243e-01, -6.37423990e-01],
                [-7.28968627e-01, -6.84547106e-01],
                [-6.84547106e-01, -7.28968627e-01],
                [-6.37423990e-01, -7.70513243e-01],
                [-5.87785252e-01, -8.09016994e-01],
                [-5.35826795e-01, -8.44327926e-01],
                [-4.81753674e-01, -8.76306680e-01],
                [-4.25779292e-01, -9.04827052e-01],
                [-3.68124553e-01, -9.29776486e-01],
                [-3.09016994e-01, -9.51056516e-01],
                [-2.48689887e-01, -9.68583161e-01],
                [-1.87381315e-01, -9.82287251e-01],
                [-1.25333234e-01, -9.92114701e-01],
                [-6.27905195e-02, -9.98026728e-01],
                [-1.83697020e-16, -1.00000000e00],
                [6.27905195e-02, -9.98026728e-01],
                [1.25333234e-01, -9.92114701e-01],
                [1.87381315e-01, -9.82287251e-01],
                [2.48689887e-01, -9.68583161e-01],
                [3.09016994e-01, -9.51056516e-01],
                [3.68124553e-01, -9.29776486e-01],
                [4.25779292e-01, -9.04827052e-01],
                [4.81753674e-01, -8.76306680e-01],
                [5.35826795e-01, -8.44327926e-01],
                [5.87785252e-01, -8.09016994e-01],
                [6.37423990e-01, -7.70513243e-01],
                [6.84547106e-01, -7.28968627e-01],
                [7.28968627e-01, -6.84547106e-01],
                [7.70513243e-01, -6.37423990e-01],
                [8.09016994e-01, -5.87785252e-01],
                [8.44327926e-01, -5.35826795e-01],
                [8.76306680e-01, -4.81753674e-01],
                [9.04827052e-01, -4.25779292e-01],
                [9.29776486e-01, -3.68124553e-01],
                [9.51056516e-01, -3.09016994e-01],
                [9.68583161e-01, -2.48689887e-01],
                [9.82287251e-01, -1.87381315e-01],
                [9.92114701e-01, -1.25333234e-01],
                [9.98026728e-01, -6.27905195e-02],
            ]
        )

        self._nearest_neighbors = [
            [99, 1],
            [0, 2],
            [1, 3],
            [2, 4],
            [3, 5],
            [4, 6],
            [5, 7],
            [6, 8],
            [7, 9],
            [8, 10],
            [9, 11],
            [10, 12],
            [11, 13],
            [12, 14],
            [13, 15],
            [14, 16],
            [15, 17],
            [16, 18],
            [17, 19],
            [18, 20],
            [19, 21],
            [20, 22],
            [21, 23],
            [22, 24],
            [23, 25],
            [24, 26],
            [25, 27],
            [26, 28],
            [27, 29],
            [28, 30],
            [29, 31],
            [30, 32],
            [31, 33],
            [32, 34],
            [33, 35],
            [34, 36],
            [35, 37],
            [36, 38],
            [37, 39],
            [38, 40],
            [39, 41],
            [40, 42],
            [41, 43],
            [42, 44],
            [43, 45],
            [44, 46],
            [45, 47],
            [46, 48],
            [47, 49],
            [48, 50],
            [49, 51],
            [50, 52],
            [51, 53],
            [52, 54],
            [53, 55],
            [54, 56],
            [55, 57],
            [56, 58],
            [57, 59],
            [58, 60],
            [59, 61],
            [60, 62],
            [61, 63],
            [62, 64],
            [63, 65],
            [64, 66],
            [65, 67],
            [66, 68],
            [67, 69],
            [68, 70],
            [69, 71],
            [70, 72],
            [71, 73],
            [72, 74],
            [73, 75],
            [74, 76],
            [75, 77],
            [76, 78],
            [77, 79],
            [78, 80],
            [79, 81],
            [80, 82],
            [81, 83],
            [82, 84],
            [83, 85],
            [84, 86],
            [85, 87],
            [86, 88],
            [87, 89],
            [88, 90],
            [89, 91],
            [90, 92],
            [91, 93],
            [92, 94],
            [93, 95],
            [94, 96],
            [95, 97],
            [96, 98],
            [97, 99],
            [98, 0],
        ]
