window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = [{"fullname": "aiosmsactivate.client", "modulename": "aiosmsactivate.client", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "aiosmsactivate.client.SmsActivate", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate", "kind": "class", "doc": "<p>RU<br />\n\u0421\u043f\u0430\u0441\u0438\u0431\u043e \u0437\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u043e\u0435\u0439 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438, \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u043f\u0440\u0438\u043d\u044f\u0442\u044c \u0443\u0447\u0430\u0441\u0442\u0438\u0435 \u0432 \u0440\u0430\u0437\u0432\u0438\u0442\u0438\u0438 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438  </p>\n\n<p>\u0412\u0410\u0416\u041d\u041e\n\u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0430 \u043f\u043e\u043b\u043d\u043e\u0441\u0442\u044c\u044e \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0432\u0441\u0435 \u043c\u0435\u0442\u043e\u0434\u044b \u0441 \u043e\u0444\u0444\u0438\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430\u0446\u0438\u0438\n<a href=\"https://sms-activate.page/api2\">https://sms-activate.page/api2</a> \u043d\u0430 \u043c\u043e\u043c\u0435\u043d\u0442 08.07.2025  </p>\n\n<p>\u043d\u0430 git: <a href=\"https://github.com/AioSmsProviders/aiosmsactivate\">https://github.com/AioSmsProviders/aiosmsactivate</a>\n\u0422\u0430\u043a \u0436\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u043f\u0438\u0441\u0430\u0442\u044c \u0432 \u0447\u0430\u0442 <a href=\"https://t.me/+5YQ8k6H02bkxZmRi\">https://t.me/+5YQ8k6H02bkxZmRi</a>\n\u0438\u043b\u0438 \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u043a \u0433\u043b\u0430\u0432\u043d\u043e\u043c\u0443 \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0443 \u0441 \u0438\u0434\u0435\u044f\u043c\u0438, \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f\u043c\u0438 \u0438 \u0431\u0430\u0433\u0430\u043c\u0438: <a href=\"https://t.me/lolkof\">https://t.me/lolkof</a>  </p>\n\n<p>EN<br />\nThank you for using my library, you can participate in the development of the library.  </p>\n\n<p>important\nThe library fully supports all methods from the official documentation\n<a href=\"https://sms-activate.page/api2\">https://sms-activate.page/api2</a> as of 07/08/2025  </p>\n\n<p>on git: <a href=\"https://github.com/AioSmsProviders/aiosmsactivate\">https://github.com/AioSmsProviders/aiosmsactivate</a>\nYou can also write to the chat <a href=\"https://t.me/+5YQ8k6H02bkxZmRi\">https://t.me/+5YQ8k6H02bkxZmRi</a>\nor contact the main developer with ideas, suggestions, and bugs: <a href=\"https://t.me/lolkof\">https://t.me/lolkof</a></p>\n\n<p>SIMPLE USAGE</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">aiosmsactivate</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">SmsActivate</span>\n<span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">aiosmsactivate.types</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">SetActivationStatus</span>\n\n<span class=\"kn\">import</span><span class=\"w\"> </span><span class=\"nn\">asyncio</span>\n\n\n<span class=\"n\">sa</span> <span class=\"o\">=</span> <span class=\"n\">SmsActivate</span><span class=\"p\">(</span><span class=\"s1\">&#39;token&#39;</span><span class=\"p\">)</span>\n\n<span class=\"k\">async</span> <span class=\"k\">def</span><span class=\"w\"> </span><span class=\"nf\">main</span><span class=\"p\">():</span>\n    <span class=\"n\">balance</span> <span class=\"o\">=</span> <span class=\"k\">await</span> <span class=\"n\">sa</span><span class=\"o\">.</span><span class=\"n\">get_balance</span><span class=\"p\">()</span>\n    <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">balance</span><span class=\"p\">)</span> <span class=\"c1\"># 6.25</span>\n\n    <span class=\"n\">number</span> <span class=\"o\">=</span> <span class=\"k\">await</span> <span class=\"n\">sa</span><span class=\"o\">.</span><span class=\"n\">purchase</span><span class=\"p\">(</span><span class=\"s1\">&#39;ya&#39;</span><span class=\"p\">)</span>\n    <span class=\"n\">number</span><span class=\"o\">.</span><span class=\"n\">activation_id</span> <span class=\"c1\"># 3807035855</span>\n    <span class=\"n\">number</span><span class=\"o\">.</span><span class=\"n\">phone_number</span> <span class=\"c1\"># &#39;79238944456&#39;</span>\n    <span class=\"n\">number</span><span class=\"o\">.</span><span class=\"n\">operator</span> <span class=\"c1\"># &#39;mtt&#39;</span>\n    <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">number</span><span class=\"p\">)</span>\n    <span class=\"c1\"># activation_id=3807035855 phone_number=&#39;79238944456&#39; activation_cost=0.2 </span>\n    <span class=\"c1\"># country_code=&#39;0&#39; can_get_another_sms=True activation_time=&#39;2025-07-08 10:49:27&#39; </span>\n    <span class=\"c1\"># operator=&#39;mtt&#39; </span>\n\n    <span class=\"n\">code</span> <span class=\"o\">=</span> <span class=\"k\">await</span> <span class=\"n\">number</span><span class=\"o\">.</span><span class=\"n\">wait_sms_code</span><span class=\"p\">(</span><span class=\"n\">timeout</span><span class=\"o\">=</span><span class=\"mi\">300</span><span class=\"p\">)</span>\n    <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">code</span><span class=\"p\">)</span> <span class=\"c1\"># 1234</span>\n\n    <span class=\"n\">status</span> <span class=\"o\">=</span> <span class=\"k\">await</span> <span class=\"n\">number</span><span class=\"o\">.</span><span class=\"n\">get_activation_status</span><span class=\"p\">()</span>\n\n    <span class=\"k\">await</span> <span class=\"n\">number</span><span class=\"o\">.</span><span class=\"n\">set_activation_status</span><span class=\"p\">(</span><span class=\"n\">SetActivationStatus</span><span class=\"o\">.</span><span class=\"n\">CANCEL</span><span class=\"p\">)</span> <span class=\"c1\"># \u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u043d\u043e\u043c\u0435\u0440 || Cancel number</span>\n    <span class=\"k\">await</span> <span class=\"n\">number</span><span class=\"o\">.</span><span class=\"n\">set_activation_status</span><span class=\"p\">(</span><span class=\"mi\">8</span><span class=\"p\">)</span> <span class=\"c1\"># \u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u043d\u043e\u043c\u0435\u0440 || Cancel number</span>\n\n<span class=\"n\">asyncio</span><span class=\"o\">.</span><span class=\"n\">run</span><span class=\"p\">(</span><span class=\"n\">main</span><span class=\"p\">())</span>\n</code></pre>\n</div>\n"}, {"fullname": "aiosmsactivate.client.SmsActivate.__init__", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.__init__", "kind": "function", "doc": "<p>RU<br />\napi_key \u043f\u0435\u0440\u0435\u0434\u0430\u0432\u0430\u0442\u044c api \u043a\u043b\u044e\u0447, \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043c\u043e\u0436\u043d\u043e \u0432\u043e\u0442 \u0442\u0443\u0442: <a href=\"https://sms-activate.page/profile\">https://sms-activate.page/profile</a>\n\u0412 base_url \u043c\u043e\u0436\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0430\u0434\u0440\u0435\u0441\u043e\u0432, \u043c\u043e\u0434\u0443\u043b\u044c \u0431\u0443\u0434\u0435\u0442 \u043f\u0440\u043e\u0445\u043e\u0434\u0438\u0442\u044c\u0441\u044f \u043f\u043e \u0432\u0441\u0435\u043c, \u043f\u043e\u043a\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0451\u0442 \u0440\u0430\u0431\u043e\u0447\u0438\u0439\n\u0430 \u043c\u043e\u0436\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u043e\u0434\u0438\u043d \u0438\u043b\u0438 \u0432\u043e\u043e\u0431\u0449\u0435 \u043d\u0435 \u0443\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c, \u0435\u0441\u043b\u0438 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u0431\u0443\u0434\u0435\u0442 \u0431\u0440\u0430\u0442\u044c\u0441\u044f \u0438\u0437 allowed_domains  </p>\n\n<p>EN<br />\napi_key to transfer the api key, you can get it here: <a href=\"https://sms-activate.page/profile\">https://sms-activate.page/profile</a>\nYou can specify a list of addresses in base_url, and the module will go through all of them until it finds a working one.\nor you can specify one or not at all, if not specified, it will be taken from allowed_domains.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">api_key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">base_url</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">list</span> <span class=\"o\">=</span> <span class=\"p\">[</span><span class=\"s1\">&#39;https://api.sms-activate.ae/stubs/handler_api.php&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;https://api.sms-activate.ru/stubs/handler_api.php&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;https://api.sms-activate.io/stubs/handler_api.php&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;https://api.sms-activate.page/stubs/handler_api.php&#39;</span><span class=\"p\">]</span></span>)</span>"}, {"fullname": "aiosmsactivate.client.SmsActivate.get_balance", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.get_balance", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">cashback</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">float</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.get_balance_and_cashback", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.get_balance_and_cashback", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.get_available_countries", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.get_available_countries", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">service</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">freePrice</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">|</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.get_count_numbers", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.get_count_numbers", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">country</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">operator</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.get_operators", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.get_operators", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">country</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.get_active_activations", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.get_active_activations", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.get_activation_status_v1", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.get_activation_status_v1", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"nb\">id</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">aiosmsactivate</span><span class=\"o\">.</span><span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">ActivationStatus</span><span class=\"p\">,</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span><span class=\"p\">]</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.get_activation_status", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.get_activation_status", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">activation_id</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"n\">aiosmsactivate</span><span class=\"o\">.</span><span class=\"n\">models</span><span class=\"o\">.</span><span class=\"n\">Number</span></span><span class=\"return-annotation\">) -> <span class=\"n\">aiosmsactivate</span><span class=\"o\">.</span><span class=\"n\">models</span><span class=\"o\">.</span><span class=\"n\">ActivationData</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.wait_sms_code", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.wait_sms_code", "kind": "function", "doc": "<p>\u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u0441\u043c\u0441 \u043a\u043e\u0434\u0430\nWait sms code</p>\n\n<p>\u0410\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b:\n    activation_id: activation_id \u043d\u043e\u043c\u0435\u0440\u0430 \u0438\u043b\u0438 \u0446\u0435\u043b\u044b\u0439 \u043e\u0431\u044a\u0435\u043a\u0442 \u043d\u043e\u043c\u0435\u0440\u0430\n    timeout: \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u0441\u043c\u0441 \u0432 \u0441\u0435\u043a\u0443\u043d\u0434\u0430\u0445, \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e 5 \u043c\u0438\u043d\u0443\u0442 \n    per_attempt: \u0432\u0440\u0435\u043c\u044f \u043c\u0435\u0436\u0434\u0443 \u043f\u043e\u043f\u044b\u0442\u043a\u043e\u0439 \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043c\u0441, \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e 5 \u0441\u0435\u043a\u0443\u043d\u0434</p>\n\n<p>Args:\n    activation_id: activation_id of number or Number object\n    timeout: maximum time to wait sms code \n    per_attempt: time per attempt</p>\n\n<p>Returns: Sms</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">activation_id</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"n\">aiosmsactivate</span><span class=\"o\">.</span><span class=\"n\">models</span><span class=\"o\">.</span><span class=\"n\">Number</span>,</span><span class=\"param\">\t<span class=\"n\">timeout</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">300</span>,</span><span class=\"param\">\t<span class=\"n\">per_attempt</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">5</span></span><span class=\"return-annotation\">) -> <span class=\"n\">aiosmsactivate</span><span class=\"o\">.</span><span class=\"n\">models</span><span class=\"o\">.</span><span class=\"n\">Sms</span> <span class=\"o\">|</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.purchase", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.purchase", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">service</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">forward</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">maxPrice</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">phoneException</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">operator</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">activationType</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">language</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">userId</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">ref</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">country</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">useCashBack</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">orderId</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">_is_v2</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">aiosmsactivate</span><span class=\"o\">.</span><span class=\"n\">models</span><span class=\"o\">.</span><span class=\"n\">Number</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.get_number", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.get_number", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.get_multi_service_number", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.get_multi_service_number", "kind": "function", "doc": "<p>Get multiservice number.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>multiService</strong>:  service1,service2,service3 (Services separated by commas)</li>\n<li><strong>multiForward</strong>:  1,0,1 (forwards separated by commas, forwards count equal services count)</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>dict object of response</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">multiService</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">multiForward</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">operator</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">ref</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">country</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.set_activation_status", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.set_activation_status", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">activation_id</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">status</span><span class=\"p\">:</span> <span class=\"n\">aiosmsactivate</span><span class=\"o\">.</span><span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">SetActivationStatus</span> <span class=\"o\">|</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">forward</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">aiosmsactivate</span><span class=\"o\">.</span><span class=\"n\">models</span><span class=\"o\">.</span><span class=\"n\">SetActivationStatusResponse</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.get_history", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.get_history", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">end</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">offset</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">limit</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">list</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.get_list_top_countries", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.get_list_top_countries", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">service</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">list</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.get_incoming_call_status", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.get_incoming_call_status", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">list</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.get_service", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.get_service", "kind": "function", "doc": "<p>RU<br />\n\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0432\u0441\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u043e \u0441\u0435\u0440\u0432\u0438\u0441\u0435<br />\nEN<br />\nGet all data about service  </p>\n\n<p>Example</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"n\">service</span> <span class=\"o\">=</span> <span class=\"k\">await</span> <span class=\"n\">sa</span><span class=\"o\">.</span><span class=\"n\">get_service</span><span class=\"p\">(</span><span class=\"s1\">&#39;ya&#39;</span><span class=\"p\">,</span> <span class=\"mi\">0</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">service</span><span class=\"p\">)</span> <span class=\"c1\"># code=&#39;ya&#39; name=&#39;Yandex/Uber&#39; country=&#39;0&#39; cost=0.115 count=10794 physical_count=5075</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">service_code</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">country</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">lang</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;ru&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;en&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;es&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;cn&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;en&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.get_prices", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.get_prices", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">service</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">country</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">list</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.get_prices_verification", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.get_prices_verification", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">service</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">list</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.get_countries", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.get_countries", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">list</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.get_service_list", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.get_service_list", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">country</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">lang</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;ru&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;en&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;es&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;cn&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">list</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.get_service_name", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.get_service_name", "kind": "function", "doc": "<p>RU<br />\n\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u043b\u043d\u043e\u0433\u043e \u0438\u043c\u0435\u043d\u0438 \u0441\u0435\u0440\u0432\u0438\u0441\u0430 \u043f\u043e \u0435\u0433\u043e id  </p>\n\n<p>EN<br />\nGet full service name by service code  </p>\n\n<p>\u041f\u0440\u0438\u043c\u0435\u0440 Example:<br />\nservice_name = await SmsActivate.get_service_name('go')<br />\nservice_name # 'Google,youtube,Gmail'</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">service_code</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">lang</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;ru&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;en&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;es&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;cn&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.get_additional_service", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.get_additional_service", "kind": "function", "doc": "<p>Get additional service to activation its cost 5rub\nreturn 2 values: addition activation id and phone number</p>\n\n<p>use like this: \nactivation_id, phone_number = await getAdditionalService(service, activation id)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">service</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"nb\">id</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.get_extra_activation", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.get_extra_activation", "kind": "function", "doc": "<p>return 2 values: addition activation id and phone number</p>\n\n<p>use like this: \nactivation_id, phone_number = await getExtraActivation(activation id)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.check_extra_activation", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.check_extra_activation", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">activationId</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">list</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.parse_call", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.parse_call", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">newLang</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">list</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.get_rent_services_and_countries", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.get_rent_services_and_countries", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">time</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">operator</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">country</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">currency</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">incomingCall</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.get_rent_number", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.get_rent_number", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">service</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">time</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">operator</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">country</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">url</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">incomingCall</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.get_rent_status", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.get_rent_status", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"nb\">id</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">page</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.set_rent_status", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.set_rent_status", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">status</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"s1\">&#39;1&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;2&#39;</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.get_rent_list", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.get_rent_list", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.continue_rent_number", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.continue_rent_number", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">rent_time</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"mi\">4</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.get_continue_rent_price_number", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.get_continue_rent_price_number", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"nb\">id</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">rent_time</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"mi\">4</span>,</span><span class=\"param\">\t<span class=\"n\">currency</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.buy_partner_product", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.buy_partner_product", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.getBalance", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.getBalance", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">cashback</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">float</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.getBalanceAndCashBack", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.getBalanceAndCashBack", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.getTopCountriesByService", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.getTopCountriesByService", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">service</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">freePrice</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">|</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.getNumbersStatus", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.getNumbersStatus", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">country</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">operator</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.getOperators", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.getOperators", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">country</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.getActiveActivations", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.getActiveActivations", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.getStatus", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.getStatus", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"nb\">id</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">aiosmsactivate</span><span class=\"o\">.</span><span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">ActivationStatus</span><span class=\"p\">,</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span><span class=\"p\">]</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.getStatusV2", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.getStatusV2", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">activation_id</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"n\">aiosmsactivate</span><span class=\"o\">.</span><span class=\"n\">models</span><span class=\"o\">.</span><span class=\"n\">Number</span></span><span class=\"return-annotation\">) -> <span class=\"n\">aiosmsactivate</span><span class=\"o\">.</span><span class=\"n\">models</span><span class=\"o\">.</span><span class=\"n\">ActivationData</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.getNumberV2", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.getNumberV2", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">service</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">forward</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">maxPrice</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">phoneException</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">operator</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">activationType</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">language</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">userId</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">ref</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">country</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">useCashBack</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">orderId</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">_is_v2</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">aiosmsactivate</span><span class=\"o\">.</span><span class=\"n\">models</span><span class=\"o\">.</span><span class=\"n\">Number</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.purchase_v1", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.purchase_v1", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.getNumber", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.getNumber", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.getMultiServiceNumber", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.getMultiServiceNumber", "kind": "function", "doc": "<p>Get multiservice number.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>multiService</strong>:  service1,service2,service3 (Services separated by commas)</li>\n<li><strong>multiForward</strong>:  1,0,1 (forwards separated by commas, forwards count equal services count)</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>dict object of response</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">multiService</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">multiForward</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">operator</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">ref</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">country</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.setStatus", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.setStatus", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">activation_id</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">status</span><span class=\"p\">:</span> <span class=\"n\">aiosmsactivate</span><span class=\"o\">.</span><span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">SetActivationStatus</span> <span class=\"o\">|</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">forward</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">aiosmsactivate</span><span class=\"o\">.</span><span class=\"n\">models</span><span class=\"o\">.</span><span class=\"n\">SetActivationStatusResponse</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.getHistory", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.getHistory", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">end</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">offset</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">limit</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">list</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.getListOfTopCountriesByService", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.getListOfTopCountriesByService", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">service</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">list</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.getIncomingCallStatus", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.getIncomingCallStatus", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">list</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.getPrices", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.getPrices", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">service</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">country</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">list</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.getPricesVerification", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.getPricesVerification", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">service</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">list</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.getCountries", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.getCountries", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">list</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.getServicesList", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.getServicesList", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">country</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">lang</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;ru&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;en&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;es&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;cn&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">list</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.getAdditionalService", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.getAdditionalService", "kind": "function", "doc": "<p>Get additional service to activation its cost 5rub\nreturn 2 values: addition activation id and phone number</p>\n\n<p>use like this: \nactivation_id, phone_number = await getAdditionalService(service, activation id)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">service</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"nb\">id</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.getExtraActivation", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.getExtraActivation", "kind": "function", "doc": "<p>return 2 values: addition activation id and phone number</p>\n\n<p>use like this: \nactivation_id, phone_number = await getExtraActivation(activation id)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.checkExtraActivation", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.checkExtraActivation", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">activationId</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">list</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.parseCall", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.parseCall", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">newLang</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">list</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.getRentServicesAndCountries", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.getRentServicesAndCountries", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">time</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">operator</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">country</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">currency</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">incomingCall</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.getRentNumber", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.getRentNumber", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">service</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">time</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">operator</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">country</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">url</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">incomingCall</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.getRentStatus", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.getRentStatus", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"nb\">id</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">page</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.getRentList", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.getRentList", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.continueRentNumber", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.continueRentNumber", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">rent_time</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"mi\">4</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.getContinueRentPriceNumber", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.getContinueRentPriceNumber", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"nb\">id</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">rent_time</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"mi\">4</span>,</span><span class=\"param\">\t<span class=\"n\">currency</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>:</span></span>", "funcdef": "async def"}, {"fullname": "aiosmsactivate.client.SmsActivate.buyPartnerProduct", "modulename": "aiosmsactivate.client", "qualname": "SmsActivate.buyPartnerProduct", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>:</span></span>", "funcdef": "async def"}];

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();