import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FunctionGrantConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the database containing the current or future functions on which to grant privileges.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function_grant#database_name FunctionGrant#database_name}
    */
    readonly databaseName: string;
    /**
    * When this is set to true, multiple grants of the same type can be created. This will cause Terraform to not revoke grants applied to roles and objects outside Terraform.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function_grant#enable_multiple_grants FunctionGrant#enable_multiple_grants}
    */
    readonly enableMultipleGrants?: boolean | cdktf.IResolvable;
    /**
    * The name of the function on which to grant privileges immediately (only valid if on_future is false).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function_grant#function_name FunctionGrant#function_name}
    */
    readonly functionName?: string;
    /**
    * When this is set to true and a schema_name is provided, apply this grant on all future functions in the given schema. When this is true and no schema_name is provided apply this grant on all future functions in the given database. The function_name, arguments, return_type, and shares fields must be unset in order to use on_future.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function_grant#on_future FunctionGrant#on_future}
    */
    readonly onFuture?: boolean | cdktf.IResolvable;
    /**
    * The privilege to grant on the current or future function. Must be one of `USAGE` or `OWNERSHIP`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function_grant#privilege FunctionGrant#privilege}
    */
    readonly privilege?: string;
    /**
    * The return type of the function (must be present if function_name is present)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function_grant#return_type FunctionGrant#return_type}
    */
    readonly returnType?: string;
    /**
    * Grants privilege to these roles.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function_grant#roles FunctionGrant#roles}
    */
    readonly roles?: string[];
    /**
    * The name of the schema containing the current or future functions on which to grant privileges.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function_grant#schema_name FunctionGrant#schema_name}
    */
    readonly schemaName: string;
    /**
    * Grants privilege to these shares (only valid if on_future is false).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function_grant#shares FunctionGrant#shares}
    */
    readonly shares?: string[];
    /**
    * When this is set to true, allows the recipient role to grant the privileges to other roles.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function_grant#with_grant_option FunctionGrant#with_grant_option}
    */
    readonly withGrantOption?: boolean | cdktf.IResolvable;
    /**
    * arguments block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function_grant#arguments FunctionGrant#arguments}
    */
    readonly arguments?: FunctionGrantArguments[] | cdktf.IResolvable;
}
export interface FunctionGrantArguments {
    /**
    * The argument name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function_grant#name FunctionGrant#name}
    */
    readonly name: string;
    /**
    * The argument type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function_grant#type FunctionGrant#type}
    */
    readonly type: string;
}
export declare function functionGrantArgumentsToTerraform(struct?: FunctionGrantArguments | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/function_grant snowflake_function_grant}
*/
export declare class FunctionGrant extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_function_grant";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/function_grant snowflake_function_grant} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FunctionGrantConfig
    */
    constructor(scope: Construct, id: string, config: FunctionGrantConfig);
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _enableMultipleGrants?;
    get enableMultipleGrants(): boolean | cdktf.IResolvable;
    set enableMultipleGrants(value: boolean | cdktf.IResolvable);
    resetEnableMultipleGrants(): void;
    get enableMultipleGrantsInput(): boolean | cdktf.IResolvable | undefined;
    private _functionName?;
    get functionName(): string;
    set functionName(value: string);
    resetFunctionName(): void;
    get functionNameInput(): string | undefined;
    get id(): string;
    private _onFuture?;
    get onFuture(): boolean | cdktf.IResolvable;
    set onFuture(value: boolean | cdktf.IResolvable);
    resetOnFuture(): void;
    get onFutureInput(): boolean | cdktf.IResolvable | undefined;
    private _privilege?;
    get privilege(): string;
    set privilege(value: string);
    resetPrivilege(): void;
    get privilegeInput(): string | undefined;
    private _returnType?;
    get returnType(): string;
    set returnType(value: string);
    resetReturnType(): void;
    get returnTypeInput(): string | undefined;
    private _roles?;
    get roles(): string[];
    set roles(value: string[]);
    resetRoles(): void;
    get rolesInput(): string[] | undefined;
    private _schemaName?;
    get schemaName(): string;
    set schemaName(value: string);
    get schemaNameInput(): string | undefined;
    private _shares?;
    get shares(): string[];
    set shares(value: string[]);
    resetShares(): void;
    get sharesInput(): string[] | undefined;
    private _withGrantOption?;
    get withGrantOption(): boolean | cdktf.IResolvable;
    set withGrantOption(value: boolean | cdktf.IResolvable);
    resetWithGrantOption(): void;
    get withGrantOptionInput(): boolean | cdktf.IResolvable | undefined;
    private _arguments?;
    get arguments(): FunctionGrantArguments[] | cdktf.IResolvable;
    set arguments(value: FunctionGrantArguments[] | cdktf.IResolvable);
    resetArguments(): void;
    get argumentsInput(): cdktf.IResolvable | FunctionGrantArguments[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
