# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = [
    'GetSshKeysResult',
    'AwaitableGetSshKeysResult',
    'get_ssh_keys',
]

@pulumi.output_type
class GetSshKeysResult:
    """
    A collection of values returned by getSshKeys.
    """
    def __init__(__self__, filters=None, id=None, sorts=None, ssh_keys=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if sorts and not isinstance(sorts, list):
            raise TypeError("Expected argument 'sorts' to be a list")
        pulumi.set(__self__, "sorts", sorts)
        if ssh_keys and not isinstance(ssh_keys, list):
            raise TypeError("Expected argument 'ssh_keys' to be a list")
        pulumi.set(__self__, "ssh_keys", ssh_keys)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSshKeysFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def sorts(self) -> Optional[Sequence['outputs.GetSshKeysSortResult']]:
        return pulumi.get(self, "sorts")

    @property
    @pulumi.getter(name="sshKeys")
    def ssh_keys(self) -> Sequence['outputs.GetSshKeysSshKeyResult']:
        """
        A list of SSH Keys. Each SSH Key has the following attributes:
        """
        return pulumi.get(self, "ssh_keys")


class AwaitableGetSshKeysResult(GetSshKeysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSshKeysResult(
            filters=self.filters,
            id=self.id,
            sorts=self.sorts,
            ssh_keys=self.ssh_keys)


def get_ssh_keys(filters: Optional[Sequence[pulumi.InputType['GetSshKeysFilterArgs']]] = None,
                 sorts: Optional[Sequence[pulumi.InputType['GetSshKeysSortArgs']]] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSshKeysResult:
    """
    Get information on SSH Keys for use in other resources.

    This data source is useful if the SSH Keys in question are not managed by the provider or you need to
    utilize any of the SSH Keys' data.

    Note: You can use the `SshKey` data source to obtain metadata
    about a single SSH Key if you already know the unique `name` to retrieve.

    ## Example Usage

    For example to find all SSH Keys:

    ```python
    import pulumi
    import pulumi_digitalocean as digitalocean

    keys = digitalocean.get_ssh_keys(sorts=[digitalocean.GetSshKeysSortArgs(
        direction="asc",
        key="name",
    )])
    ```


    :param Sequence[pulumi.InputType['GetSshKeysFilterArgs']] filters: Filter the results.
           The `filter` block is documented below.
    :param Sequence[pulumi.InputType['GetSshKeysSortArgs']] sorts: Sort the results.
           The `sort` block is documented below.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['sorts'] = sorts
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('digitalocean:index/getSshKeys:getSshKeys', __args__, opts=opts, typ=GetSshKeysResult).value

    return AwaitableGetSshKeysResult(
        filters=__ret__.filters,
        id=__ret__.id,
        sorts=__ret__.sorts,
        ssh_keys=__ret__.ssh_keys)
