import cv2
import numpy as np

def panda_producer(back_img, front_img, hyper=130):
    
    if len(front_img.shape) >=3:
        front_img = cv2.cvtColor(front_img,cv2.COLOR_RGB2GRAY)
    front_img[np.where(front_img > hyper)] = 255
    front_img = cv2.resize(front_img, (256, 256), interpolation=cv2.INTER_LINEAR)
    
    back_img = cv2.resize(back_img, (512, 512), interpolation=cv2.INTER_LINEAR)

    back_h, back_w = back_img.shape
    front_h, front_w = front_img.shape

    start_x = int((back_w - front_w) / 2)
    end_x = start_x + front_w

    start_y = int((back_h - front_h) / 2)
    start_y = int(0.6 * start_y)
    end_y = front_h + start_y
    back_img[start_y: end_y, start_x: end_x] = front_img

    return back_img

def add_text(back_img, text):
    cv2.putText(back_img, text, (150, 480), cv2.FONT_HERSHEY_SIMPLEX, 2.0, (0, 0, 0), 4)

def make_panda():
    panda = np.array([])
def gen_panda_head(front_img, text, hyper=128):
    back_img = make_panda()
    #front_img = cv2.imread(front, 0)
    merge_img = panda_producer(back_img,front_img, int(hyper))

    add_text(merge_img, str(text))
    return merge_img

    #cv2.imwrite("res_" + args.front, merge_img)

def make_panda():
    panda = np.array([[254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,252,253,255,255,255,254,250,252,254,255,255,255,253,252,251,253,255,255,255,251,250,252,255,253,251,250,253,255,253,250,249,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,253,253,253,255,255,255,255,250,252,255,255,255,252,248,245,251,253,254,254,253,251,251,252,255,255,255,255,255,255,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,251,249,248,249,250,255,255,255,254,254,255,255,255,249,250,252,255,255,255,252,250,250,254,255,253,248,247,249,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,250,253,255,255,253,253,255,255,254,251,248,247,246,246,244,243,250,250,251,253,255,253,248,244,252,255,255,255,253,254,254,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,255,253,251,249,249,250,252,246,248,252,255,255,255,255,252,255,255,255,255,255,255,253,251,252,253,251,246,248,254,255,252,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,254,253,254,255,255,255,254,255,251,239,231,230,231,232,232,234,236,237,238,239,243,250,255,252,255,254,245,243,250,251,247,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,248,250,254,255,255,243,219,200,155,134,105,80,68,65,64,65,50,61,78,96,118,147,177,198,212,238,255,255,255,255,255,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,251,251,250,239,209,154,90,45,39,29,16,8,6,4,1,0,14,18,21,21,22,35,57,76,123,173,225,246,249,251,251,247,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,251,255,254,251,253,255,255,254,252,255,244,188,104,44,20,10,9,8,8,7,7,8,8,9,9,8,7,7,8,11,14,16,27,63,113,165,219,255,255,243,255,255,255,252,248,248,252,255,253,255,255,253,248,245,247,251,251,254,255,254,251,249,251,254,246,255,255,254,251,253,252,248,250,249,249,251,252,252,252,253,255,249,245,249,250,245,243,245,240,238,234,230,228,232,239,245,242,245,249,250,249,249,250,252,255,255,255,251,249,253,254,251,250,249,247,249,255,255,254,245,253,247,247,253,255,251,248,249,255,254,253,255,255,253,251,250,254,254,254,254,254,254,254,254,253,253,253,253,254,254,254,254,254,250,252,255,255,251,249,253,255,254,253,254,255,255,254,252,244,246,250,253,255,255,254,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,253,252,254,251,246,247,252,251,207,149,90,39,15,12,7,9,8,8,7,7,8,8,9,9,8,7,7,8,10,13,14,21,18,29,63,116,174,226,255,254,244,244,255,255,253,252,255,255,254,253,253,254,255,255,255,247,251,255,255,253,251,251,252,250,251,247,242,245,255,255,255,249,252,254,255,255,252,231,210,196,185,176,175,173,163,154,150,139,131,118,105,100,105,116,125,121,125,130,136,147,167,190,207,230,229,226,228,238,251,254,250,251,252,253,251,247,245,248,252,255,255,252,249,247,248,253,255,245,248,252,254,253,251,252,254,254,254,254,254,254,254,254,254,253,253,253,253,253,253,254,254,255,249,245,250,255,255,255,255,250,253,255,255,253,251,251,252,255,254,252,252,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,252,249,251,253,247,238,166,106,47,17,5,6,9,5,9,8,8,7,7,8,8,9,9,8,7,6,7,8,10,11,8,1,3,15,29,65,142,216,252,254,255,255,254,254,254,253,255,253,250,249,249,248,245,242,255,255,253,250,249,251,255,255,255,255,254,255,255,255,244,230,236,226,207,191,182,165,131,98,56,47,40,41,43,40,37,35,45,42,36,29,25,26,31,35,30,33,34,34,36,46,62,74,56,61,74,104,151,200,229,238,244,236,237,251,255,255,252,250,244,252,255,255,253,253,255,255,250,255,255,255,254,252,253,254,254,254,254,254,254,254,254,254,253,253,253,253,253,253,253,253,247,249,252,255,253,250,252,255,250,253,254,251,247,247,252,255,252,249,247,248,252,254,254,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,249,255,250,240,252,255,224,169,57,23,5,11,13,12,11,7,9,8,8,7,7,8,8,9,9,8,7,6,6,7,8,8,6,9,19,21,6,7,54,111,197,241,255,249,236,249,255,249,249,251,253,255,255,253,251,249,243,245,249,253,255,255,254,252,251,250,251,254,250,229,196,168,88,72,56,51,52,48,35,25,20,20,21,23,23,25,30,35,26,38,54,65,67,60,51,45,40,36,28,20,14,11,10,10,23,18,12,16,36,62,77,80,73,77,107,161,207,230,244,255,251,255,255,252,249,249,249,246,254,255,255,252,251,253,254,252,254,254,254,254,254,254,254,254,253,253,253,253,253,252,252,252,254,253,253,254,254,252,249,248,255,255,255,253,252,251,251,252,255,255,253,253,255,255,252,249,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,246,246,255,237,154,66,23,5,5,17,14,7,8,10,9,8,8,7,7,8,8,9,8,8,7,6,6,6,7,7,14,8,4,6,6,6,15,27,87,168,240,253,242,245,254,254,250,253,255,255,252,252,255,255,255,255,254,251,249,243,235,229,232,214,188,162,132,92,50,22,22,10,7,15,16,9,14,28,14,33,53,64,67,72,82,91,143,159,182,198,201,192,179,170,136,121,102,89,86,83,77,71,50,50,45,37,35,37,35,30,30,26,31,43,54,74,115,156,202,213,228,243,254,255,255,249,251,250,245,241,246,254,255,250,254,254,254,254,254,254,254,254,254,253,253,253,252,252,251,251,252,244,239,245,255,255,247,232,251,247,243,245,252,255,255,255,249,248,247,247,249,251,254,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,244,246,255,255,186,86,15,26,10,8,12,8,5,8,7,9,8,8,7,7,8,8,9,8,7,7,7,7,7,7,7,11,7,2,0,5,10,9,5,13,88,190,255,255,250,247,255,253,253,254,253,253,254,255,255,243,239,231,219,196,161,122,95,67,56,46,39,31,19,10,5,7,7,16,27,27,28,51,82,137,166,199,217,222,228,235,240,234,241,249,253,252,248,243,241,249,238,226,221,221,217,206,197,201,199,185,156,120,83,49,25,14,9,7,9,8,11,28,47,47,60,92,135,177,211,240,255,255,255,255,248,249,255,254,246,254,254,254,254,254,254,254,254,254,253,253,252,252,251,250,250,245,255,255,242,214,185,161,147,172,160,146,145,160,188,216,233,250,254,255,255,251,250,252,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,245,250,253,204,112,39,14,14,5,6,9,6,8,11,6,9,8,8,7,7,8,8,9,7,7,7,8,8,8,8,8,7,11,15,13,10,7,7,7,3,40,121,212,255,254,247,254,251,249,250,255,255,249,231,216,181,151,107,70,46,33,25,20,23,18,16,15,11,8,14,24,22,50,84,105,120,146,184,214,220,238,253,255,255,255,255,253,255,255,254,251,248,248,250,253,248,249,253,255,255,255,253,248,251,253,250,240,226,208,183,163,130,105,73,51,40,30,17,7,8,2,9,36,72,121,189,246,240,255,255,255,252,254,253,247,254,254,254,254,254,254,254,254,254,254,253,252,251,250,250,249,250,255,236,180,111,62,40,35,51,44,32,26,34,62,99,126,200,221,246,255,255,251,247,247,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,251,255,254,218,133,43,5,12,3,3,8,7,1,5,12,8,9,8,8,7,7,8,8,9,7,7,8,8,8,9,9,9,15,6,3,10,15,11,6,4,8,13,57,140,218,253,255,250,255,248,242,240,228,192,138,96,56,41,22,12,12,13,11,7,18,15,16,18,20,29,53,78,146,192,232,238,235,243,251,251,255,255,255,247,245,251,252,249,248,251,254,255,254,254,255,255,252,254,253,249,244,245,252,255,255,253,250,251,255,255,251,237,227,232,234,221,190,138,77,34,31,19,13,13,6,12,57,108,196,226,250,251,246,250,255,254,254,254,254,254,254,254,254,254,254,254,253,252,251,250,249,249,229,196,135,66,21,8,12,15,1,10,17,11,0,0,14,28,50,96,161,213,239,246,248,250,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,255,253,255,250,246,252,254,253,255,241,186,109,51,20,8,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,12,2,18,54,112,198,243,225,227,192,144,102,72,48,30,20,6,10,14,16,20,30,44,56,95,109,122,133,158,194,217,222,251,252,252,253,255,255,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,251,251,252,252,248,237,222,212,165,115,60,31,21,17,21,31,73,112,169,216,240,247,249,251,255,251,248,250,253,254,253,252,254,242,252,255,240,222,177,110,77,60,38,20,12,10,8,7,8,8,8,8,8,8,8,8,11,19,39,62,81,114,170,222,246,241,252,255,248,250,255,248,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,250,255,255,251,255,255,255,245,176,95,41,15,6,8,12,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,17,7,8,12,27,74,103,86,80,57,39,34,26,13,13,25,34,49,73,100,127,155,182,199,225,234,237,234,241,255,255,255,252,252,253,254,254,255,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,251,251,253,255,255,255,251,247,247,237,204,149,92,55,42,41,16,42,69,83,96,136,200,251,251,250,252,255,254,250,252,255,243,253,247,203,140,88,48,20,24,16,7,4,7,11,13,12,8,8,8,8,8,8,8,8,5,2,6,15,21,32,61,91,158,184,218,245,255,253,250,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,252,248,252,255,252,252,255,246,191,93,22,11,9,5,8,11,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,2,5,13,9,2,16,28,16,0,8,5,0,17,64,107,126,176,187,203,218,231,242,253,255,252,255,255,252,249,250,245,236,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,253,252,253,254,255,255,255,255,255,252,234,223,207,163,114,111,55,12,7,9,27,96,177,234,255,255,246,241,253,255,247,254,218,146,74,33,12,8,17,2,0,0,3,9,12,11,8,8,8,8,8,8,8,8,8,16,7,3,5,5,3,9,20,31,58,91,152,229,255,252,250,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,249,249,255,247,245,250,229,116,36,3,20,18,6,8,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,3,8,15,15,9,9,10,5,12,18,18,35,98,183,232,238,254,255,255,255,255,250,247,246,250,255,255,255,255,255,255,251,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,254,252,250,249,249,248,248,240,252,252,244,250,255,255,234,227,190,125,56,13,8,29,49,106,173,240,255,253,248,250,252,243,150,48,6,9,14,14,17,11,10,9,11,12,10,5,1,8,8,8,8,8,8,8,8,10,4,2,7,9,7,9,13,4,5,11,63,162,236,251,241,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,255,252,247,253,246,248,252,214,69,16,1,14,5,0,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,17,13,6,7,12,9,5,9,11,5,37,120,207,252,255,254,244,247,250,251,252,253,255,255,247,250,251,250,251,254,255,252,255,255,255,254,254,253,253,252,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,251,253,255,255,255,255,255,255,251,255,255,248,238,243,253,255,245,255,242,182,101,38,9,2,7,39,112,199,252,255,255,255,180,80,13,10,10,6,8,6,9,8,7,7,8,8,6,5,8,8,8,8,8,8,8,8,5,3,4,6,5,3,6,12,15,10,8,21,75,170,241,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,255,247,254,250,255,255,193,50,17,4,8,4,7,13,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,8,2,9,20,10,3,17,32,73,143,214,253,255,246,238,253,253,252,252,253,255,255,255,255,255,253,251,251,253,254,254,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,249,252,255,255,255,255,255,255,255,249,247,254,255,255,247,239,252,237,245,255,217,126,50,23,16,12,30,89,171,226,224,199,102,28,1,15,6,0,12,17,11,9,7,6,6,9,11,13,8,8,8,8,8,8,8,8,10,12,13,11,6,5,9,15,7,4,6,1,20,108,213,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,250,255,250,255,251,255,246,156,33,18,9,13,17,15,12,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,1,7,3,7,15,2,8,47,131,197,253,255,250,253,255,247,253,252,251,250,249,249,248,248,255,254,254,255,255,255,255,255,255,255,254,254,254,254,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,251,253,255,254,251,249,248,250,254,253,252,250,249,250,254,255,254,248,242,249,255,237,166,95,33,30,18,13,36,67,71,54,40,13,9,22,16,6,5,3,16,14,11,9,7,8,11,13,8,8,8,8,8,8,8,8,5,8,9,7,6,6,8,9,18,13,10,7,14,66,161,240,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,248,255,251,253,248,252,229,121,17,12,6,9,14,8,5,12,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,15,5,2,11,16,59,132,229,248,255,252,247,251,255,252,252,253,254,255,255,255,255,254,252,252,253,255,255,253,251,251,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,252,254,255,253,251,251,254,255,245,252,255,251,250,252,252,248,247,255,255,253,255,255,246,225,165,87,23,18,25,10,3,12,3,14,14,7,5,3,5,13,8,7,6,5,4,5,7,9,8,8,8,8,8,8,8,8,8,9,9,9,10,11,7,3,5,9,9,11,11,28,114,226,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,249,255,251,249,255,255,210,70,12,11,9,8,7,8,8,9,9,8,8,7,7,8,8,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,10,7,5,6,9,10,8,6,15,1,8,13,25,98,191,233,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,253,253,253,253,253,254,254,254,254,254,254,254,254,255,255,255,255,255,255,255,255,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,254,253,252,251,251,251,251,251,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,238,202,135,62,17,7,9,8,13,8,6,7,5,1,4,12,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,12,0,5,17,11,13,65,133,212,248,255,234,255,241,255,255,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,251,255,250,251,248,241,163,41,11,10,9,8,7,8,8,9,9,8,8,7,7,8,8,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,10,7,6,7,9,10,8,6,10,3,12,46,110,192,245,251,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,253,253,253,253,253,254,254,254,254,254,254,254,254,252,252,252,252,252,252,252,252,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,255,255,255,255,255,255,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,247,225,179,108,40,5,1,4,8,14,16,11,7,9,14,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,15,4,7,17,9,0,19,57,129,211,255,251,254,249,255,253,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,252,255,249,255,243,226,105,15,10,10,9,8,8,8,8,9,9,8,8,7,7,8,8,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,8,7,7,9,9,8,7,7,6,36,111,199,255,255,249,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,252,252,252,252,252,252,252,252,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,252,252,251,252,252,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,255,255,247,199,121,50,12,3,4,9,14,13,9,6,7,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,13,4,6,17,16,4,3,13,46,140,213,255,252,253,255,253,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,251,255,247,255,244,218,66,11,9,9,8,8,8,8,8,8,9,8,8,7,7,8,8,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,8,8,8,9,9,9,8,1,16,90,193,249,254,248,247,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,253,253,253,253,253,252,252,252,252,252,252,252,252,255,255,255,255,255,255,255,255,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,250,249,249,249,249,250,252,252,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,253,253,251,226,170,117,61,28,2,5,15,12,5,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,10,4,2,9,15,16,14,13,14,62,129,236,253,253,247,255,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,252,255,244,255,245,206,44,11,7,7,8,8,8,8,8,8,9,8,8,7,7,8,8,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,8,9,9,0,47,158,250,255,247,252,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,253,253,253,253,253,252,252,252,252,252,252,252,252,255,255,255,255,255,255,255,255,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,255,254,254,254,254,255,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,250,252,250,248,255,255,251,233,173,97,24,5,13,13,9,10,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,10,7,3,2,4,7,9,8,10,16,63,200,250,255,244,255,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,253,255,244,252,246,186,33,4,6,6,7,8,8,8,8,7,9,8,8,7,7,8,8,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,10,11,10,9,8,9,10,17,108,213,255,249,252,255,249,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,252,252,252,252,252,252,252,252,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,252,252,251,252,252,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,246,242,247,248,244,248,255,254,176,82,26,6,3,6,11,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,10,10,7,5,5,5,5,5,6,41,158,238,255,252,251,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,253,255,249,251,253,173,35,0,5,6,7,8,9,8,8,7,9,8,8,7,7,8,8,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,10,12,11,8,8,9,11,71,182,247,241,244,255,249,242,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,253,253,253,253,253,254,254,254,254,254,254,254,254,252,252,252,252,252,252,252,252,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,250,249,248,248,247,248,248,249,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,252,248,255,255,250,246,248,255,233,167,79,17,2,6,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,9,11,14,13,11,10,11,5,3,26,115,225,253,255,249,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,251,254,254,254,255,170,45,0,4,5,7,8,9,8,8,7,9,8,8,7,7,8,8,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,10,12,11,8,7,9,12,119,232,255,238,255,255,243,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,253,253,253,253,253,254,254,254,254,254,254,254,254,255,255,255,255,255,255,255,255,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,255,255,254,253,252,252,252,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,240,252,255,253,252,255,255,250,230,255,238,136,44,15,15,9,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,10,6,6,10,11,8,7,8,13,0,6,83,217,244,255,251,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,250,255,250,252,249,181,35,0,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,18,0,7,17,11,5,14,49,204,237,255,250,244,253,255,252,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,253,253,253,253,253,255,242,255,213,84,12,16,14,10,17,3,7,8,3,14,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,8,9,10,14,1,15,44,155,252,255,249,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,251,255,250,252,250,183,36,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,6,16,14,5,10,4,37,136,233,251,255,252,249,255,255,250,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,253,253,253,253,253,242,247,255,237,154,49,3,14,7,18,6,10,15,11,15,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,8,9,10,12,2,8,25,126,236,255,255,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,253,255,250,253,252,185,38,2,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,10,4,12,8,14,59,138,225,255,255,254,251,254,255,255,251,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,253,253,253,253,253,247,255,248,248,217,97,5,16,2,15,5,4,11,7,7,5,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,8,9,10,7,4,6,12,101,226,255,255,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,255,250,253,254,187,39,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,22,0,14,32,76,165,232,255,255,250,246,249,254,255,255,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,254,254,254,254,254,254,255,255,245,252,247,153,42,8,3,14,8,3,6,3,3,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,8,9,10,4,8,8,13,94,230,255,250,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,255,249,253,255,189,41,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,13,24,49,96,183,241,245,255,248,247,249,254,255,252,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,254,254,254,254,254,254,252,248,252,255,255,214,117,23,11,9,13,15,13,8,7,16,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,8,9,10,6,9,5,13,89,236,255,244,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,255,248,252,255,190,41,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,0,33,119,198,245,255,245,252,250,253,255,255,255,250,251,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,246,255,255,249,253,200,101,35,1,6,18,12,9,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,8,9,10,10,10,0,9,77,232,255,245,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,255,246,251,255,190,41,2,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,11,66,192,255,249,253,255,249,252,255,255,255,253,253,253,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,245,245,255,245,202,102,18,2,13,4,7,6,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,8,9,10,10,11,1,14,70,227,255,251,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,255,246,250,255,190,41,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,36,136,236,252,246,255,252,249,250,253,251,247,249,255,255,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,243,255,255,249,255,253,246,255,178,52,10,14,2,13,17,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,8,9,10,7,13,10,26,74,226,254,255,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,250,254,252,255,245,187,52,2,8,8,9,10,10,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,6,8,15,14,6,8,15,13,104,207,255,246,255,255,247,253,252,252,253,253,253,254,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,221,115,25,17,6,3,24,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,6,15,64,220,255,251,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,255,255,255,253,246,190,45,2,8,8,9,10,10,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,12,10,7,15,18,6,15,51,170,237,255,243,248,255,252,255,252,252,253,253,253,254,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,243,172,65,14,14,10,8,10,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,9,7,14,60,216,255,252,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,255,252,255,250,249,196,40,3,8,8,9,10,10,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,14,13,3,10,17,4,41,125,232,255,255,244,246,255,255,254,252,252,253,253,253,254,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,255,230,121,20,15,16,0,16,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,6,10,7,12,55,211,253,253,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,252,246,255,250,254,206,44,3,8,8,9,10,10,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,12,16,8,4,11,32,108,206,251,253,255,251,249,254,255,249,252,252,253,253,253,254,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,255,250,177,52,9,14,0,17,9,9,8,8,8,8,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,5,10,8,11,52,207,251,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,251,247,255,254,255,215,58,0,8,8,9,10,10,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,14,16,16,16,42,109,195,252,249,246,253,255,253,251,254,252,252,252,253,253,253,254,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,250,247,225,114,14,9,14,10,9,9,9,8,8,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,5,10,8,11,52,207,251,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,255,254,255,255,255,225,90,7,8,8,9,10,10,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,19,13,19,49,114,201,253,255,254,251,255,255,253,249,254,255,252,252,253,253,253,254,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,253,246,255,180,47,11,23,4,10,10,9,8,8,7,6,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,6,10,7,12,55,211,253,253,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,255,248,255,253,241,138,32,8,8,9,10,10,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,18,7,18,84,184,250,255,247,255,255,255,254,254,250,251,255,252,252,253,253,253,254,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,255,251,255,221,96,19,19,6,10,10,9,8,8,7,6,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,9,7,14,60,216,255,252,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,248,252,239,254,252,255,177,59,8,8,9,10,10,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,13,3,17,105,218,255,242,244,250,255,251,251,255,253,248,255,252,252,253,253,253,254,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,251,255,255,234,132,27,11,12,10,10,9,8,8,7,6,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,6,15,64,220,255,251,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,255,251,242,255,250,255,239,116,28,1,16,27,0,1,18,5,8,8,8,8,8,8,8,8,5,10,11,6,7,12,12,7,17,9,40,145,231,252,255,251,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,254,254,254,254,254,254,249,252,243,250,195,64,1,23,5,14,9,9,16,15,10,5,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,10,7,9,11,72,227,255,248,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,252,253,246,255,249,255,248,158,31,19,9,6,9,13,15,13,8,8,8,8,8,8,8,8,13,14,11,6,7,12,13,8,3,13,78,188,245,252,255,243,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,254,254,254,254,254,254,250,254,248,255,230,130,46,11,2,8,6,4,8,11,10,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,9,12,14,78,227,255,250,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,245,255,250,255,248,250,255,212,53,20,0,5,14,9,6,12,8,8,8,8,8,8,8,8,15,13,9,6,9,15,17,14,5,50,142,236,255,250,255,242,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,254,254,254,254,254,254,255,255,247,255,253,198,105,13,7,6,9,5,2,8,9,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,6,9,12,17,91,228,255,251,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,243,255,252,255,252,247,255,247,119,31,0,23,17,0,4,9,8,8,8,8,8,8,8,8,9,7,6,7,13,19,20,19,31,119,208,255,255,248,255,251,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,254,254,254,254,254,254,255,255,243,249,255,242,177,78,23,7,14,11,3,9,9,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,10,8,5,20,112,233,255,250,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,247,255,251,254,255,248,250,255,210,95,19,15,13,7,12,12,8,8,8,8,8,8,8,8,5,5,7,11,15,16,18,19,59,181,249,254,252,249,255,255,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,254,254,254,254,254,254,254,254,248,254,255,255,241,176,43,4,10,13,4,11,9,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,15,5,0,29,141,241,255,249,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,252,255,250,253,255,251,246,253,255,180,63,0,3,14,9,10,8,8,8,8,8,8,8,8,8,9,12,15,14,12,16,23,87,214,255,246,251,252,252,255,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,254,254,254,254,254,254,251,255,254,255,252,252,253,223,78,4,2,11,5,12,8,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,16,2,2,53,179,248,255,250,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,255,253,251,252,255,254,249,254,255,234,147,51,13,8,4,7,8,8,8,8,8,8,8,8,8,10,14,15,11,11,24,40,134,228,255,248,254,251,252,255,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,254,254,254,254,254,254,252,255,252,254,249,244,246,231,133,23,3,13,5,12,5,10,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,2,16,86,216,254,255,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,250,252,252,255,255,253,255,244,252,230,142,40,1,8,11,8,8,8,8,8,8,8,8,5,7,12,13,10,14,36,60,179,237,255,255,255,249,254,255,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,254,254,254,254,254,254,253,255,245,249,255,255,255,244,181,47,12,18,8,11,2,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,1,2,30,111,240,255,253,255,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,243,255,232,114,30,14,2,14,10,7,10,14,14,10,6,4,13,13,6,5,28,108,185,242,245,250,254,255,255,252,250,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,218,88,26,4,11,0,17,0,8,8,8,8,8,8,8,8,0,2,11,10,3,13,17,0,18,4,57,186,248,248,255,239,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,248,251,252,245,198,105,29,9,0,11,18,11,2,2,8,12,3,6,9,11,17,94,189,240,245,248,251,254,255,254,252,251,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,246,152,40,15,7,6,18,9,8,8,8,8,8,8,8,8,10,6,9,10,3,1,8,11,19,29,117,223,255,248,243,253,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,247,255,249,253,255,195,84,18,4,13,14,4,0,5,12,13,6,4,6,20,33,159,245,255,250,251,252,253,253,253,253,253,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,213,61,18,1,9,9,9,8,8,8,8,8,8,8,8,13,12,8,6,9,6,5,12,19,81,197,252,255,254,237,255,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,252,255,255,251,255,249,166,50,12,8,6,8,11,11,10,10,7,6,8,35,70,204,254,244,254,254,253,252,252,253,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,250,239,103,18,9,15,1,11,8,8,8,8,8,8,8,8,5,14,7,4,17,17,7,8,46,154,250,254,248,255,250,255,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,252,252,255,250,239,255,226,127,32,11,1,10,14,7,4,9,6,8,10,46,123,240,255,249,255,255,253,252,252,253,254,255,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,246,161,27,22,20,1,17,8,8,8,8,8,8,8,8,4,9,6,8,13,6,12,40,120,222,255,251,245,252,255,249,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,246,251,255,253,249,255,245,213,119,62,8,0,5,10,9,11,9,6,12,42,156,248,250,255,255,254,253,253,253,253,253,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,245,203,54,21,12,1,14,8,8,8,8,8,8,8,8,11,3,5,13,5,0,48,121,210,255,255,255,253,243,255,252,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,248,253,254,253,255,253,250,251,219,163,87,30,10,11,13,11,15,4,22,35,167,242,248,251,252,252,253,254,254,253,253,253,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,250,249,224,109,22,10,8,5,8,8,8,8,8,8,8,8,13,5,9,13,12,47,132,210,255,255,251,255,255,246,249,255,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,254,255,249,243,253,255,247,255,251,202,110,31,1,4,10,18,2,35,39,177,245,255,252,250,251,253,254,255,254,253,252,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,245,255,237,166,37,22,24,4,8,8,8,8,8,8,8,8,7,11,14,8,27,112,213,255,255,242,253,247,248,255,246,255,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,247,252,247,222,137,44,17,16,5,14,15,77,217,245,255,251,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,251,255,251,233,140,31,6,8,17,14,21,11,3,4,2,17,8,12,16,43,118,209,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,248,241,251,229,169,105,43,18,15,23,110,230,254,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,252,255,250,246,191,77,11,11,4,5,14,10,13,14,1,8,3,13,65,153,222,245,248,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,251,247,255,255,242,199,133,51,21,30,144,233,254,247,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,251,255,252,255,236,129,22,15,12,11,11,3,10,15,4,17,51,104,180,238,255,255,251,248,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,246,255,255,254,240,243,250,221,96,37,45,173,233,254,245,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,251,251,255,253,246,168,48,14,1,6,13,6,13,24,33,64,157,216,255,253,243,251,255,245,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,251,254,255,255,245,251,255,228,111,46,71,200,244,255,250,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,255,246,255,250,247,209,96,11,10,6,18,17,25,63,120,186,242,245,249,252,254,253,251,248,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,249,248,255,253,255,242,179,75,36,100,217,251,255,248,251,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,255,245,253,253,254,248,158,38,22,44,127,188,197,204,226,255,255,246,242,250,255,252,252,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,251,251,249,251,247,252,213,114,33,33,139,229,255,247,247,247,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,255,250,251,254,254,255,213,107,42,50,156,254,255,255,254,255,244,255,255,246,241,249,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,255,254,252,254,255,194,58,22,48,178,244,255,245,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,242,255,252,252,245,252,243,173,67,41,130,231,249,251,255,251,249,252,253,251,253,255,254,248,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,249,237,255,248,252,254,147,44,33,112,206,247,255,255,252,255,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,254,254,254,254,254,254,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,255,254,249,254,255,243,222,77,24,68,179,244,251,242,252,253,253,253,254,254,255,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,247,253,246,255,232,126,47,64,167,243,255,255,254,254,249,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,254,254,254,254,254,254,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,250,255,253,249,253,255,248,231,113,24,32,123,221,250,255,246,253,253,253,254,254,255,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,255,250,255,251,180,76,22,80,207,255,255,248,248,255,246,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,254,254,254,254,254,254,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,247,253,253,249,251,255,253,244,162,27,12,58,172,252,255,243,253,253,253,254,254,255,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,250,247,255,217,113,33,9,103,228,255,247,247,244,255,248,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,254,254,254,254,254,254,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,247,253,255,251,250,255,255,252,202,53,18,24,111,247,241,249,253,253,253,254,254,255,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,242,249,247,163,55,20,30,159,250,255,252,255,247,255,250,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,254,254,254,254,254,254,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,251,255,255,252,250,252,254,254,227,115,22,18,62,211,234,255,253,253,253,254,254,255,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,245,255,234,121,23,16,55,206,254,250,252,255,251,254,253,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,254,254,254,254,254,254,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,255,255,253,252,252,252,252,241,189,44,24,36,142,228,254,253,253,253,254,254,255,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,252,255,193,82,15,29,105,231,247,246,246,255,254,252,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,254,254,254,254,254,254,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,255,253,253,254,254,253,252,251,248,234,119,33,21,68,186,244,253,253,253,254,254,255,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,250,234,135,43,17,59,174,253,254,255,248,250,255,250,252,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,254,254,254,254,254,254,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,251,250,253,255,255,252,250,249,245,203,40,13,22,133,235,253,253,253,254,254,255,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,252,255,179,66,18,17,143,219,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,239,240,84,14,3,75,224,254,250,248,251,255,255,246,251,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,249,244,122,28,11,45,181,247,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,248,245,143,23,1,40,179,249,251,252,252,255,255,251,252,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,251,225,69,1,14,92,217,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,250,255,248,196,33,7,15,120,247,253,255,254,250,251,255,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,250,183,42,0,27,149,240,251,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,250,255,248,215,50,15,16,82,250,255,252,255,251,245,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,246,126,28,0,37,193,253,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,251,253,255,229,94,16,16,71,237,254,248,255,255,242,251,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,247,88,20,0,56,211,251,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,252,242,255,252,162,38,8,62,189,246,248,252,255,244,250,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,230,72,15,13,110,226,248,250,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,252,246,255,255,221,108,14,35,117,234,255,246,255,250,253,251,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,197,60,10,35,169,248,255,250,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,252,255,246,250,252,181,31,6,61,226,255,242,255,255,255,250,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,251,253,255,255,249,249,249,253,111,35,4,112,225,246,254,246,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,252,253,254,255,250,219,81,6,42,172,254,255,248,255,254,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,252,253,255,253,252,250,253,227,61,19,28,173,245,255,245,245,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,251,254,249,255,251,234,116,21,23,131,244,249,255,248,253,245,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,255,246,255,252,254,181,29,16,67,223,248,255,243,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,250,255,245,253,253,251,164,37,11,83,222,243,255,246,255,250,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,255,243,255,254,242,128,22,28,120,242,246,250,248,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,250,255,245,252,252,255,198,42,8,46,181,240,255,247,254,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,252,255,244,255,254,212,80,13,36,174,247,255,249,255,241,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,252,255,248,251,251,255,212,45,5,22,130,243,243,252,244,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,251,254,251,253,253,168,43,11,44,201,241,255,253,255,240,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,255,254,250,251,254,217,61,10,18,98,248,251,255,247,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,250,252,255,247,251,124,20,15,53,203,241,252,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,251,255,248,253,255,224,93,19,13,73,229,255,255,255,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,250,250,255,243,250,97,9,11,58,201,255,250,255,238,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,247,255,246,255,255,231,120,18,0,48,193,253,231,255,245,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,251,243,250,255,253,228,78,9,11,88,224,250,255,254,255,252,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,254,254,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,248,253,253,249,255,240,189,44,19,28,123,244,255,251,249,255,255,255,252,253,255,255,252,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,255,239,236,253,197,51,0,26,120,234,250,255,250,255,251,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,254,254,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,249,252,250,246,255,246,205,47,18,20,73,188,247,255,247,249,249,249,248,249,252,253,253,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,255,249,247,246,139,31,3,45,166,248,250,253,245,255,249,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,254,254,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,249,252,249,244,255,253,226,76,17,12,21,102,189,237,255,254,253,253,255,255,253,251,250,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,250,255,255,200,62,19,9,63,204,255,252,255,245,255,249,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,254,254,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,251,254,252,246,253,255,241,128,18,10,2,30,91,170,255,255,253,254,255,255,255,253,249,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,250,252,240,190,113,4,8,13,84,228,255,253,255,249,255,250,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,254,254,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,252,252,255,255,251,251,252,246,169,22,11,5,0,21,95,204,247,249,249,249,252,255,255,251,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,254,175,85,40,0,8,23,119,241,255,254,255,253,252,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,254,254,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,252,252,255,255,255,250,249,249,187,34,12,8,4,7,45,115,224,246,255,251,246,253,255,250,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,251,200,89,26,9,10,10,30,161,251,252,254,255,255,246,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,254,254,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,251,252,255,255,249,248,255,200,53,12,5,13,10,17,41,140,204,255,255,248,252,255,248,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,229,120,22,20,3,11,5,26,192,255,252,253,252,255,241,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,254,254,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,250,247,252,254,248,249,255,213,68,12,4,15,6,3,11,32,136,232,255,249,253,255,250,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,252,243,255,255,247,251,251,225,123,53,15,7,6,7,13,39,216,249,253,253,254,250,255,250,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,255,255,254,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,221,72,16,9,1,12,5,6,14,52,144,232,255,250,252,255,255,252,250,252,255,255],
    [254,254,254,254,254,254,254,254,253,253,253,243,246,255,221,137,45,10,5,8,4,4,19,59,218,249,253,253,254,249,255,251,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,255,254,254,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,226,81,22,13,6,14,5,6,18,5,62,171,240,250,247,249,255,255,255,252,246,245],
    [254,254,254,254,254,254,254,254,255,248,246,247,253,238,152,44,6,0,10,14,9,6,24,71,221,250,252,254,255,249,254,251,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,255,254,254,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,228,90,23,12,7,14,7,9,13,0,14,79,170,243,255,242,250,254,255,255,255,252],
    [254,254,254,254,254,254,254,254,255,240,247,255,240,162,68,6,16,8,12,10,12,10,23,72,226,251,251,254,255,249,254,252,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,232,101,22,6,5,10,7,13,9,16,13,17,74,171,238,252,246,245,245,248,253,255],
    [254,254,254,254,254,254,254,254,248,253,255,235,169,76,17,6,10,6,3,0,9,7,21,82,230,252,251,254,255,249,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,252,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,244,120,28,4,4,5,5,14,10,5,5,9,16,55,151,247,255,255,249,244,243,245],
    [254,254,254,254,254,254,254,254,243,255,234,147,71,25,7,9,1,7,9,7,12,2,22,104,235,253,250,255,255,248,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,251,252,253,254,255,255,255,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,251,136,35,7,9,4,2,12,7,0,4,17,4,0,74,181,244,251,255,255,255,255],
    [254,254,254,254,254,254,254,254,250,236,155,56,16,11,7,10,9,15,15,13,18,1,27,127,238,254,249,255,255,248,253,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,250,251,252,254,255,255,255,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,234,132,31,7,14,6,1,10,6,11,12,12,9,6,33,79,141,151,174,208,241,255],
    [254,254,254,254,254,254,254,254,255,186,72,9,13,12,2,14,16,12,3,4,17,2,32,141,240,254,249,255,255,248,253,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,249,250,252,254,255,255,255,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,210,116,21,3,16,7,2,10,14,14,5,5,16,11,3,9,20,16,35,95,176,233],
    [247,255,252,255,255,226,177,157,130,79,28,10,10,9,8,9,2,10,11,7,15,9,37,125,237,247,255,250,248,252,253,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,254,248,255,252,244,255,226,73,16,10,6,3,17,5,8,8,8,8,8,8,8,8,2,9,5,11,62,133],
    [255,251,255,245,168,80,37,31,32,13,3,10,17,13,9,11,6,10,10,4,8,1,22,99,233,246,253,250,252,253,251,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,252,245,243,253,251,246,255,212,65,12,9,9,3,16,6,8,8,8,8,8,8,8,8,20,17,8,4,20,44],
    [242,255,241,161,64,10,0,0,5,2,6,13,10,2,2,9,10,9,8,3,7,0,13,75,227,248,251,250,255,254,250,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,254,246,251,255,254,251,253,185,51,6,8,13,4,13,6,8,8,8,8,8,8,8,8,10,6,7,13,15,11],
    [249,255,176,57,11,14,13,15,10,10,13,14,7,3,10,23,11,6,9,8,11,10,17,62,216,252,252,249,255,254,251,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,255,251,255,255,251,252,243,148,35,2,6,15,5,10,7,8,8,8,8,8,8,8,8,2,0,3,11,11,4],
    [255,186,79,13,6,5,1,11,3,5,10,14,11,7,8,13,12,3,11,11,12,14,18,46,191,253,255,247,255,252,253,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,251,253,248,255,247,245,255,232,105,22,3,4,16,7,8,6,8,8,8,8,8,8,8,8,13,10,6,4,4,6],
    [247,109,20,12,4,3,13,8,11,10,9,9,8,5,3,2,13,2,12,10,4,9,11,26,147,246,255,246,255,250,254,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,255,249,254,246,251,255,212,64,13,9,3,14,8,8,6,8,8,8,8,8,8,8,8,15,14,8,2,8,21],
    [248,98,17,16,2,8,24,5,10,8,6,5,7,11,14,14,13,1,14,10,0,5,9,16,95,230,255,247,255,250,255,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,255,250,255,254,255,244,155,32,9,16,2,11,9,8,5,8,8,8,8,8,8,8,8,9,9,6,2,4,9],
    [239,95,9,17,16,6,9,8,6,10,12,12,10,9,6,3,12,0,15,12,0,8,13,17,59,217,255,248,255,250,255,250,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,243,250,244,255,255,250,210,88,14,7,21,1,9,9,9,5,8,8,8,8,8,8,8,8,5,6,10,12,9,4],
    [243,96,19,9,4,7,4,6,8,8,8,8,8,8,8,8,9,8,8,7,7,8,8,9,38,161,249,255,240,255,240,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,250,255,240,255,246,125,38,11,9,8,9,11,12,10,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [245,102,22,10,6,9,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,25,90,209,244,253,242,255,251,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,251,247,250,248,255,201,74,13,11,9,8,9,11,11,10,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [247,112,25,10,9,11,8,11,8,8,8,8,8,8,8,8,6,7,9,10,10,9,7,6,14,26,138,234,255,235,255,250,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,252,248,255,247,142,30,6,11,9,8,8,10,11,10,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [247,124,28,8,11,10,8,10,8,8,8,8,8,8,8,8,5,7,9,11,11,9,7,5,13,13,67,213,252,255,254,251,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,254,252,255,203,83,13,15,10,9,7,8,10,11,9,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [247,136,31,5,11,7,6,8,8,8,8,8,8,8,8,8,5,7,9,11,11,9,7,5,11,20,25,149,241,255,246,252,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,252,249,255,235,137,36,9,12,10,8,7,8,10,10,9,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [249,149,35,3,11,5,5,6,8,8,8,8,8,8,8,8,6,7,9,10,10,9,7,6,6,13,14,67,209,247,253,251,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,252,255,207,87,18,10,7,10,8,6,7,9,10,9,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [253,161,40,4,14,6,5,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,4,11,25,142,225,255,252,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,254,254,165,55,18,9,10,9,8,6,7,9,10,8,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [255,169,44,5,16,7,6,7,8,8,8,8,8,8,8,8,9,8,8,7,7,8,8,9,13,4,5,27,79,217,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,253,253,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,245,230,122,31,16,2,14,9,7,6,7,9,9,8,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [254,173,48,2,16,7,2,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,14,8,11,10,49,170,255,249,250,249,250,255,255,250,246,252,253,253,253,254,254,255,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,247,253,255,241,255,255,239,255,255,205,126,58,21,10,12,15,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [253,169,45,2,15,7,3,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,6,6,15,12,30,121,220,255,255,255,251,249,251,252,252,254,253,253,253,254,254,255,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,255,255,255,251,245,255,253,217,146,105,52,17,8,11,11,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [251,161,41,2,13,7,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,5,6,14,13,13,58,142,204,246,255,255,253,248,253,255,254,253,253,253,254,254,255,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,250,253,255,255,244,253,239,130,48,30,10,2,6,11,9,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [249,153,37,4,11,6,9,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,11,8,8,11,10,17,53,98,169,210,252,255,247,250,255,255,253,253,253,254,254,255,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,248,253,249,248,251,255,192,55,11,14,16,14,10,7,8,10,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [249,145,34,6,9,6,12,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,10,9,6,8,11,5,5,19,58,129,218,255,249,245,255,255,253,253,253,254,254,255,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,253,255,247,230,255,255,138,29,2,8,13,12,8,6,9,14,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [250,138,31,9,8,6,14,5,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,2,8,8,7,9,7,4,4,6,75,186,255,255,246,251,253,253,253,253,254,254,255,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,245,253,255,243,255,217,88,21,12,7,3,3,7,10,9,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [251,135,30,11,7,5,17,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,3,4,8,8,6,9,12,8,8,45,144,238,255,251,251,251,253,253,253,254,254,255,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,243,244,255,255,207,123,45,12,19,13,6,6,10,12,9,5,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [253,133,30,13,7,5,18,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,11,2,5,10,6,8,10,2,6,13,97,206,252,254,255,255,253,253,253,254,254,255,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,253,253,253,254,254,254,254,254,254,254,254,255,242,250,246,132,27,21,12,7,10,12,11,9,9,11,14,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [246,145,33,5,12,7,10,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,14,3,35,126,218,255,255,247,244,249,255,252,246,254,255,242,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,255,245,245,255,250,243,255,254,255,219,132,47,8,8,16,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [247,147,35,6,12,7,10,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,16,19,41,124,227,255,248,255,249,251,255,255,254,255,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,246,252,255,250,250,255,250,233,180,149,95,43,17,14,12,5,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [250,151,38,6,11,6,10,5,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,5,18,12,4,43,130,207,240,253,247,250,253,246,245,251,251,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,254,255,250,248,255,219,147,70,46,18,5,8,14,12,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [252,155,42,7,9,6,10,4,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,8,10,12,15,40,99,153,191,222,254,255,246,253,255,249,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,250,246,248,255,248,163,57,12,9,11,17,16,9,8,12,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [254,159,46,8,8,6,10,4,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,6,7,6,6,9,17,26,31,78,140,218,255,255,254,255,247,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,244,252,250,253,255,208,108,28,16,6,3,10,12,6,5,10,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [255,162,49,8,7,6,12,5,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,10,12,12,12,12,7,0,12,63,161,245,255,247,241,246,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,252,255,254,233,195,119,45,20,12,7,5,9,7,3,5,13,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [255,164,51,8,7,7,13,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,10,16,20,13,3,7,20,16,33,108,204,250,251,250,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,251,224,186,145,92,35,7,10,2,9,16,17,9,3,7,14,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [254,165,52,8,6,7,14,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,2,7,6,2,3,10,10,5,11,6,47,130,202,241,255,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,219,147,83,45,14,4,11,12,13,11,8,6,7,9,8,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [255,155,41,8,12,7,10,5,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,17,0,0,32,86,143,197,235,254,251,245,249,255,252,248,255,255,255,255,254,252,252,253,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,248,255,255,255,254,255,255,250,254,244,251,255,251,255,242,195,98,54,18,15,16,6,1,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [254,153,39,8,12,6,10,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,6,8,16,22,25,43,89,134,211,250,255,253,247,249,249,247,251,251,252,253,255,254,253,252,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,252,253,251,250,251,253,254,251,254,254,255,252,231,203,142,69,32,11,0,8,13,8,6,13,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [252,151,37,6,11,6,10,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,10,9,11,9,1,0,16,40,110,189,247,252,250,255,255,253,249,248,249,252,255,255,253,249,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,251,250,252,254,254,255,255,241,252,255,234,169,92,36,9,1,1,5,11,12,9,9,14,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [249,149,36,5,10,6,10,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,15,5,0,7,13,12,9,9,20,79,144,195,240,255,255,247,255,251,249,251,255,255,254,250,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,254,255,255,253,247,247,252,243,249,224,156,72,12,1,20,10,14,15,11,7,7,9,11,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [248,148,35,4,10,6,10,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,7,8,11,10,7,7,10,0,12,33,87,172,233,249,244,255,255,251,250,253,255,255,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,255,255,253,246,243,246,252,255,224,139,48,7,9,12,9,7,9,8,3,3,8,10,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [249,149,35,5,10,6,10,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,8,6,5,6,9,5,13,8,16,71,152,224,255,255,255,254,252,252,252,254,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,250,254,254,252,254,255,255,255,223,135,44,6,6,11,10,6,4,5,6,7,10,13,10,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [250,150,36,5,10,6,10,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,12,8,4,5,10,13,12,8,5,19,18,6,13,58,146,229,244,249,255,255,253,251,252,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,248,254,254,253,255,255,228,193,113,40,3,16,15,2,6,15,10,9,11,14,13,9,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [251,151,37,6,11,6,10,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,5,9,10,7,4,5,8,10,8,0,1,12,8,2,52,128,231,242,254,255,254,250,250,252,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,253,255,255,250,248,226,160,92,15,5,15,16,2,11,19,1,8,6,7,9,5,0,5,14,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8],
    [252,175,37,7,8,7,6,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,6,12,16,13,7,8,19,31,113,182,249,255,247,242,249,255,253,253,253,252,250,251,254,255,254,253,250,247,244,246,251,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,248,251,254,255,255,255,255,255,251,251,253,255,255,255,255,255,255,245,251,255,255,245,241,255,255,254,236,199,146,94,54,33,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7],
    [252,180,43,8,6,7,8,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,12,14,11,6,6,14,21,28,87,159,210,239,254,255,254,250,252,255,255,255,255,250,246,252,254,255,255,255,254,251,250,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,254,250,249,250,250,249,248,255,254,251,250,249,249,251,253,246,255,255,254,255,255,255,243,243,200,138,84,49,27,11,0,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7],
    [252,187,51,9,4,7,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,10,11,9,6,6,8,10,1,23,61,107,155,200,235,255,253,253,254,255,255,255,254,252,254,251,247,245,246,250,253,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,255,251,252,255,255,254,251,255,255,255,255,255,255,254,253,250,255,239,245,252,242,225,182,128,86,34,4,2,11,13,10,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7],
    [252,192,58,11,2,7,10,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,8,9,9,8,7,5,18,15,17,27,47,85,142,188,236,244,254,255,254,250,248,248,252,251,252,253,254,255,254,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,251,253,255,255,255,255,251,248,255,255,255,251,251,254,253,249,255,255,241,255,228,147,108,69,28,18,8,5,10,16,16,13,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7],
    [253,193,59,11,3,8,10,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,7,7,9,12,12,10,7,4,7,13,12,3,6,38,73,147,178,219,247,255,254,255,255,255,255,255,255,252,250,249,250,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,249,253,255,253,248,244,244,246,246,249,248,246,250,255,255,250,246,243,213,205,132,28,13,15,8,9,10,10,8,6,4,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7],
    [255,189,54,11,5,8,9,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,8,9,11,12,11,10,0,2,8,11,5,0,8,24,35,69,115,150,168,181,194,206,221,234,250,255,255,254,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,252,253,253,250,248,250,255,255,252,255,255,253,246,234,212,189,156,140,101,82,41,0,6,17,10,6,2,3,7,10,9,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7],
    [255,184,46,10,8,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,8,9,8,7,8,9,11,14,8,2,3,7,12,17,22,0,8,22,33,40,49,61,70,109,142,186,219,235,241,247,253,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,251,249,252,255,255,253,247,243,238,217,184,155,129,97,68,37,25,14,19,24,19,13,4,14,10,7,7,10,11,8,5,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7],
    [255,179,41,10,10,7,6,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,7,4,3,6,10,11,8,5,6,10,11,6,0,13,11,9,8,8,9,9,9,1,24,56,87,121,167,220,255,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,250,246,251,255,246,222,200,175,151,103,51,24,20,17,8,16,5,7,8,7,5,2,11,5,7,9,8,5,5,7,11,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7],
    [255,158,32,8,5,12,9,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,10,10,10,10,9,8,10,10,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,16,13,18,26,29,51,116,182,226,248,255,254,247,250,253,251,252,253,252,251,249,251,255,255,253,253,253,253,253,252,250,250,255,255,255,255,252,251,254,255,254,254,254,255,255,255,255,255,255,254,253,253,254,255,253,251,255,252,240,226,201,158,107,70,30,26,20,15,12,12,13,15,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,10,10,8,8,8,8,8,8,7,7,6,6,6,6,6,6,6,6,9,9,9,9,9,9,9,9,8,8,8,7,7,6],
    [255,154,30,9,6,11,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,8,9,9,8,7,7,10,10,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,6,2,4,8,5,8,38,73,134,174,219,244,255,255,255,254,254,255,255,255,252,248,246,246,255,255,255,255,255,255,255,255,255,254,251,251,255,255,253,250,255,255,255,255,255,255,254,254,255,255,255,254,250,244,235,229,216,190,152,115,84,55,28,10,13,10,7,4,2,3,4,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,10,10,10,10,10,10,10,10,10,10,8,8,8,8,8,8,8,8,8,8,7,7,7,7,6,6,8,8,8,7,7,7],
    [253,150,28,12,9,9,5,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,5,6,7,7,7,7,6,5,10,10,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,11,7,7,10,10,6,7,12,21,61,111,150,183,211,227,231,232,239,249,255,255,255,255,255,253,253,253,252,250,248,246,245,245,241,240,245,248,237,213,193,188,187,186,184,182,180,179,178,169,169,169,167,161,151,138,129,80,65,44,26,17,13,10,7,7,6,6,5,5,6,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,10,10,12,12,12,12,12,12,13,13,9,9,9,9,9,9,9,9,9,9,8,8,7,7,6,6,8,8,8,8,7,7],
    [251,148,28,14,10,8,4,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,8,9,9,8,7,7,10,10,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,10,8,5,5,10,13,11,5,0,12,29,41,58,84,107,118,137,147,161,175,185,192,196,199,209,207,204,199,194,188,183,180,165,157,147,137,121,91,54,26,43,43,42,40,39,37,36,35,32,32,34,35,33,26,17,10,2,4,7,10,13,13,12,10,9,9,10,11,12,12,11,11,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,10,10,11,12,12,12,12,13,13,13,8,8,8,8,8,8,8,8,12,12,11,11,10,9,9,9,9,9,8,8,8,7],
    [251,151,31,15,9,8,4,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,10,10,11,11,10,10,9,10,10,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,11,11,7,3,5,10,10,6,10,12,9,3,2,8,16,21,13,19,28,35,41,46,51,54,51,49,45,40,33,26,20,17,8,6,5,7,10,12,11,9,2,2,2,1,1,1,1,1,6,5,5,7,10,10,7,5,14,13,11,9,6,3,1,0,6,6,7,8,8,7,5,5,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,10,10,9,9,9,10,11,11,11,12,7,7,7,7,7,7,7,7,11,11,10,10,9,9,9,9,9,9,9,8,8,8],
    [253,158,38,14,6,10,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,10,11,11,12,12,11,11,10,10,10,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,12,13,11,10,10,11,10,5,6,5,5,6,9,13,15,5,7,9,10,9,10,12,15,27,26,24,22,18,15,11,10,10,10,9,4,0,0,0,3,7,7,7,8,8,9,10,10,8,6,3,4,7,10,10,10,13,11,8,7,7,9,10,10,7,7,7,7,7,6,5,4,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,10,10,7,7,8,9,9,10,11,11,8,8,8,8,8,8,8,8,7,7,8,8,8,8,8,8,10,9,9,9,8,8],
    [255,167,45,12,3,12,10,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,10,10,11,11,10,10,9,10,10,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,2,2,5,9,9,7,7,9,12,9,7,7,9,12,15,17,10,12,14,13,11,10,11,13,3,4,5,5,5,5,4,3,0,5,12,14,13,10,8,8,9,9,9,10,10,11,11,11,14,11,8,7,9,10,10,10,6,6,8,14,18,19,14,9,10,9,9,9,9,9,10,11,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,10,10,7,8,8,9,10,11,11,12,11,11,11,11,11,11,11,11,10,10,11,11,12,13,13,13,10,10,9,9,9,8],
    [255,173,49,11,0,13,12,5,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,8,9,9,9,9,8,7,10,10,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,17,11,10,14,15,12,11,15,12,10,9,10,11,10,7,7,4,7,10,10,7,5,3,3,5,6,7,9,10,10,10,10,11,11,12,12,12,12,11,11,8,8,8,8,8,8,7,7,11,9,7,7,8,9,7,5,8,6,7,13,18,18,11,4,6,6,5,5,6,8,10,11,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,10,10,8,9,9,10,11,12,13,13,13,13,13,13,13,13,13,13,16,16,17,18,19,20,21,21,10,10,10,9,9,8],
    [253,186,73,0,0,8,4,11,4,4,5,5,4,2,0,0,0,1,3,5,5,4,2,1,5,6,6,6,5,3,2,1,1,3,6,8,8,6,3,1,5,5,5,5,5,5,5,5,8,8,7,6,5,4,4,3,6,6,5,4,4,5,6,6,6,6,6,6,5,4,2,2,4,6,8,9,9,8,6,4,9,8,7,6,7,8,9,10,16,14,12,10,10,11,13,14,6,6,6,5,5,4,4,4,7,7,6,5,4,3,2,2,6,5,5,4,5,6,7,7,10,8,6,5,5,6,8,10,16,12,10,12,16,17,12,7,9,9,9,9,8,6,5,4,5,5,5,5,5,5,5,5,2,2,2,2,2,2,2,2,4,4,5,4,3,2,1,0,4,4,4,5,5,5,5,5,7,7,7,7,7,7,7,7,6,6,5,4,4,5,6,6,13,11,8,6,5,6,7,8,2,12,17,19,29,39,33,18,16,8,8,30,65,92],
    [255,208,106,23,8,16,16,21,28,30,33,36,38,38,38,37,37,39,43,47,50,51,52,51,48,46,41,35,28,20,14,11,14,13,12,10,9,8,8,8,7,7,7,7,7,7,7,7,6,6,6,7,7,7,8,8,8,7,6,6,6,6,7,8,7,7,8,9,9,9,8,8,7,6,4,3,3,4,6,7,5,7,9,9,9,6,3,1,0,3,13,20,21,15,7,1,7,7,7,6,6,6,5,5,4,5,5,6,6,7,7,7,10,9,8,6,5,5,5,6,6,7,9,10,10,9,7,6,4,6,12,20,25,22,11,2,10,10,10,10,9,7,6,5,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,8,9,10,11,11,11,11,10,10,10,10,10,9,9,9,9,8,8,8,8,8,8,8,8,8,7,6,6,6,6,7,8,6,7,8,8,8,6,3,2,0,6,12,21,43,62,59,44,24,47,91,146,196,224],
    [255,249,198,142,131,138,136,135,154,156,159,163,166,167,168,168,171,174,177,182,185,187,188,188,184,180,173,163,152,141,132,128,104,100,94,89,87,88,90,92,86,86,86,86,86,86,86,86,90,91,92,93,95,96,97,98,95,94,94,93,93,94,94,95,94,95,97,98,99,99,99,99,90,87,82,79,79,82,87,90,101,104,108,110,109,103,96,91,84,94,109,120,122,114,102,93,86,86,86,86,85,85,84,84,88,89,90,92,94,97,98,99,100,98,96,94,92,91,90,90,90,93,98,101,101,98,93,90,93,97,106,116,121,117,107,98,96,97,97,97,96,95,93,93,89,89,89,89,89,89,89,89,85,85,85,85,85,85,85,85,88,89,91,93,94,95,96,96,91,91,91,90,90,89,88,88,95,95,95,95,95,95,95,95,95,94,94,93,93,94,94,95,99,102,106,109,108,104,99,95,90,92,95,107,132,153,152,138,141,163,198,232,253,255],
    [245,255,255,242,245,249,244,242,251,252,254,255,255,255,255,255,252,253,255,255,255,255,255,255,254,254,254,254,253,251,250,249,243,239,234,229,227,228,231,233,227,227,227,227,227,227,227,227,232,233,234,235,237,238,239,240,237,237,236,236,236,236,237,237,237,238,239,240,241,241,240,240,234,231,227,224,224,227,231,234,237,240,244,246,244,239,233,229,228,233,241,246,248,245,240,236,227,227,227,226,226,226,225,225,230,231,232,235,237,239,241,242,241,240,238,236,234,233,233,233,232,235,240,243,243,240,235,232,232,232,234,238,242,243,240,237,238,238,239,239,238,237,236,235,229,229,229,229,229,229,229,229,235,235,235,235,235,235,235,235,239,240,242,244,245,246,246,246,243,243,242,241,240,239,239,238,237,237,237,237,237,237,237,237,237,237,236,236,236,236,237,237,235,238,242,244,244,240,236,232,228,228,227,230,244,255,254,244,248,253,255,255,250,246],
    [252,255,254,255,255,255,255,255,254,254,254,254,253,252,251,251,253,253,253,252,252,250,249,248,251,252,253,254,255,255,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,253,253,254,254,255,255,255,255,255,255,255,254,254,255,255,255,255,255,255,255,255,255,254,253,255,255,255,255,255,255,255,255,254,255,255,255,255,255,253,252,255,255,254,253,254,255,255,255,255,255,255,255,255,255,254,254,251,252,253,254,255,255,255,255,255,255,254,253,253,253,254,255,255,255,255,255,255,255,255,255,255,252,249,248,250,253,254,254,255,255,255,255,255,255,255,254,255,255,255,255,255,255,255,255,252,252,252,252,252,252,252,252,248,249,250,251,251,251,251,250,252,251,251,250,249,248,247,247,255,255,255,255,255,255,255,255,255,255,255,254,254,255,255,255,254,255,255,255,255,255,254,253,254,255,254,250,249,251,251,248,251,252,253,255,255,254],
    [255,249,246,252,255,248,247,254,250,251,251,252,252,252,252,252,255,255,255,255,255,255,255,255,255,254,254,252,250,247,245,244,249,250,251,252,252,252,251,250,252,252,252,252,252,252,252,252,250,250,250,249,249,249,248,248,251,251,250,249,249,250,251,251,251,251,251,251,250,248,247,246,248,249,251,252,252,251,249,248,253,252,252,252,252,254,255,255,255,255,254,253,252,252,252,252,253,253,253,252,252,252,251,251,249,249,249,250,250,250,250,250,249,248,248,248,248,250,251,252,253,251,250,249,249,250,251,253,255,255,255,254,254,254,252,252,250,250,251,252,252,251,250,249,251,251,251,251,251,251,251,251,255,255,255,255,255,255,255,255,252,253,254,254,253,253,252,251,255,255,254,254,253,252,252,252,251,251,251,251,251,251,251,251,251,251,250,249,249,250,251,251,255,254,252,251,251,252,254,255,251,255,255,253,248,247,249,252,246,246,248,252,255,254],
    [245,243,247,253,254,252,252,252,255,255,255,255,255,255,255,255,250,251,251,251,252,253,253,254,247,249,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,252,253,255,255,255,255,253,252,254,253,253,253,254,254,255,255,254,255,255,255,255,254,253,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,253,253,253,253,253,253,253,253,253,254,255,255,255,255,254,253,255,255,255,255,254,254,254,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,253,252,252,253,255,255,249,250,252,253,252,251,252,254,255,255,255,255,254,254],
    [254,255,255,253,249,254,255,253,255,254,253,252,251,251,251,250,255,255,255,254,253,253,253,253,254,254,255,254,254,252,251,250,255,255,255,254,254,254,255,255,253,253,253,253,253,253,253,253,249,250,250,251,251,252,253,253,254,253,253,252,252,253,253,254,250,251,252,254,255,255,254,254,254,254,254,254,254,254,254,254,254,254,255,255,255,255,254,253,254,254,255,255,255,255,255,255,255,255,255,255,254,254,254,253,251,251,251,252,252,253,253,254,252,252,251,250,250,251,251,252,252,253,253,253,253,253,253,252,254,253,253,252,251,252,254,255,251,252,253,254,254,253,253,252,254,254,254,254,254,254,254,254,255,255,255,255,255,255,255,255,251,251,253,254,255,255,254,254,252,252,252,252,252,252,252,252,253,253,253,253,253,253,253,253,254,253,253,252,252,253,253,254,254,254,254,254,255,255,255,255,255,253,252,255,255,255,253,251,249,252,254,251,247,245],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,254,254,254,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,254,254,254,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,254,254,254,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,254,254,254,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,254,254,254,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,254,254,254,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,254,254,254,254],
    [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254],
    [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254]], dtype=float)
    return panda
