import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * Statement provider for service [batch](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbatch.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Batch extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [batch](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbatch.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to cancel a job in an AWS Batch job queue in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/batch/latest/APIReference/API_CancelJob.html
     */
    toCancelJob(): this;
    /**
     * Grants permission to create an AWS Batch compute environment in your account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/batch/latest/APIReference/API_CreateComputeEnvironment.html
     */
    toCreateComputeEnvironment(): this;
    /**
     * Grants permission to create an AWS Batch job queue in your account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/batch/latest/APIReference/API_CreateJobQueue.html
     */
    toCreateJobQueue(): this;
    /**
     * Grants permission to create an AWS Batch scheduling policy in your account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/batch/latest/APIReference/API_CreateSchedulingPolicy.html
     */
    toCreateSchedulingPolicy(): this;
    /**
     * Grants permission to delete an AWS Batch compute environment in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/batch/latest/APIReference/API_DeleteComputeEnvironment.html
     */
    toDeleteComputeEnvironment(): this;
    /**
     * Grants permission to delete an AWS Batch job queue in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/batch/latest/APIReference/API_DeleteJobQueue.html
     */
    toDeleteJobQueue(): this;
    /**
     * Grants permission to delete an AWS Batch scheduling policy in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/batch/latest/APIReference/API_DeleteSchedulingPolicy.html
     */
    toDeleteSchedulingPolicy(): this;
    /**
     * Grants permission to deregister an AWS Batch job definition in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/batch/latest/APIReference/API_DeregisterJobDefinition.html
     */
    toDeregisterJobDefinition(): this;
    /**
     * Grants permission to describe one or more AWS Batch compute environments in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/batch/latest/APIReference/API_DescribeComputeEnvironments.html
     */
    toDescribeComputeEnvironments(): this;
    /**
     * Grants permission to describe one or more AWS Batch job definitions in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/batch/latest/APIReference/API_DescribeJobDefinitions.html
     */
    toDescribeJobDefinitions(): this;
    /**
     * Grants permission to describe one or more AWS Batch job queues in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/batch/latest/APIReference/API_DescribeJobQueues.html
     */
    toDescribeJobQueues(): this;
    /**
     * Grants permission to describe a list of AWS Batch jobs in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/batch/latest/APIReference/API_DescribeJobs.html
     */
    toDescribeJobs(): this;
    /**
     * Grants permission to describe one or more AWS Batch scheduling policies in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/batch/latest/APIReference/API_DescribeSchedulingPolicies.html
     */
    toDescribeSchedulingPolicies(): this;
    /**
     * Grants permission to list jobs for a specified AWS Batch job queue in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/batch/latest/APIReference/API_ListJobs.html
     */
    toListJobs(): this;
    /**
     * Grants permission to list AWS Batch scheduling policies in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/batch/latest/APIReference/API_ListSchedulingPolicies.html
     */
    toListSchedulingPolicies(): this;
    /**
     * Grants permission to list tags for an AWS Batch resource in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/batch/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to register an AWS Batch job definition in your account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUser()
     * - .ifPrivileged()
     * - .ifImage()
     * - .ifLogDriver()
     * - .ifAWSLogsGroup()
     * - .ifAWSLogsRegion()
     * - .ifAWSLogsStreamPrefix()
     * - .ifAWSLogsCreateGroup()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/batch/latest/APIReference/API_RegisterJobDefinition.html
     */
    toRegisterJobDefinition(): this;
    /**
     * Grants permission to submit an AWS Batch job from a job definition in your account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifShareIdentifier()
     *
     * https://docs.aws.amazon.com/batch/latest/APIReference/API_SubmitJob.html
     */
    toSubmitJob(): this;
    /**
     * Grants permission to tag an AWS Batch resource in your account
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/batch/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to terminate a job in an AWS Batch job queue in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/batch/latest/APIReference/API_TerminateJob.html
     */
    toTerminateJob(): this;
    /**
     * Grants permission to untag an AWS Batch resource in your account
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/batch/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update an AWS Batch compute environment in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/batch/latest/APIReference/API_UpdateComputeEnvironment.html
     */
    toUpdateComputeEnvironment(): this;
    /**
     * Grants permission to update an AWS Batch job queue in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/batch/latest/APIReference/API_UpdateJobQueue.html
     */
    toUpdateJobQueue(): this;
    /**
     * Grants permission to update an AWS Batch scheduling policy in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/batch/latest/APIReference/API_UpdateSchedulingPolicy.html
     */
    toUpdateSchedulingPolicy(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type compute-environment to the statement
     *
     * https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html
     *
     * @param computeEnvironmentName - Identifier for the computeEnvironmentName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onComputeEnvironment(computeEnvironmentName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type job-queue to the statement
     *
     * https://docs.aws.amazon.com/batch/latest/userguide/job_queues.html
     *
     * @param jobQueueName - Identifier for the jobQueueName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onJobQueue(jobQueueName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type job-definition to the statement
     *
     * https://docs.aws.amazon.com/batch/latest/userguide/job_definitions.html
     *
     * @param jobDefinitionName - Identifier for the jobDefinitionName.
     * @param revision - Identifier for the revision.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onJobDefinition(jobDefinitionName: string, revision: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type job to the statement
     *
     * https://docs.aws.amazon.com/batch/latest/userguide/jobs.html
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onJob(jobId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type scheduling-policy to the statement
     *
     * https://docs.aws.amazon.com/batch/latest/userguide/scheduling-policy.html
     *
     * @param schedulingPolicyName - Identifier for the schedulingPolicyName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSchedulingPolicy(schedulingPolicyName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the specified logging driver to determine whether awslogs group will be created for the logs
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbatch.html#awsbatch-policy-keys
     *
     * Applies to actions:
     * - .toRegisterJobDefinition()
     *
     * @param value `true` or `false`. **Default:** `true`
     */
    ifAWSLogsCreateGroup(value?: boolean): this;
    /**
     * Filters access by the awslogs group where the logs are located
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbatch.html#awsbatch-policy-keys
     *
     * Applies to actions:
     * - .toRegisterJobDefinition()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAWSLogsGroup(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the region where the logs are sent to
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbatch.html#awsbatch-policy-keys
     *
     * Applies to actions:
     * - .toRegisterJobDefinition()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAWSLogsRegion(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the awslogs log stream prefix
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbatch.html#awsbatch-policy-keys
     *
     * Applies to actions:
     * - .toRegisterJobDefinition()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAWSLogsStreamPrefix(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by on the image used to start a container
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbatch.html#awsbatch-policy-keys
     *
     * Applies to actions:
     * - .toRegisterJobDefinition()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifImage(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the log driver used for the container
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbatch.html#awsbatch-policy-keys
     *
     * Applies to actions:
     * - .toRegisterJobDefinition()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifLogDriver(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the specified privileged parameter value that determines whether the container is given elevated privileges on the host container instance (similar to the root user)
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbatch.html#awsbatch-policy-keys
     *
     * Applies to actions:
     * - .toRegisterJobDefinition()
     *
     * @param value `true` or `false`. **Default:** `true`
     */
    ifPrivileged(value?: boolean): this;
    /**
     * Filters access by the shareIdentifier used inside submit job
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbatch.html#awsbatch-policy-keys
     *
     * Applies to actions:
     * - .toSubmitJob()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifShareIdentifier(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by user name or numeric uid used inside the container
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbatch.html#awsbatch-policy-keys
     *
     * Applies to actions:
     * - .toRegisterJobDefinition()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifUser(value: string | string[], operator?: Operator | string): this;
}
