import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [cloudshell](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscloudshell.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Cloudshell extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [cloudshell](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscloudshell.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permissions to create a CloudShell environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#CreateEnvironment
     */
    toCreateEnvironment(): this;
    /**
     * Grants permissions to connect to a CloudShell environment from the AWS Management Console
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#CreateSession
     */
    toCreateSession(): this;
    /**
     * Grants permission to delete a CloudShell environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#DeleteEnvironment
     */
    toDeleteEnvironment(): this;
    /**
     * Grants permission to read a CloudShell environment status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#GetEnvironmentStatus
     */
    toGetEnvironmentStatus(): this;
    /**
     * Grants permissions to download files from a CloudShell environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#GetFileDownloadUrls
     */
    toGetFileDownloadUrls(): this;
    /**
     * Grants permissions to upload files to a CloudShell environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#GetFileUploadUrls
     */
    toGetFileUploadUrls(): this;
    /**
     * Grants permissions to forward console credentials to the environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#PutCredentials
     */
    toPutCredentials(): this;
    /**
     * Grants permission to start a stopped CloudShell environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#StartEnvironment
     */
    toStartEnvironment(): this;
    /**
     * Grants permission to stop a running CloudShell environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#StopEnvironment
     */
    toStopEnvironment(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type Environment to the statement
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#Environment
     *
     * @param environmentId - Identifier for the environmentId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onEnvironment(environmentId: string, account?: string, region?: string, partition?: string): this;
}
