"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Iam = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [iam](https://docs.aws.amazon.com/service-authorization/latest/reference/list_identityandaccessmanagement.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Iam extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [iam](https://docs.aws.amazon.com/service-authorization/latest/reference/list_identityandaccessmanagement.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'iam';
        this.accessLevelList = {
            Write: [
                'AddClientIDToOpenIDConnectProvider',
                'AddRoleToInstanceProfile',
                'AddUserToGroup',
                'ChangePassword',
                'CreateAccessKey',
                'CreateAccountAlias',
                'CreateGroup',
                'CreateInstanceProfile',
                'CreateLoginProfile',
                'CreateOpenIDConnectProvider',
                'CreateRole',
                'CreateSAMLProvider',
                'CreateServiceLinkedRole',
                'CreateServiceSpecificCredential',
                'CreateUser',
                'CreateVirtualMFADevice',
                'DeactivateMFADevice',
                'DeleteAccessKey',
                'DeleteAccountAlias',
                'DeleteGroup',
                'DeleteInstanceProfile',
                'DeleteLoginProfile',
                'DeleteOpenIDConnectProvider',
                'DeleteRole',
                'DeleteSAMLProvider',
                'DeleteSSHPublicKey',
                'DeleteServerCertificate',
                'DeleteServiceLinkedRole',
                'DeleteServiceSpecificCredential',
                'DeleteSigningCertificate',
                'DeleteUser',
                'DeleteVirtualMFADevice',
                'EnableMFADevice',
                'PassRole',
                'RemoveClientIDFromOpenIDConnectProvider',
                'RemoveRoleFromInstanceProfile',
                'RemoveUserFromGroup',
                'ResetServiceSpecificCredential',
                'ResyncMFADevice',
                'SetSecurityTokenServicePreferences',
                'UpdateAccessKey',
                'UpdateAccountPasswordPolicy',
                'UpdateGroup',
                'UpdateLoginProfile',
                'UpdateOpenIDConnectProviderThumbprint',
                'UpdateRole',
                'UpdateRoleDescription',
                'UpdateSAMLProvider',
                'UpdateSSHPublicKey',
                'UpdateServerCertificate',
                'UpdateServiceSpecificCredential',
                'UpdateSigningCertificate',
                'UpdateUser',
                'UploadSSHPublicKey',
                'UploadServerCertificate',
                'UploadSigningCertificate'
            ],
            'Permissions management': [
                'AttachGroupPolicy',
                'AttachRolePolicy',
                'AttachUserPolicy',
                'CreatePolicy',
                'CreatePolicyVersion',
                'DeleteAccountPasswordPolicy',
                'DeleteGroupPolicy',
                'DeletePolicy',
                'DeletePolicyVersion',
                'DeleteRolePermissionsBoundary',
                'DeleteRolePolicy',
                'DeleteUserPermissionsBoundary',
                'DeleteUserPolicy',
                'DetachGroupPolicy',
                'DetachRolePolicy',
                'DetachUserPolicy',
                'PutGroupPolicy',
                'PutRolePermissionsBoundary',
                'PutRolePolicy',
                'PutUserPermissionsBoundary',
                'PutUserPolicy',
                'SetDefaultPolicyVersion',
                'UpdateAssumeRolePolicy'
            ],
            Read: [
                'GenerateCredentialReport',
                'GenerateOrganizationsAccessReport',
                'GenerateServiceLastAccessedDetails',
                'GetAccessKeyLastUsed',
                'GetAccountAuthorizationDetails',
                'GetAccountPasswordPolicy',
                'GetContextKeysForCustomPolicy',
                'GetContextKeysForPrincipalPolicy',
                'GetCredentialReport',
                'GetGroup',
                'GetGroupPolicy',
                'GetInstanceProfile',
                'GetOpenIDConnectProvider',
                'GetOrganizationsAccessReport',
                'GetPolicy',
                'GetPolicyVersion',
                'GetRole',
                'GetRolePolicy',
                'GetSAMLProvider',
                'GetSSHPublicKey',
                'GetServerCertificate',
                'GetServiceLastAccessedDetails',
                'GetServiceLastAccessedDetailsWithEntities',
                'GetServiceLinkedRoleDeletionStatus',
                'GetUser',
                'GetUserPolicy',
                'SimulateCustomPolicy',
                'SimulatePrincipalPolicy'
            ],
            List: [
                'GetAccountSummary',
                'GetLoginProfile',
                'ListAccessKeys',
                'ListAccountAliases',
                'ListAttachedGroupPolicies',
                'ListAttachedRolePolicies',
                'ListAttachedUserPolicies',
                'ListEntitiesForPolicy',
                'ListGroupPolicies',
                'ListGroups',
                'ListGroupsForUser',
                'ListInstanceProfileTags',
                'ListInstanceProfiles',
                'ListInstanceProfilesForRole',
                'ListMFADeviceTags',
                'ListMFADevices',
                'ListOpenIDConnectProviderTags',
                'ListOpenIDConnectProviders',
                'ListPolicies',
                'ListPoliciesGrantingServiceAccess',
                'ListPolicyTags',
                'ListPolicyVersions',
                'ListRolePolicies',
                'ListRoleTags',
                'ListRoles',
                'ListSAMLProviderTags',
                'ListSAMLProviders',
                'ListSSHPublicKeys',
                'ListServerCertificateTags',
                'ListServerCertificates',
                'ListServiceSpecificCredentials',
                'ListSigningCertificates',
                'ListUserPolicies',
                'ListUserTags',
                'ListUsers',
                'ListVirtualMFADevices'
            ],
            Tagging: [
                'TagInstanceProfile',
                'TagMFADevice',
                'TagOpenIDConnectProvider',
                'TagPolicy',
                'TagRole',
                'TagSAMLProvider',
                'TagServerCertificate',
                'TagUser',
                'UntagInstanceProfile',
                'UntagMFADevice',
                'UntagOpenIDConnectProvider',
                'UntagPolicy',
                'UntagRole',
                'UntagSAMLProvider',
                'UntagServerCertificate',
                'UntagUser'
            ]
        };
    }
    /**
     * Grants permission to add a new client ID (audience) to the list of registered IDs for the specified IAM OpenID Connect (OIDC) provider resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_AddClientIDToOpenIDConnectProvider.html
     */
    toAddClientIDToOpenIDConnectProvider() {
        return this.to('AddClientIDToOpenIDConnectProvider');
    }
    /**
     * Grants permission to add an IAM role to the specified instance profile
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_AddRoleToInstanceProfile.html
     */
    toAddRoleToInstanceProfile() {
        return this.to('AddRoleToInstanceProfile');
    }
    /**
     * Grants permission to add an IAM user to the specified IAM group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_AddUserToGroup.html
     */
    toAddUserToGroup() {
        return this.to('AddUserToGroup');
    }
    /**
     * Grants permission to attach a managed policy to the specified IAM group
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPolicyARN()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_AttachGroupPolicy.html
     */
    toAttachGroupPolicy() {
        return this.to('AttachGroupPolicy');
    }
    /**
     * Grants permission to attach a managed policy to the specified IAM role
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPolicyARN()
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_AttachRolePolicy.html
     */
    toAttachRolePolicy() {
        return this.to('AttachRolePolicy');
    }
    /**
     * Grants permission to attach a managed policy to the specified IAM user
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPolicyARN()
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_AttachUserPolicy.html
     */
    toAttachUserPolicy() {
        return this.to('AttachUserPolicy');
    }
    /**
     * Grants permission for an IAM user to to change their own password
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ChangePassword.html
     */
    toChangePassword() {
        return this.to('ChangePassword');
    }
    /**
     * Grants permission to create access key and secret access key for the specified IAM user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateAccessKey.html
     */
    toCreateAccessKey() {
        return this.to('CreateAccessKey');
    }
    /**
     * Grants permission to create an alias for your AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateAccountAlias.html
     */
    toCreateAccountAlias() {
        return this.to('CreateAccountAlias');
    }
    /**
     * Grants permission to create a new group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateGroup.html
     */
    toCreateGroup() {
        return this.to('CreateGroup');
    }
    /**
     * Grants permission to create a new instance profile
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateInstanceProfile.html
     */
    toCreateInstanceProfile() {
        return this.to('CreateInstanceProfile');
    }
    /**
     * Grants permission to create a password for the specified IAM user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateLoginProfile.html
     */
    toCreateLoginProfile() {
        return this.to('CreateLoginProfile');
    }
    /**
     * Grants permission to create an IAM resource that describes an identity provider (IdP) that supports OpenID Connect (OIDC)
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateOpenIDConnectProvider.html
     */
    toCreateOpenIDConnectProvider() {
        return this.to('CreateOpenIDConnectProvider');
    }
    /**
     * Grants permission to create a new managed policy
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html
     */
    toCreatePolicy() {
        return this.to('CreatePolicy');
    }
    /**
     * Grants permission to create a new version of the specified managed policy
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicyVersion.html
     */
    toCreatePolicyVersion() {
        return this.to('CreatePolicyVersion');
    }
    /**
     * Grants permission to create a new role
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html
     */
    toCreateRole() {
        return this.to('CreateRole');
    }
    /**
     * Grants permission to create an IAM resource that describes an identity provider (IdP) that supports SAML 2.0
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateSAMLProvider.html
     */
    toCreateSAMLProvider() {
        return this.to('CreateSAMLProvider');
    }
    /**
     * Grants permission to create an IAM role that allows an AWS service to perform actions on your behalf
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAWSServiceName()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateServiceLinkedRole.html
     */
    toCreateServiceLinkedRole() {
        return this.to('CreateServiceLinkedRole');
    }
    /**
     * Grants permission to create a new service-specific credential for an IAM user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateServiceSpecificCredential.html
     */
    toCreateServiceSpecificCredential() {
        return this.to('CreateServiceSpecificCredential');
    }
    /**
     * Grants permission to create a new IAM user
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateUser.html
     */
    toCreateUser() {
        return this.to('CreateUser');
    }
    /**
     * Grants permission to create a new virtual MFA device
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateVirtualMFADevice.html
     */
    toCreateVirtualMFADevice() {
        return this.to('CreateVirtualMFADevice');
    }
    /**
     * Grants permission to deactivate the specified MFA device and remove its association with the IAM user for which it was originally enabled
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeactivateMFADevice.html
     */
    toDeactivateMFADevice() {
        return this.to('DeactivateMFADevice');
    }
    /**
     * Grants permission to delete the access key pair that is associated with the specified IAM user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteAccessKey.html
     */
    toDeleteAccessKey() {
        return this.to('DeleteAccessKey');
    }
    /**
     * Grants permission to delete the specified AWS account alias
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteAccountAlias.html
     */
    toDeleteAccountAlias() {
        return this.to('DeleteAccountAlias');
    }
    /**
     * Grants permission to delete the password policy for the AWS account
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteAccountPasswordPolicy.html
     */
    toDeleteAccountPasswordPolicy() {
        return this.to('DeleteAccountPasswordPolicy');
    }
    /**
     * Grants permission to delete the specified IAM group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteGroup.html
     */
    toDeleteGroup() {
        return this.to('DeleteGroup');
    }
    /**
     * Grants permission to delete the specified inline policy from its group
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteGroupPolicy.html
     */
    toDeleteGroupPolicy() {
        return this.to('DeleteGroupPolicy');
    }
    /**
     * Grants permission to delete the specified instance profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteInstanceProfile.html
     */
    toDeleteInstanceProfile() {
        return this.to('DeleteInstanceProfile');
    }
    /**
     * Grants permission to delete the password for the specified IAM user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteLoginProfile.html
     */
    toDeleteLoginProfile() {
        return this.to('DeleteLoginProfile');
    }
    /**
     * Grants permission to delete an OpenID Connect identity provider (IdP) resource object in IAM
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteOpenIDConnectProvider.html
     */
    toDeleteOpenIDConnectProvider() {
        return this.to('DeleteOpenIDConnectProvider');
    }
    /**
     * Grants permission to delete the specified managed policy and remove it from any IAM entities (users, groups, or roles) to which it is attached
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeletePolicy.html
     */
    toDeletePolicy() {
        return this.to('DeletePolicy');
    }
    /**
     * Grants permission to delete a version from the specified managed policy
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeletePolicyVersion.html
     */
    toDeletePolicyVersion() {
        return this.to('DeletePolicyVersion');
    }
    /**
     * Grants permission to delete the specified role
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteRole.html
     */
    toDeleteRole() {
        return this.to('DeleteRole');
    }
    /**
     * Grants permission to remove the permissions boundary from a role
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteRolePermissionsBoundary.html
     */
    toDeleteRolePermissionsBoundary() {
        return this.to('DeleteRolePermissionsBoundary');
    }
    /**
     * Grants permission to delete the specified inline policy from the specified role
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteRolePolicy.html
     */
    toDeleteRolePolicy() {
        return this.to('DeleteRolePolicy');
    }
    /**
     * Grants permission to delete a SAML provider resource in IAM
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteSAMLProvider.html
     */
    toDeleteSAMLProvider() {
        return this.to('DeleteSAMLProvider');
    }
    /**
     * Grants permission to delete the specified SSH public key
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteSSHPublicKey.html
     */
    toDeleteSSHPublicKey() {
        return this.to('DeleteSSHPublicKey');
    }
    /**
     * Grants permission to delete the specified server certificate
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteServerCertificate.html
     */
    toDeleteServerCertificate() {
        return this.to('DeleteServerCertificate');
    }
    /**
     * Grants permission to delete an IAM role that is linked to a specific AWS service, if the service is no longer using it
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteServiceLinkedRole.html
     */
    toDeleteServiceLinkedRole() {
        return this.to('DeleteServiceLinkedRole');
    }
    /**
     * Grants permission to delete the specified service-specific credential for an IAM user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteServiceSpecificCredential.html
     */
    toDeleteServiceSpecificCredential() {
        return this.to('DeleteServiceSpecificCredential');
    }
    /**
     * Grants permission to delete a signing certificate that is associated with the specified IAM user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteSigningCertificate.html
     */
    toDeleteSigningCertificate() {
        return this.to('DeleteSigningCertificate');
    }
    /**
     * Grants permission to delete the specified IAM user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteUser.html
     */
    toDeleteUser() {
        return this.to('DeleteUser');
    }
    /**
     * Grants permission to remove the permissions boundary from the specified IAM user
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteUserPermissionsBoundary.html
     */
    toDeleteUserPermissionsBoundary() {
        return this.to('DeleteUserPermissionsBoundary');
    }
    /**
     * Grants permission to delete the specified inline policy from an IAM user
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteUserPolicy.html
     */
    toDeleteUserPolicy() {
        return this.to('DeleteUserPolicy');
    }
    /**
     * Grants permission to delete a virtual MFA device
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteVirtualMFADevice.html
     */
    toDeleteVirtualMFADevice() {
        return this.to('DeleteVirtualMFADevice');
    }
    /**
     * Grants permission to detach a managed policy from the specified IAM group
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPolicyARN()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DetachGroupPolicy.html
     */
    toDetachGroupPolicy() {
        return this.to('DetachGroupPolicy');
    }
    /**
     * Grants permission to detach a managed policy from the specified role
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPolicyARN()
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DetachRolePolicy.html
     */
    toDetachRolePolicy() {
        return this.to('DetachRolePolicy');
    }
    /**
     * Grants permission to detach a managed policy from the specified IAM user
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPolicyARN()
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DetachUserPolicy.html
     */
    toDetachUserPolicy() {
        return this.to('DetachUserPolicy');
    }
    /**
     * Grants permission to enable an MFA device and associate it with the specified IAM user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_EnableMFADevice.html
     */
    toEnableMFADevice() {
        return this.to('EnableMFADevice');
    }
    /**
     * Grants permission to generate a credential report for the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GenerateCredentialReport.html
     */
    toGenerateCredentialReport() {
        return this.to('GenerateCredentialReport');
    }
    /**
     * Grants permission to generate an access report for an AWS Organizations entity
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifOrganizationsPolicyId()
     *
     * Dependent actions:
     * - organizations:DescribePolicy
     * - organizations:ListChildren
     * - organizations:ListParents
     * - organizations:ListPoliciesForTarget
     * - organizations:ListRoots
     * - organizations:ListTargetsForPolicy
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GenerateOrganizationsAccessReport.html
     */
    toGenerateOrganizationsAccessReport() {
        return this.to('GenerateOrganizationsAccessReport');
    }
    /**
     * Grants permission to generate a service last accessed data report for an IAM resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GenerateServiceLastAccessedDetails.html
     */
    toGenerateServiceLastAccessedDetails() {
        return this.to('GenerateServiceLastAccessedDetails');
    }
    /**
     * Grants permission to retrieve information about when the specified access key was last used
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetAccessKeyLastUsed.html
     */
    toGetAccessKeyLastUsed() {
        return this.to('GetAccessKeyLastUsed');
    }
    /**
     * Grants permission to retrieve information about all IAM users, groups, roles, and policies in your AWS account, including their relationships to one another
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetAccountAuthorizationDetails.html
     */
    toGetAccountAuthorizationDetails() {
        return this.to('GetAccountAuthorizationDetails');
    }
    /**
     * Grants permission to retrieve the password policy for the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetAccountPasswordPolicy.html
     */
    toGetAccountPasswordPolicy() {
        return this.to('GetAccountPasswordPolicy');
    }
    /**
     * Grants permission to retrieve information about IAM entity usage and IAM quotas in the AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetAccountSummary.html
     */
    toGetAccountSummary() {
        return this.to('GetAccountSummary');
    }
    /**
     * Grants permission to retrieve a list of all of the context keys that are referenced in the specified policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetContextKeysForCustomPolicy.html
     */
    toGetContextKeysForCustomPolicy() {
        return this.to('GetContextKeysForCustomPolicy');
    }
    /**
     * Grants permission to retrieve a list of all context keys that are referenced in all IAM policies that are attached to the specified IAM identity (user, group, or role)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetContextKeysForPrincipalPolicy.html
     */
    toGetContextKeysForPrincipalPolicy() {
        return this.to('GetContextKeysForPrincipalPolicy');
    }
    /**
     * Grants permission to retrieve a credential report for the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetCredentialReport.html
     */
    toGetCredentialReport() {
        return this.to('GetCredentialReport');
    }
    /**
     * Grants permission to retrieve a list of IAM users in the specified IAM group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetGroup.html
     */
    toGetGroup() {
        return this.to('GetGroup');
    }
    /**
     * Grants permission to retrieve an inline policy document that is embedded in the specified IAM group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetGroupPolicy.html
     */
    toGetGroupPolicy() {
        return this.to('GetGroupPolicy');
    }
    /**
     * Grants permission to retrieve information about the specified instance profile, including the instance profile's path, GUID, ARN, and role
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetInstanceProfile.html
     */
    toGetInstanceProfile() {
        return this.to('GetInstanceProfile');
    }
    /**
     * Grants permission to retrieve the user name and password creation date for the specified IAM user
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetLoginProfile.html
     */
    toGetLoginProfile() {
        return this.to('GetLoginProfile');
    }
    /**
     * Grants permission to retrieve information about the specified OpenID Connect (OIDC) provider resource in IAM
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetOpenIDConnectProvider.html
     */
    toGetOpenIDConnectProvider() {
        return this.to('GetOpenIDConnectProvider');
    }
    /**
     * Grants permission to retrieve an AWS Organizations access report
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetOrganizationsAccessReport.html
     */
    toGetOrganizationsAccessReport() {
        return this.to('GetOrganizationsAccessReport');
    }
    /**
     * Grants permission to retrieve information about the specified managed policy, including the policy's default version and the total number of identities to which the policy is attached
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetPolicy.html
     */
    toGetPolicy() {
        return this.to('GetPolicy');
    }
    /**
     * Grants permission to retrieve information about a version of the specified managed policy, including the policy document
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetPolicyVersion.html
     */
    toGetPolicyVersion() {
        return this.to('GetPolicyVersion');
    }
    /**
     * Grants permission to retrieve information about the specified role, including the role's path, GUID, ARN, and the role's trust policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetRole.html
     */
    toGetRole() {
        return this.to('GetRole');
    }
    /**
     * Grants permission to retrieve an inline policy document that is embedded with the specified IAM role
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetRolePolicy.html
     */
    toGetRolePolicy() {
        return this.to('GetRolePolicy');
    }
    /**
     * Grants permission to retrieve the SAML provider metadocument that was uploaded when the IAM SAML provider resource was created or updated
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetSAMLProvider.html
     */
    toGetSAMLProvider() {
        return this.to('GetSAMLProvider');
    }
    /**
     * Grants permission to retrieve the specified SSH public key, including metadata about the key
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetSSHPublicKey.html
     */
    toGetSSHPublicKey() {
        return this.to('GetSSHPublicKey');
    }
    /**
     * Grants permission to retrieve information about the specified server certificate stored in IAM
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetServerCertificate.html
     */
    toGetServerCertificate() {
        return this.to('GetServerCertificate');
    }
    /**
     * Grants permission to retrieve information about the service last accessed data report
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetServiceLastAccessedDetails.html
     */
    toGetServiceLastAccessedDetails() {
        return this.to('GetServiceLastAccessedDetails');
    }
    /**
     * Grants permission to retrieve information about the entities from the service last accessed data report
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetServiceLastAccessedDetailsWithEntities.html
     */
    toGetServiceLastAccessedDetailsWithEntities() {
        return this.to('GetServiceLastAccessedDetailsWithEntities');
    }
    /**
     * Grants permission to retrieve an IAM service-linked role deletion status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetServiceLinkedRoleDeletionStatus.html
     */
    toGetServiceLinkedRoleDeletionStatus() {
        return this.to('GetServiceLinkedRoleDeletionStatus');
    }
    /**
     * Grants permission to retrieve information about the specified IAM user, including the user's creation date, path, unique ID, and ARN
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetUser.html
     */
    toGetUser() {
        return this.to('GetUser');
    }
    /**
     * Grants permission to retrieve an inline policy document that is embedded in the specified IAM user
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetUserPolicy.html
     */
    toGetUserPolicy() {
        return this.to('GetUserPolicy');
    }
    /**
     * Grants permission to list information about the access key IDs that are associated with the specified IAM user
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListAccessKeys.html
     */
    toListAccessKeys() {
        return this.to('ListAccessKeys');
    }
    /**
     * Grants permission to list the account alias that is associated with the AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListAccountAliases.html
     */
    toListAccountAliases() {
        return this.to('ListAccountAliases');
    }
    /**
     * Grants permission to list all managed policies that are attached to the specified IAM group
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListAttachedGroupPolicies.html
     */
    toListAttachedGroupPolicies() {
        return this.to('ListAttachedGroupPolicies');
    }
    /**
     * Grants permission to list all managed policies that are attached to the specified IAM role
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListAttachedRolePolicies.html
     */
    toListAttachedRolePolicies() {
        return this.to('ListAttachedRolePolicies');
    }
    /**
     * Grants permission to list all managed policies that are attached to the specified IAM user
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListAttachedUserPolicies.html
     */
    toListAttachedUserPolicies() {
        return this.to('ListAttachedUserPolicies');
    }
    /**
     * Grants permission to list all IAM identities to which the specified managed policy is attached
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListEntitiesForPolicy.html
     */
    toListEntitiesForPolicy() {
        return this.to('ListEntitiesForPolicy');
    }
    /**
     * Grants permission to list the names of the inline policies that are embedded in the specified IAM group
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListGroupPolicies.html
     */
    toListGroupPolicies() {
        return this.to('ListGroupPolicies');
    }
    /**
     * Grants permission to list the IAM groups that have the specified path prefix
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListGroups.html
     */
    toListGroups() {
        return this.to('ListGroups');
    }
    /**
     * Grants permission to list the IAM groups that the specified IAM user belongs to
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListGroupsForUser.html
     */
    toListGroupsForUser() {
        return this.to('ListGroupsForUser');
    }
    /**
     * Grants permission to list the tags that are attached to the specified instance profile
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListInstanceProfileTags.html
     */
    toListInstanceProfileTags() {
        return this.to('ListInstanceProfileTags');
    }
    /**
     * Grants permission to list the instance profiles that have the specified path prefix
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListInstanceProfiles.html
     */
    toListInstanceProfiles() {
        return this.to('ListInstanceProfiles');
    }
    /**
     * Grants permission to list the instance profiles that have the specified associated IAM role
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListInstanceProfilesForRole.html
     */
    toListInstanceProfilesForRole() {
        return this.to('ListInstanceProfilesForRole');
    }
    /**
     * Grants permission to list the tags that are attached to the specified virtual mfa device
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListMFADeviceTags.html
     */
    toListMFADeviceTags() {
        return this.to('ListMFADeviceTags');
    }
    /**
     * Grants permission to list the MFA devices for an IAM user
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListMFADevices.html
     */
    toListMFADevices() {
        return this.to('ListMFADevices');
    }
    /**
     * Grants permission to list the tags that are attached to the specified OpenID Connect provider
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListOpenIDConnectProviderTags.html
     */
    toListOpenIDConnectProviderTags() {
        return this.to('ListOpenIDConnectProviderTags');
    }
    /**
     * Grants permission to list information about the IAM OpenID Connect (OIDC) provider resource objects that are defined in the AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListOpenIDConnectProviders.html
     */
    toListOpenIDConnectProviders() {
        return this.to('ListOpenIDConnectProviders');
    }
    /**
     * Grants permission to list all managed policies
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListPolicies.html
     */
    toListPolicies() {
        return this.to('ListPolicies');
    }
    /**
     * Grants permission to list information about the policies that grant an entity access to a specific service
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListPoliciesGrantingServiceAccess.html
     */
    toListPoliciesGrantingServiceAccess() {
        return this.to('ListPoliciesGrantingServiceAccess');
    }
    /**
     * Grants permission to list the tags that are attached to the specified managed policy
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListPolicyTags.html
     */
    toListPolicyTags() {
        return this.to('ListPolicyTags');
    }
    /**
     * Grants permission to list information about the versions of the specified managed policy, including the version that is currently set as the policy's default version
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListPolicyVersions.html
     */
    toListPolicyVersions() {
        return this.to('ListPolicyVersions');
    }
    /**
     * Grants permission to list the names of the inline policies that are embedded in the specified IAM role
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListRolePolicies.html
     */
    toListRolePolicies() {
        return this.to('ListRolePolicies');
    }
    /**
     * Grants permission to list the tags that are attached to the specified IAM role
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListRoleTags.html
     */
    toListRoleTags() {
        return this.to('ListRoleTags');
    }
    /**
     * Grants permission to list the IAM roles that have the specified path prefix
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListRoles.html
     */
    toListRoles() {
        return this.to('ListRoles');
    }
    /**
     * Grants permission to list the tags that are attached to the specified SAML provider
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListSAMLProviderTags.html
     */
    toListSAMLProviderTags() {
        return this.to('ListSAMLProviderTags');
    }
    /**
     * Grants permission to list the SAML provider resources in IAM
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListSAMLProviders.html
     */
    toListSAMLProviders() {
        return this.to('ListSAMLProviders');
    }
    /**
     * Grants permission to list information about the SSH public keys that are associated with the specified IAM user
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListSSHPublicKeys.html
     */
    toListSSHPublicKeys() {
        return this.to('ListSSHPublicKeys');
    }
    /**
     * Grants permission to list the tags that are attached to the specified server certificate
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListServerCertificateTags.html
     */
    toListServerCertificateTags() {
        return this.to('ListServerCertificateTags');
    }
    /**
     * Grants permission to list the server certificates that have the specified path prefix
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListServerCertificates.html
     */
    toListServerCertificates() {
        return this.to('ListServerCertificates');
    }
    /**
     * Grants permission to list the service-specific credentials that are associated with the specified IAM user
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListServiceSpecificCredentials.html
     */
    toListServiceSpecificCredentials() {
        return this.to('ListServiceSpecificCredentials');
    }
    /**
     * Grants permission to list information about the signing certificates that are associated with the specified IAM user
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListSigningCertificates.html
     */
    toListSigningCertificates() {
        return this.to('ListSigningCertificates');
    }
    /**
     * Grants permission to list the names of the inline policies that are embedded in the specified IAM user
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListUserPolicies.html
     */
    toListUserPolicies() {
        return this.to('ListUserPolicies');
    }
    /**
     * Grants permission to list the tags that are attached to the specified IAM user
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListUserTags.html
     */
    toListUserTags() {
        return this.to('ListUserTags');
    }
    /**
     * Grants permission to list the IAM users that have the specified path prefix
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListUsers.html
     */
    toListUsers() {
        return this.to('ListUsers');
    }
    /**
     * Grants permission to list virtual MFA devices by assignment status
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListVirtualMFADevices.html
     */
    toListVirtualMFADevices() {
        return this.to('ListVirtualMFADevices');
    }
    /**
     * Grants permission to pass a role to a service
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAssociatedResourceArn()
     * - .ifPassedToService()
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html
     */
    toPassRole() {
        return this.to('PassRole');
    }
    /**
     * Grants permission to create or update an inline policy document that is embedded in the specified IAM group
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutGroupPolicy.html
     */
    toPutGroupPolicy() {
        return this.to('PutGroupPolicy');
    }
    /**
     * Grants permission to set a managed policy as a permissions boundary for a role
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutRolePermissionsBoundary.html
     */
    toPutRolePermissionsBoundary() {
        return this.to('PutRolePermissionsBoundary');
    }
    /**
     * Grants permission to create or update an inline policy document that is embedded in the specified IAM role
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutRolePolicy.html
     */
    toPutRolePolicy() {
        return this.to('PutRolePolicy');
    }
    /**
     * Grants permission to set a managed policy as a permissions boundary for an IAM user
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutUserPermissionsBoundary.html
     */
    toPutUserPermissionsBoundary() {
        return this.to('PutUserPermissionsBoundary');
    }
    /**
     * Grants permission to create or update an inline policy document that is embedded in the specified IAM user
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutUserPolicy.html
     */
    toPutUserPolicy() {
        return this.to('PutUserPolicy');
    }
    /**
     * Grants permission to remove the client ID (audience) from the list of client IDs in the specified IAM OpenID Connect (OIDC) provider resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_RemoveClientIDFromOpenIDConnectProvider.html
     */
    toRemoveClientIDFromOpenIDConnectProvider() {
        return this.to('RemoveClientIDFromOpenIDConnectProvider');
    }
    /**
     * Grants permission to remove an IAM role from the specified EC2 instance profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_RemoveRoleFromInstanceProfile.html
     */
    toRemoveRoleFromInstanceProfile() {
        return this.to('RemoveRoleFromInstanceProfile');
    }
    /**
     * Grants permission to remove an IAM user from the specified group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_RemoveUserFromGroup.html
     */
    toRemoveUserFromGroup() {
        return this.to('RemoveUserFromGroup');
    }
    /**
     * Grants permission to reset the password for an existing service-specific credential for an IAM user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ResetServiceSpecificCredential.html
     */
    toResetServiceSpecificCredential() {
        return this.to('ResetServiceSpecificCredential');
    }
    /**
     * Grants permission to synchronize the specified MFA device with its IAM entity (user or role)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ResyncMFADevice.html
     */
    toResyncMFADevice() {
        return this.to('ResyncMFADevice');
    }
    /**
     * Grants permission to set the version of the specified policy as the policy's default version
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_SetDefaultPolicyVersion.html
     */
    toSetDefaultPolicyVersion() {
        return this.to('SetDefaultPolicyVersion');
    }
    /**
     * Grants permission to set the STS global endpoint token version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_SetSecurityTokenServicePreferences.html
     */
    toSetSecurityTokenServicePreferences() {
        return this.to('SetSecurityTokenServicePreferences');
    }
    /**
     * Grants permission to simulate whether an identity-based policy or resource-based policy provides permissions for specific API operations and resources
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_SimulateCustomPolicy.html
     */
    toSimulateCustomPolicy() {
        return this.to('SimulateCustomPolicy');
    }
    /**
     * Grants permission to simulate whether an identity-based policy that is attached to a specified IAM entity (user or role) provides permissions for specific API operations and resources
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_SimulatePrincipalPolicy.html
     */
    toSimulatePrincipalPolicy() {
        return this.to('SimulatePrincipalPolicy');
    }
    /**
     * Grants permission to add tags to an instance profile
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_TagInstanceProfile.html
     */
    toTagInstanceProfile() {
        return this.to('TagInstanceProfile');
    }
    /**
     * Grants permission to add tags to a virtual mfa device
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_TagMFADevice.html
     */
    toTagMFADevice() {
        return this.to('TagMFADevice');
    }
    /**
     * Grants permission to add tags to an OpenID Connect provider
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_TagOpenIDConnectProvider.html
     */
    toTagOpenIDConnectProvider() {
        return this.to('TagOpenIDConnectProvider');
    }
    /**
     * Grants permission to add tags to a managed policy
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_TagPolicy.html
     */
    toTagPolicy() {
        return this.to('TagPolicy');
    }
    /**
     * Grants permission to add tags to an IAM role
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_TagRole.html
     */
    toTagRole() {
        return this.to('TagRole');
    }
    /**
     * Grants permission to add tags to a SAML Provider
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_TagSAMLProvider.html
     */
    toTagSAMLProvider() {
        return this.to('TagSAMLProvider');
    }
    /**
     * Grants permission to add tags to a server certificate
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_TagServerCertificate.html
     */
    toTagServerCertificate() {
        return this.to('TagServerCertificate');
    }
    /**
     * Grants permission to add tags to an IAM user
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_TagUser.html
     */
    toTagUser() {
        return this.to('TagUser');
    }
    /**
     * Grants permission to remove the specified tags from the instance profile
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UntagInstanceProfile.html
     */
    toUntagInstanceProfile() {
        return this.to('UntagInstanceProfile');
    }
    /**
     * Grants permission to remove the specified tags from the virtual mfa device
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UntagMFADevice.html
     */
    toUntagMFADevice() {
        return this.to('UntagMFADevice');
    }
    /**
     * Grants permission to remove the specified tags from the OpenID Connect provider
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UntagOpenIDConnectProvider.html
     */
    toUntagOpenIDConnectProvider() {
        return this.to('UntagOpenIDConnectProvider');
    }
    /**
     * Grants permission to remove the specified tags from the managed policy
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UntagPolicy.html
     */
    toUntagPolicy() {
        return this.to('UntagPolicy');
    }
    /**
     * Grants permission to remove the specified tags from the role
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UntagRole.html
     */
    toUntagRole() {
        return this.to('UntagRole');
    }
    /**
     * Grants permission to remove the specified tags from the SAML Provider
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UntagSAMLProvider.html
     */
    toUntagSAMLProvider() {
        return this.to('UntagSAMLProvider');
    }
    /**
     * Grants permission to remove the specified tags from the server certificate
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UntagServerCertificate.html
     */
    toUntagServerCertificate() {
        return this.to('UntagServerCertificate');
    }
    /**
     * Grants permission to remove the specified tags from the user
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UntagUser.html
     */
    toUntagUser() {
        return this.to('UntagUser');
    }
    /**
     * Grants permission to update the status of the specified access key as Active or Inactive
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateAccessKey.html
     */
    toUpdateAccessKey() {
        return this.to('UpdateAccessKey');
    }
    /**
     * Grants permission to update the password policy settings for the AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateAccountPasswordPolicy.html
     */
    toUpdateAccountPasswordPolicy() {
        return this.to('UpdateAccountPasswordPolicy');
    }
    /**
     * Grants permission to update the policy that grants an IAM entity permission to assume a role
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateAssumeRolePolicy.html
     */
    toUpdateAssumeRolePolicy() {
        return this.to('UpdateAssumeRolePolicy');
    }
    /**
     * Grants permission to update the name or path of the specified IAM group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateGroup.html
     */
    toUpdateGroup() {
        return this.to('UpdateGroup');
    }
    /**
     * Grants permission to change the password for the specified IAM user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateLoginProfile.html
     */
    toUpdateLoginProfile() {
        return this.to('UpdateLoginProfile');
    }
    /**
     * Grants permission to update the entire list of server certificate thumbprints that are associated with an OpenID Connect (OIDC) provider resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateOpenIDConnectProviderThumbprint.html
     */
    toUpdateOpenIDConnectProviderThumbprint() {
        return this.to('UpdateOpenIDConnectProviderThumbprint');
    }
    /**
     * Grants permission to update the description or maximum session duration setting of a role
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateRole.html
     */
    toUpdateRole() {
        return this.to('UpdateRole');
    }
    /**
     * Grants permission to update only the description of a role
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateRoleDescription.html
     */
    toUpdateRoleDescription() {
        return this.to('UpdateRoleDescription');
    }
    /**
     * Grants permission to update the metadata document for an existing SAML provider resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateSAMLProvider.html
     */
    toUpdateSAMLProvider() {
        return this.to('UpdateSAMLProvider');
    }
    /**
     * Grants permission to update the status of an IAM user's SSH public key to active or inactive
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateSSHPublicKey.html
     */
    toUpdateSSHPublicKey() {
        return this.to('UpdateSSHPublicKey');
    }
    /**
     * Grants permission to update the name or the path of the specified server certificate stored in IAM
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateServerCertificate.html
     */
    toUpdateServerCertificate() {
        return this.to('UpdateServerCertificate');
    }
    /**
     * Grants permission to update the status of a service-specific credential to active or inactive for an IAM user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateServiceSpecificCredential.html
     */
    toUpdateServiceSpecificCredential() {
        return this.to('UpdateServiceSpecificCredential');
    }
    /**
     * Grants permission to update the status of the specified user signing certificate to active or disabled
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateSigningCertificate.html
     */
    toUpdateSigningCertificate() {
        return this.to('UpdateSigningCertificate');
    }
    /**
     * Grants permission to update the name or the path of the specified IAM user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateUser.html
     */
    toUpdateUser() {
        return this.to('UpdateUser');
    }
    /**
     * Grants permission to upload an SSH public key and associate it with the specified IAM user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UploadSSHPublicKey.html
     */
    toUploadSSHPublicKey() {
        return this.to('UploadSSHPublicKey');
    }
    /**
     * Grants permission to upload a server certificate entity for the AWS account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UploadServerCertificate.html
     */
    toUploadServerCertificate() {
        return this.to('UploadServerCertificate');
    }
    /**
     * Grants permission to upload an X.509 signing certificate and associate it with the specified IAM user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UploadSigningCertificate.html
     */
    toUploadSigningCertificate() {
        return this.to('UploadSigningCertificate');
    }
    /**
     * Adds a resource of type access-report to the statement
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor-view-data-orgs.html
     *
     * @param entityPath - Identifier for the entityPath.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onAccessReport(entityPath, account, partition) {
        return this.on(`arn:${partition || 'aws'}:iam::${account || '*'}:access-report/${entityPath}`);
    }
    /**
     * Adds a resource of type assumed-role to the statement
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html
     *
     * @param roleName - Identifier for the roleName.
     * @param roleSessionName - Identifier for the roleSessionName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onAssumedRole(roleName, roleSessionName, account, partition) {
        return this.on(`arn:${partition || 'aws'}:iam::${account || '*'}:assumed-role/${roleName}/${roleSessionName}`);
    }
    /**
     * Adds a resource of type federated-user to the statement
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html
     *
     * @param userName - Identifier for the userName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onFederatedUser(userName, account, partition) {
        return this.on(`arn:${partition || 'aws'}:iam::${account || '*'}:federated-user/${userName}`);
    }
    /**
     * Adds a resource of type group to the statement
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_groups.html
     *
     * @param groupNameWithPath - Identifier for the groupNameWithPath.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onGroup(groupNameWithPath, account, partition) {
        return this.on(`arn:${partition || 'aws'}:iam::${account || '*'}:group/${groupNameWithPath}`);
    }
    /**
     * Adds a resource of type instance-profile to the statement
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html
     *
     * @param instanceProfileNameWithPath - Identifier for the instanceProfileNameWithPath.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onInstanceProfile(instanceProfileNameWithPath, account, partition) {
        return this.on(`arn:${partition || 'aws'}:iam::${account || '*'}:instance-profile/${instanceProfileNameWithPath}`);
    }
    /**
     * Adds a resource of type mfa to the statement
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa.html
     *
     * @param mfaTokenIdWithPath - Identifier for the mfaTokenIdWithPath.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMfa(mfaTokenIdWithPath, account, partition) {
        return this.on(`arn:${partition || 'aws'}:iam::${account || '*'}:mfa/${mfaTokenIdWithPath}`);
    }
    /**
     * Adds a resource of type oidc-provider to the statement
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_create_oidc.html
     *
     * @param oidcProviderName - Identifier for the oidcProviderName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onOidcProvider(oidcProviderName, account, partition) {
        return this.on(`arn:${partition || 'aws'}:iam::${account || '*'}:oidc-provider/${oidcProviderName}`);
    }
    /**
     * Adds a resource of type policy to the statement
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html
     *
     * @param policyNameWithPath - Identifier for the policyNameWithPath.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPolicy(policyNameWithPath, account, partition) {
        return this.on(`arn:${partition || 'aws'}:iam::${account || '*'}:policy/${policyNameWithPath}`);
    }
    /**
     * Adds a resource of type role to the statement
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html
     *
     * @param roleNameWithPath - Identifier for the roleNameWithPath.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onRole(roleNameWithPath, account, partition) {
        return this.on(`arn:${partition || 'aws'}:iam::${account || '*'}:role/${roleNameWithPath}`);
    }
    /**
     * Adds a resource of type saml-provider to the statement
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html
     *
     * @param samlProviderName - Identifier for the samlProviderName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSamlProvider(samlProviderName, account, partition) {
        return this.on(`arn:${partition || 'aws'}:iam::${account || '*'}:saml-provider/${samlProviderName}`);
    }
    /**
     * Adds a resource of type server-certificate to the statement
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html
     *
     * @param certificateNameWithPath - Identifier for the certificateNameWithPath.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onServerCertificate(certificateNameWithPath, account, partition) {
        return this.on(`arn:${partition || 'aws'}:iam::${account || '*'}:server-certificate/${certificateNameWithPath}`);
    }
    /**
     * Adds a resource of type sms-mfa to the statement
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa_enable_sms.html
     *
     * @param mfaTokenIdWithPath - Identifier for the mfaTokenIdWithPath.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onSmsMfa(mfaTokenIdWithPath, account, partition) {
        return this.on(`arn:${partition || 'aws'}:iam::${account || '*'}:sms-mfa/${mfaTokenIdWithPath}`);
    }
    /**
     * Adds a resource of type user to the statement
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users.html
     *
     * @param userNameWithPath - Identifier for the userNameWithPath.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onUser(userNameWithPath, account, partition) {
        return this.on(`arn:${partition || 'aws'}:iam::${account || '*'}:user/${userNameWithPath}`);
    }
    /**
     * Filters access by the AWS service to which this role is attached
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#ck_AWSServiceName
     *
     * Applies to actions:
     * - .toCreateServiceLinkedRole()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAWSServiceName(value, operator) {
        return this.if(`AWSServiceName`, value, operator || 'StringLike');
    }
    /**
     * Filters by the resource that the role will be used on behalf of
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#ck_AssociatedResourceArn
     *
     * Applies to actions:
     * - .toPassRole()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifAssociatedResourceArn(value, operator) {
        return this.if(`AssociatedResourceArn`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by the ID of an AWS Organizations policy
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#ck_OrganizationsPolicyId
     *
     * Applies to actions:
     * - .toGenerateOrganizationsAccessReport()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifOrganizationsPolicyId(value, operator) {
        return this.if(`OrganizationsPolicyId`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the AWS service to which this role is passed
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#ck_PassedToService
     *
     * Applies to actions:
     * - .toPassRole()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifPassedToService(value, operator) {
        return this.if(`PassedToService`, value, operator || 'StringLike');
    }
    /**
     * Filters access if the specified policy is set as the permissions boundary on the IAM entity (user or role)
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#ck_PermissionsBoundary
     *
     * Applies to actions:
     * - .toAttachRolePolicy()
     * - .toAttachUserPolicy()
     * - .toCreateRole()
     * - .toCreateUser()
     * - .toDeleteRolePermissionsBoundary()
     * - .toDeleteRolePolicy()
     * - .toDeleteUserPermissionsBoundary()
     * - .toDeleteUserPolicy()
     * - .toDetachRolePolicy()
     * - .toDetachUserPolicy()
     * - .toPutRolePermissionsBoundary()
     * - .toPutRolePolicy()
     * - .toPutUserPermissionsBoundary()
     * - .toPutUserPolicy()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifPermissionsBoundary(value, operator) {
        return this.if(`PermissionsBoundary`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the ARN of an IAM policy
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#ck_PolicyARN
     *
     * Applies to actions:
     * - .toAttachGroupPolicy()
     * - .toAttachRolePolicy()
     * - .toAttachUserPolicy()
     * - .toDetachGroupPolicy()
     * - .toDetachRolePolicy()
     * - .toDetachUserPolicy()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifPolicyARN(value, operator) {
        return this.if(`PolicyARN`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by the tags attached to an IAM entity (user or role)
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#ck_ResourceTag
     *
     * Applies to resource types:
     * - role
     * - user
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifResourceTag(tagKey, value, operator) {
        return this.if(`ResourceTag/${tagKey}`, value, operator || 'StringLike');
    }
}
exports.Iam = Iam;
_a = JSII_RTTI_SYMBOL_1;
Iam[_a] = { fqn: "iam-floyd.Iam", version: "0.351.0" };
//# sourceMappingURL=data:application/json;base64,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