import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [geo](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlocation.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Geo extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [geo](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlocation.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create an association between a geofence-collection and a tracker resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_AssociateTrackerConsumer.html
     */
    toAssociateTrackerConsumer(): this;
    /**
     * Grants permission to delete a batch of device position histories from a tracker resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_BatchDeleteDevicePositionHistory.html
     */
    toBatchDeleteDevicePositionHistory(): this;
    /**
     * Grants permission to delete a batch of geofences from a geofence collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_BatchDeleteGeofence.html
     */
    toBatchDeleteGeofence(): this;
    /**
     * Grants permission to evaluate device positions against the position of geofences in a given geofence collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_BatchEvaluateGeofences.html
     */
    toBatchEvaluateGeofences(): this;
    /**
     * Grants permission to send a batch request to retrieve device positions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_BatchGetDevicePosition.html
     */
    toBatchGetDevicePosition(): this;
    /**
     * Grants permission to send a batch request for adding geofences into a given geofence collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_BatchPutGeofence.html
     */
    toBatchPutGeofence(): this;
    /**
     * Grants permission to upload a position update for one or more devices to a tracker resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_BatchUpdateDevicePosition.html
     */
    toBatchUpdateDevicePosition(): this;
    /**
     * Grants permission to calculate routes using a given route calculator resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_CalculateRoute.html
     */
    toCalculateRoute(): this;
    /**
     * Grants permission to calculate a route matrix using a given route calculator resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_CalculateRouteMatrix.html
     */
    toCalculateRouteMatrix(): this;
    /**
     * Grants permission to create a geofence-collection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_CreateGeofenceCollection.html
     */
    toCreateGeofenceCollection(): this;
    /**
     * Grants permission to create a map resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_CreateMap.html
     */
    toCreateMap(): this;
    /**
     * Grants permission to create a place index resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_CreatePlaceIndex.html
     */
    toCreatePlaceIndex(): this;
    /**
     * Grants permission to create a route calculator resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_CreateRouteCalculator.html
     */
    toCreateRouteCalculator(): this;
    /**
     * Grants permission to create a tracker resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_CreateTracker.html
     */
    toCreateTracker(): this;
    /**
     * Grants permission to delete a geofence-collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DeleteGeofenceCollection.html
     */
    toDeleteGeofenceCollection(): this;
    /**
     * Grants permission to delete a map resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DeleteMap.html
     */
    toDeleteMap(): this;
    /**
     * Grants permission to delete a place index resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DeletePlaceIndex.html
     */
    toDeletePlaceIndex(): this;
    /**
     * Grants permission to delete a route calculator resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DeleteRouteCalculator.html
     */
    toDeleteRouteCalculator(): this;
    /**
     * Grants permission to delete a tracker resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DeleteTracker.html
     */
    toDeleteTracker(): this;
    /**
     * Grants permission to retrieve geofence collection details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DescribeGeofenceCollection.html
     */
    toDescribeGeofenceCollection(): this;
    /**
     * Grants permission to retrieve map resource details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DescribeMap.html
     */
    toDescribeMap(): this;
    /**
     * Grants permission to retrieve place-index resource details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DescribePlaceIndex.html
     */
    toDescribePlaceIndex(): this;
    /**
     * Grants permission to retrieve route calculator resource details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DescribeRouteCalculator.html
     */
    toDescribeRouteCalculator(): this;
    /**
     * Grants permission to retrieve a tracker resource details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DescribeTracker.html
     */
    toDescribeTracker(): this;
    /**
     * Grants permission to remove the association between a tracker resource and a geofence-collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_DisassociateTrackerConsumer.html
     */
    toDisassociateTrackerConsumer(): this;
    /**
     * Grants permission to retrieve the latest device position
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_GetDevicePosition.html
     */
    toGetDevicePosition(): this;
    /**
     * Grants permission to retrieve the device position history
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_GetDevicePositionHistory.html
     */
    toGetDevicePositionHistory(): this;
    /**
     * Grants permission to retrieve the geofence details from a geofence-collection
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_GetGeofence.html
     */
    toGetGeofence(): this;
    /**
     * Grants permission to retrieve the glyph file for a map resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_GetMapGlyphs.html
     */
    toGetMapGlyphs(): this;
    /**
     * Grants permission to retrieve the sprite file for a map resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_GetMapSprites.html
     */
    toGetMapSprites(): this;
    /**
     * Grants permission to retrieve the map style descriptor from a map resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_GetMapStyleDescriptor.html
     */
    toGetMapStyleDescriptor(): this;
    /**
     * Grants permission to retrieve the map tile from the map resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_GetMapTile.html
     */
    toGetMapTile(): this;
    /**
     * Grants permission to retrieve a list of devices and their latest positions from the given tracker resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListDevicePositions.html
     */
    toListDevicePositions(): this;
    /**
     * Grants permission to lists geofence-collections
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListGeofenceCollections.html
     */
    toListGeofenceCollections(): this;
    /**
     * Grants permission to list geofences stored in a given geofence collection
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListGeofences.html
     */
    toListGeofences(): this;
    /**
     * Grants permission to list map resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListMaps.html
     */
    toListMaps(): this;
    /**
     * Grants permission to return a list of place index resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListPlaceIndexes.html
     */
    toListPlaceIndexes(): this;
    /**
     * Grants permission to return a list of route calculator resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListRouteCalculators.html
     */
    toListRouteCalculators(): this;
    /**
     * Grants permission to list the tags (metadata) which you have assigned to the resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to retrieve a list of geofence collections currently associated to the given tracker resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListTrackerConsumers.html
     */
    toListTrackerConsumers(): this;
    /**
     * Grants permission to return a list of tracker resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_ListTrackers.html
     */
    toListTrackers(): this;
    /**
     * Grants permission to add a new geofence or update an existing geofence to a given geofence-collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_PutGeofence.html
     */
    toPutGeofence(): this;
    /**
     * Grants permission to reverse geocodes a given coordinate
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_SearchPlaceIndexForPosition.html
     */
    toSearchPlaceIndexForPosition(): this;
    /**
     * Grants permission to generate suggestions for addresses and points of interest based on partial or misspelled free-form text
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_SearchPlaceIndexForSuggestions.html
     */
    toSearchPlaceIndexForSuggestions(): this;
    /**
     * Grants permission to geocode free-form text, such as an address, name, city or region
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_SearchPlaceIndexForText.html
     */
    toSearchPlaceIndexForText(): this;
    /**
     * Grants permission to adds to or modifies the tags of the given resource. Tags are metadata which can be used to manage a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove the given tags (metadata) from the resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a geofence collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_UpdateGeofenceCollection.html
     */
    toUpdateGeofenceCollection(): this;
    /**
     * Grants permission to update a map resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_UpdateMap.html
     */
    toUpdateMap(): this;
    /**
     * Grants permission to update a place index resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_UpdatePlaceIndex.html
     */
    toUpdatePlaceIndex(): this;
    /**
     * Grants permission to update a route calculator resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_UpdateRouteCalculator.html
     */
    toUpdateRouteCalculator(): this;
    /**
     * Grants permission to update a tracker resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/API_UpdateTracker.html
     */
    toUpdateTracker(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type geofence-collection to the statement
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/overview.html#geofence-overview
     *
     * @param geofenceCollectionName - Identifier for the geofenceCollectionName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onGeofenceCollection(geofenceCollectionName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type map to the statement
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/overview.html#map-overview
     *
     * @param mapName - Identifier for the mapName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMap(mapName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type place-index to the statement
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/overview.html#places-overview
     *
     * @param indexName - Identifier for the indexName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPlaceIndex(indexName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type route-calculator to the statement
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/overview.html#routes-overview
     *
     * @param calculatorName - Identifier for the calculatorName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRouteCalculator(calculatorName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type tracker to the statement
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/overview.html#tracking-overview
     *
     * @param trackerName - Identifier for the trackerName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTracker(trackerName: string, account?: string, region?: string, partition?: string): this;
}
