import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [panorama](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspanorama.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Panorama extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [panorama](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspanorama.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create an AWS Panorama application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateApp.html
     */
    toCreateApp(): this;
    /**
     * Grants permission to deploy an AWS Panorama application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateAppDeployment.html
     */
    toCreateAppDeployment(): this;
    /**
     * Grants permission to create a version of an AWS Panorama application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateAppVersion.html
     */
    toCreateAppVersion(): this;
    /**
     * Grants permission to create an AWS Panorama Application Instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateApplicationInstance.html
     */
    toCreateApplicationInstance(): this;
    /**
     * Grants permission to create an AWS Panorama datasource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateDataSource.html
     */
    toCreateDataSource(): this;
    /**
     * Grants permission to configure a deployment for an AWS Panorama application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateDeploymentConfiguration.html
     */
    toCreateDeploymentConfiguration(): this;
    /**
     * Grants permission to generate a list of cameras on the same network as an AWS Panorama Appliance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateInputList.html
     */
    toCreateInputs(): this;
    /**
     * Grants permission to create a job for an AWS Panorama Appliance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateJobForDevices.html
     */
    toCreateJobForDevices(): this;
    /**
     * Grants permission to import a machine learning model into AWS Panorama
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateModel.html
     */
    toCreateModel(): this;
    /**
     * Grants permission to create an AWS Panorama Node
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateNodeFromTemplateJob.html
     */
    toCreateNodeFromTemplateJob(): this;
    /**
     * Grants permission to create an AWS Panorama Package
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreatePackage.html
     */
    toCreatePackage(): this;
    /**
     * Grants permission to create an AWS Panorama Package
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreatePackageImportJob.html
     */
    toCreatePackageImportJob(): this;
    /**
     * Grants permission to generate a list of streams available to an AWS Panorama Appliance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateStreamsList.html
     */
    toCreateStreams(): this;
    /**
     * Grants permission to delete an AWS Panorama application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DeleteApp.html
     */
    toDeleteApp(): this;
    /**
     * Grants permission to delete a version of an AWS Panorama application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DeleteAppVersion.html
     */
    toDeleteAppVersion(): this;
    /**
     * Grants permission to delete an AWS Panorama datasource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DeleteDataSource.html
     */
    toDeleteDataSource(): this;
    /**
     * Grants permission to deregister an AWS Panorama Appliance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DeleteDevice.html
     */
    toDeleteDevice(): this;
    /**
     * Grants permission to delete a machine learning model from AWS Panorama
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DeleteModel.html
     */
    toDeleteModel(): this;
    /**
     * Grants permission to delete an AWS Panorama Package
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DeletePackage.html
     */
    toDeletePackage(): this;
    /**
     * Grants permission to deregister an AWS Panorama Package Version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DeregisterPackageVersion.html
     */
    toDeregisterPackageVersion(): this;
    /**
     * Grants permission to view details about an AWS Panorama application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeApp.html
     */
    toDescribeApp(): this;
    /**
     * Grants permission to view details about a deployment for an AWS Panorama application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeAppDeployment.html
     */
    toDescribeAppDeployment(): this;
    /**
     * Grants permission to view details about a version of an AWS Panorama application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeAppVersion.html
     */
    toDescribeAppVersion(): this;
    /**
     * Grants permission to view details about an AWS Panorama Application Instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeApplicationInstance.html
     */
    toDescribeApplicationInstance(): this;
    /**
     * Grants permission to view details about an AWS Panorama Application Instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeApplicationInstanceDetails.html
     */
    toDescribeApplicationInstanceDetails(): this;
    /**
     * Grants permission to view details about a datasource in AWS Panorama
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeDataSource.html
     */
    toDescribeDataSource(): this;
    /**
     * Grants permission to view details about an AWS Panorama Appliance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeDevice.html
     */
    toDescribeDevice(): this;
    /**
     * Grants permission to view job details for an AWS Panorama Appliance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeDeviceJob.html
     */
    toDescribeDeviceJob(): this;
    /**
     * Grants permission to view details about a machine learning model in AWS Panorama
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeModel.html
     */
    toDescribeModel(): this;
    /**
     * Grants permission to view details about an AWS Panorama Node
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeNode.html
     */
    toDescribeNode(): this;
    /**
     * Grants permission to view details about AWS Panorama Node
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeNodeFromTemplateJob.html
     */
    toDescribeNodeFromTemplateJob(): this;
    /**
     * Grants permission to view details about an AWS Panorama Package
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribePackage.html
     */
    toDescribePackage(): this;
    /**
     * Grants permission to view details about an AWS Panorama Package
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribePackageImportJob.html
     */
    toDescribePackageImportJob(): this;
    /**
     * Grants permission to view details about an AWS Panorama Package Version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribePackageVersion.html
     */
    toDescribePackageVersion(): this;
    /**
     * Grants permission to view details about a software version for the AWS Panorama Appliance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeSoftware.html
     */
    toDescribeSoftware(): this;
    /**
     * Grants permission to view details about a deployment configuration for an AWS Panorama application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_GetDeploymentConfiguration.html
     */
    toGetDeploymentConfiguration(): this;
    /**
     * Grants permission to retrieve a list of cameras generated with CreateInputs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_GetInputList.html
     */
    toGetInputs(): this;
    /**
     * Grants permission to retrieve a list of streams generated with CreateStreams
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_GetStreamsList.html
     */
    toGetStreams(): this;
    /**
     * Grants permission to generate a WebSocket endpoint for communication with AWS Panorama
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_GetWebSocketURL.html
     */
    toGetWebSocketURL(): this;
    /**
     * Grants permission to retrieve a list of deployments for an AWS Panorama application
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListAppDeploymentOperations.html
     */
    toListAppDeploymentOperations(): this;
    /**
     * Grants permission to retrieve a list of application versions in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListAppVersions.html
     */
    toListAppVersions(): this;
    /**
     * Grants permission to retrieve a list of application instance dependencies in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListApplicationInstanceDependencies.html
     */
    toListApplicationInstanceDependencies(): this;
    /**
     * Grants permission to retrieve a list of node instances of application instances in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListApplicationInstanceNodeInstances.html
     */
    toListApplicationInstanceNodeInstances(): this;
    /**
     * Grants permission to retrieve a list of application instances in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListApplicationInstances.html
     */
    toListApplicationInstances(): this;
    /**
     * Grants permission to retrieve a list of applications in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListApps.html
     */
    toListApps(): this;
    /**
     * Grants permission to retrieve a list of datasources in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListDataSources.html
     */
    toListDataSources(): this;
    /**
     * Grants permission to retrieve a list of deployment configurations in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListDeploymentConfigurations.html
     */
    toListDeploymentConfigurations(): this;
    /**
     * Grants permission to retrieve a list of appliances in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListDevices.html
     */
    toListDevices(): this;
    /**
     * Grants permission to retrieve a list of jobs for an AWS Panorama Appliance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListDevicesJobs.html
     */
    toListDevicesJobs(): this;
    /**
     * Grants permission to retrieve a list of models in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListModels.html
     */
    toListModels(): this;
    /**
     * Grants permission to retrieve a list of Nodes for an AWS Panorama Appliance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListNodeFromTemplateJobs.html
     */
    toListNodeFromTemplateJobs(): this;
    /**
     * Grants permission to retrieve a list of nodes in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListNodes.html
     */
    toListNodes(): this;
    /**
     * Grants permission to retrieve a list of packages in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListPackageImportJobs.html
     */
    toListPackageImportJobs(): this;
    /**
     * Grants permission to retrieve a list of packages in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListPackages.html
     */
    toListPackages(): this;
    /**
     * Grants permission to retrieve a list of tags for a resource in AWS Panorama
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to register an AWS Panorama Appliance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ProvisionDevice.html
     */
    toProvisionDevice(): this;
    /**
     * Grants permission to register an AWS Panorama Package Version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_RegisterPackageVersion.html
     */
    toRegisterPackageVersion(): this;
    /**
     * Grants permission to remove an AWS Panorama Application Instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_RemoveApplicationInstance.html
     */
    toRemoveApplicationInstance(): this;
    /**
     * Grants permission to add tags to a resource in AWS Panorama
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from a resource in AWS Panorama
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to modify an AWS Panorama application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_UpdateApp.html
     */
    toUpdateApp(): this;
    /**
     * Grants permission to modify the version-specific configuration of an AWS Panorama application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_UpdateAppConfiguration.html
     */
    toUpdateAppConfiguration(): this;
    /**
     * Grants permission to modify an AWS Panorama datasource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_UpdateDataSource.html
     */
    toUpdateDataSource(): this;
    /**
     * Grants permission to modify basic settings for an AWS Panorama Appliance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_UpdateDeviceMetadata.html
     */
    toUpdateDeviceMetadata(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type device to the statement
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/
     *
     * @param deviceId - Identifier for the deviceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDevice(deviceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type package to the statement
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/
     *
     * @param packageId - Identifier for the packageId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPackage(packageId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type applicationInstance to the statement
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/
     *
     * @param applicationInstanceId - Identifier for the applicationInstanceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onApplicationInstance(applicationInstanceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type dataSource to the statement
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/
     *
     * @param deviceId - Identifier for the deviceId.
     * @param dataSourceName - Identifier for the dataSourceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDataSource(deviceId: string, dataSourceName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type model to the statement
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/
     *
     * @param modelName - Identifier for the modelName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onModel(modelName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type app to the statement
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/
     *
     * @param appName - Identifier for the appName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onApp(appName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type appVersion to the statement
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/
     *
     * @param appName - Identifier for the appName.
     * @param appVersion - Identifier for the appVersion.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onAppVersion(appName: string, appVersion: string, account?: string, region?: string, partition?: string): this;
}
