"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmsVoiceV2 = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [sms-voice-v2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonpinpointsmsvoicev2.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class SmsVoiceV2 extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [sms-voice-v2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonpinpointsmsvoicev2.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'sms-voice';
        this.accessLevelList = {
            Write: [
                'AssociateOriginationIdentity',
                'CreateConfigurationSet',
                'CreateEventDestination',
                'CreateOptOutList',
                'CreatePool',
                'DeleteConfigurationSet',
                'DeleteDefaultMessageType',
                'DeleteDefaultSenderId',
                'DeleteEventDestination',
                'DeleteKeyword',
                'DeleteOptOutList',
                'DeleteOptedOutNumber',
                'DeletePool',
                'DeleteTextMessageSpendLimitOverride',
                'DeleteVoiceMessageSpendLimitOverride',
                'DisassociateOriginationIdentity',
                'PutKeyword',
                'PutOptedOutNumber',
                'ReleasePhoneNumber',
                'RequestPhoneNumber',
                'SendTextMessage',
                'SendVoiceMessage',
                'SetDefaultMessageType',
                'SetDefaultSenderId',
                'SetTextMessageSpendLimitOverride',
                'SetVoiceMessageSpendLimitOverride',
                'UpdateEventDestination',
                'UpdatePhoneNumber',
                'UpdatePool'
            ],
            Read: [
                'DescribeAccountAttributes',
                'DescribeAccountLimits',
                'DescribeConfigurationSets',
                'DescribeKeywords',
                'DescribeOptOutLists',
                'DescribeOptedOutNumbers',
                'DescribePhoneNumbers',
                'DescribePools',
                'DescribeSenderIds',
                'DescribeSpendLimits',
                'ListPoolOriginationIdentities',
                'ListTagsForResource'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to associate an origination phone number or sender ID to a pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_AssociateOriginationIdentity.html
     */
    toAssociateOriginationIdentity() {
        return this.to('AssociateOriginationIdentity');
    }
    /**
     * Grants permission to create a configuration set
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sms-voice:TagResource
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_CreateConfigurationSet.html
     */
    toCreateConfigurationSet() {
        return this.to('CreateConfigurationSet');
    }
    /**
     * Grants permission to create an event destination within a configuration set
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_CreateEventDestination.html
     */
    toCreateEventDestination() {
        return this.to('CreateEventDestination');
    }
    /**
     * Grants permission to create an opt-out list
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sms-voice:TagResource
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_CreateOptOutList.html
     */
    toCreateOptOutList() {
        return this.to('CreateOptOutList');
    }
    /**
     * Grants permission to create a pool
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sms-voice:TagResource
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_CreatePool.html
     */
    toCreatePool() {
        return this.to('CreatePool');
    }
    /**
     * Grants permission to delete a configuration set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DeleteConfigurationSet.html
     */
    toDeleteConfigurationSet() {
        return this.to('DeleteConfigurationSet');
    }
    /**
     * Grants permission to delete the default message type for a configuration set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DeleteDefaultMessageType.html
     */
    toDeleteDefaultMessageType() {
        return this.to('DeleteDefaultMessageType');
    }
    /**
     * Grants permission to delete the default sender ID for a configuration set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DeleteDefaultSenderId.html
     */
    toDeleteDefaultSenderId() {
        return this.to('DeleteDefaultSenderId');
    }
    /**
     * Grants permission to delete an event destination within a configuration set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DeleteEventDestination.html
     */
    toDeleteEventDestination() {
        return this.to('DeleteEventDestination');
    }
    /**
     * Grants permission to delete a keyword for a pool or origination phone number
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DeleteKeyword.html
     */
    toDeleteKeyword() {
        return this.to('DeleteKeyword');
    }
    /**
     * Grants permission to delete an opt-out list
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DeleteOptOutList.html
     */
    toDeleteOptOutList() {
        return this.to('DeleteOptOutList');
    }
    /**
     * Grants permission to delete a destination phone number from an opt-out list
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DeleteOptedOutNumber.html
     */
    toDeleteOptedOutNumber() {
        return this.to('DeleteOptedOutNumber');
    }
    /**
     * Grants permission to delete a pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DeletePool.html
     */
    toDeletePool() {
        return this.to('DeletePool');
    }
    /**
     * Grants permission to delete an override for your account's text messaging monthly spend limit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DeleteTextMessageSpendLimitOverride.html
     */
    toDeleteTextMessageSpendLimitOverride() {
        return this.to('DeleteTextMessageSpendLimitOverride');
    }
    /**
     * Grants permission to delete an override for your account's voice messaging monthly spend limit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DeleteVoiceMessageSpendLimitOverride.html
     */
    toDeleteVoiceMessageSpendLimitOverride() {
        return this.to('DeleteVoiceMessageSpendLimitOverride');
    }
    /**
     * Grants permission to describe the attributes of your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DescribeAccountAttributes.html
     */
    toDescribeAccountAttributes() {
        return this.to('DescribeAccountAttributes');
    }
    /**
     * Grants permission to describe the service quotas for your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DescribeAccountLimits.html
     */
    toDescribeAccountLimits() {
        return this.to('DescribeAccountLimits');
    }
    /**
     * Grants permission to describe the configuration sets in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DescribeConfigurationSets.html
     */
    toDescribeConfigurationSets() {
        return this.to('DescribeConfigurationSets');
    }
    /**
     * Grants permission to describe the keywords for a pool or origination phone number
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DescribeKeywords.html
     */
    toDescribeKeywords() {
        return this.to('DescribeKeywords');
    }
    /**
     * Grants permission to describe the opt-out lists in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DescribeOptOutLists.html
     */
    toDescribeOptOutLists() {
        return this.to('DescribeOptOutLists');
    }
    /**
     * Grants permission to describe the destination phone numbers in an opt-out list
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DescribeOptedOutNumbers.html
     */
    toDescribeOptedOutNumbers() {
        return this.to('DescribeOptedOutNumbers');
    }
    /**
     * Grants permission to describe the origination phone numbers in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DescribePhoneNumbers.html
     */
    toDescribePhoneNumbers() {
        return this.to('DescribePhoneNumbers');
    }
    /**
     * Grants permission to describe the pools in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DescribePools.html
     */
    toDescribePools() {
        return this.to('DescribePools');
    }
    /**
     * Grants permission to describe the sender IDs in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DescribeSenderIds.html
     */
    toDescribeSenderIds() {
        return this.to('DescribeSenderIds');
    }
    /**
     * Grants permission to describe the monthly spend limits for your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DescribeSpendLimits.html
     */
    toDescribeSpendLimits() {
        return this.to('DescribeSpendLimits');
    }
    /**
     * Grants permission to disassociate an origination phone number or sender ID from a pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DisassociateOriginationIdentity.html
     */
    toDisassociateOriginationIdentity() {
        return this.to('DisassociateOriginationIdentity');
    }
    /**
     * Grants permission to list all origination phone numbers and sender IDs associated to a pool
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_ListPoolOriginationIdentities.html
     */
    toListPoolOriginationIdentities() {
        return this.to('ListPoolOriginationIdentities');
    }
    /**
     * Grants permission to list the tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to create or update a keyword for a pool or origination phone number
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_PutKeyword.html
     */
    toPutKeyword() {
        return this.to('PutKeyword');
    }
    /**
     * Grants permission to put a destination phone number into an opt-out list
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_PutOptedOutNumber.html
     */
    toPutOptedOutNumber() {
        return this.to('PutOptedOutNumber');
    }
    /**
     * Grants permission to release an origination phone number
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_ReleasePhoneNumber.html
     */
    toReleasePhoneNumber() {
        return this.to('ReleasePhoneNumber');
    }
    /**
     * Grants permission to request an origination phone number
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sms-voice:AssociateOriginationIdentity
     * - sms-voice:TagResource
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_RequestPhoneNumber.html
     */
    toRequestPhoneNumber() {
        return this.to('RequestPhoneNumber');
    }
    /**
     * Grants permission to send a text message to a destination phone number
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_SendTextMessage.html
     */
    toSendTextMessage() {
        return this.to('SendTextMessage');
    }
    /**
     * Grants permission to send a voice message to a destination phone number
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_SendVoiceMessage.html
     */
    toSendVoiceMessage() {
        return this.to('SendVoiceMessage');
    }
    /**
     * Grants permission to set the default message type for a configuration set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_SetDefaultMessageType.html
     */
    toSetDefaultMessageType() {
        return this.to('SetDefaultMessageType');
    }
    /**
     * Grants permission to set the default sender ID for a configuration set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_SetDefaultSenderId.html
     */
    toSetDefaultSenderId() {
        return this.to('SetDefaultSenderId');
    }
    /**
     * Grants permission to set an override for your account's text messaging monthly spend limit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_SetTextMessageSpendLimitOverride.html
     */
    toSetTextMessageSpendLimitOverride() {
        return this.to('SetTextMessageSpendLimitOverride');
    }
    /**
     * Grants permission to set an override for your account's voice messaging monthly spend limit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_SetVoiceMessageSpendLimitOverride.html
     */
    toSetVoiceMessageSpendLimitOverride() {
        return this.to('SetVoiceMessageSpendLimitOverride');
    }
    /**
     * Grants permission to add tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove tags from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update an event destination within a configuration set
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_UpdateEventDestination.html
     */
    toUpdateEventDestination() {
        return this.to('UpdateEventDestination');
    }
    /**
     * Grants permission to update an origination phone number's configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_UpdatePhoneNumber.html
     */
    toUpdatePhoneNumber() {
        return this.to('UpdatePhoneNumber');
    }
    /**
     * Grants permission to update a pool's configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_UpdatePool.html
     */
    toUpdatePool() {
        return this.to('UpdatePool');
    }
    /**
     * Adds a resource of type ConfigurationSet to the statement
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_CreateConfigurationSet.html
     *
     * @param configurationSetName - Identifier for the configurationSetName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConfigurationSet(configurationSetName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:sms-voice:${region || '*'}:${account || '*'}:configuration-set/${configurationSetName}`);
    }
    /**
     * Adds a resource of type OptOutList to the statement
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_CreateOptOutList.html
     *
     * @param optOutListName - Identifier for the optOutListName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onOptOutList(optOutListName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:sms-voice:${region || '*'}:${account || '*'}:opt-out-list/${optOutListName}`);
    }
    /**
     * Adds a resource of type PhoneNumber to the statement
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_RequestPhoneNumber.html
     *
     * @param phoneNumberId - Identifier for the phoneNumberId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPhoneNumber(phoneNumberId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:sms-voice:${region || '*'}:${account || '*'}:phone-number/${phoneNumberId}`);
    }
    /**
     * Adds a resource of type Pool to the statement
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_CreatePool.html
     *
     * @param poolId - Identifier for the poolId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPool(poolId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:sms-voice:${region || '*'}:${account || '*'}:pool/${poolId}`);
    }
    /**
     * Adds a resource of type SenderId to the statement
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DescribeSenderIds.html
     *
     * @param senderId - Identifier for the senderId.
     * @param isoCountryCode - Identifier for the isoCountryCode.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSenderId(senderId, isoCountryCode, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:sms-voice:${region || '*'}:${account || '*'}:sender-id/${senderId}/${isoCountryCode}`);
    }
}
exports.SmsVoiceV2 = SmsVoiceV2;
_a = JSII_RTTI_SYMBOL_1;
SmsVoiceV2[_a] = { fqn: "iam-floyd.SmsVoiceV2", version: "0.351.0" };
//# sourceMappingURL=data:application/json;base64,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