import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [resiliencehub](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsresiliencehubservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Resiliencehub extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [resiliencehub](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsresiliencehubservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to add draft application version resource mappings
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - cloudformation:DescribeStacks
     * - cloudformation:ListStackResources
     * - resource-groups:GetGroup
     * - resource-groups:ListGroupResources
     * - servicecatalog:GetApplication
     * - servicecatalog:ListAssociatedResources
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_AddDraftAppVersionResourceMappings.html
     */
    toAddDraftAppVersionResourceMappings(): this;
    /**
     * Grants permission to create application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_CreateApp.html
     */
    toCreateApp(): this;
    /**
     * Grants permission to create recommendation template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - s3:CreateBucket
     * - s3:ListBucket
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_CreateRecommendationTemplate.html
     */
    toCreateRecommendationTemplate(): this;
    /**
     * Grants permission to create resiliency policy
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_CreateResiliencyPolicy.html
     */
    toCreateResiliencyPolicy(): this;
    /**
     * Grants permission to batch delete application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DeleteApp.html
     */
    toDeleteApp(): this;
    /**
     * Grants permission to batch delete application assessment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DeleteAppAssessment.html
     */
    toDeleteAppAssessment(): this;
    /**
     * Grants permission to batch delete recommendation template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DeleteRecommendationTemplate.html
     */
    toDeleteRecommendationTemplate(): this;
    /**
     * Grants permission to batch delete resiliency policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DeleteResiliencyPolicy.html
     */
    toDeleteResiliencyPolicy(): this;
    /**
     * Grants permission to describe application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeApp.html
     */
    toDescribeApp(): this;
    /**
     * Grants permission to describe application assessment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeAppAssessment.html
     */
    toDescribeAppAssessment(): this;
    /**
     * Grants permission to describe application resolution
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeAppVersionResourcesResolutionStatus.html
     */
    toDescribeAppVersionResourcesResolutionStatus(): this;
    /**
     * Grants permission to describe application version template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeAppVersionTemplate.html
     */
    toDescribeAppVersionTemplate(): this;
    /**
     * Grants permission to describe draft application version resources import status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeDraftAppVersionResourcesImportStatus.html
     */
    toDescribeDraftAppVersionResourcesImportStatus(): this;
    /**
     * Grants permission to describe resiliency policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeResiliencyPolicy.html
     */
    toDescribeResiliencyPolicy(): this;
    /**
     * Grants permission to import resources to draft application version
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - cloudformation:DescribeStacks
     * - cloudformation:ListStackResources
     * - resource-groups:GetGroup
     * - resource-groups:ListGroupResources
     * - servicecatalog:GetApplication
     * - servicecatalog:ListAssociatedResources
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ImportResourcesToDraftAppVersion.html
     */
    toImportResourcesToDraftAppVersion(): this;
    /**
     * Grants permission to list alarm recommendation
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAlarmRecommendations.html
     */
    toListAlarmRecommendations(): this;
    /**
     * Grants permission to list application assessment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppAssessments.html
     */
    toListAppAssessments(): this;
    /**
     * Grants permission to list app component compliances
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppComponentCompliances.html
     */
    toListAppComponentCompliances(): this;
    /**
     * Grants permission to list app component recommendations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppComponentRecommendations.html
     */
    toListAppComponentRecommendations(): this;
    /**
     * Grants permission to application version resource mappings
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppVersionResourceMappings.html
     */
    toListAppVersionResourceMappings(): this;
    /**
     * Grants permission to list application resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppVersionResources.html
     */
    toListAppVersionResources(): this;
    /**
     * Grants permission to list application version
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppVersions.html
     */
    toListAppVersions(): this;
    /**
     * Grants permission to list applications
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListApps.html
     */
    toListApps(): this;
    /**
     * Grants permission to list recommendation templates
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListRecommendationTemplates.html
     */
    toListRecommendationTemplates(): this;
    /**
     * Grants permission to list resiliency policies
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListResiliencyPolicies.html
     */
    toListResiliencyPolicies(): this;
    /**
     * Grants permission to list SOP recommendations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListSopRecommendations.html
     */
    toListSopRecommendations(): this;
    /**
     * Grants permission to list suggested resiliency policies
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListSuggestedResiliencyPolicies.html
     */
    toListSuggestedResiliencyPolicies(): this;
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list test recommendations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListTestRecommendations.html
     */
    toListTestRecommendations(): this;
    /**
     * Grants permission to list unsupported application version resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListUnsupportedAppVersionResources.html
     */
    toListUnsupportedAppVersionResources(): this;
    /**
     * Grants permission to publish application version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_PublishAppVersion.html
     */
    toPublishAppVersion(): this;
    /**
     * Grants permission to put draft application version template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_PutDraftAppVersionTemplate.html
     */
    toPutDraftAppVersionTemplate(): this;
    /**
     * Grants permission to remove draft application version mappings
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_RemoveDraftAppVersionResourceMappings.html
     */
    toRemoveDraftAppVersionResourceMappings(): this;
    /**
     * Grants permission to resolve application version resources
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - cloudformation:DescribeStacks
     * - cloudformation:ListStackResources
     * - resource-groups:GetGroup
     * - resource-groups:ListGroupResources
     * - servicecatalog:GetApplication
     * - servicecatalog:ListAssociatedResources
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ResolveAppVersionResources.html
     */
    toResolveAppVersionResources(): this;
    /**
     * Grants permission to create application assessment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - cloudformation:DescribeStacks
     * - cloudformation:ListStackResources
     * - cloudwatch:DescribeAlarms
     * - cloudwatch:GetMetricData
     * - cloudwatch:GetMetricStatistics
     * - cloudwatch:PutMetricData
     * - fis:GetExperimentTemplate
     * - fis:ListExperimentTemplates
     * - fis:ListExperiments
     * - resource-groups:GetGroup
     * - resource-groups:ListGroupResources
     * - servicecatalog:GetApplication
     * - servicecatalog:ListAssociatedResources
     * - ssm:GetParametersByPath
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_StartAppAssessment.html
     */
    toStartAppAssessment(): this;
    /**
     * Grants permission to assign a resource tag
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_UpdateApp.html
     */
    toUpdateApp(): this;
    /**
     * Grants permission to update resiliency policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_UpdateResiliencyPolicy.html
     */
    toUpdateResiliencyPolicy(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type resiliency-policy to the statement
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ResiliencyPolicy.html
     *
     * @param resiliencyPolicyID - Identifier for the resiliencyPolicyID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onResiliencyPolicy(resiliencyPolicyID: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type application to the statement
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_App.html
     *
     * @param appID - Identifier for the appID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onApplication(appID: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type app-assessment to the statement
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_AppAssessment.html
     *
     * @param appAssessmentID - Identifier for the appAssessmentID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAppAssessment(appAssessmentID: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type recommendation-template to the statement
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_RecommendationTemplate.html
     *
     * @param recommendationTemplateID - Identifier for the recommendationTemplateID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRecommendationTemplate(recommendationTemplateID: string, account?: string, region?: string, partition?: string): this;
}
