import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [ssm-contacts](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssystemsmanagerincidentmanagercontacts.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class SsmContacts extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [ssm-contacts](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssystemsmanagerincidentmanagercontacts.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to accept a page
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_AcceptPage.html
     */
    toAcceptPage(): this;
    /**
     * Grants permission to activate a contact's contact channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_ActivateContactChannel.html
     */
    toActivateContactChannel(): this;
    /**
     * Grants permission to use a contact in an escalation plan
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_AssociateContact.html
     */
    toAssociateContact(): this;
    /**
     * Grants permission to create a contact
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ssm-contacts:AssociateContact
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_CreateContact.html
     */
    toCreateContact(): this;
    /**
     * Grants permission to create a contact channel for a contact
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_CreateContactChannel.html
     */
    toCreateContactChannel(): this;
    /**
     * Grants permission to deactivate a contact's contact channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_DeactivateContactChannel.html
     */
    toDeactivateContactChannel(): this;
    /**
     * Grants permission to delete a contact
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_DeleteContact.html
     */
    toDeleteContact(): this;
    /**
     * Grants permission to delete a contact's contact channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_DeleteContactChannel.html
     */
    toDeleteContactChannel(): this;
    /**
     * Grants permission to delete a contact's resource policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_DeleteContactPolicy.html
     */
    toDeleteContactPolicy(): this;
    /**
     * Grants permission to describe an engagement
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_DescribeEngagement.html
     */
    toDescribeEngagement(): this;
    /**
     * Grants permission to describe a page
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_DescribePage.html
     */
    toDescribePage(): this;
    /**
     * Grants permission to get a contact
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_GetContact.html
     */
    toGetContact(): this;
    /**
     * Grants permission to get a contact's contact channel
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_GetContactChannel.html
     */
    toGetContactChannel(): this;
    /**
     * Grants permission to get a contact's resource policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_GetContactPolicy.html
     */
    toGetContactPolicy(): this;
    /**
     * Grants permission to list all of a contact's contact channels
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_ListContactChannels.html
     */
    toListContactChannels(): this;
    /**
     * Grants permission to list all contacts
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_ListContacts.html
     */
    toListContacts(): this;
    /**
     * Grants permission to list all engagements
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_ListEngagements.html
     */
    toListEngagements(): this;
    /**
     * Grants permission to list all receipts of a page
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_ListPageReceipts.html
     */
    toListPageReceipts(): this;
    /**
     * Grants permission to list all pages sent to a contact
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_ListPagesByContacts.html
     */
    toListPagesByContact(): this;
    /**
     * Grants permission to list all pages created in an engagement
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_ListPagesByEngagement.html
     */
    toListPagesByEngagement(): this;
    /**
     * Grants permission to view a list of resource tags for a specified resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to add a resource policy to a contact
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_PutContactPolicy.html
     */
    toPutContactPolicy(): this;
    /**
     * Grants permission to send the activation code of a contact's contact channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_SendActivationCode.html
     */
    toSendActivationCode(): this;
    /**
     * Grants permission to start an engagement
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_StartEngagement.html
     */
    toStartEngagement(): this;
    /**
     * Grants permission to stop an engagement
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_StopEngagement.html
     */
    toStopEngagement(): this;
    /**
     * Grants permission to add tags to a response plan
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from a response plan
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a contact
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ssm-contacts:AssociateContact
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_UpdateContact.html
     */
    toUpdateContact(): this;
    /**
     * Grants permission to update a contact's contact channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_UpdateContactChannel.html
     */
    toUpdateContactChannel(): this;
    /**
     * Grants permission to update a contact's resource policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_UpdateContactPolicy.html
     */
    toUpdateContactPolicy(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type contact to the statement
     *
     * https://docs.aws.amazon.com/incident-manager/latest/UserGuide/contacts.html
     *
     * @param contactAlias - Identifier for the contactAlias.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onContact(contactAlias: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type contactchannel to the statement
     *
     * https://docs.aws.amazon.com/incident-manager/latest/UserGuide/contacts.html
     *
     * @param contactAlias - Identifier for the contactAlias.
     * @param contactChannelId - Identifier for the contactChannelId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onContactchannel(contactAlias: string, contactChannelId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type engagement to the statement
     *
     * https://docs.aws.amazon.com/incident-manager/latest/UserGuide/escalation.html
     *
     * @param contactAlias - Identifier for the contactAlias.
     * @param engagementId - Identifier for the engagementId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onEngagement(contactAlias: string, engagementId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type page to the statement
     *
     * https://docs.aws.amazon.com/incident-manager/latest/UserGuide/escalation.html
     *
     * @param contactAlias - Identifier for the contactAlias.
     * @param pageId - Identifier for the pageId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onPage(contactAlias: string, pageId: string, account?: string, region?: string, partition?: string): this;
}
