<p align="center">
  <img src="https://dev-to-uploads.s3.amazonaws.com/uploads/articles/4trhpkkdbbzutc5ufxi9.png" width="160px">
  <h1 align="center">Masonite</h1>
</p>
<p align="center">
  <img alt="GitHub Workflow Status" src="https://img.shields.io/github/workflow/status/MasoniteFramework/masonite/Test%20Application">
  <img alt="PyPI" src="https://img.shields.io/pypi/v/masonite">
  <img src="https://img.shields.io/badge/python-3.7+-blue.svg" alt="Python Version">
  <img alt="GitHub release (latest by date including pre-releases)" src="https://img.shields.io/github/v/release/MasoniteFramework/masonite?include_prereleases">
  <img src="https://img.shields.io/github/license/MasoniteFramework/masonite.svg" alt="License">
  <a href="https://github.com/psf/black"><img alt="Code style: black" src="https://img.shields.io/badge/code%20style-black-000000.svg"></a>
</p>

## About Masonite

> Note: This repository contains the core code of the Masonite framework. If you want to see a Masonite project template please go to [MasoniteFramework/cookie-cutter](https://github.com/MasoniteFramework/cookie-cutter)

The modern and developer centric Python web framework that strives for an actual batteries included developer tool with a lot of out of the box functionality with an extremely extendable architecture. Masonite is perfect for beginner developers getting into their first web applications as well as experienced devs that need to utilize the full potential of Masonite to get their applications done.
Masonite works hard to be fast and easy from install to deployment so developers can go from concept to creation in as quick and efficiently as possible. Use it for your next SaaS! Try it once and you’ll fall in love.

- Easily send emails with the Mail Provider and the SMTP and Mailgun drivers
- Send websocket requests from your server with the Broadcast Provider and Pusher, Ably and PubNub drivers
- IOC container and auto resolving dependency injection
- Service Providers to easily add functionality to the framework
- Extremely simple static files configured and ready to go
- Active Record style ORM called [Masonite ORM](https://github.com/MasoniteFramework/orm)
- An extremely useful command line tool to assist in your development tasks
- Extremely extendable

## Learning Masonite

New to Masonite ? Please first read the [Official Documentation](https://docs.masoniteproject.com/).
Masonite strives to have extremely comprehensive documentation 😃. It would be wise to go through the tutorials there.
If you find any discrepencies or anything that doesn't make sense, be sure to comment directly on the documentation to start a discussion!

If you are more of a visual learner you can watch Masonite related tutorial videos at [masonitecasts.com](https://masonitecasts.com)

Also be sure to join the [Masonite Discord Community](https://discord.gg/TwKeFahmPZ)!

## Getting Started Quickly

If you have a working Python 3.7+ getting started is as quick as typing

```bash
pip install masonite
project start .
python craft serve
```

## Contributing

Contributing to Masonite is simple:

- Hop on [Masonite Discord Community](https://discord.gg/TwKeFahmPZ) to ask any questions you need!
- Read the [How To Contribute](https://docs.masoniteproject.com/prologue/how-to-contribute) documentation to see ways to contribute to the project.
- Read the [Contributing Guide](https://docs.masoniteproject.com/prologue/contributing-guide) to learn how to contribute to the core source code development of the project.
- [Follow Masonite Framework on Twitter](https://twitter.com/masoniteproject) to get updates about tips and tricks, announcement and releases.

## Core Maintainers

- [Joseph Mancuso](https://github.com/josephmancuso) (Author)
- [Samuel Girardin](https://github.com/girardinsamuel)
- [Marlysson Silva](https://github.com/Marlysson)

## Sponsors

To become a sponsor head to our [GitHub Sponsors page](https://github.com/sponsors/MasoniteFramework)!

## Security Vulnerabilities

If you discover a security vulnerability within Masonite please read the [Security Policy](./SECURITY.md). All security vulnerabilities will be promptly addressed.

## License

The Masonite framework is open-sourced software licensed under the [MIT license](https://opensource.org/licenses/MIT).
