#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# Word list originally created by dabura667 and released under The MIT License (MIT)
#
# The MIT License (MIT)
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#
# Code surrounding the word list is Copyright (c) 2014-2018, The Monero Project
#
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without modification, are
# permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice, this list of
#    conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice, this list
#    of conditions and the following disclaimer in the documentation and/or other
#    materials provided with the distribution.
#
# 3. Neither the name of the copyright holder nor the names of its contributors may be
#    used to endorse or promote products derived from this software without specific
#    prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
# THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
# STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
# THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# list of words from:
#     https://github.com/monero-project/monero/blob/master/src/mnemonics/german.h
#     Most recent commit: 8ea3c4d54429976e9001b8cc4868b721e6747e3c


from .wordlist import Wordlist


class German(Wordlist):
    language_name = "Deutsch"
    english_language_name = "German"
    unique_prefix_length = 4
    word_list = [
        u"Abakus",
        u"Abart",
        u"abbilden",
        u"Abbruch",
        u"Abdrift",
        u"Abendrot",
        u"Abfahrt",
        u"abfeuern",
        u"Abflug",
        u"abfragen",
        u"Abglanz",
        u"abhärten",
        u"abheben",
        u"Abhilfe",
        u"Abitur",
        u"Abkehr",
        u"Ablauf",
        u"ablecken",
        u"Ablösung",
        u"Abnehmer",
        u"abnutzen",
        u"Abonnent",
        u"Abrasion",
        u"Abrede",
        u"abrüsten",
        u"Absicht",
        u"Absprung",
        u"Abstand",
        u"absuchen",
        u"Abteil",
        u"Abundanz",
        u"abwarten",
        u"Abwurf",
        u"Abzug",
        u"Achse",
        u"Achtung",
        u"Acker",
        u"Aderlass",
        u"Adler",
        u"Admiral",
        u"Adresse",
        u"Affe",
        u"Affront",
        u"Afrika",
        u"Aggregat",
        u"Agilität",
        u"ähneln",
        u"Ahnung",
        u"Ahorn",
        u"Akazie",
        u"Akkord",
        u"Akrobat",
        u"Aktfoto",
        u"Aktivist",
        u"Albatros",
        u"Alchimie",
        u"Alemanne",
        u"Alibi",
        u"Alkohol",
        u"Allee",
        u"Allüre",
        u"Almosen",
        u"Almweide",
        u"Aloe",
        u"Alpaka",
        u"Alpental",
        u"Alphabet",
        u"Alpinist",
        u"Alraune",
        u"Altbier",
        u"Alter",
        u"Altflöte",
        u"Altruist",
        u"Alublech",
        u"Aludose",
        u"Amateur",
        u"Amazonas",
        u"Ameise",
        u"Amnesie",
        u"Amok",
        u"Ampel",
        u"Amphibie",
        u"Ampulle",
        u"Amsel",
        u"Amulett",
        u"Anakonda",
        u"Analogie",
        u"Ananas",
        u"Anarchie",
        u"Anatomie",
        u"Anbau",
        u"Anbeginn",
        u"anbieten",
        u"Anblick",
        u"ändern",
        u"andocken",
        u"Andrang",
        u"anecken",
        u"Anflug",
        u"Anfrage",
        u"Anführer",
        u"Angebot",
        u"Angler",
        u"Anhalter",
        u"Anhöhe",
        u"Animator",
        u"Anis",
        u"Anker",
        u"ankleben",
        u"Ankunft",
        u"Anlage",
        u"anlocken",
        u"Anmut",
        u"Annahme",
        u"Anomalie",
        u"Anonymus",
        u"Anorak",
        u"anpeilen",
        u"Anrecht",
        u"Anruf",
        u"Ansage",
        u"Anschein",
        u"Ansicht",
        u"Ansporn",
        u"Anteil",
        u"Antlitz",
        u"Antrag",
        u"Antwort",
        u"Anwohner",
        u"Aorta",
        u"Apfel",
        u"Appetit",
        u"Applaus",
        u"Aquarium",
        u"Arbeit",
        u"Arche",
        u"Argument",
        u"Arktis",
        u"Armband",
        u"Aroma",
        u"Asche",
        u"Askese",
        u"Asphalt",
        u"Asteroid",
        u"Ästhetik",
        u"Astronom",
        u"Atelier",
        u"Athlet",
        u"Atlantik",
        u"Atmung",
        u"Audienz",
        u"aufatmen",
        u"Auffahrt",
        u"aufholen",
        u"aufregen",
        u"Aufsatz",
        u"Auftritt",
        u"Aufwand",
        u"Augapfel",
        u"Auktion",
        u"Ausbruch",
        u"Ausflug",
        u"Ausgabe",
        u"Aushilfe",
        u"Ausland",
        u"Ausnahme",
        u"Aussage",
        u"Autobahn",
        u"Avocado",
        u"Axthieb",
        u"Bach",
        u"backen",
        u"Badesee",
        u"Bahnhof",
        u"Balance",
        u"Balkon",
        u"Ballett",
        u"Balsam",
        u"Banane",
        u"Bandage",
        u"Bankett",
        u"Barbar",
        u"Barde",
        u"Barett",
        u"Bargeld",
        u"Barkasse",
        u"Barriere",
        u"Bart",
        u"Bass",
        u"Bastler",
        u"Batterie",
        u"Bauch",
        u"Bauer",
        u"Bauholz",
        u"Baujahr",
        u"Baum",
        u"Baustahl",
        u"Bauteil",
        u"Bauweise",
        u"Bazar",
        u"beachten",
        u"Beatmung",
        u"beben",
        u"Becher",
        u"Becken",
        u"bedanken",
        u"beeilen",
        u"beenden",
        u"Beere",
        u"befinden",
        u"Befreier",
        u"Begabung",
        u"Begierde",
        u"begrüßen",
        u"Beiboot",
        u"Beichte",
        u"Beifall",
        u"Beigabe",
        u"Beil",
        u"Beispiel",
        u"Beitrag",
        u"beizen",
        u"bekommen",
        u"beladen",
        u"Beleg",
        u"bellen",
        u"belohnen",
        u"Bemalung",
        u"Bengel",
        u"Benutzer",
        u"Benzin",
        u"beraten",
        u"Bereich",
        u"Bergluft",
        u"Bericht",
        u"Bescheid",
        u"Besitz",
        u"besorgen",
        u"Bestand",
        u"Besuch",
        u"betanken",
        u"beten",
        u"betören",
        u"Bett",
        u"Beule",
        u"Beute",
        u"Bewegung",
        u"bewirken",
        u"Bewohner",
        u"bezahlen",
        u"Bezug",
        u"biegen",
        u"Biene",
        u"Bierzelt",
        u"bieten",
        u"Bikini",
        u"Bildung",
        u"Billard",
        u"binden",
        u"Biobauer",
        u"Biologe",
        u"Bionik",
        u"Biotop",
        u"Birke",
        u"Bison",
        u"Bitte",
        u"Biwak",
        u"Bizeps",
        u"blasen",
        u"Blatt",
        u"Blauwal",
        u"Blende",
        u"Blick",
        u"Blitz",
        u"Blockade",
        u"Blödelei",
        u"Blondine",
        u"Blues",
        u"Blume",
        u"Blut",
        u"Bodensee",
        u"Bogen",
        u"Boje",
        u"Bollwerk",
        u"Bonbon",
        u"Bonus",
        u"Boot",
        u"Bordarzt",
        u"Börse",
        u"Böschung",
        u"Boudoir",
        u"Boxkampf",
        u"Boykott",
        u"Brahms",
        u"Brandung",
        u"Brauerei",
        u"Brecher",
        u"Breitaxt",
        u"Bremse",
        u"brennen",
        u"Brett",
        u"Brief",
        u"Brigade",
        u"Brillanz",
        u"bringen",
        u"brodeln",
        u"Brosche",
        u"Brötchen",
        u"Brücke",
        u"Brunnen",
        u"Brüste",
        u"Brutofen",
        u"Buch",
        u"Büffel",
        u"Bugwelle",
        u"Bühne",
        u"Buletten",
        u"Bullauge",
        u"Bumerang",
        u"bummeln",
        u"Buntglas",
        u"Bürde",
        u"Burgherr",
        u"Bursche",
        u"Busen",
        u"Buslinie",
        u"Bussard",
        u"Butangas",
        u"Butter",
        u"Cabrio",
        u"campen",
        u"Captain",
        u"Cartoon",
        u"Cello",
        u"Chalet",
        u"Charisma",
        u"Chefarzt",
        u"Chiffon",
        u"Chipsatz",
        u"Chirurg",
        u"Chor",
        u"Chronik",
        u"Chuzpe",
        u"Clubhaus",
        u"Cockpit",
        u"Codewort",
        u"Cognac",
        u"Coladose",
        u"Computer",
        u"Coupon",
        u"Cousin",
        u"Cracking",
        u"Crash",
        u"Curry",
        u"Dach",
        u"Dackel",
        u"daddeln",
        u"daliegen",
        u"Dame",
        u"Dammbau",
        u"Dämon",
        u"Dampflok",
        u"Dank",
        u"Darm",
        u"Datei",
        u"Datsche",
        u"Datteln",
        u"Datum",
        u"Dauer",
        u"Daunen",
        u"Deckel",
        u"Decoder",
        u"Defekt",
        u"Degen",
        u"Dehnung",
        u"Deiche",
        u"Dekade",
        u"Dekor",
        u"Delfin",
        u"Demut",
        u"denken",
        u"Deponie",
        u"Design",
        u"Desktop",
        u"Dessert",
        u"Detail",
        u"Detektiv",
        u"Dezibel",
        u"Diadem",
        u"Diagnose",
        u"Dialekt",
        u"Diamant",
        u"Dichter",
        u"Dickicht",
        u"Diesel",
        u"Diktat",
        u"Diplom",
        u"Direktor",
        u"Dirne",
        u"Diskurs",
        u"Distanz",
        u"Docht",
        u"Dohle",
        u"Dolch",
        u"Domäne",
        u"Donner",
        u"Dorade",
        u"Dorf",
        u"Dörrobst",
        u"Dorsch",
        u"Dossier",
        u"Dozent",
        u"Drachen",
        u"Draht",
        u"Drama",
        u"Drang",
        u"Drehbuch",
        u"Dreieck",
        u"Dressur",
        u"Drittel",
        u"Drossel",
        u"Druck",
        u"Duell",
        u"Duft",
        u"Düne",
        u"Dünung",
        u"dürfen",
        u"Duschbad",
        u"Düsenjet",
        u"Dynamik",
        u"Ebbe",
        u"Echolot",
        u"Echse",
        u"Eckball",
        u"Edding",
        u"Edelweiß",
        u"Eden",
        u"Edition",
        u"Efeu",
        u"Effekte",
        u"Egoismus",
        u"Ehre",
        u"Eiablage",
        u"Eiche",
        u"Eidechse",
        u"Eidotter",
        u"Eierkopf",
        u"Eigelb",
        u"Eiland",
        u"Eilbote",
        u"Eimer",
        u"einatmen",
        u"Einband",
        u"Eindruck",
        u"Einfall",
        u"Eingang",
        u"Einkauf",
        u"einladen",
        u"Einöde",
        u"Einrad",
        u"Eintopf",
        u"Einwurf",
        u"Einzug",
        u"Eisbär",
        u"Eisen",
        u"Eishöhle",
        u"Eismeer",
        u"Eiweiß",
        u"Ekstase",
        u"Elan",
        u"Elch",
        u"Elefant",
        u"Eleganz",
        u"Element",
        u"Elfe",
        u"Elite",
        u"Elixier",
        u"Ellbogen",
        u"Eloquenz",
        u"Emigrant",
        u"Emission",
        u"Emotion",
        u"Empathie",
        u"Empfang",
        u"Endzeit",
        u"Energie",
        u"Engpass",
        u"Enkel",
        u"Enklave",
        u"Ente",
        u"entheben",
        u"Entität",
        u"entladen",
        u"Entwurf",
        u"Episode",
        u"Epoche",
        u"erachten",
        u"Erbauer",
        u"erblühen",
        u"Erdbeere",
        u"Erde",
        u"Erdgas",
        u"Erdkunde",
        u"Erdnuss",
        u"Erdöl",
        u"Erdteil",
        u"Ereignis",
        u"Eremit",
        u"erfahren",
        u"Erfolg",
        u"erfreuen",
        u"erfüllen",
        u"Ergebnis",
        u"erhitzen",
        u"erkalten",
        u"erkennen",
        u"erleben",
        u"Erlösung",
        u"ernähren",
        u"erneuern",
        u"Ernte",
        u"Eroberer",
        u"eröffnen",
        u"Erosion",
        u"Erotik",
        u"Erpel",
        u"erraten",
        u"Erreger",
        u"erröten",
        u"Ersatz",
        u"Erstflug",
        u"Ertrag",
        u"Eruption",
        u"erwarten",
        u"erwidern",
        u"Erzbau",
        u"Erzeuger",
        u"erziehen",
        u"Esel",
        u"Eskimo",
        u"Eskorte",
        u"Espe",
        u"Espresso",
        u"essen",
        u"Etage",
        u"Etappe",
        u"Etat",
        u"Ethik",
        u"Etikett",
        u"Etüde",
        u"Eule",
        u"Euphorie",
        u"Europa",
        u"Everest",
        u"Examen",
        u"Exil",
        u"Exodus",
        u"Extrakt",
        u"Fabel",
        u"Fabrik",
        u"Fachmann",
        u"Fackel",
        u"Faden",
        u"Fagott",
        u"Fahne",
        u"Faible",
        u"Fairness",
        u"Fakt",
        u"Fakultät",
        u"Falke",
        u"Fallobst",
        u"Fälscher",
        u"Faltboot",
        u"Familie",
        u"Fanclub",
        u"Fanfare",
        u"Fangarm",
        u"Fantasie",
        u"Farbe",
        u"Farmhaus",
        u"Farn",
        u"Fasan",
        u"Faser",
        u"Fassung",
        u"fasten",
        u"Faulheit",
        u"Fauna",
        u"Faust",
        u"Favorit",
        u"Faxgerät",
        u"Fazit",
        u"fechten",
        u"Federboa",
        u"Fehler",
        u"Feier",
        u"Feige",
        u"feilen",
        u"Feinripp",
        u"Feldbett",
        u"Felge",
        u"Fellpony",
        u"Felswand",
        u"Ferien",
        u"Ferkel",
        u"Fernweh",
        u"Ferse",
        u"Fest",
        u"Fettnapf",
        u"Feuer",
        u"Fiasko",
        u"Fichte",
        u"Fiktion",
        u"Film",
        u"Filter",
        u"Filz",
        u"Finanzen",
        u"Findling",
        u"Finger",
        u"Fink",
        u"Finnwal",
        u"Fisch",
        u"Fitness",
        u"Fixpunkt",
        u"Fixstern",
        u"Fjord",
        u"Flachbau",
        u"Flagge",
        u"Flamenco",
        u"Flanke",
        u"Flasche",
        u"Flaute",
        u"Fleck",
        u"Flegel",
        u"flehen",
        u"Fleisch",
        u"fliegen",
        u"Flinte",
        u"Flirt",
        u"Flocke",
        u"Floh",
        u"Floskel",
        u"Floß",
        u"Flöte",
        u"Flugzeug",
        u"Flunder",
        u"Flusstal",
        u"Flutung",
        u"Fockmast",
        u"Fohlen",
        u"Föhnlage",
        u"Fokus",
        u"folgen",
        u"Foliant",
        u"Folklore",
        u"Fontäne",
        u"Förde",
        u"Forelle",
        u"Format",
        u"Forscher",
        u"Fortgang",
        u"Forum",
        u"Fotograf",
        u"Frachter",
        u"Fragment",
        u"Fraktion",
        u"fräsen",
        u"Frauenpo",
        u"Freak",
        u"Fregatte",
        u"Freiheit",
        u"Freude",
        u"Frieden",
        u"Frohsinn",
        u"Frosch",
        u"Frucht",
        u"Frühjahr",
        u"Fuchs",
        u"Fügung",
        u"fühlen",
        u"Füller",
        u"Fundbüro",
        u"Funkboje",
        u"Funzel",
        u"Furnier",
        u"Fürsorge",
        u"Fusel",
        u"Fußbad",
        u"Futteral",
        u"Gabelung",
        u"gackern",
        u"Gage",
        u"gähnen",
        u"Galaxie",
        u"Galeere",
        u"Galopp",
        u"Gameboy",
        u"Gamsbart",
        u"Gandhi",
        u"Gang",
        u"Garage",
        u"Gardine",
        u"Garküche",
        u"Garten",
        u"Gasthaus",
        u"Gattung",
        u"gaukeln",
        u"Gazelle",
        u"Gebäck",
        u"Gebirge",
        u"Gebräu",
        u"Geburt",
        u"Gedanke",
        u"Gedeck",
        u"Gedicht",
        u"Gefahr",
        u"Gefieder",
        u"Geflügel",
        u"Gefühl",
        u"Gegend",
        u"Gehirn",
        u"Gehöft",
        u"Gehweg",
        u"Geige",
        u"Geist",
        u"Gelage",
        u"Geld",
        u"Gelenk",
        u"Gelübde",
        u"Gemälde",
        u"Gemeinde",
        u"Gemüse",
        u"genesen",
        u"Genuss",
        u"Gepäck",
        u"Geranie",
        u"Gericht",
        u"Germane",
        u"Geruch",
        u"Gesang",
        u"Geschenk",
        u"Gesetz",
        u"Gesindel",
        u"Gesöff",
        u"Gespan",
        u"Gestade",
        u"Gesuch",
        u"Getier",
        u"Getränk",
        u"Getümmel",
        u"Gewand",
        u"Geweih",
        u"Gewitter",
        u"Gewölbe",
        u"Geysir",
        u"Giftzahn",
        u"Gipfel",
        u"Giraffe",
        u"Gitarre",
        u"glänzen",
        u"Glasauge",
        u"Glatze",
        u"Gleis",
        u"Globus",
        u"Glück",
        u"glühen",
        u"Glutofen",
        u"Goldzahn",
        u"Gondel",
        u"gönnen",
        u"Gottheit",
        u"graben",
        u"Grafik",
        u"Grashalm",
        u"Graugans",
        u"greifen",
        u"Grenze",
        u"grillen",
        u"Groschen",
        u"Grotte",
        u"Grube",
        u"Grünalge",
        u"Gruppe",
        u"gruseln",
        u"Gulasch",
        u"Gummibär",
        u"Gurgel",
        u"Gürtel",
        u"Güterzug",
        u"Haarband",
        u"Habicht",
        u"hacken",
        u"hadern",
        u"Hafen",
        u"Hagel",
        u"Hähnchen",
        u"Haifisch",
        u"Haken",
        u"Halbaffe",
        u"Halsader",
        u"halten",
        u"Halunke",
        u"Handbuch",
        u"Hanf",
        u"Harfe",
        u"Harnisch",
        u"härten",
        u"Harz",
        u"Hasenohr",
        u"Haube",
        u"hauchen",
        u"Haupt",
        u"Haut",
        u"Havarie",
        u"Hebamme",
        u"hecheln",
        u"Heck",
        u"Hedonist",
        u"Heiler",
        u"Heimat",
        u"Heizung",
        u"Hektik",
        u"Held",
        u"helfen",
        u"Helium",
        u"Hemd",
        u"hemmen",
        u"Hengst",
        u"Herd",
        u"Hering",
        u"Herkunft",
        u"Hermelin",
        u"Herrchen",
        u"Herzdame",
        u"Heulboje",
        u"Hexe",
        u"Hilfe",
        u"Himbeere",
        u"Himmel",
        u"Hingabe",
        u"hinhören",
        u"Hinweis",
        u"Hirsch",
        u"Hirte",
        u"Hitzkopf",
        u"Hobel",
        u"Hochform",
        u"Hocker",
        u"hoffen",
        u"Hofhund",
        u"Hofnarr",
        u"Höhenzug",
        u"Hohlraum",
        u"Hölle",
        u"Holzboot",
        u"Honig",
        u"Honorar",
        u"horchen",
        u"Hörprobe",
        u"Höschen",
        u"Hotel",
        u"Hubraum",
        u"Hufeisen",
        u"Hügel",
        u"huldigen",
        u"Hülle",
        u"Humbug",
        u"Hummer",
        u"Humor",
        u"Hund",
        u"Hunger",
        u"Hupe",
        u"Hürde",
        u"Hurrikan",
        u"Hydrant",
        u"Hypnose",
        u"Ibis",
        u"Idee",
        u"Idiot",
        u"Igel",
        u"Illusion",
        u"Imitat",
        u"impfen",
        u"Import",
        u"Inferno",
        u"Ingwer",
        u"Inhalte",
        u"Inland",
        u"Insekt",
        u"Ironie",
        u"Irrfahrt",
        u"Irrtum",
        u"Isolator",
        u"Istwert",
        u"Jacke",
        u"Jade",
        u"Jagdhund",
        u"Jäger",
        u"Jaguar",
        u"Jahr",
        u"Jähzorn",
        u"Jazzfest",
        u"Jetpilot",
        u"jobben",
        u"Jochbein",
        u"jodeln",
        u"Jodsalz",
        u"Jolle",
        u"Journal",
        u"Jubel",
        u"Junge",
        u"Junimond",
        u"Jupiter",
        u"Jutesack",
        u"Juwel",
        u"Kabarett",
        u"Kabine",
        u"Kabuff",
        u"Käfer",
        u"Kaffee",
        u"Kahlkopf",
        u"Kaimauer",
        u"Kajüte",
        u"Kaktus",
        u"Kaliber",
        u"Kaltluft",
        u"Kamel",
        u"kämmen",
        u"Kampagne",
        u"Kanal",
        u"Känguru",
        u"Kanister",
        u"Kanone",
        u"Kante",
        u"Kanu",
        u"kapern",
        u"Kapitän",
        u"Kapuze",
        u"Karneval",
        u"Karotte",
        u"Käsebrot",
        u"Kasper",
        u"Kastanie",
        u"Katalog",
        u"Kathode",
        u"Katze",
        u"kaufen",
        u"Kaugummi",
        u"Kauz",
        u"Kehle",
        u"Keilerei",
        u"Keksdose",
        u"Kellner",
        u"Keramik",
        u"Kerze",
        u"Kessel",
        u"Kette",
        u"keuchen",
        u"kichern",
        u"Kielboot",
        u"Kindheit",
        u"Kinnbart",
        u"Kinosaal",
        u"Kiosk",
        u"Kissen",
        u"Klammer",
        u"Klang",
        u"Klapprad",
        u"Klartext",
        u"kleben",
        u"Klee",
        u"Kleinod",
        u"Klima",
        u"Klingel",
        u"Klippe",
        u"Klischee",
        u"Kloster",
        u"Klugheit",
        u"Klüngel",
        u"kneten",
        u"Knie",
        u"Knöchel",
        u"knüpfen",
        u"Kobold",
        u"Kochbuch",
        u"Kohlrabi",
        u"Koje",
        u"Kokosöl",
        u"Kolibri",
        u"Kolumne",
        u"Kombüse",
        u"Komiker",
        u"kommen",
        u"Konto",
        u"Konzept",
        u"Kopfkino",
        u"Kordhose",
        u"Korken",
        u"Korsett",
        u"Kosename",
        u"Krabbe",
        u"Krach",
        u"Kraft",
        u"Krähe",
        u"Kralle",
        u"Krapfen",
        u"Krater",
        u"kraulen",
        u"Kreuz",
        u"Krokodil",
        u"Kröte",
        u"Kugel",
        u"Kuhhirt",
        u"Kühnheit",
        u"Künstler",
        u"Kurort",
        u"Kurve",
        u"Kurzfilm",
        u"kuscheln",
        u"küssen",
        u"Kutter",
        u"Labor",
        u"lachen",
        u"Lackaffe",
        u"Ladeluke",
        u"Lagune",
        u"Laib",
        u"Lakritze",
        u"Lammfell",
        u"Land",
        u"Langmut",
        u"Lappalie",
        u"Last",
        u"Laterne",
        u"Latzhose",
        u"Laubsäge",
        u"laufen",
        u"Laune",
        u"Lausbub",
        u"Lavasee",
        u"Leben",
        u"Leder",
        u"Leerlauf",
        u"Lehm",
        u"Lehrer",
        u"leihen",
        u"Lektüre",
        u"Lenker",
        u"Lerche",
        u"Leseecke",
        u"Leuchter",
        u"Lexikon",
        u"Libelle",
        u"Libido",
        u"Licht",
        u"Liebe",
        u"liefern",
        u"Liftboy",
        u"Limonade",
        u"Lineal",
        u"Linoleum",
        u"List",
        u"Liveband",
        u"Lobrede",
        u"locken",
        u"Löffel",
        u"Logbuch",
        u"Logik",
        u"Lohn",
        u"Loipe",
        u"Lokal",
        u"Lorbeer",
        u"Lösung",
        u"löten",
        u"Lottofee",
        u"Löwe",
        u"Luchs",
        u"Luder",
        u"Luftpost",
        u"Luke",
        u"Lümmel",
        u"Lunge",
        u"lutschen",
        u"Luxus",
        u"Macht",
        u"Magazin",
        u"Magier",
        u"Magnet",
        u"mähen",
        u"Mahlzeit",
        u"Mahnmal",
        u"Maibaum",
        u"Maisbrei",
        u"Makel",
        u"malen",
        u"Mammut",
        u"Maniküre",
        u"Mantel",
        u"Marathon",
        u"Marder",
        u"Marine",
        u"Marke",
        u"Marmor",
        u"Märzluft",
        u"Maske",
        u"Maßanzug",
        u"Maßkrug",
        u"Mastkorb",
        u"Material",
        u"Matratze",
        u"Mauerbau",
        u"Maulkorb",
        u"Mäuschen",
        u"Mäzen",
        u"Medium",
        u"Meinung",
        u"melden",
        u"Melodie",
        u"Mensch",
        u"Merkmal",
        u"Messe",
        u"Metall",
        u"Meteor",
        u"Methode",
        u"Metzger",
        u"Mieze",
        u"Milchkuh",
        u"Mimose",
        u"Minirock",
        u"Minute",
        u"mischen",
        u"Missetat",
        u"mitgehen",
        u"Mittag",
        u"Mixtape",
        u"Möbel",
        u"Modul",
        u"mögen",
        u"Möhre",
        u"Molch",
        u"Moment",
        u"Monat",
        u"Mondflug",
        u"Monitor",
        u"Monokini",
        u"Monster",
        u"Monument",
        u"Moorhuhn",
        u"Moos",
        u"Möpse",
        u"Moral",
        u"Mörtel",
        u"Motiv",
        u"Motorrad",
        u"Möwe",
        u"Mühe",
        u"Mulatte",
        u"Müller",
        u"Mumie",
        u"Mund",
        u"Münze",
        u"Muschel",
        u"Muster",
        u"Mythos",
        u"Nabel",
        u"Nachtzug",
        u"Nackedei",
        u"Nagel",
        u"Nähe",
        u"Nähnadel",
        u"Namen",
        u"Narbe",
        u"Narwal",
        u"Nasenbär",
        u"Natur",
        u"Nebel",
        u"necken",
        u"Neffe",
        u"Neigung",
        u"Nektar",
        u"Nenner",
        u"Neptun",
        u"Nerz",
        u"Nessel",
        u"Nestbau",
        u"Netz",
        u"Neubau",
        u"Neuerung",
        u"Neugier",
        u"nicken",
        u"Niere",
        u"Nilpferd",
        u"nisten",
        u"Nocke",
        u"Nomade",
        u"Nordmeer",
        u"Notdurft",
        u"Notstand",
        u"Notwehr",
        u"Nudismus",
        u"Nuss",
        u"Nutzhanf",
        u"Oase",
        u"Obdach",
        u"Oberarzt",
        u"Objekt",
        u"Oboe",
        u"Obsthain",
        u"Ochse",
        u"Odyssee",
        u"Ofenholz",
        u"öffnen",
        u"Ohnmacht",
        u"Ohrfeige",
        u"Ohrwurm",
        u"Ökologie",
        u"Oktave",
        u"Ölberg",
        u"Olive",
        u"Ölkrise",
        u"Omelett",
        u"Onkel",
        u"Oper",
        u"Optiker",
        u"Orange",
        u"Orchidee",
        u"ordnen",
        u"Orgasmus",
        u"Orkan",
        u"Ortskern",
        u"Ortung",
        u"Ostasien",
        u"Ozean",
        u"Paarlauf",
        u"Packeis",
        u"paddeln",
        u"Paket",
        u"Palast",
        u"Pandabär",
        u"Panik",
        u"Panorama",
        u"Panther",
        u"Papagei",
        u"Papier",
        u"Paprika",
        u"Paradies",
        u"Parka",
        u"Parodie",
        u"Partner",
        u"Passant",
        u"Patent",
        u"Patzer",
        u"Pause",
        u"Pavian",
        u"Pedal",
        u"Pegel",
        u"peilen",
        u"Perle",
        u"Person",
        u"Pfad",
        u"Pfau",
        u"Pferd",
        u"Pfleger",
        u"Physik",
        u"Pier",
        u"Pilotwal",
        u"Pinzette",
        u"Piste",
        u"Plakat",
        u"Plankton",
        u"Platin",
        u"Plombe",
        u"plündern",
        u"Pobacke",
        u"Pokal",
        u"polieren",
        u"Popmusik",
        u"Porträt",
        u"Posaune",
        u"Postamt",
        u"Pottwal",
        u"Pracht",
        u"Pranke",
        u"Preis",
        u"Primat",
        u"Prinzip",
        u"Protest",
        u"Proviant",
        u"Prüfung",
        u"Pubertät",
        u"Pudding",
        u"Pullover",
        u"Pulsader",
        u"Punkt",
        u"Pute",
        u"Putsch",
        u"Puzzle",
        u"Python",
        u"quaken",
        u"Qualle",
        u"Quark",
        u"Quellsee",
        u"Querkopf",
        u"Quitte",
        u"Quote",
        u"Rabauke",
        u"Rache",
        u"Radclub",
        u"Radhose",
        u"Radio",
        u"Radtour",
        u"Rahmen",
        u"Rampe",
        u"Randlage",
        u"Ranzen",
        u"Rapsöl",
        u"Raserei",
        u"rasten",
        u"Rasur",
        u"Rätsel",
        u"Raubtier",
        u"Raumzeit",
        u"Rausch",
        u"Reaktor",
        u"Realität",
        u"Rebell",
        u"Rede",
        u"Reetdach",
        u"Regatta",
        u"Regen",
        u"Rehkitz",
        u"Reifen",
        u"Reim",
        u"Reise",
        u"Reizung",
        u"Rekord",
        u"Relevanz",
        u"Rennboot",
        u"Respekt",
        u"Restmüll",
        u"retten",
        u"Reue",
        u"Revolte",
        u"Rhetorik",
        u"Rhythmus",
        u"Richtung",
        u"Riegel",
        u"Rindvieh",
        u"Rippchen",
        u"Ritter",
        u"Robbe",
        u"Roboter",
        u"Rockband",
        u"Rohdaten",
        u"Roller",
        u"Roman",
        u"röntgen",
        u"Rose",
        u"Rosskur",
        u"Rost",
        u"Rotahorn",
        u"Rotglut",
        u"Rotznase",
        u"Rubrik",
        u"Rückweg",
        u"Rufmord",
        u"Ruhe",
        u"Ruine",
        u"Rumpf",
        u"Runde",
        u"Rüstung",
        u"rütteln",
        u"Saaltür",
        u"Saatguts",
        u"Säbel",
        u"Sachbuch",
        u"Sack",
        u"Saft",
        u"sagen",
        u"Sahneeis",
        u"Salat",
        u"Salbe",
        u"Salz",
        u"Sammlung",
        u"Samt",
        u"Sandbank",
        u"Sanftmut",
        u"Sardine",
        u"Satire",
        u"Sattel",
        u"Satzbau",
        u"Sauerei",
        u"Saum",
        u"Säure",
        u"Schall",
        u"Scheitel",
        u"Schiff",
        u"Schlager",
        u"Schmied",
        u"Schnee",
        u"Scholle",
        u"Schrank",
        u"Schulbus",
        u"Schwan",
        u"Seeadler",
        u"Seefahrt",
        u"Seehund",
        u"Seeufer",
        u"segeln",
        u"Sehnerv",
        u"Seide",
        u"Seilzug",
        u"Senf",
        u"Sessel",
        u"Seufzer",
        u"Sexgott",
        u"Sichtung",
        u"Signal",
        u"Silber",
        u"singen",
        u"Sinn",
        u"Sirup",
        u"Sitzbank",
        u"Skandal",
        u"Skikurs",
        u"Skipper",
        u"Skizze",
        u"Smaragd",
        u"Socke",
        u"Sohn",
        u"Sommer",
        u"Songtext",
        u"Sorte",
        u"Spagat",
        u"Spannung",
        u"Spargel",
        u"Specht",
        u"Speiseöl",
        u"Spiegel",
        u"Sport",
        u"spülen",
        u"Stadtbus",
        u"Stall",
        u"Stärke",
        u"Stativ",
        u"staunen",
        u"Stern",
        u"Stiftung",
        u"Stollen",
        u"Strömung",
        u"Sturm",
        u"Substanz",
        u"Südalpen",
        u"Sumpf",
        u"surfen",
        u"Tabak",
        u"Tafel",
        u"Tagebau",
        u"takeln",
        u"Taktung",
        u"Talsohle",
        u"Tand",
        u"Tanzbär",
        u"Tapir",
        u"Tarantel",
        u"Tarnname",
        u"Tasse",
        u"Tatnacht",
        u"Tatsache",
        u"Tatze",
        u"Taube",
        u"tauchen",
        u"Taufpate",
        u"Taumel",
        u"Teelicht",
        u"Teich",
        u"teilen",
        u"Tempo",
        u"Tenor",
        u"Terrasse",
        u"Testflug",
        u"Theater",
        u"Thermik",
        u"ticken",
        u"Tiefflug",
        u"Tierart",
        u"Tigerhai",
        u"Tinte",
        u"Tischler",
        u"toben",
        u"Toleranz",
        u"Tölpel",
        u"Tonband",
        u"Topf",
        u"Topmodel",
        u"Torbogen",
        u"Torlinie",
        u"Torte",
        u"Tourist",
        u"Tragesel",
        u"trampeln",
        u"Trapez",
        u"Traum",
        u"treffen",
        u"Trennung",
        u"Treue",
        u"Trick",
        u"trimmen",
        u"Trödel",
        u"Trost",
        u"Trumpf",
        u"tüfteln",
        u"Turban",
        u"Turm",
        u"Übermut",
        u"Ufer",
        u"Uhrwerk",
        u"umarmen",
        u"Umbau",
        u"Umfeld",
        u"Umgang",
        u"Umsturz",
        u"Unart",
        u"Unfug",
        u"Unimog",
        u"Unruhe",
        u"Unwucht",
        u"Uranerz",
        u"Urlaub",
        u"Urmensch",
        u"Utopie",
        u"Vakuum",
        u"Valuta",
        u"Vandale",
        u"Vase",
        u"Vektor",
        u"Ventil",
        u"Verb",
        u"Verdeck",
        u"Verfall",
        u"Vergaser",
        u"verhexen",
        u"Verlag",
        u"Vers",
        u"Vesper",
        u"Vieh",
        u"Viereck",
        u"Vinyl",
        u"Virus",
        u"Vitrine",
        u"Vollblut",
        u"Vorbote",
        u"Vorrat",
        u"Vorsicht",
        u"Vulkan",
        u"Wachstum",
        u"Wade",
        u"Wagemut",
        u"Wahlen",
        u"Wahrheit",
        u"Wald",
        u"Walhai",
        u"Wallach",
        u"Walnuss",
        u"Walzer",
        u"wandeln",
        u"Wanze",
        u"wärmen",
        u"Warnruf",
        u"Wäsche",
        u"Wasser",
        u"Weberei",
        u"wechseln",
        u"Wegegeld",
        u"wehren",
        u"Weiher",
        u"Weinglas",
        u"Weißbier",
        u"Weitwurf",
        u"Welle",
        u"Weltall",
        u"Werkbank",
        u"Werwolf",
        u"Wetter",
        u"wiehern",
        u"Wildgans",
        u"Wind",
        u"Wohl",
        u"Wohnort",
        u"Wolf",
        u"Wollust",
        u"Wortlaut",
        u"Wrack",
        u"Wunder",
        u"Wurfaxt",
        u"Wurst",
        u"Yacht",
        u"Yeti",
        u"Zacke",
        u"Zahl",
        u"zähmen",
        u"Zahnfee",
        u"Zäpfchen",
        u"Zaster",
        u"Zaumzeug",
        u"Zebra",
        u"zeigen",
        u"Zeitlupe",
        u"Zellkern",
        u"Zeltdach",
        u"Zensor",
        u"Zerfall",
        u"Zeug",
        u"Ziege",
        u"Zielfoto",
        u"Zimteis",
        u"Zobel",
        u"Zollhund",
        u"Zombie",
        u"Zöpfe",
        u"Zucht",
        u"Zufahrt",
        u"Zugfahrt",
        u"Zugvogel",
        u"Zündung",
        u"Zweck",
        u"Zyklop",
    ]
