/*
 * Decompiled with CFR 0.152.
 */
package fastminer.algo.closed;

class BitVector {
    static long[] TWO_POWER = new long[64];
    long[] bits;
    public int cardinality;

    public BitVector(int[] itemset, int last) {
        int length = itemset[0];
        this.bits = new long[length / 64 + 1];
        this.cardinality = last;
        for (int i = 0; i < last; ++i) {
            int item = itemset[i];
            int n = item / 64;
            this.bits[n] = this.bits[n] | TWO_POWER[item % 64];
        }
    }

    public boolean isSubSet(BitVector q) {
        if (this.cardinality >= q.cardinality) {
            return false;
        }
        for (int i = 0; i < this.bits.length; ++i) {
            if ((this.bits[i] & (q.bits[i] ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) continue;
            return false;
        }
        return true;
    }

    static {
        for (int i = 0; i < TWO_POWER.length; ++i) {
            BitVector.TWO_POWER[i] = (long)Math.pow(2.0, i);
        }
    }
}

