/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.graph_mining.aerminer.AlgoAERMiner;
import java.io.File;
import java.io.IOException;

public class DescriptionAlgoAERMiner
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "AERMiner";
    }

    @Override
    public String getAlgorithmCategory() {
        return "GRAPH PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/AERMiner.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException, ClassNotFoundException {
        String inputDirectory = String.valueOf(DescriptionAlgoAERMiner.getParamAsString(parameters[0])) + File.separator;
        double minsup = DescriptionAlgoAERMiner.getParamAsDouble(parameters[1]);
        double minconf = DescriptionAlgoAERMiner.getParamAsDouble(parameters[2]);
        double minlift = DescriptionAlgoAERMiner.getParamAsDouble(parameters[3]);
        AlgoAERMiner algo = new AlgoAERMiner();
        algo.runAlgorithm(inputDirectory, outputFile, minsup, minconf, minlift);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Input directory", "(e.g. DBLP)", String.class, false), new DescriptionOfParameter("Minsup", "(e.g. 0.02)", Double.class, false), new DescriptionOfParameter("Minconf", "(e.g. 0.01)", Double.class, false), new DescriptionOfParameter("Minlift", "(e.g. 0.4)", Double.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Ganghuan He and Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Dynamic Attributed Graph"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Trend patterns", "Attribute Evolution Rules"};
    }
}

