/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.apriori_HT.AlgoAprioriHT;
import java.io.IOException;

public class DescriptionAlgoAprioriHT
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "Apriori_with_hash_tree";
    }

    @Override
    public String getAlgorithmCategory() {
        return "FREQUENT ITEMSET MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/Apriori.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        double minsup = DescriptionAlgoAprioriHT.getParamAsDouble(parameters[0]);
        int branch_count = DescriptionAlgoAprioriHT.getParamAsInteger(parameters[1]);
        AlgoAprioriHT algorithm = new AlgoAprioriHT();
        if (parameters.length >= 3 && !"".equals(parameters[2])) {
            algorithm.setMaximumPatternLength(DescriptionAlgoAprioriHT.getParamAsInteger(parameters[2]));
        }
        algorithm.runAlgorithm(minsup, inputFile, outputFile, branch_count);
        algorithm.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.4 or 40%)", Double.class, false), new DescriptionOfParameter("Hash-tree branch count", "(e.g. 30 branch)", Integer.class, false), new DescriptionOfParameter("Max pattern length", "(e.g. 2 items)", Integer.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Frequent patterns", "Frequent itemsets"};
    }
}

