/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.clhminer.AlgoCLHMiner;
import java.io.File;
import java.io.IOException;

public class DescriptionAlgoCLHMiner
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "CLHMiner";
    }

    @Override
    public String getAlgorithmCategory() {
        return "HIGH-UTILITY PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/CLHMiner_cross.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int minutil = DescriptionAlgoCLHMiner.getParamAsInteger(parameters[0]);
        String taxonomyFilename = parameters[1];
        File file = new File(inputFile);
        String taxonomyPath = file.getParent() == null ? taxonomyFilename : String.valueOf(file.getParent()) + File.separator + taxonomyFilename;
        AlgoCLHMiner algo = new AlgoCLHMiner();
        algo.runAlgorithm(minutil, inputFile, outputFile, taxonomyPath);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("minutil", "(e.g. 60)", Integer.class, false), new DescriptionOfParameter("taxonomy file", "(e.g. taxonomy_CLHMiner.txt)", String.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Bay Vo et al.";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with utility values", "Transaction database with taxonomy"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "High-utility patterns", "High-utility itemsets", "Cross-Level High-utility itemsets"};
    }
}

