/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequentialpatterns.spam.AlgoCMSPAM;
import java.io.IOException;

public class DescriptionAlgoCMSPAM
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "CM-SPAM";
    }

    @Override
    public String getAlgorithmCategory() {
        return "SEQUENTIAL PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/CM-SPAM.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        AlgoCMSPAM algo = new AlgoCMSPAM();
        if (parameters.length >= 2 && !"".equals(parameters[1])) {
            algo.setMinimumPatternLength(DescriptionAlgoCMSPAM.getParamAsInteger(parameters[1]));
        }
        if (parameters.length >= 3 && !"".equals(parameters[2])) {
            algo.setMaximumPatternLength(DescriptionAlgoCMSPAM.getParamAsInteger(parameters[2]));
        }
        if (parameters.length >= 4 && parameters[3] != null && !parameters[3].isEmpty()) {
            String[] itemsString = parameters[3].split(",");
            int[] requiredItems = new int[itemsString.length];
            int i = 0;
            while (i < itemsString.length) {
                requiredItems[i] = Integer.parseInt(itemsString[i]);
                ++i;
            }
            algo.setMustAppearItems(requiredItems);
        }
        if (parameters.length >= 5 && !"".equals(parameters[4])) {
            algo.setMaxGap(DescriptionAlgoCMSPAM.getParamAsInteger(parameters[4]));
        }
        boolean outputSeqIdentifiers = false;
        if (parameters.length >= 6 && !"".equals(parameters[5])) {
            outputSeqIdentifiers = DescriptionAlgoCMSPAM.getParamAsBoolean(parameters[5]);
        }
        algo.runAlgorithm(inputFile, outputFile, DescriptionAlgoCMSPAM.getParamAsDouble(parameters[0]), outputSeqIdentifiers);
        algo.printStatistics();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.5 or 50%)", Double.class, false), new DescriptionOfParameter("Min pattern length", "(e.g. 1 items)", Integer.class, true), new DescriptionOfParameter("Max pattern length", "(e.g. 10 items)", Integer.class, true), new DescriptionOfParameter("Required items", "(e.g. 1,2,3)", String.class, true), new DescriptionOfParameter("Max gap", "(e.g. 1 item)", Integer.class, true), new DescriptionOfParameter("Show sequence ids?", "(default: false)", Boolean.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Antonio Gomariz Penalver & Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Simple sequence database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Sequential patterns", "Frequent sequential patterns"};
    }
}

