/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.clustering.dbscan.AlgoDBSCAN;
import java.io.IOException;

public class DescriptionAlgoDBScan
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "DBScan";
    }

    @Override
    public String getAlgorithmCategory() {
        return "CLUSTERING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/DBScan.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int minPts = DescriptionAlgoDBScan.getParamAsInteger(parameters[0]);
        double epsilon = DescriptionAlgoDBScan.getParamAsDouble(parameters[1]);
        String separator = parameters.length > 2 && !"".equals(parameters[2]) ? DescriptionAlgoDBScan.getParamAsString(parameters[2]) : " ";
        AlgoDBSCAN algo = new AlgoDBSCAN();
        algo.runAlgorithm(inputFile, minPts, epsilon, separator);
        algo.printStatistics();
        algo.saveToFile(outputFile);
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("minPts", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("epsilon", "(e.g. 2)", Double.class, false), new DescriptionOfParameter("separator", "(default: ' ')", String.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Database of double vectors"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Clusters", "Density-based clusters"};
    }
}

