/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.dci_closed_optimized.AlgoDCI_Closed_Optimized;
import java.io.IOException;

public class DescriptionAlgoDCIClosed
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "DCI_Closed";
    }

    @Override
    public String getAlgorithmCategory() {
        return "FREQUENT ITEMSET MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/DCI_Closed.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int minsup = DescriptionAlgoDCIClosed.getParamAsInteger(parameters[0]);
        AlgoDCI_Closed_Optimized algorithm = new AlgoDCI_Closed_Optimized();
        if (parameters.length >= 2 && !"".equals(parameters[1])) {
            algorithm.setShowTransactionIdentifiers(DescriptionAlgoDCIClosed.getParamAsBoolean(parameters[1]));
        }
        algorithm.runAlgorithm(inputFile, outputFile, minsup);
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 2 transactions)", Integer.class, false), new DescriptionOfParameter("Show transaction ids?", "(default: false)", Boolean.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Frequent patterns", "Frequent closed itemsets"};
    }
}

