/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.fhmds.ds.AlgoFHM_DS;
import java.io.IOException;

public class DescriptionAlgoFHMDS
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "FHMDS";
    }

    @Override
    public String getAlgorithmCategory() {
        return "HIGH-UTILITY PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/FHMDS.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int k = DescriptionAlgoFHMDS.getParamAsInteger(parameters[0]);
        int win_size = DescriptionAlgoFHMDS.getParamAsInteger(parameters[1]);
        int number_of_transactions_batch = DescriptionAlgoFHMDS.getParamAsInteger(parameters[2]);
        AlgoFHM_DS algorithm = new AlgoFHM_DS();
        algorithm.runAlgorithm(inputFile, k, win_size, number_of_transactions_batch, outputFile);
        algorithm.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("k", "(e.g. 5)", Integer.class, false), new DescriptionOfParameter("Window size", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("Transactions / batch", "(e.g. 2)", Integer.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Siddhart Dawar et al.";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with utility values"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "High-utility patterns", "High-utility itemsets", "Top-k High-utility itemsets"};
    }
}

